/*
 * Decompiled with CFR 0.152.
 */
package com.tydic.fsc.bill.ability.impl;

import com.tydic.fsc.bill.ability.api.FscFinanceWriteOffApprovalService;
import com.tydic.fsc.bill.ability.bo.FscFinanceWriteOffApprovalServiceReqBo;
import com.tydic.fsc.bill.ability.bo.FscFinanceWriteOffApprovalServiceRspBo;
import com.tydic.fsc.bill.busi.api.FscFinanceWriteOffApprovalBusiService;
import com.tydic.fsc.common.ability.api.FscEsSyncComOrderListAbilityService;
import com.tydic.fsc.common.ability.bo.FscEsSyncComOrderListReqBO;
import com.tydic.fsc.constants.FscConstants;
import com.tydic.fsc.dao.FscFinanceWriteOffAdjustMapper;
import com.tydic.fsc.dao.FscOrderMapper;
import com.tydic.fsc.exception.FscBusinessException;
import com.tydic.fsc.po.FscFinanceWriteOffAdjustPO;
import java.util.Collection;
import org.springframework.beans.factory.annotation.Autowired;
import org.springframework.util.CollectionUtils;
import org.springframework.web.bind.annotation.PostMapping;
import org.springframework.web.bind.annotation.RequestBody;
import org.springframework.web.bind.annotation.RequestMapping;
import org.springframework.web.bind.annotation.RestController;

@RestController
@RequestMapping(value={"FSC_GROUP_DEV/1.0.0/com.tydic.fsc.bill.ability.api.FscFinanceWriteOffApprovalService"})
public class FscFinanceWriteOffApprovalServiceImpl
implements FscFinanceWriteOffApprovalService {
    @Autowired
    private FscEsSyncComOrderListAbilityService fscEsSyncComOrderListAbilityService;
    @Autowired
    private FscOrderMapper fscOrderMapper;
    @Autowired
    private FscFinanceWriteOffApprovalBusiService fscFinanceWriteOffApprovalBusiService;
    @Autowired
    private FscFinanceWriteOffAdjustMapper fscFinanceWriteOffAdjustMapper;

    @PostMapping(value={"dealFinanceWriteOffApproval"})
    public FscFinanceWriteOffApprovalServiceRspBo dealFinanceWriteOffApproval(@RequestBody FscFinanceWriteOffApprovalServiceReqBo reqBo) {
        if (CollectionUtils.isEmpty((Collection)reqBo.getStationsList())) {
            throw new FscBusinessException("190000", "\u5f53\u524d\u8d26\u53f7\u65e0\u4e0b\u4e00\u6b65\u5ba1\u6279\u6743\u9650");
        }
        if (CollectionUtils.isEmpty((Collection)reqBo.getAdjustIdList())) {
            throw new FscBusinessException("190000", "\u5fc5\u4f20\u53c2\u6570adjustIdList\u4e0d\u80fd\u4e3a\u7a7a");
        }
        for (Long adjustId : reqBo.getAdjustIdList()) {
            reqBo.setAdjustId(adjustId);
            this.dealApproval(reqBo);
        }
        FscFinanceWriteOffApprovalServiceRspBo rspBo = new FscFinanceWriteOffApprovalServiceRspBo();
        rspBo.setRespCode("0000");
        rspBo.setRespDesc("\u6210\u529f");
        return rspBo;
    }

    private void dealApproval(FscFinanceWriteOffApprovalServiceReqBo reqBo) {
        FscFinanceWriteOffAdjustPO adjustPO = new FscFinanceWriteOffAdjustPO();
        adjustPO.setAdjustId(reqBo.getAdjustId());
        adjustPO = this.fscFinanceWriteOffAdjustMapper.getModelBy(adjustPO);
        if (null == adjustPO) {
            throw new FscBusinessException("191019", "\u8865\u5f55\u4e3b\u5355\u4e0d\u5b58\u5728");
        }
        reqBo.setFscOrderId(adjustPO.getFscOrderId());
        reqBo.setWriteOffAmt(adjustPO.getWriteOffAmt());
        Integer count = this.fscOrderMapper.getOrderAuditCount(adjustPO.getFscOrderId(), reqBo.getStationsList());
        if (count == 0 || CollectionUtils.isEmpty((Collection)reqBo.getStationsList())) {
            throw new FscBusinessException("191124", "\u60a8\u6ca1\u6709\u8be5\u7533\u8bf7\u5355\u7684\u5ba1\u6279\u6743\u9650,\u8bf7\u5237\u65b0\u4e0b\u9875\u9762\uff01");
        }
        if (!FscConstants.WriteOffBillStatus.TO_AUDIT.equals(adjustPO.getBillStatus())) {
            throw new FscBusinessException("191019", "\u5f53\u524d\u72b6\u6001[" + adjustPO.getBillStatus() + "]\u4e0d\u5141\u8bb8\u5ba1\u6279");
        }
        this.fscFinanceWriteOffApprovalBusiService.dealFinanceWriteOffApproval(reqBo);
        FscEsSyncComOrderListReqBO syncReqBO = new FscEsSyncComOrderListReqBO();
        syncReqBO.setFscOrderId(adjustPO.getFscOrderId());
        this.fscEsSyncComOrderListAbilityService.dealOrderToEs(syncReqBO);
    }
}

