/*
 * Decompiled with CFR 0.152.
 */
package com.tydic.fsc.bill.ability.impl;

import com.alibaba.fastjson.JSON;
import com.alibaba.fastjson.JSONArray;
import com.ohaotian.plugin.db.Page;
import com.ohaotian.plugin.db.Sequence;
import com.tydic.fsc.bill.ability.api.FscWxReconciliationAbilityService;
import com.tydic.fsc.bill.ability.bo.FscWxReconciliationBO;
import com.tydic.fsc.bill.ability.bo.FscWxReconciliationOrderBO;
import com.tydic.fsc.bill.ability.bo.FscWxReconciliationReqBO;
import com.tydic.fsc.bill.ability.bo.FscWxReconciliationRspBO;
import com.tydic.fsc.bill.busi.api.FscWxReconciliationBusiService;
import com.tydic.fsc.busibase.busi.bo.FscWxReconciliationImportBO;
import com.tydic.fsc.dao.FscWxReconciliationImportMapper;
import com.tydic.fsc.dao.FscWxReconciliationMapper;
import com.tydic.fsc.dao.FscWxReconciliationOrderMapper;
import com.tydic.fsc.exception.FscBusinessException;
import com.tydic.fsc.po.FscWxReconciliationOrderPO;
import com.tydic.fsc.po.FscWxReconciliationPO;
import com.tydic.fsc.util.BatchImportUtils;
import com.tydic.fsc.utils.ExportExcel;
import com.tydic.fsc.utils.UploadUtil;
import com.tydic.plugin.encoded.service.CfcEncodedSerialGetService;
import com.tydic.plugin.encoded.service.bo.CfcEncodedSerialGetServiceReqBO;
import com.tydic.plugin.encoded.service.bo.CfcEncodedSerialGetServiceRspBO;
import com.tydic.uoc.common.ability.api.UocWxReconciliationAbilityService;
import com.tydic.uoc.common.ability.bo.UocWxReconciliationReqBO;
import com.tydic.uoc.common.ability.bo.UocWxReconciliationRspBO;
import java.math.BigDecimal;
import java.math.RoundingMode;
import java.util.ArrayList;
import java.util.Collection;
import java.util.Date;
import java.util.HashMap;
import java.util.List;
import java.util.Map;
import java.util.Set;
import java.util.stream.Collectors;
import org.apache.poi.ss.usermodel.Workbook;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;
import org.springframework.beans.BeanUtils;
import org.springframework.beans.factory.annotation.Autowired;
import org.springframework.util.CollectionUtils;
import org.springframework.web.bind.annotation.PostMapping;
import org.springframework.web.bind.annotation.RequestBody;
import org.springframework.web.bind.annotation.RequestMapping;
import org.springframework.web.bind.annotation.RestController;

@RestController
@RequestMapping(value={"FSC_GROUP_DEV/1.0.0/com.tydic.fsc.bill.ability.api.FscWxReconciliationAbilityService"})
public class FscWxReconciliationAbilityServiceImpl
implements FscWxReconciliationAbilityService {
    private static final Logger log = LoggerFactory.getLogger(FscWxReconciliationAbilityServiceImpl.class);
    @Autowired
    private FscWxReconciliationBusiService fscWxReconciliationBusiService;
    @Autowired
    private FscWxReconciliationMapper fscWxReconciliationMapper;
    @Autowired
    private FscWxReconciliationImportMapper fscWxReconciliationImportMapper;
    @Autowired
    private UocWxReconciliationAbilityService uocWxReconciliationAbilityService;
    @Autowired
    private FscWxReconciliationOrderMapper fscWxReconciliationOrderMapper;
    @Autowired
    private UploadUtil uploadUtil;
    @Autowired
    private CfcEncodedSerialGetService encodedSerialGetService;

    @PostMapping(value={"dealCreate"})
    public FscWxReconciliationRspBO dealCreate(@RequestBody FscWxReconciliationReqBO reqBO) {
        List importDataMap;
        FscWxReconciliationRspBO rspBO = new FscWxReconciliationRspBO();
        ArrayList<String> title = new ArrayList<String>();
        title.add("\u4ea4\u6613\u65f6\u95f4");
        title.add("\u516c\u4f17\u8d26\u53f7ID");
        title.add("\u5546\u6237\u53f7");
        title.add("\u7279\u7ea6\u5546\u6237\u53f7");
        title.add("\u8bbe\u5907\u53f7");
        title.add("\u5fae\u4fe1\u8ba2\u5355\u53f7");
        title.add("\u5546\u6237\u8ba2\u5355\u53f7");
        title.add("\u7528\u6237\u6807\u8bc6");
        title.add("\u4ea4\u6613\u7c7b\u578b");
        title.add("\u4ea4\u6613\u72b6\u6001");
        title.add("\u4ed8\u6b3e\u94f6\u884c");
        title.add("\u8d27\u5e01\u79cd\u7c7b");
        title.add("\u5e94\u7ed3\u8ba2\u5355\u91d1\u989d");
        title.add("\u4ee3\u91d1\u5238\u91d1\u989d");
        title.add("\u5fae\u4fe1\u9000\u6b3e\u5355\u53f7");
        title.add("\u5546\u6237\u9000\u6b3e\u5355\u53f7");
        title.add("\u9000\u6b3e\u91d1\u989d");
        title.add("\u5145\u503c\u5238\u9000\u6b3e\u91d1\u989d");
        title.add("\u9000\u6b3e\u7c7b\u578b");
        title.add("\u9000\u6b3e\u72b6\u6001");
        title.add("\u5546\u54c1\u540d\u79f0");
        title.add("\u5546\u6237\u6570\u636e\u5305");
        title.add("\u624b\u7eed\u8d39");
        title.add("\u8d39\u7387");
        title.add("\u8ba2\u5355\u91d1\u989d");
        title.add("\u7533\u8bf7\u9000\u6b3e\u91d1\u989d");
        title.add("\u8d39\u7387\u5907\u6ce8");
        ArrayList data = new ArrayList();
        try {
            BatchImportUtils batchImportUtils = new BatchImportUtils(title, data, FscWxReconciliationBO.class);
            batchImportUtils.batchImport(reqBO.getFileUrl(), 0, 1, -1, "`");
            importDataMap = batchImportUtils.getImportDataMaps();
        }
        catch (Exception e) {
            log.error("\u5bfc\u5165\u89e3\u6790\u6587\u4ef6\u6570\u636e\u5931\u8d25:" + e);
            rspBO.setRespCode("8888");
            rspBO.setRespDesc(e.toString());
            return rspBO;
        }
        if (CollectionUtils.isEmpty((Collection)importDataMap)) {
            rspBO.setRespCode("8888");
            rspBO.setRespDesc("\u5bfc\u5165\u5185\u5bb9\u4e3a\u7a7a");
            return rspBO;
        }
        List list = JSONArray.parseArray((String)JSON.toJSONString((Object)importDataMap), FscWxReconciliationBO.class);
        FscWxReconciliationOrderBO fscWxReconciliationOrderBO = new FscWxReconciliationOrderBO();
        fscWxReconciliationOrderBO.setId(Long.valueOf(Sequence.getInstance().nextId()));
        CfcEncodedSerialGetServiceReqBO encodedSerialGetServiceReqBO = new CfcEncodedSerialGetServiceReqBO();
        encodedSerialGetServiceReqBO.setCenter("FSC");
        encodedSerialGetServiceReqBO.setEncodedRuleCode("WX_RECONCILIATION_no");
        encodedSerialGetServiceReqBO.setNum(Integer.valueOf(1));
        encodedSerialGetServiceReqBO.setOrgType("-1");
        CfcEncodedSerialGetServiceRspBO encodedSerialGetServiceRspBO = this.encodedSerialGetService.getEncodedSerial(encodedSerialGetServiceReqBO);
        fscWxReconciliationOrderBO.setReconciliationCode((String)encodedSerialGetServiceRspBO.getSerialNoList().get(0));
        fscWxReconciliationOrderBO.setCreateName(reqBO.getName());
        fscWxReconciliationOrderBO.setCreateTime(new Date());
        fscWxReconciliationOrderBO.setCreateUserId(reqBO.getUserId());
        fscWxReconciliationOrderBO.setCreateUserName(reqBO.getUserName());
        fscWxReconciliationOrderBO.setIsDel(Integer.valueOf(0));
        HashMap<String, FscWxReconciliationBO> map = new HashMap<String, FscWxReconciliationBO>();
        for (FscWxReconciliationBO reconciliationBO : list) {
            reconciliationBO.setExt1(reconciliationBO.getWechatOrderNumber() + reconciliationBO.getWechatRefundOrderNumber());
            reconciliationBO.setId(Long.valueOf(Sequence.getInstance().nextId()));
            reconciliationBO.setCreateTime(new Date());
            reconciliationBO.setCreateUserId(reqBO.getUserId());
            reconciliationBO.setCreateUserName(reqBO.getName());
            reconciliationBO.setExt3(fscWxReconciliationOrderBO.getId().toString());
            if (map.get(reconciliationBO.getWechatOrderNumber()) == null) {
                FscWxReconciliationBO news = new FscWxReconciliationBO();
                BeanUtils.copyProperties((Object)reconciliationBO, (Object)news);
                map.put(reconciliationBO.getWechatOrderNumber(), news);
                continue;
            }
            FscWxReconciliationBO old = (FscWxReconciliationBO)map.get(reconciliationBO.getWechatOrderNumber());
            if (reconciliationBO.getTransactionHour().before(old.getTransactionHour())) {
                old.setTransactionHour(reconciliationBO.getTransactionHour());
            }
            old.setAmountOfOrdersDue(old.getAmountOfOrdersDue().add(reconciliationBO.getAmountOfOrdersDue()));
            old.setOrderAmount(old.getOrderAmount().add(reconciliationBO.getOrderAmount()));
            old.setRefundAmount(old.getRefundAmount().add(reconciliationBO.getRefundAmount()));
            old.setRequestRefundAmount(old.getRequestRefundAmount().add(reconciliationBO.getRequestRefundAmount()));
            old.setHandlingFee(old.getHandlingFee().add(reconciliationBO.getHandlingFee()));
            map.put(reconciliationBO.getWechatOrderNumber(), old);
        }
        Set wxOrders = map.keySet();
        FscWxReconciliationPO fscWxReconciliationPO = new FscWxReconciliationPO();
        fscWxReconciliationPO.setWxOrders(wxOrders);
        List shouldPayPOS = this.fscWxReconciliationMapper.getShouldPayId(fscWxReconciliationPO);
        if (CollectionUtils.isEmpty((Collection)shouldPayPOS)) {
            rspBO.setRespCode("8888");
            rspBO.setRespDesc("\u5bfc\u5165\u6570\u636e\u6ca1\u6709\u67e5\u8be2\u5230\u4efb\u4f55\u4e00\u4e2a\u652f\u4ed8\u5355");
            return rspBO;
        }
        UocWxReconciliationReqBO lic = new UocWxReconciliationReqBO();
        lic.setShouldPayIds(shouldPayPOS.stream().map(FscWxReconciliationPO::getShouldPayId).collect(Collectors.toList()));
        UocWxReconciliationRspBO uoc = this.uocWxReconciliationAbilityService.qryOrder(lic);
        if (!"0000".equals(uoc.getRespCode())) {
            throw new FscBusinessException("198888", "\u67e5\u8be2\u8ba2\u5355\u4fe1\u606f\u5931\u8d25\uff1a" + uoc.getRespDesc());
        }
        if (CollectionUtils.isEmpty((Collection)uoc.getOrderInfo())) {
            throw new FscBusinessException("198888", "\u5bfc\u5165\u6570\u636e\u6ca1\u6709\u67e5\u8be2\u5230\u4efb\u4f55\u4e00\u4e2a\u8ba2\u5355");
        }
        Map<Long, List<UocWxReconciliationRspBO>> order = uoc.getOrderInfo().stream().collect(Collectors.groupingBy(UocWxReconciliationRspBO::getShouldPayId));
        Map<String, List<FscWxReconciliationPO>> payMap = shouldPayPOS.stream().collect(Collectors.groupingBy(FscWxReconciliationPO::getWechatOrderNumber));
        ArrayList<FscWxReconciliationBO> insert = new ArrayList<FscWxReconciliationBO>();
        int count = 0;
        for (String key : map.keySet()) {
            FscWxReconciliationBO bo = (FscWxReconciliationBO)map.get(key);
            List<FscWxReconciliationPO> payList = payMap.get(key);
            if (CollectionUtils.isEmpty(payList)) {
                FscWxReconciliationBO liationPO = new FscWxReconciliationBO();
                BeanUtils.copyProperties((Object)bo, (Object)liationPO);
                liationPO.setReconciliationStatus(Integer.valueOf(0));
                ++count;
                insert.add(liationPO);
                continue;
            }
            for (FscWxReconciliationPO pay : payList) {
                List<UocWxReconciliationRspBO> info = order.get(pay.getShouldPayId());
                if (!CollectionUtils.isEmpty(info)) {
                    for (UocWxReconciliationRspBO wx : info) {
                        FscWxReconciliationBO liationPO = new FscWxReconciliationBO();
                        BeanUtils.copyProperties((Object)bo, (Object)liationPO);
                        liationPO.setExt3(fscWxReconciliationOrderBO.getId().toString());
                        liationPO.setYgOrderId(wx.getYgOrderId());
                        liationPO.setYgOrderAmount(wx.getYgOrderAmount());
                        liationPO.setYgAmountOfOrdersDue(wx.getYgAmountOfOrdersDue());
                        liationPO.setYgRefundAmount(wx.getYgRefundAmount());
                        liationPO.setYgNoTaxFee(wx.getYgNoTaxFee());
                        liationPO.setYgNoTotalTaxFee(wx.getYgNoTotalTaxFee());
                        liationPO.setYgOrderId(wx.getYgOrderId());
                        liationPO.setYgOrderNo(wx.getYgOrderNo());
                        liationPO.setExt2(wx.getTax());
                        liationPO.setId(Long.valueOf(Sequence.getInstance().nextId()));
                        if (pay.getRefundFee() == null) {
                            pay.setRefundFee(Long.valueOf(0L));
                        }
                        int re = new BigDecimal(pay.getRefundFee() + "").divide(new BigDecimal(10000), 2, RoundingMode.HALF_UP).compareTo(bo.getRefundAmount());
                        int to = new BigDecimal(pay.getTotalFee() + "").divide(new BigDecimal(10000), 2, RoundingMode.HALF_UP).compareTo(bo.getOrderAmount());
                        if (re != 0 || to != 0) {
                            liationPO.setReconciliationStatus(Integer.valueOf(0));
                            ++count;
                        } else {
                            liationPO.setReconciliationStatus(Integer.valueOf(1));
                        }
                        insert.add(liationPO);
                    }
                    continue;
                }
                FscWxReconciliationBO liationPO = new FscWxReconciliationBO();
                BeanUtils.copyProperties((Object)bo, (Object)liationPO);
                liationPO.setReconciliationStatus(Integer.valueOf(0));
                ++count;
                insert.add(liationPO);
            }
        }
        fscWxReconciliationOrderBO.setFailCount(Integer.valueOf(count));
        reqBO.setOrder(insert);
        reqBO.setImportInfo(list);
        reqBO.setFscWxReconciliationOrderBO(fscWxReconciliationOrderBO);
        return this.fscWxReconciliationBusiService.dealCreate(reqBO);
    }

    @PostMapping(value={"qryWxReconciliation"})
    public FscWxReconciliationRspBO qryWxReconciliation(@RequestBody FscWxReconciliationReqBO reqBO) {
        FscWxReconciliationRspBO rspBO = new FscWxReconciliationRspBO();
        FscWxReconciliationPO po = new FscWxReconciliationPO();
        po.setWechatOrderNumber(reqBO.getWechatOrderNumber());
        po.setYgOrderNo(reqBO.getYgOrderNo());
        po.setReconciliationStatus(reqBO.getReconciliationStatus());
        po.setIds(reqBO.getIds());
        po.setExt3(reqBO.getExt3());
        Page page = new Page(reqBO.getPageNo().intValue(), reqBO.getPageSize().intValue());
        List list = this.fscWxReconciliationMapper.getListPage(po, page);
        rspBO.setPageNo(Integer.valueOf(page.getPageNo()));
        rspBO.setRecordsTotal(Integer.valueOf(page.getTotalCount()));
        rspBO.setTotal(Integer.valueOf(page.getTotalPages()));
        rspBO.setRespCode("0000");
        rspBO.setRespDesc("\u6210\u529f");
        if (CollectionUtils.isEmpty((Collection)list)) {
            rspBO.setRows(new ArrayList());
            return rspBO;
        }
        rspBO.setRows(JSONArray.parseArray((String)JSON.toJSONString((Object)list), FscWxReconciliationBO.class));
        return rspBO;
    }

    @PostMapping(value={"qryWxReconciliationOrder"})
    public FscWxReconciliationRspBO qryWxReconciliationOrder(@RequestBody FscWxReconciliationReqBO reqBO) {
        FscWxReconciliationRspBO rspBO = new FscWxReconciliationRspBO();
        FscWxReconciliationOrderPO po = new FscWxReconciliationOrderPO();
        BeanUtils.copyProperties((Object)reqBO, (Object)po);
        po.setIds(reqBO.getIds());
        po.setIsDel(Integer.valueOf(0));
        Page page = new Page(reqBO.getPageNo().intValue(), reqBO.getPageSize().intValue());
        List list = this.fscWxReconciliationOrderMapper.getListPage(po, page);
        rspBO.setPageNo(Integer.valueOf(page.getPageNo()));
        rspBO.setRecordsTotal(Integer.valueOf(page.getTotalCount()));
        rspBO.setTotal(Integer.valueOf(page.getTotalPages()));
        rspBO.setRespCode("0000");
        rspBO.setRespDesc("\u6210\u529f");
        if (CollectionUtils.isEmpty((Collection)list)) {
            rspBO.setRows(new ArrayList());
            return rspBO;
        }
        rspBO.setRows(JSONArray.parseArray((String)JSON.toJSONString((Object)list), FscWxReconciliationBO.class));
        return rspBO;
    }

    @PostMapping(value={"deleteWxReconciliationOrder"})
    public FscWxReconciliationRspBO deleteWxReconciliationOrder(@RequestBody FscWxReconciliationReqBO reqBO) {
        FscWxReconciliationOrderPO po = new FscWxReconciliationOrderPO();
        po.setId(reqBO.getId());
        po.setIsDel(Integer.valueOf(1));
        po.setUpdateName(reqBO.getName());
        po.setUpdateUserId(reqBO.getUserId());
        po.setUpdateUserName(reqBO.getUserName());
        po.setUpdateTime(new Date());
        int j = this.fscWxReconciliationOrderMapper.update(po);
        if (j == 0) {
            throw new FscBusinessException("198888", "\u5220\u9664\u6570\u636e\u5931\u8d25");
        }
        FscWxReconciliationRspBO rspBO = new FscWxReconciliationRspBO();
        rspBO.setRespCode("0000");
        rspBO.setRespDesc("\u6210\u529f");
        return rspBO;
    }

    @PostMapping(value={"exportWx"})
    public FscWxReconciliationRspBO exportWx(@RequestBody FscWxReconciliationReqBO reqBO) {
        FscWxReconciliationPO po = new FscWxReconciliationPO();
        BeanUtils.copyProperties((Object)reqBO, (Object)po);
        List list = this.fscWxReconciliationImportMapper.exportWx(po);
        FscWxReconciliationRspBO rspBO = new FscWxReconciliationRspBO();
        rspBO.setRespCode("0000");
        rspBO.setRespDesc("\u6210\u529f");
        Map<String, List<FscWxReconciliationImportBO>> map = list.stream().collect(Collectors.groupingBy(FscWxReconciliationImportBO::getTransactionHour));
        HashMap<String, FscWxReconciliationImportBO> hz = new HashMap<String, FscWxReconciliationImportBO>();
        for (String key : map.keySet()) {
            List<FscWxReconciliationImportBO> day = map.get(key);
            BigDecimal wxDtk = BigDecimal.ZERO;
            BigDecimal wxSkDz = BigDecimal.ZERO;
            BigDecimal yhSkDz = BigDecimal.ZERO;
            BigDecimal yhTkDz = BigDecimal.ZERO;
            for (FscWxReconciliationImportBO wx : day) {
                if ((wxDtk = wxDtk.add(new BigDecimal(wx.getRequestRefundAmount()))).compareTo(BigDecimal.ZERO) != 0) {
                    yhTkDz = wxDtk.subtract(new BigDecimal(wx.getHandlingFee()));
                } else {
                    wx.setDzje("0.00");
                }
                wxSkDz = wxSkDz.add(new BigDecimal(wx.getOrderAmount()));
                if (new BigDecimal(wx.getOrderAmount()).compareTo(BigDecimal.ZERO) == 0) continue;
                yhSkDz = yhSkDz.add(new BigDecimal(wx.getOrderAmount())).subtract(new BigDecimal(wx.getHandlingFee()));
            }
            FscWxReconciliationImportBO importBO = new FscWxReconciliationImportBO();
            importBO.setTransactionHour(key);
            importBO.setWxSkDz(wxSkDz.toPlainString());
            importBO.setWxDtk(wxDtk.toPlainString());
            importBO.setYhSkDz(yhSkDz.toPlainString());
            importBO.setYhTkDz(yhTkDz.toPlainString());
            hz.put(key, importBO);
        }
        for (FscWxReconciliationImportBO wx : list) {
            FscWxReconciliationImportBO importBO = (FscWxReconciliationImportBO)hz.get(wx.getTransactionHour());
            wx.setWxSkDz(importBO.getWxSkDz());
            wx.setWxDtk(importBO.getWxDtk());
            wx.setYhSkDz(importBO.getYhSkDz());
            wx.setYhTkDz(importBO.getYhTkDz());
            if (new BigDecimal(wx.getOrderAmount()).compareTo(BigDecimal.ZERO) != 0) {
                wx.setDzje(new BigDecimal(wx.getOrderAmount()).subtract(new BigDecimal(wx.getHandlingFee())).toPlainString());
                continue;
            }
            wx.setDzje("0.00");
        }
        String[] title = new String[]{"\u4ea4\u6613\u65e5\u671f", "\u5fae\u4fe1\u8ba2\u5355\u53f7", "\u624b\u7eed\u8d39", "\u6536\u6b3e\u91d1\u989d", "\u9000\u6b3e\u91d1\u989d", "\u94f6\u884c\u5230\u8d26\u91d1\u989d", "\u5fae\u4fe1\u5e94\u5230\u8d26\u91d1\u989d\u5408\u8ba1", "\u5fae\u4fe1\u5e94\u9000\u6b3e\u5408\u8ba1", "\u94f6\u884c\u5230\u8d26\u5408\u8ba1"};
        String[] field = new String[]{"transactionHour", "wechatOrderNumber", "handlingFee", "orderAmount", "requestRefundAmount", "dzje", "wxSkDz", "wxDtk", "yhSkDz"};
        Workbook workbook = ExportExcel.createWorkbook((String[])field, (String[])title, (String)JSON.toJSONString((Object)list));
        ExportExcel.merge((Workbook)workbook, (Integer)0, (Integer)6);
        ExportExcel.merge((Workbook)workbook, (Integer)0, (Integer)7);
        ExportExcel.merge((Workbook)workbook, (Integer)0, (Integer)8);
        ExportExcel.merge((Workbook)workbook, (Integer)0, (Integer)9);
        String path = ExportExcel.createExcel((Workbook)workbook);
        String url = this.uploadUtil.upload(path);
        rspBO.setFileUrl(url);
        return rspBO;
    }
}

