/*
 * Decompiled with CFR 0.152.
 */
package com.tydic.fsc.bill.ability.impl.finance;

import cn.hutool.core.collection.CollectionUtil;
import com.alibaba.fastjson.JSONObject;
import com.ohaotian.plugin.db.Sequence;
import com.tydic.fsc.bill.ability.api.finance.FscFinanceInvoiceFolderUpdateAbilityService;
import com.tydic.fsc.bill.ability.bo.finance.FscFinanceInvoiceFolderUpdateReqBo;
import com.tydic.fsc.bill.ability.bo.finance.FscFinanceInvoiceFolderUpdateRspBo;
import com.tydic.fsc.bill.ability.bo.finance.FscFinanceInvoiceFolderUpdateRspBoList;
import com.tydic.fsc.busibase.external.api.esb.finance.FscFinanceShareRelatedInterfacesAtomService;
import com.tydic.fsc.constants.FscConstants;
import com.tydic.fsc.dao.FscPurchasePushLogMapper;
import com.tydic.fsc.exception.FscBusinessException;
import com.tydic.fsc.po.FscPurchasePushLogPo;
import com.tydic.fsc.utils.SSLClient;
import java.util.Collection;
import java.util.Date;
import java.util.HashMap;
import java.util.List;
import org.apache.commons.lang3.StringUtils;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;
import org.springframework.beans.factory.annotation.Autowired;
import org.springframework.beans.factory.annotation.Value;
import org.springframework.web.bind.annotation.PostMapping;
import org.springframework.web.bind.annotation.RequestBody;
import org.springframework.web.bind.annotation.RequestMapping;
import org.springframework.web.bind.annotation.RestController;

@RestController
@RequestMapping(value={"FSC_GROUP_DEV/1.0.0/com.tydic.fsc.bill.ability.api.finance.FscFinanceInvoiceFolderUpdateAbilityService"})
public class FscFinanceInvoiceFolderUpdateAbilityServiceImpl
implements FscFinanceInvoiceFolderUpdateAbilityService {
    private static final Logger log = LoggerFactory.getLogger(FscFinanceInvoiceFolderUpdateAbilityServiceImpl.class);
    @Autowired
    private FscFinanceShareRelatedInterfacesAtomService fscFinanceShareRelatedInterfacesAtomService;
    @Autowired
    private FscPurchasePushLogMapper fscPurchasePushLogMapper;
    @Value(value="${finance.invoice.update.url:}")
    private String updateUrl;

    @PostMapping(value={"updateInvoiceFolderStatus"})
    public FscFinanceInvoiceFolderUpdateRspBo updateInvoiceFolderStatus(@RequestBody FscFinanceInvoiceFolderUpdateReqBo reqBo) {
        if (StringUtils.isEmpty((CharSequence)reqBo.getUseStatus())) {
            throw new FscBusinessException("191000", "\u5fc5\u4f20\u53c2\u6570[useStatus]\u4e3a\u7a7a!");
        }
        if (CollectionUtil.isEmpty((Collection)reqBo.getItemGuids())) {
            throw new FscBusinessException("191000", "\u5fc5\u4f20\u53c2\u6570[itemGuids]\u4e3a\u7a7a!");
        }
        String token = this.fscFinanceShareRelatedInterfacesAtomService.getFinanceShareToken().getToken();
        HashMap<String, String> header = new HashMap<String, String>();
        header.put("Authorization", token);
        JSONObject reqParam = new JSONObject();
        reqParam.put("itemGuids", (Object)reqBo.getItemGuids());
        reqParam.put("useStatus", (Object)reqBo.getUseStatus());
        if (StringUtils.isNotEmpty((CharSequence)reqBo.getUseBillCode())) {
            reqParam.put("useBillCode", (Object)reqBo.getUseBillCode());
        }
        if (StringUtils.isNotEmpty((CharSequence)reqBo.getUseBillTypeCode())) {
            reqParam.put("useBillTypeCode", (Object)reqBo.getUseBillTypeCode());
        }
        if (StringUtils.isNotEmpty((CharSequence)reqBo.getUseBillTypeName())) {
            reqParam.put("useBillTypeName", (Object)reqBo.getUseBillTypeName());
        }
        if (StringUtils.isNotEmpty((CharSequence)reqBo.getUseBizDomainCode())) {
            reqParam.put("useBizDomainCode", (Object)reqBo.getUseBizDomainCode());
        }
        if (StringUtils.isNotEmpty((CharSequence)reqBo.getUseBizDomainName())) {
            reqParam.put("useBizDomainName", (Object)reqBo.getUseBizDomainName());
        }
        FscPurchasePushLogPo pushLogPo = new FscPurchasePushLogPo();
        pushLogPo.setCreateTime(new Date());
        pushLogPo.setId(Long.valueOf(Sequence.getInstance().nextId()));
        pushLogPo.setType(FscConstants.FscPurchasePushType.UPLOAD_SHARE_INVOICE);
        String reqJson = reqParam.toJSONString();
        pushLogPo.setPushData(reqJson);
        log.info("\u8d22\u52a1\u5171\u4eab\u53d1\u7968\u72b6\u6001\u66f4\u65b0\u63a5\u53e3\u8bf7\u6c42param:{},\u8bf7\u6c42url:{}", (Object)reqJson, (Object)this.updateUrl);
        String resString = SSLClient.doPostWithHeadMap((String)this.updateUrl, (String)reqJson, header);
        log.info("\u8c03\u7528\u8d22\u52a1\u5171\u4eab\u7cfb\u7edf-\u53d1\u7968\u72b6\u6001\u66f4\u65b0\u63a5\u53e3-\u8fd4\u56de\u62a5\u6587:{}", (Object)resString);
        pushLogPo.setRespData(resString);
        if (StringUtils.isEmpty((CharSequence)resString)) {
            throw new FscBusinessException("198888", "\u8c03\u7528\u8d22\u52a1\u53d1\u7968\u72b6\u6001\u66f4\u65b0\u63a5\u53e3\u54cd\u5e94\u62a5\u6587\u4e3a\u7a7a\uff01");
        }
        FscFinanceInvoiceFolderUpdateRspBo updateRspBo = new FscFinanceInvoiceFolderUpdateRspBo();
        JSONObject jsonObject = JSONObject.parseObject((String)resString);
        if (!"0".equals(jsonObject.getString("code"))) {
            pushLogPo.setPushStatus(Integer.valueOf(0));
            updateRspBo.setRespCode("190000");
            updateRspBo.setRespDesc(jsonObject.getString("msg"));
        } else {
            pushLogPo.setPushStatus(Integer.valueOf(1));
            List data = JSONObject.parseArray((String)jsonObject.getJSONArray("data").toJSONString(), FscFinanceInvoiceFolderUpdateRspBoList.class);
            updateRspBo.setData(data);
            updateRspBo.setRespCode("0000");
            updateRspBo.setRespDesc("\u6210\u529f");
        }
        this.fscPurchasePushLogMapper.insert(pushLogPo);
        return updateRspBo;
    }
}

