/*
 * Decompiled with CFR 0.152.
 */
package com.tydic.fsc.bill.atom.impl;

import com.tydic.fsc.bill.atom.api.FscBillOrderRefundUpdateAlreadyRefundAtomService;
import com.tydic.fsc.bill.atom.bo.FscBillOrderRefundUpdateAlreadyRefundAtomReqBO;
import com.tydic.fsc.bill.atom.bo.FscBillOrderRefundUpdateAlreadyRefundAtomRspBO;
import com.tydic.fsc.dao.FscOrderItemMapper;
import com.tydic.fsc.dao.FscOrderRefundMapper;
import com.tydic.fsc.exception.FscBusinessException;
import com.tydic.fsc.po.FscOrderItemPO;
import com.tydic.fsc.po.FscOrderRefundPO;
import java.math.BigDecimal;
import java.util.ArrayList;
import java.util.List;
import java.util.Map;
import java.util.stream.Collectors;
import org.springframework.beans.factory.annotation.Autowired;
import org.springframework.stereotype.Service;
import org.springframework.util.CollectionUtils;

@Service
public class FscBillOrderRefundUpdateAlreadyRefundAtomServiceImpl
implements FscBillOrderRefundUpdateAlreadyRefundAtomService {
    @Autowired
    private FscOrderItemMapper fscOrderItemMapper;
    @Autowired
    private FscOrderRefundMapper fscOrderRefundMapper;

    @Override
    public FscBillOrderRefundUpdateAlreadyRefundAtomRspBO recordRefundUpdateAlreadyRefund(FscBillOrderRefundUpdateAlreadyRefundAtomReqBO reqBO) {
        if (reqBO.getRefundId() == null) {
            throw new FscBusinessException("198888", "\u5165\u53c2[refundId]\u4e0d\u80fd\u4e3a\u7a7a\uff01");
        }
        FscOrderRefundPO refundPO = new FscOrderRefundPO();
        refundPO.setRefundId(reqBO.getRefundId());
        refundPO = this.fscOrderRefundMapper.getModelBy(refundPO);
        if (refundPO == null) {
            throw new FscBusinessException("198888", "\u672a\u67e5\u8be2\u5230\u9000\u7968\u5355\u76f8\u5173\u4fe1\u606f\uff01");
        }
        Long fscOrderId = refundPO.getFscOrderId();
        if (fscOrderId == null) {
            throw new FscBusinessException("198888", "\u672a\u67e5\u8be2\u5230\u9000\u7968\u5355\u76f8\u5173\u7684\u7ed3\u7b97\u5355\u4fe1\u606f\uff01");
        }
        FscOrderItemPO searchOrderItemPO = new FscOrderItemPO();
        searchOrderItemPO.setFscOrderId(fscOrderId);
        searchOrderItemPO.setOrderBy("id");
        List fscOrderItemPOList = this.fscOrderItemMapper.getListNoPage(searchOrderItemPO);
        Map<Long, List<FscOrderItemPO>> fscOrderItemIdMap = fscOrderItemPOList.stream().filter(e -> e.getOrderItemId() != null).collect(Collectors.groupingBy(FscOrderItemPO::getOrderItemId));
        FscOrderItemPO searchRefundOrderItemPO = new FscOrderItemPO();
        searchRefundOrderItemPO.setRefundId(reqBO.getRefundId());
        List refundOrderItemPOS = this.fscOrderItemMapper.getListNoPage(searchRefundOrderItemPO);
        Map<Long, List<FscOrderItemPO>> refundOrderItemIdMap = refundOrderItemPOS.stream().filter(e -> e.getOrderItemId() != null).collect(Collectors.groupingBy(FscOrderItemPO::getOrderItemId));
        ArrayList<FscOrderItemPO> updateFscOrderItemPOS = new ArrayList<FscOrderItemPO>();
        for (Long orderItemId : refundOrderItemIdMap.keySet()) {
            if (fscOrderItemIdMap.containsKey(orderItemId)) {
                BigDecimal alreadyRefundNum = BigDecimal.ZERO;
                BigDecimal alreadyRefundAmt = BigDecimal.ZERO;
                for (FscOrderItemPO refundOrderItemPO : refundOrderItemIdMap.get(orderItemId)) {
                    alreadyRefundNum = alreadyRefundNum.add(refundOrderItemPO.getNum());
                    alreadyRefundAmt = alreadyRefundAmt.add(refundOrderItemPO.getRefundAmt());
                }
                Long id = fscOrderItemIdMap.get(orderItemId).get(0).getId();
                FscOrderItemPO updateFscOrderItemPO = new FscOrderItemPO();
                updateFscOrderItemPO.setId(id);
                updateFscOrderItemPO.setAlreadyRefundAmt(alreadyRefundAmt);
                updateFscOrderItemPO.setAlreadyRefundNum(alreadyRefundNum);
                updateFscOrderItemPOS.add(updateFscOrderItemPO);
                continue;
            }
            throw new FscBusinessException("198888", "\u9000\u7968\u5355\u660e\u7ec6\u6570\u636e\u5728\u7ed3\u7b97\u5355\u660e\u7ec6\u4e2d\u4e0d\u5b58\u5728\uff0c\u8bf7\u8054\u7cfb\u8fd0\u7ef4\uff01\u8ba2\u5355\u660e\u7ec6id\uff1a" + orderItemId);
        }
        if (!CollectionUtils.isEmpty(updateFscOrderItemPOS)) {
            int count = this.fscOrderItemMapper.updateBatchAlreadyRefund(updateFscOrderItemPOS);
            if (updateFscOrderItemPOS.size() != count) {
                throw new FscBusinessException("198888", "\u4fee\u6539\u5df2\u9000\u7968\u6570\u91cf\u8ddf\u5df2\u9000\u7968\u91d1\u989d\u6761\u6570\u5931\u8d25");
            }
        }
        FscBillOrderRefundUpdateAlreadyRefundAtomRspBO rspBO = new FscBillOrderRefundUpdateAlreadyRefundAtomRspBO();
        rspBO.setRespCode("0000");
        rspBO.setRespDesc("\u6210\u529f");
        return rspBO;
    }
}

