/*
 * Decompiled with CFR 0.152.
 */
package com.tydic.fsc.bill.busi.impl;

import com.alibaba.fastjson.JSONObject;
import com.tydic.fsc.bill.busi.api.FscBillEcomDealInvoiceMsgBusiService;
import com.tydic.fsc.bill.busi.bo.FscBillEcomDealInvoiceMsgBusiReqBO;
import com.tydic.fsc.bill.busi.bo.FscBillEcomDealInvoiceMsgBusiRspBO;
import com.tydic.fsc.bo.FscEcomMsgExternalBO;
import com.tydic.fsc.busibase.atom.api.FscOrderRejectAtomService;
import com.tydic.fsc.busibase.atom.api.FscUocOrderRelUpdateAtomService;
import com.tydic.fsc.busibase.atom.bo.FscOrderRejectAtomReqBO;
import com.tydic.fsc.busibase.atom.bo.FscOrderRejectAtomRspBO;
import com.tydic.fsc.busibase.atom.bo.FscUocOrderRelUpdateAtomReqBO;
import com.tydic.fsc.busibase.external.api.bo.FscNoticeEcomDelMsgExternalReqBO;
import com.tydic.fsc.busibase.external.api.bo.FscNoticeEcomDelMsgExternalRspBO;
import com.tydic.fsc.busibase.external.api.esb.FscNoticeEcomDelMsgExternalService;
import com.tydic.fsc.constants.FscConstants;
import com.tydic.fsc.dao.FscEcomInfoMapper;
import com.tydic.fsc.dao.FscOrderMapper;
import com.tydic.fsc.exception.FscBusinessException;
import com.tydic.fsc.po.FscEcomInfoPO;
import com.tydic.fsc.po.FscOrderPO;
import java.util.ArrayList;
import java.util.Date;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;
import org.springframework.beans.factory.annotation.Autowired;
import org.springframework.stereotype.Service;
import org.springframework.util.CollectionUtils;
import org.springframework.util.StringUtils;

@Service
public class FscBillEcomDealInvoiceMsgBusiServiceImpl
implements FscBillEcomDealInvoiceMsgBusiService {
    private static final Logger log = LoggerFactory.getLogger(FscBillEcomDealInvoiceMsgBusiServiceImpl.class);
    @Autowired
    private FscOrderMapper fscOrderMapper;
    @Autowired
    private FscUocOrderRelUpdateAtomService fscUocOrderRelUpdateAtomService;
    @Autowired
    private FscNoticeEcomDelMsgExternalService fscNoticeEcomDelMsgExternalService;
    @Autowired
    private FscOrderRejectAtomService fscOrderRejectAtomService;
    @Autowired
    private FscEcomInfoMapper fscEcomInfoMapper;

    @Override
    public FscBillEcomDealInvoiceMsgBusiRspBO dealEcomInvoiceMsg(FscBillEcomDealInvoiceMsgBusiReqBO reqBO) {
        this.valid(reqBO);
        FscBillEcomDealInvoiceMsgBusiRspBO rspBO = new FscBillEcomDealInvoiceMsgBusiRspBO();
        ArrayList<Long> fscOrderIds = new ArrayList<Long>();
        for (FscEcomMsgExternalBO fscEcomMsgExternalBO : reqBO.getResult()) {
            FscOrderPO fscOrderPO = new FscOrderPO();
            fscOrderPO.setFscOrderId(Long.valueOf(fscEcomMsgExternalBO.getMarkId()));
            if ((fscOrderPO = this.fscOrderMapper.getModelBy(fscOrderPO)) == null) continue;
            if (fscEcomMsgExternalBO.getState().equals("2") && (fscOrderPO.getOrderState().equals(FscConstants.FscInvoiceOrderState.BILLING) || fscOrderPO.getOrderState().equals(FscConstants.FscInvoiceOrderState.SUBMITTING))) {
                this.syncOrderStatus(fscOrderPO.getFscOrderId());
                FscOrderRejectAtomReqBO atomReqBO = new FscOrderRejectAtomReqBO();
                atomReqBO.setFscOrderId(fscOrderPO.getFscOrderId());
                atomReqBO.setOrderState(fscOrderPO.getOrderState());
                FscOrderRejectAtomRspBO atomRspBO = this.fscOrderRejectAtomService.dealOrderReject(atomReqBO);
                if (!atomRspBO.getRespCode().equals("0000")) {
                    log.error("\u4e3b\u5355\u6d41\u8f6c\u72b6\u6001\u5931\u8d25\uff01" + atomRspBO.getRespDesc());
                }
                fscOrderIds.add(fscOrderPO.getFscOrderId());
            }
            this.saveEcomLog(reqBO, fscEcomMsgExternalBO, 1);
        }
        FscNoticeEcomDelMsgExternalReqBO externalReqBO = new FscNoticeEcomDelMsgExternalReqBO();
        externalReqBO.setId(reqBO.getId());
        externalReqBO.setSupplierId(reqBO.getSupplierId());
        FscNoticeEcomDelMsgExternalRspBO externalRspBO = this.fscNoticeEcomDelMsgExternalService.delEcomDelMsg(externalReqBO);
        if (!externalRspBO.getSuccess().booleanValue()) {
            throw new FscBusinessException(externalRspBO.getRespCode(), externalRspBO.getRespDesc());
        }
        rspBO.setFscOrderIds(fscOrderIds);
        rspBO.setRespCode("0000");
        rspBO.setRespDesc("\u6210\u529f");
        return rspBO;
    }

    private void saveEcomLog(FscBillEcomDealInvoiceMsgBusiReqBO reqBO, FscEcomMsgExternalBO fscEcomMsgExternalBO, Integer dealStatus) {
        FscEcomInfoPO fscEcomInfoPO = new FscEcomInfoPO();
        fscEcomInfoPO.setMarkId(fscEcomMsgExternalBO.getMarkId());
        fscEcomInfoPO.setState(fscEcomMsgExternalBO.getState());
        fscEcomInfoPO.setType(reqBO.getType());
        fscEcomInfoPO.setObjId(reqBO.getId());
        fscEcomInfoPO.setCreateTime(new Date());
        fscEcomInfoPO.setObjData(JSONObject.toJSONString((Object)reqBO));
        fscEcomInfoPO.setDealStatus(dealStatus);
        this.fscEcomInfoMapper.insert(fscEcomInfoPO);
    }

    private void syncOrderStatus(Long fscOrderId) {
        FscUocOrderRelUpdateAtomReqBO fscUocOrderRelUpdateAtomReqBO = new FscUocOrderRelUpdateAtomReqBO();
        fscUocOrderRelUpdateAtomReqBO.setFscOrderId(fscOrderId);
        fscUocOrderRelUpdateAtomReqBO.setRelState(FscConstants.FscRelStatus.UNCOMMITTED);
        fscUocOrderRelUpdateAtomReqBO.setOperType(FscConstants.FscRelUpdateAtomOperType.FSC_ORDER);
        this.fscUocOrderRelUpdateAtomService.dealRelUpdate(fscUocOrderRelUpdateAtomReqBO);
    }

    private void valid(FscBillEcomDealInvoiceMsgBusiReqBO reqBO) {
        if (StringUtils.isEmpty((Object)reqBO.getId())) {
            throw new FscBusinessException("190000", "\u5165\u53c2[id]\u4e0d\u80fd\u4e3a\u7a7a\uff01");
        }
        if (StringUtils.isEmpty((Object)reqBO.getSupplierId())) {
            throw new FscBusinessException("190000", "\u5165\u53c2[supplierId]\u4e0d\u80fd\u4e3a\u7a7a\uff01");
        }
        if (StringUtils.isEmpty((Object)reqBO.getType())) {
            throw new FscBusinessException("190000", "\u5165\u53c2[type]\u4e0d\u80fd\u4e3a\u7a7a\uff01");
        }
        if (CollectionUtils.isEmpty(reqBO.getResult())) {
            throw new FscBusinessException("190000", "\u5165\u53c2[result]\u4e0d\u80fd\u4e3a\u7a7a\uff01");
        }
    }
}

