/*
 * Decompiled with CFR 0.152.
 */
package com.tydic.fsc.bill.busi.impl;

import com.alibaba.fastjson.JSON;
import com.ohaotian.plugin.base.exception.ZTBusinessException;
import com.ohaotian.plugin.db.Sequence;
import com.tydic.authority.busi.api.DycStationOrgSelectUserNameService;
import com.tydic.authority.busi.bo.DycStationOrgSelectUserNameReqBO;
import com.tydic.authority.busi.bo.DycStationOrgSelectUserNameRspBO;
import com.tydic.authority.busi.bo.UserBO;
import com.tydic.fsc.bill.ability.bo.FscBillOrderRefundCreateInvoiceBO;
import com.tydic.fsc.bill.ability.bo.FscBillOrderRefundQualityBO;
import com.tydic.fsc.bill.atom.api.FscBillOrderRefundChangeNewAtomService;
import com.tydic.fsc.bill.atom.api.FscBillOrderRefundPayAtomService;
import com.tydic.fsc.bill.atom.bo.FscBillOrderRefundChangeAtomReqBO;
import com.tydic.fsc.bill.atom.bo.FscBillOrderRefundChangeAtomRspBO;
import com.tydic.fsc.bill.busi.api.FscBillOrderRefundCreateNewBusiService;
import com.tydic.fsc.bill.busi.bo.FscBillOrderRefundCreateBusiReqBO;
import com.tydic.fsc.bill.busi.bo.FscBillOrderRefundCreateBusiRspBO;
import com.tydic.fsc.bo.AttachmentBO;
import com.tydic.fsc.bo.FscApprovalTaskQueryBO;
import com.tydic.fsc.busibase.atom.api.FscOrderStatusStartAtomService;
import com.tydic.fsc.busibase.atom.api.FscSendNotificationExtAtomService;
import com.tydic.fsc.busibase.atom.bo.FscOrderStatusStartAtomReqBO;
import com.tydic.fsc.busibase.atom.bo.FscOrderStatusStartAtomRspBO;
import com.tydic.fsc.busibase.atom.bo.FscSendNotificationExtAtomReqBO;
import com.tydic.fsc.constants.FscConstants;
import com.tydic.fsc.constants.FscRefundFlowProcKeyEnum;
import com.tydic.fsc.dao.FscAttachmentMapper;
import com.tydic.fsc.dao.FscInvoiceItemMapper;
import com.tydic.fsc.dao.FscInvoiceMapper;
import com.tydic.fsc.dao.FscInvoiceRefundRelationMapper;
import com.tydic.fsc.dao.FscOrderItemMapper;
import com.tydic.fsc.dao.FscOrderMapper;
import com.tydic.fsc.dao.FscOrderRefundMapper;
import com.tydic.fsc.dao.FscOrderRelationMapper;
import com.tydic.fsc.dao.FscRefundInvoiceHeadMapper;
import com.tydic.fsc.dao.FscShouldPayDetailMapper;
import com.tydic.fsc.dao.FscTaskCandidateMapper;
import com.tydic.fsc.exception.FscBusinessException;
import com.tydic.fsc.pay.task.service.TaskTodoWaitService;
import com.tydic.fsc.po.FscAttachmentPO;
import com.tydic.fsc.po.FscInvoicePO;
import com.tydic.fsc.po.FscInvoiceRefundRelationPO;
import com.tydic.fsc.po.FscOrderPO;
import com.tydic.fsc.po.FscOrderRefundPO;
import com.tydic.fsc.po.FscOrderRelationPO;
import com.tydic.fsc.po.FscShouldPayDetailPO;
import com.tydic.fsc.po.FscTaskCandidatePO;
import com.tydic.fsc.util.TaxUtils;
import com.tydic.plugin.encoded.service.CfcEncodedSerialGetService;
import com.tydic.plugin.encoded.service.bo.CfcEncodedSerialGetServiceReqBO;
import com.tydic.plugin.encoded.service.bo.CfcEncodedSerialGetServiceRspBO;
import com.tydic.uac.ability.UacNoTaskAuditCreateAbilityService;
import com.tydic.uac.ability.bo.UacNoTaskAuditCreateInfoReqBO;
import com.tydic.uac.ability.bo.UacNoTaskAuditCreateReqBO;
import com.tydic.uac.ability.bo.UacNoTaskAuditCreateRspBO;
import com.tydic.uac.bo.common.ApprovalObjBO;
import com.tydic.umc.general.ability.api.UmcEnterpriseOrgNameListQryAbilityService;
import com.tydic.umc.general.ability.bo.UmcDycEnterpriseOrgBO;
import com.tydic.umc.general.ability.bo.UmcEnterpriseOrgNameListQryAbilityReqBO;
import com.tydic.umc.general.ability.bo.UmcEnterpriseOrgNameListQryAbilityRspBO;
import com.tydic.uoc.common.ability.api.PebExtUpdateAbnormalRefundFlagAbilityService;
import java.math.BigDecimal;
import java.util.ArrayList;
import java.util.Arrays;
import java.util.Collection;
import java.util.Collections;
import java.util.Date;
import java.util.HashMap;
import java.util.List;
import java.util.Map;
import java.util.Objects;
import java.util.stream.Collectors;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;
import org.springframework.beans.BeanUtils;
import org.springframework.beans.factory.annotation.Autowired;
import org.springframework.beans.factory.annotation.Value;
import org.springframework.stereotype.Service;
import org.springframework.util.CollectionUtils;

@Service
public class FscBillOrderRefundCreateNewBusiServiceImpl
implements FscBillOrderRefundCreateNewBusiService {
    private static final Logger log = LoggerFactory.getLogger(FscBillOrderRefundCreateNewBusiServiceImpl.class);
    @Autowired
    private FscOrderRefundMapper fscOrderRefundMapper;
    @Autowired
    private FscAttachmentMapper fscAttachmentMapper;
    @Autowired
    private FscInvoiceRefundRelationMapper fscInvoiceRefundRelationMapper;
    @Autowired
    private CfcEncodedSerialGetService encodedSerialGetService;
    @Autowired
    private FscOrderMapper fscOrderMapper;
    @Autowired
    private FscOrderRelationMapper fscOrderRelationMapper;
    @Autowired
    private UacNoTaskAuditCreateAbilityService uacNoTaskAuditCreateAbilityService;
    @Autowired
    private FscOrderStatusStartAtomService fscOrderStatusStartAtomService;
    @Autowired
    private FscInvoiceMapper fscInvoiceMapper;
    @Autowired
    private UmcEnterpriseOrgNameListQryAbilityService umcEnterpriseOrgNameListQryAbilityService;
    @Autowired
    private PebExtUpdateAbnormalRefundFlagAbilityService pebExtUpdateAbnormalRefundFlagAbilityService;
    @Autowired
    private FscTaskCandidateMapper fscTaskCandidateMapper;
    @Autowired
    private DycStationOrgSelectUserNameService dycStationOrgSelectUserNameService;
    @Autowired
    private FscSendNotificationExtAtomService fscSendNotificationExtAtomService;
    @Value(value="${REFUND_PERMIT_ERROR_AMT:0.05}")
    private BigDecimal permitError;
    @Value(value="${fsc.main.pro.org:100096,100100}")
    private String proOrg;
    private static final String BUSI_NAME = "\u9000\u7968\u4e3b\u5355\u521b\u5efa";
    private static final String SEPARATOR = ",";
    @Autowired
    private FscInvoiceItemMapper fscInvoiceItemMapper;
    @Autowired
    private FscOrderItemMapper fscOrderItemMapper;
    @Autowired
    private FscRefundInvoiceHeadMapper fscRefundInvoiceHeadMapper;
    @Autowired
    private FscBillOrderRefundChangeNewAtomService fscBillOrderRefundChangeNewAtomService;
    @Autowired
    private FscBillOrderRefundPayAtomService fscBillOrderRefundPayAtomService;
    @Autowired
    private TaskTodoWaitService taskTodoWaitService;
    @Autowired
    private FscShouldPayDetailMapper fscShouldPayDetailMapper;

    @Override
    public FscBillOrderRefundCreateBusiRspBO dealRefundCreateNew(FscBillOrderRefundCreateBusiReqBO reqBO) {
        int refundCount;
        if (CollectionUtils.isEmpty(reqBO.getOrderList())) {
            throw new FscBusinessException("198888", "\u9000\u7968\u5f02\u5e38\u8ba2\u5355\u4fe1\u606f\u4e0d\u80fd\u4e3a\u7a7a\uff01");
        }
        if (CollectionUtils.isEmpty(reqBO.getInvoiceList())) {
            throw new FscBusinessException("198888", "\u9000\u7968\u53d1\u7968\u4fe1\u606f\u4e0d\u80fd\u4e3a\u7a7a\uff01");
        }
        Boolean editFlag = Objects.nonNull(reqBO.getIsEdit()) && reqBO.getIsEdit() == 1;
        FscOrderRefundPO refundPO = this.buildRefundOrderInfo(reqBO);
        ArrayList<FscInvoiceRefundRelationPO> invoiceRefundList = new ArrayList<FscInvoiceRefundRelationPO>();
        ArrayList<Long> invoiceIds = new ArrayList<Long>();
        Map<Long, BigDecimal> invoiceIdRefundAmtMap = reqBO.getInvoiceBOS().stream().collect(Collectors.toMap(FscBillOrderRefundCreateInvoiceBO::getInvoiceId, FscBillOrderRefundCreateInvoiceBO::getRefundAmt));
        for (FscInvoicePO invoicePO : reqBO.getInvoiceList()) {
            FscInvoiceRefundRelationPO refundRelationPO = new FscInvoiceRefundRelationPO();
            refundRelationPO.setFscOrderId(invoicePO.getFscOrderId());
            refundRelationPO.setCreateTime(new Date());
            refundRelationPO.setInvoiceId(invoicePO.getInvoiceId());
            refundRelationPO.setId(Long.valueOf(Sequence.getInstance().nextId()));
            refundRelationPO.setRefundId(refundPO.getRefundId());
            refundRelationPO.setRefundAmt(invoiceIdRefundAmtMap.get(invoicePO.getInvoiceId()));
            if (reqBO.getOperationType().equals(FscConstants.RefundOperationType.SUBMIT)) {
                refundRelationPO.setInvoiceStatus(FscConstants.FscInvoiceStatus.TO_CONFIRM);
            } else {
                refundRelationPO.setInvoiceStatus(invoicePO.getStatus());
            }
            BigDecimal rate = BigDecimal.ZERO;
            if (invoicePO.getTaxAmt() != null && invoicePO.getUntaxAmt() != null) {
                rate = invoicePO.getTaxAmt().divide(invoicePO.getUntaxAmt(), 2, 4);
            }
            BigDecimal noTaxAmt = TaxUtils.calNoTaxAmt((BigDecimal)refundRelationPO.getRefundAmt(), (BigDecimal)rate);
            BigDecimal taxAmt = refundRelationPO.getRefundAmt().subtract(noTaxAmt);
            refundRelationPO.setUntaxAmt(noTaxAmt);
            refundRelationPO.setTaxAmt(taxAmt);
            invoiceRefundList.add(refundRelationPO);
            invoiceIds.add(invoicePO.getInvoiceId());
        }
        for (FscOrderRelationPO relationPO : reqBO.getOrderList()) {
            relationPO.setFscOrderId(null);
            relationPO.setRefundId(refundPO.getRefundId());
            relationPO.setId(Long.valueOf(Sequence.getInstance().nextId()));
        }
        String refundNo = editFlag != false ? reqBO.getRefundNo() : this.qryRefundNo(refundPO);
        refundPO.setRefundNo(refundNo);
        refundPO.setRefundAmount(reqBO.getRefundAmt());
        if (!CollectionUtils.isEmpty(reqBO.getFileList())) {
            ArrayList<FscAttachmentPO> attachmentList = new ArrayList<FscAttachmentPO>();
            Date now = new Date();
            if (editFlag.booleanValue()) {
                FscAttachmentPO attachmentPO = new FscAttachmentPO();
                attachmentPO.setObjId(refundPO.getRefundId());
                this.fscAttachmentMapper.deleteBy(attachmentPO);
            }
            for (AttachmentBO attachmentBO : reqBO.getFileList()) {
                FscAttachmentPO attachmentPO = new FscAttachmentPO();
                BeanUtils.copyProperties((Object)attachmentBO, (Object)attachmentPO);
                attachmentPO.setAttachmentId(Long.valueOf(Sequence.getInstance().nextId()));
                attachmentPO.setObjId(refundPO.getRefundId());
                attachmentPO.setObjType(FscConstants.AttachmentObjType.REFUND_INVOICE);
                attachmentPO.setAttachmentType(FscConstants.AttachmentType.REFUND_INVOICE);
                attachmentPO.setCreateTime(now);
                attachmentPO.setCreateUser(reqBO.getName());
                attachmentPO.setCreateUserId(reqBO.getUserId());
                attachmentList.add(attachmentPO);
            }
            this.fscAttachmentMapper.insertBatch(attachmentList);
        }
        if (refundPO.getReceiveType().equals(FscConstants.FscOrderReceiveType.OPERATION) || reqBO.getOperationDown().equals(FscConstants.OperationDown.YES)) {
            this.dealOperatorInfo(refundPO, reqBO);
        }
        if (editFlag.booleanValue()) {
            this.fscOrderRefundMapper.deleteById(refundPO.getRefundId());
            this.fscOrderRelationMapper.deleteByRefundIds(Arrays.asList(refundPO.getRefundId()));
            this.fscInvoiceRefundRelationMapper.deleteByRefundId(refundPO.getRefundId());
            this.fscOrderItemMapper.deleteByRefundIds(Arrays.asList(refundPO.getRefundId()));
        }
        if ((refundCount = this.fscOrderRefundMapper.insert(refundPO)) == 0) {
            throw new FscBusinessException("198888", "refundCount\u9000\u7968\u5355\u65b0\u589e\u5931\u8d25,\u8bf7\u5237\u65b0\u540e\u91cd\u8bd5\uff01");
        }
        int relationCount = this.fscOrderRelationMapper.insertBatch(reqBO.getOrderList());
        if (relationCount == 0) {
            throw new FscBusinessException("198888", "relationCount\u9000\u7968\u5355\u5173\u8054\u5173\u7cfb\u65b0\u589e\u5931\u8d25,\u8bf7\u5237\u65b0\u540e\u91cd\u8bd5\uff01");
        }
        int invoiceRcount = this.fscInvoiceRefundRelationMapper.insertBatch(invoiceRefundList);
        if (invoiceRcount == 0) {
            throw new FscBusinessException("198888", "invoiceRcount\u9000\u7968\u5355\u5173\u8054\u65b0\u589e\u5931\u8d25,\u8bf7\u5237\u65b0\u540e\u91cd\u8bd5\uff01");
        }
        if (!CollectionUtils.isEmpty(reqBO.getInsertFscOrderItemPOS())) {
            this.fscOrderItemMapper.insertBatch(reqBO.getInsertFscOrderItemPOS());
        }
        if (!editFlag.booleanValue() && reqBO.getOperationDown().equals(FscConstants.OperationDown.YES) && reqBO.getOperationType().equals(FscConstants.RefundOperationType.SUBMIT) && reqBO.getHisOrderFlow() != 7) {
            FscBillOrderRefundChangeAtomReqBO atomReqBO = new FscBillOrderRefundChangeAtomReqBO();
            atomReqBO.setRefundId(refundPO.getRefundId());
            atomReqBO.setCreateUserId(reqBO.getUserId());
            atomReqBO.setOperationType(FscConstants.RefundChangeOperationType.SAVE);
            FscBillOrderRefundChangeAtomRspBO atomRspBO = this.fscBillOrderRefundChangeNewAtomService.recordRefundChangeNew(atomReqBO);
            if (!"0000".equals(atomRspBO.getRespCode())) {
                throw new ZTBusinessException("\u8bb0\u5f55\u6838\u9500\u865a\u62df\u53d8\u66f4\u8868\u5931\u8d25" + atomRspBO.getRespDesc());
            }
        }
        if (reqBO.getOperationDown() != null && reqBO.getOperationDown().equals(FscConstants.OperationDown.YES) && reqBO.getOperationType().equals(FscConstants.RefundOperationType.SUBMIT) && reqBO.getHisOrderFlow() != 7) {
            this.dealStartApproval(reqBO, refundPO);
        }
        if (reqBO.getOperationType().equals(FscConstants.RefundOperationType.SUBMIT) && reqBO.getHisOrderFlow() != 7) {
            this.dealWorkFlow(refundPO, reqBO.getOperationDown());
        }
        FscBillOrderRefundCreateBusiRspBO rspBO = new FscBillOrderRefundCreateBusiRspBO();
        rspBO.setRefundId(refundPO.getRefundId());
        rspBO.setFscOrderId(reqBO.getFscOrderId());
        rspBO.setRespCode("0000");
        rspBO.setRespDesc("\u6210\u529f");
        return rspBO;
    }

    private void dealOperatorInfo(FscOrderRefundPO refundPO, FscBillOrderRefundCreateBusiReqBO reqBO) {
        String[] split;
        refundPO.setOperatorId(reqBO.getUserId());
        refundPO.setOperatorName(reqBO.getName());
        for (String orgId : split = this.proOrg.split(SEPARATOR)) {
            if (!reqBO.getOrgPath().contains("-" + orgId + "-")) continue;
            refundPO.setOperationId(Long.valueOf(orgId));
            UmcEnterpriseOrgNameListQryAbilityReqBO abilityReqBO = new UmcEnterpriseOrgNameListQryAbilityReqBO();
            abilityReqBO.setOrgIdList(Collections.singletonList(Long.valueOf(orgId)));
            UmcEnterpriseOrgNameListQryAbilityRspBO rspBO = this.umcEnterpriseOrgNameListQryAbilityService.qryEnterpriseOrgNameList(abilityReqBO);
            if (rspBO.getRespCode().equals("0000") && !CollectionUtils.isEmpty((Map)rspBO.getOrgMap())) {
                Map orgMap = rspBO.getOrgMap();
                refundPO.setOperationName(((UmcDycEnterpriseOrgBO)orgMap.get(refundPO.getOperationId())).getOrgName());
                break;
            }
            throw new FscBusinessException("198888", "\u67e5\u8be2\u673a\u6784\u4fe1\u606f\u5f02\u5e38:" + rspBO.getRespDesc());
        }
    }

    private void checkRefundInvoice(List<Long> invoiceIds) {
        int count = this.fscInvoiceRefundRelationMapper.checkRefund(invoiceIds);
        if (count > 0) {
            throw new FscBusinessException("198888", "\u5b58\u5728\u53d1\u7968\u5df2\u8fdb\u884c\u9000\u7968\u6216\u5728\u9000\u7968\u4e2d,\u8bf7\u52ff\u91cd\u590d\u53d1\u8d77\u9000\u7968\u7533\u8bf7\uff01");
        }
    }

    private BigDecimal getPaidAmtByPay(FscOrderRefundPO refundPO) {
        BigDecimal paidAmt = BigDecimal.ZERO;
        List payDetailPOList = new ArrayList();
        payDetailPOList = refundPO.getSettleType().equals(FscConstants.SettleType.INSPECTION) ? this.fscShouldPayDetailMapper.qryRefundList(refundPO.getFscOrderId(), null) : this.fscShouldPayDetailMapper.qryOrderRefundList(refundPO.getFscOrderId(), null);
        if (!CollectionUtils.isEmpty(payDetailPOList)) {
            for (FscShouldPayDetailPO shouldPayDetailPO : payDetailPOList) {
                paidAmt = paidAmt.add(shouldPayDetailPO.getPayAmount().subtract(shouldPayDetailPO.getRefundAmount()));
            }
        }
        return paidAmt;
    }

    private void dealStartApproval(FscBillOrderRefundCreateBusiReqBO reqBO, FscOrderRefundPO refundPO) {
        UacNoTaskAuditCreateReqBO auditCreateReqBO = new UacNoTaskAuditCreateReqBO();
        auditCreateReqBO.setCreateOperId(reqBO.getUserId().toString());
        auditCreateReqBO.setCreateOperName(reqBO.getName());
        auditCreateReqBO.setCreateOperDept(reqBO.getOrgName());
        auditCreateReqBO.setIsSaveCreateLog(Boolean.valueOf(true));
        if (refundPO.getReceiveType().equals(FscConstants.FscOrderReceiveType.OPERATION)) {
            auditCreateReqBO.setMenuId("M001009");
        } else {
            auditCreateReqBO.setMenuId("M001010");
        }
        auditCreateReqBO.setOrgId(reqBO.getOrgId().toString());
        ArrayList<UacNoTaskAuditCreateInfoReqBO> createBusiReqBO = new ArrayList<UacNoTaskAuditCreateInfoReqBO>();
        UacNoTaskAuditCreateInfoReqBO uacNoTaskAuditCreateInfoReqBO = new UacNoTaskAuditCreateInfoReqBO();
        uacNoTaskAuditCreateInfoReqBO.setObjType(FscConstants.AuditObjType.REFUND_INVOICE);
        uacNoTaskAuditCreateInfoReqBO.setObjNum("1");
        uacNoTaskAuditCreateInfoReqBO.setOrderId(refundPO.getRefundId());
        ArrayList<ApprovalObjBO> approvalObjBOList = new ArrayList<ApprovalObjBO>();
        ApprovalObjBO approvalObjBO = new ApprovalObjBO();
        approvalObjBO.setObjId(refundPO.getRefundId().toString());
        approvalObjBO.setObjName("\u9000\u7968\u5355\u5ba1\u6279");
        approvalObjBO.setObjType(FscConstants.AuditObjType.REFUND_INVOICE);
        approvalObjBOList.add(approvalObjBO);
        uacNoTaskAuditCreateInfoReqBO.setApprovalObjInfo(approvalObjBOList);
        createBusiReqBO.add(uacNoTaskAuditCreateInfoReqBO);
        auditCreateReqBO.setCreateBusiReqBO(createBusiReqBO);
        log.info("\u5ba1\u6279\u5165\u53c2================" + JSON.toJSONString((Object)auditCreateReqBO));
        UacNoTaskAuditCreateRspBO uacNoTaskAuditCreateRspBO = this.uacNoTaskAuditCreateAbilityService.auditOrderCreate(auditCreateReqBO);
        log.info("\u5ba1\u6279\u51fa\u53c2================" + JSON.toJSONString((Object)uacNoTaskAuditCreateRspBO));
        if (!"0000".equals(uacNoTaskAuditCreateRspBO.getRespCode())) {
            throw new FscBusinessException("191019", uacNoTaskAuditCreateRspBO.getRespDesc());
        }
        if (uacNoTaskAuditCreateRspBO.getNotFindFlag().booleanValue()) {
            throw new FscBusinessException("190000", "\u8bf7\u8054\u7cfb\u7ba1\u7406\u5458\u914d\u7f6e\u7ed3\u7b97\u5355\u5ba1\u6279\u6d41\uff01");
        }
        FscTaskCandidatePO taskPo = new FscTaskCandidatePO();
        taskPo.setFscOrderId(refundPO.getRefundId());
        List pendAuditPostIdList = this.fscTaskCandidateMapper.getPendAuditPostIdList(taskPo);
        if (!CollectionUtils.isEmpty((Collection)pendAuditPostIdList)) {
            DycStationOrgSelectUserNameReqBO dycStationOrgSelectUserNameReqBO = new DycStationOrgSelectUserNameReqBO();
            dycStationOrgSelectUserNameReqBO.setStationId(Long.valueOf(((FscApprovalTaskQueryBO)pendAuditPostIdList.get(0)).getTaskOperId()));
            DycStationOrgSelectUserNameRspBO dycStationOrgSelectUserNameRspBO = this.dycStationOrgSelectUserNameService.selectUserName(dycStationOrgSelectUserNameReqBO);
            if (dycStationOrgSelectUserNameRspBO != null && !CollectionUtils.isEmpty((Collection)dycStationOrgSelectUserNameRspBO.getUserList())) {
                FscSendNotificationExtAtomReqBO fscSendNotificationExtAtomReqBO = new FscSendNotificationExtAtomReqBO();
                fscSendNotificationExtAtomReqBO.setTitel("\u9500\u552e\u9000\u7968\u7533\u8bf7\u5355");
                fscSendNotificationExtAtomReqBO.setText("\u3010\u4e2d\u56fd\u4e2d\u7164\u3011\u60a8\u6709\u5f85\u5ba1\u6279\u7684\u9000\u7968\u7533\u8bf7\u5355" + refundPO.getRefundNo() + "\u5df2\u63d0\u4ea4\u81f3\u60a8\u5904\u5ba1\u6279\uff0c\u8bf7\u53ca\u65f6\u5904\u7406\u3002");
                fscSendNotificationExtAtomReqBO.setUserId(reqBO.getUserId());
                fscSendNotificationExtAtomReqBO.setReceiveIds(dycStationOrgSelectUserNameRspBO.getUserList().stream().map(UserBO::getUserId).distinct().collect(Collectors.toList()));
                this.fscSendNotificationExtAtomService.sendNotification(fscSendNotificationExtAtomReqBO);
            }
        }
        FscOrderRefundPO updatePo = new FscOrderRefundPO();
        updatePo.setRefundId(refundPO.getRefundId());
        updatePo.setAuditStatus(FscConstants.AuditStatus.AUDITING);
        this.fscOrderRefundMapper.updateById(updatePo);
        try {
            this.taskTodoWaitService.syncNotifySaleRefundWaitDone(reqBO.getRefundId());
        }
        catch (Exception e) {
            log.error("dealPayBillCreateBySale -\u901a\u77e5\u5f85\u529e\u5931\u8d25- error:{}", (Throwable)e);
        }
    }

    private void dealWorkFlow(FscOrderRefundPO refundPO, Integer paramValue) {
        FscOrderStatusStartAtomRspBO fscOrderStatusStartAtomRspBO;
        FscOrderStatusStartAtomReqBO fscOrderStatusStartAtomReqBO = new FscOrderStatusStartAtomReqBO();
        fscOrderStatusStartAtomReqBO.setBusiName(BUSI_NAME);
        fscOrderStatusStartAtomReqBO.setOrderId(refundPO.getRefundId());
        fscOrderStatusStartAtomReqBO.setOrderFlowKey(refundPO.getOrderFlowKey());
        fscOrderStatusStartAtomReqBO.setOrderFlow(refundPO.getOrderFlow());
        if (paramValue != null) {
            HashMap<String, Integer> paramMap = new HashMap<String, Integer>();
            paramMap.put("startFlag", paramValue);
            fscOrderStatusStartAtomReqBO.setParamMap(paramMap);
        }
        if (!(fscOrderStatusStartAtomRspBO = this.fscOrderStatusStartAtomService.dealRefundStatusStart(fscOrderStatusStartAtomReqBO)).getRespCode().equals("0000")) {
            throw new FscBusinessException(fscOrderStatusStartAtomRspBO.getRespCode(), fscOrderStatusStartAtomRspBO.getRespDesc());
        }
    }

    private String qryRefundNo(FscOrderRefundPO refundPO) {
        StringBuffer keySb = new StringBuffer();
        keySb.append(refundPO.getReceiveType());
        if (FscConstants.FscOrderMakeType.OPERTION.equals(refundPO.getMakeType()) || FscConstants.FscOrderReceiveType.OPERATION.equals(refundPO.getReceiveType())) {
            keySb.append(FscConstants.FscBusiModel.TRADE);
        } else {
            keySb.append(FscConstants.FscBusiModel.MATCHING);
        }
        keySb.append(refundPO.getOrderSource());
        CfcEncodedSerialGetServiceReqBO encodedSerialGetServiceReqBO = new CfcEncodedSerialGetServiceReqBO();
        encodedSerialGetServiceReqBO.setCenter("FSC");
        encodedSerialGetServiceReqBO.setEncodedRuleCode("XS_REFUND_INVOICE_NO");
        encodedSerialGetServiceReqBO.setNum(Integer.valueOf(1));
        CfcEncodedSerialGetServiceRspBO encodedSerialGetServiceRspBO = this.encodedSerialGetService.getEncodedSerial(encodedSerialGetServiceReqBO);
        if (!encodedSerialGetServiceRspBO.getRespCode().equals("0000") || CollectionUtils.isEmpty((Collection)encodedSerialGetServiceRspBO.getSerialNoList())) {
            throw new FscBusinessException("198888", "\u67e5\u8be2\u9000\u6b3e\u5355\u53f7\u7f16\u7801\u89c4\u5219\u5931\u8d25\uff01" + encodedSerialGetServiceRspBO.getRespDesc());
        }
        return (String)encodedSerialGetServiceRspBO.getSerialNoList().get(0);
    }

    private FscOrderRefundPO buildRefundOrderInfo(FscBillOrderRefundCreateBusiReqBO reqBO) {
        FscOrderPO orderPO = new FscOrderPO();
        orderPO.setFscOrderId(reqBO.getFscOrderId());
        orderPO = this.fscOrderMapper.getModelBy(orderPO);
        reqBO.setHisOrderFlow(orderPO.getOrderFlow());
        FscOrderRefundPO refundPO = new FscOrderRefundPO();
        BeanUtils.copyProperties((Object)orderPO, (Object)refundPO);
        refundPO.setRefundId(reqBO.getRefundId());
        refundPO.setAgentDeptId(reqBO.getAgentDeptId());
        refundPO.setAgentDeptName(reqBO.getAgentDeptName());
        refundPO.setAgentUserId(reqBO.getAgentUserId());
        refundPO.setAgentUserName(reqBO.getAgentUserName());
        refundPO.setAuditStatus(orderPO.getOrderFlow() == 7 ? FscConstants.AuditStatus.AUDIT_PASS : FscConstants.AuditStatus.SAVE);
        refundPO.setRefundNote(reqBO.getRefundNote());
        refundPO.setRefundReason(reqBO.getRefundReason());
        refundPO.setRefundReasonType(reqBO.getRefundReasonType());
        refundPO.setTotalCharge(orderPO.getTotalCharge());
        refundPO.setCertification(reqBO.getCertification());
        refundPO.setCreateTime(new Date());
        refundPO.setCreateUserId(reqBO.getUserId());
        refundPO.setCreateUserName(reqBO.getName());
        refundPO.setRefundStatus(orderPO.getOrderFlow() == 7 ? FscConstants.RefundInvoiceStatus.AUDIT_PASS : FscConstants.RefundInvoiceStatus.SAVE);
        refundPO.setPushStatus(FscConstants.RefundPushStatus.UN_PUSH);
        refundPO.setFscOrderNo(orderPO.getOrderNo());
        refundPO.setOrderFlow(FscConstants.OrderFlow.REFUND_INVOICE);
        refundPO.setIsPushUnify(orderPO.getSettlePlatform());
        if (refundPO.getIsPushUnify() == null) {
            refundPO.setIsPushUnify(Integer.valueOf(0));
        }
        refundPO.setPushUnifyStatus(FscConstants.FscPushStatus.NO_PUSH);
        refundPO.setOrderFlowKey(FscRefundFlowProcKeyEnum.REFUND_DOWN_INVOICE.getDescr());
        refundPO.setYcUserId(reqBO.getYcUserId());
        refundPO.setYcPersonId(reqBO.getYcPersonId());
        refundPO.setYcPersonName(reqBO.getYcPersonName());
        refundPO.setYcDeptId(reqBO.getYcDeptId());
        refundPO.setYcDeptName(reqBO.getYcDeptName());
        refundPO.setExt1(reqBO.getExt1());
        refundPO.setIsQuality(reqBO.getIsQuality());
        BigDecimal qualityAmt = BigDecimal.ZERO;
        if (!CollectionUtils.isEmpty(reqBO.getQualityBOS())) {
            for (FscBillOrderRefundQualityBO qualityBO : reqBO.getQualityBOS()) {
                qualityAmt = qualityAmt.add(qualityBO.getQualityAmt());
            }
        }
        refundPO.setQualityAmt(qualityAmt);
        refundPO.setIsInvoiceChange(reqBO.getIsInvoiceChange());
        refundPO.setIsOperateCreate(reqBO.getIsOperateCreate());
        refundPO.setSign(Integer.valueOf(1));
        return refundPO;
    }
}

