/*
 * Decompiled with CFR 0.152.
 */
package com.tydic.fsc.bill.busi.impl;

import com.tydic.fsc.bill.busi.api.FscBillOrderSpecialRefundCancelBusiService;
import com.tydic.fsc.bill.busi.bo.FscBillOrderSpecialRefundCancelBusiReqBO;
import com.tydic.fsc.bill.busi.bo.FscBillOrderSpecialRefundCancelBusiRspBO;
import com.tydic.fsc.busibase.atom.api.FscOrderStatusFlowAtomService;
import com.tydic.fsc.busibase.atom.bo.FscOrderStatusFlowAtomReqBO;
import com.tydic.fsc.busibase.atom.bo.FscOrderStatusFlowAtomRspBO;
import com.tydic.fsc.constants.FscConstants;
import com.tydic.fsc.dao.FscInvoiceItemMapper;
import com.tydic.fsc.dao.FscInvoiceMapper;
import com.tydic.fsc.dao.FscInvoiceRefundRelationMapper;
import com.tydic.fsc.dao.FscOrderItemMapper;
import com.tydic.fsc.dao.FscOrderRefundMapper;
import com.tydic.fsc.exception.FscBusinessException;
import com.tydic.fsc.po.FscInvoicePO;
import com.tydic.fsc.po.FscInvoiceRefundRelationPO;
import com.tydic.fsc.po.FscOrderItemPO;
import com.tydic.fsc.po.FscOrderRefundPO;
import java.util.Collection;
import java.util.HashMap;
import java.util.List;
import java.util.stream.Collectors;
import org.springframework.beans.factory.annotation.Autowired;
import org.springframework.stereotype.Service;
import org.springframework.util.CollectionUtils;

@Service
public class FscBillOrderSpecialRefundCancelBusiServiceImpl
implements FscBillOrderSpecialRefundCancelBusiService {
    @Autowired
    private FscOrderRefundMapper fscOrderRefundMapper;
    @Autowired
    private FscInvoiceItemMapper fscInvoiceItemMapper;
    @Autowired
    private FscInvoiceMapper fscInvoiceMapper;
    @Autowired
    private FscInvoiceRefundRelationMapper fscInvoiceRefundRelationMapper;
    @Autowired
    private FscOrderItemMapper fscOrderItemMapper;
    @Autowired
    private FscOrderStatusFlowAtomService fscOrderStatusFlowAtomService;
    private static final String BUSI_NAME = "\u9000\u7968\u4e3b\u5355\u53d6\u6d88";

    @Override
    public FscBillOrderSpecialRefundCancelBusiRspBO dealSpecialRefundCancel(FscBillOrderSpecialRefundCancelBusiReqBO reqBO) {
        FscOrderRefundPO refundPO = new FscOrderRefundPO();
        refundPO.setRefundId(reqBO.getRefundId());
        refundPO = this.fscOrderRefundMapper.getModelBy(refundPO);
        if (!refundPO.getRefundStatus().equals(FscConstants.RefundInvoiceStatus.CANCEL)) {
            this.dealRefundInvoiceAmt(reqBO.getRefundId());
        }
        if (reqBO.getDelType() == 1) {
            this.dealWorkFlow(refundPO);
        }
        if (reqBO.getDelType() == 2) {
            FscOrderRefundPO updateRefundPO = new FscOrderRefundPO();
            updateRefundPO.setRefundId(reqBO.getRefundId());
            updateRefundPO.setRefundStatus(FscConstants.RefundInvoiceStatus.DELETE);
            int count = this.fscOrderRefundMapper.updateById(updateRefundPO);
            if (count != 1) {
                throw new FscBusinessException("198888", "\u66f4\u65b0\u9000\u7968\u4e3b\u5355\u4fe1\u606f\u5931\u8d25\uff01");
            }
        }
        FscBillOrderSpecialRefundCancelBusiRspBO rspBO = new FscBillOrderSpecialRefundCancelBusiRspBO();
        rspBO.setRespCode("0000");
        rspBO.setRespDesc("\u6210\u529f");
        return rspBO;
    }

    private void dealRefundInvoiceAmt(Long refundId) {
        FscOrderItemPO orderItemPO = new FscOrderItemPO();
        orderItemPO.setRefundId(refundId);
        List orderItemPOList = this.fscOrderItemMapper.getListNoPage(orderItemPO);
        if (CollectionUtils.isEmpty((Collection)orderItemPOList)) {
            throw new FscBusinessException("198888", "\u67e5\u8be2\u9000\u7968\u7ed3\u7b97\u660e\u7ec6\u4fe1\u606f\u4e3a\u7a7a\uff01");
        }
        List invoiceItemIds = orderItemPOList.stream().map(FscOrderItemPO::getInvoiceItemId).collect(Collectors.toList());
        int count = this.fscInvoiceItemMapper.updateRefundAmtByItemIdsSub(invoiceItemIds);
        if (count != invoiceItemIds.size()) {
            throw new FscBusinessException("198888", "\u91ca\u653e\u53d1\u7968\u660e\u7ec6\u9000\u7968\u91d1\u989d\u5904\u7406\u5931\u8d25\uff01");
        }
        FscInvoiceRefundRelationPO invoiceRefundRelationPO = new FscInvoiceRefundRelationPO();
        invoiceRefundRelationPO.setRefundId(refundId);
        List invoiceRefundRelationPOList = this.fscInvoiceRefundRelationMapper.getList(invoiceRefundRelationPO);
        List invoiceIds = invoiceRefundRelationPOList.stream().map(FscInvoiceRefundRelationPO::getInvoiceId).collect(Collectors.toList());
        FscInvoicePO invoicePO = new FscInvoicePO();
        invoicePO.setInvoiceIds(invoiceIds);
        invoicePO.setStatus(FscConstants.FscInvoiceStatus.VALID);
        int invoiceCount = this.fscInvoiceMapper.updateInvoiceStatus(invoicePO);
        if (invoiceCount != invoiceIds.size()) {
            throw new FscBusinessException("198888", "\u91ca\u653e\u53d1\u7968\u660e\u7ec6\u9000\u7968\u91d1\u989d\u5904\u7406\u5931\u8d25\uff01");
        }
    }

    private void dealWorkFlow(FscOrderRefundPO refundPO) {
        HashMap<String, Integer> paramMap = new HashMap<String, Integer>(4);
        paramMap.put("cancelFlag", FscConstants.BillOrderCancelFlag.CANCEL_ORDER);
        FscOrderStatusFlowAtomReqBO flowAtomReqBO = new FscOrderStatusFlowAtomReqBO();
        flowAtomReqBO.setOrderId(refundPO.getRefundId());
        flowAtomReqBO.setCurStatus(refundPO.getRefundStatus());
        flowAtomReqBO.setBusiName(BUSI_NAME);
        flowAtomReqBO.setParamMap(paramMap);
        FscOrderStatusFlowAtomRspBO flowAtomRspBO = this.fscOrderStatusFlowAtomService.dealRefundStatusFlow(flowAtomReqBO);
        if (!"0000".equals(flowAtomRspBO.getRespCode())) {
            throw new FscBusinessException("193108", flowAtomRspBO.getRespDesc());
        }
    }
}

