/*
 * Decompiled with CFR 0.152.
 */
package com.tydic.fsc.bill.busi.impl;

import com.alibaba.fastjson.JSON;
import com.alibaba.fastjson.JSONObject;
import com.google.common.base.Joiner;
import com.ohaotian.plugin.db.Page;
import com.ohaotian.plugin.db.Sequence;
import com.tydic.authority.busi.api.DycStationOrgSelectUserNameService;
import com.tydic.authority.busi.bo.DycStationOrgSelectUserNameReqBO;
import com.tydic.authority.busi.bo.DycStationOrgSelectUserNameRspBO;
import com.tydic.authority.busi.bo.UserBO;
import com.tydic.fsc.bill.ability.bo.FscSaleCheckAbilityRspBO;
import com.tydic.fsc.bill.ability.bo.FscUpdateIllustrateAbilityReqBO;
import com.tydic.fsc.bill.busi.api.FscBillSendSaleFscOrderApplyBusiService;
import com.tydic.fsc.bill.busi.bo.FscBillSendSaleFscOrderApplyBusiReqBO;
import com.tydic.fsc.bill.busi.bo.FscBillSendSaleFscOrderApplyBusiRspBO;
import com.tydic.fsc.bill.busi.bo.FscCheckTempBusiBO;
import com.tydic.fsc.bill.busi.bo.FscCheckTempBusiReqBO;
import com.tydic.fsc.bill.busi.bo.FscCheckTempBusiRspBO;
import com.tydic.fsc.bill.busi.bo.FscSaleCheckBusiReqBO;
import com.tydic.fsc.bill.busi.bo.FscSaleCheckBusiRspBO;
import com.tydic.fsc.bill.busi.bo.FscSaleCheckDataReqBO;
import com.tydic.fsc.bo.FscApprovalTaskQueryBO;
import com.tydic.fsc.bo.FscOrderInfoBO;
import com.tydic.fsc.bo.FscOrderItemBO;
import com.tydic.fsc.bo.FscOrderItemReqBO;
import com.tydic.fsc.bo.RelOrderBO;
import com.tydic.fsc.busibase.atom.api.FscAcceptOrderListQueryAtomService;
import com.tydic.fsc.busibase.atom.api.FscOrderStatusFlowAtomService;
import com.tydic.fsc.busibase.atom.api.FscSendNotificationExtAtomService;
import com.tydic.fsc.busibase.atom.bo.FscAcceptOrderListQueryAtomReqBO;
import com.tydic.fsc.busibase.atom.bo.FscAcceptOrderListQueryAtomRspBO;
import com.tydic.fsc.busibase.atom.bo.FscOrderStatusFlowAtomReqBO;
import com.tydic.fsc.busibase.atom.bo.FscOrderStatusFlowAtomRspBO;
import com.tydic.fsc.busibase.atom.bo.FscSendNotificationExtAtomReqBO;
import com.tydic.fsc.busibase.busi.api.FscDictionaryBusiService;
import com.tydic.fsc.common.ability.enums.FscInvoiceValueTypeEnum;
import com.tydic.fsc.constants.FscBillStatus;
import com.tydic.fsc.constants.FscConstants;
import com.tydic.fsc.constants.FscOrderSourceEnum;
import com.tydic.fsc.dao.FscCheckTempMapper;
import com.tydic.fsc.dao.FscOrderItemMapper;
import com.tydic.fsc.dao.FscOrderMapper;
import com.tydic.fsc.dao.FscTaskCandidateMapper;
import com.tydic.fsc.enums.FscOrderSendStateEnum;
import com.tydic.fsc.exception.FscBusinessException;
import com.tydic.fsc.pay.task.service.TaskTodoWaitService;
import com.tydic.fsc.po.FscCheckTempPO;
import com.tydic.fsc.po.FscOrderItemPO;
import com.tydic.fsc.po.FscOrderPO;
import com.tydic.fsc.po.FscTaskCandidatePO;
import com.tydic.fsc.util.FscCommonUtils;
import com.tydic.uac.ability.UacNoTaskAuditCreateAbilityService;
import com.tydic.uac.ability.bo.UacNoTaskAuditCreateInfoReqBO;
import com.tydic.uac.ability.bo.UacNoTaskAuditCreateReqBO;
import com.tydic.uac.ability.bo.UacNoTaskAuditCreateRspBO;
import com.tydic.uac.bo.common.ApprovalObjBO;
import com.tydic.umc.general.ability.api.UmcEnterpriseOrgNameListQryAbilityService;
import com.tydic.umc.general.ability.api.UmcEnterpriseOrgQryDetailAbilityService;
import com.tydic.umc.general.ability.bo.UmcDycEnterpriseOrgBO;
import com.tydic.umc.general.ability.bo.UmcEnterpriseOrgNameListQryAbilityReqBO;
import com.tydic.umc.general.ability.bo.UmcEnterpriseOrgNameListQryAbilityRspBO;
import com.tydic.uoc.common.ability.api.UocPebQryOrderDetailAbilityService;
import com.tydic.uoc.common.ability.bo.UocOrderItemRspBO;
import com.tydic.uoc.common.ability.bo.UocQryOrderItemAbilityReqBO;
import com.tydic.uoc.common.ability.bo.UocQryOrderItemListAbilityRspBO;
import java.math.BigDecimal;
import java.math.RoundingMode;
import java.util.ArrayList;
import java.util.Collection;
import java.util.Date;
import java.util.HashMap;
import java.util.List;
import java.util.Map;
import java.util.Objects;
import java.util.function.Function;
import java.util.stream.Collectors;
import org.apache.commons.lang3.StringUtils;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;
import org.springframework.beans.factory.annotation.Autowired;
import org.springframework.beans.factory.annotation.Value;
import org.springframework.stereotype.Service;
import org.springframework.util.CollectionUtils;

@Service
public class FscBillSendSaleFscOrderApplyBusiServiceImpl
implements FscBillSendSaleFscOrderApplyBusiService {
    private static final Logger log = LoggerFactory.getLogger(FscBillSendSaleFscOrderApplyBusiServiceImpl.class);
    @Autowired
    private UacNoTaskAuditCreateAbilityService uacNoTaskAuditCreateAbilityService;
    @Autowired
    private FscOrderMapper fscOrderMapper;
    @Autowired
    private FscOrderItemMapper fscOrderItemMapper;
    @Autowired
    private FscTaskCandidateMapper fscTaskCandidateMapper;
    @Value(value="${fsc.main.pro.org:100096,100100}")
    private String proOrg;
    @Autowired
    private FscOrderStatusFlowAtomService fscOrderStatusFlowAtomService;
    private static final String BUSI_NAME = "\u4e3b\u5355\u786e\u8ba4";
    @Autowired
    private UmcEnterpriseOrgNameListQryAbilityService umcEnterpriseOrgNameListQryAbilityService;
    @Autowired
    private FscAcceptOrderListQueryAtomService fscAcceptOrderListQueryAtomService;
    @Autowired
    private UmcEnterpriseOrgQryDetailAbilityService umcEnterpriseOrgQryDetailAbilityService;
    @Autowired
    private UocPebQryOrderDetailAbilityService uocPebQryOrderDetailAbilityService;
    @Autowired
    private FscCheckTempMapper fscCheckTempMapper;
    @Autowired
    private DycStationOrgSelectUserNameService dycStationOrgSelectUserNameService;
    @Autowired
    private FscSendNotificationExtAtomService fscSendNotificationExtAtomService;
    @Autowired
    private FscDictionaryBusiService fscDictionaryBusiService;
    @Autowired
    private TaskTodoWaitService taskTodoWaitService;

    @Override
    public FscBillSendSaleFscOrderApplyBusiRspBO dealSendSaleFscOrderApply(FscBillSendSaleFscOrderApplyBusiReqBO reqBO) {
        if (!CollectionUtils.isEmpty(reqBO.getSettlFscOrderItemBOList())) {
            ArrayList fscOrderItemPOList = new ArrayList(reqBO.getSettlFscOrderItemBOList().size());
            reqBO.getSettlFscOrderItemBOList().forEach(e -> {
                FscOrderItemPO fscOrderItemPO = new FscOrderItemPO();
                fscOrderItemPO.setFscOrderId(e.getFscOrderId());
                fscOrderItemPO.setOrderItemId(e.getOrderItemId());
                fscOrderItemPO.setProductDescription(e.getProductDescription());
                fscOrderItemPO.setSpecificationsModel(e.getSpecificationsModel());
                fscOrderItemPO.setProductDescriptionTemp(e.getProductDescription());
                fscOrderItemPO.setSpecificationsModelTemp(e.getSpecificationsModel());
                fscOrderItemPOList.add(fscOrderItemPO);
            });
            int count = this.fscOrderItemMapper.updateBatchByList(fscOrderItemPOList);
            if (count < 0) {
                throw new FscBusinessException("198888", "\u66f4\u65b0\u5931\u8d25\uff01");
            }
        }
        ArrayList<Long> pushOrderIds = new ArrayList<Long>();
        FscBillSendSaleFscOrderApplyBusiRspBO rspBO = new FscBillSendSaleFscOrderApplyBusiRspBO();
        for (Long l : reqBO.getFscOrderIds()) {
            FscOrderPO order = new FscOrderPO();
            order.setFscOrderId(l);
            order = this.fscOrderMapper.getModelBy(order);
            if (FscOrderSendStateEnum.NO_AUDIT.getCode().equals(order.getSendState())) {
                throw new FscBusinessException("191000", order.getOrderNo() + "\u8be5\u7ed3\u7b97\u5355\u5df2\u5728\u5ba1\u6279\u4e2d");
            }
            FscOrderItemPO fscOrderItemPO = new FscOrderItemPO();
            fscOrderItemPO.setFscOrderId(order.getFscOrderId());
            List fscOrderItemList = this.fscOrderItemMapper.getList(fscOrderItemPO);
            if (CollectionUtils.isEmpty((Collection)fscOrderItemList)) {
                throw new FscBusinessException("193008", "\u9500\u552e\u7ed3\u7b97\u5355\uff1a" + order.getOrderNo() + "\uff0c\u67e5\u8be2\u7ed3\u7b97\u8ba2\u5355\u660e\u7ec6\u4e3a\u7a7a\uff01");
            }
            int index = 1;
            for (FscOrderItemPO po : fscOrderItemList) {
                if (StringUtils.isNotBlank((CharSequence)po.getSpecificationsModel()) && po.getSpecificationsModel().length() > 120) {
                    throw new FscBusinessException("193004", "\u9500\u552e\u7ed3\u7b97\u5355\uff1a" + order.getOrderNo() + "\uff0c\u7b2c" + index + "\u884c\u89c4\u683c\u578b\u53f7\u4e0d\u53ef\u8d85\u8fc7120\u5b57\u7b26\uff0c\u8bf7\u91cd\u65b0\u4fee\u6539\u4e4b\u540e\u8fdb\u884c\u63d0\u4ea4\uff01");
                }
                ++index;
            }
            if (FscConstants.FscInvoiceOrderState.BILLFAIL.equals(order.getOrderState())) {
                pushOrderIds.add(l);
                continue;
            }
            FscOrderPO fscOrderPO = new FscOrderPO();
            this.fscOrderMapper.deleteOrderSendTemp(l);
            FscOrderPO fscSendTemp = (FscOrderPO)JSON.parseObject((String)JSONObject.toJSONString((Object)((Object)reqBO)), FscOrderPO.class);
            fscSendTemp.setFscOrderId(l);
            fscSendTemp.setYcDeptId(reqBO.getDeptId().toString());
            fscSendTemp.setYcDeptName(reqBO.getDeptName());
            fscSendTemp.setYcPersonId(reqBO.getPersonId().toString());
            fscSendTemp.setYcPersonName(reqBO.getPersonName());
            fscSendTemp.setBuynerNo(order.getBuynerNo());
            fscSendTemp.setBuynerName(order.getBuynerName());
            fscSendTemp.setUserAgentAccount(reqBO.getAgentAccount());
            log.debug("========\u63a8\u9001\u9500\u552e\u5355\u7533\u8bf7\u4e34\u65f6\u4fdd\u5b58\u4fe1\u606f\uff1a" + JSONObject.toJSONString((Object)fscSendTemp));
            this.fscOrderMapper.insertOrderSendTemp(fscSendTemp);
            boolean individuallyPay = !order.getReceiveType().equals(FscConstants.FscOrderReceiveType.INDIVIDUAL);
            Boolean uacFlag = this.invokeUacTask(reqBO, order, individuallyPay);
            if (uacFlag.booleanValue() && individuallyPay) {
                throw new FscBusinessException("190000", "\u8bf7\u8054\u7cfb\u7ba1\u7406\u5458\u914d\u7f6e\u7ed3\u7b97\u5355\u5ba1\u6279\u6d41\uff01");
            }
            if (uacFlag.booleanValue()) {
                fscOrderPO.setSendState(FscOrderSendStateEnum.NOT_AUDIT.getCode());
                fscOrderPO.setOrderState(FscConstants.FscInvoiceOrderState.APPROVAL_PASS);
                pushOrderIds.add(l);
            }
            if (!uacFlag.booleanValue()) {
                FscTaskCandidatePO taskPo = new FscTaskCandidatePO();
                taskPo.setFscOrderId(l);
                List pendAuditPostIdList = this.fscTaskCandidateMapper.getPendAuditPostIdList(taskPo);
                fscOrderPO.setSignApplyTime(new Date());
                if (!CollectionUtils.isEmpty((Collection)pendAuditPostIdList)) {
                    List auditedPostIdList = pendAuditPostIdList.stream().map(FscApprovalTaskQueryBO::getTaskOperId).distinct().collect(Collectors.toList());
                    fscOrderPO.setSendStation(Joiner.on((String)",").join(auditedPostIdList) + ",");
                }
                fscOrderPO.setSendState(FscOrderSendStateEnum.NO_AUDIT.getCode());
                fscOrderPO.setSendApplyTime(new Date());
                fscOrderPO.setSendUserId(reqBO.getUserId());
                fscOrderPO.setSendUserName(reqBO.getName());
            }
            fscOrderPO.setFscOrderId(l);
            fscOrderPO.setOperatorId(reqBO.getUserId());
            fscOrderPO.setOperatorName(reqBO.getName());
            fscOrderPO.setOperatorDeptId(reqBO.getDeptId());
            fscOrderPO.setOperatorDeptName(reqBO.getDeptName());
            if (order.getOperationTime() == null) {
                fscOrderPO.setOperationTime(new Date());
            }
            String operationNo = String.valueOf(reqBO.getOrgId());
            String[] org = this.proOrg.split(",");
            String[] pur = reqBO.getOrgPath().split("-");
            block4: for (String pro : org) {
                for (String t : pur) {
                    if (!pro.equals(t)) continue;
                    operationNo = pro;
                    continue block4;
                }
            }
            fscOrderPO.setOperationNo(operationNo);
            UmcEnterpriseOrgNameListQryAbilityReqBO abilityReqBO = new UmcEnterpriseOrgNameListQryAbilityReqBO();
            ArrayList<Long> operationNos = new ArrayList<Long>();
            operationNos.add(Long.parseLong(operationNo));
            abilityReqBO.setOrgIdList(operationNos);
            UmcEnterpriseOrgNameListQryAbilityRspBO abilityRspBO = this.umcEnterpriseOrgNameListQryAbilityService.qryEnterpriseOrgNameList(abilityReqBO);
            if (abilityRspBO.getRespCode().equals("0000") && !CollectionUtils.isEmpty((Map)abilityRspBO.getOrgMap())) {
                Map orgMap = abilityRspBO.getOrgMap();
                fscOrderPO.setOperationName(((UmcDycEnterpriseOrgBO)orgMap.get(Long.valueOf(fscOrderPO.getOperationNo()))).getOrgName());
            }
            if (reqBO.getWebSource() != null && reqBO.getWebSource().equals(FscConstants.FscWebSource.AGR_DOWN) && !order.getOrderState().equals(FscConstants.FscInvoiceOrderState.UNBILLED)) {
                this.validSendAndPurchaseCount(order, fscOrderItemList);
                this.dealWorkFlow(order);
            } else if (reqBO.getWebSource() != null && !order.getOrderState().equals(FscConstants.FscInvoiceOrderState.UNBILLED)) {
                this.dealWorkFlow(order);
            }
            if (FscConstants.FscInvoiceOrderState.APPROVAL_REJECT.equals(order.getOrderState())) {
                fscOrderPO.setOrderState(FscConstants.FscInvoiceOrderState.AUDITING);
            }
            this.fscOrderMapper.updateById(fscOrderPO);
            try {
                this.taskTodoWaitService.syncNotifyAccountWaitDone(order.getFscOrderId());
            }
            catch (Exception e2) {
                log.error("dealCreate -\u901a\u77e5\u5f85\u529e\u5931\u8d25- error:{}", (Throwable)e2);
            }
        }
        rspBO.setRespCode("0000");
        rspBO.setRespDesc("\u6210\u529f");
        rspBO.setPushOrderIds(pushOrderIds);
        return rspBO;
    }

    @Override
    public FscCheckTempBusiRspBO qryCheckTemp(FscCheckTempBusiReqBO reqBO) {
        FscCheckTempBusiRspBO rspBO = new FscCheckTempBusiRspBO();
        FscCheckTempPO busiReqBO = (FscCheckTempPO)JSONObject.parseObject((String)JSONObject.toJSONString((Object)((Object)reqBO)), FscCheckTempPO.class);
        Page page = new Page(reqBO.getPageNo().intValue(), reqBO.getPageSize().intValue());
        List list = this.fscCheckTempMapper.getList(busiReqBO, page);
        List fscCheckTempBusiBOS = JSONObject.parseArray((String)JSONObject.toJSONString((Object)list), FscCheckTempBusiBO.class);
        rspBO.setRows(fscCheckTempBusiBOS);
        rspBO.setPageNo(page.getPageNo());
        rspBO.setRecordsTotal(page.getTotalCount());
        rspBO.setTotal(page.getTotalPages());
        busiReqBO.setType("0");
        int listCount = this.fscCheckTempMapper.getListCount(busiReqBO);
        rspBO.setType("0");
        if (listCount > 0) {
            rspBO.setType("1");
        }
        return rspBO;
    }

    @Override
    public FscSaleCheckBusiRspBO checkSaleOrder(FscSaleCheckBusiReqBO reqBO) {
        Map<Object, Object> settltItemMap;
        FscSaleCheckBusiRspBO rspBO = new FscSaleCheckBusiRspBO();
        ArrayList<Long> inspectionVoucherIdList = new ArrayList<Long>();
        for (RelOrderBO relOrderBO : reqBO.getRelOrderList()) {
            inspectionVoucherIdList.add(relOrderBO.getAcceptOrderId());
        }
        FscAcceptOrderListQueryAtomReqBO fscAcceptOrderListQueryAtomReqBO = new FscAcceptOrderListQueryAtomReqBO();
        fscAcceptOrderListQueryAtomReqBO.setInspectionVoucherIdList(inspectionVoucherIdList);
        fscAcceptOrderListQueryAtomReqBO.setReceiveType(reqBO.getReceiveType());
        if (FscConstants.FscOrderReceiveType.PURCHASE.equals(reqBO.getReceiveType()) && FscConstants.FscOrderMakeType.ELECTRONIC_COMMERCE.equals(reqBO.getMakeType())) {
            fscAcceptOrderListQueryAtomReqBO.setReceiveType(FscConstants.FscOrderReceiveType.OPERATION);
        }
        fscAcceptOrderListQueryAtomReqBO.setRelType(FscConstants.FscRelType.TRADE_INVOICE);
        if (FscConstants.FscOrderReceiveType.OPERATION.equals(reqBO.getReceiveType())) {
            fscAcceptOrderListQueryAtomReqBO.setRelType(FscConstants.FscRelType.PRO_INVOICE);
        }
        if (FscConstants.FscOrderReceiveType.PURCHASE.equals(reqBO.getReceiveType()) && !FscConstants.FscOrderMakeType.OPERTION.equals(reqBO.getMakeType())) {
            fscAcceptOrderListQueryAtomReqBO.setRelType(FscConstants.FscRelType.MATCH_INVOICE);
        }
        if (FscConstants.FscOrderReceiveType.INDIVIDUAL.equals(reqBO.getReceiveType())) {
            fscAcceptOrderListQueryAtomReqBO.setRelType(FscConstants.FscRelType.INDIVIDUAL_TYPE);
        }
        fscAcceptOrderListQueryAtomReqBO.setRelState(FscConstants.FscRelStatus.UNCOMMITTED);
        if (reqBO.getOpenInvoiceType() != null) {
            fscAcceptOrderListQueryAtomReqBO.setOpenInvoiceType(reqBO.getOpenInvoiceType());
        }
        fscAcceptOrderListQueryAtomReqBO.setCheckVerification("1");
        log.debug("\u4e3b\u5355\u5f00\u7968\u67e5\u8be2\u9a8c\u6536\u5355\u4fe1\u606f\u5165\u53c2\uff1a{}", (Object)JSON.toJSONString((Object)fscAcceptOrderListQueryAtomReqBO));
        FscAcceptOrderListQueryAtomRspBO fscAcceptOrderListQueryAtomRspBO = this.fscAcceptOrderListQueryAtomService.query(fscAcceptOrderListQueryAtomReqBO);
        log.debug("\u4e3b\u5355\u5f00\u7968\u67e5\u8be2\u9a8c\u6536\u5355\u4fe1\u606f\u51fa\u53c2\uff1a{}", (Object)JSON.toJSONString((Object)fscAcceptOrderListQueryAtomRspBO));
        if (null == fscAcceptOrderListQueryAtomRspBO.getFscOrderInfoBoMap() || fscAcceptOrderListQueryAtomRspBO.getFscOrderInfoBoMap().size() != inspectionVoucherIdList.size()) {
            throw new FscBusinessException("191014", "\u8c03\u7528\u8ba2\u5355\u4e2d\u5fc3\u67e5\u8be2\u8ba2\u5355\u4fe1\u606f\u4e3a\u7a7a");
        }
        if (!this.checkTaxCode(fscAcceptOrderListQueryAtomRspBO, reqBO)) {
            throw new FscBusinessException("190000", "\u6210\u54c1\u6cb9\u7c7b\u7684\u5546\u54c1\u4e0d\u80fd\u548c\u5176\u4ed6\u7c7b\u7684\u5546\u54c1\u4e00\u8d77\u53d1\u8d77\u7ed3\u7b97\u5f00\u7968\uff0c\u8bf7\u91cd\u65b0\u52fe\u9009\u53d1\u8d77");
        }
        if (reqBO.getFscOrderId() != null) {
            FscOrderItemPO fscOrderItemPO = new FscOrderItemPO();
            fscOrderItemPO.setFscOrderId(reqBO.getFscOrderId());
            List fscOrderItemList = this.fscOrderItemMapper.getList(fscOrderItemPO);
            settltItemMap = !CollectionUtils.isEmpty((Collection)fscOrderItemList) ? fscOrderItemList.stream().collect(Collectors.toMap(FscOrderItemPO::getOrderItemId, Function.identity(), (k1, k2) -> k1)) : new HashMap();
        } else {
            settltItemMap = null;
        }
        ArrayList list = new ArrayList();
        Long fscOrderId = Sequence.getInstance().nextId();
        Map<Object, Object> acceptMap = !CollectionUtils.isEmpty(reqBO.getRelOrderList()) ? reqBO.getRelOrderList().stream().collect(Collectors.toMap(RelOrderBO::getAcceptOrderId, RelOrderBO::getFscOrderItemBOList, (k1, k2) -> k1)) : new HashMap();
        fscAcceptOrderListQueryAtomRspBO.getFscOrderInfoBoMap().forEach((key, val) -> {
            Map<Object, Object> acceptItemMap = !CollectionUtils.isEmpty((Map)acceptMap) && Objects.nonNull(acceptMap.get(key)) ? ((List)acceptMap.get(key)).stream().collect(Collectors.toMap(FscOrderItemReqBO::getInspectionItemId, Function.identity(), (k1, k2) -> k1)) : new HashMap();
            val.getFscOrderItemBOS().forEach(e -> {
                if (!CollectionUtils.isEmpty((Map)acceptItemMap) && Objects.nonNull(acceptItemMap.get(e.getOrderItemId()))) {
                    FscCheckTempPO po;
                    FscOrderItemReqBO fscOrderItemReqBO = (FscOrderItemReqBO)acceptItemMap.get(e.getOrderItemId());
                    if (fscOrderItemReqBO.getAmt().compareTo(BigDecimal.ZERO) == 0) {
                        return;
                    }
                    if (StringUtils.isNotBlank((CharSequence)fscOrderItemReqBO.getProductDescription()) && FscCommonUtils.getLength((String)fscOrderItemReqBO.getProductDescription()) > 90) {
                        po = new FscCheckTempPO();
                        if (!StringUtils.isBlank((CharSequence)reqBO.getFscOrderNo())) {
                            po.setObjNo(reqBO.getFscOrderNo());
                        }
                        po.setObjId(fscOrderId);
                        po.setOrderId(String.valueOf(val.getOrderId()));
                        po.setOrderNo(val.getOrderNo());
                        po.setSkuName(e.getSkuName());
                        po.setType("0");
                        po.setReason("\u5f00\u7968\u540d\u79f0\u5b57\u6bb5\u9650\u523690\u5b57\u7b26");
                        list.add(po);
                    }
                    if (StringUtils.isBlank((CharSequence)fscOrderItemReqBO.getSpecificationsModel())) {
                        po = new FscCheckTempPO();
                        if (!StringUtils.isBlank((CharSequence)reqBO.getFscOrderNo())) {
                            po.setObjNo(reqBO.getFscOrderNo());
                        }
                        po.setObjId(fscOrderId);
                        po.setOrderId(String.valueOf(val.getOrderId()));
                        po.setOrderNo(val.getOrderNo());
                        po.setSkuName(e.getSkuName());
                        po.setType("1");
                        po.setReason("\u89c4\u683c\u578b\u53f7\u4e3a\u7a7a");
                        list.add(po);
                    }
                    if (StringUtils.isNotBlank((CharSequence)fscOrderItemReqBO.getSpecificationsModel()) && FscCommonUtils.getLength((String)fscOrderItemReqBO.getSpecificationsModel()) > 40) {
                        po = new FscCheckTempPO();
                        if (!StringUtils.isBlank((CharSequence)reqBO.getFscOrderNo())) {
                            po.setObjNo(reqBO.getFscOrderNo());
                        }
                        po.setObjId(fscOrderId);
                        po.setOrderId(String.valueOf(val.getOrderId()));
                        po.setOrderNo(val.getOrderNo());
                        po.setSkuName(e.getSkuName());
                        po.setType("0");
                        po.setReason("\u89c4\u683c\u578b\u53f7\u5b57\u6bb5\u957f\u5ea6\u9650\u523640\u5b57\u7b26");
                        list.add(po);
                    }
                } else {
                    FscCheckTempPO po;
                    if (CollectionUtils.isEmpty((Map)settltItemMap) && e.getAmt().compareTo(BigDecimal.ZERO) == 0) {
                        return;
                    }
                    if (!CollectionUtils.isEmpty((Map)settltItemMap) && Objects.isNull(settltItemMap.get(e.getOrderItemId()))) {
                        return;
                    }
                    FscOrderItemPO fscOrderItemPO = (FscOrderItemPO)JSONObject.parseObject((String)JSONObject.toJSONString((Object)e), FscOrderItemPO.class);
                    this.dealDescAndModel(fscOrderItemPO, reqBO);
                    if (!CollectionUtils.isEmpty((Map)settltItemMap) && settltItemMap.get(fscOrderItemPO.getOrderItemId()) != null) {
                        FscOrderItemPO itemPO = (FscOrderItemPO)settltItemMap.get(fscOrderItemPO.getOrderItemId());
                        fscOrderItemPO.setSpecificationsModel(itemPO.getSpecificationsModel());
                        fscOrderItemPO.setProductDescription(itemPO.getProductDescription());
                    }
                    if (StringUtils.isNotBlank((CharSequence)fscOrderItemPO.getProductDescription()) && FscCommonUtils.getLength((String)fscOrderItemPO.getProductDescription()) > 90) {
                        po = new FscCheckTempPO();
                        if (!StringUtils.isBlank((CharSequence)reqBO.getFscOrderNo())) {
                            po.setObjNo(reqBO.getFscOrderNo());
                        }
                        po.setObjId(fscOrderId);
                        po.setOrderId(String.valueOf(val.getOrderId()));
                        po.setOrderNo(val.getOrderNo());
                        po.setSkuName(e.getSkuName());
                        po.setType("0");
                        po.setReason("\u5f00\u7968\u540d\u79f0\u5b57\u6bb5\u9650\u523690\u5b57\u7b26");
                        list.add(po);
                    }
                    if (StringUtils.isBlank((CharSequence)fscOrderItemPO.getSpecificationsModel())) {
                        po = new FscCheckTempPO();
                        if (!StringUtils.isBlank((CharSequence)reqBO.getFscOrderNo())) {
                            po.setObjNo(reqBO.getFscOrderNo());
                        }
                        po.setObjId(fscOrderId);
                        po.setOrderId(String.valueOf(val.getOrderId()));
                        po.setOrderNo(val.getOrderNo());
                        po.setSkuName(e.getSkuName());
                        po.setType("1");
                        po.setReason("\u89c4\u683c\u578b\u53f7\u4e3a\u7a7a");
                        list.add(po);
                    }
                    if (StringUtils.isNotBlank((CharSequence)fscOrderItemPO.getSpecificationsModel()) && FscCommonUtils.getLength((String)fscOrderItemPO.getSpecificationsModel()) > 40) {
                        po = new FscCheckTempPO();
                        if (!StringUtils.isBlank((CharSequence)reqBO.getFscOrderNo())) {
                            po.setObjNo(reqBO.getFscOrderNo());
                        }
                        po.setObjId(fscOrderId);
                        po.setOrderId(String.valueOf(val.getOrderId()));
                        po.setOrderNo(val.getOrderNo());
                        po.setSkuName(e.getSkuName());
                        po.setType("0");
                        po.setReason("\u89c4\u683c\u578b\u53f7\u5b57\u6bb5\u957f\u5ea6\u9650\u523640\u5b57\u7b26");
                        list.add(po);
                    }
                }
            });
        });
        try {
            this.fscCheckTempMapper.deleteByObjId(fscOrderId);
            if (!CollectionUtils.isEmpty(list)) {
                this.fscCheckTempMapper.insertBatch(list);
                rspBO.setFscOrderId(fscOrderId);
            }
        }
        catch (Exception e) {
            log.error("\u6821\u9a8c\u5f00\u7968\u540d\u79f0\u548c\u89c4\u683c\u578b\u53f7\u63d2\u5165\u6570\u636e\u5e93\u9519\u8bef\uff01" + e);
            throw new FscBusinessException("190000", "\u6821\u9a8c\u5f00\u7968\u540d\u79f0\u548c\u89c4\u683c\u578b\u53f7\u63d2\u5165\u6570\u636e\u5e93\u9519\u8bef\uff01");
        }
        rspBO.setRespCode("0000");
        rspBO.setRespDesc("\u6210\u529f");
        return rspBO;
    }

    private boolean checkTaxCode(FscAcceptOrderListQueryAtomRspBO respBo, FscSaleCheckBusiReqBO reqBO) {
        List<RelOrderBO> relOrderList = reqBO.getRelOrderList();
        ArrayList fscOrderItemBOList = new ArrayList();
        for (RelOrderBO relOrderBO : relOrderList) {
            fscOrderItemBOList.addAll(relOrderBO.getFscOrderItemBOList());
        }
        Map map = respBo.getFscOrderInfoBoMap();
        ArrayList list = new ArrayList();
        for (Map.Entry entry : map.entrySet()) {
            FscOrderInfoBO orderInfoBO = (FscOrderInfoBO)entry.getValue();
            list.addAll(orderInfoBO.getFscOrderItemBOS());
        }
        for (FscOrderItemReqBO fscOrderItemReqBO : fscOrderItemBOList) {
            for (FscOrderItemBO fscOrderItemBO : list) {
                if (fscOrderItemReqBO.getInspectionItemId().intValue() != fscOrderItemBO.getOrderItemId().intValue()) continue;
                fscOrderItemBO.setNum(fscOrderItemReqBO.getNum());
                fscOrderItemBO.setAmt(fscOrderItemReqBO.getAmt());
            }
        }
        FscOrderItemBO orderItemFirst = new FscOrderItemBO();
        for (FscOrderItemBO entity : list) {
            if (entity.getTaxCode() == null || entity.getAmt() == null || entity.getNum() == null || entity.getAmt().compareTo(BigDecimal.ZERO) == 0 || entity.getNum().compareTo(BigDecimal.ZERO) == 0) continue;
            orderItemFirst = entity;
            break;
        }
        if (!CollectionUtils.isEmpty(list)) {
            for (FscOrderItemBO entity : list) {
                if (orderItemFirst == null || orderItemFirst.getTaxCode() == null || (orderItemFirst.getTaxCode().indexOf("10701010") != 0 || entity.getTaxCode().indexOf("10701010") == 0 || entity.getNum() == null || entity.getNum().compareTo(BigDecimal.ZERO) == 0 || entity.getAmt() == null || entity.getAmt().compareTo(BigDecimal.ZERO) == 0) && (orderItemFirst.getTaxCode().indexOf("10701010") == 0 || entity.getTaxCode().indexOf("10701010") != 0 || entity.getNum() == null || entity.getNum().compareTo(BigDecimal.ZERO) == 0 || entity.getAmt() == null || entity.getAmt().compareTo(BigDecimal.ZERO) == 0)) continue;
                return false;
            }
        }
        return true;
    }

    @Override
    public FscSaleCheckAbilityRspBO checkUpdateData(FscSaleCheckDataReqBO reqBO) {
        FscOrderItemPO fscOrderItemPO = new FscOrderItemPO();
        fscOrderItemPO.setFscOrderId(reqBO.getFscOrderId());
        FscSaleCheckAbilityRspBO rspBO = new FscSaleCheckAbilityRspBO();
        if (reqBO.getFscOrderId() == null) {
            rspBO.setRespCode("190000");
            rspBO.setRespDesc("\u5931\u8d25");
            return rspBO;
        }
        List fscOrderItemList = this.fscOrderItemMapper.getList(fscOrderItemPO);
        if (CollectionUtils.isEmpty((Collection)fscOrderItemList)) {
            log.error("\u5165\u53c2\u7ed3\u7b97\u5355\u53f7" + reqBO.getFscOrderId());
            throw new FscBusinessException("190000", "\u672a\u67e5\u8be2\u5230\u5bf9\u5e94\u7684\u7ed3\u7b97\u5355\u660e\u7ec6\u6570\u636e\uff01");
        }
        Map<Object, Object> fscOrderItemMap = !CollectionUtils.isEmpty(reqBO.getFscOrderItemBOList()) ? reqBO.getFscOrderItemBOList().stream().collect(Collectors.toMap(FscOrderItemReqBO::getId, Function.identity(), (k1, k2) -> k1)) : new HashMap();
        ArrayList list = new ArrayList();
        fscOrderItemList.forEach(e -> {
            if (!CollectionUtils.isEmpty((Map)fscOrderItemMap) && Objects.nonNull(fscOrderItemMap.get(e.getId()))) {
                FscCheckTempPO po;
                FscOrderItemReqBO fscOrderItemReqBO = (FscOrderItemReqBO)fscOrderItemMap.get(e.getId());
                if (StringUtils.isNotBlank((CharSequence)fscOrderItemReqBO.getProductDescription()) && FscCommonUtils.getLength((String)fscOrderItemReqBO.getProductDescription()) > 90) {
                    po = new FscCheckTempPO();
                    if (!StringUtils.isBlank((CharSequence)reqBO.getFscOrderNo())) {
                        po.setObjNo(reqBO.getFscOrderNo());
                    }
                    po.setObjId(reqBO.getFscOrderId());
                    po.setOrderId(String.valueOf(e.getOrderId()));
                    po.setOrderNo(e.getOrderCode());
                    po.setSkuName(e.getSkuName());
                    po.setType("0");
                    po.setReason("\u5f00\u7968\u540d\u79f0\u5b57\u6bb5\u9650\u523690\u5b57\u7b26");
                    list.add(po);
                }
                if (StringUtils.isBlank((CharSequence)fscOrderItemReqBO.getSpecificationsModel())) {
                    po = new FscCheckTempPO();
                    if (!StringUtils.isBlank((CharSequence)reqBO.getFscOrderNo())) {
                        po.setObjNo(reqBO.getFscOrderNo());
                    }
                    po.setObjId(e.getFscOrderId());
                    po.setOrderId(String.valueOf(e.getOrderId()));
                    po.setOrderNo(e.getOrderCode());
                    po.setSkuName(e.getSkuName());
                    po.setType("1");
                    po.setReason("\u89c4\u683c\u578b\u53f7\u4e3a\u7a7a");
                    list.add(po);
                }
                if (StringUtils.isNotBlank((CharSequence)fscOrderItemReqBO.getSpecificationsModel()) && FscCommonUtils.getLength((String)fscOrderItemReqBO.getSpecificationsModel()) > 40) {
                    po = new FscCheckTempPO();
                    if (!StringUtils.isBlank((CharSequence)reqBO.getFscOrderNo())) {
                        po.setObjNo(reqBO.getFscOrderNo());
                    }
                    po.setObjId(e.getFscOrderId());
                    po.setOrderId(String.valueOf(e.getOrderId()));
                    po.setOrderNo(e.getOrderCode());
                    po.setSkuName(e.getSkuName());
                    po.setType("0");
                    po.setReason("\u89c4\u683c\u578b\u53f7\u5b57\u6bb5\u957f\u5ea6\u9650\u523640\u5b57\u7b26");
                    list.add(po);
                }
            } else {
                FscCheckTempPO po;
                e.setProductDescription(StringUtils.isEmpty((CharSequence)e.getProductDescriptionTemp()) ? e.getProductDescription() : e.getProductDescriptionTemp());
                e.setSpecificationsModel(StringUtils.isEmpty((CharSequence)e.getSpecificationsModelTemp()) ? e.getSpecificationsModel() : e.getSpecificationsModelTemp());
                if (StringUtils.isNotBlank((CharSequence)e.getProductDescription()) && FscCommonUtils.getLength((String)e.getProductDescription()) > 90) {
                    po = new FscCheckTempPO();
                    if (!StringUtils.isBlank((CharSequence)reqBO.getFscOrderNo())) {
                        po.setObjNo(reqBO.getFscOrderNo());
                    }
                    po.setObjId(reqBO.getFscOrderId());
                    po.setOrderId(String.valueOf(e.getOrderId()));
                    po.setOrderNo(e.getOrderCode());
                    po.setSkuName(e.getSkuName());
                    po.setType("0");
                    po.setReason("\u5f00\u7968\u540d\u79f0\u5b57\u6bb5\u9650\u523690\u5b57\u7b26");
                    list.add(po);
                }
                if (StringUtils.isBlank((CharSequence)e.getSpecificationsModel())) {
                    po = new FscCheckTempPO();
                    if (!StringUtils.isBlank((CharSequence)reqBO.getFscOrderNo())) {
                        po.setObjNo(reqBO.getFscOrderNo());
                    }
                    po.setObjId(reqBO.getFscOrderId());
                    po.setOrderId(String.valueOf(e.getOrderId()));
                    po.setOrderNo(e.getOrderCode());
                    po.setSkuName(e.getSkuName());
                    po.setType("1");
                    po.setReason("\u89c4\u683c\u578b\u53f7\u4e3a\u7a7a");
                    list.add(po);
                }
                if (StringUtils.isNotBlank((CharSequence)e.getSpecificationsModel()) && FscCommonUtils.getLength((String)e.getSpecificationsModel()) > 40) {
                    po = new FscCheckTempPO();
                    if (!StringUtils.isBlank((CharSequence)reqBO.getFscOrderNo())) {
                        po.setObjNo(reqBO.getFscOrderNo());
                    }
                    po.setObjId(reqBO.getFscOrderId());
                    po.setOrderId(String.valueOf(e.getOrderId()));
                    po.setOrderNo(e.getOrderCode());
                    po.setSkuName(e.getSkuName());
                    po.setType("0");
                    po.setReason("\u89c4\u683c\u578b\u53f7\u5b57\u6bb5\u957f\u5ea6\u9650\u523640\u5b57\u7b26");
                    list.add(po);
                }
            }
        });
        try {
            this.fscCheckTempMapper.deleteByObjId(reqBO.getFscOrderId());
            if (!CollectionUtils.isEmpty(list)) {
                this.fscCheckTempMapper.insertBatch(list);
                rspBO.setFscOrderId(reqBO.getFscOrderId());
            }
        }
        catch (Exception e2) {
            log.error("\u6821\u9a8c\u5f00\u7968\u540d\u79f0\u548c\u89c4\u683c\u578b\u53f7\u63d2\u5165\u6570\u636e\u5e93\u9519\u8bef\uff01");
            e2.printStackTrace();
            throw new FscBusinessException("190000", "\u6821\u9a8c\u5f00\u7968\u540d\u79f0\u548c\u89c4\u683c\u578b\u53f7\u63d2\u5165\u6570\u636e\u5e93\u9519\u8bef\uff01");
        }
        rspBO.setRespCode("0000");
        rspBO.setRespDesc("\u6210\u529f");
        return rspBO;
    }

    @Override
    public FscSaleCheckAbilityRspBO saveFscIllustrate(FscUpdateIllustrateAbilityReqBO reqBO) {
        FscOrderPO po = new FscOrderPO();
        po.setFscOrderId(reqBO.getFscOrderId());
        FscOrderPO modelBy = this.fscOrderMapper.getModelBy(po);
        if (!FscBillStatus.INVOICING_TO_BE_CONFIRM.getCode().equals(modelBy.getOrderState())) {
            throw new FscBusinessException("198888", "\u8be5\u7ed3\u7b97\u5355\u4e0d\u662f\u5f85\u786e\u8ba4\u72b6\u6001\uff0c\u4e0d\u5141\u8bb8\u4fdd\u5b58\u3002");
        }
        List collect = reqBO.getUpdateBos().stream().map(obj -> {
            FscOrderItemPO itemPO = new FscOrderItemPO();
            itemPO.setId(obj.getId());
            itemPO.setOrderId(obj.getOrderId());
            itemPO.setProductDescriptionTemp(obj.getProductDescription());
            itemPO.setSpecificationsModelTemp(obj.getSpecificationsModel());
            return itemPO;
        }).collect(Collectors.toList());
        this.fscOrderItemMapper.updateFscItemIllustrate(collect, reqBO.getFscOrderId());
        FscSaleCheckAbilityRspBO rspBO = new FscSaleCheckAbilityRspBO();
        rspBO.setRespCode("0000");
        rspBO.setRespDesc("\u6210\u529f");
        return rspBO;
    }

    private void dealWorkFlow(FscOrderPO fscOrderPo) {
        FscOrderStatusFlowAtomReqBO fscOrderStatusFlowAtomReqBO = new FscOrderStatusFlowAtomReqBO();
        fscOrderStatusFlowAtomReqBO.setBusiName(BUSI_NAME);
        fscOrderStatusFlowAtomReqBO.setOrderId(fscOrderPo.getFscOrderId());
        fscOrderStatusFlowAtomReqBO.setCurStatus(fscOrderPo.getOrderState());
        HashMap<String, Integer> paramMap = new HashMap<String, Integer>();
        paramMap.put("confirmFlag", FscConstants.BillOrderConfirmFlag.CONFIRM);
        fscOrderStatusFlowAtomReqBO.setParamMap(paramMap);
        FscOrderStatusFlowAtomRspBO fscOrderStatusFlowAtomRspBO = this.fscOrderStatusFlowAtomService.dealStatusFlow(fscOrderStatusFlowAtomReqBO);
        if (!fscOrderStatusFlowAtomRspBO.getRespCode().equals("0000")) {
            throw new FscBusinessException(fscOrderStatusFlowAtomRspBO.getRespCode(), fscOrderStatusFlowAtomRspBO.getRespDesc());
        }
    }

    private void validSendAndPurchaseCount(FscOrderPO order, List<FscOrderItemPO> fscOrderItemList) {
        if (Objects.nonNull(order.getOrderSource()) && !"2".equals(String.valueOf(order.getOrderSource()))) {
            return;
        }
        if (Objects.isNull(order.getPurchaserId())) {
            return;
        }
        ArrayList errorInfoList = new ArrayList();
        List<Long> orderIdList = fscOrderItemList.stream().map(FscOrderItemPO::getOrderId).distinct().collect(Collectors.toList());
        UocQryOrderItemAbilityReqBO uocQryOrderItemAbilityReqBO = new UocQryOrderItemAbilityReqBO();
        uocQryOrderItemAbilityReqBO.setOrderIdList(orderIdList);
        UocQryOrderItemListAbilityRspBO uocQryOrderItemListAbilityRspBO = this.uocPebQryOrderDetailAbilityService.qryOrderItemList(uocQryOrderItemAbilityReqBO);
        orderIdList.forEach(orderId -> {
            if (CollectionUtils.isEmpty((Map)uocQryOrderItemListAbilityRspBO.getOrderErpPushStateMap()) || Objects.isNull(uocQryOrderItemListAbilityRspBO.getOrderErpPushStateMap().get(orderId)) || 1 != (Integer)uocQryOrderItemListAbilityRspBO.getOrderErpPushStateMap().get(orderId)) {
                return;
            }
            if (CollectionUtils.isEmpty((Map)uocQryOrderItemListAbilityRspBO.getOrderItemMap()) || CollectionUtils.isEmpty((Collection)((Collection)uocQryOrderItemListAbilityRspBO.getOrderItemMap().get(orderId)))) {
                return;
            }
            List itemRspBOList = (List)uocQryOrderItemListAbilityRspBO.getOrderItemMap().get(orderId);
            StringBuilder sb = new StringBuilder();
            ArrayList skuIdList = new ArrayList();
            itemRspBOList.forEach(item -> {
                BigDecimal receiptCount = new BigDecimal(item.getExtField5());
                if (receiptCount.compareTo(BigDecimal.ZERO) > 0 && item.getArriveCount().subtract(item.getReturnCount()).compareTo(receiptCount) != 0 && Objects.nonNull(item.getSkuId())) {
                    skuIdList.add(String.valueOf(item.getSkuId()));
                }
            });
            if (!CollectionUtils.isEmpty(skuIdList)) {
                String orderNo = StringUtils.isNotBlank((CharSequence)((UocOrderItemRspBO)itemRspBOList.get(0)).getSaleVoucherNo()) ? ((UocOrderItemRspBO)itemRspBOList.get(0)).getSaleVoucherNo() : orderId.toString();
                sb.append("\u8ba2\u5355").append(orderNo).append("\u4e2d\uff0c\u5546\u54c1\uff1a");
                String skuIdInfo = String.join((CharSequence)"\uff0c", skuIdList);
                sb.append(skuIdInfo).append("\uff1b");
                errorInfoList.add(sb.toString());
            }
        });
        if (!CollectionUtils.isEmpty(errorInfoList)) {
            String errorInfo = String.join((CharSequence)"\uff1b", errorInfoList);
            throw new FscBusinessException("193008", errorInfo + "\u5b9e\u9645\u5165\u5e93\u6570\u91cf\u4e0e\u4f9b\u5e94\u5546\u59a5\u6295\u6570\u91cf\u4e0d\u4e00\u81f4\uff0c\u8bf7\u5728ERP\u8c03\u6574\u51fa\u5165\u5e93\u6570\u91cf\u6216\u5728\u5546\u57ce\u8fdb\u884c\u8ba2\u5355\u5f02\u5e38\u53d8\u66f4\u8c03\u6574\u5b9e\u9645\u5230\u8d27\u6570\u91cf\uff01");
        }
    }

    private Boolean invokeUacTask(FscBillSendSaleFscOrderApplyBusiReqBO reqBO, FscOrderPO order, Boolean individuallyPay) {
        UacNoTaskAuditCreateReqBO auditCreateReqBO = new UacNoTaskAuditCreateReqBO();
        auditCreateReqBO.setCreateOperId(reqBO.getUserId().toString());
        auditCreateReqBO.setCreateOperName(reqBO.getName());
        auditCreateReqBO.setCreateOperDept(reqBO.getOrgName());
        auditCreateReqBO.setIsSaveCreateLog(Boolean.valueOf(true));
        FscOrderPO fscOrderPO = new FscOrderPO();
        fscOrderPO.setFscOrderId(order.getFscOrderId());
        fscOrderPO = this.fscOrderMapper.getModelBy(fscOrderPO);
        if (individuallyPay.booleanValue()) {
            if (FscOrderSourceEnum.ELECTRIC_AREA.getCode().equals(fscOrderPO.getOrderSource()) && FscConstants.FscOrderMakeType.OPERTION.equals(fscOrderPO.getMakeType()) && FscConstants.FscOrderReceiveType.PURCHASE.equals(fscOrderPO.getReceiveType())) {
                auditCreateReqBO.setMenuId("FSC_ARGEE_DOWN_ORDER_INVOICE_PROCESS");
            } else {
                auditCreateReqBO.setMenuId("M001007");
            }
        } else {
            auditCreateReqBO.setMenuId("M001008");
        }
        auditCreateReqBO.setOrgId(reqBO.getOrgId().toString());
        ArrayList<UacNoTaskAuditCreateInfoReqBO> createBusiReqBO = new ArrayList<UacNoTaskAuditCreateInfoReqBO>();
        UacNoTaskAuditCreateInfoReqBO uacNoTaskAuditCreateInfoReqBO = new UacNoTaskAuditCreateInfoReqBO();
        uacNoTaskAuditCreateInfoReqBO.setObjType(FscConstants.AuditObjType.ORDER_INVOICE_APPROVAL);
        uacNoTaskAuditCreateInfoReqBO.setObjNum("1");
        uacNoTaskAuditCreateInfoReqBO.setOrderId(order.getFscOrderId());
        ArrayList<ApprovalObjBO> approvalObjBOList = new ArrayList<ApprovalObjBO>();
        ApprovalObjBO approvalObjBO = new ApprovalObjBO();
        approvalObjBO.setObjId(order.getFscOrderId().toString());
        approvalObjBO.setObjName("\u9500\u552e\u7ed3\u7b97\u5355\u5ba1\u6279");
        approvalObjBO.setObjType(FscConstants.AuditObjType.ORDER_INVOICE_APPROVAL);
        approvalObjBOList.add(approvalObjBO);
        uacNoTaskAuditCreateInfoReqBO.setApprovalObjInfo(approvalObjBOList);
        createBusiReqBO.add(uacNoTaskAuditCreateInfoReqBO);
        auditCreateReqBO.setCreateBusiReqBO(createBusiReqBO);
        this.checkExistProcess(order.getFscOrderId());
        log.info("\u5ba1\u6279\u5165\u53c2================" + JSON.toJSONString((Object)auditCreateReqBO));
        UacNoTaskAuditCreateRspBO uacNoTaskAuditCreateRspBO = this.uacNoTaskAuditCreateAbilityService.auditOrderCreate(auditCreateReqBO);
        log.info("\u5ba1\u6279\u51fa\u53c2================" + JSON.toJSONString((Object)uacNoTaskAuditCreateRspBO));
        if (!"0000".equals(uacNoTaskAuditCreateRspBO.getRespCode())) {
            throw new FscBusinessException("191019", uacNoTaskAuditCreateRspBO.getRespDesc());
        }
        FscTaskCandidatePO taskPo = new FscTaskCandidatePO();
        taskPo.setFscOrderId(order.getFscOrderId());
        List pendAuditPostIdList = this.fscTaskCandidateMapper.getPendAuditPostIdList(taskPo);
        if (!CollectionUtils.isEmpty((Collection)pendAuditPostIdList)) {
            Map orderTypeMap = this.fscDictionaryBusiService.queryBypCodeBackMap("FSC_ORDER_TYPE");
            String orderTypeStr = fscOrderPO.getOrderType() == 2 && fscOrderPO.getTradeMode() != null && fscOrderPO.getTradeMode() == 2 && fscOrderPO.getOrderSource() == 3 && fscOrderPO.getSettlePlatform() != null && fscOrderPO.getSettlePlatform() == 2 ? "\u81ea\u9700\u91c7\u8d2d" : (String)orderTypeMap.get(fscOrderPO.getOrderType() + "");
            DycStationOrgSelectUserNameReqBO dycStationOrgSelectUserNameReqBO = new DycStationOrgSelectUserNameReqBO();
            dycStationOrgSelectUserNameReqBO.setStationId(Long.valueOf(((FscApprovalTaskQueryBO)pendAuditPostIdList.get(0)).getTaskOperId()));
            DycStationOrgSelectUserNameRspBO dycStationOrgSelectUserNameRspBO = this.dycStationOrgSelectUserNameService.selectUserName(dycStationOrgSelectUserNameReqBO);
            if (dycStationOrgSelectUserNameRspBO != null && !CollectionUtils.isEmpty((Collection)dycStationOrgSelectUserNameRspBO.getUserList())) {
                FscSendNotificationExtAtomReqBO fscSendNotificationExtAtomReqBO = new FscSendNotificationExtAtomReqBO();
                fscSendNotificationExtAtomReqBO.setTitel(fscOrderPO.getOrderNo() + "\u9500\u552e\u7ed3\u7b97_" + orderTypeStr + "_" + fscOrderPO.getTotalCharge().setScale(2, RoundingMode.HALF_UP) + "\u5f85\u5ba1\u6279");
                fscSendNotificationExtAtomReqBO.setText("\u3010\u4e2d\u56fd\u4e2d\u7164\u3011\u60a8\u6709\u5f85\u5ba1\u6279\u7684\u9500\u552e\u7ed3\u7b97\u5355" + order.getOrderNo() + "\u5df2\u63d0\u4ea4\u81f3\u60a8\u5904\u5ba1\u6279\uff0c\u8bf7\u53ca\u65f6\u5904\u7406\u3002");
                fscSendNotificationExtAtomReqBO.setUserId(reqBO.getUserId());
                fscSendNotificationExtAtomReqBO.setReceiveIds(dycStationOrgSelectUserNameRspBO.getUserList().stream().map(UserBO::getUserId).distinct().collect(Collectors.toList()));
                this.fscSendNotificationExtAtomService.sendNotification(fscSendNotificationExtAtomReqBO);
            }
        }
        return uacNoTaskAuditCreateRspBO.getNotFindFlag();
    }

    public void dealDescAndModel(FscOrderItemPO fscOrderItemPO, FscSaleCheckBusiReqBO reqBO) {
        if ("2".equals(reqBO.getOrderSource())) {
            if (FscInvoiceValueTypeEnum.AGREE_MATERIAL.getCode().equals(reqBO.getInvoiceValueType()) && StringUtils.isNotBlank((CharSequence)fscOrderItemPO.getSkuMaterialName())) {
                fscOrderItemPO.setProductDescription(fscOrderItemPO.getSkuMaterialName());
                fscOrderItemPO.setSpecificationsModel(this.dealSpecificationsModel(fscOrderItemPO.getMaterialSpec(), fscOrderItemPO.getMaterialModel(), fscOrderItemPO.getMaterialBj(), fscOrderItemPO.getSkuMaterialId(), reqBO.getOrderSource()));
            } else {
                fscOrderItemPO.setProductDescription(fscOrderItemPO.getSkuName());
                fscOrderItemPO.setSpecificationsModel(this.dealSpecificationsModel(fscOrderItemPO.getSpec(), fscOrderItemPO.getModel(), null, null, reqBO.getOrderSource()));
            }
        } else if ("1".equals(reqBO.getOrderSource())) {
            if (FscInvoiceValueTypeEnum.PLAN_MATERIAL.getCode().equals(reqBO.getInvoiceValueType()) && StringUtils.isNotBlank((CharSequence)fscOrderItemPO.getPlanItemName())) {
                fscOrderItemPO.setProductDescription(fscOrderItemPO.getPlanItemName());
                fscOrderItemPO.setSpecificationsModel(this.dealSpecificationsModel(fscOrderItemPO.getPlanItemSpecification(), null, fscOrderItemPO.getMaterialBj(), fscOrderItemPO.getPlanItemCode(), reqBO.getOrderSource()));
            } else if (FscInvoiceValueTypeEnum.ELECTRONIC.getCode().equals(reqBO.getInvoiceValueType()) && StringUtils.isNotBlank((CharSequence)fscOrderItemPO.getSkuName())) {
                fscOrderItemPO.setProductDescription(fscOrderItemPO.getSkuName());
                fscOrderItemPO.setSpecificationsModel(this.dealSpecificationsModel(fscOrderItemPO.getSpec(), fscOrderItemPO.getModel(), null, null, reqBO.getOrderSource()));
            } else {
                fscOrderItemPO.setProductDescription(fscOrderItemPO.getSkuMaterialName());
                fscOrderItemPO.setSpecificationsModel(this.dealSpecificationsModel(fscOrderItemPO.getSpec(), fscOrderItemPO.getModel(), fscOrderItemPO.getMaterialBj(), fscOrderItemPO.getSkuMaterialId(), reqBO.getOrderSource()));
            }
        }
    }

    public String dealSpecificationsModel(String spec, String model, String materialBJ, String materialId, String orderSource) {
        if (!org.springframework.util.StringUtils.isEmpty((Object)materialId) && materialId.startsWith("61")) {
            return "";
        }
        String specificationsModel = "";
        specificationsModel = !org.springframework.util.StringUtils.isEmpty((Object)spec) && !org.springframework.util.StringUtils.isEmpty((Object)model) && !org.springframework.util.StringUtils.isEmpty((Object)materialBJ) ? spec + "|" + model + "|" + materialBJ : (!org.springframework.util.StringUtils.isEmpty((Object)spec) && !org.springframework.util.StringUtils.isEmpty((Object)model) ? spec + "|" + model : (!org.springframework.util.StringUtils.isEmpty((Object)model) && !org.springframework.util.StringUtils.isEmpty((Object)materialBJ) ? model + "|" + materialBJ : (!org.springframework.util.StringUtils.isEmpty((Object)spec) && !org.springframework.util.StringUtils.isEmpty((Object)materialBJ) ? spec + "|" + materialBJ : (!org.springframework.util.StringUtils.isEmpty((Object)spec) ? spec : (!org.springframework.util.StringUtils.isEmpty((Object)model) ? model : materialBJ)))));
        if (!"2".equals(orderSource) && !org.springframework.util.StringUtils.isEmpty((Object)specificationsModel) && specificationsModel.length() > 40) {
            return specificationsModel.substring(0, 40);
        }
        return specificationsModel;
    }

    private void checkExistProcess(Long fscOrderId) {
        int count = this.fscOrderMapper.selectStepIdCount(fscOrderId, FscConstants.AuditObjType.ORDER_INVOICE_APPROVAL);
        if (count > 0) {
            throw new FscBusinessException("191019", "\u8be5\u5355\u636e\u5df2\u63d0\u4ea4\u5ba1\u6279");
        }
    }
}

