/*
 * Decompiled with CFR 0.152.
 */
package com.tydic.fsc.bill.busi.impl;

import com.alibaba.fastjson.JSON;
import com.ohaotian.plugin.db.Sequence;
import com.tydic.fsc.bill.busi.api.FscBillSyncTongYiPayResultBusiService;
import com.tydic.fsc.bill.busi.bo.FscBillSyncTongYiPayResultBusiReqBO;
import com.tydic.fsc.bill.busi.bo.FscBillSyncTongYiPayResultBusiRspBO;
import com.tydic.fsc.busibase.atom.api.FscOrderStatusFlowAtomService;
import com.tydic.fsc.busibase.atom.bo.FscOrderStatusFlowAtomReqBO;
import com.tydic.fsc.busibase.atom.bo.FscOrderStatusFlowAtomRspBO;
import com.tydic.fsc.constants.FscConstants;
import com.tydic.fsc.dao.FscOrderMapper;
import com.tydic.fsc.dao.FscOrderRefundMapper;
import com.tydic.fsc.dao.FscPurchasePushLogMapper;
import com.tydic.fsc.exception.FscBusinessException;
import com.tydic.fsc.po.FscOrderPO;
import com.tydic.fsc.po.FscOrderRefundPO;
import com.tydic.fsc.po.FscPurchasePushLogPo;
import java.math.BigDecimal;
import java.util.Date;
import java.util.HashMap;
import java.util.Objects;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;
import org.springframework.beans.factory.annotation.Autowired;
import org.springframework.stereotype.Service;
import org.springframework.util.CollectionUtils;

@Service
public class FscBillSyncTongYiPayResultBusiServiceImpl
implements FscBillSyncTongYiPayResultBusiService {
    private static final Logger log = LoggerFactory.getLogger(FscBillSyncTongYiPayResultBusiServiceImpl.class);
    @Autowired
    private FscOrderMapper fscOrderMapper;
    @Autowired
    private FscOrderStatusFlowAtomService fscOrderStatusFlowAtomService;
    @Autowired
    private FscPurchasePushLogMapper fscPurchasePushLogMapper;
    @Autowired
    private FscOrderRefundMapper fscOrderRefundMapper;
    private static String PAY_RESULT_SUCCESS = "0002";
    private static String PAY_RESULT_FAIL = "0001";

    @Override
    public FscBillSyncTongYiPayResultBusiRspBO dealSyncTongYiPayResult(FscBillSyncTongYiPayResultBusiReqBO reqBO) {
        if (reqBO.getBillType() != null && reqBO.getBillType() == 2) {
            this.dealRefundPay(reqBO);
        } else {
            FscOrderPO fscOrderPO = new FscOrderPO();
            fscOrderPO.setFscOrderId(reqBO.getPayOrderId());
            fscOrderPO.setOrderNo(reqBO.getPayOrderNo());
            fscOrderPO.setOrderFlow(FscConstants.OrderFlow.PAY);
            FscOrderPO orderPO = this.fscOrderMapper.getModelBy(fscOrderPO);
            if (orderPO == null) {
                throw new FscBusinessException("190000", "\u672a\u67e5\u8be2\u5230\u4ed8\u6b3e\u5355\u4fe1\u606f");
            }
            FscOrderPO updatePO = new FscOrderPO();
            updatePO.setFscOrderId(reqBO.getPayOrderId());
            updatePO.setPayTime(reqBO.getPayTime());
            updatePO.setFailReason(reqBO.getFailReason());
            updatePO.setTransactionId(reqBO.getSerialNumber());
            updatePO.setPayMethod(reqBO.getPayMethod());
            this.fscOrderMapper.updateById(updatePO);
            Integer settlePlatForm = Objects.isNull(orderPO.getSettlePlatform()) ? 0 : orderPO.getSettlePlatform();
            if (settlePlatForm == 2 && FscConstants.FscPayOrderState.TO_PAY.equals(orderPO.getOrderState())) {
                FscOrderStatusFlowAtomReqBO fscOrderStatusFlowAtomReqBO = new FscOrderStatusFlowAtomReqBO();
                fscOrderStatusFlowAtomReqBO.setOrderId(orderPO.getFscOrderId());
                fscOrderStatusFlowAtomReqBO.setCurStatus(orderPO.getOrderState());
                HashMap<String, Integer> paramMap = new HashMap<String, Integer>(4);
                if (PAY_RESULT_SUCCESS.equals(reqBO.getPayStatus())) {
                    paramMap.put("confirmFlag", FscConstants.ProcessParam.confirmFlag1);
                } else if (PAY_RESULT_FAIL.equals(reqBO.getPayStatus())) {
                    paramMap.put("confirmFlag", FscConstants.ProcessParam.confirmFlag3);
                }
                if (!CollectionUtils.isEmpty(paramMap)) {
                    fscOrderStatusFlowAtomReqBO.setParamMap(paramMap);
                }
                log.debug("\u7edf\u4e00\u7ed3\u7b97\u5e73\u53f0\u4ed8\u6b3e\u7ed3\u679c\u56de\u4f20\u72b6\u6001\u6d41\u8f6c\u5165\u53c2\uff1a{}", (Object)JSON.toJSONString((Object)fscOrderStatusFlowAtomReqBO));
                FscOrderStatusFlowAtomRspBO fscOrderStatusFlowAtomRspBO = this.fscOrderStatusFlowAtomService.dealStatusFlow(fscOrderStatusFlowAtomReqBO);
                log.debug("\u7edf\u4e00\u7ed3\u7b97\u5e73\u53f0\u4ed8\u6b3e\u7ed3\u679c\u56de\u4f20\u72b6\u6001\u6d41\u8f6c\u51fa\u53c2\uff1a{}", (Object)JSON.toJSONString((Object)fscOrderStatusFlowAtomRspBO));
                if (!"0000".equals(fscOrderStatusFlowAtomRspBO.getRespCode())) {
                    throw new FscBusinessException("190000", fscOrderStatusFlowAtomRspBO.getRespDesc());
                }
            } else if (settlePlatForm == 1) {
                if (!FscConstants.FscPayOrderState.TY_PAYING.equals(orderPO.getOrderState()) && !FscConstants.FscPayOrderState.TY_POSTING_PASS.equals(orderPO.getOrderState())) {
                    throw new FscBusinessException("198888", "\u5f53\u524d\u4ed8\u6b3e\u5355\u636e\u72b6\u6001\u4e0d\u4e3a\u4ed8\u6b3e\u4e2d\u6216\u5df2\u8fc7\u5e10\uff01");
                }
                FscOrderStatusFlowAtomReqBO fscOrderStatusFlowAtomReqBO = new FscOrderStatusFlowAtomReqBO();
                fscOrderStatusFlowAtomReqBO.setOrderId(orderPO.getFscOrderId());
                fscOrderStatusFlowAtomReqBO.setCurStatus(orderPO.getOrderState());
                HashMap<String, Integer> paramMap = new HashMap<String, Integer>(4);
                if (PAY_RESULT_SUCCESS.equals(reqBO.getPayStatus())) {
                    paramMap.put("payResult", FscConstants.TyPayFlowPayResult.PASS);
                } else if (PAY_RESULT_FAIL.equals(reqBO.getPayStatus())) {
                    paramMap.put("payResult", FscConstants.TyPayFlowPayResult.FAIL);
                }
                if (!CollectionUtils.isEmpty(paramMap)) {
                    fscOrderStatusFlowAtomReqBO.setParamMap(paramMap);
                }
                log.debug("\u7edf\u4e00\u7ed3\u7b97\u5e73\u53f0\u4ed8\u6b3e\u7ed3\u679c\u56de\u4f20\u72b6\u6001\u6d41\u8f6c\u5165\u53c2\uff1a{}", (Object)JSON.toJSONString((Object)fscOrderStatusFlowAtomReqBO));
                FscOrderStatusFlowAtomRspBO fscOrderStatusFlowAtomRspBO = this.fscOrderStatusFlowAtomService.dealStatusFlow(fscOrderStatusFlowAtomReqBO);
                log.debug("\u7edf\u4e00\u7ed3\u7b97\u5e73\u53f0\u4ed8\u6b3e\u7ed3\u679c\u56de\u4f20\u72b6\u6001\u6d41\u8f6c\u51fa\u53c2\uff1a{}", (Object)JSON.toJSONString((Object)fscOrderStatusFlowAtomRspBO));
                if (!"0000".equals(fscOrderStatusFlowAtomRspBO.getRespCode())) {
                    throw new FscBusinessException("190000", fscOrderStatusFlowAtomRspBO.getRespDesc());
                }
            }
        }
        this.saveLog(reqBO.getPayOrderId(), reqBO.getPayOrderNo(), JSON.toJSONString((Object)reqBO));
        FscBillSyncTongYiPayResultBusiRspBO rspBO = new FscBillSyncTongYiPayResultBusiRspBO();
        rspBO.setRespCode("0000");
        rspBO.setRespDesc("\u6210\u529f");
        return rspBO;
    }

    private void dealRefundPay(FscBillSyncTongYiPayResultBusiReqBO reqBO) {
        FscOrderRefundPO refundPO = new FscOrderRefundPO();
        refundPO.setRefundId(reqBO.getPayOrderId());
        refundPO = this.fscOrderRefundMapper.getModelBy(refundPO);
        if (refundPO == null) {
            throw new FscBusinessException("198888", "\u672a\u67e5\u8be2\u5230\u9000\u6b3e\u5355\u636e\u4fe1\u606f\uff01");
        }
        BigDecimal hasRefundAmount = refundPO.getRefundAmount().subtract(refundPO.getActualRefundAmount());
        if (reqBO.getPayAmount().compareTo(hasRefundAmount) > 0) {
            throw new FscBusinessException("198888", "\u672c\u6b21\u6b3e\u91d1\u989d\u4e0d\u80fd\u5927\u4e8e\u9000\u6b3e\u5355\u672a\u9000\u6b3e\u91d1\u989d\uff01");
        }
        FscOrderRefundPO updateVo = new FscOrderRefundPO();
        updateVo.setRefundId(refundPO.getRefundId());
        updateVo.setRefundDate(reqBO.getPayTime());
        updateVo.setActualRefundAmount(refundPO.getActualRefundAmount().add(reqBO.getPayAmount()));
        this.fscOrderRefundMapper.updateById(updateVo);
        FscOrderStatusFlowAtomReqBO fscOrderStatusFlowAtomReqBO = new FscOrderStatusFlowAtomReqBO();
        fscOrderStatusFlowAtomReqBO.setOrderId(refundPO.getRefundId());
        fscOrderStatusFlowAtomReqBO.setCurStatus(refundPO.getRefundStatus());
        HashMap<String, Integer> paramMap = new HashMap<String, Integer>(8);
        if (PAY_RESULT_SUCCESS.equals(reqBO.getPayStatus())) {
            paramMap.put("confirmFlag", FscConstants.ProcessParam.confirmFlag1);
        } else if (PAY_RESULT_FAIL.equals(reqBO.getPayStatus())) {
            paramMap.put("confirmFlag", FscConstants.ProcessParam.confirmFlag3);
        }
        FscOrderStatusFlowAtomRspBO fscOrderStatusFlowAtomRspBO = this.fscOrderStatusFlowAtomService.dealStatusFlow(fscOrderStatusFlowAtomReqBO);
        if (!"0000".equals(fscOrderStatusFlowAtomRspBO.getRespCode())) {
            throw new FscBusinessException("190000", fscOrderStatusFlowAtomRspBO.getRespDesc());
        }
    }

    private void saveLog(Long objectId, String objectNo, String pushData) {
        FscPurchasePushLogPo purchasePushLogPo = new FscPurchasePushLogPo();
        purchasePushLogPo.setObjectId(objectId);
        purchasePushLogPo.setObjectNo(objectNo);
        purchasePushLogPo.setCreateTime(new Date());
        purchasePushLogPo.setType(FscConstants.FscPurchasePushType.ORDER_PAY_RESULT);
        purchasePushLogPo.setPushData(pushData);
        purchasePushLogPo.setId(Long.valueOf(Sequence.getInstance().nextId()));
        this.fscPurchasePushLogMapper.insert(purchasePushLogPo);
    }
}

