/*
 * Decompiled with CFR 0.152.
 */
package com.tydic.fsc.bill.busi.impl;

import com.alibaba.fastjson.JSON;
import com.ohaotian.plugin.base.exception.ZTBusinessException;
import com.tydic.authority.busi.api.DycStationOrgSelectUserNameService;
import com.tydic.authority.busi.bo.DycStationOrgSelectUserNameReqBO;
import com.tydic.authority.busi.bo.DycStationOrgSelectUserNameRspBO;
import com.tydic.authority.busi.bo.UserBO;
import com.tydic.fsc.bill.atom.api.FscBillOrderRefundChangeAtomService;
import com.tydic.fsc.bill.atom.bo.FscBillOrderRefundChangeAtomReqBO;
import com.tydic.fsc.bill.atom.bo.FscBillOrderRefundChangeAtomRspBO;
import com.tydic.fsc.bill.busi.api.FscComOrderRefundAgreeBusiService;
import com.tydic.fsc.bill.busi.bo.FscComOrderRefundAgreeBusiReqBO;
import com.tydic.fsc.bill.busi.bo.FscComOrderRefundAgreeBusiRspBO;
import com.tydic.fsc.bo.FscApprovalTaskQueryBO;
import com.tydic.fsc.busibase.atom.api.FscOrderStatusFlowAtomService;
import com.tydic.fsc.busibase.atom.api.FscSendNotificationExtAtomService;
import com.tydic.fsc.busibase.atom.bo.FscOrderStatusFlowAtomReqBO;
import com.tydic.fsc.busibase.atom.bo.FscOrderStatusFlowAtomRspBO;
import com.tydic.fsc.busibase.atom.bo.FscSendNotificationExtAtomReqBO;
import com.tydic.fsc.constants.FscConstants;
import com.tydic.fsc.dao.FscClaimDetailChangeMapper;
import com.tydic.fsc.dao.FscClaimDetailMapper;
import com.tydic.fsc.dao.FscOrderMapper;
import com.tydic.fsc.dao.FscOrderRefundMapper;
import com.tydic.fsc.dao.FscOrderRelationMapper;
import com.tydic.fsc.dao.FscTaskCandidateMapper;
import com.tydic.fsc.exception.FscBusinessException;
import com.tydic.fsc.pay.task.service.TaskTodoWaitService;
import com.tydic.fsc.po.FscClaimDetailChangePO;
import com.tydic.fsc.po.FscClaimDetailPO;
import com.tydic.fsc.po.FscOrderRefundPO;
import com.tydic.fsc.po.FscOrderRelationPO;
import com.tydic.fsc.po.FscTaskCandidatePO;
import com.tydic.uac.ability.UacNoTaskAuditCreateAbilityService;
import com.tydic.uac.ability.bo.UacNoTaskAuditCreateInfoReqBO;
import com.tydic.uac.ability.bo.UacNoTaskAuditCreateReqBO;
import com.tydic.uac.ability.bo.UacNoTaskAuditCreateRspBO;
import com.tydic.uac.bo.common.ApprovalObjBO;
import com.tydic.umc.general.ability.api.UmcEnterpriseOrgNameListQryAbilityService;
import com.tydic.umc.general.ability.bo.UmcDycEnterpriseOrgBO;
import com.tydic.umc.general.ability.bo.UmcEnterpriseOrgNameListQryAbilityReqBO;
import com.tydic.umc.general.ability.bo.UmcEnterpriseOrgNameListQryAbilityRspBO;
import java.math.BigDecimal;
import java.util.ArrayList;
import java.util.Collection;
import java.util.Collections;
import java.util.HashMap;
import java.util.List;
import java.util.Map;
import java.util.stream.Collectors;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;
import org.springframework.beans.factory.annotation.Autowired;
import org.springframework.beans.factory.annotation.Value;
import org.springframework.stereotype.Service;
import org.springframework.util.CollectionUtils;

@Service
public class FscComOrderRefundAgreeBusiServiceImpl
implements FscComOrderRefundAgreeBusiService {
    private static final Logger log = LoggerFactory.getLogger(FscComOrderRefundAgreeBusiServiceImpl.class);
    @Autowired
    private FscOrderRefundMapper fscOrderRefundMapper;
    @Autowired
    private FscOrderStatusFlowAtomService fscOrderStatusFlowAtomService;
    @Autowired
    private UacNoTaskAuditCreateAbilityService uacNoTaskAuditCreateAbilityService;
    @Autowired
    private UmcEnterpriseOrgNameListQryAbilityService umcEnterpriseOrgNameListQryAbilityService;
    @Autowired
    private FscTaskCandidateMapper fscTaskCandidateMapper;
    @Autowired
    private DycStationOrgSelectUserNameService dycStationOrgSelectUserNameService;
    @Autowired
    private FscSendNotificationExtAtomService fscSendNotificationExtAtomService;
    @Value(value="${fsc.main.pro.org:100096,100100}")
    private String proOrg;
    private static final String BUSI_NAME = "\u9000\u7968\u4e3b\u5355\u786e\u8ba4";
    private static final String SEPARATOR = ",";
    @Autowired
    private FscBillOrderRefundChangeAtomService fscBillOrderRefundChangeAtomService;
    @Autowired
    private FscOrderMapper fscOrderMapper;
    @Value(value="${OPERATION_SUP_ID:1001693}")
    private String operationSupId;
    @Autowired
    private FscClaimDetailMapper fscClaimDetailMapper;
    @Autowired
    private FscClaimDetailChangeMapper fscClaimDetailChangeMapper;
    @Autowired
    private FscOrderRelationMapper fscOrderRelationMapper;
    @Autowired
    private TaskTodoWaitService taskTodoWaitService;

    @Override
    public FscComOrderRefundAgreeBusiRspBO dealOrderRefundAgree(FscComOrderRefundAgreeBusiReqBO reqBO) {
        if (reqBO.getRefundId() == null) {
            throw new FscBusinessException("198888", "\u5165\u53c2[refundId]\u4e0d\u80fd\u4e3a\u7a7a\uff01");
        }
        FscOrderRefundPO refundPO = new FscOrderRefundPO();
        refundPO.setRefundId(reqBO.getRefundId());
        refundPO = this.fscOrderRefundMapper.getModelBy(refundPO);
        if (refundPO == null) {
            throw new FscBusinessException("198888", "\u67e5\u8be2\u9000\u7968\u4e3b\u5355\u4e3a\u7a7a\uff01");
        }
        if (!(refundPO.getRefundStatus().equals(FscConstants.RefundInvoiceStatus.TO_REFUND) || refundPO.getRefundStatus().equals(FscConstants.RefundInvoiceStatus.APPROVAL_REJECT) || refundPO.getRefundStatus().equals(FscConstants.RefundInvoiceStatus.YC_REJECT))) {
            throw new FscBusinessException("198888", "\u5355\u636e\uff1a" + refundPO.getRefundNo() + "\u5f53\u524d\u9000\u7968\u5355\u636e\u72b6\u6001\u4e0d\u80fd\u8fdb\u884c\u786e\u8ba4\u64cd\u4f5c\uff01");
        }
        this.checkFscClaim(refundPO);
        this.dealApproval(reqBO, refundPO);
        this.dealOperatorInfo(refundPO, reqBO);
        FscOrderRefundPO updatePo = new FscOrderRefundPO();
        updatePo.setRefundId(refundPO.getRefundId());
        updatePo.setOperatorName(refundPO.getOperatorName());
        updatePo.setOperatorId(refundPO.getOperatorId());
        updatePo.setOperationId(refundPO.getOperationId());
        updatePo.setOperationName(refundPO.getOperationName());
        updatePo.setAuditStatus(FscConstants.AuditStatus.AUDITING);
        updatePo.setYcUserId(reqBO.getYcUserId());
        updatePo.setYcPersonId(reqBO.getYcPersonId());
        updatePo.setYcPersonName(reqBO.getYcPersonName());
        updatePo.setYcDeptId(reqBO.getYcDeptId());
        updatePo.setYcDeptName(reqBO.getYcDeptName());
        updatePo.setExt1(reqBO.getExt1());
        this.fscOrderRefundMapper.updateById(updatePo);
        if (refundPO.getMakeType().equals(FscConstants.FscOrderMakeType.OPERTION) || this.operationSupId.equals(String.valueOf(refundPO.getSupplierId()))) {
            FscBillOrderRefundChangeAtomReqBO atomReqBO = new FscBillOrderRefundChangeAtomReqBO();
            atomReqBO.setRefundId(refundPO.getRefundId());
            atomReqBO.setCreateUserId(reqBO.getUserId());
            atomReqBO.setOperationType(FscConstants.RefundChangeOperationType.SAVE);
            FscBillOrderRefundChangeAtomRspBO atomRspBO = this.fscBillOrderRefundChangeAtomService.recordRefundChange(atomReqBO);
            if (!"0000".equals(atomRspBO.getRespCode())) {
                throw new ZTBusinessException("\u8bb0\u5f55\u6838\u9500\u865a\u62df\u53d8\u66f4\u8868\u5931\u8d25" + atomRspBO.getRespDesc());
            }
        }
        FscOrderStatusFlowAtomReqBO fscOrderStatusFlowAtomReqBO = new FscOrderStatusFlowAtomReqBO();
        fscOrderStatusFlowAtomReqBO.setBusiName(BUSI_NAME);
        fscOrderStatusFlowAtomReqBO.setOrderId(refundPO.getRefundId());
        fscOrderStatusFlowAtomReqBO.setCurStatus(refundPO.getRefundStatus());
        HashMap<String, Integer> paramMap = new HashMap<String, Integer>();
        paramMap.put("confirmFlag", FscConstants.BillOrderConfirmFlag.CONFIRM);
        fscOrderStatusFlowAtomReqBO.setParamMap(paramMap);
        FscOrderStatusFlowAtomRspBO fscOrderStatusFlowAtomRspBO = this.fscOrderStatusFlowAtomService.dealRefundStatusFlow(fscOrderStatusFlowAtomReqBO);
        if (!fscOrderStatusFlowAtomRspBO.getRespCode().equals("0000")) {
            throw new FscBusinessException(fscOrderStatusFlowAtomRspBO.getRespCode(), fscOrderStatusFlowAtomRspBO.getRespDesc());
        }
        FscComOrderRefundAgreeBusiRspBO rspBO = new FscComOrderRefundAgreeBusiRspBO();
        rspBO.setRespCode("0000");
        rspBO.setRespDesc("\u6210\u529f");
        return rspBO;
    }

    private void dealApproval(FscComOrderRefundAgreeBusiReqBO reqBO, FscOrderRefundPO refundPO) {
        if (refundPO.getAuditStatus().equals(FscConstants.AuditStatus.AUDIT_PASS)) {
            throw new FscBusinessException("198888", "\u5f53\u524d\u9000\u7968\u5355\u5df2\u5b8c\u6210\u5ba1\u6279,\u8bf7\u52ff\u91cd\u590d\u63d0\u4ea4\uff01");
        }
        if (refundPO.getAuditStatus().equals(FscConstants.AuditStatus.AUDITING)) {
            throw new FscBusinessException("198888", "\u5f53\u524d\u9000\u7968\u5355\u5df2\u5728\u5ba1\u6279\u4e2d,\u8bf7\u52ff\u91cd\u590d\u63d0\u4ea4!");
        }
        UacNoTaskAuditCreateReqBO auditCreateReqBO = new UacNoTaskAuditCreateReqBO();
        auditCreateReqBO.setCreateOperId(reqBO.getUserId().toString());
        auditCreateReqBO.setCreateOperName(reqBO.getName());
        auditCreateReqBO.setCreateOperDept(reqBO.getOrgName());
        auditCreateReqBO.setIsSaveCreateLog(Boolean.valueOf(true));
        if (refundPO.getReceiveType().equals(FscConstants.FscOrderReceiveType.OPERATION)) {
            auditCreateReqBO.setMenuId("M001009");
        } else {
            auditCreateReqBO.setMenuId("M001010");
        }
        auditCreateReqBO.setOrgId(reqBO.getOrgId().toString());
        ArrayList<UacNoTaskAuditCreateInfoReqBO> createBusiReqBO = new ArrayList<UacNoTaskAuditCreateInfoReqBO>();
        UacNoTaskAuditCreateInfoReqBO uacNoTaskAuditCreateInfoReqBO = new UacNoTaskAuditCreateInfoReqBO();
        uacNoTaskAuditCreateInfoReqBO.setObjType(FscConstants.AuditObjType.REFUND_INVOICE);
        uacNoTaskAuditCreateInfoReqBO.setObjNum("1");
        uacNoTaskAuditCreateInfoReqBO.setOrderId(refundPO.getRefundId());
        ArrayList<ApprovalObjBO> approvalObjBOList = new ArrayList<ApprovalObjBO>();
        ApprovalObjBO approvalObjBO = new ApprovalObjBO();
        approvalObjBO.setObjId(refundPO.getRefundId().toString());
        approvalObjBO.setObjName("\u7ed3\u7b97\u5355\u5ba1\u6279");
        approvalObjBO.setObjType(FscConstants.AuditObjType.REFUND_INVOICE);
        approvalObjBOList.add(approvalObjBO);
        uacNoTaskAuditCreateInfoReqBO.setApprovalObjInfo(approvalObjBOList);
        createBusiReqBO.add(uacNoTaskAuditCreateInfoReqBO);
        auditCreateReqBO.setCreateBusiReqBO(createBusiReqBO);
        log.info("\u5ba1\u6279\u5165\u53c2================" + JSON.toJSONString((Object)auditCreateReqBO));
        UacNoTaskAuditCreateRspBO uacNoTaskAuditCreateRspBO = this.uacNoTaskAuditCreateAbilityService.auditOrderCreate(auditCreateReqBO);
        log.info("\u5ba1\u6279\u51fa\u53c2================" + JSON.toJSONString((Object)uacNoTaskAuditCreateRspBO));
        if (!"0000".equals(uacNoTaskAuditCreateRspBO.getRespCode())) {
            throw new FscBusinessException("191019", uacNoTaskAuditCreateRspBO.getRespDesc());
        }
        if (uacNoTaskAuditCreateRspBO.getNotFindFlag().booleanValue()) {
            throw new FscBusinessException("190000", "\u8bf7\u8054\u7cfb\u7ba1\u7406\u5458\u914d\u7f6e\u9000\u7968\u5ba1\u6279\u6d41\uff01");
        }
        FscTaskCandidatePO taskPo = new FscTaskCandidatePO();
        taskPo.setFscOrderId(refundPO.getRefundId());
        List pendAuditPostIdList = this.fscTaskCandidateMapper.getPendAuditPostIdList(taskPo);
        if (!CollectionUtils.isEmpty((Collection)pendAuditPostIdList)) {
            DycStationOrgSelectUserNameReqBO dycStationOrgSelectUserNameReqBO = new DycStationOrgSelectUserNameReqBO();
            dycStationOrgSelectUserNameReqBO.setStationId(Long.valueOf(((FscApprovalTaskQueryBO)pendAuditPostIdList.get(0)).getTaskOperId()));
            DycStationOrgSelectUserNameRspBO dycStationOrgSelectUserNameRspBO = this.dycStationOrgSelectUserNameService.selectUserName(dycStationOrgSelectUserNameReqBO);
            if (dycStationOrgSelectUserNameRspBO != null && !CollectionUtils.isEmpty((Collection)dycStationOrgSelectUserNameRspBO.getUserList())) {
                FscSendNotificationExtAtomReqBO fscSendNotificationExtAtomReqBO = new FscSendNotificationExtAtomReqBO();
                fscSendNotificationExtAtomReqBO.setTitel("\u91c7\u8d2d\u9000\u7968\u7533\u8bf7\u5355");
                fscSendNotificationExtAtomReqBO.setText("\u3010\u4e2d\u7164\u96c6\u56e2\u3011\u60a8\u6709\u5f85\u5ba1\u6279\u7684\u9000\u7968\u7533\u8bf7\u5355" + refundPO.getRefundNo() + "(\u9000\u7968\u7533\u8bf7\u5355\u53f7)\u5df2\u63d0\u4ea4\u81f3\u60a8\u5904\u5ba1\u6279\uff0c\u8bf7\u53ca\u65f6\u5904\u7406\u3002");
                fscSendNotificationExtAtomReqBO.setUserId(reqBO.getUserId());
                fscSendNotificationExtAtomReqBO.setReceiveIds(dycStationOrgSelectUserNameRspBO.getUserList().stream().map(UserBO::getUserId).distinct().collect(Collectors.toList()));
                this.fscSendNotificationExtAtomService.sendNotification(fscSendNotificationExtAtomReqBO);
            }
        }
        if (FscConstants.FscOrderReceiveType.PURCHASE.equals(refundPO.getReceiveType()) && FscConstants.FscOrderMakeType.OPERTION.equals(refundPO.getMakeType())) {
            try {
                this.taskTodoWaitService.syncNotifySaleRefundWaitDone(reqBO.getRefundId());
            }
            catch (Exception e) {
                log.error("dealPayBillCreateBySale -\u901a\u77e5\u5f85\u529e\u5931\u8d25- error:{}", (Throwable)e);
            }
        }
    }

    private void dealOperatorInfo(FscOrderRefundPO refundPO, FscComOrderRefundAgreeBusiReqBO reqBO) {
        String[] split;
        refundPO.setOperatorId(reqBO.getUserId());
        refundPO.setOperatorName(reqBO.getName());
        for (String orgId : split = this.proOrg.split(SEPARATOR)) {
            if (!reqBO.getOrgPath().contains("-" + orgId + "-")) continue;
            refundPO.setOperationId(Long.valueOf(orgId));
            UmcEnterpriseOrgNameListQryAbilityReqBO abilityReqBO = new UmcEnterpriseOrgNameListQryAbilityReqBO();
            abilityReqBO.setOrgIdList(Collections.singletonList(Long.valueOf(orgId)));
            UmcEnterpriseOrgNameListQryAbilityRspBO rspBO = this.umcEnterpriseOrgNameListQryAbilityService.qryEnterpriseOrgNameList(abilityReqBO);
            if (rspBO.getRespCode().equals("0000") && !CollectionUtils.isEmpty((Map)rspBO.getOrgMap())) {
                Map orgMap = rspBO.getOrgMap();
                refundPO.setOperationName(((UmcDycEnterpriseOrgBO)orgMap.get(refundPO.getOperationId())).getOrgName());
                break;
            }
            throw new FscBusinessException("198888", "\u67e5\u8be2\u673a\u6784\u4fe1\u606f\u5f02\u5e38:" + rspBO.getRespDesc());
        }
    }

    private void checkFscClaim(FscOrderRefundPO refundPO) {
        List payPaidList;
        if (!refundPO.getRefundReasonType().equals(FscConstants.RefundReasonType.ORDER_REFUND) && (refundPO.getMakeType().equals(FscConstants.FscOrderMakeType.OPERTION) || this.operationSupId.equals(String.valueOf(refundPO.getSupplierId()))) && !CollectionUtils.isEmpty((Collection)(payPaidList = this.fscClaimDetailMapper.qryClaimListByFscOrderId(refundPO.getFscOrderId())))) {
            List claimDetailIdList = payPaidList.stream().map(FscClaimDetailPO::getClaimDetailId).collect(Collectors.toList());
            FscClaimDetailChangePO searchPO = new FscClaimDetailChangePO();
            searchPO.setClaimDetailIds(claimDetailIdList);
            searchPO.setPushStatus(FscConstants.FscPushStatus.SUCCESS);
            searchPO.setChangeBusiType(FscConstants.ChangeBusiType.REFUND);
            BigDecimal totalClaimChangeAmount = this.fscClaimDetailChangeMapper.queryTotalClaimChangeAmount(searchPO);
            if (totalClaimChangeAmount == null) {
                totalClaimChangeAmount = BigDecimal.ZERO;
            }
            BigDecimal totalOperationClaimAmt = BigDecimal.ZERO;
            FscOrderRelationPO orderRelationPO = new FscOrderRelationPO();
            orderRelationPO.setFscOrderId(refundPO.getFscOrderId());
            List orderRelationPOS = this.fscOrderRelationMapper.getListNoPage(orderRelationPO);
            if (!CollectionUtils.isEmpty((Collection)orderRelationPOS)) {
                for (FscOrderRelationPO po : orderRelationPOS) {
                    if (po.getOperationClaimAmt() == null) continue;
                    totalOperationClaimAmt = totalOperationClaimAmt.add(po.getOperationClaimAmt());
                }
            }
            if (totalClaimChangeAmount.compareTo(totalOperationClaimAmt) < 0) {
                throw new FscBusinessException("198888", "\u8bf7\u5148\u8fdb\u884c\u7ed3\u7b97\u5355\u7684\u6362\u7968\u9884\u8ba4\u9886\u53d8\u66f4");
            }
        }
    }
}

