/*
 * Decompiled with CFR 0.152.
 */
package com.tydic.fsc.bill.busi.impl;

import com.alibaba.fastjson.JSON;
import com.ohaotian.plugin.db.Sequence;
import com.tydic.fsc.bill.atom.api.FscBillOrderRefundUpdateAlreadyRefundAtomService;
import com.tydic.fsc.bill.atom.bo.FscBillOrderRefundUpdateAlreadyRefundAtomReqBO;
import com.tydic.fsc.bill.atom.bo.FscBillOrderRefundUpdateAlreadyRefundAtomRspBO;
import com.tydic.fsc.bill.busi.api.FscComOrderRefundSupConfirmBusiService;
import com.tydic.fsc.bill.busi.bo.FscComOrderRefundSupConfirmBusiReqBO;
import com.tydic.fsc.bill.busi.bo.FscComOrderRefundSupConfirmBusiRspBO;
import com.tydic.fsc.bo.InvoiceBO;
import com.tydic.fsc.busibase.atom.api.FscOrderStatusFlowAtomService;
import com.tydic.fsc.busibase.atom.api.FscSettleRefundShouldPayCreateAtomService;
import com.tydic.fsc.busibase.atom.api.FscUocOrderRelUpdateAtomService;
import com.tydic.fsc.busibase.atom.bo.FscOrderStatusFlowAtomReqBO;
import com.tydic.fsc.busibase.atom.bo.FscOrderStatusFlowAtomRspBO;
import com.tydic.fsc.busibase.atom.bo.FscSettleRefundShouldPayCreateAtomReqBO;
import com.tydic.fsc.busibase.atom.bo.FscSettleRefundShouldPayCreateAtomRspBO;
import com.tydic.fsc.busibase.atom.bo.FscUocOrderRelUpdateAtomReqBO;
import com.tydic.fsc.busibase.atom.bo.FscUocOrderRelUpdateAtomRspBO;
import com.tydic.fsc.constants.FscConstants;
import com.tydic.fsc.constants.FscRefundReasonEnum;
import com.tydic.fsc.dao.FscInvoiceMapper;
import com.tydic.fsc.dao.FscInvoiceRefundRelationMapper;
import com.tydic.fsc.dao.FscOrderRefundMapper;
import com.tydic.fsc.dao.FscOrderShouldAmountMapper;
import com.tydic.fsc.dao.FscRefundShouldAmountMapper;
import com.tydic.fsc.exception.FscBusinessException;
import com.tydic.fsc.po.FscInvoicePO;
import com.tydic.fsc.po.FscInvoiceRefundRelationPO;
import com.tydic.fsc.po.FscOrderRefundPO;
import com.tydic.fsc.po.FscOrderShouldAmountPO;
import com.tydic.fsc.po.FscRefundShouldAmountPO;
import com.tydic.fsc.util.DateUtil;
import java.math.BigDecimal;
import java.util.ArrayList;
import java.util.Collection;
import java.util.Date;
import java.util.HashMap;
import java.util.List;
import java.util.Map;
import java.util.Set;
import java.util.stream.Collectors;
import org.springframework.beans.BeanUtils;
import org.springframework.beans.factory.annotation.Autowired;
import org.springframework.stereotype.Service;
import org.springframework.util.CollectionUtils;

@Service
public class FscComOrderRefundSupConfirmBusiServiceImpl
implements FscComOrderRefundSupConfirmBusiService {
    @Autowired
    private FscOrderRefundMapper fscOrderRefundMapper;
    @Autowired
    private FscInvoiceMapper fscInvoiceMapper;
    @Autowired
    private FscOrderStatusFlowAtomService fscOrderStatusFlowAtomService;
    @Autowired
    private FscInvoiceRefundRelationMapper fscInvoiceRefundRelationMapper;
    @Autowired
    private FscUocOrderRelUpdateAtomService fscUocOrderRelUpdateAtomService;
    @Autowired
    private FscBillOrderRefundUpdateAlreadyRefundAtomService fscBillOrderRefundUpdateAlreadyRefundAtomService;
    @Autowired
    private FscSettleRefundShouldPayCreateAtomService fscSettleRefundShouldPayCreateAtomService;
    @Autowired
    private FscRefundShouldAmountMapper fscRefundShouldAmountMapper;
    @Autowired
    private FscOrderShouldAmountMapper fscOrderShouldAmountMapper;

    @Override
    public FscComOrderRefundSupConfirmBusiRspBO dealOrderRefundSupConfirm(FscComOrderRefundSupConfirmBusiReqBO reqBO) {
        FscOrderRefundPO refundPO = new FscOrderRefundPO();
        refundPO.setRefundId(reqBO.getRefundId());
        refundPO = this.fscOrderRefundMapper.getModelBy(refundPO);
        if (refundPO == null) {
            throw new FscBusinessException("198888", "\u672a\u67e5\u8be2\u5230\u9000\u7968\u4e3b\u5355\u4fe1\u606f!");
        }
        if (FscConstants.FscInvoiceStatus.INVALID.equals(refundPO.getInvoiceStatus()) || FscConstants.FscInvoiceStatus.RED.equals(refundPO.getInvoiceStatus())) {
            throw new FscBusinessException("198888", "\u9000\u7968\u4e3b\u5355\u5df2\u7ea2\u51b2\u6216\u8005\u5df2\u4f5c\u5e9f\uff0c\u8bf7\u5237\u65b0\u5217\u8868!");
        }
        FscOrderRefundPO updateVo = new FscOrderRefundPO();
        updateVo.setRefundId(refundPO.getRefundId());
        if (reqBO.getConfirmType().equals(FscConstants.RefundSupConfirmType.CANCELLATION)) {
            this.dealCancellation(reqBO, refundPO);
            this.dealWorkFlow(refundPO, "\u4f9b\u5e94\u786e\u8ba4\u4f5c\u5e9f");
            updateVo.setInvoiceStatus(FscConstants.FscInvoiceStatus.INVALID);
        } else {
            this.dealRedPunch(reqBO, refundPO);
            this.dealWorkFlow(refundPO, "\u4f9b\u5e94\u786e\u8ba4\u7ea2\u51b2");
            updateVo.setInvoiceStatus(FscConstants.FscInvoiceStatus.RED);
        }
        updateVo.setReopenFlag(FscConstants.ReopenFlag.NO);
        this.fscOrderRefundMapper.updateById(updateVo);
        if (refundPO.getReceiveType().equals(FscConstants.FscOrderReceiveType.OPERATION)) {
            this.dealRefund(reqBO, refundPO);
        } else if (refundPO.getIsPushUnify() == null || !refundPO.getIsPushUnify().equals(FscConstants.IsPushUnify.PUSH)) {
            this.dealRefund(reqBO, refundPO);
        }
        FscComOrderRefundSupConfirmBusiRspBO rspBO = new FscComOrderRefundSupConfirmBusiRspBO();
        rspBO.setFscOrderId(refundPO.getFscOrderId());
        rspBO.setRespCode("0000");
        rspBO.setRespDesc("\u6210\u529f");
        return rspBO;
    }

    private void dealRefund(FscComOrderRefundSupConfirmBusiReqBO reqBO, FscOrderRefundPO refundPO) {
        if (!FscRefundReasonEnum.RETURN_OR_EXCHANGE_PROBLEM.getCode().equals(refundPO.getRefundReasonType().toString())) {
            FscBillOrderRefundUpdateAlreadyRefundAtomReqBO updateAlreadyRefundAtomReqBO = new FscBillOrderRefundUpdateAlreadyRefundAtomReqBO();
            updateAlreadyRefundAtomReqBO.setRefundId(reqBO.getRefundId());
            FscBillOrderRefundUpdateAlreadyRefundAtomRspBO updateAlreadyRefundAtomRspBO = this.fscBillOrderRefundUpdateAlreadyRefundAtomService.recordRefundUpdateAlreadyRefund(updateAlreadyRefundAtomReqBO);
            if (!"0000".equals(updateAlreadyRefundAtomRspBO.getRespCode())) {
                throw new FscBusinessException("198888", "\u8bb0\u5f55\u5df2\u9000\u7968\u6570\u91cf\u8ddf\u5df2\u9000\u7968\u91d1\u989d\u5931\u8d25\uff1a" + updateAlreadyRefundAtomRspBO.getRespDesc());
            }
            this.syncOrderStatus(refundPO);
        } else {
            this.dealCreateRefundShouldPay(reqBO, refundPO);
        }
        FscRefundShouldAmountPO refundShouldAmountPO = new FscRefundShouldAmountPO();
        refundShouldAmountPO.setRefundId(refundPO.getRefundId());
        List refundList = this.fscRefundShouldAmountMapper.getList(refundShouldAmountPO);
        if (!CollectionUtils.isEmpty((Collection)refundList)) {
            ArrayList<FscOrderShouldAmountPO> amountPOList = new ArrayList<FscOrderShouldAmountPO>(refundList.size());
            for (FscRefundShouldAmountPO fscRefundShouldAmountPO : refundList) {
                FscOrderShouldAmountPO shouldAmountPO = new FscOrderShouldAmountPO();
                BeanUtils.copyProperties((Object)fscRefundShouldAmountPO, (Object)shouldAmountPO);
                shouldAmountPO.setRefundAmt(BigDecimal.ZERO);
                shouldAmountPO.setWriteOffDate(fscRefundShouldAmountPO.getCreateTime());
                shouldAmountPO.setRefundId(refundPO.getRefundId());
                shouldAmountPO.setWriteOffAmount(fscRefundShouldAmountPO.getAmount().negate());
                amountPOList.add(shouldAmountPO);
            }
            int count = this.fscOrderShouldAmountMapper.insertBatch(amountPOList);
            if (count != amountPOList.size()) {
                throw new FscBusinessException("198888", "\u63d2\u5165\u6838\u9500\u51b2\u9500\u6570\u636e\u4fe1\u606f\u5931\u8d25\uff01");
            }
        }
    }

    private void dealRedPunch(FscComOrderRefundSupConfirmBusiReqBO reqBO, FscOrderRefundPO refundPO) {
        FscInvoicePO invoicePO;
        Date now = new Date();
        String dateStr = DateUtil.dateToStr((Date)now, (String)"yyyy-MM");
        FscInvoicePO searchPO = new FscInvoicePO();
        searchPO.setFscOrderId(refundPO.getFscOrderId());
        searchPO.setBillDateLike(dateStr);
        int count = this.fscInvoiceMapper.getCheckBy(searchPO);
        if (!(count > 0 || refundPO.getRefundReasonType() != null && FscConstants.RefundReasonType.ORDER_REFUND.equals(refundPO.getRefundReasonType()) || refundPO.getCertification() == null || refundPO.getCertification() != 0)) {
            throw new FscBusinessException("198888", "\u60a8\u9009\u62e9\u7684\u9000\u7968\u7533\u8bf7\u4e3a\u672a\u8ba4\u8bc1\u7684\u5f53\u6708\u53d1\u7968\uff0c\u65e0\u6cd5\u8fdb\u884c\u7ea2\u51b2\u3002");
        }
        FscInvoiceRefundRelationPO searchRefundRelationPO = new FscInvoiceRefundRelationPO();
        searchRefundRelationPO.setRefundId(reqBO.getRefundId());
        List fscInvoiceRefundRelationPOS = this.fscInvoiceRefundRelationMapper.getList(searchRefundRelationPO);
        Map<Long, BigDecimal> invoiceIdRefundAmtMap = fscInvoiceRefundRelationPOS.stream().collect(Collectors.toMap(FscInvoiceRefundRelationPO::getInvoiceId, FscInvoiceRefundRelationPO::getRefundAmt));
        List beforeInvoiceIds = fscInvoiceRefundRelationPOS.stream().map(FscInvoiceRefundRelationPO::getInvoiceId).collect(Collectors.toList());
        Set reqInvoiceIdSet = reqBO.getRedInvoiceList().stream().map(InvoiceBO::getInvoiceId).collect(Collectors.toSet());
        ArrayList<Long> failBeforeInvoiceIds = new ArrayList<Long>();
        for (Object invoiceId : beforeInvoiceIds) {
            if (reqInvoiceIdSet.contains(invoiceId)) continue;
            failBeforeInvoiceIds.add((Long)invoiceId);
        }
        if (!CollectionUtils.isEmpty(failBeforeInvoiceIds)) {
            throw new FscBusinessException("198888", "\u53d1\u7968Id:" + failBeforeInvoiceIds + "\u7ea2\u51b2\u5904\u7406\u5931\u8d25\uff1a\u9000\u7968\u5355\u4e2d\u53d1\u7968\u4fe1\u606f\u6ca1\u6709\u4f20\u5165\uff01");
        }
        ArrayList<Long> failInvoiceIds = new ArrayList<Long>();
        for (InvoiceBO invoiceBO : reqBO.getRedInvoiceList()) {
            if (invoiceBO.getAmt() == null) {
                throw new FscBusinessException("198888", "\u7ea2\u51b2\u53d1\u7968\u7684\u91d1\u989d\u4e0d\u80fd\u4e3a\u7a7a\uff0c\u53d1\u7968Id:" + invoiceBO.getInvoiceId());
            }
            if (invoiceIdRefundAmtMap.containsKey(invoiceBO.getInvoiceId())) {
                BigDecimal refundAmt = invoiceIdRefundAmtMap.get(invoiceBO.getInvoiceId());
                if (refundAmt.compareTo(invoiceBO.getAmt().abs()) == 0) continue;
                failInvoiceIds.add(invoiceBO.getInvoiceId());
                continue;
            }
            throw new FscBusinessException("198888", "\u53d1\u7968\u4e0d\u5c5e\u4e8e\u672c\u6b21\u9000\u7968\u5355\uff0c\u53d1\u7968Id:" + invoiceBO.getInvoiceId());
        }
        if (!CollectionUtils.isEmpty(failInvoiceIds)) {
            throw new FscBusinessException("198888", "\u53d1\u7968Id:" + failInvoiceIds + "\u7ea2\u51b2\u5904\u7406\u5931\u8d25\uff1a\u7ea2\u51b2\u53d1\u7968\u91d1\u989d\u4e0e\u539f\u53d1\u7968\u7684\u9000\u7968\u91d1\u989d\u4e0d\u4e00\u81f4\uff01");
        }
        List ids = fscInvoiceRefundRelationPOS.stream().map(FscInvoiceRefundRelationPO::getId).collect(Collectors.toList());
        FscInvoiceRefundRelationPO updateInvoiceRelation = new FscInvoiceRefundRelationPO();
        updateInvoiceRelation.setIds(ids);
        updateInvoiceRelation.setInvoiceStatus(FscConstants.FscInvoiceStatus.RED);
        this.fscInvoiceRefundRelationMapper.updateInvoiceStatus(updateInvoiceRelation);
        ArrayList<Long> redInvoiceIds = new ArrayList<Long>();
        ArrayList<Long> partRedInvoiceIds = new ArrayList<Long>();
        FscInvoicePO searchInvoicePO = new FscInvoicePO();
        searchInvoicePO.setFscOrderId(refundPO.getFscOrderId());
        searchInvoicePO.setInvoiceIds(beforeInvoiceIds);
        List beforeInvoiceList = this.fscInvoiceMapper.getList(searchInvoicePO);
        Map<Long, FscInvoicePO> invoiceIdMap = beforeInvoiceList.stream().collect(Collectors.toMap(FscInvoicePO::getInvoiceId, o -> o));
        searchRefundRelationPO = new FscInvoiceRefundRelationPO();
        searchRefundRelationPO.setInvoiceIds(beforeInvoiceIds);
        fscInvoiceRefundRelationPOS = this.fscInvoiceRefundRelationMapper.getList(searchRefundRelationPO);
        Set refundIdSet = fscInvoiceRefundRelationPOS.stream().filter(e -> e.getRefundId() != null).map(FscInvoiceRefundRelationPO::getRefundId).collect(Collectors.toSet());
        if (!CollectionUtils.isEmpty(refundIdSet)) {
            FscOrderRefundPO fscOrderRefundPO = new FscOrderRefundPO();
            fscOrderRefundPO.setRefundIdList(new ArrayList(refundIdSet));
            List fscOrderRefundPOList = this.fscOrderRefundMapper.queryAll(fscOrderRefundPO);
            if (!CollectionUtils.isEmpty((Collection)fscOrderRefundPOList)) {
                List delRefundIds = fscOrderRefundPOList.stream().filter(e -> FscConstants.RefundInvoiceStatus.DELETE.equals(e.getRefundStatus()) || FscConstants.RefundInvoiceStatus.CANCEL.equals(e.getRefundStatus())).map(FscOrderRefundPO::getRefundId).collect(Collectors.toList());
                fscInvoiceRefundRelationPOS = fscInvoiceRefundRelationPOS.stream().filter(e -> !delRefundIds.contains(e.getRefundId())).collect(Collectors.toList());
            }
        }
        Map<Long, List<FscInvoiceRefundRelationPO>> invoiceIdRefundRelationMap = fscInvoiceRefundRelationPOS.stream().collect(Collectors.groupingBy(FscInvoiceRefundRelationPO::getInvoiceId));
        for (Long invoiceId : invoiceIdRefundRelationMap.keySet()) {
            BigDecimal redRefundAmt = BigDecimal.ZERO;
            for (FscInvoiceRefundRelationPO relationPO : invoiceIdRefundRelationMap.get(invoiceId)) {
                if (!FscConstants.FscInvoiceStatus.RED.equals(relationPO.getInvoiceStatus())) continue;
                redRefundAmt = redRefundAmt.add(relationPO.getRefundAmt());
            }
            BigDecimal amt = invoiceIdMap.get(invoiceId).getAmt();
            if (redRefundAmt.compareTo(amt) >= 0) {
                redInvoiceIds.add(invoiceId);
                continue;
            }
            partRedInvoiceIds.add(invoiceId);
        }
        if (!CollectionUtils.isEmpty(redInvoiceIds)) {
            invoicePO = new FscInvoicePO();
            invoicePO.setInvoiceIds(redInvoiceIds);
            invoicePO.setStatus(FscConstants.FscInvoiceStatus.RED);
            this.fscInvoiceMapper.updateInvoiceStatus(invoicePO);
        }
        if (!CollectionUtils.isEmpty(partRedInvoiceIds)) {
            invoicePO = new FscInvoicePO();
            invoicePO.setInvoiceIds(partRedInvoiceIds);
            invoicePO.setStatus(FscConstants.FscInvoiceStatus.PART_RED);
            this.fscInvoiceMapper.updateInvoiceStatus(invoicePO);
        }
        ArrayList<FscInvoicePO> invoiceList = new ArrayList<FscInvoicePO>();
        for (InvoiceBO invoiceBO : reqBO.getRedInvoiceList()) {
            FscInvoicePO invoicePO2 = new FscInvoicePO();
            BeanUtils.copyProperties((Object)invoiceBO, (Object)invoicePO2);
            invoicePO2.setPreInvoiceId(invoiceBO.getInvoiceId());
            invoicePO2.setInvoiceId(Long.valueOf(Sequence.getInstance().nextId()));
            invoicePO2.setRefundId(refundPO.getRefundId());
            invoicePO2.setStatus(FscConstants.FscInvoiceStatus.VALID);
            invoicePO2.setAmt(invoiceBO.getAmt().abs());
            invoicePO2.setTaxAmt(invoiceBO.getTaxAmt().abs());
            invoicePO2.setUntaxAmt(invoiceBO.getUntaxAmt().abs());
            invoicePO2.setCreateTime(new Date());
            if (FscConstants.InvoiceCategory.FULL_ELECTRON.equals(invoicePO2.getInvoiceCategory())) {
                invoicePO2.setFullElecNo(invoicePO2.getInvoiceNo());
                int splitIndex = invoicePO2.getInvoiceNo().length() - 8;
                invoicePO2.setInvoiceCode(invoicePO2.getInvoiceNo().substring(0, splitIndex));
                invoicePO2.setInvoiceNo(invoicePO2.getInvoiceNo().substring(splitIndex));
            }
            invoiceList.add(invoicePO2);
        }
        this.fscInvoiceMapper.insertBatch(invoiceList);
    }

    private void dealCancellation(FscComOrderRefundSupConfirmBusiReqBO reqBO, FscOrderRefundPO refundPO) {
        if (refundPO.getCertification() != null && refundPO.getCertification() == 1) {
            throw new FscBusinessException("198888", "\u60a8\u9009\u62e9\u7684\u9000\u7968\u7533\u8bf7\u4e3a\u5df2\u8ba4\u8bc1\u53d1\u7968\uff0c\u65e0\u6cd5\u8fdb\u884c\u4f5c\u5e9f\uff0c\u53ea\u80fd\u8fdb\u884c\u7ea2\u51b2\u3002");
        }
        Date now = new Date();
        String dateStr = DateUtil.dateToStr((Date)now, (String)"yyyy-MM");
        FscInvoicePO invoicePO = new FscInvoicePO();
        invoicePO.setFscOrderId(refundPO.getFscOrderId());
        invoicePO.setBillDateLike(dateStr);
        int count = this.fscInvoiceMapper.getCheckBy(invoicePO);
        if (count > 0) {
            throw new FscBusinessException("198888", "\u60a8\u9009\u62e9\u7684\u9000\u7968\u7533\u8bf7\u4e3a\u9694\u6708\u53d1\u7968\uff0c\u65e0\u6cd5\u8fdb\u884c\u4f5c\u5e9f\u3002");
        }
        FscInvoiceRefundRelationPO searchRefundRelationPO = new FscInvoiceRefundRelationPO();
        searchRefundRelationPO.setRefundId(reqBO.getRefundId());
        List fscInvoiceRefundRelationPOS = this.fscInvoiceRefundRelationMapper.getList(searchRefundRelationPO);
        Map<Long, BigDecimal> invoiceIdRefundAmtMap = fscInvoiceRefundRelationPOS.stream().collect(Collectors.toMap(FscInvoiceRefundRelationPO::getInvoiceId, FscInvoiceRefundRelationPO::getRefundAmt));
        FscInvoicePO searchInvoicePO = new FscInvoicePO();
        searchInvoicePO.setFscOrderId(refundPO.getFscOrderId());
        ArrayList<Long> invoiceIds = new ArrayList<Long>();
        invoiceIds.addAll(invoiceIdRefundAmtMap.keySet());
        searchInvoicePO.setInvoiceIds(invoiceIds);
        List invoiceList = this.fscInvoiceMapper.getList(searchInvoicePO);
        Map<Long, FscInvoicePO> invoiceIdMap = invoiceList.stream().collect(Collectors.toMap(FscInvoicePO::getInvoiceId, o -> o));
        for (Long invoiceId : invoiceIdRefundAmtMap.keySet()) {
            BigDecimal amt;
            BigDecimal refundAmt = invoiceIdRefundAmtMap.get(invoiceId);
            if (refundAmt.compareTo(amt = invoiceIdMap.get(invoiceId).getAmt()) >= 0) continue;
            throw new FscBusinessException("198888", "\u60a8\u9009\u62e9\u7684\u9000\u7968\u7533\u8bf7\u9000\u7968\u91d1\u989d\u4e0d\u7b49\u4e8e\u5f00\u7968\u91d1\u989d\uff0c\u65e0\u6cd5\u8fdb\u884c\u4f5c\u5e9f\u3002");
        }
        List ids = fscInvoiceRefundRelationPOS.stream().map(FscInvoiceRefundRelationPO::getId).collect(Collectors.toList());
        FscInvoiceRefundRelationPO updateInvoiceRelation = new FscInvoiceRefundRelationPO();
        updateInvoiceRelation.setIds(ids);
        updateInvoiceRelation.setInvoiceStatus(FscConstants.FscInvoiceStatus.INVALID);
        this.fscInvoiceRefundRelationMapper.updateInvoiceStatus(updateInvoiceRelation);
        FscInvoicePO updateInvoicePO = new FscInvoicePO();
        updateInvoicePO.setInvoiceIds(invoiceIds);
        updateInvoicePO.setStatus(FscConstants.FscInvoiceStatus.INVALID);
        this.fscInvoiceMapper.updateInvoiceStatus(updateInvoicePO);
    }

    private void dealWorkFlow(FscOrderRefundPO refundPO, String busiName) {
        FscOrderStatusFlowAtomReqBO fscOrderStatusFlowAtomReqBO = new FscOrderStatusFlowAtomReqBO();
        fscOrderStatusFlowAtomReqBO.setBusiName(busiName);
        fscOrderStatusFlowAtomReqBO.setOrderId(refundPO.getRefundId());
        fscOrderStatusFlowAtomReqBO.setCurStatus(refundPO.getRefundStatus());
        HashMap<String, Integer> paramMap = new HashMap<String, Integer>();
        if (refundPO.getReceiveType().equals(FscConstants.FscOrderReceiveType.PURCHASE)) {
            paramMap.put("confirmFlag", FscConstants.BillOrderConfirmFlag.PURCHASE);
        } else {
            paramMap.put("confirmFlag", FscConstants.BillOrderConfirmFlag.CONFIRM);
        }
        fscOrderStatusFlowAtomReqBO.setParamMap(paramMap);
        FscOrderStatusFlowAtomRspBO fscOrderStatusFlowAtomRspBO = this.fscOrderStatusFlowAtomService.dealRefundStatusFlow(fscOrderStatusFlowAtomReqBO);
        if (!fscOrderStatusFlowAtomRspBO.getRespCode().equals("0000")) {
            throw new FscBusinessException(fscOrderStatusFlowAtomRspBO.getRespCode(), fscOrderStatusFlowAtomRspBO.getRespDesc());
        }
    }

    private void updateInvoiceStatus(Long refundId, Integer status) {
        FscInvoiceRefundRelationPO refundRelationPO = new FscInvoiceRefundRelationPO();
        refundRelationPO.setRefundId(refundId);
        List list = this.fscInvoiceRefundRelationMapper.getList(refundRelationPO);
        List preInvoiceIds = list.stream().map(FscInvoiceRefundRelationPO::getInvoiceId).collect(Collectors.toList());
        FscInvoicePO invoicePO = new FscInvoicePO();
        invoicePO.setInvoiceIds(preInvoiceIds);
        invoicePO.setStatus(status);
        int count = this.fscInvoiceMapper.updateInvoiceStatus(invoicePO);
        if (count < 0) {
            throw new FscBusinessException("198888", "\u66f4\u65b0\u53d1\u7968\u72b6\u6001\u5931\u8d25\uff01");
        }
    }

    private void syncOrderStatus(FscOrderRefundPO refundPO) {
        FscUocOrderRelUpdateAtomReqBO fscUocOrderRelUpdateAtomReqBO = new FscUocOrderRelUpdateAtomReqBO();
        fscUocOrderRelUpdateAtomReqBO.setRefundId(refundPO.getRefundId());
        fscUocOrderRelUpdateAtomReqBO.setOperType(FscConstants.FscRelUpdateAtomOperType.REFUND);
        fscUocOrderRelUpdateAtomReqBO.setRelState(FscConstants.FscRelStatus.UNCOMMITTED);
        FscUocOrderRelUpdateAtomRspBO fscUocOrderRelUpdateAtomRspBO = this.fscUocOrderRelUpdateAtomService.dealRefundUpdate(fscUocOrderRelUpdateAtomReqBO);
        if (!fscUocOrderRelUpdateAtomRspBO.getRespCode().equals("0000")) {
            throw new FscBusinessException(fscUocOrderRelUpdateAtomRspBO.getRespCode(), "\u91ca\u653e\u8ba2\u5355\u5931\u8d25\uff1a" + fscUocOrderRelUpdateAtomRspBO.getRespDesc());
        }
    }

    private void dealCreateRefundShouldPay(FscComOrderRefundSupConfirmBusiReqBO reqBO, FscOrderRefundPO refundPO) {
        FscSettleRefundShouldPayCreateAtomReqBO atomReqBO = (FscSettleRefundShouldPayCreateAtomReqBO)JSON.parseObject((String)JSON.toJSONString((Object)((Object)reqBO)), FscSettleRefundShouldPayCreateAtomReqBO.class);
        atomReqBO.setOrderRefundPO(refundPO);
        FscSettleRefundShouldPayCreateAtomRspBO atomRspBO = this.fscSettleRefundShouldPayCreateAtomService.createSettleRefundShouldPay(atomReqBO);
        if (!atomRspBO.getRespCode().equals("0000")) {
            throw new FscBusinessException(atomRspBO.getRespCode(), atomRspBO.getRespDesc());
        }
    }
}

