/*
 * Decompiled with CFR 0.152.
 */
package com.tydic.fsc.bill.busi.impl;

import cn.hutool.core.collection.CollectionUtil;
import com.alibaba.fastjson.JSON;
import com.google.common.base.Joiner;
import com.tydic.authority.busi.api.DycStationOrgSelectUserNameService;
import com.tydic.authority.busi.bo.DycStationOrgSelectUserNameReqBO;
import com.tydic.authority.busi.bo.DycStationOrgSelectUserNameRspBO;
import com.tydic.authority.busi.bo.UserBO;
import com.tydic.fsc.bill.ability.bo.FscFinanceWriteOffApprovalServiceReqBo;
import com.tydic.fsc.bill.busi.api.FscFinanceWriteOffApprovalBusiService;
import com.tydic.fsc.bo.FscApprovalTaskQueryBO;
import com.tydic.fsc.busibase.atom.api.FscOrderStatusFlowAtomService;
import com.tydic.fsc.busibase.atom.api.FscSendNotificationExtAtomService;
import com.tydic.fsc.busibase.atom.bo.FscSendNotificationExtAtomReqBO;
import com.tydic.fsc.busibase.busi.api.FscDictionaryBusiService;
import com.tydic.fsc.constants.FscConstants;
import com.tydic.fsc.dao.FscFinanceWriteOffAdjustDetailMapper;
import com.tydic.fsc.dao.FscFinanceWriteOffAdjustMapper;
import com.tydic.fsc.dao.FscOrderMapper;
import com.tydic.fsc.dao.FscOrderPayItemMapper;
import com.tydic.fsc.dao.FscTaskCandidateMapper;
import com.tydic.fsc.enums.FscOrderSendStateEnum;
import com.tydic.fsc.exception.FscBusinessException;
import com.tydic.fsc.pay.task.service.TaskTodoWaitService;
import com.tydic.fsc.po.FscFinanceWriteOffAdjustDetailPO;
import com.tydic.fsc.po.FscFinanceWriteOffAdjustPO;
import com.tydic.fsc.po.FscOrderPO;
import com.tydic.fsc.po.FscOrderPayItemPO;
import com.tydic.fsc.po.FscTaskCandidatePO;
import com.tydic.fsc.po.UocApprovalLogPO;
import com.tydic.uac.ability.UacNoTaskAuditOrderAuditAbilityService;
import com.tydic.uac.ability.bo.UacNoTaskAuditOrderAuditReqBO;
import com.tydic.uac.ability.bo.UacNoTaskAuditOrderAuditRspBO;
import com.tydic.uac.bo.common.UacNoneInstanceBO;
import com.tydic.uac.constant.UacCommConstant;
import java.math.BigDecimal;
import java.math.RoundingMode;
import java.util.ArrayList;
import java.util.Collection;
import java.util.Collections;
import java.util.Date;
import java.util.HashMap;
import java.util.List;
import java.util.Map;
import java.util.stream.Collectors;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;
import org.springframework.beans.factory.annotation.Autowired;
import org.springframework.stereotype.Service;
import org.springframework.util.CollectionUtils;
import org.springframework.util.StringUtils;

@Service
public class FscFinanceWriteOffApprovalServiceBusiImpl
implements FscFinanceWriteOffApprovalBusiService {
    private static final Logger log = LoggerFactory.getLogger(FscFinanceWriteOffApprovalServiceBusiImpl.class);
    @Autowired
    private TaskTodoWaitService taskTodoWaitService;
    @Autowired
    private FscOrderMapper fscOrderMapper;
    @Autowired
    private UacNoTaskAuditOrderAuditAbilityService uacNoTaskAuditOrderAuditAbilityService;
    @Autowired
    private FscDictionaryBusiService fscDictionaryBusiService;
    @Autowired
    private FscOrderStatusFlowAtomService fscOrderStatusFlowAtomService;
    @Autowired
    private FscSendNotificationExtAtomService fscSendNotificationExtAtomService;
    @Autowired
    private FscTaskCandidateMapper fscTaskCandidateMapper;
    @Autowired
    private FscFinanceWriteOffAdjustMapper fscFinanceWriteOffAdjustMapper;
    @Autowired
    private FscFinanceWriteOffAdjustDetailMapper fscFinanceWriteOffAdjustDetailMapper;
    @Autowired
    private FscOrderPayItemMapper fscOrderPayItemMapper;
    @Autowired
    private DycStationOrgSelectUserNameService dycStationOrgSelectUserNameService;
    private static final String BUSI_NAME = "\u7ed3\u7b97\u8865\u6838\u9500\u7533\u8bf7";

    @Override
    public void dealFinanceWriteOffApproval(FscFinanceWriteOffApprovalServiceReqBo reqBo) {
        UocApprovalLogPO uocApprovalLogPO = null;
        try {
            uocApprovalLogPO = this.taskTodoWaitService.listApproval(reqBo.getFscOrderId());
        }
        catch (Exception e) {
            log.error("dealFinanceWriteOffApproval get stationId error:" + e);
        }
        UacNoTaskAuditOrderAuditRspBO approvalResult = this.getApprovalResult(reqBo, uocApprovalLogPO);
        UacNoneInstanceBO noneInstanceBO = approvalResult.getNoneInstanceBO();
        String auditResult = noneInstanceBO.getAuditResult();
        Boolean finish = noneInstanceBO.getFinish();
        FscOrderPO fscOrderPO = new FscOrderPO();
        fscOrderPO.setFscOrderId(reqBo.getFscOrderId());
        fscOrderPO = this.fscOrderMapper.getModelBy(fscOrderPO);
        FscOrderPO orderPO = new FscOrderPO();
        orderPO.setFscOrderId(reqBo.getFscOrderId());
        orderPO.setSignOperId((StringUtils.isEmpty((Object)fscOrderPO.getSignOperId()) ? "" : fscOrderPO.getSignOperId()) + reqBo.getUserId().toString() + ",");
        orderPO.setSignOperName(reqBo.getName());
        orderPO.setSignOperTime(new Date());
        Map orderTypeMap = this.fscDictionaryBusiService.queryBypCodeBackMap("FSC_ORDER_TYPE");
        String orderTypeStr = fscOrderPO.getOrderType() == 2 && fscOrderPO.getTradeMode() != null && fscOrderPO.getTradeMode() == 2 && fscOrderPO.getOrderSource() == 3 && fscOrderPO.getSettlePlatform() != null && fscOrderPO.getSettlePlatform() == 2 ? "\u81ea\u9700\u91c7\u8d2d" : (String)orderTypeMap.get(fscOrderPO.getOrderType() + "");
        Long adjustId = reqBo.getAdjustId();
        FscFinanceWriteOffAdjustPO set = new FscFinanceWriteOffAdjustPO();
        set.setAuditOperId(reqBo.getUserId().toString());
        set.setAuditOperName(reqBo.getName());
        set.setAuditOperTime(new Date());
        if ("0".equals(auditResult)) {
            FscTaskCandidatePO taskPo;
            if (finish.booleanValue()) {
                fscOrderPO.setSendState(FscOrderSendStateEnum.PASS.getCode());
                this.fscOrderMapper.updateById(fscOrderPO);
                taskPo = new FscTaskCandidatePO();
                taskPo.setFscOrderId(reqBo.getFscOrderId());
                List pendAuditPostIdList = this.fscTaskCandidateMapper.getPendAuditPostIdList(taskPo);
                if (CollectionUtil.isNotEmpty((Collection)pendAuditPostIdList)) {
                    DycStationOrgSelectUserNameReqBO dycStationOrgSelectUserNameReqBO = new DycStationOrgSelectUserNameReqBO();
                    dycStationOrgSelectUserNameReqBO.setStationId(Long.valueOf(((FscApprovalTaskQueryBO)pendAuditPostIdList.get(0)).getTaskOperId()));
                    DycStationOrgSelectUserNameRspBO dycStationOrgSelectUserNameRspBO = this.dycStationOrgSelectUserNameService.selectUserName(dycStationOrgSelectUserNameReqBO);
                    if (dycStationOrgSelectUserNameRspBO != null && !CollectionUtils.isEmpty((Collection)dycStationOrgSelectUserNameRspBO.getUserList())) {
                        FscSendNotificationExtAtomReqBO fscSendNotificationExtAtomReqBO = new FscSendNotificationExtAtomReqBO();
                        fscSendNotificationExtAtomReqBO.setTitel(fscOrderPO.getOrderNo() + "\u91c7\u8d2d\u7ed3\u7b97_" + orderTypeStr + "_" + fscOrderPO.getTotalCharge().setScale(2, RoundingMode.HALF_UP) + "\u5ba1\u6279\u901a\u8fc7");
                        fscSendNotificationExtAtomReqBO.setText("\u3010\u4e2d\u56fd\u4e2d\u7164\u3011\u60a8\u6709\u5f85\u91c7\u8d2d\u7ed3\u7b97\u5355" + fscOrderPO.getOrderNo() + "\u5df2\u901a\u8fc7\u5ba1\u6279\u3002");
                        fscSendNotificationExtAtomReqBO.setUserId(reqBo.getUserId());
                        fscSendNotificationExtAtomReqBO.setReceiveIds(dycStationOrgSelectUserNameRspBO.getUserList().stream().map(UserBO::getUserId).distinct().collect(Collectors.toList()));
                        this.fscSendNotificationExtAtomService.sendNotification(fscSendNotificationExtAtomReqBO);
                    }
                }
                set.setBillStatus(FscConstants.WriteOffBillStatus.AUDIT_SUCCESS);
            } else {
                taskPo = new FscTaskCandidatePO();
                taskPo.setFscOrderId(reqBo.getFscOrderId());
                List pendAuditPostIdList = this.fscTaskCandidateMapper.getPendAuditPostIdList(taskPo);
                if (CollectionUtils.isEmpty((Collection)pendAuditPostIdList)) {
                    throw new FscBusinessException("198888", "\u83b7\u53d6\u5c97\u4f4d\u4fe1\u606f\u5f02\u5e38");
                }
                List auditedPostIdList = pendAuditPostIdList.stream().map(FscApprovalTaskQueryBO::getTaskOperId).distinct().collect(Collectors.toList());
                orderPO.setSignStation(Joiner.on((String)",").join(auditedPostIdList) + ",");
            }
        } else {
            fscOrderPO.setSendState(FscOrderSendStateEnum.REFUSE.getCode());
            this.fscOrderMapper.updateById(fscOrderPO);
            FscOrderPO fscSignTemp = this.fscOrderMapper.getOrderSignTemp(reqBo.getFscOrderId());
            FscSendNotificationExtAtomReqBO fscSendNotificationExtAtomReqBO = new FscSendNotificationExtAtomReqBO();
            fscSendNotificationExtAtomReqBO.setTitel(fscOrderPO.getOrderNo() + "\u91c7\u8d2d\u7ed3\u7b97_" + orderTypeStr + "_" + fscOrderPO.getTotalCharge().setScale(2, RoundingMode.HALF_UP) + "\u5ba1\u6279\u9a73\u56de");
            fscSendNotificationExtAtomReqBO.setText("\u3010\u4e2d\u56fd\u4e2d\u7164\u3011\u60a8\u6709\u7b7e\u6536\u7684\u91c7\u8d2d\u7ed3\u7b97\u5355 " + fscOrderPO.getOrderNo() + "\u88ab\u5ba1\u6279\u9a73\u56de\u3002");
            fscSendNotificationExtAtomReqBO.setUserId(reqBo.getUserId());
            fscSendNotificationExtAtomReqBO.setReceiveIds(Collections.singletonList(fscSignTemp.getUserId()));
            this.fscSendNotificationExtAtomService.sendNotification(fscSendNotificationExtAtomReqBO);
            set.setBillStatus(FscConstants.WriteOffBillStatus.AUDIT_FAIL);
            FscFinanceWriteOffAdjustDetailPO adjustDetailPO = new FscFinanceWriteOffAdjustDetailPO();
            adjustDetailPO.setAdjustId(adjustId);
            List list = this.fscFinanceWriteOffAdjustDetailMapper.getList(adjustDetailPO);
            for (FscFinanceWriteOffAdjustDetailPO detailPO : list) {
                FscOrderPayItemPO fscOrderPayItemPO = new FscOrderPayItemPO();
                fscOrderPayItemPO.setOrderPayItemId(detailPO.getOrderPayDetailId());
                BigDecimal writeOffAmt = reqBo.getBillType() == 1L ? detailPO.getWriteOffAmt().negate() : detailPO.getWriteOffAmt();
                fscOrderPayItemPO.setPurWriteOffAmount(writeOffAmt);
                this.fscOrderPayItemMapper.updatePurWriteOffAmountAdd(fscOrderPayItemPO);
            }
            BigDecimal writeOffAmt = reqBo.getBillType() == 1L ? reqBo.getWriteOffAmt().negate() : reqBo.getWriteOffAmt();
            FscOrderPO fscOrderPo = new FscOrderPO();
            fscOrderPo.setFscOrderId(reqBo.getFscOrderId());
            fscOrderPo.setPurWriteOffAmount(writeOffAmt);
            this.fscOrderMapper.updatePurWriteOffAmountAdd(fscOrderPo);
        }
        FscFinanceWriteOffAdjustPO where = new FscFinanceWriteOffAdjustPO();
        where.setAdjustId(adjustId);
        this.fscFinanceWriteOffAdjustMapper.updateBy(set, where);
        this.fscOrderMapper.updateById(orderPO);
    }

    private UacNoTaskAuditOrderAuditRspBO getApprovalResult(FscFinanceWriteOffApprovalServiceReqBo reqBO, UocApprovalLogPO uocApprovalLogPO) {
        UacNoTaskAuditOrderAuditReqBO auditReqBO = new UacNoTaskAuditOrderAuditReqBO();
        ArrayList<Long> objIdList = new ArrayList<Long>();
        objIdList.add(reqBO.getFscOrderId());
        auditReqBO.setObjId(objIdList);
        Integer objType = FscConstants.AuditObjType.FINANCE_WRITEOFF;
        String stepId = this.fscOrderMapper.selectStepId(reqBO.getFscOrderId(), objType, UacCommConstant.STATUS.UNDER_REVIEW);
        auditReqBO.setAuditResult(reqBO.getAuditResult());
        auditReqBO.setAuditAdvice(reqBO.getAuditAdvice());
        auditReqBO.setStepId(stepId);
        auditReqBO.setOperId(String.valueOf(reqBO.getUserId()));
        auditReqBO.setUsername(reqBO.getName());
        auditReqBO.setObjType(objType);
        auditReqBO.setOperDept(reqBO.getOrgName());
        HashMap<String, Integer> paramMap = new HashMap<String, Integer>(4);
        paramMap.put("auditResult", reqBO.getAuditResult().equals(FscConstants.AuditResultStatus.PASS) ? FscConstants.AuditResultStatus.PASS : FscConstants.AuditResultStatus.REFUSE);
        auditReqBO.setVariables(paramMap);
        if (StringUtils.hasText((String)reqBO.getAuditAdvice())) {
            auditReqBO.setAuditAdvice(reqBO.getAuditAdvice());
        }
        if (log.isDebugEnabled()) {
            log.debug("\u8c03\u7528\u5ba1\u6279\u4e2d\u5fc3\u5165\u53c2\uff1a{}", (Object)JSON.toJSONString((Object)auditReqBO));
        }
        HashMap variables = new HashMap();
        auditReqBO.setVariables(variables);
        UacNoTaskAuditOrderAuditRspBO auditRspBO = this.uacNoTaskAuditOrderAuditAbilityService.dealAudit(auditReqBO);
        if (log.isDebugEnabled()) {
            log.debug("\u8c03\u7528\u5ba1\u6279\u4e2d\u5fc3\u51fa\u53c2\uff1a{}", (Object)JSON.toJSONString((Object)auditRspBO));
        }
        if (!"0000".equals(auditRspBO.getRespCode())) {
            throw new FscBusinessException("193108", auditRspBO.getRespDesc());
        }
        return auditRspBO;
    }
}

