/*
 * Decompiled with CFR 0.152.
 */
package com.tydic.fsc.bill.busi.impl;

import com.alibaba.fastjson.JSONObject;
import com.tydic.fsc.bill.busi.api.FscOrderPayNoticeBusiService;
import com.tydic.fsc.bill.busi.bo.FscOrderPayNoticeBusiReqBO;
import com.tydic.fsc.bill.busi.bo.FscOrderPayNoticeBusiRspBO;
import com.tydic.fsc.constants.FscConstants;
import com.tydic.fsc.dao.FscOrderItemMapper;
import com.tydic.fsc.dao.FscOrderMapper;
import com.tydic.fsc.dao.FscShouldPayMapper;
import com.tydic.fsc.exception.FscBusinessException;
import com.tydic.fsc.po.FscOrderItemPO;
import com.tydic.fsc.po.FscOrderPO;
import com.tydic.fsc.po.FscShouldPayPO;
import com.tydic.uoc.common.ability.api.UocProOrderZqPaymentCallbackAbilityService;
import com.tydic.uoc.common.ability.bo.UocProOrderZqPaymentCallbackAbilityReqBO;
import com.tydic.uoc.common.ability.bo.UocProOrderZqPaymentCallbackAbilityRspBO;
import java.math.BigDecimal;
import java.util.Collection;
import java.util.List;
import java.util.Objects;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;
import org.springframework.beans.factory.annotation.Autowired;
import org.springframework.stereotype.Service;
import org.springframework.transaction.annotation.Isolation;
import org.springframework.transaction.annotation.Transactional;
import org.springframework.util.CollectionUtils;
import org.springframework.util.StringUtils;

@Service
public class FscOrderPayNoticeBusiServiceImpl
implements FscOrderPayNoticeBusiService {
    private static final Logger log = LoggerFactory.getLogger(FscOrderPayNoticeBusiServiceImpl.class);
    @Autowired
    private FscShouldPayMapper fscShouldPayMapper;
    @Autowired
    private FscOrderMapper fscOrderMapper;
    @Autowired
    private FscOrderItemMapper fscOrderItemMapper;
    @Autowired
    private UocProOrderZqPaymentCallbackAbilityService uocProOrderZqPaymentCallbackAbilityService;

    @Override
    @Transactional(isolation=Isolation.READ_UNCOMMITTED)
    public FscOrderPayNoticeBusiRspBO noticeOrderPay(FscOrderPayNoticeBusiReqBO reqBO) {
        this.valid(reqBO);
        FscShouldPayPO fscShouldPayPo = new FscShouldPayPO();
        fscShouldPayPo.setShouldPayStatus(FscConstants.ShouldPayStatus.PAYED);
        fscShouldPayPo.setObjectNo(reqBO.getOrderCode());
        fscShouldPayPo.setPayeeId(reqBO.getPayeeId());
        BigDecimal prePaidAmount = this.fscShouldPayMapper.sumPayPaidAmt(fscShouldPayPo);
        FscOrderPO fscOrderPO = new FscOrderPO();
        fscOrderPO.setOrderNo(reqBO.getOrderCode());
        fscOrderPO.setPayeeId(reqBO.getPayeeId());
        List settleNoList = this.fscOrderMapper.getOrderSettleNoByOrderCodes(fscOrderPO);
        fscShouldPayPo.setObjectNo(null);
        fscShouldPayPo.setObjectNos(settleNoList);
        BigDecimal shouldPaidAmount = this.fscShouldPayMapper.sumPayPaidAmt(fscShouldPayPo);
        BigDecimal totalPaidAmt = prePaidAmount.add(shouldPaidAmount);
        if (reqBO.getNoShouldPayData() != null && reqBO.getNoShouldPayData() == 1 && reqBO.getFscOrderId() != null) {
            FscOrderItemPO fscOrderItemPO = new FscOrderItemPO();
            fscOrderItemPO.setFscOrderId(reqBO.getFscOrderId());
            fscOrderItemPO.setOrderCode(reqBO.getOrderCode());
            List list = this.fscOrderItemMapper.getList(fscOrderItemPO);
            if (!CollectionUtils.isEmpty((Collection)list)) {
                BigDecimal reduce = list.stream().map(FscOrderItemPO::getAmt).filter(Objects::nonNull).reduce(BigDecimal.ZERO, BigDecimal::add);
                totalPaidAmt = totalPaidAmt.add(reduce);
            }
        }
        UocProOrderZqPaymentCallbackAbilityReqBO abilityReqBO = new UocProOrderZqPaymentCallbackAbilityReqBO();
        abilityReqBO.setOrderCode(reqBO.getOrderCode());
        abilityReqBO.setPayFlag(reqBO.getPayFlag());
        abilityReqBO.setPayeeId(reqBO.getPayeeId());
        abilityReqBO.setTotalPaidAmt(totalPaidAmt.multiply(new BigDecimal(10000)));
        log.debug("\u8c03\u7528\u8ba2\u5355\u4e2d\u5fc3\u540c\u6b65\u4ed8\u6b3e\u72b6\u6001\u5165\u53c2\uff1a" + JSONObject.toJSONString((Object)abilityReqBO));
        UocProOrderZqPaymentCallbackAbilityRspBO abilityRspBO = this.uocProOrderZqPaymentCallbackAbilityService.dealZqPaymentCallBack(abilityReqBO);
        log.debug("\u8c03\u7528\u8ba2\u5355\u4e2d\u5fc3\u540c\u6b65\u4ed8\u6b3e\u72b6\u6001\u51fa\u53c2\uff1a" + JSONObject.toJSONString((Object)abilityRspBO));
        if (!abilityRspBO.getRespCode().equals("0000")) {
            throw new FscBusinessException(abilityRspBO.getRespCode(), abilityRspBO.getRespDesc());
        }
        FscOrderPayNoticeBusiRspBO busiRspBO = new FscOrderPayNoticeBusiRspBO();
        busiRspBO.setRespCode("0000");
        busiRspBO.setRespDesc("\u6210\u529f");
        return busiRspBO;
    }

    private void valid(FscOrderPayNoticeBusiReqBO reqBO) {
        if (StringUtils.isEmpty((Object)reqBO.getOrderCode())) {
            throw new FscBusinessException("198888", "\u5165\u53c2[orderCode]\u4e0d\u80fd\u4e3a\u7a7a!");
        }
        if (StringUtils.isEmpty((Object)reqBO.getPayerId())) {
            throw new FscBusinessException("198888", "\u5165\u53c2[payerId]\u4e0d\u80fd\u4e3a\u7a7a!");
        }
        if (StringUtils.isEmpty((Object)reqBO.getPayeeId())) {
            throw new FscBusinessException("198888", "\u5165\u53c2[payeeId]\u4e0d\u80fd\u4e3a\u7a7a!");
        }
    }
}

