/*
 * Decompiled with CFR 0.152.
 */
package com.tydic.fsc.bill.consumer;

import com.alibaba.fastjson.JSONObject;
import com.ohaotian.plugin.mq.proxy.DefaultProxyMessageConfig;
import com.ohaotian.plugin.mq.proxy.ProxyMessage;
import com.ohaotian.plugin.mq.proxy.ProxyMessageConsumer;
import com.ohaotian.plugin.mq.proxy.status.ProxyConsumerStatus;
import com.tydic.fsc.bill.busi.api.FscBillEcomDealInvoiceMsgBusiService;
import com.tydic.fsc.bill.busi.bo.FscBillEcomDealInvoiceMsgBusiReqBO;
import com.tydic.fsc.bill.busi.bo.FscBillEcomDealInvoiceMsgBusiRspBO;
import com.tydic.fsc.busibase.busi.api.FscOrderFailLogUpdateBusiService;
import com.tydic.fsc.busibase.busi.bo.FscOrderFailLogUpdateBusiReqBO;
import com.tydic.fsc.common.ability.api.FscComOrderSyncAbilityService;
import com.tydic.fsc.common.ability.bo.FscComOrderListSyncAbilityReqBO;
import com.tydic.fsc.constants.FscConstants;
import com.tydic.fsc.exception.FscBusinessException;
import java.util.Date;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;
import org.springframework.beans.factory.annotation.Autowired;
import org.springframework.util.CollectionUtils;

public class FscEcomInvoiceMsgDealServiceConsumer
extends DefaultProxyMessageConfig
implements ProxyMessageConsumer {
    private static final Logger log = LoggerFactory.getLogger(FscEcomInvoiceMsgDealServiceConsumer.class);
    @Autowired
    private FscBillEcomDealInvoiceMsgBusiService fscBillEcomDealInvoiceMsgBusiService;
    @Autowired
    private FscComOrderSyncAbilityService fscComOrderSyncAbilityService;
    @Autowired
    private FscOrderFailLogUpdateBusiService fscOrderFailLogUpdateBusiService;

    public ProxyConsumerStatus onMessage(ProxyMessage message) {
        try {
            FscBillEcomDealInvoiceMsgBusiReqBO reqBO;
            FscBillEcomDealInvoiceMsgBusiRspBO rspBO;
            if (log.isDebugEnabled()) {
                log.debug("\u7535\u5546\u6d88\u606f\u5904\u7406\u6d88\u8d39\u8005\u5165\u53c2:{}", (Object)message.getContent());
            }
            if (!(rspBO = this.fscBillEcomDealInvoiceMsgBusiService.dealEcomInvoiceMsg(reqBO = (FscBillEcomDealInvoiceMsgBusiReqBO)JSONObject.parseObject((String)message.getContent(), FscBillEcomDealInvoiceMsgBusiReqBO.class))).getRespCode().equals("0000")) {
                this.writeFailLog(reqBO.getSupplierId(), rspBO.getRespDesc(), JSONObject.toJSONString((Object)reqBO));
                throw new FscBusinessException(rspBO.getRespCode(), rspBO.getRespDesc());
            }
            if (!CollectionUtils.isEmpty(rspBO.getFscOrderIds())) {
                for (Long fscOrderId : rspBO.getFscOrderIds()) {
                    FscComOrderListSyncAbilityReqBO abilityReqBO = new FscComOrderListSyncAbilityReqBO();
                    abilityReqBO.setFscOrderId(fscOrderId);
                    this.fscComOrderSyncAbilityService.dealComOrderSyncEs(abilityReqBO);
                }
            }
        }
        catch (Exception e) {
            log.error("\u7535\u5546\u6d88\u606f\u5904\u7406\u6d88\u8d39\u8005\u5f02\u5e38\uff01" + e);
            return ProxyConsumerStatus.CONSUME_SUCCESS;
        }
        return ProxyConsumerStatus.CONSUME_SUCCESS;
    }

    private void writeFailLog(Long id, String errorMsg, String busiFailReq) {
        FscOrderFailLogUpdateBusiReqBO fscOrderFailLogUpdateBusiReqBO = new FscOrderFailLogUpdateBusiReqBO();
        fscOrderFailLogUpdateBusiReqBO.setObjId(id);
        fscOrderFailLogUpdateBusiReqBO.setBusiFailDesc(errorMsg);
        fscOrderFailLogUpdateBusiReqBO.setBusiFailTime(new Date());
        fscOrderFailLogUpdateBusiReqBO.setBusiFailReq(busiFailReq);
        fscOrderFailLogUpdateBusiReqBO.setBusiType(FscConstants.FscOrderFailRetansBusiType.FSC_DEAL_ECOM_MSG_FAIL);
        this.fscOrderFailLogUpdateBusiService.dealInsert(fscOrderFailLogUpdateBusiReqBO);
    }
}

