/*
 * Decompiled with CFR 0.152.
 */
package com.tydic.fsc.bill.ability.impl;

import cn.hutool.core.collection.CollectionUtil;
import com.tydic.dyc.base.utils.JUtil;
import com.tydic.fsc.bill.ability.api.FscAddFinanceWriteOffAbilityService;
import com.tydic.fsc.bill.ability.bo.FscAddFinanceWriteOffReqBo;
import com.tydic.fsc.bill.ability.bo.FscAddFinanceWriteOffRspBo;
import com.tydic.fsc.bill.busi.api.FscAddFinanceWriteOffBusiService;
import com.tydic.fsc.bill.busi.bo.FscAddFinanceWriteOffBusiReqBo;
import com.tydic.fsc.bill.busi.bo.finance.FscAddFinanceWriteOffBusiRspBo;
import com.tydic.fsc.common.ability.api.FscEsSyncComOrderListAbilityService;
import com.tydic.fsc.common.ability.bo.FscEsSyncComOrderListReqBO;
import com.tydic.fsc.constants.FscConstants;
import com.tydic.fsc.dao.FscOrderMapper;
import com.tydic.fsc.exception.FscBusinessException;
import com.tydic.fsc.po.FscOrderPO;
import java.math.BigDecimal;
import java.util.Collection;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;
import org.springframework.beans.factory.annotation.Autowired;
import org.springframework.web.bind.annotation.PostMapping;
import org.springframework.web.bind.annotation.RequestBody;
import org.springframework.web.bind.annotation.RequestMapping;
import org.springframework.web.bind.annotation.RestController;

@RestController
@RequestMapping(value={"FSC_GROUP_DEV/1.0.0/com.tydic.fsc.bill.ability.api.FscAddFinanceWriteOffAbilityService"})
public class FscAddFinanceWriteOffAbilityServiceImpl
implements FscAddFinanceWriteOffAbilityService {
    private static final Logger log = LoggerFactory.getLogger(FscAddFinanceWriteOffAbilityServiceImpl.class);
    @Autowired
    private FscOrderMapper fscOrderMapper;
    @Autowired
    private FscAddFinanceWriteOffBusiService fscAddFinanceWriteOffBusiService;
    @Autowired
    private FscEsSyncComOrderListAbilityService fscEsSyncComOrderListAbilityService;

    @PostMapping(value={"dealFinanceWriteOff"})
    public FscAddFinanceWriteOffRspBo dealFinanceWriteOff(@RequestBody FscAddFinanceWriteOffReqBo reqBo) {
        if (null == reqBo || CollectionUtil.isEmpty((Collection)reqBo.getDetails())) {
            throw new FscBusinessException("191000", "\u8bf7\u6c42\u53c2\u6570\u4e0d\u80fd\u4e3a\u7a7a");
        }
        if (null == reqBo.getFscOrderId()) {
            throw new FscBusinessException("191000", "\u8bf7\u6c42\u53c2\u6570[fscOrderId]\u4e0d\u80fd\u4e3a\u7a7a");
        }
        if (null == reqBo.getWriteOffAmt()) {
            throw new FscBusinessException("191000", "\u8bf7\u6c42\u53c2\u6570[writeOffAmt]\u4e0d\u80fd\u4e3a\u7a7a");
        }
        if (null == reqBo.getBillType()) {
            throw new FscBusinessException("191000", "\u8bf7\u6c42\u53c2\u6570[billType]\u4e0d\u80fd\u4e3a\u7a7a");
        }
        FscOrderPO fscOrderPO = new FscOrderPO();
        fscOrderPO.setFscOrderId(reqBo.getFscOrderId());
        fscOrderPO = this.fscOrderMapper.getModelBy(fscOrderPO);
        if (null == fscOrderPO) {
            throw new FscBusinessException("191000", "\u83b7\u53d6\u4e3b\u5355\u4fe1\u606f\u4e3a\u7a7a");
        }
        BigDecimal purWriteOffAmountOld = fscOrderPO.getPurWriteOffAmount();
        BigDecimal purWriteOffAmountNew = purWriteOffAmountOld.add(reqBo.getWriteOffAmt());
        if (FscConstants.FinanceWriteOffType.ADD.equals(reqBo.getBillType()) && purWriteOffAmountNew.compareTo(reqBo.getPaidAmount()) > 0) {
            throw new FscBusinessException("190000", "\u603b\u6838\u9500\u91d1\u989d\u4e0d\u80fd\u5927\u4e8e\u4ed8\u6b3e\u91d1\u989d" + purWriteOffAmountNew);
        }
        if (FscConstants.FinanceWriteOffType.CANCELED.equals(reqBo.getBillType()) && reqBo.getWriteOffAmt().compareTo(reqBo.getPaidAmount()) > 0) {
            throw new FscBusinessException("190000", "\u64a4\u6838\u9500\u91d1\u989d\u4e0d\u80fd\u5927\u4e8e\u4ed8\u6b3e\u91d1\u989d");
        }
        FscAddFinanceWriteOffBusiReqBo busiReqBo = (FscAddFinanceWriteOffBusiReqBo)((Object)JUtil.js((Object)reqBo, FscAddFinanceWriteOffBusiReqBo.class));
        FscAddFinanceWriteOffBusiRspBo busiRspBo = this.fscAddFinanceWriteOffBusiService.dealFinanceWriteOff(busiReqBo);
        if ("0000".equals(busiRspBo.getRespCode())) {
            FscEsSyncComOrderListReqBO syncReqBO = new FscEsSyncComOrderListReqBO();
            syncReqBO.setFscOrderId(reqBo.getFscOrderId());
            this.fscEsSyncComOrderListAbilityService.dealOrderToEs(syncReqBO);
        }
        FscAddFinanceWriteOffRspBo rspBo = new FscAddFinanceWriteOffRspBo();
        rspBo.setRespDesc(busiRspBo.getRespDesc());
        rspBo.setRespCode(busiRspBo.getRespCode());
        return rspBo;
    }
}

