/*
 * Decompiled with CFR 0.152.
 */
package com.tydic.fsc.bill.ability.impl;

import com.alibaba.fastjson.JSONObject;
import com.ohaotian.plugin.mq.proxy.ProxyMessage;
import com.ohaotian.plugin.mq.proxy.ProxyMessageProducer;
import com.tydic.fsc.bill.ability.api.FscBillEcomDealMsgAbilityService;
import com.tydic.fsc.bill.ability.bo.FscBillEcomDealMsgAbilityReqBO;
import com.tydic.fsc.bill.ability.bo.FscBillEcomDealMsgAbilityRspBO;
import com.tydic.fsc.bill.busi.api.FscBillEcomDealInvoiceMsgBusiService;
import com.tydic.fsc.busibase.external.api.bo.FscEcomMsgExternalRspBO;
import com.tydic.fsc.busibase.external.api.bo.FscGetEcomMsgExternalReqBO;
import com.tydic.fsc.busibase.external.api.bo.FscGetEcomMsgExternalRspBO;
import com.tydic.fsc.busibase.external.api.esb.FscGetEcomMsgExternalService;
import com.tydic.fsc.constants.FscConstants;
import com.tydic.fsc.exception.FscBusinessException;
import javax.annotation.Resource;
import org.springframework.beans.factory.annotation.Autowired;
import org.springframework.beans.factory.annotation.Value;
import org.springframework.web.bind.annotation.PostMapping;
import org.springframework.web.bind.annotation.RequestBody;
import org.springframework.web.bind.annotation.RequestMapping;
import org.springframework.web.bind.annotation.RestController;

@RestController
@RequestMapping(value={"FSC_GROUP_DEV/1.0.0/com.tydic.fsc.bill.ability.api.FscBillEcomDealMsgAbilityService"})
public class FscBillEcomDealMsgAbilityServiceImpl
implements FscBillEcomDealMsgAbilityService {
    @Autowired
    private FscGetEcomMsgExternalService fscGetEcomMsgExternalService;
    @Autowired
    private FscBillEcomDealInvoiceMsgBusiService fscBillEcomDealInvoiceMsgBusiService;
    @Value(value="${FSC_INVOICE_MSG_DEAL_TOPIC:FSC_INVOICE_MSG_DEAL_TOPIC}")
    private String FSC_INVOICE_MSG_DEAL_TOPIC;
    @Value(value="${FSC_INVOICE_MSG_DEAL_TAG:*}")
    private String FSC_INVOICE_MSG_DEAL_TAG;
    @Resource(name="fscInvoiceMsgDealProvider")
    private ProxyMessageProducer fscInvoiceMsgDealProvider;
    @Value(value="${JD_SUP_ID:100055}")
    private Long JD_SUP_ID;
    @Value(value="${SUPPLIER_JD_ID_FL:202200511}")
    private Long jdIdFl;

    @PostMapping(value={"dealEcomMsg"})
    public FscBillEcomDealMsgAbilityRspBO dealEcomMsg(@RequestBody FscBillEcomDealMsgAbilityReqBO reqBO) {
        this.valid(reqBO);
        FscBillEcomDealMsgAbilityRspBO rspBO = new FscBillEcomDealMsgAbilityRspBO();
        FscGetEcomMsgExternalReqBO externalReqBO = new FscGetEcomMsgExternalReqBO();
        if (reqBO.getSupplierId().equals(this.jdIdFl) || reqBO.getSupplierId().equals(this.JD_SUP_ID)) {
            externalReqBO.setType(FscConstants.EcomMsgType.JD_INVOICE_PROGRESS);
        } else {
            externalReqBO.setType(FscConstants.EcomMsgType.INVOICE_PROGRESS);
        }
        externalReqBO.setSupplierId(reqBO.getSupplierId());
        FscGetEcomMsgExternalRspBO externalRspBO = this.fscGetEcomMsgExternalService.getEcomMsg(externalReqBO);
        if (!externalRspBO.getRespCode().equals("0000")) {
            rspBO.setRespCode(externalRspBO.getRespCode());
            rspBO.setRespDesc(externalRspBO.getRespDesc());
            return rspBO;
        }
        for (FscEcomMsgExternalRspBO fscEcomMsgExternalRspBO : externalRspBO.getResult()) {
            fscEcomMsgExternalRspBO.setSupplierId(reqBO.getSupplierId());
            String reqParam = JSONObject.toJSONString((Object)fscEcomMsgExternalRspBO);
            this.fscInvoiceMsgDealProvider.send(new ProxyMessage(this.FSC_INVOICE_MSG_DEAL_TOPIC, this.FSC_INVOICE_MSG_DEAL_TAG, reqParam));
        }
        rspBO.setRespCode("0000");
        rspBO.setRespDesc("\u6210\u529f");
        return rspBO;
    }

    public void valid(FscBillEcomDealMsgAbilityReqBO reqBO) {
        if (reqBO == null) {
            throw new FscBusinessException("190000", "\u5165\u53c2\u4e0d\u80fd\u4e3a\u7a7a\uff01");
        }
        if (reqBO.getSupplierId() == null) {
            throw new FscBusinessException("190000", "\u5165\u53c2[supplierId]\u4e0d\u80fd\u4e3a\u7a7a\uff01");
        }
    }
}

