/*
 * Decompiled with CFR 0.152.
 */
package com.tydic.fsc.bill.ability.impl;

import com.alibaba.fastjson.JSONObject;
import com.ohaotian.plugin.base.exception.ZTBusinessException;
import com.ohaotian.plugin.mq.proxy.ProxyMessage;
import com.ohaotian.plugin.mq.proxy.ProxyMessageProducer;
import com.ohaotian.plugin.mq.proxy.ProxySendResult;
import com.tydic.fsc.bill.ability.api.FscBillOrderCreateReopenShouldPayAbilityService;
import com.tydic.fsc.bill.ability.bo.FscBillOrderCreateReopenShouldPayAbilityReqBO;
import com.tydic.fsc.bill.ability.bo.FscBillOrderCreateReopenShouldPayAbilityRspBO;
import com.tydic.fsc.bill.busi.api.FscBillOrderCreateReopenShouldPayBusiService;
import com.tydic.fsc.bill.busi.bo.FscBillOrderCreateReopenShouldPayBusiReqBO;
import com.tydic.fsc.bill.busi.bo.FscBillOrderCreateReopenShouldPayBusiRspBO;
import com.tydic.fsc.bo.FscShouldPayBO;
import com.tydic.fsc.busibase.atom.api.FscAcceptOrderListQueryAtomService;
import com.tydic.fsc.busibase.atom.api.FscSaleOrderListQueryAtomService;
import com.tydic.fsc.busibase.atom.bo.FscAcceptOrderListQueryAtomReqBO;
import com.tydic.fsc.busibase.atom.bo.FscAcceptOrderListQueryAtomRspBO;
import com.tydic.fsc.busibase.atom.bo.FscSaleOrderListQueryAtomReqBO;
import com.tydic.fsc.busibase.atom.bo.FscSaleOrderListQueryAtomRspBO;
import com.tydic.fsc.common.ability.api.FscComInvoiceSyncAbilityService;
import com.tydic.fsc.common.ability.api.FscEsSyncComOrderListAbilityService;
import com.tydic.fsc.common.ability.bo.FscComInvoiceListSyncAbilityReqBO;
import com.tydic.fsc.common.ability.bo.FscEsSyncComOrderListReqBO;
import com.tydic.fsc.constants.FscConstants;
import com.tydic.fsc.dao.FscInvoiceMapper;
import com.tydic.fsc.dao.FscOrderMapper;
import com.tydic.fsc.dao.FscOrderRefundMapper;
import com.tydic.fsc.dao.FscRefundPayItemMapper;
import com.tydic.fsc.dao.FscRefundPaymentDetailMapper;
import com.tydic.fsc.dao.FscShouldPayMapper;
import com.tydic.fsc.exception.FscBusinessException;
import com.tydic.fsc.po.FscOrderPO;
import com.tydic.fsc.po.FscOrderRefundPO;
import com.tydic.fsc.po.FscShouldPayPO;
import java.math.BigDecimal;
import java.util.ArrayList;
import java.util.Collection;
import java.util.HashMap;
import java.util.HashSet;
import java.util.List;
import java.util.Map;
import java.util.Set;
import java.util.stream.Collectors;
import javax.annotation.Resource;
import org.springframework.beans.BeanUtils;
import org.springframework.beans.factory.annotation.Autowired;
import org.springframework.beans.factory.annotation.Value;
import org.springframework.util.CollectionUtils;
import org.springframework.web.bind.annotation.PostMapping;
import org.springframework.web.bind.annotation.RequestBody;
import org.springframework.web.bind.annotation.RequestMapping;
import org.springframework.web.bind.annotation.RestController;

@RestController
@RequestMapping(value={"FSC_GROUP_DEV/1.0.0/com.tydic.fsc.bill.ability.api.FscBillOrderCreateReopenShouldPayAbilityService"})
public class FscBillOrderCreateReopenShouldPayAbilityServiceImpl
implements FscBillOrderCreateReopenShouldPayAbilityService {
    @Autowired
    private FscOrderRefundMapper fscOrderRefundMapper;
    @Autowired
    private FscOrderMapper fscOrderMapper;
    @Autowired
    private FscShouldPayMapper fscShouldPayMapper;
    @Autowired
    private FscInvoiceMapper fscInvoiceMapper;
    @Autowired
    private FscAcceptOrderListQueryAtomService fscAcceptOrderListQueryAtomService;
    @Autowired
    private FscSaleOrderListQueryAtomService fscSaleOrderListQueryAtomService;
    @Autowired
    private FscRefundPaymentDetailMapper fscRefundPaymentDetailMapper;
    @Autowired
    private FscRefundPayItemMapper fscRefundPayItemMapper;
    @Autowired
    private FscBillOrderCreateReopenShouldPayBusiService fscBillOrderCreateReopenShouldPayBusiService;
    @Autowired
    private FscEsSyncComOrderListAbilityService fscEsSyncComOrderListAbilityService;
    @Autowired
    private FscComInvoiceSyncAbilityService fscComInvoiceSyncAbilityService;
    @Value(value="${es.FSC_SIGN_BACK_FILL_INVOICE_TOPIC:FSC_SIGN_BACK_FILL_INVOICE_TOPIC}")
    private String fscSignBackFillInvoiceTopic;
    @Value(value="${es.FSC_SIGN_BACK_FILL_INVOICE_TAG:FSC_SIGN_BACK_FILL_INVOICE_TAG}")
    private String fscSignBackFillInvoiceTag;
    @Resource(name="fscSignBackFillInvoiceMqServiceProvider")
    private ProxyMessageProducer fscSignBackFillInvoiceMqServiceProvider;

    @PostMapping(value={"createReopenShouldPay"})
    public FscBillOrderCreateReopenShouldPayAbilityRspBO createReopenShouldPay(@RequestBody FscBillOrderCreateReopenShouldPayAbilityReqBO reqBO) {
        FscOrderPO fscOrderPO = new FscOrderPO();
        fscOrderPO.setFscOrderId(reqBO.getOrderId());
        fscOrderPO = this.fscOrderMapper.getModelBy(fscOrderPO);
        if (null == fscOrderPO) {
            throw new FscBusinessException("191019", "\u7ed3\u7b97\u4e3b\u5355\u4e0d\u5b58\u5728");
        }
        String billDateMax = this.fscInvoiceMapper.setInvoiceBillDate(fscOrderPO.getFscOrderId());
        HashSet<String> orderCodeList = new HashSet<String>();
        HashSet<String> orderOperList = new HashSet<String>();
        ArrayList<FscShouldPayBO> fscShouldPayBOS = new ArrayList<FscShouldPayBO>();
        if (fscOrderPO.getRefundId() != null) {
            FscOrderRefundPO refundPO = new FscOrderRefundPO();
            refundPO.setRefundId(fscOrderPO.getRefundId());
            refundPO = this.fscOrderRefundMapper.getModelBy(refundPO);
            if (refundPO.getToPayAmount().compareTo(BigDecimal.ZERO) > 0) {
                if (CollectionUtils.isEmpty((Collection)reqBO.getOrderCodeList()) || CollectionUtils.isEmpty((Collection)reqBO.getOrderOperList())) {
                    this.getOrderCode(fscOrderPO, orderCodeList, orderOperList);
                } else {
                    orderCodeList.addAll(reqBO.getOrderCodeList());
                    orderOperList.addAll(reqBO.getOrderOperList());
                }
                this.createReopenShouldPay(fscOrderPO, fscShouldPayBOS, orderCodeList, orderOperList, billDateMax);
            }
        }
        FscBillOrderCreateReopenShouldPayBusiReqBO busiReqBO = new FscBillOrderCreateReopenShouldPayBusiReqBO();
        busiReqBO.setFscShouldPayBOS(fscShouldPayBOS);
        busiReqBO.setOrderId(reqBO.getOrderId());
        busiReqBO.setRefundId(fscOrderPO.getRefundId());
        FscBillOrderCreateReopenShouldPayBusiRspBO busiRspBO = this.fscBillOrderCreateReopenShouldPayBusiService.createReopenShouldPay(busiReqBO);
        if (!"0000".equals(busiRspBO.getRespCode())) {
            throw new ZTBusinessException("\u4ed8\u6b3e\u5355\u8f6c\u79fb\u5931\u8d25" + busiRspBO.getRespDesc());
        }
        if (reqBO.getSyncESFlag() == null) {
            this.sendMq(reqBO.getOrderId());
        }
        FscBillOrderCreateReopenShouldPayAbilityRspBO rspBO = new FscBillOrderCreateReopenShouldPayAbilityRspBO();
        rspBO.setRespCode("0000");
        rspBO.setRespDesc("\u6210\u529f");
        return rspBO;
    }

    private void getOrderCode(FscOrderPO fscOrderPO, Set<String> orderCodeList, Set<String> orderOperList) {
        if (fscOrderPO.getSettleType() == null || fscOrderPO.getSettleType().equals(FscConstants.SettleType.INSPECTION)) {
            FscAcceptOrderListQueryAtomReqBO fscAcceptOrderListQueryAtomReqBO = new FscAcceptOrderListQueryAtomReqBO();
            fscAcceptOrderListQueryAtomReqBO.setRelId(fscOrderPO.getFscOrderId());
            FscAcceptOrderListQueryAtomRspBO fscAcceptOrderListQueryAtomRspBO = this.fscAcceptOrderListQueryAtomService.query(fscAcceptOrderListQueryAtomReqBO);
            if (!"0000".equals(fscAcceptOrderListQueryAtomRspBO.getRespCode())) {
                throw new FscBusinessException("191019", fscAcceptOrderListQueryAtomRspBO.getRespDesc());
            }
            if (CollectionUtils.isEmpty((Map)fscAcceptOrderListQueryAtomRspBO.getFscOrderInfoBoMap())) {
                throw new FscBusinessException("191019", "\u67e5\u8be2\u8ba2\u5355MAP\u4e3a\u7a7a");
            }
            if (!CollectionUtils.isEmpty((Collection)fscAcceptOrderListQueryAtomRspBO.getOrderCodeList())) {
                orderCodeList.addAll(fscAcceptOrderListQueryAtomRspBO.getOrderCodeList());
            }
            if (!CollectionUtils.isEmpty((Collection)fscAcceptOrderListQueryAtomRspBO.getOrderOperList())) {
                orderOperList.addAll(fscAcceptOrderListQueryAtomRspBO.getOrderOperList());
            }
        } else {
            FscSaleOrderListQueryAtomReqBO atomReqBO = new FscSaleOrderListQueryAtomReqBO();
            atomReqBO.setRelId(fscOrderPO.getFscOrderId());
            FscSaleOrderListQueryAtomRspBO fscSaleOrderListQueryAtomRspBO = this.fscSaleOrderListQueryAtomService.qrySaleOrderList(atomReqBO);
            if (!"0000".equals(fscSaleOrderListQueryAtomRspBO.getRespCode())) {
                throw new FscBusinessException("191019", fscSaleOrderListQueryAtomRspBO.getRespDesc());
            }
            if (CollectionUtils.isEmpty((Map)fscSaleOrderListQueryAtomRspBO.getFscOrderInfoBoMap())) {
                throw new FscBusinessException("191019", "\u67e5\u8be2\u8ba2\u5355MAP\u4e3a\u7a7a");
            }
            if (!CollectionUtils.isEmpty((Collection)fscSaleOrderListQueryAtomRspBO.getOrderCodeList())) {
                orderCodeList.addAll(fscSaleOrderListQueryAtomRspBO.getOrderCodeList());
            }
            if (!CollectionUtils.isEmpty((Collection)fscSaleOrderListQueryAtomRspBO.getOrderOperList())) {
                orderOperList.addAll(fscSaleOrderListQueryAtomRspBO.getOrderOperList());
            }
        }
    }

    private void createReopenShouldPay(FscOrderPO fscOrderPO, List<FscShouldPayBO> fscShouldPayBOS, Set<String> orderCodeList, Set<String> orderOperList, String billDateMax) {
        List shouldPayPOList = this.fscShouldPayMapper.getReopenShouldPay(fscOrderPO.getRefundId());
        if (!CollectionUtils.isEmpty((Collection)shouldPayPOList)) {
            Map<Object, Object> oldShouldPayIdMap = new HashMap();
            List oldShouldPayIds = shouldPayPOList.stream().map(FscShouldPayPO::getShouldPayId).collect(Collectors.toList());
            FscShouldPayPO searchShouldPayPo = new FscShouldPayPO();
            searchShouldPayPo.setShouldPayIds(oldShouldPayIds);
            List shouldPayPOS = this.fscShouldPayMapper.getList(searchShouldPayPo);
            if (!CollectionUtils.isEmpty((Collection)shouldPayPOS)) {
                oldShouldPayIdMap = shouldPayPOS.stream().collect(Collectors.toMap(FscShouldPayPO::getShouldPayId, o -> o));
            }
            for (FscShouldPayPO shouldPayPO : shouldPayPOList) {
                FscShouldPayBO fscShouldPayBO = new FscShouldPayBO();
                BeanUtils.copyProperties((Object)shouldPayPO, (Object)fscShouldPayBO);
                fscShouldPayBO.setShouldPayAmount(shouldPayPO.getRefundAmount());
                fscShouldPayBO.setObjectId(fscOrderPO.getFscOrderId());
                fscShouldPayBO.setObjectNo(fscOrderPO.getOrderNo());
                fscShouldPayBO.setOperatorId(fscOrderPO.getOperatorId());
                fscShouldPayBO.setOperatorName(fscOrderPO.getOperatorName());
                fscShouldPayBO.setOperationNo(fscOrderPO.getOperationNo());
                fscShouldPayBO.setOrderCodeStr(String.join((CharSequence)",", orderCodeList));
                fscShouldPayBO.setOrderOperStr(String.join((CharSequence)",", orderOperList));
                fscShouldPayBO.setShouldPayMethod(shouldPayPO.getPayMethod());
                fscShouldPayBO.setBillDate(billDateMax);
                fscShouldPayBO.setRefundId(fscOrderPO.getRefundId());
                if (oldShouldPayIdMap.containsKey(shouldPayPO.getShouldPayId())) {
                    fscShouldPayBO.setNodePayRatio(((FscShouldPayPO)oldShouldPayIdMap.get(shouldPayPO.getShouldPayId())).getNodePayRatio());
                    fscShouldPayBO.setPayConfId(((FscShouldPayPO)oldShouldPayIdMap.get(shouldPayPO.getShouldPayId())).getPayConfId());
                }
                fscShouldPayBOS.add(fscShouldPayBO);
            }
        }
    }

    private void sendMq(Long orderId) {
        FscEsSyncComOrderListReqBO syncReqBO = new FscEsSyncComOrderListReqBO();
        syncReqBO.setFscOrderId(orderId);
        this.fscEsSyncComOrderListAbilityService.dealOrderToEs(syncReqBO);
        FscComInvoiceListSyncAbilityReqBO fscComInvoiceListSyncAbilityReqBO = new FscComInvoiceListSyncAbilityReqBO();
        fscComInvoiceListSyncAbilityReqBO.setFscOrderId(orderId);
        this.fscComInvoiceSyncAbilityService.dealComOrderSyncEs(fscComInvoiceListSyncAbilityReqBO);
        JSONObject object = new JSONObject();
        object.put("fscOrderId", (Object)orderId);
        ProxySendResult proxySendResult = this.fscSignBackFillInvoiceMqServiceProvider.send(new ProxyMessage(this.fscSignBackFillInvoiceTopic, this.fscSignBackFillInvoiceTag, JSONObject.toJSONString((Object)object)));
    }
}

