/*
 * Decompiled with CFR 0.152.
 */
package com.tydic.fsc.bill.ability.impl;

import cn.hutool.core.convert.Convert;
import com.alibaba.fastjson.JSON;
import com.tydic.fsc.bill.ability.api.FscBillOrderInvoiceSignWelfareApplyAbilityService;
import com.tydic.fsc.bill.ability.bo.FscBillOrderInvoiceSignApplyAbilityReqBO;
import com.tydic.fsc.bill.ability.bo.FscBillOrderInvoiceSignApplyAbilityRspBO;
import com.tydic.fsc.bill.busi.api.FscBillOrderInvoiceSignWelfareApplyBusiService;
import com.tydic.fsc.bill.busi.bo.FscBillOrderInvoiceSignApplyBusiReqBO;
import com.tydic.fsc.bill.busi.bo.FscBillOrderInvoiceSignApplyBusiRspBO;
import com.tydic.fsc.bo.FscOrderInfoBO;
import com.tydic.fsc.bo.FscShouldPayBO;
import com.tydic.fsc.busibase.atom.api.FscAcceptOrderListQueryAtomService;
import com.tydic.fsc.busibase.atom.bo.FscAcceptOrderListQueryAtomReqBO;
import com.tydic.fsc.busibase.atom.bo.FscAcceptOrderListQueryAtomRspBO;
import com.tydic.fsc.common.ability.api.FscComOrderSyncAbilityService;
import com.tydic.fsc.common.ability.bo.FscComOrderListSyncAbilityReqBO;
import com.tydic.fsc.constants.FscConstants;
import com.tydic.fsc.dao.FscInvoiceMapper;
import com.tydic.fsc.dao.FscOrderMapper;
import com.tydic.fsc.exception.FscBusinessException;
import com.tydic.fsc.po.FscOrderPO;
import com.tydic.fsc.util.FscDuplicateCommitLimit;
import java.text.ParseException;
import java.text.SimpleDateFormat;
import java.util.ArrayList;
import java.util.Calendar;
import java.util.Comparator;
import java.util.Date;
import java.util.HashMap;
import java.util.Map;
import java.util.Objects;
import java.util.Optional;
import java.util.Set;
import org.apache.commons.lang3.StringUtils;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;
import org.springframework.beans.factory.annotation.Autowired;
import org.springframework.util.CollectionUtils;
import org.springframework.web.bind.annotation.PostMapping;
import org.springframework.web.bind.annotation.RequestBody;
import org.springframework.web.bind.annotation.RequestMapping;
import org.springframework.web.bind.annotation.RestController;

@RestController
@RequestMapping(value={"FSC_GROUP_DEV/1.0.0/com.tydic.fsc.bill.ability.api.FscBillOrderInvoiceSignWelfareApplyAbilityService"})
public class FscBillOrderInvoiceSignWelfareApplyAbilityServiceImpl
implements FscBillOrderInvoiceSignWelfareApplyAbilityService {
    private static final Logger log = LoggerFactory.getLogger(FscBillOrderInvoiceSignWelfareApplyAbilityServiceImpl.class);
    @Autowired
    private FscOrderMapper fscOrderMapper;
    @Autowired
    private FscBillOrderInvoiceSignWelfareApplyBusiService fscBillOrderInvoiceSignWelfareApplyBusiService;
    @Autowired
    private FscComOrderSyncAbilityService fscComOrderSyncAbilityService;
    @Autowired
    private FscAcceptOrderListQueryAtomService fscAcceptOrderListQueryAtomService;
    @Autowired
    private FscInvoiceMapper fscInvoiceMapper;

    @FscDuplicateCommitLimit
    @PostMapping(value={"dealOrderInvoiceSignWelfareApply"})
    public FscBillOrderInvoiceSignApplyAbilityRspBO dealOrderInvoiceSignWelfareApply(@RequestBody FscBillOrderInvoiceSignApplyAbilityReqBO reqBO) {
        this.val(reqBO);
        FscOrderPO fscOrderPO = new FscOrderPO();
        fscOrderPO.setFscOrderId(reqBO.getOrderId());
        fscOrderPO = this.fscOrderMapper.getModelBy(fscOrderPO);
        if (null == fscOrderPO) {
            throw new FscBusinessException("191019", "\u7ed3\u7b97\u4e3b\u5355\u4e0d\u5b58\u5728");
        }
        if (!FscConstants.FscInvoiceOrderState.BILLED.equals(fscOrderPO.getOrderState()) && !FscConstants.FscInvoiceOrderState.BILL_REFUSE.equals(fscOrderPO.getOrderState())) {
            throw new FscBusinessException("191019", "\u5f53\u524d\u72b6\u6001[" + fscOrderPO.getOrderState() + "]\u4e0d\u5141\u8bb8\u7b7e\u6536\u7533\u8bf7");
        }
        FscBillOrderInvoiceSignApplyBusiReqBO fscBillOrderInvoiceSignBusiReqBO = (FscBillOrderInvoiceSignApplyBusiReqBO)((Object)JSON.parseObject((String)JSON.toJSONString((Object)reqBO), FscBillOrderInvoiceSignApplyBusiReqBO.class));
        fscBillOrderInvoiceSignBusiReqBO.setCurStatus(fscOrderPO.getOrderState());
        if (FscConstants.OrderFlow.INVOICE.equals(fscOrderPO.getOrderFlow())) {
            this.dealOrderCheck(fscBillOrderInvoiceSignBusiReqBO, fscOrderPO);
        }
        fscBillOrderInvoiceSignBusiReqBO.setSettlePlatform(Objects.isNull(fscOrderPO.getSettlePlatform()) ? 0 : fscOrderPO.getSettlePlatform());
        fscBillOrderInvoiceSignBusiReqBO.setTradeMode(fscOrderPO.getTradeMode());
        FscBillOrderInvoiceSignApplyBusiRspBO fscBillOrderInvoiceSignApplyBusiRspBO = this.fscBillOrderInvoiceSignWelfareApplyBusiService.dealOrderInvoiceSignWelfareApply(fscBillOrderInvoiceSignBusiReqBO);
        if (!"0000".equals(fscBillOrderInvoiceSignApplyBusiRspBO.getRespCode())) {
            throw new FscBusinessException("191019", fscBillOrderInvoiceSignApplyBusiRspBO.getRespDesc());
        }
        this.sendMq(reqBO);
        return new FscBillOrderInvoiceSignApplyAbilityRspBO();
    }

    private void dealOrderCheck(FscBillOrderInvoiceSignApplyBusiReqBO fscBillOrderInvoiceSignBusiReqBO, FscOrderPO fscOrderPO) {
        HashMap<Long, FscOrderInfoBO> fscOrderInfoBoMap = new HashMap();
        if (fscOrderPO.getSettleType() == null || fscOrderPO.getSettleType().equals(FscConstants.SettleType.INSPECTION)) {
            FscAcceptOrderListQueryAtomReqBO fscAcceptOrderListQueryAtomReqBO = new FscAcceptOrderListQueryAtomReqBO();
            fscAcceptOrderListQueryAtomReqBO.setRelId(fscOrderPO.getFscOrderId());
            FscAcceptOrderListQueryAtomRspBO fscAcceptOrderListQueryAtomRspBO = this.fscAcceptOrderListQueryAtomService.queryWelfare(fscAcceptOrderListQueryAtomReqBO);
            if (!"0000".equals(fscAcceptOrderListQueryAtomRspBO.getRespCode())) {
                throw new FscBusinessException("191019", fscAcceptOrderListQueryAtomRspBO.getRespDesc());
            }
            if (CollectionUtils.isEmpty((Map)fscAcceptOrderListQueryAtomRspBO.getFscOrderInfoBoMap())) {
                throw new FscBusinessException("191019", "\u67e5\u8be2\u8ba2\u5355MAP\u4e3a\u7a7a");
            }
            fscOrderInfoBoMap = fscAcceptOrderListQueryAtomRspBO.getFscOrderInfoBoMap();
            this.dealAccountRule(fscBillOrderInvoiceSignBusiReqBO, fscOrderPO, fscOrderInfoBoMap, fscAcceptOrderListQueryAtomRspBO.getOrderCodeList(), fscAcceptOrderListQueryAtomRspBO.getOrderOperList());
        }
    }

    private void dealAccountRule(FscBillOrderInvoiceSignApplyBusiReqBO fscBillOrderInvoiceSignBusiReqBO, FscOrderPO fscOrderPO, Map<Long, FscOrderInfoBO> fscOrderInfoBoMap, Set<String> orderCodeList, Set<String> orderOperList) {
        if (fscOrderPO.getSettleType() != null && fscOrderPO.getSettleType().equals(FscConstants.SettleType.ORDER)) {
            return;
        }
        if (this.qryHistoryRefund(fscOrderPO)) {
            return;
        }
        String billDateMax = this.fscInvoiceMapper.setInvoiceBillDate(fscOrderPO.getFscOrderId());
        if (FscConstants.MerchantPayType.MERCHANT_PAY_TYPE_PERIOD.equals(fscOrderPO.getPayType())) {
            Optional<FscOrderInfoBO> max = fscOrderInfoBoMap.values().stream().max(Comparator.comparing(FscOrderInfoBO::getOrderCreateTime));
            if (!max.isPresent()) {
                throw new FscBusinessException("191019", "\u83b7\u53d6\u8ba2\u5355\u4e3a\u7a7a");
            }
            FscOrderInfoBO fscOrderInfoBO = max.get();
            if (null == fscOrderInfoBO) {
                throw new FscBusinessException("191019", "\u83b7\u53d6\u8ba2\u5355\u4e3a\u7a7a");
            }
            log.debug("++++++++++fscOrderInfoBO:{}", (Object)JSON.toJSONString((Object)fscOrderInfoBO));
            if ((fscOrderPO.getMakeType().equals(FscConstants.FscOrderMakeType.SUPPLIER) || fscOrderPO.getMakeType().equals(FscConstants.FscOrderMakeType.ELECTRONIC_COMMERCE)) && fscOrderPO.getReceiveType().equals(FscConstants.FscOrderReceiveType.OPERATION)) {
                fscOrderInfoBO.setPayAccountDayRule(fscOrderInfoBO.getProPayAccountDayRule());
                fscOrderInfoBO.setPayNodeRule(fscOrderInfoBO.getProPayNodeRule());
                fscOrderInfoBO.setPayBreakScale(fscOrderInfoBO.getProPayBreakScale());
                fscOrderInfoBO.setModelContractId(fscOrderInfoBO.getProModelContractId());
                fscOrderInfoBO.setModelContractNo(fscOrderInfoBO.getProModelContractNo());
                fscOrderInfoBO.setPayAccountDay(fscOrderInfoBO.getProPayAccountDay());
                fscOrderInfoBO.setPayNodeAccountDays(fscOrderInfoBO.getProPaymentDays());
                fscOrderInfoBO.setPayRule(fscOrderInfoBO.getProPayRule());
            }
            if ((FscConstants.MerchantPayAccountDayRule.SIGN.equals(fscOrderInfoBO.getPayAccountDayRule()) || FscConstants.MerchantPayNodeRule.SIGN.equals(fscOrderInfoBO.getPayNodeRule())) && (fscOrderPO.getSettlePlatform() == null || fscOrderPO.getSettlePlatform() != 1)) {
                ArrayList<FscShouldPayBO> fscShouldPayBOS = new ArrayList<FscShouldPayBO>();
                FscShouldPayBO fscShouldPayBO = new FscShouldPayBO();
                fscShouldPayBO.setShouldPayType(FscConstants.ShouldPayType.PAYMENT_DAY_PAY);
                fscShouldPayBO.setObjectType(FscConstants.ShouldObjectType.SIGN_INVOICE_ORDER);
                fscShouldPayBO.setObjectId(fscOrderPO.getFscOrderId());
                fscShouldPayBO.setObjectNo(fscOrderPO.getOrderNo());
                fscShouldPayBO.setPayType(FscConstants.MerchantPayType.MERCHANT_PAY_TYPE_PERIOD);
                fscShouldPayBO.setShouldPayAmount(fscOrderPO.getTotalCharge());
                fscShouldPayBO.setPayeeId(fscOrderPO.getPayeeId());
                fscShouldPayBO.setPayeeName(fscOrderPO.getPayeeName());
                fscShouldPayBO.setPayerId(fscOrderPO.getPayerId());
                fscShouldPayBO.setPayerName(fscOrderPO.getPayerName());
                fscShouldPayBO.setPenaltyRatio(fscOrderInfoBO.getPayBreakScale());
                fscShouldPayBO.setContractId(fscOrderInfoBO.getModelContractId());
                fscShouldPayBO.setContractNo(fscOrderInfoBO.getModelContractNo());
                fscShouldPayBO.setAgreementId(fscOrderInfoBO.getProtocolId());
                fscShouldPayBO.setAgreementNo(fscOrderInfoBO.getPlaAgreementCode());
                fscShouldPayBO.setShouldPayDate(this.calShouldPayDate(fscOrderInfoBO, fscOrderPO.getOrderSource(), billDateMax));
                fscShouldPayBO.setOrderId(fscOrderInfoBO.getOrderId());
                fscShouldPayBO.setInvoiceNo(fscBillOrderInvoiceSignBusiReqBO.getInvoiceNo());
                fscShouldPayBO.setBillDate(billDateMax);
                fscShouldPayBO.setBuyerNo(fscOrderPO.getBuynerNo());
                fscShouldPayBO.setBuyerName(fscOrderPO.getBuynerName());
                fscShouldPayBO.setOrderType(fscOrderPO.getOrderType());
                fscShouldPayBO.setOrderSource(fscOrderPO.getOrderSource());
                fscShouldPayBO.setTradeMode(fscOrderPO.getTradeMode());
                fscShouldPayBO.setOrderOperStr(String.join((CharSequence)",", orderOperList));
                fscShouldPayBO.setOrderCodeStr(String.join((CharSequence)",", orderCodeList));
                fscShouldPayBO.setOperatorId(fscOrderPO.getOperatorId());
                fscShouldPayBO.setOperatorName(fscOrderPO.getOperatorName());
                fscShouldPayBO.setOperatorDeptId(Convert.toStr((Object)fscOrderPO.getOperatorDeptId()));
                fscShouldPayBO.setOperatorDeptName(fscOrderPO.getOperatorDeptName());
                fscShouldPayBO.setOperationNo(fscOrderPO.getOperationNo());
                fscShouldPayBO.setShouldPayMethod(Integer.valueOf(2));
                fscShouldPayBOS.add(fscShouldPayBO);
                fscBillOrderInvoiceSignBusiReqBO.setFscShouldPayBOS(fscShouldPayBOS);
                fscBillOrderInvoiceSignBusiReqBO.setCreateShouldPayFlag(true);
            }
        }
    }

    private Date calShouldPayDate(FscOrderInfoBO fscOrderInfoBO, Integer orderSource, String billDateMax) {
        Calendar now = Calendar.getInstance();
        if (StringUtils.isNotBlank((CharSequence)billDateMax)) {
            SimpleDateFormat sdf = new SimpleDateFormat("yyyy-MM-dd");
            try {
                now.setTime(sdf.parse(billDateMax));
            }
            catch (ParseException e) {
                log.error("\u65e5\u671f\u8f6c\u6362\u5f02\u5e38");
            }
        }
        if (FscConstants.MerchantPayRule.MERCHANT_PAY_RULE_SPECIFY.equals(fscOrderInfoBO.getPayRule())) {
            if (null == fscOrderInfoBO.getPayAccountDay()) {
                throw new FscBusinessException("191019", "\u8ba2\u5355\u6307\u5b9a\u8d26\u671f\u65e5\u4e3a\u7a7a");
            }
            Integer day = now.get(5);
            if (day >= fscOrderInfoBO.getPayAccountDay()) {
                now.add(2, 1);
            }
            now.add(5, fscOrderInfoBO.getPayAccountDay() - day);
        }
        if (FscConstants.MerchantPayRule.Merchant_PAY_RULE_BUSIESS_NODE.equals(fscOrderInfoBO.getPayRule())) {
            if (null == fscOrderInfoBO.getPayNodeAccountDays()) {
                throw new FscBusinessException("191019", "\u8ba2\u5355\u8d26\u671f\u5929\u6570\u4e3a\u7a7a");
            }
            now.add(5, fscOrderInfoBO.getPayNodeAccountDays());
        }
        return now.getTime();
    }

    private boolean qryHistoryRefund(FscOrderPO fscOrderPO) {
        if (fscOrderPO.getRefundId() == null) {
            return false;
        }
        FscOrderPO orderPO = this.fscOrderMapper.qryHistoryRefund(fscOrderPO.getRefundId());
        if (orderPO == null) {
            return false;
        }
        if (orderPO.getOrderState().equals(FscConstants.FscInvoiceOrderState.SIGNED)) {
            return true;
        }
        if (orderPO.getRefundId() != null) {
            return this.qryHistoryRefund(orderPO);
        }
        return false;
    }

    private void val(FscBillOrderInvoiceSignApplyAbilityReqBO reqBO) {
        if (null == reqBO) {
            throw new FscBusinessException("191000", "\u5165\u53c2\u5bf9\u8c61\u4e3a\u7a7a");
        }
        if (null == reqBO.getOrderId()) {
            throw new FscBusinessException("191000", "\u5165\u53c2orderId\u4e3a\u7a7a");
        }
    }

    private void sendMq(FscBillOrderInvoiceSignApplyAbilityReqBO reqBO) {
        FscComOrderListSyncAbilityReqBO fscComOrderListSyncAbilityReqBO = new FscComOrderListSyncAbilityReqBO();
        fscComOrderListSyncAbilityReqBO.setFscOrderId(reqBO.getOrderId());
        this.fscComOrderSyncAbilityService.dealComOrderSyncEs(fscComOrderListSyncAbilityReqBO);
    }
}

