/*
 * Decompiled with CFR 0.152.
 */
package com.tydic.fsc.bill.ability.impl;

import com.alibaba.fastjson.JSONObject;
import com.ohaotian.plugin.db.Sequence;
import com.tydic.fsc.bill.ability.api.FscBillOrderRefundCreateNewAbilityService;
import com.tydic.fsc.bill.ability.api.FscSyncPushYcSpecialRefundAbilityService;
import com.tydic.fsc.bill.ability.bo.FscBillOrderRefundCreateAbilityReqBO;
import com.tydic.fsc.bill.ability.bo.FscBillOrderRefundCreateAbilityRspBO;
import com.tydic.fsc.bill.ability.bo.FscBillOrderRefundCreateInvoiceBO;
import com.tydic.fsc.bill.ability.bo.FscSyncPushYcSpecialRefundAbilityReqBO;
import com.tydic.fsc.bill.busi.api.FscBillOrderRefundCreateNewBusiService;
import com.tydic.fsc.bill.busi.bo.FscBillOrderRefundCreateBusiReqBO;
import com.tydic.fsc.bill.busi.bo.FscBillOrderRefundCreateBusiRspBO;
import com.tydic.fsc.busibase.atom.api.FscRefundCheckPayInfoAtomService;
import com.tydic.fsc.common.ability.api.FscComInvoiceSyncAbilityService;
import com.tydic.fsc.common.ability.api.FscComOrderSyncAbilityService;
import com.tydic.fsc.common.ability.api.FscComRefundSyncAbilityService;
import com.tydic.fsc.common.ability.bo.FscComInvoiceListSyncAbilityReqBO;
import com.tydic.fsc.common.ability.bo.FscComOrderListSyncAbilityReqBO;
import com.tydic.fsc.common.ability.bo.FscComRefundSyncAbilityReqBO;
import com.tydic.fsc.constants.FscConstants;
import com.tydic.fsc.dao.FscClaimDetailChangeMapper;
import com.tydic.fsc.dao.FscClaimDetailMapper;
import com.tydic.fsc.dao.FscInvoiceItemMapper;
import com.tydic.fsc.dao.FscInvoiceMapper;
import com.tydic.fsc.dao.FscInvoiceRefundRelationMapper;
import com.tydic.fsc.dao.FscOrderItemMapper;
import com.tydic.fsc.dao.FscOrderMapper;
import com.tydic.fsc.dao.FscOrderRefundMapper;
import com.tydic.fsc.dao.FscOrderRelationMapper;
import com.tydic.fsc.dao.FscOrderWriteRelationMapper;
import com.tydic.fsc.enums.FscPostingStatusEnum;
import com.tydic.fsc.exception.FscBusinessException;
import com.tydic.fsc.pay.task.service.TaskTodoWaitService;
import com.tydic.fsc.po.FscInvoiceItemPO;
import com.tydic.fsc.po.FscInvoicePO;
import com.tydic.fsc.po.FscInvoiceRefundRelationPO;
import com.tydic.fsc.po.FscOrderItemPO;
import com.tydic.fsc.po.FscOrderPO;
import com.tydic.fsc.po.FscOrderRefundPO;
import com.tydic.fsc.po.FscOrderRelationPO;
import com.tydic.fsc.po.FscOrderWriteRelationPO;
import com.tydic.fsc.util.FscIdempotentCommitLimit;
import java.math.BigDecimal;
import java.util.ArrayList;
import java.util.Collection;
import java.util.Collections;
import java.util.HashMap;
import java.util.HashSet;
import java.util.List;
import java.util.Map;
import java.util.Objects;
import java.util.Set;
import java.util.stream.Collectors;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;
import org.springframework.beans.BeanUtils;
import org.springframework.beans.factory.annotation.Autowired;
import org.springframework.beans.factory.annotation.Value;
import org.springframework.util.CollectionUtils;
import org.springframework.util.StringUtils;
import org.springframework.web.bind.annotation.PostMapping;
import org.springframework.web.bind.annotation.RequestBody;
import org.springframework.web.bind.annotation.RequestMapping;
import org.springframework.web.bind.annotation.RestController;

@RestController
@RequestMapping(value={"FSC_GROUP_DEV/1.0.0/com.tydic.fsc.bill.ability.api.FscBillOrderRefundCreateNewAbilityService"})
public class FscBillOrderRefundCreateNewAbilityServiceImpl
implements FscBillOrderRefundCreateNewAbilityService {
    private static final Logger log = LoggerFactory.getLogger(FscBillOrderRefundCreateNewAbilityServiceImpl.class);
    @Autowired
    private FscBillOrderRefundCreateNewBusiService fscBillOrderRefundCreateNewBusiService;
    @Autowired
    private FscComInvoiceSyncAbilityService fscComInvoiceSyncAbilityService;
    @Autowired
    private FscComRefundSyncAbilityService fscComRefundSyncAbilityService;
    @Autowired
    private FscOrderMapper fscOrderMapper;
    @Autowired
    private FscOrderRelationMapper fscOrderRelationMapper;
    @Autowired
    private FscInvoiceMapper fscInvoiceMapper;
    @Autowired
    private FscComOrderSyncAbilityService fscComOrderSyncAbilityService;
    @Autowired
    private FscInvoiceRefundRelationMapper fscInvoiceRefundRelationMapper;
    @Autowired
    private FscInvoiceItemMapper fscInvoiceItemMapper;
    @Autowired
    private FscOrderItemMapper fscOrderItemMapper;
    @Autowired
    private FscOrderRefundMapper fscOrderRefundMapper;
    @Autowired
    private FscRefundCheckPayInfoAtomService fscRefundCheckPayInfoAtomService;
    @Autowired
    private FscClaimDetailMapper fscClaimDetailMapper;
    @Autowired
    private FscClaimDetailChangeMapper fscClaimDetailChangeMapper;
    @Autowired
    private FscOrderWriteRelationMapper fscOrderWriteRelationMapper;
    @Autowired
    private FscSyncPushYcSpecialRefundAbilityService fscSyncPushYcSpecialRefundAbilityService;
    @Value(value="${fsc.member.refund.userId:76138}")
    private Long userId;
    @Value(value="${fsc.member.refund.personId:234456}")
    private Long personId;
    @Value(value="${fsc.member.refund.personName:\u7a46\u82f1\u6c38}")
    private String personName;
    @Value(value="${fsc.member.refund.deptId:166161}")
    private Long deptId;
    @Value(value="${fsc.member.refund.deptName:\u4e2d\u56fd\u7164\u70ad\u5f00\u53d1\u6709\u9650\u8d23\u4efb\u516c\u53f8\u672c\u90e8\u4e1a\u52a1\u8fd0\u8425\u90e8\u5ba4\u7535\u5b50\u5546\u52a1\u4e2d\u5fc3\u7535\u5546\u8fd0\u8425\u90e8}")
    private String deptName;
    @Autowired
    private TaskTodoWaitService taskTodoWaitService;

    @FscIdempotentCommitLimit(lockKey="fscOrderId")
    @PostMapping(value={"dealRefundCreateNew"})
    public FscBillOrderRefundCreateAbilityRspBO dealRefundCreateNew(@RequestBody FscBillOrderRefundCreateAbilityReqBO reqBO) {
        this.valid(reqBO);
        FscOrderPO orderPO = new FscOrderPO();
        orderPO.setFscOrderId(reqBO.getFscOrderId());
        orderPO = this.fscOrderMapper.getModelBy(orderPO);
        if (orderPO == null) {
            throw new FscBusinessException("198888", "\u672a\u67e5\u8be2\u5230\u7ed3\u7b97\u5355\u4fe1\u606f\uff01");
        }
        if (!(orderPO.getOrderState().equals(FscConstants.FscInvoiceOrderState.BILLED) || orderPO.getOrderState().equals(FscConstants.FscInvoiceOrderState.SIGNED) || orderPO.getOrderState().equals(FscConstants.FscInvoiceOrderState.TY_BUSI_AUDIT_REJECT) || orderPO.getOrderState().equals(FscConstants.FscInvoiceOrderState.TY_PUSH_FAIL))) {
            throw new FscBusinessException("198888", "\u5f53\u524d\u7ed3\u7b97\u5355\u72b6\u6001\u4e0d\u5141\u8bb8\u9000\u7968\uff01");
        }
        if (orderPO.getOrderFlow() != 7 && !FscPostingStatusEnum.EFFECTIVE.getCode().equals(orderPO.getPostingStatus())) {
            throw new FscBusinessException("198888", "\u5f53\u524d\u7ed3\u7b97\u5355\u72b6\u6001\u6ca1\u6709\u8fc7\u8d26\u4e0d\u5141\u8bb8\u9000\u7968\uff01");
        }
        if (orderPO.getOrderFlow() == 7) {
            reqBO.setYcUserId(this.userId);
            reqBO.setYcPersonId(this.personId);
            reqBO.setYcPersonName(this.personName);
            reqBO.setYcDeptId(this.deptId);
            reqBO.setYcDeptName(this.deptName);
        }
        this.checkClaim(orderPO, reqBO.getInvoiceBOS());
        FscBillOrderRefundCreateBusiReqBO busiReqBO = new FscBillOrderRefundCreateBusiReqBO();
        BeanUtils.copyProperties((Object)reqBO, (Object)((Object)busiReqBO));
        FscInvoicePO invoicePO = new FscInvoicePO();
        invoicePO.setFscOrderId(reqBO.getFscOrderId());
        Long refundId = Objects.nonNull(reqBO.getIsEdit()) && reqBO.getIsEdit() == 1 ? reqBO.getRefundId().longValue() : Sequence.getInstance().nextId();
        busiReqBO.setRefundId(refundId);
        List<Object> invoiceIds = new ArrayList();
        if (!CollectionUtils.isEmpty((Collection)reqBO.getInvoiceBOS())) {
            invoiceIds = reqBO.getInvoiceBOS().stream().map(FscBillOrderRefundCreateInvoiceBO::getInvoiceId).collect(Collectors.toList());
            invoicePO.setInvoiceIds(invoiceIds);
        }
        if (CollectionUtils.isEmpty(invoiceIds)) {
            throw new FscBusinessException("198888", "\u53d1\u7968ids\u4e0d\u80fd\u4e3a\u7a7a\uff01");
        }
        List invoiceList = this.fscInvoiceMapper.getList(invoicePO);
        if (CollectionUtils.isEmpty((Collection)invoiceList)) {
            throw new FscBusinessException("198888", "\u672a\u67e5\u8be2\u5230\u53d1\u7968\u4fe1\u606f\uff01");
        }
        if (invoiceIds.size() != invoiceList.size()) {
            throw new FscBusinessException("198888", "\u6709\u53d1\u7968\u4fe1\u606f\u4e0d\u5b58\u5728\uff01");
        }
        List invoiceItemPOS = new ArrayList();
        FscInvoiceItemPO searchInvoiceItemPO = new FscInvoiceItemPO();
        searchInvoiceItemPO.setInvoiceIds(invoiceIds);
        searchInvoiceItemPO.setOrderBy("ID");
        invoiceItemPOS = this.fscInvoiceItemMapper.getList(searchInvoiceItemPO);
        if (CollectionUtils.isEmpty(invoiceItemPOS)) {
            throw new FscBusinessException("198888", "\u53d1\u7968\u660e\u7ec6\u4fe1\u606f\u4e0d\u5b58\u5728\uff01");
        }
        Map<Long, List<FscInvoiceItemPO>> invoiceIdItemMap = invoiceItemPOS.stream().collect(Collectors.groupingBy(FscInvoiceItemPO::getInvoiceId));
        Map<Long, FscInvoiceItemPO> invoiceItemIdMap = invoiceItemPOS.stream().collect(Collectors.toMap(FscInvoiceItemPO::getId, o -> o));
        List fscOrderItemPOS = new ArrayList();
        FscOrderItemPO searchFscOrderItemPO = new FscOrderItemPO();
        searchFscOrderItemPO.setFscOrderId(reqBO.getFscOrderId());
        searchFscOrderItemPO.setOrderBy("id");
        fscOrderItemPOS = this.fscOrderItemMapper.getListNoPage(searchFscOrderItemPO);
        if (CollectionUtils.isEmpty(fscOrderItemPOS)) {
            throw new FscBusinessException("198888", "\u672a\u67e5\u8be2\u5230\u7ed3\u7b97\u5355\u660e\u7ec6\u4fe1\u606f\uff01");
        }
        Map<Long, List<FscOrderItemPO>> fscOrderItemIdMap = fscOrderItemPOS.stream().collect(Collectors.groupingBy(FscOrderItemPO::getOrderItemId));
        HashMap<Long, String> orderIdCodeMap = new HashMap<Long, String>();
        for (FscOrderItemPO fscOrderItemPO : fscOrderItemPOS) {
            if (fscOrderItemPO.getOrderId() == null || StringUtils.isEmpty((Object)fscOrderItemPO.getOrderCode())) continue;
            orderIdCodeMap.put(fscOrderItemPO.getOrderId(), fscOrderItemPO.getOrderCode());
        }
        BigDecimal sumRefundAmt = this.checkRefundAmt(reqBO, invoiceIds, invoiceList, orderPO);
        if (sumRefundAmt.compareTo(BigDecimal.ZERO) <= 0) {
            throw new FscBusinessException("198888", "\u9000\u7968\u91d1\u989d\u5f02\u5e38\uff01");
        }
        ArrayList<FscOrderItemPO> insertFscOrderItemPOS = new ArrayList<FscOrderItemPO>();
        ArrayList<FscInvoiceItemPO> updateInvoiceItemPOS = new ArrayList<FscInvoiceItemPO>();
        ArrayList<FscOrderRelationPO> orderList = new ArrayList<FscOrderRelationPO>();
        for (Object invoiceBO : reqBO.getInvoiceBOS()) {
            List<FscInvoiceItemPO> fscInvoiceItemPOS = invoiceIdItemMap.get(invoiceBO.getInvoiceId());
            for (FscInvoiceItemPO fscInvoiceItemPO : fscInvoiceItemPOS) {
                if (fscInvoiceItemPO.getAmt() == null) {
                    fscInvoiceItemPO.setAmt(BigDecimal.ZERO);
                }
                if (fscInvoiceItemPO.getRefundAmt() == null) {
                    fscInvoiceItemPO.setRefundAmt(BigDecimal.ZERO);
                }
                BigDecimal residualAmt = fscInvoiceItemPO.getAmt().subtract(fscInvoiceItemPO.getRefundAmt());
                FscOrderItemPO insertOrderItemPO = (FscOrderItemPO)JSONObject.parseObject((String)JSONObject.toJSONString((Object)fscInvoiceItemPO), FscOrderItemPO.class);
                insertOrderItemPO.setId(Long.valueOf(Sequence.getInstance().nextId()));
                insertOrderItemPO.setRefundId(refundId);
                insertOrderItemPO.setFscOrderId(null);
                insertOrderItemPO.setInvoiceItemId(fscInvoiceItemPO.getId());
                FscInvoiceItemPO updateInvoiceItemPO = new FscInvoiceItemPO();
                updateInvoiceItemPO.setId(fscInvoiceItemPO.getId());
                updateInvoiceItemPO.setRefundAmt(residualAmt);
                insertOrderItemPO.setRefundAmt(residualAmt);
                updateInvoiceItemPOS.add(updateInvoiceItemPO);
                insertFscOrderItemPOS.add(insertOrderItemPO);
            }
        }
        if (CollectionUtils.isEmpty(insertFscOrderItemPOS)) {
            throw new FscBusinessException("198888", "\u6700\u7ec8\u7ec4\u88c5\u7684\u9000\u7968\u5355\u660e\u7ec6\u4fe1\u606f\u4e3a\u7a7a\uff01");
        }
        Map<Long, List<FscOrderItemPO>> acceptOrderIdMap = insertFscOrderItemPOS.stream().collect(Collectors.groupingBy(FscOrderItemPO::getAcceptOrderId));
        for (Long acceptOrderId : acceptOrderIdMap.keySet()) {
            FscOrderRelationPO fscOrderRelationPO = new FscOrderRelationPO();
            fscOrderRelationPO.setId(Long.valueOf(Sequence.getInstance().nextId()));
            fscOrderRelationPO.setAcceptOrderId(acceptOrderId);
            List<FscOrderItemPO> orderItemPOList = acceptOrderIdMap.get(acceptOrderId);
            fscOrderRelationPO.setOrderId(orderItemPOList.get(0).getOrderId());
            BigDecimal settleAmt = BigDecimal.ZERO;
            for (FscOrderItemPO fscOrderItemPO : orderItemPOList) {
                settleAmt = settleAmt.add(fscOrderItemPO.getRefundAmt());
            }
            fscOrderRelationPO.setSettleAmt(settleAmt);
            fscOrderRelationPO.setPurchaseClaimAmt(BigDecimal.ZERO);
            fscOrderRelationPO.setOperationClaimAmt(BigDecimal.ZERO);
            fscOrderRelationPO.setAmount(BigDecimal.ZERO);
            fscOrderRelationPO.setRefundId(refundId);
            if (fscOrderRelationPO.getOrderId() != null) {
                fscOrderRelationPO.setOrderNo((String)orderIdCodeMap.get(fscOrderRelationPO.getOrderId()));
            }
            orderList.add(fscOrderRelationPO);
        }
        if (!CollectionUtils.isEmpty(updateInvoiceItemPOS)) {
            Map<Long, List<FscInvoiceItemPO>> idMap = updateInvoiceItemPOS.stream().collect(Collectors.groupingBy(FscInvoiceItemPO::getId));
            ArrayList<FscInvoiceItemPO> distUpdateInvoiceItemPOS = new ArrayList<FscInvoiceItemPO>();
            for (Long itemId : idMap.keySet()) {
                List<FscInvoiceItemPO> fscInvoiceItemPOS = idMap.get(itemId);
                FscInvoiceItemPO itemPO = fscInvoiceItemPOS.get(0);
                BigDecimal refundAmt = BigDecimal.ZERO;
                for (FscInvoiceItemPO fscInvoiceItemPO : fscInvoiceItemPOS) {
                    refundAmt = refundAmt.add(fscInvoiceItemPO.getRefundAmt());
                }
                itemPO.setRefundAmt(refundAmt);
                distUpdateInvoiceItemPOS.add(itemPO);
            }
            updateInvoiceItemPOS = distUpdateInvoiceItemPOS;
        }
        if (CollectionUtils.isEmpty(updateInvoiceItemPOS)) {
            throw new FscBusinessException("198888", "\u6700\u7ec8\u7ec4\u88c5\u9000\u7968\u91d1\u989d\u5360\u7528\u660e\u7ec6\u4fe1\u606f\u4e3a\u7a7a\uff01");
        }
        busiReqBO.setRefundAmt(sumRefundAmt);
        busiReqBO.setOrderList(orderList);
        busiReqBO.setInvoiceList(invoiceList);
        busiReqBO.setInvoiceIds(invoiceIds);
        busiReqBO.setInsertFscOrderItemPOS(insertFscOrderItemPOS);
        busiReqBO.setUpdateInvoiceItemPOS(updateInvoiceItemPOS);
        FscBillOrderRefundCreateBusiRspBO busiRspBO = this.fscBillOrderRefundCreateNewBusiService.dealRefundCreateNew(busiReqBO);
        if (!busiRspBO.getRespCode().equals("0000")) {
            throw new FscBusinessException("198888", "\u521b\u5efa\u9000\u7968\u4e3b\u5355\u5931\u8d25:" + busiRspBO.getRespDesc());
        }
        if (reqBO.getOperationDown() != null && reqBO.getOperationDown().equals(FscConstants.OperationDown.YES) && reqBO.getOperationType().equals(FscConstants.RefundOperationType.SUBMIT) && orderPO.getOrderFlow() != 7) {
            try {
                this.taskTodoWaitService.syncNotifySaleRefundWaitDone(busiRspBO.getRefundId());
            }
            catch (Exception e) {
                log.error("dealPayBillCreateBySale -\u901a\u77e5\u5f85\u529e\u5931\u8d25- error:{}", (Throwable)e);
            }
        }
        if (orderPO.getOrderFlow() == 7) {
            FscSyncPushYcSpecialRefundAbilityReqBO abilityReqBO = new FscSyncPushYcSpecialRefundAbilityReqBO();
            abilityReqBO.setRefundId(busiRspBO.getRefundId());
            this.fscSyncPushYcSpecialRefundAbilityService.PushYcSpecialRefund(abilityReqBO);
        }
        this.syncEs(busiRspBO);
        FscBillOrderRefundCreateAbilityRspBO rspBO = new FscBillOrderRefundCreateAbilityRspBO();
        rspBO.setRespCode("0000");
        rspBO.setRespDesc("\u6210\u529f");
        return rspBO;
    }

    private void checkClaim(FscOrderPO orderPO, List<FscBillOrderRefundCreateInvoiceBO> pos) {
        int claimCount = this.fscClaimDetailMapper.queryCheckClaim(orderPO.getFscOrderId());
        if (claimCount != 0) {
            throw new FscBusinessException("198888", "\u8be5\u7ed3\u7b97\u5355\u5b58\u5728\u5728\u9014\u8ba4\u9886\u5355,\u4e0d\u5141\u8bb8\u53d1\u8d77\u9000\u7968!");
        }
        int changeCount = this.fscClaimDetailChangeMapper.queryCheckChangeClaim(orderPO.getOrderNo());
        if (changeCount != 0) {
            throw new FscBusinessException("198888", "\u8be5\u7ed3\u7b97\u5355\u5b58\u5728\u5728\u9014\u8ba4\u9886\u53d8\u66f4\u5355,\u4e0d\u5141\u8bb8\u53d1\u8d77\u9000\u7968!");
        }
        int writeCount = this.fscOrderWriteRelationMapper.queryChangeOccupyState(orderPO.getFscOrderId());
        if (writeCount != 0) {
            throw new FscBusinessException("198888", "\u8be5\u7ed3\u7b97\u5355\u5b58\u5728\u5728\u9014\u6838\u9500\u8ba4\u9886\u53d8\u66f4\u5355,\u4e0d\u5141\u8bb8\u53d1\u8d77\u9000\u7968!");
        }
        FscInvoicePO fscInvoicePO = new FscInvoicePO();
        fscInvoicePO.setFscOrderId(orderPO.getFscOrderId());
        List invoiceList = this.fscInvoiceMapper.getList(fscInvoicePO);
        if (pos.size() != invoiceList.size()) {
            FscOrderWriteRelationPO writeRelationPO = new FscOrderWriteRelationPO();
            writeRelationPO.setFscOrderId(orderPO.getFscOrderId());
            List resultList = this.fscOrderWriteRelationMapper.getWritteSum(writeRelationPO);
            if (!CollectionUtils.isEmpty((Collection)resultList)) {
                throw new FscBusinessException("198888", "\u90e8\u5206\u9000\u7968\u8bf7\u5148\u5c06\u6838\u9500\u6570\u636e\u8ba4\u9886\u53d8\u66f4\uff01");
            }
        }
    }

    private void syncEs(FscBillOrderRefundCreateBusiRspBO busiRspBO) {
        FscComRefundSyncAbilityReqBO refundSyncAbilityReqBO = new FscComRefundSyncAbilityReqBO();
        refundSyncAbilityReqBO.setRefundIds(Collections.singletonList(busiRspBO.getRefundId()));
        this.fscComRefundSyncAbilityService.syncRefund(refundSyncAbilityReqBO);
        FscComInvoiceListSyncAbilityReqBO fscComInvoiceListSyncAbilityReqBO = new FscComInvoiceListSyncAbilityReqBO();
        fscComInvoiceListSyncAbilityReqBO.setFscOrderId(busiRspBO.getFscOrderId());
        this.fscComInvoiceSyncAbilityService.dealComOrderSyncEs(fscComInvoiceListSyncAbilityReqBO);
        FscComOrderListSyncAbilityReqBO fscComOrderListSyncAbilityReqBO = new FscComOrderListSyncAbilityReqBO();
        fscComOrderListSyncAbilityReqBO.setFscOrderId(busiRspBO.getFscOrderId());
        this.fscComOrderSyncAbilityService.dealComOrderSyncEs(fscComOrderListSyncAbilityReqBO);
    }

    private void valid(FscBillOrderRefundCreateAbilityReqBO reqBO) {
        if (Objects.nonNull(reqBO.getIsEdit()) && reqBO.getIsEdit() == 1) {
            if (reqBO.getRefundId() == null) {
                throw new FscBusinessException("198888", "\u5165\u53c2[refundId]\u4e0d\u80fd\u4e3a\u7a7a\uff01");
            }
            if (reqBO.getRefundNo() == null) {
                throw new FscBusinessException("198888", "\u5165\u53c2[refundNo]\u4e0d\u80fd\u4e3a\u7a7a\uff01");
            }
        }
        if (reqBO.getOperationType() == null) {
            throw new FscBusinessException("198888", "\u5165\u53c2[operationType]\u4e0d\u80fd\u4e3a\u7a7a\uff01");
        }
        if (reqBO.getFscOrderId() == null) {
            throw new FscBusinessException("198888", "\u5165\u53c2[fscOrderId]\u4e0d\u80fd\u4e3a\u7a7a\uff01");
        }
        if (reqBO.getCertification() == null) {
            throw new FscBusinessException("198888", "\u5165\u53c2[certification]\u4e0d\u80fd\u4e3a\u7a7a\uff01");
        }
        if (reqBO.getRefundReasonType() == null) {
            throw new FscBusinessException("198888", "\u5165\u53c2[refundReasonType]\u4e0d\u80fd\u4e3a\u7a7a\uff01");
        }
        if (reqBO.getRefundNote() == null) {
            throw new FscBusinessException("198888", "\u5165\u53c2[refundNote]\u4e0d\u80fd\u4e3a\u7a7a\uff01");
        }
        if (CollectionUtils.isEmpty((Collection)reqBO.getInvoiceBOS())) {
            throw new FscBusinessException("198888", "\u5165\u53c2[invoiceBOS]\u4e0d\u80fd\u4e3a\u7a7a\uff01");
        }
        HashSet<Long> invoiceIdSet = new HashSet<Long>();
        for (Object invoiceBO : reqBO.getInvoiceBOS()) {
            if (invoiceBO.getInvoiceId() == null) {
                throw new FscBusinessException("198888", "\u5165\u53c2[\u53d1\u7968Id]\u4e0d\u80fd\u4e3a\u7a7a\uff01");
            }
            if (invoiceBO.getRefundAmt().compareTo(BigDecimal.ZERO) <= 0) {
                throw new FscBusinessException("198888", "\u5165\u53c2[\u9000\u7968\u91d1\u989d\u4e0d\u80fd\u5c0f\u4e8e0]\u4e0d\u80fd\u4e3a\u7a7a\uff01");
            }
            invoiceIdSet.add(invoiceBO.getInvoiceId());
        }
        if (invoiceIdSet.size() != reqBO.getInvoiceBOS().size()) {
            throw new FscBusinessException("198888", "\u5165\u53c2\u6709\u91cd\u590d\u7684\u53d1\u7968\u4fe1\u606f\uff01");
        }
        if (reqBO.getRefundReasonType().equals(FscConstants.RefundReasonType.ORDER_REFUND) && CollectionUtils.isEmpty((Collection)reqBO.getAbnormalIds())) {
            throw new FscBusinessException("198888", "\u5f02\u5e38\u5355\u4fe1\u606f\u4e0d\u80fd\u4e3a\u7a7a\uff01");
        }
        if (reqBO.getOperationDown() != null && reqBO.getOperationDown().equals(FscConstants.OperationDown.YES) && reqBO.getOperationType().equals(FscConstants.RefundOperationType.SUBMIT) && StringUtils.isEmpty((Object)reqBO.getExt1())) {
            throw new FscBusinessException("198888", "\u5165\u53c2[\u7528\u6237\u7684erp\u8d26\u53f7]\u4e0d\u80fd\u4e3a\u7a7a\uff01");
        }
        if (reqBO.getIsQuality() != null && reqBO.getIsQuality() == 1) {
            if (CollectionUtils.isEmpty((Collection)reqBO.getQualityBOS())) {
                throw new FscBusinessException("198888", "\u5165\u53c2[\u8d28\u4fdd\u91d1\u4fe1\u606f]\u4e0d\u80fd\u4e3a\u7a7a\uff01");
            }
            if (!reqBO.getRefundReasonType().equals(FscConstants.RefundReasonType.ORDER_REFUND)) {
                throw new FscBusinessException("198888", "\u9000\u7968\u539f\u56e0\u4e0d\u662f\u9500\u8d27\u9000\u56de\uff0c\u4e0d\u80fd\u9009\u62e9\u8d28\u4fdd\u91d1\u4fe1\u606f");
            }
        }
        if (!CollectionUtils.isEmpty((Collection)reqBO.getQualityBOS())) {
            if (reqBO.getIsQuality() == null || reqBO.getIsQuality() != 1) {
                throw new FscBusinessException("198888", "\u5165\u53c2[\u662f\u5426\u542b\u4e3a\u5426\u65f6\uff0c\u8d28\u4fdd\u91d1\u4fe1\u606f]\u4e0d\u80fd\u975e\u7a7a\uff01");
            }
            BigDecimal qualityAmt = BigDecimal.ZERO;
            HashSet<Long> abnormalIdSet = new HashSet<Long>();
            for (Object qualityBO : reqBO.getQualityBOS()) {
                if (qualityBO.getAbnormalId() == null) {
                    throw new FscBusinessException("198888", "\u5165\u53c2[qualityBOS.abnormalId]\u4e0d\u80fd\u4e3a\u7a7a\uff01");
                }
                if (qualityBO.getOrderNo() == null) {
                    throw new FscBusinessException("198888", "\u5165\u53c2[qualityBOS.orderNo]\u4e0d\u80fd\u4e3a\u7a7a\uff01");
                }
                if (qualityBO.getQualityAmt() == null) {
                    throw new FscBusinessException("198888", "\u5165\u53c2[qualityBOS.qualityAmt]\u4e0d\u80fd\u4e3a\u7a7a\uff01");
                }
                if (qualityBO.getQualityDate() == null) {
                    throw new FscBusinessException("198888", "\u5165\u53c2[qualityBOS.qualityDate]\u4e0d\u80fd\u4e3a\u7a7a\uff01");
                }
                if (!reqBO.getAbnormalIds().contains(qualityBO.getAbnormalId())) {
                    throw new FscBusinessException("198888", "\u5165\u53c2[qualityBOS.abnormalId]\u6ca1\u6709\u9009\u62e9\u76f8\u5173\u5f02\u5e38\u5355\uff01");
                }
                abnormalIdSet.add(qualityBO.getAbnormalId());
                qualityAmt = qualityAmt.add(qualityBO.getQualityAmt());
            }
            if (abnormalIdSet.size() != reqBO.getQualityBOS().size()) {
                throw new FscBusinessException("198888", "\u5165\u53c2\u6709\u91cd\u590d\u7684\u8d28\u4fdd\u91d1\u4fe1\u606f\uff01");
            }
            BigDecimal refundAmt = BigDecimal.ZERO;
            for (FscBillOrderRefundCreateInvoiceBO invoiceBO : reqBO.getInvoiceBOS()) {
                refundAmt = refundAmt.add(invoiceBO.getRefundAmt());
            }
            if (qualityAmt.compareTo(refundAmt) > 0) {
                throw new FscBusinessException("198888", "\u8d28\u4fdd\u91d1\u5927\u4e8e\u9000\u7968\u91d1\u989d\uff01");
            }
            BigDecimal forwardRefundQualityAmt = BigDecimal.ZERO;
            FscOrderRelationPO relationPO = new FscOrderRelationPO();
            relationPO.setAbnormalVoucherIds(new ArrayList(abnormalIdSet));
            List list = this.fscOrderRelationMapper.getListByOrderIds(relationPO);
            if (!CollectionUtils.isEmpty((Collection)list)) {
                ArrayList<Long> occupiedRefundIds = new ArrayList<Long>();
                Set refundIdSet = list.stream().filter(e -> e.getRefundId() != null).map(FscOrderRelationPO::getRefundId).collect(Collectors.toSet());
                if (!CollectionUtils.isEmpty(refundIdSet)) {
                    FscOrderRefundPO fscOrderRefundPO = new FscOrderRefundPO();
                    fscOrderRefundPO.setRefundIdList(new ArrayList(refundIdSet));
                    List fscOrderRefundPOList = this.fscOrderRefundMapper.queryAll(fscOrderRefundPO);
                    if (!CollectionUtils.isEmpty((Collection)fscOrderRefundPOList)) {
                        for (FscOrderRefundPO orderRefundPO : fscOrderRefundPOList) {
                            if (FscConstants.RefundInvoiceStatus.DELETE.equals(orderRefundPO.getRefundStatus()) || FscConstants.RefundInvoiceStatus.CANCEL.equals(orderRefundPO.getRefundStatus()) || !reqBO.getFscOrderId().equals(orderRefundPO.getFscOrderId())) continue;
                            occupiedRefundIds.add(orderRefundPO.getRefundId());
                        }
                    }
                }
                list = list.stream().filter(e -> occupiedRefundIds.contains(e.getRefundId())).collect(Collectors.toList());
                for (FscOrderRelationPO po : list) {
                    if (po.getQualityAmt() == null || po.getRefundId() == null) continue;
                    forwardRefundQualityAmt = forwardRefundQualityAmt.add(po.getQualityAmt());
                }
            }
            BigDecimal forwardQualityAmt = BigDecimal.ZERO;
            relationPO = new FscOrderRelationPO();
            relationPO.setFscOrderId(reqBO.getFscOrderId());
            list = this.fscOrderRelationMapper.getListByOrderIds(relationPO);
            if (!CollectionUtils.isEmpty((Collection)list)) {
                for (FscOrderRelationPO po : list) {
                    if (po.getQualityAmt() == null || po.getRefundId() != null) continue;
                    forwardQualityAmt = forwardQualityAmt.add(po.getQualityAmt());
                }
            }
            if ((forwardQualityAmt = forwardQualityAmt.subtract(forwardRefundQualityAmt)).compareTo(qualityAmt) < 0) {
                throw new FscBusinessException("198888", "\u5165\u53c2\u8d28\u4fdd\u91d1\u989d\u603b\u548c\u4e0d\u80fd\u8d85\u8fc7\u6b63\u5411\u7684\u53ef\u88ab\u5360\u7528\u7684\u8d28\u4fdd\u91d1\uff01\u5269\u4f59\u53ef\u88ab\u5360\u7528\u7684\u8d28\u4fdd\u91d1\uff1a" + forwardQualityAmt.setScale(2, 4));
            }
        }
        if (reqBO.getCertification() == 1 && CollectionUtils.isEmpty((Collection)reqBO.getFileList())) {
            throw new FscBusinessException("198888", "\u7ea2\u51b2\u8bf4\u660e\u4e0d\u80fd\u4e3a\u7a7a\uff01");
        }
    }

    private Map<Long, BigDecimal> getAlreadyInvoiceIdRefundAmtMap(List<Long> invoiceIds, FscBillOrderRefundCreateAbilityReqBO reqBO) {
        List relationPOS;
        HashMap<Long, BigDecimal> invoiceIdRefundAmtMap = new HashMap<Long, BigDecimal>();
        FscInvoiceRefundRelationPO searchRefundRelationPO = new FscInvoiceRefundRelationPO();
        searchRefundRelationPO.setInvoiceIds(invoiceIds);
        if (Objects.nonNull(reqBO.getIsEdit()) && reqBO.getIsEdit() == 1) {
            searchRefundRelationPO.setRefundIdNot(reqBO.getRefundId());
        }
        if (!CollectionUtils.isEmpty((Collection)(relationPOS = this.fscInvoiceRefundRelationMapper.getList(searchRefundRelationPO)))) {
            Set refundIdSet = relationPOS.stream().filter(e -> e.getRefundId() != null).map(FscInvoiceRefundRelationPO::getRefundId).collect(Collectors.toSet());
            if (!CollectionUtils.isEmpty(refundIdSet)) {
                FscOrderRefundPO fscOrderRefundPO = new FscOrderRefundPO();
                fscOrderRefundPO.setRefundIdList(new ArrayList(refundIdSet));
                List fscOrderRefundPOList = this.fscOrderRefundMapper.queryAll(fscOrderRefundPO);
                if (!CollectionUtils.isEmpty((Collection)fscOrderRefundPOList)) {
                    List delRefundIds = fscOrderRefundPOList.stream().filter(e -> FscConstants.RefundInvoiceStatus.DELETE.equals(e.getRefundStatus()) || FscConstants.RefundInvoiceStatus.CANCEL.equals(e.getRefundStatus())).map(FscOrderRefundPO::getRefundId).collect(Collectors.toList());
                    relationPOS = relationPOS.stream().filter(e -> !delRefundIds.contains(e.getRefundId())).collect(Collectors.toList());
                }
            }
            if (!CollectionUtils.isEmpty((Collection)relationPOS)) {
                Map<Long, List<FscInvoiceRefundRelationPO>> invoiceIdMap = relationPOS.stream().collect(Collectors.groupingBy(FscInvoiceRefundRelationPO::getInvoiceId));
                for (Long invoiceId : invoiceIdMap.keySet()) {
                    List<FscInvoiceRefundRelationPO> refundRelationPOS = invoiceIdMap.get(invoiceId);
                    BigDecimal alreadyRefundAmt = BigDecimal.ZERO;
                    for (FscInvoiceRefundRelationPO refundRelationPO : refundRelationPOS) {
                        if (refundRelationPO.getRefundAmt() == null) continue;
                        alreadyRefundAmt = alreadyRefundAmt.add(refundRelationPO.getRefundAmt());
                    }
                    invoiceIdRefundAmtMap.put(invoiceId, alreadyRefundAmt);
                }
            }
        }
        return invoiceIdRefundAmtMap;
    }

    private BigDecimal checkRefundAmt(FscBillOrderRefundCreateAbilityReqBO reqBO, List<Long> invoiceIds, List<FscInvoicePO> invoiceList, FscOrderPO orderPO) {
        BigDecimal refundAmt = BigDecimal.ZERO;
        Map<Long, BigDecimal> invoiceIdRefundAmtMap = this.getAlreadyInvoiceIdRefundAmtMap(invoiceIds, reqBO);
        Set<Long> alreadyRefundinvoiceIdSet = invoiceIdRefundAmtMap.keySet();
        Map<Long, BigDecimal> invoiceIdAmtMap = invoiceList.stream().collect(Collectors.toMap(FscInvoicePO::getInvoiceId, FscInvoicePO::getAmt));
        for (FscBillOrderRefundCreateInvoiceBO invoiceBO : reqBO.getInvoiceBOS()) {
            refundAmt = refundAmt.add(invoiceBO.getRefundAmt());
            BigDecimal amt = invoiceIdAmtMap.get(invoiceBO.getInvoiceId());
            if (alreadyRefundinvoiceIdSet.contains(invoiceBO.getInvoiceId())) {
                amt = amt.subtract(invoiceIdRefundAmtMap.get(invoiceBO.getInvoiceId()));
            }
            if (invoiceBO.getRefundAmt().compareTo(amt) <= 0) continue;
            throw new FscBusinessException("198888", "\u9000\u7968\u91d1\u989d\u4e0d\u80fd\u5927\u4e8e\u5f00\u7968\u91d1\u989d\uff01");
        }
        if (refundAmt.compareTo(orderPO.getTotalCharge()) != 0) {
            throw new FscBusinessException("198888", "\u9000\u7968\u91d1\u989d\u4e0e\u5f00\u7968\u91d1\u989d\u4e0d\u4e00\u81f4\uff01");
        }
        return refundAmt;
    }
}

