/*
 * Decompiled with CFR 0.152.
 */
package com.tydic.fsc.bill.ability.impl;

import com.alibaba.fastjson.JSONObject;
import com.tydic.fsc.bill.ability.api.FscBillOrderSpecialRefundCreateAbilityService;
import com.tydic.fsc.bill.ability.bo.FscBillOrderRefundCreateInvoiceBO;
import com.tydic.fsc.bill.ability.bo.FscBillOrderSpecialRefundCreateAbilityReqBO;
import com.tydic.fsc.bill.ability.bo.FscBillOrderSpecialRefundCreateAbilityRspBO;
import com.tydic.fsc.bill.busi.api.FscBillOrderSpecialRefundCreateBusiService;
import com.tydic.fsc.bill.busi.bo.FscBillOrderSpecialRefundCreateBusiReqBO;
import com.tydic.fsc.bill.busi.bo.FscBillOrderSpecialRefundCreateBusiRspBO;
import com.tydic.fsc.common.ability.api.FscComInvoiceSyncAbilityService;
import com.tydic.fsc.common.ability.api.FscComOrderSyncAbilityService;
import com.tydic.fsc.common.ability.api.FscComRefundSyncAbilityService;
import com.tydic.fsc.common.ability.bo.FscComInvoiceListSyncAbilityReqBO;
import com.tydic.fsc.common.ability.bo.FscComOrderListSyncAbilityReqBO;
import com.tydic.fsc.common.ability.bo.FscComRefundSyncAbilityReqBO;
import com.tydic.fsc.constants.FscConstants;
import com.tydic.fsc.dao.FscOrderMapper;
import com.tydic.fsc.exception.FscBusinessException;
import com.tydic.fsc.po.FscOrderPO;
import java.util.Collection;
import java.util.Collections;
import org.springframework.beans.factory.annotation.Autowired;
import org.springframework.util.CollectionUtils;
import org.springframework.web.bind.annotation.PostMapping;
import org.springframework.web.bind.annotation.RequestBody;
import org.springframework.web.bind.annotation.RequestMapping;
import org.springframework.web.bind.annotation.RestController;

@RestController
@RequestMapping(value={"FSC_GROUP_DEV/1.0.0/com.tydic.fsc.bill.ability.api.FscBillOrderSpecialRefundCreateAbilityService"})
public class FscBillOrderSpecialRefundCreateAbilityServiceImpl
implements FscBillOrderSpecialRefundCreateAbilityService {
    @Autowired
    private FscOrderMapper fscOrderMapper;
    @Autowired
    private FscComInvoiceSyncAbilityService fscComInvoiceSyncAbilityService;
    @Autowired
    private FscComRefundSyncAbilityService fscComRefundSyncAbilityService;
    @Autowired
    private FscComOrderSyncAbilityService fscComOrderSyncAbilityService;
    @Autowired
    private FscBillOrderSpecialRefundCreateBusiService fscBillOrderSpecialRefundCreateBusiService;

    @PostMapping(value={"dealSpecialRefundCreate"})
    public FscBillOrderSpecialRefundCreateAbilityRspBO dealSpecialRefundCreate(@RequestBody FscBillOrderSpecialRefundCreateAbilityReqBO reqBO) {
        this.valid(reqBO);
        FscOrderPO orderPO = new FscOrderPO();
        orderPO.setFscOrderId(reqBO.getFscOrderId());
        orderPO.setOrderFlow(FscConstants.OrderFlow.TRACFFIC_FEE);
        orderPO = this.fscOrderMapper.getModelBy(orderPO);
        if (orderPO == null) {
            throw new FscBusinessException("198888", "\u672a\u67e5\u8be2\u5230\u7ed3\u7b97\u5355\u4fe1\u606f\uff01");
        }
        if (!orderPO.getOrderState().equals(FscConstants.FscInvoiceOrderState.BILLED) && !orderPO.getOrderState().equals(FscConstants.FscInvoiceOrderState.SIGNED)) {
            throw new FscBusinessException("198888", "\u5f53\u524d\u7ed3\u7b97\u5355\u72b6\u6001\u4e0d\u5141\u8bb8\u9000\u7968\uff01");
        }
        String reqString = JSONObject.toJSONString((Object)reqBO);
        FscBillOrderSpecialRefundCreateBusiReqBO busiReqBO = (FscBillOrderSpecialRefundCreateBusiReqBO)((Object)JSONObject.parseObject((String)reqString, FscBillOrderSpecialRefundCreateBusiReqBO.class));
        FscBillOrderSpecialRefundCreateBusiRspBO busiRspBO = this.fscBillOrderSpecialRefundCreateBusiService.dealSpecialRefundCreate(busiReqBO);
        if (!busiRspBO.getRespCode().equals("0000")) {
            throw new FscBusinessException("198888", "\u521b\u5efa\u9000\u7968\u5355\u5931\u8d25\uff1a" + busiRspBO.getRespDesc());
        }
        this.syncEs(busiRspBO, reqBO);
        FscBillOrderSpecialRefundCreateAbilityRspBO rspBO = new FscBillOrderSpecialRefundCreateAbilityRspBO();
        rspBO.setRespCode("0000");
        rspBO.setRespDesc("\u6210\u529f");
        return rspBO;
    }

    private void syncEs(FscBillOrderSpecialRefundCreateBusiRspBO busiRspBO, FscBillOrderSpecialRefundCreateAbilityReqBO reqBO) {
        FscComRefundSyncAbilityReqBO refundSyncAbilityReqBO = new FscComRefundSyncAbilityReqBO();
        refundSyncAbilityReqBO.setRefundIds(Collections.singletonList(busiRspBO.getRefundId()));
        this.fscComRefundSyncAbilityService.syncRefund(refundSyncAbilityReqBO);
        FscComInvoiceListSyncAbilityReqBO fscComInvoiceListSyncAbilityReqBO = new FscComInvoiceListSyncAbilityReqBO();
        fscComInvoiceListSyncAbilityReqBO.setFscOrderId(reqBO.getFscOrderId());
        this.fscComInvoiceSyncAbilityService.dealComOrderSyncEs(fscComInvoiceListSyncAbilityReqBO);
        FscComOrderListSyncAbilityReqBO fscComOrderListSyncAbilityReqBO = new FscComOrderListSyncAbilityReqBO();
        fscComOrderListSyncAbilityReqBO.setFscOrderId(reqBO.getFscOrderId());
        this.fscComOrderSyncAbilityService.dealComOrderSyncEs(fscComOrderListSyncAbilityReqBO);
    }

    private void valid(FscBillOrderSpecialRefundCreateAbilityReqBO reqBO) {
        if (reqBO.getOperationType() == null) {
            throw new FscBusinessException("198888", "\u5165\u53c2[operationType]\u4e0d\u80fd\u4e3a\u7a7a\uff01");
        }
        if (reqBO.getFscOrderId() == null) {
            throw new FscBusinessException("198888", "\u5165\u53c2[fscOrderId]\u4e0d\u80fd\u4e3a\u7a7a\uff01");
        }
        if (CollectionUtils.isEmpty((Collection)reqBO.getInvoiceBOS())) {
            throw new FscBusinessException("198888", "\u5165\u53c2[invoiceBOS]\u4e0d\u80fd\u4e3a\u7a7a\uff01");
        }
        if (reqBO.getCertification() == null) {
            throw new FscBusinessException("198888", "\u5165\u53c2[certification]\u4e0d\u80fd\u4e3a\u7a7a\uff01");
        }
        if (reqBO.getRefundNote() == null) {
            throw new FscBusinessException("198888", "\u5165\u53c2[refundNote]\u4e0d\u80fd\u4e3a\u7a7a\uff01");
        }
        if (reqBO.getRefundReasonType() == null) {
            throw new FscBusinessException("198888", "\u5165\u53c2[refundReasonType]\u4e0d\u80fd\u4e3a\u7a7a\uff01");
        }
        for (FscBillOrderRefundCreateInvoiceBO invoiceBO : reqBO.getInvoiceBOS()) {
            if (invoiceBO.getInvoiceId() == null) {
                throw new FscBusinessException("198888", "\u5165\u53c2[invoiceId]\u4e0d\u80fd\u4e3a\u7a7a\uff01");
            }
            if (invoiceBO.getRefundAmt() != null) continue;
            throw new FscBusinessException("198888", "\u5165\u53c2[refundAmt]\u4e0d\u80fd\u4e3a\u7a7a\uff01");
        }
    }
}

