/*
 * Decompiled with CFR 0.152.
 */
package com.tydic.fsc.bill.ability.impl;

import com.alibaba.fastjson.JSONArray;
import com.alibaba.fastjson.JSONObject;
import com.ohaotian.plugin.base.exception.ZTBusinessException;
import com.tydic.fsc.bill.ability.api.FscBillOrderSpecialRefundPushYcAbilityService;
import com.tydic.fsc.bill.ability.bo.FscBillOrderSpecialRefundPushYcAbilityReqBO;
import com.tydic.fsc.bill.ability.bo.FscBillOrderSpecialRefundPushYcAbilityRspBO;
import com.tydic.fsc.bill.busi.api.FscBillOrderSpecialRefundPushYcBusiService;
import com.tydic.fsc.bill.busi.bo.FscBillOrderSpecialRefundPushYcBusiReqBO;
import com.tydic.fsc.bill.busi.bo.FscBillOrderSpecialRefundPushYcBusiRspBO;
import com.tydic.fsc.busibase.external.api.bo.FscGetErpCustInfoReqBO;
import com.tydic.fsc.busibase.external.api.bo.FscGetErpCustInfoRspBO;
import com.tydic.fsc.busibase.external.api.bo.FscPushNewYcSaleSettleChargeAgainstClaimChangeBO;
import com.tydic.fsc.busibase.external.api.bo.FscPushNewYcSaleSettleChargeAgainstClaimChangeChangeItemBO;
import com.tydic.fsc.busibase.external.api.bo.FscPushNewYcSaleSettleChargeAgainstClaimChangeHeadBO;
import com.tydic.fsc.busibase.external.api.bo.FscPushNewYcSaleSettleChargeAgainstClaimChangeNewItemBO;
import com.tydic.fsc.busibase.external.api.bo.FscPushNewYcSaleSettleChargeAgainstHeadBO;
import com.tydic.fsc.busibase.external.api.bo.FscPushNewYcSaleSettleChargeAgainstInvoiceBO;
import com.tydic.fsc.busibase.external.api.bo.FscPushNewYcSaleSettleChargeAgainstItemBO;
import com.tydic.fsc.busibase.external.api.esb.FscGetErpCustInfoService;
import com.tydic.fsc.common.ability.api.FscComRefundSyncAbilityService;
import com.tydic.fsc.common.ability.api.FscSyncPushYcAttachmentAbilityService;
import com.tydic.fsc.common.ability.bo.FscComRefundSyncAbilityReqBO;
import com.tydic.fsc.common.ability.bo.FscPushYcAttachmentAbilityReqBO;
import com.tydic.fsc.constants.FscConstants;
import com.tydic.fsc.dao.FscDicDictionaryExernalMapper;
import com.tydic.fsc.dao.FscInvoiceItemMapper;
import com.tydic.fsc.dao.FscInvoiceRefundRelationMapper;
import com.tydic.fsc.dao.FscOrderInvoiceMapper;
import com.tydic.fsc.dao.FscOrderItemMapper;
import com.tydic.fsc.dao.FscOrderMapper;
import com.tydic.fsc.dao.FscOrderRefundMapper;
import com.tydic.fsc.dao.FscPushLogMapper;
import com.tydic.fsc.dao.FscRefundChangeItemMapper;
import com.tydic.fsc.dao.FscRefundChangeMapper;
import com.tydic.fsc.exception.FscBusinessException;
import com.tydic.fsc.po.FscDicDictionaryExernalPO;
import com.tydic.fsc.po.FscInvoiceItemPO;
import com.tydic.fsc.po.FscInvoiceRefundRelationPO;
import com.tydic.fsc.po.FscOrderInvoicePO;
import com.tydic.fsc.po.FscOrderItemPO;
import com.tydic.fsc.po.FscOrderPO;
import com.tydic.fsc.po.FscOrderRefundPO;
import com.tydic.fsc.po.FscRefundChangeItemPO;
import com.tydic.fsc.po.FscRefundChangePO;
import com.tydic.fsc.util.DateUtil;
import com.tydic.fsc.util.FscDuplicateCommitLimit;
import java.math.BigDecimal;
import java.math.RoundingMode;
import java.util.ArrayList;
import java.util.Collection;
import java.util.Collections;
import java.util.Date;
import java.util.List;
import java.util.Map;
import java.util.stream.Collectors;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;
import org.springframework.beans.factory.annotation.Autowired;
import org.springframework.beans.factory.annotation.Value;
import org.springframework.util.CollectionUtils;
import org.springframework.util.StringUtils;
import org.springframework.web.bind.annotation.PostMapping;
import org.springframework.web.bind.annotation.RequestBody;
import org.springframework.web.bind.annotation.RequestMapping;
import org.springframework.web.bind.annotation.RestController;

@RestController
@RequestMapping(value={"FSC_GROUP_DEV/1.0.0/com.tydic.fsc.bill.ability.api.FscBillOrderSpecialRefundPushYcAbilityService"})
public class FscBillOrderSpecialRefundPushYcAbilityServiceImpl
implements FscBillOrderSpecialRefundPushYcAbilityService {
    private static final Logger log = LoggerFactory.getLogger(FscBillOrderSpecialRefundPushYcAbilityServiceImpl.class);
    @Autowired
    private FscBillOrderSpecialRefundPushYcBusiService fscBillOrderSpecialRefundPushYcBusiService;
    @Autowired
    private FscSyncPushYcAttachmentAbilityService fscSyncPushYcAttachmentAbilityService;
    @Autowired
    private FscGetErpCustInfoService fscGetErpCustInfoService;
    @Autowired
    private FscComRefundSyncAbilityService fscComRefundSyncAbilityService;
    @Autowired
    private FscInvoiceRefundRelationMapper fscInvoiceRefundRelationMapper;
    @Autowired
    private FscDicDictionaryExernalMapper fscDicDictionaryExernalMapper;
    @Autowired
    private FscOrderInvoiceMapper fscOrderInvoiceMapper;
    @Autowired
    private FscInvoiceItemMapper fscInvoiceItemMapper;
    @Autowired
    private FscOrderRefundMapper fscOrderRefundMapper;
    @Autowired
    private FscOrderItemMapper fscOrderItemMapper;
    @Autowired
    private FscOrderMapper fscOrderMapper;
    @Autowired
    private FscPushLogMapper fscPushLogMapper;
    @Value(value="${OPER_ORG_ID}")
    private String operationOrgId;
    @Value(value="${OPER_ORG_NAME}")
    private String operationOrgName;
    @Value(value="${settle.stage.value:2}")
    private String settleStage;
    @Value(value="${fsc.invoice.priceMode}")
    private String priceMode;
    @Autowired
    private FscRefundChangeMapper fscRefundChangeMapper;
    @Autowired
    private FscRefundChangeItemMapper fscRefundChangeItemMapper;

    @FscDuplicateCommitLimit
    @PostMapping(value={"dealPushSpecialRefund"})
    public FscBillOrderSpecialRefundPushYcAbilityRspBO dealPushSpecialRefund(@RequestBody FscBillOrderSpecialRefundPushYcAbilityReqBO reqBO) {
        FscBillOrderSpecialRefundPushYcBusiRspBO busiRspBO;
        if (reqBO.getRefundId() == null) {
            throw new FscBusinessException("198888", "\u5165\u53c2[refundId]\u4e0d\u80fd\u4e3a\u7a7a\uff01");
        }
        FscOrderRefundPO refundPO = new FscOrderRefundPO();
        refundPO.setRefundId(reqBO.getRefundId());
        refundPO = this.fscOrderRefundMapper.getModelBy(refundPO);
        if (refundPO == null) {
            throw new FscBusinessException("198888", reqBO.getRefundId() + "\u672a\u67e5\u5230\u9000\u7968\u5355\u4fe1\u606f\uff01");
        }
        if (refundPO.getPushStatus().equals(FscConstants.FscPushStatus.SUCCESS)) {
            throw new FscBusinessException("198888", "\u5f53\u524d\u5355\u636e\u5df2\u63a8\u9001\u6210\u529f\uff0c\u8bf7\u52ff\u91cd\u590d\u63a8\u9001\uff01");
        }
        try {
            FscOrderInvoicePO orderInvoicePO = new FscOrderInvoicePO();
            orderInvoicePO.setFscOrderId(refundPO.getFscOrderId());
            orderInvoicePO = this.fscOrderInvoiceMapper.getModelBy(orderInvoicePO);
            FscPushNewYcSaleSettleChargeAgainstHeadBO headBO = this.buildHeadInfo(refundPO, orderInvoicePO);
            List<FscPushNewYcSaleSettleChargeAgainstInvoiceBO> invoiceList = this.buildInvoiceInfo(refundPO, orderInvoicePO);
            headBO.setINV_TYPE(invoiceList.get(0).getORIGINAL_INV_TYPE());
            headBO.setTAXPAYER_NUM(orderInvoicePO.getTaxNo());
            headBO.setCOMPANY_ADDRESS(orderInvoicePO.getAddress().trim());
            headBO.setBANK_NAME(orderInvoicePO.getBank().trim());
            headBO.setCOMPANY_PHONE(orderInvoicePO.getPhone().trim());
            headBO.setBANK_ACC(orderInvoicePO.getAccount().trim());
            List<FscPushNewYcSaleSettleChargeAgainstItemBO> itemList = this.buildItemInfo(headBO, refundPO);
            BigDecimal taxAmt = BigDecimal.ZERO;
            BigDecimal untaxAmt = BigDecimal.ZERO;
            for (FscPushNewYcSaleSettleChargeAgainstItemBO againstItemBO : itemList) {
                taxAmt = taxAmt.add(againstItemBO.getTAX_AMOUNT());
                untaxAmt = untaxAmt.add(againstItemBO.getNOTAX_AMOUNT());
            }
            headBO.setTAX_AMOUNT(taxAmt);
            headBO.setNOTAX_AMOUNT(untaxAmt);
            JSONArray jsonArray = new JSONArray();
            JSONObject jsonObject = new JSONObject();
            jsonObject.put("BALANCE", (Object)headBO);
            jsonObject.put("BALANCE_LINE", itemList);
            jsonObject.put("BALANCE_INVOICE", invoiceList);
            jsonObject.put("STAGE", (Object)this.settleStage);
            jsonObject.put("CLAIM_CHG", this.getClaimChangeBO(reqBO.getRefundId()));
            jsonArray.add((Object)jsonObject);
            FscBillOrderSpecialRefundPushYcBusiReqBO busiReqBO = new FscBillOrderSpecialRefundPushYcBusiReqBO();
            busiReqBO.setRefundId(reqBO.getRefundId());
            busiReqBO.setRefundNo(refundPO.getRefundNo());
            busiReqBO.setReqData(jsonArray.toJSONString());
            busiRspBO = this.fscBillOrderSpecialRefundPushYcBusiService.dealPushSpecialRefund(busiReqBO);
            this.syncEs(reqBO.getRefundId());
            if ("0000".equals(busiRspBO.getRespCode())) {
                FscPushYcAttachmentAbilityReqBO attachmentAbilityReqBO = new FscPushYcAttachmentAbilityReqBO();
                attachmentAbilityReqBO.setObjNo(refundPO.getRefundNo());
                attachmentAbilityReqBO.setObjId(refundPO.getRefundId());
                attachmentAbilityReqBO.setAgentAccount(refundPO.getExt1());
                attachmentAbilityReqBO.setAgentName(refundPO.getOperatorName());
                attachmentAbilityReqBO.setObjType(FscConstants.FSC_YC_FILE_TYPE.SALE_SETTLE_CHARGE_AGAINST);
                this.fscSyncPushYcAttachmentAbilityService.syncPushYcAttachment(attachmentAbilityReqBO);
            }
        }
        catch (Exception e) {
            log.error("\u5904\u7406\u63a8\u9001\u4e1a\u8d22\u6d41\u91cf\u8d39\u51b2\u9500\u5f02\u5e38\uff1a" + e);
            e.printStackTrace();
            FscBillOrderSpecialRefundPushYcBusiReqBO busiReqBO = new FscBillOrderSpecialRefundPushYcBusiReqBO();
            busiReqBO.setRefundNo(refundPO.getRefundNo());
            busiReqBO.setRefundId(refundPO.getRefundId());
            busiReqBO.setReqData(e.getMessage());
            this.fscBillOrderSpecialRefundPushYcBusiService.dealPushSpecialFail(busiReqBO);
            this.syncEs(reqBO.getRefundId());
            throw new FscBusinessException("198888", e.getMessage());
        }
        FscBillOrderSpecialRefundPushYcAbilityRspBO rspBO = new FscBillOrderSpecialRefundPushYcAbilityRspBO();
        rspBO.setRespCode(busiRspBO.getRespCode());
        rspBO.setRespDesc(busiRspBO.getRespDesc());
        return rspBO;
    }

    private List<FscPushNewYcSaleSettleChargeAgainstInvoiceBO> buildInvoiceInfo(FscOrderRefundPO refundPO, FscOrderInvoicePO orderInvoicePO) {
        FscDicDictionaryExernalPO externalPO = new FscDicDictionaryExernalPO();
        externalPO.setPCode("FSC_YC_REFUND_REASON_TYPE");
        externalPO.setCode(refundPO.getRefundReasonType() + "");
        List refundTypeList = this.fscDicDictionaryExernalMapper.getListByCondition(externalPO);
        if (CollectionUtils.isEmpty((Collection)refundTypeList)) {
            throw new FscBusinessException("198888", "\u7ea2\u51b2\u539f\u56e0\u672a\u5339\u914d\u5230\u7801\u503c\uff0c\u8bf7\u901a\u77e5\u8fd0\u7ef4\u7ef4\u62a4[SYS_DIC_DICTIONARY_EXERNAL]");
        }
        String invoiceKey = FscConstants.FscInvoiceCategory.ELEC.equals(orderInvoicePO.getInvoiceCategory()) ? "FSC_INVOICE_TYPE_SALE_ELECTORNIC" : (FscConstants.FscInvoiceCategory.FULL.equals(orderInvoicePO.getInvoiceCategory()) ? "FSC_INVOICE_TYPE_ELECTRONIC_FULL" : "FSC_INVOICE_TYPE_SALE");
        String invoiceType = "1".equals(orderInvoicePO.getInvoiceType()) ? "00" : "01";
        externalPO.setPCode(invoiceKey);
        externalPO.setCode(invoiceType);
        List invoiceTypeList = this.fscDicDictionaryExernalMapper.getListByCondition(externalPO);
        if (CollectionUtils.isEmpty((Collection)invoiceTypeList)) {
            throw new FscBusinessException("193128", "\u53d1\u7968\u7c7b\u578b\u672a\u5339\u914d\u5230\u7801\u503c\uff0c\u8bf7\u901a\u77e5\u8fd0\u7ef4\u7ef4\u62a4[SYS_DIC_DICTIONARY_EXERNAL]");
        }
        FscInvoiceRefundRelationPO invoiceRefundRelationPO = new FscInvoiceRefundRelationPO();
        invoiceRefundRelationPO.setRefundId(refundPO.getRefundId());
        List invoiceRefundRelationPOList = this.fscInvoiceRefundRelationMapper.getInvoiceList(invoiceRefundRelationPO);
        if (CollectionUtils.isEmpty((Collection)invoiceRefundRelationPOList)) {
            throw new FscBusinessException("198888", "\u672a\u67e5\u8be2\u5230\u9000\u7968\u53d1\u7968\u4fe1\u606f\uff01");
        }
        ArrayList<FscPushNewYcSaleSettleChargeAgainstInvoiceBO> invoiceList = new ArrayList<FscPushNewYcSaleSettleChargeAgainstInvoiceBO>(invoiceRefundRelationPOList.size());
        for (FscInvoiceRefundRelationPO refundRelationPO : invoiceRefundRelationPOList) {
            FscPushNewYcSaleSettleChargeAgainstInvoiceBO againstInvoiceBO = new FscPushNewYcSaleSettleChargeAgainstInvoiceBO();
            if (StringUtils.isEmpty((Object)refundRelationPO.getFullElecNo())) {
                againstInvoiceBO.setORIGINAL_INV_NO(refundRelationPO.getInvoiceNo());
                againstInvoiceBO.setORIGINAL_INV_CODE(refundRelationPO.getInvoiceCode());
            } else {
                againstInvoiceBO.setORIGINAL_INV_NO(refundRelationPO.getFullElecNo());
                againstInvoiceBO.setORIGINAL_INV_CODE("");
            }
            againstInvoiceBO.setORIGINAL_INV_AMOUNT(refundRelationPO.getUntaxAmt());
            againstInvoiceBO.setORIGINAL_INV_TAX(refundRelationPO.getTaxAmt());
            againstInvoiceBO.setORIGINAL_INV_TYPE(((FscDicDictionaryExernalPO)invoiceTypeList.get(0)).getExernalCode());
            againstInvoiceBO.setRED_REASON(((FscDicDictionaryExernalPO)refundTypeList.get(0)).getExernalCode());
            againstInvoiceBO.setEG_TESCO_ID(refundRelationPO.getInvoiceId() + "");
            againstInvoiceBO.setORI_SPECIFIC_FACTOR("");
            invoiceList.add(againstInvoiceBO);
        }
        return invoiceList;
    }

    private List<FscPushNewYcSaleSettleChargeAgainstItemBO> buildItemInfo(FscPushNewYcSaleSettleChargeAgainstHeadBO headBO, FscOrderRefundPO refundPO) {
        ArrayList<FscPushNewYcSaleSettleChargeAgainstItemBO> againstItemList = new ArrayList<FscPushNewYcSaleSettleChargeAgainstItemBO>();
        FscOrderItemPO orderItemPO = new FscOrderItemPO();
        orderItemPO.setRefundId(refundPO.getRefundId());
        List refundOrderItemList = this.fscOrderItemMapper.getListNoPage(orderItemPO);
        ArrayList<Long> invoiceItemIdList = new ArrayList<Long>();
        ArrayList<Long> orderItemIdList = new ArrayList<Long>();
        for (FscOrderItemPO itemPO : refundOrderItemList) {
            invoiceItemIdList.add(itemPO.getInvoiceItemId());
            orderItemIdList.add(itemPO.getOrderItemId());
        }
        if (CollectionUtils.isEmpty(invoiceItemIdList)) {
            throw new FscBusinessException("198888", "\u83b7\u53d6\u9000\u7968\u53d1\u7968\u660e\u7ec6id\u4e3a\u7a7a\uff01");
        }
        FscInvoiceItemPO invoiceItemPO = new FscInvoiceItemPO();
        invoiceItemPO.setIds(invoiceItemIdList);
        List invoiceItemPOS = this.fscInvoiceItemMapper.getList(invoiceItemPO);
        if (CollectionUtils.isEmpty((Collection)invoiceItemPOS)) {
            throw new FscBusinessException("198888", "\u83b7\u53d6\u9000\u7968\u53d1\u7968\u660e\u7ec6\u4e3a\u7a7a\uff01");
        }
        Map<Long, FscInvoiceItemPO> invoiceItemMap = invoiceItemPOS.stream().collect(Collectors.toMap(FscInvoiceItemPO::getId, e -> e));
        orderItemPO.setRefundId(null);
        orderItemPO.setOrderItemIds(orderItemIdList);
        orderItemPO.setFscOrderId(refundPO.getFscOrderId());
        List orderItemList = this.fscOrderItemMapper.getListNoPage(orderItemPO);
        if (CollectionUtils.isEmpty((Collection)orderItemList)) {
            throw new FscBusinessException("198888", "\u83b7\u53d6\u539f\u7ed3\u7b97\u660e\u7ec6\u884c\u4fe1\u606f\u4e3a\u7a7a\uff01");
        }
        Map<Long, Long> orderItemMap = orderItemList.stream().collect(Collectors.toMap(FscOrderItemPO::getOrderItemId, FscOrderItemPO::getId));
        for (FscOrderItemPO itemPO : refundOrderItemList) {
            FscPushNewYcSaleSettleChargeAgainstItemBO againstItemBO = new FscPushNewYcSaleSettleChargeAgainstItemBO();
            againstItemBO.setLINE_TYPE(headBO.getBALANCE_TYPE());
            againstItemBO.setTRADE_NAME(itemPO.getSkuName());
            againstItemBO.setQUANTITY(itemPO.getNum().negate());
            againstItemBO.setAMOUNT(itemPO.getAmt().negate());
            againstItemBO.setTAX_RATE(itemPO.getTaxRate().setScale(2, RoundingMode.HALF_UP).multiply(new BigDecimal(100)));
            againstItemBO.setNOTAX_AMOUNT(itemPO.getUntaxAmt().negate());
            againstItemBO.setTAX_AMOUNT(itemPO.getTaxAmt().negate());
            againstItemBO.setPRICE(itemPO.getPrice());
            againstItemBO.setPRICE_NOTAX(itemPO.getPrice().divide(BigDecimal.ONE.add(itemPO.getTaxRate()), 8, 4));
            againstItemBO.setORG_ID(headBO.getORG_ID());
            againstItemBO.setEG_TESCO_ID(itemPO.getId() + "");
            FscInvoiceItemPO fscInvoiceItemPO = invoiceItemMap.get(itemPO.getInvoiceItemId());
            againstItemBO.setCOST_PRICE(BigDecimal.ZERO);
            againstItemBO.setORI_LINE_CODE(fscInvoiceItemPO.getItemNo());
            againstItemBO.setEG_ITEM_DESCRIPTION(fscInvoiceItemPO.getSkuName());
            againstItemBO.setUNIT_DIS(fscInvoiceItemPO.getUnit());
            againstItemBO.setTAX_TYPE(fscInvoiceItemPO.getTaxCode());
            againstItemBO.setEG_BALANCE_LINE_ID(orderItemMap.get(itemPO.getOrderItemId()) + "");
            againstItemBO.setPART_NUMBER(null);
            againstItemBO.setSPE_MODEL(null);
            againstItemList.add(againstItemBO);
            againstItemBO.setEG_INV_LINE_ID(fscInvoiceItemPO.getInvoiceId() + "");
            if (StringUtils.isEmpty((Object)orderItemPO.getSkuNo())) continue;
            againstItemBO.setMATERIAL_CODE(itemPO.getSkuNo());
        }
        return againstItemList;
    }

    private FscPushNewYcSaleSettleChargeAgainstHeadBO buildHeadInfo(FscOrderRefundPO refundPO, FscOrderInvoicePO orderInvoicePO) {
        FscPushNewYcSaleSettleChargeAgainstHeadBO headBO = new FscPushNewYcSaleSettleChargeAgainstHeadBO();
        headBO.setEG_BILL_NUM(refundPO.getRefundNo());
        headBO.setPERSON_ID(refundPO.getYcUserId() + "");
        headBO.setPERSON_NAME(refundPO.getYcPersonName());
        headBO.setDEPT_ID(refundPO.getYcDeptId() + "");
        headBO.setDEPT_NAME(refundPO.getYcDeptName());
        headBO.setORG_ID(this.operationOrgId);
        headBO.setORG_NAME(this.operationOrgName);
        headBO.setPRICE_TYPE(this.priceMode);
        headBO.setDOC_COUNT("0");
        headBO.setBALANCE_ID(refundPO.getFscOrderId() + "");
        headBO.setBALANCE_NUM(refundPO.getFscOrderNo());
        headBO.setINV_AMOUNT(refundPO.getTotalCharge());
        headBO.setBILL_DATE(DateUtil.dateToStr((Date)refundPO.getCreateTime()));
        headBO.setDESCRIPTIONS(refundPO.getRefundNote());
        headBO.setREC_BAL_AMOUNT(refundPO.getTotalCharge());
        headBO.setEG_TESCO_ID(refundPO.getRefundId() + "");
        if (refundPO.getOrderType() == 15) {
            headBO.setTASK_FLAG("N");
        } else {
            headBO.setTASK_FLAG("Y");
        }
        FscDicDictionaryExernalPO externalPO = new FscDicDictionaryExernalPO();
        externalPO.setPCode("FSC_ORDER_SOURCE");
        externalPO.setCode(refundPO.getOrderType() + "");
        List fscTypeList = this.fscDicDictionaryExernalMapper.getListByCondition(externalPO);
        if (CollectionUtils.isEmpty((Collection)fscTypeList)) {
            throw new FscBusinessException("198888", "\u7ed3\u7b97\u7c7b\u578b\u672a\u5339\u914d\u5230\u7801\u503c\uff0c\u8bf7\u901a\u77e5\u8fd0\u7ef4\u7ef4\u62a4[SYS_DIC_DICTIONARY_EXERNAL]");
        }
        headBO.setBALANCE_TYPE_DIS(((FscDicDictionaryExernalPO)fscTypeList.get(0)).getExernalTitle());
        headBO.setBALANCE_TYPE(((FscDicDictionaryExernalPO)fscTypeList.get(0)).getExernalCode());
        if (refundPO.getOrderType() != 15) {
            FscGetErpCustInfoReqBO custInfoReqBO = new FscGetErpCustInfoReqBO();
            custInfoReqBO.setCustomerName(orderInvoicePO.getBuyName());
            FscGetErpCustInfoRspBO erpCustInfo = this.fscGetErpCustInfoService.getErpCustInfo(custInfoReqBO);
            if (!erpCustInfo.getRespCode().equals("0000")) {
                throw new FscBusinessException(erpCustInfo.getRespCode(), erpCustInfo.getRespDesc());
            }
            headBO.setVENDOR_ID(erpCustInfo.getCustAccountId());
        }
        headBO.setVENDOR_NAME(orderInvoicePO.getBuyName());
        headBO.setEG_TESCO_EMAIL(orderInvoicePO.getReceiveEmail());
        headBO.setCOST_AMOUNT(BigDecimal.ZERO);
        headBO.setCOST_AMOUNT_NOTAX(BigDecimal.ZERO);
        headBO.setAMOUNT(refundPO.getRefundAmount().negate());
        headBO.setEG_SETTLE_NUMBER(refundPO.getRefundNo());
        headBO.setEG_TESCO_SETTLE_ID(refundPO.getRefundId() + "");
        FscOrderPO orderPO = new FscOrderPO();
        orderPO.setFscOrderId(refundPO.getFscOrderId());
        orderPO = this.fscOrderMapper.getModelBy(orderPO);
        headBO.setEG_SETTLE_NAME(orderPO.getOrderName());
        headBO.setINV_DESCRIPTIONS(orderPO.getInvoiceRemark());
        return headBO;
    }

    private void syncEs(Long refundId) {
        FscComRefundSyncAbilityReqBO refundSyncAbilityReqBO = new FscComRefundSyncAbilityReqBO();
        refundSyncAbilityReqBO.setRefundIds(Collections.singletonList(refundId));
        this.fscComRefundSyncAbilityService.syncRefund(refundSyncAbilityReqBO);
    }

    private List<FscPushNewYcSaleSettleChargeAgainstClaimChangeBO> getClaimChangeBO(Long refundId) {
        ArrayList<FscPushNewYcSaleSettleChargeAgainstClaimChangeBO> claimChangeBOS = new ArrayList<FscPushNewYcSaleSettleChargeAgainstClaimChangeBO>();
        List refundChangePOS = this.fscRefundChangeMapper.queryByRefundId(refundId);
        if (!CollectionUtils.isEmpty((Collection)refundChangePOS)) {
            refundChangePOS = refundChangePOS.stream().filter(e -> e.getDelFlag() == null || e.getDelFlag() != 1).collect(Collectors.toList());
        }
        if (!CollectionUtils.isEmpty((Collection)refundChangePOS)) {
            FscDicDictionaryExernalPO eternalPo = new FscDicDictionaryExernalPO();
            eternalPo.setPCode("FSC_YC_CLAIM_TYPE");
            Map<String, String> dicMap = this.getDicMap(eternalPo);
            List changeItemPOS = this.fscRefundChangeItemMapper.queryByRefundId(refundId);
            if (!CollectionUtils.isEmpty((Collection)changeItemPOS)) {
                changeItemPOS = changeItemPOS.stream().filter(e -> e.getDelFlag() == null || e.getDelFlag() != 1).collect(Collectors.toList());
            }
            if (!CollectionUtils.isEmpty((Collection)changeItemPOS)) {
                Map<Long, List<FscRefundChangePO>> claimIdHeadMap = refundChangePOS.stream().collect(Collectors.groupingBy(FscRefundChangePO::getClaimId));
                Map<Long, List<FscRefundChangeItemPO>> claimIdItemMap = changeItemPOS.stream().collect(Collectors.groupingBy(FscRefundChangeItemPO::getPreClaimId));
                for (Long claimId : claimIdHeadMap.keySet()) {
                    FscPushNewYcSaleSettleChargeAgainstClaimChangeBO claimChangeBO = new FscPushNewYcSaleSettleChargeAgainstClaimChangeBO();
                    FscRefundChangePO refundChangePO = claimIdHeadMap.get(claimId).get(0);
                    FscPushNewYcSaleSettleChargeAgainstClaimChangeHeadBO claimChangeHeadBO = new FscPushNewYcSaleSettleChargeAgainstClaimChangeHeadBO();
                    if (refundChangePO.getYcOrgId() == null || refundChangePO.getYcUserId() == null || refundChangePO.getYcDeptId() == null) {
                        throw new ZTBusinessException("\u865a\u62df\u53d8\u66f4\u4eba\u7f3a\u5c11\u7ecf\u529e\u4eba\u4fe1\u606f");
                    }
                    claimChangeHeadBO.setORG_ID(refundChangePO.getYcOrgId().toString());
                    claimChangeHeadBO.setORG_NAME(refundChangePO.getYcOrgName());
                    claimChangeHeadBO.setPERSON_ID(refundChangePO.getYcUserId().toString());
                    claimChangeHeadBO.setPERSON_NAME(refundChangePO.getYcUserName());
                    claimChangeHeadBO.setDEPT_ID(refundChangePO.getYcDeptId().toString());
                    claimChangeHeadBO.setDEPT_NAME(refundChangePO.getYcDeptName());
                    claimChangeHeadBO.setEG_REC_ID(claimId.toString());
                    claimChangeHeadBO.setEG_REC_BILL_NUM(refundChangePO.getClaimNo());
                    claimChangeHeadBO.setEG_BILL_NUM(refundChangePO.getChangeNo());
                    claimChangeHeadBO.setBILL_DATE(DateUtil.dateToStr((Date)refundChangePO.getCreateTime()));
                    claimChangeHeadBO.setCHANGE_AMOUNT(refundChangePO.getChangeAmt());
                    claimChangeHeadBO.setEG_TESCO_ID(refundChangePO.getChangeId().toString());
                    claimChangeBO.setClaimChangeHeadBO(claimChangeHeadBO);
                    ArrayList<FscPushNewYcSaleSettleChargeAgainstClaimChangeNewItemBO> newItemBOList = new ArrayList<FscPushNewYcSaleSettleChargeAgainstClaimChangeNewItemBO>();
                    ArrayList<FscPushNewYcSaleSettleChargeAgainstClaimChangeChangeItemBO> changeItemBOList = new ArrayList<FscPushNewYcSaleSettleChargeAgainstClaimChangeChangeItemBO>();
                    List<FscRefundChangeItemPO> refundChangeItemPOS = claimIdItemMap.get(claimId);
                    for (FscRefundChangeItemPO changeItemPO : refundChangeItemPOS) {
                        FscPushNewYcSaleSettleChargeAgainstClaimChangeChangeItemBO changeItemBO = new FscPushNewYcSaleSettleChargeAgainstClaimChangeChangeItemBO();
                        changeItemBO.setCLAIM_TYPE(dicMap.get(changeItemPO.getClaimType().toString()));
                        if (changeItemPO.getPreFscOrderId() != null) {
                            changeItemBO.setBALANCE_ID(changeItemPO.getPreFscOrderId().toString());
                        }
                        changeItemBO.setBALANCE_NUM(changeItemPO.getPreFscOrderNo());
                        changeItemBO.setAMOUNT(changeItemPO.getChangeAmt());
                        changeItemBO.setEG_FROM_TESCO_ID(changeItemPO.getPreClaimDetailId().toString());
                        changeItemBO.setPERSON_ID(changeItemPO.getPreHandleUserId().toString());
                        changeItemBO.setPERSON_NAME(changeItemPO.getPreHandleUserName());
                        changeItemBO.setDEPT_ID(changeItemPO.getPreHandleDeptId().toString());
                        changeItemBO.setDEPT_NAME(changeItemPO.getPreHandleDeptName());
                        changeItemBOList.add(changeItemBO);
                        FscPushNewYcSaleSettleChargeAgainstClaimChangeNewItemBO newItemBO = new FscPushNewYcSaleSettleChargeAgainstClaimChangeNewItemBO();
                        newItemBO.setPERSON_ID(changeItemPO.getHandleUserId().toString());
                        newItemBO.setPERSON_NAME(changeItemPO.getHandleUserName());
                        newItemBO.setDEPT_ID(changeItemPO.getHandleDeptId().toString());
                        newItemBO.setDEPT_NAME(changeItemPO.getHandleDeptName());
                        newItemBO.setCLAIM_TYPE(dicMap.get(changeItemPO.getClaimType().toString()));
                        newItemBO.setEG_TESCO_ID(changeItemPO.getChangeItemId().toString());
                        newItemBO.setCLAIM_AMOUNT(changeItemPO.getClaimAmt());
                        newItemBOList.add(newItemBO);
                    }
                    claimChangeBO.setNewItemBOList(newItemBOList);
                    claimChangeBO.setChangeItemBOList(changeItemBOList);
                    claimChangeBOS.add(claimChangeBO);
                }
            }
        }
        return claimChangeBOS;
    }

    private Map<String, String> getDicMap(FscDicDictionaryExernalPO eternalPo) {
        List listByCondition = this.fscDicDictionaryExernalMapper.getListByCondition(eternalPo);
        if (CollectionUtils.isEmpty((Collection)listByCondition)) {
            throw new FscBusinessException("190000", "\u672a\u67e5\u8be2\u5230\u7ed3\u7b97\u7c7b\u578b\u5b57\u5178\uff01");
        }
        return listByCondition.stream().collect(Collectors.toMap(FscDicDictionaryExernalPO::getCode, FscDicDictionaryExernalPO::getExernalCode));
    }
}

