/*
 * Decompiled with CFR 0.152.
 */
package com.tydic.fsc.bill.ability.impl;

import com.alibaba.fastjson.JSONObject;
import com.tydic.fsc.bill.ability.api.FscBillOrderSpecialRefundUpdateAbilityService;
import com.tydic.fsc.bill.ability.bo.FscBillOrderRefundCreateInvoiceBO;
import com.tydic.fsc.bill.ability.bo.FscBillOrderSpecialRefundUpdateAbilityReqBO;
import com.tydic.fsc.bill.ability.bo.FscBillOrderSpecialRefundUpdateAbilityRspBO;
import com.tydic.fsc.bill.busi.api.FscBillOrderSpecialRefundUpdateBusiService;
import com.tydic.fsc.bill.busi.bo.FscBillOrderSpecialRefundUpdateBusiReqBO;
import com.tydic.fsc.bill.busi.bo.FscBillOrderSpecialRefundUpdateBusiRspBO;
import com.tydic.fsc.common.ability.api.FscComInvoiceSyncAbilityService;
import com.tydic.fsc.common.ability.api.FscComOrderSyncAbilityService;
import com.tydic.fsc.common.ability.api.FscComRefundSyncAbilityService;
import com.tydic.fsc.common.ability.bo.FscComInvoiceListSyncAbilityReqBO;
import com.tydic.fsc.common.ability.bo.FscComOrderListSyncAbilityReqBO;
import com.tydic.fsc.common.ability.bo.FscComRefundSyncAbilityReqBO;
import com.tydic.fsc.constants.FscConstants;
import com.tydic.fsc.dao.FscOrderRefundMapper;
import com.tydic.fsc.exception.FscBusinessException;
import com.tydic.fsc.po.FscOrderRefundPO;
import java.util.Collection;
import java.util.Collections;
import org.springframework.beans.factory.annotation.Autowired;
import org.springframework.util.CollectionUtils;
import org.springframework.web.bind.annotation.PostMapping;
import org.springframework.web.bind.annotation.RequestBody;
import org.springframework.web.bind.annotation.RequestMapping;
import org.springframework.web.bind.annotation.RestController;

@RestController
@RequestMapping(value={"FSC_GROUP_DEV/1.0.0/com.tydic.fsc.bill.ability.api.FscBillOrderSpecialRefundUpdateAbilityService"})
public class FscBillOrderSpecialRefundUpdateAbilityServiceImpl
implements FscBillOrderSpecialRefundUpdateAbilityService {
    @Autowired
    private FscOrderRefundMapper fscOrderRefundMapper;
    @Autowired
    private FscComInvoiceSyncAbilityService fscComInvoiceSyncAbilityService;
    @Autowired
    private FscComRefundSyncAbilityService fscComRefundSyncAbilityService;
    @Autowired
    private FscComOrderSyncAbilityService fscComOrderSyncAbilityService;
    @Autowired
    private FscBillOrderSpecialRefundUpdateBusiService fscBillOrderSpecialRefundUpdateBusiService;

    @PostMapping(value={"dealSpecialRefundUpdate"})
    public FscBillOrderSpecialRefundUpdateAbilityRspBO dealSpecialRefundUpdate(@RequestBody FscBillOrderSpecialRefundUpdateAbilityReqBO reqBO) {
        this.valid(reqBO);
        FscOrderRefundPO refundPO = new FscOrderRefundPO();
        refundPO.setRefundId(reqBO.getRefundId());
        refundPO = this.fscOrderRefundMapper.getModelBy(refundPO);
        if (refundPO == null) {
            throw new FscBusinessException("198888", "\u672a\u6839\u636e\u9000\u7968id[" + reqBO.getRefundId() + "]\u67e5\u8be2\u5230\u9000\u7968\u4fe1\u606f");
        }
        if (!(refundPO.getRefundStatus().equals(FscConstants.RefundInvoiceStatus.SAVE) || refundPO.getRefundStatus().equals(FscConstants.RefundInvoiceStatus.REFUND_BACK) || refundPO.getRefundStatus().equals(FscConstants.RefundInvoiceStatus.APPROVAL_REJECT))) {
            throw new FscBusinessException("198888", "\u5f53\u524d\u9000\u7968\u5355\u636e\u72b6\u6001\u4e0d\u5141\u8bb8\u4fee\u6539\uff01");
        }
        FscBillOrderSpecialRefundUpdateBusiReqBO busiReqBO = (FscBillOrderSpecialRefundUpdateBusiReqBO)((Object)JSONObject.parseObject((String)JSONObject.toJSONString((Object)reqBO), FscBillOrderSpecialRefundUpdateBusiReqBO.class));
        FscBillOrderSpecialRefundUpdateBusiRspBO busiRspBO = this.fscBillOrderSpecialRefundUpdateBusiService.dealSpecialRefundUpdate(busiReqBO);
        if (!busiRspBO.getRespCode().equals("0000")) {
            throw new FscBusinessException("198888", "\u4fee\u6539\u9000\u7968\u5355\u4fe1\u606f\u5931\u8d25\uff1a" + busiRspBO.getRespDesc());
        }
        this.syncEs(refundPO);
        FscBillOrderSpecialRefundUpdateAbilityRspBO rspBO = new FscBillOrderSpecialRefundUpdateAbilityRspBO();
        rspBO.setRespCode("0000");
        rspBO.setRespDesc("\u6210\u529f");
        return rspBO;
    }

    private void valid(FscBillOrderSpecialRefundUpdateAbilityReqBO reqBO) {
        if (reqBO.getRefundId() == null) {
            throw new FscBusinessException("198888", "\u5165\u53c2[refundId]\u4e0d\u80fd\u4e3a\u7a7a\uff01");
        }
        if (CollectionUtils.isEmpty((Collection)reqBO.getInvoiceBOS())) {
            throw new FscBusinessException("198888", "\u5165\u53c2[invoiceBOS]\u4e0d\u80fd\u4e3a\u7a7a\uff01");
        }
        for (FscBillOrderRefundCreateInvoiceBO invoiceBO : reqBO.getInvoiceBOS()) {
            if (invoiceBO.getInvoiceId() == null) {
                throw new FscBusinessException("198888", "\u5165\u53c2[invoiceId]\u4e0d\u80fd\u4e3a\u7a7a\uff01");
            }
            if (invoiceBO.getRefundAmt() != null) continue;
            throw new FscBusinessException("198888", "\u5165\u53c2[refundAmt]\u4e0d\u80fd\u4e3a\u7a7a\uff01");
        }
    }

    private void syncEs(FscOrderRefundPO refundPO) {
        FscComRefundSyncAbilityReqBO refundSyncAbilityReqBO = new FscComRefundSyncAbilityReqBO();
        refundSyncAbilityReqBO.setRefundIds(Collections.singletonList(refundPO.getRefundId()));
        this.fscComRefundSyncAbilityService.syncRefund(refundSyncAbilityReqBO);
        FscComInvoiceListSyncAbilityReqBO fscComInvoiceListSyncAbilityReqBO = new FscComInvoiceListSyncAbilityReqBO();
        fscComInvoiceListSyncAbilityReqBO.setFscOrderId(refundPO.getFscOrderId());
        this.fscComInvoiceSyncAbilityService.dealComOrderSyncEs(fscComInvoiceListSyncAbilityReqBO);
        FscComOrderListSyncAbilityReqBO fscComOrderListSyncAbilityReqBO = new FscComOrderListSyncAbilityReqBO();
        fscComOrderListSyncAbilityReqBO.setFscOrderId(refundPO.getFscOrderId());
        this.fscComOrderSyncAbilityService.dealComOrderSyncEs(fscComOrderListSyncAbilityReqBO);
    }
}

