/*
 * Decompiled with CFR 0.152.
 */
package com.tydic.fsc.bill.ability.impl;

import com.alibaba.fastjson.JSON;
import com.alibaba.fastjson.JSONObject;
import com.tydic.fsc.base.FscRspBaseBO;
import com.tydic.fsc.bill.ability.api.FscBillEcomDealInvoiceMsgAbilityService;
import com.tydic.fsc.bill.ability.api.FscBillInvoiceImplAbilityService;
import com.tydic.fsc.bill.ability.api.FscBillOrderCreateAbilityService;
import com.tydic.fsc.bill.ability.api.FscBillOrderInvoiceSignAbilityService;
import com.tydic.fsc.bill.ability.api.FscBillOrderSyncRetransAbilityService;
import com.tydic.fsc.bill.ability.bo.FscBillEcomDealInvoiceMsgAbilityReqBO;
import com.tydic.fsc.bill.ability.bo.FscBillInvoiceImplAbilityReqBO;
import com.tydic.fsc.bill.ability.bo.FscBillOrderCreateAbilityReqBO;
import com.tydic.fsc.bill.ability.bo.FscBillOrderInvoiceSignAbilityReqBO;
import com.tydic.fsc.bill.ability.bo.FscBillOrderSyncRetransAbilityReqBO;
import com.tydic.fsc.bill.ability.bo.FscBillOrderSyncRetransAbilityRspBO;
import com.tydic.fsc.busibase.busi.api.FscOrderFailLogUpdateBusiService;
import com.tydic.fsc.busibase.busi.bo.FscOrderFailLogUpdateBusiReqBO;
import com.tydic.fsc.constants.FscConstants;
import com.tydic.fsc.dao.FscOrderFailLogMapper;
import com.tydic.fsc.po.FscOrderFailLogPO;
import java.util.ArrayList;
import java.util.Collection;
import java.util.List;
import org.apache.commons.lang3.StringUtils;
import org.springframework.beans.factory.annotation.Autowired;
import org.springframework.util.CollectionUtils;
import org.springframework.web.bind.annotation.PostMapping;
import org.springframework.web.bind.annotation.RequestBody;
import org.springframework.web.bind.annotation.RequestMapping;
import org.springframework.web.bind.annotation.RestController;

@RestController
@RequestMapping(value={"FSC_GROUP_DEV/1.0.0/com.tydic.fsc.bill.ability.api.FscBillOrderSyncRetransAbilityService"})
public class FscBillOrderSyncRetransAbilityServiceImpl
implements FscBillOrderSyncRetransAbilityService {
    @Autowired
    private FscOrderFailLogMapper fscOrderFailLogMapper;
    @Autowired
    private FscOrderFailLogUpdateBusiService fscOrderFailLogUpdateBusiService;
    @Autowired
    private FscBillOrderInvoiceSignAbilityService fscBillOrderInvoiceSignAbilityService;
    @Autowired
    private FscBillInvoiceImplAbilityService fscBillInvoiceImplAbilityService;
    @Autowired
    private FscBillOrderCreateAbilityService fscBillOrderCreateAbilityService;
    @Autowired
    private FscBillEcomDealInvoiceMsgAbilityService fscBillEcomDealInvoiceMsgAbilityService;

    @PostMapping(value={"dealRetrans"})
    public FscBillOrderSyncRetransAbilityRspBO dealRetrans(@RequestBody FscBillOrderSyncRetransAbilityReqBO reqBO) {
        FscOrderFailLogPO fscOrderFailLogPO = (FscOrderFailLogPO)JSON.parseObject((String)JSON.toJSONString((Object)reqBO), FscOrderFailLogPO.class);
        fscOrderFailLogPO.setDealStatus(FscConstants.FscOrderFailRetransDealStatus.WAIT_DEAL);
        ArrayList<Integer> busiTypes = new ArrayList<Integer>();
        busiTypes.add(FscConstants.FscOrderFailRetansBusiType.FSC_ORDER_INVOICE_SIGN_FAIL);
        busiTypes.add(FscConstants.FscOrderFailRetansBusiType.FSC_ORDER_INVOICE_BILL_FAIL);
        busiTypes.add(FscConstants.FscOrderFailRetansBusiType.FSC_DOWN_TAKE_UP_FAIL);
        fscOrderFailLogPO.setBusiTypes(busiTypes);
        List fscOrderFailLogPOS = this.fscOrderFailLogMapper.getList(fscOrderFailLogPO);
        if (!CollectionUtils.isEmpty((Collection)fscOrderFailLogPOS)) {
            for (FscOrderFailLogPO fscOrderFailLog : fscOrderFailLogPOS) {
                this.updateStatus(FscConstants.FscOrderFailRetransDealStatus.DEALLING, fscOrderFailLog.getId(), null);
                FscRspBaseBO fscRspBaseBO = null;
                if (FscConstants.FscOrderFailRetansBusiType.FSC_ORDER_INVOICE_SIGN_FAIL.equals(fscOrderFailLog.getBusiType())) {
                    fscRspBaseBO = this.dealInvoiceSignSync(fscOrderFailLog);
                }
                if (FscConstants.FscOrderFailRetansBusiType.FSC_ORDER_INVOICE_BILL_FAIL.equals(fscOrderFailLog.getBusiType())) {
                    fscRspBaseBO = this.dealInvoiceSubmitSync(fscOrderFailLog);
                }
                if (FscConstants.FscOrderFailRetansBusiType.FSC_DOWN_TAKE_UP_FAIL.equals(fscOrderFailLog.getBusiType())) {
                    fscRspBaseBO = this.dealDownTakeUpCreate(fscOrderFailLog);
                }
                if (FscConstants.FscOrderFailRetansBusiType.FSC_DEAL_ECOM_MSG_FAIL.equals(fscOrderFailLog.getBusiType())) {
                    fscRspBaseBO = this.dealEcomMsg(fscOrderFailLog);
                }
                if (null != fscRspBaseBO) {
                    this.updateStatus(this.getDealStatus(fscRspBaseBO), fscOrderFailLog.getId(), fscRspBaseBO.getRespDesc());
                    continue;
                }
                this.updateStatus(FscConstants.FscOrderFailRetransDealStatus.WAIT_DEAL, fscOrderFailLog.getId(), null);
            }
        }
        return new FscBillOrderSyncRetransAbilityRspBO();
    }

    private FscRspBaseBO dealEcomMsg(FscOrderFailLogPO fscOrderFailLog) {
        FscBillEcomDealInvoiceMsgAbilityReqBO abilityReqBO = (FscBillEcomDealInvoiceMsgAbilityReqBO)JSONObject.parseObject((String)fscOrderFailLog.getBusiFailReq(), FscBillEcomDealInvoiceMsgAbilityReqBO.class);
        if (abilityReqBO.getId() == null) {
            return new FscRspBaseBO();
        }
        return this.fscBillEcomDealInvoiceMsgAbilityService.dealEcomMsg(abilityReqBO);
    }

    private FscRspBaseBO dealInvoiceSignSync(FscOrderFailLogPO fscOrderFailLog) {
        if (null == fscOrderFailLog.getObjId()) {
            return new FscRspBaseBO();
        }
        FscBillOrderInvoiceSignAbilityReqBO signAbilityReqBO = new FscBillOrderInvoiceSignAbilityReqBO();
        signAbilityReqBO.setOrderId(fscOrderFailLog.getObjId());
        signAbilityReqBO.setAutoSignFlag("0");
        return this.fscBillOrderInvoiceSignAbilityService.dealOrderInvoiceSign(signAbilityReqBO);
    }

    private FscRspBaseBO dealInvoiceSubmitSync(FscOrderFailLogPO fscOrderFailLog) {
        if (null == fscOrderFailLog.getObjId()) {
            return new FscRspBaseBO();
        }
        FscBillInvoiceImplAbilityReqBO fscBillInvoiceImplAbilityReqBO = new FscBillInvoiceImplAbilityReqBO();
        fscBillInvoiceImplAbilityReqBO.setOrderId(fscOrderFailLog.getObjId());
        return this.fscBillInvoiceImplAbilityService.dealInvoiceImpl(fscBillInvoiceImplAbilityReqBO);
    }

    private FscRspBaseBO dealDownTakeUpCreate(FscOrderFailLogPO fscOrderFailLog) {
        if (StringUtils.isBlank((CharSequence)fscOrderFailLog.getBusiFailDesc())) {
            return new FscRspBaseBO();
        }
        FscBillOrderCreateAbilityReqBO fscBillOrderCreateAbilityReqBO = (FscBillOrderCreateAbilityReqBO)JSON.parseObject((String)fscOrderFailLog.getBusiFailDesc(), FscBillOrderCreateAbilityReqBO.class);
        return this.fscBillOrderCreateAbilityService.dealCreate(fscBillOrderCreateAbilityReqBO);
    }

    private void updateStatus(Integer status, Long id, String desc) {
        FscOrderFailLogUpdateBusiReqBO fscOrderFailLogUpdateBusiReqBO = new FscOrderFailLogUpdateBusiReqBO();
        fscOrderFailLogUpdateBusiReqBO.setId(id);
        fscOrderFailLogUpdateBusiReqBO.setDealStatus(status);
        fscOrderFailLogUpdateBusiReqBO.setDealResultDesc(desc);
        this.fscOrderFailLogUpdateBusiService.dealUpdate(fscOrderFailLogUpdateBusiReqBO);
    }

    private Integer getDealStatus(FscRspBaseBO fscRspBaseBO) {
        if ("0000".equals(fscRspBaseBO.getRespCode())) {
            return FscConstants.FscOrderFailRetransDealStatus.SUCCESS;
        }
        return FscConstants.FscOrderFailRetransDealStatus.FAIL;
    }
}

