/*
 * Decompiled with CFR 0.152.
 */
package com.tydic.fsc.bill.ability.impl;

import cn.hutool.core.bean.BeanUtil;
import com.alibaba.fastjson.JSONObject;
import com.itextpdf.text.Chunk;
import com.itextpdf.text.Document;
import com.itextpdf.text.DocumentException;
import com.itextpdf.text.Element;
import com.itextpdf.text.Font;
import com.itextpdf.text.Paragraph;
import com.itextpdf.text.pdf.PdfPCell;
import com.itextpdf.text.pdf.PdfPTable;
import com.itextpdf.text.pdf.PdfWriter;
import com.tydic.agreement.ability.api.AgrQryAgreementSubjectDetailsAbilityService;
import com.tydic.agreement.ability.bo.AgrAgreementBO;
import com.tydic.agreement.ability.bo.AgrQryAgreementSubjectDetailsAbilityReqBO;
import com.tydic.agreement.ability.bo.AgrQryAgreementSubjectDetailsAbilityRspBO;
import com.tydic.authority.busi.api.DycStationSelectService;
import com.tydic.fsc.bill.ability.api.FscBillPurchaseListPrintAbilityService;
import com.tydic.fsc.bill.ability.bo.FscPurchaseListPrintReqBO;
import com.tydic.fsc.bill.ability.bo.FscPurchaseListPrintRspBO;
import com.tydic.fsc.bill.ability.impl.FscBillListPrintServiceImpl;
import com.tydic.fsc.bo.FscApprovalprocessListBO;
import com.tydic.fsc.bo.FscOrderItemDetailBO;
import com.tydic.fsc.common.ability.api.FscComApprovalprocessListQryAbilityService;
import com.tydic.fsc.common.ability.api.FscComOrderDetailQueryAbilityService;
import com.tydic.fsc.common.ability.api.FscOrderItemDetailQueryAbilityService;
import com.tydic.fsc.common.ability.bo.FscComApprovalprocessListQryAbilityReqBO;
import com.tydic.fsc.common.ability.bo.FscComApprovalprocessListQryAbilityRspBO;
import com.tydic.fsc.common.ability.bo.FscComOrderDetailQueryAbilityReqBO;
import com.tydic.fsc.common.ability.bo.FscComOrderDetailQueryAbilityRspBO;
import com.tydic.fsc.common.ability.bo.FscOrderItemDetailQueryAbilityReqBO;
import com.tydic.fsc.common.ability.bo.FscOrderItemDetailQueryAbilityRspBO;
import com.tydic.fsc.constants.FscConstants;
import com.tydic.fsc.dao.FscDicDictionaryMapper;
import com.tydic.fsc.dao.FscInvoiceMapper;
import com.tydic.fsc.dao.FscOrderMapper;
import com.tydic.fsc.dao.FscOrderRelationMapper;
import com.tydic.fsc.dao.FscPushLogMapper;
import com.tydic.fsc.dao.FscShouldPayMapper;
import com.tydic.fsc.enums.FscOrderTypeEnum;
import com.tydic.fsc.exception.FscBusinessException;
import com.tydic.fsc.po.FscDicDictionaryPO;
import com.tydic.fsc.po.FscInvoicePO;
import com.tydic.fsc.po.FscOrderPO;
import com.tydic.fsc.po.FscOrderRelationPO;
import com.tydic.fsc.po.FscPaymentWriteOffPO;
import com.tydic.fsc.po.FscPushLogPO;
import com.tydic.fsc.po.FscShouldPayPO;
import com.tydic.fsc.util.AmountUtils;
import com.tydic.fsc.util.CheckUtils;
import com.tydic.fsc.util.FscStringUtils;
import com.tydic.fsc.util.PdfUtils;
import com.tydic.uoc.common.ability.api.PebExtMainOrderDetailQueryAbilityService;
import com.tydic.uoc.common.ability.api.UocMainOrderDetailQueryAbilityService;
import com.tydic.uoc.common.ability.api.UocSalesSingleDetailsListQueryAbilityService;
import com.tydic.uoc.common.ability.bo.UocMainOrderDetailQueryReqBO;
import com.tydic.uoc.common.ability.bo.UocMainOrderDetailQueryRspBO;
import com.tydic.uoc.common.ability.bo.UocPebChildOrderAbilityBO;
import com.tydic.uoc.common.ability.bo.UocPebUpperOrderAbilityBO;
import com.tydic.uoc.common.ability.bo.UocSalesSingleDetailsListQueryReqBO;
import com.tydic.uoc.common.ability.bo.UocSalesSingleDetailsListQueryRspBO;
import java.io.ByteArrayOutputStream;
import java.io.OutputStream;
import java.math.BigDecimal;
import java.math.RoundingMode;
import java.util.ArrayList;
import java.util.Collection;
import java.util.Collections;
import java.util.HashMap;
import java.util.List;
import java.util.Map;
import java.util.Objects;
import java.util.stream.Collectors;
import java.util.stream.Stream;
import org.apache.commons.lang3.StringUtils;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;
import org.springframework.beans.factory.annotation.Autowired;
import org.springframework.beans.factory.annotation.Value;
import org.springframework.util.CollectionUtils;
import org.springframework.web.bind.annotation.PostMapping;
import org.springframework.web.bind.annotation.RequestBody;
import org.springframework.web.bind.annotation.RequestMapping;
import org.springframework.web.bind.annotation.RestController;

@RestController
@RequestMapping(value={"FSC_GROUP_DEV/1.0.0/com.tydic.fsc.bill.ability.api.FscBillPurchaseListPrintAbilityService"})
public class FscBillPurchaseListPrintAbilityServiceImpl
implements FscBillPurchaseListPrintAbilityService {
    private static final Logger log = LoggerFactory.getLogger(FscBillPurchaseListPrintAbilityServiceImpl.class);
    private FscComOrderDetailQueryAbilityService fscComOrderDetailQueryAbilityService;
    private FscBillListPrintServiceImpl fscBillListPrintServiceImpl;
    private FscComApprovalprocessListQryAbilityService fscComApprovalprocessListQryAbilityService;
    private DycStationSelectService dycStationSelectService;
    private PebExtMainOrderDetailQueryAbilityService pebExtMainOrderDetailQueryAbilityService;
    private FscOrderItemDetailQueryAbilityService fscOrderItemDetailQueryAbilityService;
    private FscOrderRelationMapper fscOrderRelationMapper;
    private FscShouldPayMapper fscShouldPayMapper;
    private FscInvoiceMapper fscInvoiceMapper;
    @Autowired
    private FscDicDictionaryMapper fscDicDictionaryMapper;
    @Autowired
    private FscOrderMapper fscOrderMapper;
    @Autowired
    private AgrQryAgreementSubjectDetailsAbilityService agrQryAgreementSubjectDetailsAbilityService;
    @Autowired
    private UocMainOrderDetailQueryAbilityService uocMainOrderDetailQueryAbilityService;
    @Autowired
    private UocSalesSingleDetailsListQueryAbilityService uocSalesSingleDetailsListQueryAbilityService;
    @Autowired
    private FscPushLogMapper fscPushLogMapper;
    @Value(value="${OPERATION_ORG_ID:1000000074}")
    private Long operationOrgId;
    @Value(value="${saleOrderTabId:30001}")
    private Integer TAB_ID;

    @PostMapping(value={"billPurchaseListPrintAbilityService"})
    public FscPurchaseListPrintRspBO billPurchaseListPrintAbilityService(@RequestBody FscPurchaseListPrintReqBO reqBO) {
        if (CheckUtils.isBlank((Object)reqBO.getOrderId())) {
            throw new FscBusinessException("191000", "\u5bfc\u51faPDF\u5931\u8d25\uff0c\u7ed3\u7b97\u5355ID\u4e3a\u7a7a");
        }
        FscOrderPO fscOrderPo = new FscOrderPO();
        fscOrderPo.setFscOrderId(reqBO.getOrderId());
        fscOrderPo = this.fscOrderMapper.getModelBy(fscOrderPo);
        Document document = PdfUtils.newDefaultDocument();
        ByteArrayOutputStream byteArrayOutputStream = new ByteArrayOutputStream();
        try {
            PdfWriter.getInstance((Document)document, (OutputStream)byteArrayOutputStream);
        }
        catch (DocumentException e) {
            e.printStackTrace();
        }
        document.open();
        this.addPdfTable(document, reqBO);
        document.close();
        if (reqBO.getMergerFlag().booleanValue()) {
            FscPurchaseListPrintRspBO rspBO = new FscPurchaseListPrintRspBO();
            rspBO.setByteArrayOutputStream(byteArrayOutputStream);
            return rspBO;
        }
        String url = this.fscBillListPrintServiceImpl.uploadFile("\u91c7\u8d2d\u7ed3\u7b97\u5355", byteArrayOutputStream);
        return new FscPurchaseListPrintRspBO(url, fscOrderPo.getOrderNo(), null);
    }

    private void addPdfTable(Document document, FscPurchaseListPrintReqBO reqBO) {
        ArrayList<PdfPTable> list = new ArrayList<PdfPTable>();
        FscComOrderDetailQueryAbilityReqBO orderDetailBo = new FscComOrderDetailQueryAbilityReqBO();
        orderDetailBo.setOrderId(reqBO.getOrderId());
        FscComOrderDetailQueryAbilityRspBO orderDetail = this.fscComOrderDetailQueryAbilityService.qryOrderDetail(orderDetailBo);
        if (!"0000".equals(orderDetail.getRespCode())) {
            throw new FscBusinessException("193005", orderDetail.getRespDesc());
        }
        FscOrderItemDetailQueryAbilityReqBO orderItemDetailBO = new FscOrderItemDetailQueryAbilityReqBO();
        orderItemDetailBO.setFscOrderIdList(Stream.of(reqBO.getOrderId()).collect(Collectors.toList()));
        FscOrderItemDetailQueryAbilityRspBO orderItem = this.fscOrderItemDetailQueryAbilityService.queryOrderItemDetail(orderItemDetailBO);
        List acceptOrderIdList = orderItem.getFscOrderItemDetailBOS().stream().map(FscOrderItemDetailBO::getAcceptOrderId).distinct().collect(Collectors.toList());
        FscShouldPayPO fscShouldPayPo = new FscShouldPayPO();
        fscShouldPayPo.setAcceptOrderIds(acceptOrderIdList);
        fscShouldPayPo.setPayeeIdNot(this.operationOrgId);
        fscShouldPayPo.setShouldPayTypeNot(FscConstants.ShouldPayType.PAYMENT_ADVANCE_PAY);
        List shouldPayList = this.fscShouldPayMapper.getList(fscShouldPayPo);
        FscShouldPayPO fscShouldPay = new FscShouldPayPO();
        fscShouldPay.setObjectId(reqBO.getOrderId());
        List orderShouldPayList = this.fscShouldPayMapper.getList(fscShouldPay);
        FscOrderRelationPO fscOrderRelationPo = new FscOrderRelationPO();
        fscOrderRelationPo.setFscOrderId(reqBO.getOrderId());
        List orderRelationList = this.fscOrderRelationMapper.getList(fscOrderRelationPo);
        FscInvoicePO fscInvoicePo = new FscInvoicePO();
        fscInvoicePo.setFscOrderId(reqBO.getOrderId());
        List fscInvoiceList = this.fscInvoiceMapper.getList(fscInvoicePo);
        Boolean invoiceTypeFlag = false;
        if (!CollectionUtils.isEmpty((Collection)fscInvoiceList) && orderDetail.getReceiveType() == 2 && "1".equals(orderDetail.getOrderSource()) && 2 == orderDetail.getSettleType() && (orderDetail.getOrderType() == 4 || orderDetail.getOrderType() == 5)) {
            invoiceTypeFlag = "01".equals(((FscInvoicePO)fscInvoiceList.get(0)).getInvoiceType());
        }
        FscComApprovalprocessListQryAbilityReqBO fscComApprovalprocessListQryAbilityReqBO = (FscComApprovalprocessListQryAbilityReqBO)BeanUtil.copyProperties((Object)reqBO, FscComApprovalprocessListQryAbilityReqBO.class);
        fscComApprovalprocessListQryAbilityReqBO.setFscOrderId(reqBO.getOrderId());
        if (orderDetail.getReceiveType() == 1) {
            fscComApprovalprocessListQryAbilityReqBO.setObjType(Integer.valueOf(7));
        } else {
            fscComApprovalprocessListQryAbilityReqBO.setObjType(Integer.valueOf(6));
        }
        ArrayList<FscApprovalprocessListBO> approvalList = new ArrayList();
        FscComApprovalprocessListQryAbilityRspBO fscApprovalList = this.fscComApprovalprocessListQryAbilityService.getFscApprovalprocessListQry(fscComApprovalprocessListQryAbilityReqBO);
        if (!CollectionUtils.isEmpty((Collection)fscApprovalList.getRows())) {
            approvalList = fscApprovalList.getRows();
            this.dealStationInfo(approvalList);
        }
        this.addHeadTable(list, orderDetail);
        this.addMiddleTable(list, orderDetail, orderRelationList, orderItem, shouldPayList, orderShouldPayList, fscInvoiceList, invoiceTypeFlag);
        this.addFootTable(list, orderDetail, fscInvoiceList, shouldPayList, invoiceTypeFlag);
        this.addAuditTable(list, approvalList);
        PdfUtils.addTableListToDoc((Document)document, list);
    }

    private void addFootTable(List<PdfPTable> list, FscComOrderDetailQueryAbilityRspBO orderDetail, List<FscInvoicePO> fscInvoiceList, List<FscShouldPayPO> shouldPayList, Boolean invoiceTypeFlag) {
        PdfPTable pageTableAuditTitle = PdfUtils.newPdfTable();
        PdfUtils.addCellToTable((PdfPTable)pageTableAuditTitle, (Object)"\u7ed3\u7b97\u4fe1\u606f", (Font)PdfUtils.DEFAULT_SECOND_TITLE_FONT, (Integer)1, (Integer)5, (Float)Float.valueOf(35.0f), (Integer)24, null);
        list.add(pageTableAuditTitle);
        PdfPTable pageTable14 = PdfUtils.newPdfTable();
        PdfUtils.addCellToTable((PdfPTable)pageTable14, (Object)"\u5e8f\u53f7", (Font)PdfUtils.DEFAULT_SECOND_TITLE_FONT, (Integer)1, (Integer)5, (Float)Float.valueOf(30.0f), (Integer)2, null);
        PdfUtils.addCellToTable((PdfPTable)pageTable14, (Object)"\u8d39\u7528\u7c7b\u578b", (Font)PdfUtils.DEFAULT_SECOND_TITLE_FONT, (Integer)1, (Integer)5, (Float)Float.valueOf(30.0f), (Integer)3, null);
        PdfUtils.addCellToTable((PdfPTable)pageTable14, (Object)"\u5f00\u7968\u7f16\u53f7", (Font)PdfUtils.DEFAULT_SECOND_TITLE_FONT, (Integer)1, (Integer)5, (Float)Float.valueOf(30.0f), (Integer)3, null);
        PdfUtils.addCellToTable((PdfPTable)pageTable14, (Object)"\u5f00\u7968\u65e5\u671f", (Font)PdfUtils.DEFAULT_SECOND_TITLE_FONT, (Integer)1, (Integer)5, (Float)Float.valueOf(30.0f), (Integer)4, null);
        PdfUtils.addCellToTable((PdfPTable)pageTable14, (Object)"\u4e0d\u542b\u7a0e\u91d1\u989d", (Font)PdfUtils.DEFAULT_SECOND_TITLE_FONT, (Integer)1, (Integer)5, (Float)Float.valueOf(30.0f), (Integer)4, null);
        PdfUtils.addCellToTable((PdfPTable)pageTable14, (Object)"\u7a0e\u989d", (Font)PdfUtils.DEFAULT_SECOND_TITLE_FONT, (Integer)1, (Integer)5, (Float)Float.valueOf(30.0f), (Integer)4, null);
        PdfUtils.addCellToTable((PdfPTable)pageTable14, (Object)"\u542b\u7a0e\u91d1\u989d", (Font)PdfUtils.DEFAULT_SECOND_TITLE_FONT, (Integer)1, (Integer)5, (Float)Float.valueOf(30.0f), (Integer)4, null);
        list.add(pageTable14);
        if (fscInvoiceList.isEmpty()) {
            PdfPTable pageTable15 = PdfUtils.newPdfTable();
            PdfUtils.addCellToTable((PdfPTable)pageTable15, (Object)"1", (Font)PdfUtils.DEFAULT_CONTENT_FONT, (Integer)1, (Integer)5, (Float)Float.valueOf(30.0f), (Integer)2, null);
            PdfUtils.addCellToTable((PdfPTable)pageTable15, (Object)"", (Font)PdfUtils.DEFAULT_CONTENT_FONT, (Integer)1, (Integer)5, (Float)Float.valueOf(30.0f), (Integer)3, null);
            PdfUtils.addCellToTable((PdfPTable)pageTable15, (Object)"", (Font)PdfUtils.DEFAULT_CONTENT_FONT, (Integer)1, (Integer)5, (Float)Float.valueOf(30.0f), (Integer)3, null);
            PdfUtils.addCellToTable((PdfPTable)pageTable15, (Object)"", (Font)PdfUtils.DEFAULT_CONTENT_FONT, (Integer)1, (Integer)5, (Float)Float.valueOf(30.0f), (Integer)4, null);
            PdfUtils.addCellToTable((PdfPTable)pageTable15, (Object)" ", (Font)PdfUtils.DEFAULT_CONTENT_FONT, (Integer)1, (Integer)5, (Float)Float.valueOf(30.0f), (Integer)4, null);
            PdfUtils.addCellToTable((PdfPTable)pageTable15, (Object)" ", (Font)PdfUtils.DEFAULT_CONTENT_FONT, (Integer)1, (Integer)5, (Float)Float.valueOf(30.0f), (Integer)4, null);
            PdfUtils.addCellToTable((PdfPTable)pageTable15, (Object)" ", (Font)PdfUtils.DEFAULT_CONTENT_FONT, (Integer)1, (Integer)5, (Float)Float.valueOf(30.0f), (Integer)4, null);
            list.add(pageTable15);
        } else {
            for (int i = 0; i < fscInvoiceList.size(); ++i) {
                PdfPTable pageTable15 = PdfUtils.newPdfTable();
                PdfUtils.addCellToTable((PdfPTable)pageTable15, (Object)(i + 1), (Font)PdfUtils.DEFAULT_CONTENT_FONT, (Integer)1, (Integer)5, (Float)Float.valueOf(30.0f), (Integer)2, null);
                PdfUtils.addCellToTable((PdfPTable)pageTable15, (Object)"\u9879\u76ee-\u8d37\u6b3e", (Font)PdfUtils.DEFAULT_CONTENT_FONT, (Integer)1, (Integer)5, (Float)Float.valueOf(30.0f), (Integer)3, null);
                PdfUtils.addCellToTable((PdfPTable)pageTable15, (Object)FscStringUtils.convertValueCopy((Object)fscInvoiceList.get(i).getInvoiceNo()), (Font)PdfUtils.DEFAULT_CONTENT_FONT, (Integer)1, (Integer)5, (Float)Float.valueOf(30.0f), (Integer)3, null);
                PdfUtils.addCellToTable((PdfPTable)pageTable15, (Object)FscStringUtils.convertValueCopy((Object)fscInvoiceList.get(i).getBillDate()), (Font)PdfUtils.DEFAULT_CONTENT_FONT, (Integer)1, (Integer)5, (Float)Float.valueOf(30.0f), (Integer)4, null);
                PdfUtils.addCellToTable((PdfPTable)pageTable15, (Object)AmountUtils.formatWithThousandSeparator((BigDecimal)(invoiceTypeFlag != false ? fscInvoiceList.get(i).getAmt().setScale(2, 4) : fscInvoiceList.get(i).getUntaxAmt().setScale(2, 4))), (Font)PdfUtils.DEFAULT_CONTENT_FONT, (Integer)1, (Integer)5, (Float)Float.valueOf(30.0f), (Integer)4, null);
                PdfUtils.addCellToTable((PdfPTable)pageTable15, (Object)AmountUtils.formatWithThousandSeparator((BigDecimal)(invoiceTypeFlag != false ? BigDecimal.ZERO : fscInvoiceList.get(i).getTaxAmt().setScale(2, 4))), (Font)PdfUtils.DEFAULT_CONTENT_FONT, (Integer)1, (Integer)5, (Float)Float.valueOf(30.0f), (Integer)4, null);
                PdfUtils.addCellToTable((PdfPTable)pageTable15, (Object)AmountUtils.formatWithThousandSeparator((BigDecimal)fscInvoiceList.get(i).getAmt().setScale(2, 4)), (Font)PdfUtils.DEFAULT_CONTENT_FONT, (Integer)1, (Integer)5, (Float)Float.valueOf(30.0f), (Integer)4, null);
                list.add(pageTable15);
            }
        }
        PdfPTable pageTable16 = PdfUtils.newPdfTable();
        PdfUtils.addCellToTable((PdfPTable)pageTable16, (Object)"\u5408\u8ba1", (Font)PdfUtils.DEFAULT_SECOND_TITLE_FONT, (Integer)1, (Integer)5, (Float)Float.valueOf(30.0f), (Integer)12, null);
        BigDecimal reduce = fscInvoiceList.stream().map(FscInvoicePO::getUntaxAmt).map(e -> e.setScale(2, 4)).reduce(BigDecimal.ZERO, BigDecimal::add);
        BigDecimal reduce2 = fscInvoiceList.stream().map(FscInvoicePO::getAmt).map(e -> e.setScale(2, 4)).reduce(BigDecimal.ZERO, BigDecimal::add);
        PdfUtils.addCellToTable((PdfPTable)pageTable16, (Object)AmountUtils.formatWithThousandSeparator((BigDecimal)(invoiceTypeFlag != false ? reduce2 : reduce)), (Font)PdfUtils.DEFAULT_CONTENT_FONT, (Integer)1, (Integer)5, (Float)Float.valueOf(30.0f), (Integer)4, null);
        BigDecimal reduce1 = fscInvoiceList.stream().map(FscInvoicePO::getTaxAmt).map(e -> e.setScale(2, 4)).reduce(BigDecimal.ZERO, BigDecimal::add);
        PdfUtils.addCellToTable((PdfPTable)pageTable16, (Object)AmountUtils.formatWithThousandSeparator((BigDecimal)(invoiceTypeFlag != false ? BigDecimal.ZERO : reduce1)), (Font)PdfUtils.DEFAULT_CONTENT_FONT, (Integer)1, (Integer)5, (Float)Float.valueOf(30.0f), (Integer)4, null);
        PdfUtils.addCellToTable((PdfPTable)pageTable16, (Object)AmountUtils.formatWithThousandSeparator((BigDecimal)reduce2), (Font)PdfUtils.DEFAULT_CONTENT_FONT, (Integer)1, (Integer)5, (Float)Float.valueOf(30.0f), (Integer)4, null);
        list.add(pageTable16);
        List paymentWriteOffList = this.fscOrderMapper.getPaymentSumWriteOffList(orderDetail.getFscOrderId());
        if (!CollectionUtils.isEmpty((Collection)paymentWriteOffList)) {
            PdfPTable pageTablewaiteTitle = PdfUtils.newPdfTable();
            PdfUtils.addCellToTable((PdfPTable)pageTablewaiteTitle, (Object)"\u6838\u9500\u4fe1\u606f", (Font)PdfUtils.DEFAULT_SECOND_TITLE_FONT, (Integer)1, (Integer)5, (Float)Float.valueOf(35.0f), (Integer)24, null);
            list.add(pageTablewaiteTitle);
            PdfPTable pageTable17 = PdfUtils.newPdfTable();
            PdfUtils.addCellToTable((PdfPTable)pageTable17, (Object)"\u5e8f\u53f7", (Font)PdfUtils.DEFAULT_SECOND_TITLE_FONT, (Integer)1, (Integer)5, (Float)Float.valueOf(30.0f), (Integer)2, null);
            PdfUtils.addCellToTable((PdfPTable)pageTable17, (Object)"\u9884\u4ed8\u6b3e\u7f16\u53f7", (Font)PdfUtils.DEFAULT_SECOND_TITLE_FONT, (Integer)1, (Integer)5, (Float)Float.valueOf(30.0f), (Integer)3, null);
            PdfUtils.addCellToTable((PdfPTable)pageTable17, (Object)"\u9884\u4ed8\u6b3e\u540d\u79f0", (Font)PdfUtils.DEFAULT_SECOND_TITLE_FONT, (Integer)1, (Integer)5, (Float)Float.valueOf(30.0f), (Integer)3, null);
            PdfUtils.addCellToTable((PdfPTable)pageTable17, (Object)"\u9884\u4ed8\u6b3e\u91d1\u989d", (Font)PdfUtils.DEFAULT_SECOND_TITLE_FONT, (Integer)1, (Integer)5, (Float)Float.valueOf(30.0f), (Integer)4, null);
            PdfUtils.addCellToTable((PdfPTable)pageTable17, (Object)"\u5df2\u6838\u9500\u91d1\u989d", (Font)PdfUtils.DEFAULT_SECOND_TITLE_FONT, (Integer)1, (Integer)5, (Float)Float.valueOf(30.0f), (Integer)4, null);
            PdfUtils.addCellToTable((PdfPTable)pageTable17, (Object)"\u672a\u6838\u9500\u91d1\u989d", (Font)PdfUtils.DEFAULT_SECOND_TITLE_FONT, (Integer)1, (Integer)5, (Float)Float.valueOf(30.0f), (Integer)4, null);
            PdfUtils.addCellToTable((PdfPTable)pageTable17, (Object)"\u672c\u6b21\u6838\u9500\u91d1\u989d", (Font)PdfUtils.DEFAULT_SECOND_TITLE_FONT, (Integer)1, (Integer)5, (Float)Float.valueOf(30.0f), (Integer)4, null);
            list.add(pageTable17);
            for (int i = 0; i < paymentWriteOffList.size(); ++i) {
                PdfPTable pageTable18 = PdfUtils.newPdfTable();
                PdfUtils.addCellToTable((PdfPTable)pageTable18, (Object)(i + 1), (Font)PdfUtils.DEFAULT_CONTENT_FONT, (Integer)1, (Integer)5, (Float)Float.valueOf(30.0f), (Integer)2, null);
                PdfUtils.addCellToTable((PdfPTable)pageTable18, (Object)FscStringUtils.convertValueCopy((Object)((FscPaymentWriteOffPO)paymentWriteOffList.get(i)).getFscOrderNo()), (Font)PdfUtils.DEFAULT_CONTENT_FONT, (Integer)1, (Integer)5, (Float)Float.valueOf(30.0f), (Integer)3, null);
                PdfUtils.addCellToTable((PdfPTable)pageTable18, (Object)FscStringUtils.convertValueCopy((Object)((FscPaymentWriteOffPO)paymentWriteOffList.get(i)).getFscOrderName()), (Font)PdfUtils.DEFAULT_CONTENT_FONT, (Integer)1, (Integer)5, (Float)Float.valueOf(30.0f), (Integer)3, null);
                PdfUtils.addCellToTable((PdfPTable)pageTable18, (Object)AmountUtils.formatWithThousandSeparator((BigDecimal)((FscPaymentWriteOffPO)paymentWriteOffList.get(i)).getOrderPaidAmount().setScale(2, 4)), (Font)PdfUtils.DEFAULT_CONTENT_FONT, (Integer)1, (Integer)5, (Float)Float.valueOf(30.0f), (Integer)4, null);
                PdfUtils.addCellToTable((PdfPTable)pageTable18, (Object)AmountUtils.formatWithThousandSeparator((BigDecimal)((FscPaymentWriteOffPO)paymentWriteOffList.get(i)).getWriteOffAmount().setScale(2, 4)), (Font)PdfUtils.DEFAULT_CONTENT_FONT, (Integer)1, (Integer)5, (Float)Float.valueOf(30.0f), (Integer)4, null);
                PdfUtils.addCellToTable((PdfPTable)pageTable18, (Object)AmountUtils.formatWithThousandSeparator((BigDecimal)((FscPaymentWriteOffPO)paymentWriteOffList.get(i)).getSurplusWriteOffAmount().setScale(2, 4)), (Font)PdfUtils.DEFAULT_CONTENT_FONT, (Integer)1, (Integer)5, (Float)Float.valueOf(30.0f), (Integer)4, null);
                PdfUtils.addCellToTable((PdfPTable)pageTable18, (Object)AmountUtils.formatWithThousandSeparator((BigDecimal)((FscPaymentWriteOffPO)paymentWriteOffList.get(i)).getWriteOffAmount().setScale(2, 4)), (Font)PdfUtils.DEFAULT_CONTENT_FONT, (Integer)1, (Integer)5, (Float)Float.valueOf(30.0f), (Integer)4, null);
                list.add(pageTable18);
            }
            PdfPTable pageTable19 = PdfUtils.newPdfTable();
            PdfUtils.addCellToTable((PdfPTable)pageTable19, (Object)"\u5408\u8ba1", (Font)PdfUtils.DEFAULT_SECOND_TITLE_FONT, (Integer)1, (Integer)5, (Float)Float.valueOf(30.0f), (Integer)4, null);
            PdfUtils.addCellToTable((PdfPTable)pageTable19, (Object)"", (Font)PdfUtils.DEFAULT_CONTENT_FONT, (Integer)1, (Integer)5, (Float)Float.valueOf(30.0f), (Integer)16, null);
            PdfUtils.addCellToTable((PdfPTable)pageTable19, (Object)AmountUtils.formatWithThousandSeparator((BigDecimal)paymentWriteOffList.stream().map(FscPaymentWriteOffPO::getWriteOffAmount).map(e -> e.setScale(2, 4)).reduce(BigDecimal.ZERO, BigDecimal::add)), (Font)PdfUtils.DEFAULT_CONTENT_FONT, (Integer)1, (Integer)5, (Float)Float.valueOf(30.0f), (Integer)4, null);
            list.add(pageTable19);
        }
    }

    private void addMiddleTable(List<PdfPTable> list, FscComOrderDetailQueryAbilityRspBO orderDetail, List<FscOrderRelationPO> orderRelationList, FscOrderItemDetailQueryAbilityRspBO orderItem, List<FscShouldPayPO> shouldPayList, List<FscShouldPayPO> orderShouldPayList, List<FscInvoicePO> fscInvoiceList, Boolean invoiceTypeFlag) {
        PdfPTable pageTable4 = PdfUtils.newPdfTable();
        PdfUtils.addCellToTable((PdfPTable)pageTable4, (Object)"\u91c7\u8d2d\u7ed3\u7b97\u7f16\u7801", (Font)PdfUtils.DEFAULT_SECOND_TITLE_FONT, (Integer)1, (Integer)5, (Float)Float.valueOf(30.0f), (Integer)4, null);
        PdfUtils.addCellToTable((PdfPTable)pageTable4, (Object)FscStringUtils.convertValueCopy((Object)orderDetail.getOrderNo()), (Font)PdfUtils.DEFAULT_CONTENT_FONT, (Integer)1, (Integer)5, (Float)Float.valueOf(30.0f), (Integer)4, null);
        PdfUtils.addCellToTable((PdfPTable)pageTable4, (Object)"\u4f9b\u5e94\u5546\u540d\u79f0", (Font)PdfUtils.DEFAULT_SECOND_TITLE_FONT, (Integer)1, (Integer)5, (Float)Float.valueOf(30.0f), (Integer)4, null);
        PdfUtils.addCellToTable((PdfPTable)pageTable4, (Object)FscStringUtils.convertValueCopy((Object)orderDetail.getSupplierName()), (Font)PdfUtils.DEFAULT_CONTENT_FONT, (Integer)1, (Integer)5, (Float)Float.valueOf(30.0f), (Integer)4, null);
        PdfUtils.addCellToTable((PdfPTable)pageTable4, (Object)"\u4e1a\u52a1\u7c7b\u578b", (Font)PdfUtils.DEFAULT_SECOND_TITLE_FONT, (Integer)1, (Integer)5, (Float)Float.valueOf(30.0f), (Integer)4, null);
        String fscTypeStr = "-";
        if (orderDetail.getOrderType() != null) {
            Map<String, Map<String, String>> dicMap = this.getDicMap();
            fscTypeStr = dicMap.get("FSC_TYPE").get(orderDetail.getOrderType().toString());
        }
        PdfUtils.addCellToTable((PdfPTable)pageTable4, (Object)fscTypeStr, (Font)PdfUtils.DEFAULT_CONTENT_FONT, (Integer)1, (Integer)5, (Float)Float.valueOf(30.0f), (Integer)4, null);
        list.add(pageTable4);
        UocSalesSingleDetailsListQueryReqBO saleDetailsReqBO = new UocSalesSingleDetailsListQueryReqBO();
        saleDetailsReqBO.setPageSize(1000);
        saleDetailsReqBO.setOrderIdList(Collections.singletonList(orderRelationList.get(0).getOrderId()));
        saleDetailsReqBO.setTabId(this.TAB_ID);
        saleDetailsReqBO.setIndividually("1");
        log.debug("\u7ed3\u7b97\u5173\u8054\u8ba2\u5355\u660e\u7ec6\u5217\u8868\u67e5\u8be2\u9500\u552e\u5355\u5165\u53c2\uff1a{}", (Object)JSONObject.toJSONString((Object)saleDetailsReqBO));
        UocSalesSingleDetailsListQueryRspBO saleDetailsRspBO = this.uocSalesSingleDetailsListQueryAbilityService.getUocSalesSingleDetailsListQuery(saleDetailsReqBO);
        if (!"0000".equals(saleDetailsRspBO.getRespCode())) {
            log.error("\u67e5\u8be2\u8ba2\u5355\u4fe1\u606f\u5931\u8d25:" + saleDetailsRspBO.getRespDesc());
        }
        UocMainOrderDetailQueryReqBO uocMainOrderDetailQueryReqBO = new UocMainOrderDetailQueryReqBO();
        uocMainOrderDetailQueryReqBO.setOrderId(orderRelationList.get(0).getOrderId());
        uocMainOrderDetailQueryReqBO.setQueryLevelList(Collections.singletonList(3));
        log.debug("\u7ed3\u7b97\u5173\u8054\u8ba2\u5355\u660e\u7ec6\u5217\u8868\u67e5\u8be2\u9500\u552e\u5355\u5165\u53c2\uff1a{}", (Object)JSONObject.toJSONString((Object)uocMainOrderDetailQueryReqBO));
        UocMainOrderDetailQueryRspBO uocMainOrderDetailQuery = this.uocMainOrderDetailQueryAbilityService.getUocMainOrderDetailQuery(uocMainOrderDetailQueryReqBO);
        if (!"0000".equals(uocMainOrderDetailQuery.getRespCode())) {
            log.error("\u67e5\u8be2\u8ba2\u5355\u4fe1\u606f\u5931\u8d25:" + uocMainOrderDetailQuery.getRespDesc());
        }
        String catt = "-";
        if (uocMainOrderDetailQuery.getOrdAgreementRspBO() != null && StringUtils.isNotBlank((CharSequence)uocMainOrderDetailQuery.getOrdAgreementRspBO().getAgreementId())) {
            AgrAgreementBO agrAgreementBO;
            AgrQryAgreementSubjectDetailsAbilityReqBO agrQryAgreementSubjectDetailsAbilityReqBO = new AgrQryAgreementSubjectDetailsAbilityReqBO();
            agrQryAgreementSubjectDetailsAbilityReqBO.setAgreementId(Long.valueOf(uocMainOrderDetailQuery.getOrdAgreementRspBO().getAgreementId()));
            agrQryAgreementSubjectDetailsAbilityReqBO.setTranslateFlag(Boolean.valueOf(false));
            agrQryAgreementSubjectDetailsAbilityReqBO.setQueryAttachmentFlag(Boolean.valueOf(false));
            agrQryAgreementSubjectDetailsAbilityReqBO.setQueryScopeFlag(Boolean.valueOf(false));
            AgrQryAgreementSubjectDetailsAbilityRspBO agrQryAgreementSubjectDetailsAbilityRspBO = this.agrQryAgreementSubjectDetailsAbilityService.qryAgreementSubjectDetails(agrQryAgreementSubjectDetailsAbilityReqBO);
            if (agrQryAgreementSubjectDetailsAbilityRspBO != null && agrQryAgreementSubjectDetailsAbilityRspBO.getAgrAgreementBO() != null && StringUtils.isNotBlank((CharSequence)(agrAgreementBO = agrQryAgreementSubjectDetailsAbilityRspBO.getAgrAgreementBO()).getCategory())) {
                catt = agrAgreementBO.getCategory();
            }
        }
        PdfPTable pageTable5 = PdfUtils.newPdfTable();
        PdfUtils.addCellToTable((PdfPTable)pageTable5, (Object)"\u8ba2\u5355\u7f16\u53f7", (Font)PdfUtils.DEFAULT_SECOND_TITLE_FONT, (Integer)1, (Integer)5, (Float)Float.valueOf(30.0f), (Integer)4, null);
        PdfUtils.addCellToTable((PdfPTable)pageTable5, (Object)orderRelationList.stream().map(FscOrderRelationPO::getOrderNo).collect(Collectors.joining(",")), (Font)PdfUtils.DEFAULT_CONTENT_FONT, (Integer)1, (Integer)5, (Float)Float.valueOf(30.0f), (Integer)12, null);
        PdfUtils.addCellToTable((PdfPTable)pageTable5, (Object)"\u54c1\u7c7b", (Font)PdfUtils.DEFAULT_SECOND_TITLE_FONT, (Integer)1, (Integer)5, (Float)Float.valueOf(30.0f), (Integer)4, null);
        PdfUtils.addCellToTable((PdfPTable)pageTable5, (Object)catt, (Font)PdfUtils.DEFAULT_CONTENT_FONT, (Integer)1, (Integer)5, (Float)Float.valueOf(30.0f), (Integer)4, null);
        list.add(pageTable5);
        PdfPTable pageTable6 = PdfUtils.newPdfTable();
        String proModelContractNoTemp = ((UocPebChildOrderAbilityBO)((UocPebUpperOrderAbilityBO)saleDetailsRspBO.getRows().get(0)).getChildOrderList().get(0)).getProModelContractNo();
        String proModelContractNo = proModelContractNoTemp == null ? "-" : proModelContractNoTemp;
        String proModelContractNameTemp = ((UocPebChildOrderAbilityBO)((UocPebUpperOrderAbilityBO)saleDetailsRspBO.getRows().get(0)).getChildOrderList().get(0)).getProModelContractName();
        String proModelContractName = proModelContractNameTemp == null ? "-" : proModelContractNameTemp;
        PdfUtils.addCellToTable((PdfPTable)pageTable6, (Object)"\u91c7\u8d2d\u5408\u540c\u7f16\u53f7", (Font)PdfUtils.DEFAULT_SECOND_TITLE_FONT, (Integer)1, (Integer)5, (Float)Float.valueOf(30.0f), (Integer)4, null);
        PdfUtils.addCellToTable((PdfPTable)pageTable6, (Object)proModelContractNo, (Font)PdfUtils.DEFAULT_CONTENT_FONT, (Integer)1, (Integer)5, (Float)Float.valueOf(30.0f), (Integer)4, null);
        PdfUtils.addCellToTable((PdfPTable)pageTable6, (Object)"\u91c7\u8d2d\u5408\u540c\u540d\u79f0", (Font)PdfUtils.DEFAULT_SECOND_TITLE_FONT, (Integer)1, (Integer)5, (Float)Float.valueOf(30.0f), (Integer)4, null);
        PdfUtils.addCellToTable((PdfPTable)pageTable6, (Object)proModelContractName, (Font)PdfUtils.DEFAULT_CONTENT_FONT, (Integer)1, (Integer)5, (Float)Float.valueOf(30.0f), (Integer)4, null);
        PdfUtils.addCellToTable((PdfPTable)pageTable6, (Object)"\u9884\u4ed8\u6b3e\u91d1\u989d", (Font)PdfUtils.DEFAULT_SECOND_TITLE_FONT, (Integer)1, (Integer)5, (Float)Float.valueOf(30.0f), (Integer)4, null);
        List paymentWriteOffList = this.fscOrderMapper.getPaymentSumWriteOffList(orderDetail.getFscOrderId());
        PdfUtils.addCellToTable((PdfPTable)pageTable6, (Object)AmountUtils.formatWithThousandSeparator((BigDecimal)(CollectionUtils.isEmpty((Collection)paymentWriteOffList) ? BigDecimal.ZERO : paymentWriteOffList.stream().filter(Objects::nonNull).map(FscPaymentWriteOffPO::getOrderPaidAmount).reduce(BigDecimal.ZERO, BigDecimal::add).setScale(2, 4))), (Font)PdfUtils.DEFAULT_CONTENT_FONT, (Integer)1, (Integer)5, (Float)Float.valueOf(30.0f), (Integer)4, null);
        list.add(pageTable6);
        PdfPTable pageTable7 = PdfUtils.newPdfTable();
        PdfUtils.addCellToTable((PdfPTable)pageTable7, (Object)"\u5e01\u79cd", (Font)PdfUtils.DEFAULT_SECOND_TITLE_FONT, (Integer)1, (Integer)5, (Float)Float.valueOf(30.0f), (Integer)4, null);
        PdfUtils.addCellToTable((PdfPTable)pageTable7, (Object)"\u4eba\u6c11\u5e01", (Font)PdfUtils.DEFAULT_CONTENT_FONT, (Integer)1, (Integer)5, (Float)Float.valueOf(30.0f), (Integer)4, null);
        PdfUtils.addCellToTable((PdfPTable)pageTable7, (Object)"\u6c47\u7387", (Font)PdfUtils.DEFAULT_SECOND_TITLE_FONT, (Integer)1, (Integer)5, (Float)Float.valueOf(30.0f), (Integer)4, null);
        PdfUtils.addCellToTable((PdfPTable)pageTable7, (Object)"1", (Font)PdfUtils.DEFAULT_CONTENT_FONT, (Integer)1, (Integer)5, (Float)Float.valueOf(30.0f), (Integer)4, null);
        BigDecimal amt = new BigDecimal("0.00");
        BigDecimal taxAmt = new BigDecimal("0.00");
        if (!CollectionUtils.isEmpty(fscInvoiceList)) {
            taxAmt = fscInvoiceList.stream().map(FscInvoicePO::getTaxAmt).reduce(BigDecimal.ZERO, BigDecimal::add).setScale(2, RoundingMode.HALF_UP);
            amt = fscInvoiceList.stream().map(FscInvoicePO::getAmt).reduce(BigDecimal.ZERO, BigDecimal::add).setScale(2, RoundingMode.HALF_UP);
        }
        PdfUtils.addCellToTable((PdfPTable)pageTable7, (Object)"\u672c\u6b21\u53d1\u7968\u91d1\u989d(\u542b\u7a0e)", (Font)PdfUtils.DEFAULT_SECOND_TITLE_FONT, (Integer)1, (Integer)5, (Float)Float.valueOf(30.0f), (Integer)4, null);
        PdfUtils.addCellToTable((PdfPTable)pageTable7, (Object)AmountUtils.formatWithThousandSeparator((BigDecimal)amt), (Font)PdfUtils.DEFAULT_CONTENT_FONT, (Integer)1, (Integer)5, (Float)Float.valueOf(30.0f), (Integer)4, null);
        list.add(pageTable7);
        PdfPTable pageTable8 = PdfUtils.newPdfTable();
        PdfUtils.addCellToTable((PdfPTable)pageTable8, (Object)"\u672c\u6b21\u53d1\u7968\u91d1\u989d(\u4e0d\u542b\u7a0e)", (Font)PdfUtils.DEFAULT_SECOND_TITLE_FONT, (Integer)1, (Integer)5, (Float)Float.valueOf(30.0f), (Integer)4, null);
        PdfUtils.addCellToTable((PdfPTable)pageTable8, (Object)AmountUtils.formatWithThousandSeparator((BigDecimal)(invoiceTypeFlag != false ? amt : amt.subtract(taxAmt))), (Font)PdfUtils.DEFAULT_CONTENT_FONT, (Integer)1, (Integer)5, (Float)Float.valueOf(30.0f), (Integer)4, null);
        PdfUtils.addCellToTable((PdfPTable)pageTable8, (Object)"\u672c\u6b21\u53d1\u7968\u7a0e\u989d", (Font)PdfUtils.DEFAULT_SECOND_TITLE_FONT, (Integer)1, (Integer)5, (Float)Float.valueOf(30.0f), (Integer)4, null);
        PdfUtils.addCellToTable((PdfPTable)pageTable8, (Object)AmountUtils.formatWithThousandSeparator((BigDecimal)(invoiceTypeFlag != false ? BigDecimal.ZERO : taxAmt)), (Font)PdfUtils.DEFAULT_CONTENT_FONT, (Integer)1, (Integer)5, (Float)Float.valueOf(30.0f), (Integer)4, null);
        PdfUtils.addCellToTable((PdfPTable)pageTable8, (Object)"\u672c\u6b21\u6838\u9500\u9884\u4ed8\u6b3e\u91d1\u989d", (Font)PdfUtils.DEFAULT_SECOND_TITLE_FONT, (Integer)1, (Integer)5, (Float)Float.valueOf(30.0f), (Integer)4, null);
        PdfUtils.addCellToTable((PdfPTable)pageTable8, (Object)AmountUtils.formatWithThousandSeparator((BigDecimal)orderDetail.getWriteOffAmount()), (Font)PdfUtils.DEFAULT_CONTENT_FONT, (Integer)1, (Integer)5, (Float)Float.valueOf(30.0f), (Integer)4, null);
        list.add(pageTable8);
        PdfPTable pageTable10 = PdfUtils.newPdfTable();
        PdfUtils.addCellToTable((PdfPTable)pageTable10, (Object)"\u5355\u636e\u5907\u6ce8", (Font)PdfUtils.DEFAULT_SECOND_TITLE_FONT, (Integer)1, (Integer)5, (Float)Float.valueOf(30.0f), (Integer)4, null);
        PdfUtils.addCellToTable((PdfPTable)pageTable10, (Object)FscStringUtils.convertValueCopy((Object)orderDetail.getRemark()), (Font)PdfUtils.DEFAULT_CONTENT_FONT, (Integer)1, (Integer)5, (Float)Float.valueOf(30.0f), (Integer)20, null);
        list.add(pageTable10);
    }

    public void dealStationInfo(List<FscApprovalprocessListBO> approvalList) {
        approvalList.get(0).setStationName("\u53d1\u8d77\u5ba1\u6279");
        for (int i = 1; i < approvalList.size(); ++i) {
            if (StringUtils.isNotBlank((CharSequence)approvalList.get(i).getStepName())) {
                approvalList.get(i).setStationName(approvalList.get(i).getStepName());
                continue;
            }
            approvalList.get(i).setStationName("\u53d1\u8d77\u5ba1\u6279");
        }
    }

    private void addHeadTable(List<PdfPTable> tableList, FscComOrderDetailQueryAbilityRspBO orderDetail) {
        PdfPTable titleTable1 = PdfUtils.newPdfTable();
        PdfUtils.addCellToTable((PdfPTable)titleTable1, (Object)"\u4e2d\u56fd\u7164\u70ad\u5f00\u53d1\u6709\u9650\u8d23\u4efb\u516c\u53f8", (Font)PdfUtils.DEFAULT_TITLE_FONT, (Integer)1, (Integer)5, (Float)Float.valueOf(50.0f), (Integer)23, null);
        PdfUtils.addCellToTable((PdfPTable)titleTable1, (Object)("\u9644\u4ef6" + (orderDetail.getAttachmentList() == null ? 0 : orderDetail.getAttachmentList().size()) + "\u5f20"), (Font)PdfUtils.DEFAULT_SECOND_TITLE_FONT, (Integer)1, (Integer)5, (Float)Float.valueOf(30.0f), (Integer)1, null);
        tableList.add(titleTable1);
        tableList.add(this.dealColor(orderDetail));
        PdfPTable pageTable3 = PdfUtils.newPdfTable();
        PdfUtils.addCellToTable((PdfPTable)pageTable3, (Object)"\u7ecf\u529e\u90e8\u95e8", (Font)PdfUtils.DEFAULT_SECOND_TITLE_FONT, (Integer)1, (Integer)5, (Float)Float.valueOf(30.0f), (Integer)4, null);
        PdfUtils.addCellToTable((PdfPTable)pageTable3, (Object)(orderDetail.getOperationName() == null ? "-" : orderDetail.getOperationName()), (Font)PdfUtils.DEFAULT_CONTENT_FONT, (Integer)1, (Integer)5, (Float)Float.valueOf(30.0f), (Integer)8, null);
        PdfUtils.addCellToTable((PdfPTable)pageTable3, (Object)"\u7ecf\u529e\u4eba", (Font)PdfUtils.DEFAULT_SECOND_TITLE_FONT, (Integer)1, (Integer)5, (Float)Float.valueOf(30.0f), (Integer)4, null);
        PdfUtils.addCellToTable((PdfPTable)pageTable3, (Object)(orderDetail.getOperatorName() == null ? "-" : orderDetail.getOperatorName()), (Font)PdfUtils.DEFAULT_CONTENT_FONT, (Integer)1, (Integer)5, (Float)Float.valueOf(30.0f), (Integer)8, null);
        tableList.add(pageTable3);
    }

    public void addAuditTable(List<PdfPTable> tableList, List<FscApprovalprocessListBO> auditList) {
        PdfPTable pageTableAuditTitle = PdfUtils.newPdfTable();
        PdfUtils.addCellToTable((PdfPTable)pageTableAuditTitle, (Object)"\u7b7e\u5b57\u5ba1\u6279", (Font)PdfUtils.DEFAULT_SECOND_TITLE_FONT, (Integer)1, (Integer)5, (Float)Float.valueOf(35.0f), (Integer)24, null);
        tableList.add(pageTableAuditTitle);
        PdfPTable pageTableAudit = PdfUtils.newPdfTable();
        PdfUtils.addCellToTable((PdfPTable)pageTableAudit, (Object)"\u5e8f\u53f7", (Font)PdfUtils.DEFAULT_SECOND_TITLE_FONT, (Integer)1, (Integer)5, (Float)Float.valueOf(30.0f), (Integer)4, null);
        PdfUtils.addCellToTable((PdfPTable)pageTableAudit, (Object)"\u5ba1\u6279\u65f6\u95f4", (Font)PdfUtils.DEFAULT_SECOND_TITLE_FONT, (Integer)1, (Integer)5, (Float)Float.valueOf(30.0f), (Integer)4, null);
        PdfUtils.addCellToTable((PdfPTable)pageTableAudit, (Object)"\u5ba1\u6279\u8282\u70b9", (Font)PdfUtils.DEFAULT_SECOND_TITLE_FONT, (Integer)1, (Integer)5, (Float)Float.valueOf(30.0f), (Integer)4, null);
        PdfUtils.addCellToTable((PdfPTable)pageTableAudit, (Object)"\u5ba1\u6279\u4eba", (Font)PdfUtils.DEFAULT_SECOND_TITLE_FONT, (Integer)1, (Integer)5, (Float)Float.valueOf(30.0f), (Integer)4, null);
        PdfUtils.addCellToTable((PdfPTable)pageTableAudit, (Object)"\u5ba1\u6279\u72b6\u6001", (Font)PdfUtils.DEFAULT_SECOND_TITLE_FONT, (Integer)1, (Integer)5, (Float)Float.valueOf(30.0f), (Integer)4, null);
        PdfUtils.addCellToTable((PdfPTable)pageTableAudit, (Object)"\u5ba1\u6279\u610f\u89c1", (Font)PdfUtils.DEFAULT_SECOND_TITLE_FONT, (Integer)1, (Integer)5, (Float)Float.valueOf(30.0f), (Integer)4, null);
        tableList.add(pageTableAudit);
        if (!CollectionUtils.isEmpty(auditList)) {
            for (int i = 0; i < auditList.size(); ++i) {
                PdfPTable auditTable = PdfUtils.newPdfTable();
                PdfUtils.addCellToTable((PdfPTable)auditTable, (Object)String.valueOf(i + 1), (Font)PdfUtils.DEFAULT_CONTENT_FONT, (Integer)1, (Integer)5, (Float)Float.valueOf(30.0f), (Integer)4, null);
                PdfUtils.addCellToTable((PdfPTable)auditTable, (Object)FscStringUtils.convertValue((Object)auditList.get(i).getTime()), (Font)PdfUtils.DEFAULT_CONTENT_FONT, (Integer)1, (Integer)5, (Float)Float.valueOf(30.0f), (Integer)4, null);
                PdfUtils.addCellToTable((PdfPTable)auditTable, (Object)FscStringUtils.convertValue((Object)auditList.get(i).getStationName()), (Font)PdfUtils.DEFAULT_CONTENT_FONT, (Integer)1, (Integer)5, (Float)Float.valueOf(30.0f), (Integer)4, null);
                PdfUtils.addCellToTable((PdfPTable)auditTable, (Object)FscStringUtils.convertValue((Object)auditList.get(i).getOperName()), (Font)PdfUtils.DEFAULT_CONTENT_FONT, (Integer)1, (Integer)5, (Float)Float.valueOf(30.0f), (Integer)4, null);
                PdfUtils.addCellToTable((PdfPTable)auditTable, (Object)FscStringUtils.convertValue((Object)auditList.get(i).getAudit()), (Font)PdfUtils.DEFAULT_CONTENT_FONT, (Integer)1, (Integer)5, (Float)Float.valueOf(30.0f), (Integer)4, null);
                PdfUtils.addCellToTable((PdfPTable)auditTable, (Object)FscStringUtils.convertValue((Object)auditList.get(i).getAdvice()), (Font)PdfUtils.DEFAULT_CONTENT_FONT, (Integer)1, (Integer)5, (Float)Float.valueOf(30.0f), (Integer)4, null);
                tableList.add(auditTable);
            }
        }
    }

    private BigDecimal dealDecimal(BigDecimal bigDecimal1, BigDecimal bigDecimal2) {
        if (bigDecimal1 == null) {
            bigDecimal1 = BigDecimal.ZERO;
        }
        if (bigDecimal2 == null) {
            bigDecimal2 = BigDecimal.ZERO;
        }
        return bigDecimal1.subtract(bigDecimal2).setScale(2, 4);
    }

    private String dealOrderTypeEnum(Integer code) {
        FscOrderTypeEnum instance = FscOrderTypeEnum.getInstance((Integer)code);
        if (instance != null) {
            return instance.getCodeDesc();
        }
        return code.toString();
    }

    private Map<String, Map<String, String>> getDicMap() {
        HashMap<String, Map<String, String>> dicMap = new HashMap<String, Map<String, String>>(16);
        ArrayList<String> dicPCodes = new ArrayList<String>();
        dicPCodes.add("FSC_TYPE");
        FscDicDictionaryPO queryPo = new FscDicDictionaryPO();
        queryPo.setSysCode("FSC");
        for (String pCode : dicPCodes) {
            queryPo.setPCode(pCode);
            List dicDictionaryPos = this.fscDicDictionaryMapper.getListByCondition(queryPo);
            Map<String, String> map = dicDictionaryPos.stream().collect(Collectors.toMap(FscDicDictionaryPO::getCode, fscDicDictionaryPO -> fscDicDictionaryPO.getTitle()));
            dicMap.put(pCode, map);
        }
        return dicMap;
    }

    private PdfPTable dealColor(FscComOrderDetailQueryAbilityRspBO abilityRspBO) {
        PdfPTable pageTable2 = PdfUtils.newPdfTable();
        Integer pushResult = 0;
        FscPushLogPO pushLogPO = new FscPushLogPO();
        pushLogPO.setObjectId(abilityRspBO.getFscOrderId());
        pushLogPO.setType(Integer.valueOf(2));
        pushLogPO.setStatus(Integer.valueOf(1));
        FscPushLogPO lastPushLog = this.fscPushLogMapper.getLastPushLog(pushLogPO);
        if (lastPushLog != null && lastPushLog.getStatus() != null) {
            pushResult = lastPushLog.getStatus();
        }
        if (pushResult == 1) {
            PdfUtils.addCellToTable((PdfPTable)pageTable2, (Object)"\u91c7\u8d2d\u7ed3\u7b97\u5355", (Font)PdfUtils.DEFAULT_TITLE_FONT, (Integer)1, (Integer)5, (Float)Float.valueOf(40.0f), (Integer)24, null);
        } else {
            PdfPCell cell1 = new PdfPCell();
            Paragraph paragraph = new Paragraph();
            paragraph.add((Element)new Chunk("\u91c7\u8d2d\u7ed3\u7b97\u5355", PdfUtils.DEFAULT_TITLE_FONT));
            paragraph.add((Element)new Chunk("(\u6d41\u7a0b\u672a\u7ed3\u675f\uff0c\u4ec5\u4f9b\u9884\u89c8\u4f7f\u7528)", PdfUtils.DEFAULT_TITLE_FONT_RED));
            paragraph.setAlignment(1);
            cell1.addElement((Element)paragraph);
            cell1.setColspan(24);
            cell1.setFixedHeight(40.0f);
            cell1.setVerticalAlignment(5);
            pageTable2.addCell(cell1);
        }
        return pageTable2;
    }

    @Autowired
    public void setFscComOrderDetailQueryAbilityService(FscComOrderDetailQueryAbilityService fscComOrderDetailQueryAbilityService) {
        this.fscComOrderDetailQueryAbilityService = fscComOrderDetailQueryAbilityService;
    }

    @Autowired
    public void setFscBillListPrintServiceImpl(FscBillListPrintServiceImpl fscBillListPrintServiceImpl) {
        this.fscBillListPrintServiceImpl = fscBillListPrintServiceImpl;
    }

    @Autowired
    public void setFscComApprovalprocessListQryAbilityService(FscComApprovalprocessListQryAbilityService fscComApprovalprocessListQryAbilityService) {
        this.fscComApprovalprocessListQryAbilityService = fscComApprovalprocessListQryAbilityService;
    }

    @Autowired
    public void setDycStationSelectService(DycStationSelectService dycStationSelectService) {
        this.dycStationSelectService = dycStationSelectService;
    }

    @Autowired
    public void setPebExtMainOrderDetailQueryAbilityService(PebExtMainOrderDetailQueryAbilityService pebExtMainOrderDetailQueryAbilityService) {
        this.pebExtMainOrderDetailQueryAbilityService = pebExtMainOrderDetailQueryAbilityService;
    }

    @Autowired
    public void setFscOrderItemDetailQueryAbilityService(FscOrderItemDetailQueryAbilityService fscOrderItemDetailQueryAbilityService) {
        this.fscOrderItemDetailQueryAbilityService = fscOrderItemDetailQueryAbilityService;
    }

    @Autowired
    public void setFscOrderRelationMapper(FscOrderRelationMapper fscOrderRelationMapper) {
        this.fscOrderRelationMapper = fscOrderRelationMapper;
    }

    @Autowired
    public void setFscShouldPayMapper(FscShouldPayMapper fscShouldPayMapper) {
        this.fscShouldPayMapper = fscShouldPayMapper;
    }

    @Autowired
    public void setFscInvoiceMapper(FscInvoiceMapper fscInvoiceMapper) {
        this.fscInvoiceMapper = fscInvoiceMapper;
    }
}

