/*
 * Decompiled with CFR 0.152.
 */
package com.tydic.fsc.bill.ability.impl;

import com.alibaba.fastjson.JSON;
import com.alibaba.fastjson.JSONObject;
import com.tydic.authority.busi.api.DycStationOrgSelectUserNameService;
import com.tydic.authority.busi.bo.DycStationOrgSelectUserNameReqBO;
import com.tydic.authority.busi.bo.DycStationOrgSelectUserNameRspBO;
import com.tydic.authority.busi.bo.UserBO;
import com.tydic.fsc.bill.ability.api.FscBillSendSaleFscOrderApprovalAbilityService;
import com.tydic.fsc.bill.ability.bo.FscBillSendSaleFscOrderApprovalAbilityReqBO;
import com.tydic.fsc.bill.ability.bo.FscBillSendSaleFscOrderApprovalAbilityRspBO;
import com.tydic.fsc.bill.busi.api.FscBillSendSaleFscOrderApprovalBusiService;
import com.tydic.fsc.bill.busi.bo.FscBillSendSaleFscOrderApprovalBusiReqBO;
import com.tydic.fsc.bill.busi.bo.FscBillSendSaleFscOrderApprovalBusiRspBO;
import com.tydic.fsc.common.ability.api.FscComOrderSyncAbilityService;
import com.tydic.fsc.common.ability.api.FscEsSyncComOrderListAbilityService;
import com.tydic.fsc.common.ability.api.FscSyncPushYcSaleAbilityService;
import com.tydic.fsc.common.ability.api.FscSyncSendNotificationService;
import com.tydic.fsc.common.ability.bo.FscComOrderListSyncAbilityReqBO;
import com.tydic.fsc.common.ability.bo.FscEsSyncComOrderListReqBO;
import com.tydic.fsc.common.ability.bo.FscSyncPushYcSaleAbilityReqBO;
import com.tydic.fsc.common.ability.bo.FscSyncSendNotificationReqBO;
import com.tydic.fsc.constants.FscConstants;
import java.util.Collection;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;
import org.springframework.beans.factory.annotation.Autowired;
import org.springframework.beans.factory.annotation.Value;
import org.springframework.util.CollectionUtils;
import org.springframework.util.StringUtils;
import org.springframework.web.bind.annotation.PostMapping;
import org.springframework.web.bind.annotation.RequestBody;
import org.springframework.web.bind.annotation.RequestMapping;
import org.springframework.web.bind.annotation.RestController;

@RestController
@RequestMapping(value={"FSC_GROUP_DEV/1.0.0/com.tydic.fsc.bill.ability.api.FscBillSendSaleFscOrderApprovalAbilityService"})
public class FscBillSendSaleFscOrderApprovalAbilityServiceImpl
implements FscBillSendSaleFscOrderApprovalAbilityService {
    private static final Logger log = LoggerFactory.getLogger(FscBillSendSaleFscOrderApprovalAbilityServiceImpl.class);
    @Autowired
    private FscBillSendSaleFscOrderApprovalBusiService fscBillSendSaleFscOrderApprovalBusiService;
    @Autowired
    private FscComOrderSyncAbilityService fscComOrderSyncAbilityService;
    @Autowired
    private FscEsSyncComOrderListAbilityService fscEsSyncComOrderListAbilityService;
    @Autowired
    private FscSyncPushYcSaleAbilityService fscSyncPushYcSaleAbilityService;
    @Autowired
    private FscSyncSendNotificationService fscSyncSendNotificationService;
    @Autowired
    private DycStationOrgSelectUserNameService dycStationOrgSelectUserNameService;
    @Value(value="${fsc.saleSettl.approval.taxAccounting:6240}")
    private String taxAccounting;

    @PostMapping(value={"sendSaleFscOrderApproval"})
    public FscBillSendSaleFscOrderApprovalAbilityRspBO sendSaleFscOrderApproval(@RequestBody FscBillSendSaleFscOrderApprovalAbilityReqBO reqBO) {
        FscBillSendSaleFscOrderApprovalAbilityRspBO rspBO = new FscBillSendSaleFscOrderApprovalAbilityRspBO();
        rspBO.setRespDesc("\u6210\u529f");
        if (!CollectionUtils.isEmpty((Collection)reqBO.getOrderIds())) {
            String errorInfo = "";
            for (Long orderId : reqBO.getOrderIds()) {
                FscBillSendSaleFscOrderApprovalBusiReqBO busiReqBO = (FscBillSendSaleFscOrderApprovalBusiReqBO)((Object)JSON.parseObject((String)JSONObject.toJSONString((Object)reqBO), FscBillSendSaleFscOrderApprovalBusiReqBO.class));
                busiReqBO.setOrderId(orderId);
                FscBillSendSaleFscOrderApprovalBusiRspBO busiRspBO = this.fscBillSendSaleFscOrderApprovalBusiService.sendSaleFscOrderApproval(busiReqBO);
                if ("0000".equals(busiRspBO.getRespCode()) && FscConstants.AuditResultStatus.PASS.equals(reqBO.getAuditResult()) && !busiRspBO.getFinish().booleanValue() && !StringUtils.isEmpty((Object)busiRspBO.getSendStation()) && busiRspBO.getSendStation().contains(this.taxAccounting)) {
                    DycStationOrgSelectUserNameReqBO dycStationOrgSelectUserNameReqBO = new DycStationOrgSelectUserNameReqBO();
                    dycStationOrgSelectUserNameReqBO.setStationId(Long.valueOf(this.taxAccounting));
                    DycStationOrgSelectUserNameRspBO dycStationOrgSelectUserNameRspBO = this.dycStationOrgSelectUserNameService.selectUserName(dycStationOrgSelectUserNameReqBO);
                    if (dycStationOrgSelectUserNameRspBO != null && !CollectionUtils.isEmpty((Collection)dycStationOrgSelectUserNameRspBO.getUserList())) {
                        UserBO userBO = (UserBO)dycStationOrgSelectUserNameRspBO.getUserList().get(0);
                        busiReqBO.setName(userBO.getName());
                        busiReqBO.setOrgName(userBO.getOrgName());
                        busiReqBO.setUserId(userBO.getUserId());
                    }
                    busiReqBO.setAuditAdvice("\u540c\u610f");
                    busiReqBO.setIsSelfApproval(true);
                    busiRspBO = this.fscBillSendSaleFscOrderApprovalBusiService.sendSaleFscOrderApproval(busiReqBO);
                }
                if (!"0000".equals(busiRspBO.getRespCode())) {
                    errorInfo = errorInfo + "\u7ed3\u7b97\u5355" + orderId + "\u5ba1\u6279\u5931\u8d25\uff0c" + busiRspBO.getRespDesc() + ";";
                }
                FscEsSyncComOrderListReqBO syncReqBO = new FscEsSyncComOrderListReqBO();
                syncReqBO.setFscOrderId(orderId);
                this.fscEsSyncComOrderListAbilityService.dealOrderToEs(syncReqBO);
                if (busiRspBO.getPushFlag().booleanValue()) {
                    this.sendPushMq(orderId);
                }
                if (!"0000".equals(busiRspBO.getRespCode()) || busiRspBO.getFinish().booleanValue()) continue;
                this.syncSendNotice(orderId, reqBO.getUserId());
            }
            if (StringUtils.isEmpty((Object)errorInfo)) {
                rspBO.setRespCode("0000");
                rspBO.setRespDesc("\u6210\u529f");
            } else {
                rspBO.setRespCode("198888");
                rspBO.setRespDesc(errorInfo);
            }
        } else if (reqBO.getOrderId() != null) {
            FscBillSendSaleFscOrderApprovalBusiReqBO busiReqBO = (FscBillSendSaleFscOrderApprovalBusiReqBO)((Object)JSON.parseObject((String)JSONObject.toJSONString((Object)reqBO), FscBillSendSaleFscOrderApprovalBusiReqBO.class));
            FscBillSendSaleFscOrderApprovalBusiRspBO busiRspBO = this.fscBillSendSaleFscOrderApprovalBusiService.sendSaleFscOrderApproval(busiReqBO);
            rspBO = (FscBillSendSaleFscOrderApprovalAbilityRspBO)JSON.parseObject((String)JSONObject.toJSONString((Object)((Object)busiRspBO)), FscBillSendSaleFscOrderApprovalAbilityRspBO.class);
            FscEsSyncComOrderListReqBO syncReqBO = new FscEsSyncComOrderListReqBO();
            syncReqBO.setFscOrderId(reqBO.getOrderId());
            this.fscEsSyncComOrderListAbilityService.dealOrderToEs(syncReqBO);
            if (busiRspBO.getPushFlag().booleanValue()) {
                this.sendPushMq(reqBO.getOrderId());
            }
            if ("0000".equals(busiRspBO.getRespCode()) && !busiRspBO.getFinish().booleanValue()) {
                this.syncSendNotice(reqBO.getOrderId(), reqBO.getUserId());
            }
        } else {
            rspBO.setRespCode("191000");
            rspBO.setRespDesc("\u53c2\u6570[orderId]\u548c[orderIds]\u4e0d\u80fd\u540c\u65f6\u4e3a\u7a7a");
        }
        return rspBO;
    }

    private void sendMq(Long orderId) {
        FscComOrderListSyncAbilityReqBO fscComOrderListSyncAbilityReqBO = new FscComOrderListSyncAbilityReqBO();
        fscComOrderListSyncAbilityReqBO.setFscOrderId(orderId);
        this.fscComOrderSyncAbilityService.dealComOrderSyncEs(fscComOrderListSyncAbilityReqBO);
    }

    private void sendPushMq(Long orderId) {
        FscSyncPushYcSaleAbilityReqBO syncAbilityReqBO = new FscSyncPushYcSaleAbilityReqBO();
        syncAbilityReqBO.setFscOrderId(orderId);
        this.fscSyncPushYcSaleAbilityService.syncPushYcSale(syncAbilityReqBO);
    }

    private void syncSendNotice(Long fscOrderId, Long userId) {
        FscSyncSendNotificationReqBO reqBO = new FscSyncSendNotificationReqBO();
        reqBO.setUserId(userId);
        reqBO.setObjId(fscOrderId);
        reqBO.setNotificationType(FscConstants.FSC_NOTIFICATION_TYPE.SALE_WAIT_AUDIT);
        this.fscSyncSendNotificationService.syncSendNotification(reqBO);
    }
}

