/*
 * Decompiled with CFR 0.152.
 */
package com.tydic.fsc.bill.ability.impl;

import com.alibaba.fastjson.JSONObject;
import com.tydic.fsc.bill.ability.api.FscComOrderRefundRejectAbilityService;
import com.tydic.fsc.bill.ability.bo.FscComOrderRefundRejectAbilityReqBO;
import com.tydic.fsc.bill.ability.bo.FscComOrderRefundRejectAbilityRspBO;
import com.tydic.fsc.bill.busi.api.FscComOrderRefundRejectBusiService;
import com.tydic.fsc.bill.busi.bo.FscComOrderRefundRejectBusiReqBO;
import com.tydic.fsc.bill.busi.bo.FscComOrderRefundRejectBusiRspBO;
import com.tydic.fsc.common.ability.api.FscComRefundSyncAbilityService;
import com.tydic.fsc.common.ability.bo.FscComRefundSyncAbilityReqBO;
import com.tydic.fsc.exception.FscBusinessException;
import java.util.Collection;
import java.util.Collections;
import org.springframework.beans.factory.annotation.Autowired;
import org.springframework.util.CollectionUtils;
import org.springframework.util.StringUtils;
import org.springframework.web.bind.annotation.PostMapping;
import org.springframework.web.bind.annotation.RequestBody;
import org.springframework.web.bind.annotation.RequestMapping;
import org.springframework.web.bind.annotation.RestController;

@RestController
@RequestMapping(value={"FSC_GROUP_DEV/1.0.0/com.tydic.fsc.bill.ability.api.FscComOrderRefundRejectAbilityService"})
public class FscComOrderRefundRejectAbilityServiceImpl
implements FscComOrderRefundRejectAbilityService {
    @Autowired
    private FscComOrderRefundRejectBusiService fscComOrderRefundRejectBusiService;
    @Autowired
    private FscComRefundSyncAbilityService fscComRefundSyncAbilityService;

    @PostMapping(value={"dealOrderRefundReject"})
    public FscComOrderRefundRejectAbilityRspBO dealOrderRefundReject(@RequestBody FscComOrderRefundRejectAbilityReqBO reqBO) {
        this.valid(reqBO);
        String reqString = JSONObject.toJSONString((Object)reqBO);
        FscComOrderRefundRejectBusiReqBO busiReqBO = (FscComOrderRefundRejectBusiReqBO)((Object)JSONObject.parseObject((String)reqString, FscComOrderRefundRejectBusiReqBO.class));
        StringBuffer sb = new StringBuffer();
        for (Long refundId : reqBO.getRefundIds()) {
            busiReqBO.setRefundId(refundId);
            FscComOrderRefundRejectBusiRspBO busiRspBO = this.fscComOrderRefundRejectBusiService.dealOrderRefundReject(busiReqBO);
            if (!busiRspBO.getRespCode().equals("0000")) {
                sb.append("\u9000\u7968\u5355[").append(refundId).append("]\u62d2\u7edd\u5904\u7406\u5931\u8d25\uff1a").append(busiRspBO.getRespDesc());
                continue;
            }
            this.sendMq(refundId);
        }
        FscComOrderRefundRejectAbilityRspBO rspBO = new FscComOrderRefundRejectAbilityRspBO();
        if (!StringUtils.isEmpty((Object)sb.toString())) {
            rspBO.setRespCode("198888");
            rspBO.setRespDesc(sb.toString());
        } else {
            rspBO.setRespCode("0000");
            rspBO.setRespDesc("\u6210\u529f");
        }
        return rspBO;
    }

    private void sendMq(Long refundId) {
        FscComRefundSyncAbilityReqBO syncAbilityReqBO = new FscComRefundSyncAbilityReqBO();
        syncAbilityReqBO.setRefundIds(Collections.singletonList(refundId));
        this.fscComRefundSyncAbilityService.syncRefund(syncAbilityReqBO);
    }

    private void valid(FscComOrderRefundRejectAbilityReqBO reqBO) {
        if (CollectionUtils.isEmpty((Collection)reqBO.getRefundIds())) {
            throw new FscBusinessException("198888", "\u5165\u53c2[refundIds]\u4e0d\u80fd\u4e3a\u7a7a\uff01");
        }
        if (StringUtils.isEmpty((Object)reqBO.getRejectReason())) {
            throw new FscBusinessException("198888", "\u5165\u53c2[rejectReason]\u4e0d\u80fd\u4e3a\u7a7a\uff01");
        }
    }
}

