/*
 * Decompiled with CFR 0.152.
 */
package com.tydic.fsc.bill.ability.impl;

import com.alibaba.fastjson.JSONObject;
import com.tydic.fsc.bill.ability.api.FscComOrderRefundSupConfirmAbilityService;
import com.tydic.fsc.bill.ability.bo.FscComOrderRefundSupConfirmAbilityReqBO;
import com.tydic.fsc.bill.ability.bo.FscComOrderRefundSupConfirmAbilityRspBO;
import com.tydic.fsc.bill.busi.api.FscComOrderRefundSupConfirmBusiService;
import com.tydic.fsc.bill.busi.bo.FscComOrderRefundSupConfirmBusiReqBO;
import com.tydic.fsc.bill.busi.bo.FscComOrderRefundSupConfirmBusiRspBO;
import com.tydic.fsc.bo.InvoiceBO;
import com.tydic.fsc.common.ability.api.FscComInvoiceSyncAbilityService;
import com.tydic.fsc.common.ability.api.FscComOrderSyncAbilityService;
import com.tydic.fsc.common.ability.api.FscComRefundSyncAbilityService;
import com.tydic.fsc.common.ability.bo.FscComInvoiceListSyncAbilityReqBO;
import com.tydic.fsc.common.ability.bo.FscComOrderListSyncAbilityReqBO;
import com.tydic.fsc.common.ability.bo.FscComRefundSyncAbilityReqBO;
import com.tydic.fsc.constants.FscConstants;
import com.tydic.fsc.exception.FscBusinessException;
import com.tydic.fsc.util.FscDuplicateCommitLimit;
import java.util.Collection;
import java.util.Collections;
import org.springframework.beans.factory.annotation.Autowired;
import org.springframework.util.CollectionUtils;
import org.springframework.web.bind.annotation.PostMapping;
import org.springframework.web.bind.annotation.RequestBody;
import org.springframework.web.bind.annotation.RequestMapping;
import org.springframework.web.bind.annotation.RestController;

@RestController
@RequestMapping(value={"FSC_GROUP_DEV/1.0.0/com.tydic.fsc.bill.ability.api.FscComOrderRefundSupConfirmAbilityService"})
public class FscComOrderRefundSupConfirmAbilityServiceImpl
implements FscComOrderRefundSupConfirmAbilityService {
    @Autowired
    private FscComOrderRefundSupConfirmBusiService fscComOrderRefundSupConfirmBusiService;
    @Autowired
    private FscComRefundSyncAbilityService fscComRefundSyncAbilityService;
    @Autowired
    private FscComInvoiceSyncAbilityService fscComInvoiceSyncAbilityService;
    @Autowired
    private FscComOrderSyncAbilityService fscComOrderSyncAbilityService;

    @FscDuplicateCommitLimit
    @PostMapping(value={"dealOrderRefundSupConfirm"})
    public FscComOrderRefundSupConfirmAbilityRspBO dealOrderRefundSupConfirm(@RequestBody FscComOrderRefundSupConfirmAbilityReqBO reqBO) {
        this.valid(reqBO);
        String reqString = JSONObject.toJSONString((Object)reqBO);
        FscComOrderRefundSupConfirmBusiReqBO busiReqBO = (FscComOrderRefundSupConfirmBusiReqBO)((Object)JSONObject.parseObject((String)reqString, FscComOrderRefundSupConfirmBusiReqBO.class));
        FscComOrderRefundSupConfirmBusiRspBO busiRspBO = this.fscComOrderRefundSupConfirmBusiService.dealOrderRefundSupConfirm(busiReqBO);
        if (busiRspBO.getRespCode().equals("0000")) {
            this.sendMq(reqBO.getRefundId(), busiRspBO.getFscOrderId());
        }
        return (FscComOrderRefundSupConfirmAbilityRspBO)JSONObject.parseObject((String)JSONObject.toJSONString((Object)((Object)busiRspBO)), FscComOrderRefundSupConfirmAbilityRspBO.class);
    }

    private void sendMq(Long refundId, Long fscOrderId) {
        FscComRefundSyncAbilityReqBO syncAbilityReqBO = new FscComRefundSyncAbilityReqBO();
        syncAbilityReqBO.setRefundIds(Collections.singletonList(refundId));
        this.fscComRefundSyncAbilityService.syncRefund(syncAbilityReqBO);
        FscComInvoiceListSyncAbilityReqBO fscComInvoiceListSyncAbilityReqBO = new FscComInvoiceListSyncAbilityReqBO();
        fscComInvoiceListSyncAbilityReqBO.setFscOrderId(fscOrderId);
        this.fscComInvoiceSyncAbilityService.dealComOrderSyncEs(fscComInvoiceListSyncAbilityReqBO);
        FscComInvoiceListSyncAbilityReqBO refundInvoiceListSyncAbilityReqBO = new FscComInvoiceListSyncAbilityReqBO();
        refundInvoiceListSyncAbilityReqBO.setFscOrderId(refundId);
        refundInvoiceListSyncAbilityReqBO.setSyncType(FscConstants.FscSyncType.REFUND);
        this.fscComInvoiceSyncAbilityService.dealComOrderSyncEs(refundInvoiceListSyncAbilityReqBO);
        FscComOrderListSyncAbilityReqBO fscComOrderListSyncAbilityReqBO = new FscComOrderListSyncAbilityReqBO();
        fscComOrderListSyncAbilityReqBO.setFscOrderId(fscOrderId);
        this.fscComOrderSyncAbilityService.dealComOrderSyncEs(fscComOrderListSyncAbilityReqBO);
    }

    private void valid(FscComOrderRefundSupConfirmAbilityReqBO reqBO) {
        if (reqBO.getRefundId() == null) {
            throw new FscBusinessException("198888", "\u5165\u53c2[refundId]\u4e0d\u80fd\u4e3a\u7a7a\uff01");
        }
        if (reqBO.getConfirmType() == null) {
            throw new FscBusinessException("198888", "\u5165\u53c2[confirmType]\u4e0d\u80fd\u4e3a\u7a7a\uff01");
        }
        if (reqBO.getConfirmType().equals(FscConstants.RefundSupConfirmType.RED) && CollectionUtils.isEmpty((Collection)reqBO.getRedInvoiceList())) {
            throw new FscBusinessException("198888", "\u5165\u53c2[redInvoiceList]\u4e0d\u80fd\u4e3a\u7a7a\uff01");
        }
        for (InvoiceBO invoiceBO : reqBO.getRedInvoiceList()) {
            if (invoiceBO.getInvoiceId() != null) continue;
            throw new FscBusinessException("198888", "\u5165\u53c2[redInvoiceList\u7684invoiceId]\u4e0d\u80fd\u4e3a\u7a7a\uff01");
        }
    }
}

