/*
 * Decompiled with CFR 0.152.
 */
package com.tydic.fsc.bill.ability.impl;

import cn.hutool.core.collection.CollectionUtil;
import com.google.common.collect.Lists;
import com.tydic.fsc.bill.ability.api.FscFinanceInvoiceUploadTaskAbilityService;
import com.tydic.fsc.bill.ability.api.finance.FscFinanceInvoiceFolderQryByUserAbilityService;
import com.tydic.fsc.bill.ability.api.finance.FscFinanceInvoiceFolderUpdateAbilityService;
import com.tydic.fsc.bill.ability.api.finance.FscFinanceInvoiceFolderUploadAbilityService;
import com.tydic.fsc.bill.ability.bo.FscFinanceInvoiceUploadTaskReqBo;
import com.tydic.fsc.bill.ability.bo.FscFinanceInvoiceUploadTaskRspBo;
import com.tydic.fsc.bill.ability.bo.finance.FscFinanceInvoiceFolderQryByUserReqBo;
import com.tydic.fsc.bill.ability.bo.finance.FscFinanceInvoiceFolderQryByUserRspBO;
import com.tydic.fsc.bill.ability.bo.finance.FscFinanceInvoiceFolderQryByUserRspList;
import com.tydic.fsc.bill.ability.bo.finance.FscFinanceInvoiceFolderUpdateReqBo;
import com.tydic.fsc.bill.ability.bo.finance.FscFinanceInvoiceFolderUpdateRspBo;
import com.tydic.fsc.bill.ability.bo.finance.FscFinanceInvoiceFolderUploadReqBo;
import com.tydic.fsc.bill.ability.bo.finance.FscFinanceInvoiceFolderUploadRspBo;
import com.tydic.fsc.bill.ability.bo.finance.FscFinanceInvoiceFolderUploadRspBoData;
import com.tydic.fsc.constants.FscConstants;
import com.tydic.fsc.dao.FscAttachmentMapper;
import com.tydic.fsc.dao.FscInvoiceMapper;
import com.tydic.fsc.exception.FscBusinessException;
import com.tydic.fsc.po.FscAttachmentPO;
import com.tydic.fsc.po.FscInvoicePO;
import java.util.ArrayList;
import java.util.Collection;
import java.util.Collections;
import java.util.HashMap;
import java.util.List;
import java.util.stream.Collectors;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;
import org.springframework.beans.factory.annotation.Autowired;
import org.springframework.web.bind.annotation.PostMapping;
import org.springframework.web.bind.annotation.RequestBody;
import org.springframework.web.bind.annotation.RequestMapping;
import org.springframework.web.bind.annotation.RestController;

@RestController
@RequestMapping(value={"FSC_GROUP_DEV/1.0.0/com.tydic.fsc.bill.ability.api.FscFinanceInvoiceUploadTaskAbilityService"})
public class FscFinanceInvoiceUploadTaskAbilityServiceImpl
implements FscFinanceInvoiceUploadTaskAbilityService {
    private static final Logger log = LoggerFactory.getLogger(FscFinanceInvoiceUploadTaskAbilityServiceImpl.class);
    @Autowired
    private FscInvoiceMapper fscInvoiceMapper;
    @Autowired
    private FscAttachmentMapper fscAttachmentMapper;
    @Autowired
    private FscFinanceInvoiceFolderUploadAbilityService folderUploadAbilityService;
    @Autowired
    private FscFinanceInvoiceFolderUpdateAbilityService invoiceFolderUpdateAbilityService;
    @Autowired
    private FscFinanceInvoiceFolderQryByUserAbilityService folderQryByUserAbilityService;

    @PostMapping(value={"invoiceUploadShare"})
    public FscFinanceInvoiceUploadTaskRspBo invoiceUploadShare(@RequestBody FscFinanceInvoiceUploadTaskReqBo reqBo) {
        List list;
        List reUpdateList;
        log.info("\u8fd0\u8425\u5355\u4f4d\u5f00\u7968\u5b9a\u65f6\u4efb\u52a1\u53bb\u4e0a\u4f20\u3001\u5360\u7528\u5171\u4eab\u5f00\u59cb");
        FscInvoicePO queryPo = new FscInvoicePO();
        queryPo.setInvoiceIds(reqBo.getInvoiceIdList());
        queryPo.setFscOrderIds(reqBo.getFscOrderIdList());
        if (CollectionUtil.isEmpty((Collection)reqBo.getInvoiceIdList()) && CollectionUtil.isEmpty((Collection)reqBo.getFscOrderIdList())) {
            queryPo.setStatus(Integer.valueOf(1));
        }
        if (CollectionUtil.isNotEmpty(reUpdateList = (list = this.fscInvoiceMapper.queryInvoiceUploadShare(queryPo)).stream().filter(fscInvoicePO -> fscInvoicePO.getUploadShareStatus() == 3).collect(Collectors.toList()))) {
            for (FscInvoicePO fscInvoicePO2 : reUpdateList) {
                FscInvoicePO updatePo = new FscInvoicePO();
                this.toUpdate(fscInvoicePO2, fscInvoicePO2.getFinanceGuid());
                updatePo.setInvoiceId(fscInvoicePO2.getInvoiceId());
                updatePo.setUploadShareFailNum(fscInvoicePO2.getUploadShareFailNum());
                updatePo.setUploadShareFailReason(fscInvoicePO2.getUploadShareFailReason());
                updatePo.setUploadShareStatus(fscInvoicePO2.getUploadShareStatus());
                this.fscInvoiceMapper.updateById(updatePo);
            }
            list.removeAll(reUpdateList);
        }
        FscFinanceInvoiceUploadTaskRspBo rspBo = new FscFinanceInvoiceUploadTaskRspBo();
        rspBo.setRespCode("0000");
        rspBo.setRespDesc("\u6210\u529f");
        if (CollectionUtil.isEmpty((Collection)list)) {
            rspBo.setRespDesc("\u5f00\u7968\u5b9a\u65f6\u4efb\u52a1\u4e0a\u4f20\u3001\u5360\u7528\u5171\u4eab\u672a\u67e5\u8be2\u5230\u6570\u636e");
            log.info("\u5f00\u7968\u5b9a\u65f6\u4efb\u52a1\u4e0a\u4f20\u3001\u5360\u7528\u5171\u4eab\u672a\u67e5\u8be2\u5230\u6570\u636e");
            return rspBo;
        }
        List partition = Lists.partition((List)list, (int)1000);
        for (List invoicePOList : partition) {
            HashMap contractIdMap = new HashMap(invoicePOList.size());
            FscAttachmentPO attachmentPO = new FscAttachmentPO();
            attachmentPO.setFscOrderIds(new ArrayList(invoicePOList.size()));
            attachmentPO.setObjIds(new ArrayList(invoicePOList.size()));
            attachmentPO.setObjType(Integer.valueOf(1));
            invoicePOList.forEach(e -> {
                attachmentPO.getFscOrderIds().add(e.getFscOrderId());
                attachmentPO.getObjIds().add(e.getInvoiceId());
                contractIdMap.put(e.getInvoiceId(), e);
            });
            log.info("\u9644\u4ef6\u67e5\u8be2\u5165\u53c2{}", (Object)attachmentPO);
            List attachmentPOS = this.fscAttachmentMapper.getList(attachmentPO);
            if (CollectionUtil.isEmpty((Collection)attachmentPOS)) {
                rspBo.setRespDesc("\u5f00\u7968\u5b9a\u65f6\u4efb\u52a1\u4e0a\u4f20\u3001\u5360\u7528\u5171\u4eab\u672a\u67e5\u8be2\u5230\u9644\u4ef6");
                log.info("\u5f00\u7968\u5b9a\u65f6\u4efb\u52a1\u4e0a\u4f20\u3001\u5360\u7528\u5171\u4eab\u672a\u67e5\u8be2\u5230\u9644\u4ef6");
                return rspBo;
            }
            attachmentPOS.forEach(e -> {
                FscInvoicePO updatePo = new FscInvoicePO();
                updatePo.setInvoiceId(e.getObjId());
                updatePo.setUploadShareStatus(FscConstants.FinanceInvoiceUploadShareStatus.UPLOAD_FAIL);
                FscInvoicePO fscInvoicePO = (FscInvoicePO)contractIdMap.get(e.getObjId());
                updatePo.setUploadShareFailNum(Integer.valueOf(fscInvoicePO.getUploadShareFailNum() == null ? 1 : fscInvoicePO.getUploadShareFailNum() + 1));
                try {
                    FscFinanceInvoiceFolderUploadReqBo uploadReqBo = new FscFinanceInvoiceFolderUploadReqBo();
                    uploadReqBo.setFscOrderId(e.getFscOrderId());
                    uploadReqBo.setFileUrl(Collections.singletonList(e.getAttachmentUrl()));
                    uploadReqBo.setGuid(this.getGuid(fscInvoicePO));
                    uploadReqBo.setContractId(fscInvoicePO.getContractId());
                    FscFinanceInvoiceFolderUploadRspBo uploadRspBo = this.folderUploadAbilityService.uploadInvoiceFolder(uploadReqBo);
                    if ("0000".equals(uploadRspBo.getRespCode())) {
                        String guid = ((FscFinanceInvoiceFolderUploadRspBoData)uploadRspBo.getData().get(0)).getGuid();
                        updatePo.setFinanceGuid(guid);
                        updatePo.setUploadShareStatus(FscConstants.FinanceInvoiceUploadShareStatus.USE_FAIL);
                        updatePo.setUploadShareFailNum(Integer.valueOf(0));
                        this.toUpdate(updatePo, guid);
                    } else {
                        updatePo.setUploadShareFailReason(uploadRspBo.getRespDesc());
                    }
                }
                catch (FscBusinessException fex) {
                    log.info("\u5f00\u7968\u5b9a\u65f6\u4efb\u52a1\u4e0a\u4f20\u3001\u5360\u7528\u5171\u4eab\u5f02\u5e38{},\u5f02\u5e38\u53d1\u7968id{}", (Object)fex.getMessage(), (Object)e.getObjId());
                    updatePo.setUploadShareFailReason(fex.getMessage());
                }
                catch (Exception ex) {
                    String message = ex.getMessage();
                    log.info("\u5f00\u7968\u5b9a\u65f6\u4efb\u52a1\u4e0a\u4f20\u3001\u5360\u7528\u5171\u4eab\u5f02\u5e38{},\u5f02\u5e38\u53d1\u7968id{}", (Object)message, (Object)e.getObjId());
                    updatePo.setUploadShareFailReason(message.length() >= 100 ? message.substring(0, 100) : message);
                }
                this.fscInvoiceMapper.updateById(updatePo);
            });
        }
        log.info("\u8fd0\u8425\u5355\u4f4d\u5f00\u7968\u5b9a\u65f6\u4efb\u52a1\u53bb\u4e0a\u4f20\u3001\u5360\u7528\u5171\u4eab\u7ed3\u675f");
        return rspBo;
    }

    private String getGuid(FscInvoicePO fscInvoicePO) {
        FscFinanceInvoiceFolderQryByUserReqBo folderQryReqBo = new FscFinanceInvoiceFolderQryByUserReqBo();
        folderQryReqBo.setFscOrderId(fscInvoicePO.getFscOrderId());
        folderQryReqBo.setUserName(fscInvoicePO.getCreateOperId());
        FscFinanceInvoiceFolderQryByUserRspBO folderQryByUserRspBO = this.folderQryByUserAbilityService.queryInvoiceFolderByUser(folderQryReqBo);
        if (!"0000".equals(folderQryByUserRspBO.getRespCode())) {
            throw new FscBusinessException("190000", "\u83b7\u53d6\u7528\u6237\u7968\u5939\u5931\u8d25:" + folderQryByUserRspBO.getRespDesc());
        }
        return ((FscFinanceInvoiceFolderQryByUserRspList)folderQryByUserRspBO.getDate().get(0)).getGuid();
    }

    private void toUpdate(FscInvoicePO fscInvoicePo, String guid) {
        FscFinanceInvoiceFolderUpdateReqBo reqBo = new FscFinanceInvoiceFolderUpdateReqBo();
        reqBo.setItemGuids(Collections.singletonList(guid));
        reqBo.setUseStatus("1");
        FscFinanceInvoiceFolderUpdateRspBo updateRspBo = this.invoiceFolderUpdateAbilityService.updateInvoiceFolderStatus(reqBo);
        if ("0000".equals(updateRspBo.getRespCode())) {
            fscInvoicePo.setUploadShareStatus(FscConstants.FinanceInvoiceUploadShareStatus.USE_SUCCESS);
        } else {
            fscInvoicePo.setUploadShareFailNum(Integer.valueOf(fscInvoicePo.getUploadShareFailNum() + 1));
            fscInvoicePo.setUploadShareStatus(FscConstants.FinanceInvoiceUploadShareStatus.USE_FAIL);
            fscInvoicePo.setUploadShareFailReason(updateRspBo.getRespDesc());
        }
    }
}

