/*
 * Decompiled with CFR 0.152.
 */
package com.tydic.fsc.bill.ability.impl;

import com.tydic.fsc.bill.ability.api.FscBillAutoSignAbilityService;
import com.tydic.fsc.bill.ability.api.FscGetInvoiceDataAbilityService;
import com.tydic.fsc.bill.ability.bo.FscBillAutoSignAbilityReqBO;
import com.tydic.fsc.bill.ability.bo.FscGetInvoiceDataAbilityReqBO;
import com.tydic.fsc.bill.ability.bo.FscGetInvoiceDataAbilityRspBO;
import com.tydic.fsc.bill.busi.api.FscBillInvoiceUploadBusiService;
import com.tydic.fsc.bill.busi.api.FscBillOrderDescUpdateBusiService;
import com.tydic.fsc.bill.busi.bo.FscBillInvoiceUploadBusiReqBO;
import com.tydic.fsc.bill.busi.bo.FscBillInvoiceUploadBusiRspBO;
import com.tydic.fsc.bill.busi.bo.FscBillOrderDescUpdateBusiReqBO;
import com.tydic.fsc.bo.AttachmentBO;
import com.tydic.fsc.bo.FscInvoiceInfoBO;
import com.tydic.fsc.bo.InvoiceItemBO;
import com.tydic.fsc.busibase.atom.api.FscSendNotificationExtAtomService;
import com.tydic.fsc.busibase.atom.bo.FscSendNotificationExtAtomReqBO;
import com.tydic.fsc.busibase.busi.api.FscDictionaryBusiService;
import com.tydic.fsc.busibase.external.api.bo.FscCfcUniteParamQryListDetailExternalReqBO;
import com.tydic.fsc.busibase.external.api.bo.FscCfcUniteParamQryListDetailExternalRspBO;
import com.tydic.fsc.busibase.external.api.bo.FscGetInvoiceInfoItemReqBO;
import com.tydic.fsc.busibase.external.api.bo.FscGetInvoiceInfoItemRspBO;
import com.tydic.fsc.busibase.external.api.bo.FscGetInvoiceInfoItemSkuRspBO;
import com.tydic.fsc.busibase.external.api.bo.FscGetInvoiceInfoListRspBO;
import com.tydic.fsc.busibase.external.api.bo.FscGetInvoiceInfoReqBO;
import com.tydic.fsc.busibase.external.api.bo.FscGetInvoiceInfoRspBO;
import com.tydic.fsc.busibase.external.api.cfc.FscCfcUniteParamQryListDetailExternalService;
import com.tydic.fsc.busibase.external.api.esb.FscGetInvoiceInfoExternalService;
import com.tydic.fsc.busibase.external.api.esb.FscGetInvoiceInfoItemExternalService;
import com.tydic.fsc.common.ability.api.FscBillMailSyncAbilityService;
import com.tydic.fsc.common.ability.api.FscComInvoiceDeleteSyncAbilityService;
import com.tydic.fsc.common.ability.api.FscComInvoiceSyncAbilityService;
import com.tydic.fsc.common.ability.api.FscComOrderSyncAbilityService;
import com.tydic.fsc.common.ability.bo.FscBillMailListSyncAbilityReqBO;
import com.tydic.fsc.common.ability.bo.FscComInvoiceDeleteSyncAbilityReqBO;
import com.tydic.fsc.common.ability.bo.FscComInvoiceListSyncAbilityReqBO;
import com.tydic.fsc.common.ability.bo.FscComOrderListSyncAbilityReqBO;
import com.tydic.fsc.constants.FscBillStatus;
import com.tydic.fsc.constants.FscConstants;
import com.tydic.fsc.dao.FscOrderInvoiceMapper;
import com.tydic.fsc.dao.FscOrderItemMapper;
import com.tydic.fsc.dao.FscOrderMapper;
import com.tydic.fsc.dao.FscOrderRelationMapper;
import com.tydic.fsc.exception.FscBusinessException;
import com.tydic.fsc.po.FscOrderInvoicePO;
import com.tydic.fsc.po.FscOrderItemPO;
import com.tydic.fsc.po.FscOrderPO;
import com.tydic.fsc.po.FscOrderRelationPO;
import java.math.BigDecimal;
import java.math.RoundingMode;
import java.text.SimpleDateFormat;
import java.util.ArrayList;
import java.util.Collection;
import java.util.Collections;
import java.util.HashMap;
import java.util.List;
import java.util.Map;
import org.apache.commons.lang.StringUtils;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;
import org.springframework.beans.factory.annotation.Autowired;
import org.springframework.beans.factory.annotation.Value;
import org.springframework.util.CollectionUtils;
import org.springframework.web.bind.annotation.PostMapping;
import org.springframework.web.bind.annotation.RequestBody;
import org.springframework.web.bind.annotation.RequestMapping;
import org.springframework.web.bind.annotation.RestController;

@RestController
@RequestMapping(value={"FSC_GROUP_DEV/1.0.0/com.tydic.fsc.bill.ability.api.FscGetInvoiceDataAbilityService"})
public class FscGetInvoiceDataAbilityServiceImpl
implements FscGetInvoiceDataAbilityService {
    private static final Logger log = LoggerFactory.getLogger(FscGetInvoiceDataAbilityServiceImpl.class);
    @Autowired
    private FscComOrderSyncAbilityService fscComOrderSyncAbilityService;
    @Autowired
    private FscComInvoiceSyncAbilityService fscComInvoiceSyncAbilityService;
    @Autowired
    private FscComInvoiceDeleteSyncAbilityService fscComInvoiceDeleteSyncAbilityService;
    @Autowired
    private FscBillInvoiceUploadBusiService fscBillInvoiceUploadBusiService;
    @Autowired
    private FscGetInvoiceInfoExternalService fscGetInvoiceInfoExternalService;
    @Autowired
    private FscGetInvoiceInfoItemExternalService fscGetInvoiceInfoItemExternalService;
    @Autowired
    private FscOrderMapper fscOrderMapper;
    @Autowired
    private FscOrderInvoiceMapper fscOrderInvoiceMapper;
    @Autowired
    private FscOrderItemMapper fscOrderItemMapper;
    @Autowired
    private FscCfcUniteParamQryListDetailExternalService fscCfcUniteParamQryListDetailExternalService;
    @Autowired
    private FscBillMailSyncAbilityService fscBillMailSyncAbilityService;
    @Autowired
    private FscBillAutoSignAbilityService fscBillAutoSignAbilityService;
    @Autowired
    private FscBillOrderDescUpdateBusiService fscBillOrderDescUpdateBusiService;
    @Autowired
    private FscOrderRelationMapper fscOrderRelationMapper;
    @Autowired
    private FscSendNotificationExtAtomService fscSendNotificationExtAtomService;
    @Autowired
    private FscDictionaryBusiService fscDictionaryBusiService;
    private static final String AUTO_SIGN = "0";
    private static final String BUSI_NAME = "\u83b7\u53d6\u7535\u5546\u53d1\u7968";
    private final Long JD_SUPPLIER_ID = 100055L;
    @Value(value="${SUPPLIER_SUNING:100057}")
    private Long SN_SUPPLIER_ID;
    @Value(value="${SUPPLIER_JD_ID_FL:202200511}")
    private Long jdIdFl;
    @Value(value="${SUPPLIER_SUNING_FL:202200512}")
    private Long snIdFl;
    @Value(value="${SUPPLIER_FULL_ELEC_ID:100060}")
    private String fullElecId;
    private static final String NOT_NEED_INVOICE_INFO = "0";

    @PostMapping(value={"getInvoiceData"})
    public FscGetInvoiceDataAbilityRspBO getInvoiceData(@RequestBody FscGetInvoiceDataAbilityReqBO reqBO) {
        this.val(reqBO);
        FscGetInvoiceInfoReqBO fscGetInvoiceInfoReqBO = new FscGetInvoiceInfoReqBO();
        fscGetInvoiceInfoReqBO.setMarkId(String.valueOf(reqBO.getFscOrderId()));
        fscGetInvoiceInfoReqBO.setSupplierId(String.valueOf(reqBO.getSupplierId()));
        fscGetInvoiceInfoReqBO.setProOrgId(String.valueOf(reqBO.getProOrgId()));
        FscGetInvoiceInfoRspBO invoiceInfo = this.fscGetInvoiceInfoExternalService.getInvoiceInfo(fscGetInvoiceInfoReqBO);
        if (!"0000".equals(invoiceInfo.getRespCode())) {
            throw new FscBusinessException("191031", invoiceInfo.getRespDesc());
        }
        List invoiceInfoResultList = invoiceInfo.getResult();
        FscOrderInvoicePO fscOrderInvoicePo = new FscOrderInvoicePO();
        fscOrderInvoicePo.setFscOrderId(reqBO.getFscOrderId());
        fscOrderInvoicePo = this.fscOrderInvoiceMapper.getModelBy(fscOrderInvoicePo);
        if (null == fscOrderInvoicePo) {
            throw new FscBusinessException("191031", "\u67e5\u8be2\u4e3b\u5355\u53d1\u7968\u4e3a\u7a7a");
        }
        FscOrderItemPO fscOrderItemPo = new FscOrderItemPO();
        fscOrderItemPo.setFscOrderId(reqBO.getFscOrderId());
        List fscOrderItemPos = this.fscOrderItemMapper.getListBySkuNumNotZero(fscOrderItemPo);
        if (CollectionUtils.isEmpty((Collection)fscOrderItemPos)) {
            throw new FscBusinessException("191031", "\u67e5\u8be2\u4e3b\u5355\u660e\u7ec6\u4e3a\u7a7a");
        }
        Boolean isAutoSign = this.isAutoSign(reqBO);
        ArrayList<FscInvoiceInfoBO> fscInvoiceInfoBos = new ArrayList<FscInvoiceInfoBO>();
        if (!CollectionUtils.isEmpty((Collection)invoiceInfoResultList)) {
            for (FscGetInvoiceInfoListRspBO fscGetInvoiceInfoListRspBO : invoiceInfoResultList) {
                FscInvoiceInfoBO fscInvoiceInfoBO = this.createEntity(fscGetInvoiceInfoListRspBO, reqBO, fscOrderInvoicePo, fscOrderItemPos);
                fscInvoiceInfoBos.add(fscInvoiceInfoBO);
            }
        }
        FscBillInvoiceUploadBusiReqBO fscBillInvoiceUploadBusiReqBO = new FscBillInvoiceUploadBusiReqBO();
        fscBillInvoiceUploadBusiReqBO.setFscInvoiceInfoBOS(fscInvoiceInfoBos);
        fscBillInvoiceUploadBusiReqBO.setFscOrderId(reqBO.getFscOrderId());
        fscBillInvoiceUploadBusiReqBO.setBusiName(BUSI_NAME);
        fscBillInvoiceUploadBusiReqBO.setCurStatus(FscBillStatus.INVOICING_SUBMISSION.getCode());
        FscBillInvoiceUploadBusiRspBO fscBillInvoiceUploadBusiRspBO = this.fscBillInvoiceUploadBusiService.dealInvoiceUpload(fscBillInvoiceUploadBusiReqBO);
        if (!"0000".equals(fscBillInvoiceUploadBusiRspBO.getRespCode())) {
            throw new FscBusinessException("191031", fscBillInvoiceUploadBusiRspBO.getRespDesc());
        }
        FscOrderPO fscOrderPo = new FscOrderPO();
        fscOrderPo.setFscOrderId(reqBO.getFscOrderId());
        fscOrderPo = this.fscOrderMapper.getModelBy(fscOrderPo);
        Map orderTypeMap = this.fscDictionaryBusiService.queryBypCodeBackMap("FSC_ORDER_TYPE");
        String orderTypeStr = fscOrderPo.getOrderType() == 2 && fscOrderPo.getTradeMode() != null && fscOrderPo.getTradeMode() == 2 && fscOrderPo.getOrderSource() == 3 && fscOrderPo.getSettlePlatform() != null && fscOrderPo.getSettlePlatform() == 2 ? "\u81ea\u9700\u91c7\u8d2d" : (String)orderTypeMap.get(fscOrderPo.getOrderType() + "");
        FscSendNotificationExtAtomReqBO fscSendNotificationExtAtomReqBO = new FscSendNotificationExtAtomReqBO();
        fscSendNotificationExtAtomReqBO.setTitel(fscOrderPo.getOrderNo() + "\u91c7\u8d2d\u7ed3\u7b97_" + orderTypeStr + "_" + fscOrderPo.getTotalCharge().setScale(2, RoundingMode.HALF_UP) + "\u5df2\u5f00\u7968");
        fscSendNotificationExtAtomReqBO.setText("\u3010\u4e2d\u56fd\u4e2d\u7164\u3011\u60a8\u7684\u7ed3\u7b97\u5355" + fscOrderPo.getOrderNo() + "\u5df2\u5f00\u7968\u5b8c\u6210\uff0c\u8bf7\u6ce8\u610f\u67e5\u6536\u3002");
        fscSendNotificationExtAtomReqBO.setUserId(Long.valueOf(1L));
        fscSendNotificationExtAtomReqBO.setReceiveIds(Collections.singletonList(fscOrderPo.getCreateOperId()));
        this.fscSendNotificationExtAtomService.sendNotification(fscSendNotificationExtAtomReqBO);
        this.updateOrderDesc(reqBO.getFscOrderId());
        this.sendMq(reqBO);
        if (isAutoSign.booleanValue()) {
            this.autoSign(reqBO);
        }
        return new FscGetInvoiceDataAbilityRspBO();
    }

    private void autoSign(FscGetInvoiceDataAbilityReqBO reqBO) {
        FscBillAutoSignAbilityReqBO fscBillAutoSignAbilityReqBO = new FscBillAutoSignAbilityReqBO();
        fscBillAutoSignAbilityReqBO.setFscOrderId(reqBO.getFscOrderId());
        this.fscBillAutoSignAbilityService.dealAutoSign(fscBillAutoSignAbilityReqBO);
    }

    private boolean isAutoSign(FscGetInvoiceDataAbilityReqBO reqBO) {
        if (FscConstants.FscOrderReceiveType.PURCHASE.equals(reqBO.getReceiveType()) && FscConstants.FscOrderMakeType.OPERTION.equals(reqBO.getMakeType())) {
            FscCfcUniteParamQryListDetailExternalReqBO fscCfcUniteParamQryListDetailExternalReqBO = new FscCfcUniteParamQryListDetailExternalReqBO();
            fscCfcUniteParamQryListDetailExternalReqBO.setParamCode("operinvoice_sign");
            fscCfcUniteParamQryListDetailExternalReqBO.setRelId(String.valueOf(reqBO.getProOrgId()));
            FscCfcUniteParamQryListDetailExternalRspBO fscCfcUniteParamQryListDetailExternalRspBO = this.fscCfcUniteParamQryListDetailExternalService.qryListDetail(fscCfcUniteParamQryListDetailExternalReqBO);
            if (!"0000".equals(fscCfcUniteParamQryListDetailExternalRspBO.getRespCode())) {
                throw new FscBusinessException("191031", fscCfcUniteParamQryListDetailExternalRspBO.getRespDesc());
            }
            if (StringUtils.isBlank((String)fscCfcUniteParamQryListDetailExternalRspBO.getReqSign())) {
                throw new FscBusinessException("191031", "\u67e5\u8be2\u914d\u7f6e\u4e2d\u5fc3[operinvoice_sign]\u8fd4\u56de[reqSign]\u4e3a\u7a7a");
            }
            return "0".equals(fscCfcUniteParamQryListDetailExternalRspBO.getReqSign());
        }
        return false;
    }

    private boolean needInvoiceInfos() {
        FscCfcUniteParamQryListDetailExternalReqBO fscCfcUniteParamQryListDetailExternalReqBO = new FscCfcUniteParamQryListDetailExternalReqBO();
        fscCfcUniteParamQryListDetailExternalReqBO.setParamCode("invoice_upload_details_2");
        FscCfcUniteParamQryListDetailExternalRspBO fscCfcUniteParamQryListDetailExternalRspBO = this.fscCfcUniteParamQryListDetailExternalService.qryListDetail(fscCfcUniteParamQryListDetailExternalReqBO);
        if (!"0000".equals(fscCfcUniteParamQryListDetailExternalRspBO.getRespCode())) {
            throw new FscBusinessException("191031", fscCfcUniteParamQryListDetailExternalRspBO.getRespDesc());
        }
        if (!org.apache.commons.lang3.StringUtils.isBlank((CharSequence)fscCfcUniteParamQryListDetailExternalRspBO.getReqDetailed())) {
            String reqDetailed = fscCfcUniteParamQryListDetailExternalRspBO.getReqDetailed();
            return !"0".equals(reqDetailed);
        }
        return true;
    }

    private void val(FscGetInvoiceDataAbilityReqBO reqBO) {
        if (null == reqBO.getFscOrderId()) {
            throw new FscBusinessException("191000", "\u5165\u53c2[fscOrderId]\u4e3a\u7a7a");
        }
        if (null == reqBO.getSupplierId()) {
            throw new FscBusinessException("191000", "\u5165\u53c2[supplierId]\u4e3a\u7a7a");
        }
        if (null == reqBO.getReceiveType()) {
            throw new FscBusinessException("191000", "\u5165\u53c2[receiveType]\u4e3a\u7a7a");
        }
        if (null == reqBO.getMakeType()) {
            throw new FscBusinessException("191000", "\u5165\u53c2[makeType]\u4e3a\u7a7a");
        }
    }

    private FscInvoiceInfoBO createEntity(FscGetInvoiceInfoListRspBO fscGetInvoiceInfoListRspBO, FscGetInvoiceDataAbilityReqBO reqBO, FscOrderInvoicePO fscOrderInvoicePo, List<FscOrderItemPO> fscOrderItemPos) {
        SimpleDateFormat simpleDateFormat = new SimpleDateFormat("yyyy-MM-dd");
        FscInvoiceInfoBO fscInvoiceInfoBO = new FscInvoiceInfoBO();
        ArrayList invoiceItemBOList = new ArrayList();
        if (!this.needInvoiceInfos()) {
            fscOrderItemPos.forEach(fscOrderItemPo -> {
                InvoiceItemBO invoiceItemBO = new InvoiceItemBO();
                invoiceItemBO.setFscOrderId(fscOrderItemPo.getFscOrderId());
                invoiceItemBO.setAcceptOrderId(fscOrderItemPo.getAcceptOrderId());
                invoiceItemBO.setOrderId(fscOrderItemPo.getOrderId());
                invoiceItemBO.setOrderItemId(fscOrderItemPo.getOrderItemId());
                invoiceItemBO.setSkuId(fscOrderItemPo.getSkuId());
                invoiceItemBO.setSkuName(fscOrderItemPo.getSkuName());
                invoiceItemBO.setSpec(fscOrderItemPo.getSpec());
                invoiceItemBO.setModel(fscOrderItemPo.getModel());
                invoiceItemBO.setPrice(fscOrderItemPo.getPrice());
                invoiceItemBO.setTaxAmt(fscOrderItemPo.getTaxAmt());
                invoiceItemBO.setUnit(fscOrderItemPo.getUnit());
                invoiceItemBO.setTaxCode(fscOrderItemPo.getTaxCode());
                invoiceItemBO.setNum(fscOrderItemPo.getNum());
                invoiceItemBO.setAmt(fscOrderItemPo.getAmt());
                invoiceItemBO.setUntaxAmt(fscOrderItemPo.getUntaxAmt());
                invoiceItemBOList.add(invoiceItemBO);
            });
        } else {
            FscGetInvoiceInfoItemReqBO fscGetInvoiceInfoItemReqBO = new FscGetInvoiceInfoItemReqBO();
            if (!this.fullElecId.contains(String.valueOf(reqBO.getSupplierId())) || !FscConstants.FscElecInvoiceType.FULL_ELEC.equals(fscGetInvoiceInfoListRspBO.getInvoiceType()) && !FscConstants.FscElecInvoiceType.FULL_ORDINARY.equals(fscGetInvoiceInfoListRspBO.getInvoiceType())) {
                fscGetInvoiceInfoItemReqBO.setInvoiceCode(fscGetInvoiceInfoListRspBO.getInvoiceCode());
            }
            fscGetInvoiceInfoItemReqBO.setInvoiceId(fscGetInvoiceInfoListRspBO.getInvoiceId());
            fscGetInvoiceInfoItemReqBO.setSupplierId(String.valueOf(reqBO.getSupplierId()));
            fscGetInvoiceInfoItemReqBO.setProOrgId(String.valueOf(reqBO.getProOrgId()));
            FscOrderRelationPO relationQueryVo = new FscOrderRelationPO();
            relationQueryVo.setFscOrderId(reqBO.getFscOrderId());
            List relationList = this.fscOrderRelationMapper.getList(relationQueryVo);
            HashMap<Long, String> orderIdMap = new HashMap<Long, String>();
            for (FscOrderRelationPO fscOrderRelationPO : relationList) {
                orderIdMap.computeIfAbsent(fscOrderRelationPO.getOrderId(), k -> fscOrderRelationPO.getExtOrderNo());
            }
            FscGetInvoiceInfoItemRspBO invoiceInfoItem = this.fscGetInvoiceInfoItemExternalService.getInvoiceInfoItem(fscGetInvoiceInfoItemReqBO);
            if (!"0000".equals(invoiceInfoItem.getRespCode())) {
                throw new FscBusinessException("191031", invoiceInfoItem.getRespDesc());
            }
            List skuEntity = null;
            skuEntity = this.JD_SUPPLIER_ID.equals(reqBO.getSupplierId()) || this.jdIdFl.equals(reqBO.getSupplierId()) ? invoiceInfoItem.getResult().getSkuDetails() : invoiceInfoItem.getResult().getSkuEntity();
            if (CollectionUtils.isEmpty((Collection)skuEntity)) {
                throw new FscBusinessException("198888", "\u8bf7\u6c42ESB\u83b7\u53d6\u7535\u5546\u5f00\u7968\u660e\u7ec6\u6570\u636e\u63a5\u53e3\u53d1\u7968\u660e\u7ec6\u8fd4\u56de\u4e3a\u7a7a");
            }
            HashMap<String, FscGetInvoiceInfoItemSkuRspBO> extInvoiceItemMap = new HashMap<String, FscGetInvoiceInfoItemSkuRspBO>();
            for (FscGetInvoiceInfoItemSkuRspBO fscGetInvoiceInfoItemSkuRspBO2 : skuEntity) {
                String key = "1";
                key = this.JD_SUPPLIER_ID.equals(reqBO.getSupplierId()) || this.jdIdFl.equals(reqBO.getSupplierId()) ? fscGetInvoiceInfoItemSkuRspBO2.getExtSkuId() + fscGetInvoiceInfoItemSkuRspBO2.getJdOrderId() : fscGetInvoiceInfoItemSkuRspBO2.getExtSkuId() + fscGetInvoiceInfoItemSkuRspBO2.getEOrderId();
                log.debug(key);
                extInvoiceItemMap.putIfAbsent(key, fscGetInvoiceInfoItemSkuRspBO2);
            }
            HashMap<String, FscOrderItemPO> fscOrderItemMap = new HashMap<String, FscOrderItemPO>();
            for (FscOrderItemPO fscOrderItemPo2 : fscOrderItemPos) {
                String key = "1";
                if (this.JD_SUPPLIER_ID.equals(reqBO.getSupplierId()) || this.jdIdFl.equals(reqBO.getSupplierId()) || this.snIdFl.equals(reqBO.getSupplierId()) || this.SN_SUPPLIER_ID.equals(reqBO.getSupplierId())) {
                    if (orderIdMap.get(fscOrderItemPo2.getOrderId()) == null) {
                        throw new FscBusinessException("190000", "\u8ba2\u5355\u660e\u7ec6\u672a\u67e5\u8be2\u5230\u5916\u90e8\u7535\u5546\u8ba2\u5355\u53f7\uff01");
                    }
                    key = fscOrderItemPo2.getSkuIdExt() + (String)orderIdMap.get(fscOrderItemPo2.getOrderId());
                } else {
                    key = fscOrderItemPo2.getSkuIdExt() + fscOrderItemPo2.getOrderId().toString();
                }
                if (fscOrderItemMap.get(key) != null) continue;
                fscOrderItemMap.put(key, fscOrderItemPo2);
            }
            skuEntity.forEach(fscGetInvoiceInfoItemSkuRspBO -> {
                InvoiceItemBO invoiceItemBO = new InvoiceItemBO();
                String key = "1";
                if (this.JD_SUPPLIER_ID.equals(reqBO.getSupplierId()) || this.jdIdFl.equals(reqBO.getSupplierId())) {
                    key = fscGetInvoiceInfoItemSkuRspBO.getExtSkuId() + fscGetInvoiceInfoItemSkuRspBO.getJdOrderId();
                    if (fscOrderItemMap.get(key) == null) {
                        throw new FscBusinessException("191000", "\u53d1\u7968\u660e\u7ec6\u884c[" + fscGetInvoiceInfoItemSkuRspBO.getExtSkuId() + "-" + fscGetInvoiceInfoItemSkuRspBO.getJdOrderId() + "]\u65e0\u5339\u914d\u660e\u7ec6\u4fe1\u606f\uff01");
                    }
                } else {
                    key = fscGetInvoiceInfoItemSkuRspBO.getExtSkuId() + fscGetInvoiceInfoItemSkuRspBO.getEOrderId();
                    if (fscOrderItemMap.get(key) == null) {
                        throw new FscBusinessException("191000", "\u53d1\u7968\u660e\u7ec6\u884c[" + fscGetInvoiceInfoItemSkuRspBO.getExtSkuId() + "-" + fscGetInvoiceInfoItemSkuRspBO.getEOrderId() + "]\u65e0\u5339\u914d\u660e\u7ec6\u4fe1\u606f\uff01");
                    }
                }
                invoiceItemBO.setFscOrderId(((FscOrderItemPO)fscOrderItemMap.get(key)).getFscOrderId());
                invoiceItemBO.setAcceptOrderId(((FscOrderItemPO)fscOrderItemMap.get(key)).getAcceptOrderId());
                invoiceItemBO.setOrderId(((FscOrderItemPO)fscOrderItemMap.get(key)).getOrderId());
                invoiceItemBO.setOrderItemId(((FscOrderItemPO)fscOrderItemMap.get(key)).getOrderItemId());
                invoiceItemBO.setSkuId(((FscOrderItemPO)fscOrderItemMap.get(key)).getSkuId());
                invoiceItemBO.setSkuName(((FscOrderItemPO)fscOrderItemMap.get(key)).getSkuName());
                invoiceItemBO.setSpec(((FscOrderItemPO)fscOrderItemMap.get(key)).getSpec());
                invoiceItemBO.setModel(((FscOrderItemPO)fscOrderItemMap.get(key)).getModel());
                invoiceItemBO.setPrice(((FscOrderItemPO)fscOrderItemMap.get(key)).getPrice());
                if (invoiceItemBO.getTaxRate() == null) {
                    invoiceItemBO.setTaxRate(((FscOrderItemPO)fscOrderItemMap.get(key)).getTaxRate());
                }
                invoiceItemBO.setTaxAmt(this.dealPrice(fscGetInvoiceInfoItemSkuRspBO.getTaxAmount()));
                invoiceItemBO.setUnit(fscGetInvoiceInfoItemSkuRspBO.getSettleUnit());
                invoiceItemBO.setTaxCode(fscGetInvoiceInfoItemSkuRspBO.getTaxId());
                invoiceItemBO.setNum(fscGetInvoiceInfoItemSkuRspBO.getNum());
                invoiceItemBO.setAmt(fscGetInvoiceInfoItemSkuRspBO.getAmount());
                invoiceItemBO.setUntaxAmt(this.dealPrice(fscGetInvoiceInfoItemSkuRspBO.getAmountUnTax()).compareTo(BigDecimal.ZERO) == 0 ? invoiceItemBO.getAmt() : fscGetInvoiceInfoItemSkuRspBO.getAmountUnTax());
                invoiceItemBOList.add(invoiceItemBO);
            });
        }
        fscInvoiceInfoBO.setInvoiceItemBOS(invoiceItemBOList);
        fscInvoiceInfoBO.setFscOrderId(reqBO.getFscOrderId());
        fscInvoiceInfoBO.setInvoiceType(fscOrderInvoicePo.getInvoiceType());
        fscInvoiceInfoBO.setInvoiceCategory(fscOrderInvoicePo.getInvoiceCategory());
        fscInvoiceInfoBO.setCreateTime(fscOrderInvoicePo.getBillTime());
        fscInvoiceInfoBO.setCreateOperId(fscOrderInvoicePo.getBillOperId());
        fscInvoiceInfoBO.setCreateOperName(fscOrderInvoicePo.getBillOperName());
        fscInvoiceInfoBO.setBank(fscGetInvoiceInfoListRspBO.getBank());
        if (FscConstants.FscElecInvoiceType.FULL_ELEC.equals(fscGetInvoiceInfoListRspBO.getInvoiceType()) || FscConstants.FscElecInvoiceType.FULL_ORDINARY.equals(fscGetInvoiceInfoListRspBO.getInvoiceType())) {
            String invoiceId = fscGetInvoiceInfoListRspBO.getInvoiceId();
            fscInvoiceInfoBO.setFullElecNo(invoiceId);
            if (invoiceId.length() > 8) {
                int splitIndex = invoiceId.length() - 8;
                fscInvoiceInfoBO.setInvoiceCode(invoiceId.substring(0, splitIndex));
                fscInvoiceInfoBO.setInvoiceNo(invoiceId.substring(splitIndex));
            }
            fscInvoiceInfoBO.setInvoiceCategory(Integer.valueOf(3));
        } else {
            fscInvoiceInfoBO.setInvoiceCode(fscGetInvoiceInfoListRspBO.getInvoiceCode());
            fscInvoiceInfoBO.setInvoiceNo(fscGetInvoiceInfoListRspBO.getInvoiceId());
        }
        fscInvoiceInfoBO.setBillDate(simpleDateFormat.format(fscGetInvoiceInfoListRspBO.getInvoiceDate()));
        fscInvoiceInfoBO.setUntaxAmt(this.dealPrice(fscGetInvoiceInfoListRspBO.getInvoiceNakedAmount()).compareTo(BigDecimal.ZERO) == 0 ? fscGetInvoiceInfoListRspBO.getInvoiceTaxAmount() : fscGetInvoiceInfoListRspBO.getInvoiceNakedAmount());
        fscInvoiceInfoBO.setTax(fscGetInvoiceInfoListRspBO.getInvoiceTaxRate());
        fscInvoiceInfoBO.setTaxAmt(this.dealPrice(fscGetInvoiceInfoListRspBO.getInvoiceTaxAmount()));
        fscInvoiceInfoBO.setAmt(fscGetInvoiceInfoListRspBO.getInvoiceAmount());
        fscInvoiceInfoBO.setBuyName(fscGetInvoiceInfoListRspBO.getTitle());
        fscInvoiceInfoBO.setTaxNo(fscGetInvoiceInfoListRspBO.getEnterpriseTaxpayer());
        fscInvoiceInfoBO.setAddress(fscGetInvoiceInfoListRspBO.getAddress());
        fscInvoiceInfoBO.setPhone(fscGetInvoiceInfoListRspBO.getTel());
        fscInvoiceInfoBO.setAccount(fscGetInvoiceInfoListRspBO.getAccount());
        if (!StringUtils.isBlank((String)fscGetInvoiceInfoListRspBO.getFileUrl())) {
            ArrayList<AttachmentBO> attachmentBos = new ArrayList<AttachmentBO>();
            AttachmentBO attachmentBo = new AttachmentBO();
            attachmentBo.setAttachmentType(FscConstants.AttachmentType.INVOICE);
            attachmentBo.setAttachmentUrl(fscGetInvoiceInfoListRspBO.getFileUrl());
            attachmentBos.add(attachmentBo);
            if (!StringUtils.isBlank((String)fscGetInvoiceInfoListRspBO.getXmlSourceFileUrl())) {
                AttachmentBO xmlAttachmentBo = new AttachmentBO();
                xmlAttachmentBo.setAttachmentType(FscConstants.AttachmentType.INVOICE);
                xmlAttachmentBo.setAttachmentUrl(fscGetInvoiceInfoListRspBO.getXmlSourceFileUrl());
                attachmentBos.add(xmlAttachmentBo);
            }
            if (!StringUtils.isBlank((String)fscGetInvoiceInfoListRspBO.getOfdFileUrl())) {
                AttachmentBO odfAttachmentBo = new AttachmentBO();
                odfAttachmentBo.setAttachmentType(FscConstants.AttachmentType.INVOICE);
                odfAttachmentBo.setAttachmentUrl(fscGetInvoiceInfoListRspBO.getOfdFileUrl());
                attachmentBos.add(odfAttachmentBo);
            }
            fscInvoiceInfoBO.setAttachmentList(attachmentBos);
        }
        return fscInvoiceInfoBO;
    }

    private void sendMq(FscGetInvoiceDataAbilityReqBO reqBO) {
        FscComOrderListSyncAbilityReqBO fscComOrderListSyncAbilityReqBO = new FscComOrderListSyncAbilityReqBO();
        fscComOrderListSyncAbilityReqBO.setFscOrderId(reqBO.getFscOrderId());
        this.fscComOrderSyncAbilityService.dealComOrderSyncEs(fscComOrderListSyncAbilityReqBO);
        FscComInvoiceDeleteSyncAbilityReqBO fscComInvoiceDeleteSyncAbilityReqBO = new FscComInvoiceDeleteSyncAbilityReqBO();
        fscComInvoiceDeleteSyncAbilityReqBO.setFscOrderId(reqBO.getFscOrderId());
        this.fscComInvoiceDeleteSyncAbilityService.deleteComInvoiceSyncEs(fscComInvoiceDeleteSyncAbilityReqBO);
        FscComInvoiceListSyncAbilityReqBO fscComInvoiceListSyncAbilityReqBO = new FscComInvoiceListSyncAbilityReqBO();
        fscComInvoiceListSyncAbilityReqBO.setFscOrderId(reqBO.getFscOrderId());
        this.fscComInvoiceSyncAbilityService.dealComOrderSyncEs(fscComInvoiceListSyncAbilityReqBO);
        if (FscConstants.FscOrderMakeType.OPERTION.equals(reqBO.getMakeType())) {
            FscBillMailListSyncAbilityReqBO fscBillMailListSyncAbilityReqBO = new FscBillMailListSyncAbilityReqBO();
            fscBillMailListSyncAbilityReqBO.setFscOrderId(reqBO.getFscOrderId());
            this.fscBillMailSyncAbilityService.syncBillMail(fscBillMailListSyncAbilityReqBO);
        }
    }

    private void updateOrderDesc(Long fscOrderId) {
        FscBillOrderDescUpdateBusiReqBO fscBillOrderDescUpdateBusiReqBO = new FscBillOrderDescUpdateBusiReqBO();
        fscBillOrderDescUpdateBusiReqBO.setFscOrderId(fscOrderId);
        fscBillOrderDescUpdateBusiReqBO.setSuccessRetransFlag("1");
        this.fscBillOrderDescUpdateBusiService.dealOrderDesc(fscBillOrderDescUpdateBusiReqBO);
    }

    private BigDecimal dealPrice(BigDecimal b) {
        if (b == null || b.compareTo(BigDecimal.ZERO) == 0) {
            return new BigDecimal("0.00");
        }
        return b;
    }
}

