/*
 * Decompiled with CFR 0.152.
 */
package com.tydic.fsc.bill.ability.impl;

import com.alibaba.fastjson.JSONObject;
import com.tydic.fsc.bill.ability.api.FscBillGetYcPersonInfoAbilityService;
import com.tydic.fsc.bill.ability.api.FscMemInvoiceCreateAbilityService;
import com.tydic.fsc.bill.ability.bo.FscBillGetYcPersonInfoAbilityBO;
import com.tydic.fsc.bill.ability.bo.FscBillGetYcPersonInfoAbilityReqBO;
import com.tydic.fsc.bill.ability.bo.FscBillGetYcPersonInfoAbilityRspBO;
import com.tydic.fsc.bill.ability.bo.FscMemInvoiceCreateAbilityReqBO;
import com.tydic.fsc.bill.ability.bo.FscMemInvoiceCreateAbilityRspBO;
import com.tydic.fsc.bill.busi.api.FscMemInvoiceCreateBusiService;
import com.tydic.fsc.bill.busi.api.FscPushYcMemInvoiceBusiService;
import com.tydic.fsc.bill.busi.bo.FscMemInvoiceCreateBusiReqBO;
import com.tydic.fsc.bill.busi.bo.FscMemInvoiceCreateBusiRspBO;
import com.tydic.fsc.bill.busi.bo.FscPushYcMemInvoiceBusiReqBO;
import com.tydic.fsc.common.ability.api.FscComOrderSyncAbilityService;
import com.tydic.fsc.common.ability.bo.FscComOrderListSyncAbilityReqBO;
import com.tydic.fsc.constants.FscBillInvoiceSerial;
import com.tydic.fsc.constants.FscConstants;
import com.tydic.fsc.constants.FscOrderFlowEnum;
import com.tydic.fsc.constants.FscOrderFlowProcKeyEnum;
import com.tydic.fsc.dao.FscInvoiceCheckMapper;
import com.tydic.fsc.dao.FscMemPayInfoMapper;
import com.tydic.fsc.dao.FscOrderMapper;
import com.tydic.fsc.dao.FscOrderRelationMapper;
import com.tydic.fsc.exception.FscBusinessException;
import com.tydic.fsc.po.FscInvoiceCheckPO;
import com.tydic.fsc.po.FscMemPayInfoPO;
import com.tydic.fsc.po.FscOrderInvoicePO;
import com.tydic.fsc.po.FscOrderItemPO;
import com.tydic.fsc.po.FscOrderPO;
import com.tydic.fsc.po.FscOrderRelationPO;
import com.tydic.fsc.util.FscDuplicateCommitLimit;
import com.tydic.fsc.util.TaxUtils;
import com.tydic.fsc.utils.MD5Util;
import com.tydic.plugin.encoded.service.CfcEncodedSerialGetService;
import com.tydic.plugin.encoded.service.bo.CfcEncodedSerialGetServiceReqBO;
import com.tydic.plugin.encoded.service.bo.CfcEncodedSerialGetServiceRspBO;
import java.math.BigDecimal;
import java.util.Collection;
import java.util.Date;
import java.util.List;
import org.apache.commons.lang3.StringUtils;
import org.springframework.beans.factory.annotation.Autowired;
import org.springframework.beans.factory.annotation.Value;
import org.springframework.util.CollectionUtils;
import org.springframework.web.bind.annotation.PostMapping;
import org.springframework.web.bind.annotation.RequestBody;
import org.springframework.web.bind.annotation.RequestMapping;
import org.springframework.web.bind.annotation.RestController;

@RestController
@RequestMapping(value={"FSC_GROUP_DEV/1.0.0/com.tydic.fsc.bill.ability.api.FscMemInvoiceCreateAbilityService"})
public class FscMemInvoiceCreateAbilityServiceImpl
implements FscMemInvoiceCreateAbilityService {
    @Autowired
    private FscMemInvoiceCreateBusiService fscMemInvoiceCreateBusiService;
    @Autowired
    private CfcEncodedSerialGetService encodedSerialGetService;
    @Autowired
    private FscOrderMapper fscOrderMapper;
    @Autowired
    private FscMemPayInfoMapper fscMemPayInfoMapper;
    @Autowired
    private FscOrderRelationMapper fscOrderRelationMapper;
    @Autowired
    private FscComOrderSyncAbilityService fscComOrderSyncAbilityService;
    @Autowired
    private FscInvoiceCheckMapper fscInvoiceCheckMapper;
    @Autowired
    private FscPushYcMemInvoiceBusiService fscPushYcMemInvoiceBusiService;
    @Autowired
    private FscBillGetYcPersonInfoAbilityService fscBillGetYcPersonInfoAbilityService;
    @Value(value="${fsc.member.invoice.user:10228059}")
    private String userName;
    @Value(value="${fsc.member.invoice.agentAccount:10228059}")
    private String agentAccount;
    @Value(value="${fsc.member.invoice.taxCode:3040600000000000000}")
    private String taxCode;
    @Value(value="${fsc.member.invoice.taxRate:0.06}")
    private BigDecimal taxRate;
    @Value(value="${fsc.member.invoice.orderName:\u5e73\u53f0\u670d\u52a1\u8d39}")
    private String orderName;
    @Value(value="${OPERATION_ORG_ID:1000000074}")
    private Long operationOrgId;

    @FscDuplicateCommitLimit
    @PostMapping(value={"dealMemInvoiceCreate"})
    public FscMemInvoiceCreateAbilityRspBO dealMemInvoiceCreate(@RequestBody FscMemInvoiceCreateAbilityReqBO reqBO) {
        FscMemInvoiceCreateAbilityRspBO rspBO = new FscMemInvoiceCreateAbilityRspBO();
        StringBuilder sb = new StringBuilder();
        this.valid(reqBO, sb);
        if (!StringUtils.isEmpty((CharSequence)sb.toString())) {
            rspBO.setRespCode("198888");
            rspBO.setRespDesc(sb.toString());
        }
        FscOrderPO payPo = new FscOrderPO();
        payPo.setFscOrderId(reqBO.getFscOrderId());
        payPo = this.fscOrderMapper.getModelBy(payPo);
        if (payPo == null) {
            throw new FscBusinessException("198888", "\u672a\u67e5\u8be2\u5230\u4ed8\u6b3e\u5355\u4fe1\u606f");
        }
        if (!payPo.getOrderState().equals(FscConstants.FscInvoiceOrderState.UNBILLED)) {
            throw new FscBusinessException("198888", "\u53ea\u6709\u5f85\u5f00\u7968\u72b6\u6001\u5141\u8bb8\u5f00\u7968\uff01");
        }
        FscMemPayInfoPO payInfoPo = new FscMemPayInfoPO();
        payInfoPo.setFscOrderId(reqBO.getFscOrderId());
        payInfoPo = this.fscMemPayInfoMapper.getModelBy(payInfoPo);
        this.check(reqBO.getFscOrderId());
        List<String> serial = this.getSerial(FscBillInvoiceSerial.MEMBER_FEE_ORDER_NO.getCode(), 1);
        FscOrderPO orderPo = this.buildFscOrderInfo(serial, payPo, payInfoPo, reqBO);
        FscOrderItemPO itemPo = this.buildFscOrderItemInfo(payPo, payInfoPo);
        FscOrderInvoicePO orderInvoicePo = this.buildFscOrderInvoiceInfo(reqBO, payPo.getPayeeId());
        FscOrderRelationPO orderRelationPo = this.buildFscOrderRelationInfo(payPo, payInfoPo);
        FscMemInvoiceCreateBusiReqBO busiReqBO = new FscMemInvoiceCreateBusiReqBO();
        busiReqBO.setFscOrderPO(orderPo);
        busiReqBO.setFscOrderItemPO(itemPo);
        busiReqBO.setFscOrderInvoicePO(orderInvoicePo);
        busiReqBO.setFscOrderRelationPO(orderRelationPo);
        String invoiceOrderId = MD5Util.MD5Encode((String)JSONObject.toJSONString((Object)payPo.getFscOrderId()), null);
        try {
            FscInvoiceCheckPO invoiceCheckPO = new FscInvoiceCheckPO();
            invoiceCheckPO.setOrderId(invoiceOrderId);
            invoiceCheckPO.setReceiveType(FscConstants.FscOrderReceiveType.SUPPLIER);
            invoiceCheckPO.setCreateTime(new Date());
            invoiceCheckPO.setCreateUserId(reqBO.getUserId());
            int count = this.fscInvoiceCheckMapper.insert(invoiceCheckPO);
            if (count <= 0) {
                throw new FscBusinessException("198888", "\u63d2\u5165\u6570\u636e\u5931\u8d25\uff01");
            }
        }
        catch (Exception e) {
            e.printStackTrace();
            throw new FscBusinessException("198888", "\u5f53\u524d\u7cfb\u7edf\u5904\u7406\u7e41\u5fd9,\u8bf7\u7a0d\u540e\u518d\u8bd5\uff01");
        }
        FscMemInvoiceCreateBusiRspBO busiRspBO = this.fscMemInvoiceCreateBusiService.dealMemInvoiceCreate(busiReqBO);
        this.fscInvoiceCheckMapper.deleteByIdAndType(invoiceOrderId, FscConstants.FscOrderReceiveType.SUPPLIER);
        if (busiRspBO.getFscOrderId() != null) {
            FscPushYcMemInvoiceBusiReqBO memInvoiceBusiReqBO = new FscPushYcMemInvoiceBusiReqBO();
            memInvoiceBusiReqBO.setOrderId(busiRspBO.getFscOrderId());
            memInvoiceBusiReqBO.setAgentAccount(this.agentAccount);
            this.fscPushYcMemInvoiceBusiService.dealPushMemInvoice(memInvoiceBusiReqBO);
            this.sendMq(busiRspBO.getFscOrderId());
        }
        return (FscMemInvoiceCreateAbilityRspBO)JSONObject.parseObject((String)JSONObject.toJSONString((Object)((Object)busiRspBO)), FscMemInvoiceCreateAbilityRspBO.class);
    }

    private FscOrderRelationPO buildFscOrderRelationInfo(FscOrderPO payPo, FscMemPayInfoPO payInfoPo) {
        FscOrderRelationPO relationPO = new FscOrderRelationPO();
        relationPO.setOrderId(payPo.getFscOrderId());
        relationPO.setOrderNo(payPo.getOrderNo());
        relationPO.setAcceptOrderId(payInfoPo.getMemId());
        return relationPO;
    }

    private FscOrderInvoicePO buildFscOrderInvoiceInfo(FscMemInvoiceCreateAbilityReqBO reqBO, Long payeeId) {
        FscOrderInvoicePO orderInvoicePo = new FscOrderInvoicePO();
        orderInvoicePo.setBuyName(reqBO.getBuyName());
        orderInvoicePo.setInvoiceType(reqBO.getInvoiceType());
        if (this.operationOrgId.equals(payeeId)) {
            orderInvoicePo.setInvoiceCategory(FscConstants.FscInvoiceCategory.FULL);
        } else {
            orderInvoicePo.setInvoiceCategory(Integer.valueOf(reqBO.getInvoiceCategory()));
        }
        orderInvoicePo.setTaxNo(reqBO.getTaxNo());
        orderInvoicePo.setBank(reqBO.getBank());
        orderInvoicePo.setAccount(reqBO.getAccount());
        orderInvoicePo.setAddress(reqBO.getAddress());
        orderInvoicePo.setPhone(reqBO.getPhone());
        orderInvoicePo.setInvoiceId(reqBO.getInvoiceId());
        return orderInvoicePo;
    }

    private void check(Long orderId) {
        FscOrderRelationPO relationPO = new FscOrderRelationPO();
        relationPO.setOrderId(orderId);
        relationPO.setOrderBy("id desc");
        relationPO.setFscFlag("1");
        List list = this.fscOrderRelationMapper.getList(relationPO);
        if (!CollectionUtils.isEmpty((Collection)list) && !FscConstants.FscInvoiceOrderState.REFUND.equals(((FscOrderRelationPO)list.get(0)).getOrderState())) {
            throw new FscBusinessException("198888", "\u8be5\u4f1a\u5458\u8d39\u5df2\u53d1\u8d77\u7ed3\u7b97\uff0c\u8bf7\u52ff\u91cd\u590d\u53d1\u8d77\uff01");
        }
    }

    private FscOrderItemPO buildFscOrderItemInfo(FscOrderPO payPo, FscMemPayInfoPO payInfoPo) {
        FscOrderItemPO itemPo = new FscOrderItemPO();
        itemPo.setSkuName("\u5e73\u53f0\u670d\u52a1\u8d39");
        itemPo.setUnit("\u5e74");
        itemPo.setNum(new BigDecimal(payInfoPo.getMemCycle()));
        itemPo.setOrderId(payPo.getFscOrderId());
        itemPo.setOrderCode(payPo.getOrderNo());
        itemPo.setAmt(payPo.getTotalCharge());
        itemPo.setPrice(payInfoPo.getPrice());
        itemPo.setPurchaseAmt(payPo.getTotalCharge());
        itemPo.setPurchasePrice(payInfoPo.getPrice());
        itemPo.setOrderItemId(payInfoPo.getMemId());
        itemPo.setAcceptOrderId(payInfoPo.getMemId());
        itemPo.setTaxCode(this.taxCode);
        itemPo.setTaxRate(this.taxRate);
        itemPo.setTaxAmt(TaxUtils.calTaxAmt((BigDecimal)payPo.getTotalCharge(), (BigDecimal)this.taxRate, (Integer)2));
        itemPo.setUntaxAmt(payPo.getTotalCharge().subtract(itemPo.getTaxAmt()));
        itemPo.setPurchaseUntaxAmt(payPo.getTotalCharge().subtract(itemPo.getTaxAmt()));
        itemPo.setSkuId(Long.valueOf(0L));
        return itemPo;
    }

    private FscOrderPO buildFscOrderInfo(List<String> serial, FscOrderPO payPo, FscMemPayInfoPO payInfoPo, FscMemInvoiceCreateAbilityReqBO reqBO) {
        FscOrderPO invoicePo = new FscOrderPO();
        invoicePo.setMakeType(FscConstants.FscOrderMakeType.OPERTION);
        invoicePo.setReceiveType(FscConstants.FscOrderReceiveType.SUPPLIER);
        invoicePo.setOrderFlow(FscOrderFlowEnum.MEMBER_FEE_INVOICE.getCode());
        invoicePo.setOrderFlowKey(FscOrderFlowProcKeyEnum.getInstance((String)invoicePo.getOrderFlow().toString()).getDescr());
        invoicePo.setOrderNo(serial.get(0));
        invoicePo.setPayerId(payPo.getPayerId());
        invoicePo.setPayerName(payPo.getPayerName());
        invoicePo.setPurchaserId(payPo.getPayerId());
        invoicePo.setPurchaserName(payPo.getPayerName());
        invoicePo.setPayeeId(payPo.getPayeeId());
        invoicePo.setPayeeName(payPo.getPayeeName());
        invoicePo.setSupplierId(payPo.getSupplierId());
        invoicePo.setSupplierName(payPo.getSupplierName());
        invoicePo.setTotalCharge(payPo.getTotalCharge());
        invoicePo.setProOrgId(payPo.getProOrgId());
        invoicePo.setCreateTime(new Date());
        invoicePo.setUpdateTime(new Date());
        invoicePo.setCreateOperId(reqBO.getUserId());
        invoicePo.setCreateOperName(reqBO.getUserName());
        invoicePo.setCreateCompanyId(reqBO.getCompanyId());
        invoicePo.setCreateCompanyName(reqBO.getCompanyName());
        invoicePo.setCreateOrgId(reqBO.getOrgId());
        invoicePo.setCreateOrgName(reqBO.getOrgName());
        invoicePo.setCreateOperNo(reqBO.getUserName());
        invoicePo.setOrderName(this.orderName);
        FscBillGetYcPersonInfoAbilityReqBO personInfoAbilityReqBO = new FscBillGetYcPersonInfoAbilityReqBO();
        personInfoAbilityReqBO.setUserName(this.userName);
        personInfoAbilityReqBO.setAgentAccount(this.agentAccount);
        FscBillGetYcPersonInfoAbilityRspBO personInfo = this.fscBillGetYcPersonInfoAbilityService.getPersonInfo(personInfoAbilityReqBO);
        if (!"0000".equals(personInfo.getRespCode()) || CollectionUtils.isEmpty((Collection)personInfo.getRows())) {
            throw new FscBusinessException("193201", personInfo.getRespDesc());
        }
        invoicePo.setYcUserId(((FscBillGetYcPersonInfoAbilityBO)personInfo.getRows().get(0)).getUserId().toString());
        invoicePo.setYcUserName(((FscBillGetYcPersonInfoAbilityBO)personInfo.getRows().get(0)).getPersonName());
        invoicePo.setYcDeptId(((FscBillGetYcPersonInfoAbilityBO)personInfo.getRows().get(0)).getDeptId().toString());
        invoicePo.setYcDeptName(((FscBillGetYcPersonInfoAbilityBO)personInfo.getRows().get(0)).getDeptName());
        invoicePo.setOrderType(Integer.valueOf(15));
        return invoicePo;
    }

    private List<String> getSerial(String key, Integer num) {
        CfcEncodedSerialGetServiceReqBO encodedSerialGetServiceReqBO = new CfcEncodedSerialGetServiceReqBO();
        encodedSerialGetServiceReqBO.setCenter("FSC");
        encodedSerialGetServiceReqBO.setOrgType("-1");
        encodedSerialGetServiceReqBO.setEncodedRuleCode(FscBillInvoiceSerial.getInstance((String)key).getDesc());
        encodedSerialGetServiceReqBO.setNum(num);
        CfcEncodedSerialGetServiceRspBO encodedSerialGetServiceRspBO = this.encodedSerialGetService.getEncodedSerial(encodedSerialGetServiceReqBO);
        if (null == encodedSerialGetServiceRspBO || CollectionUtils.isEmpty((Collection)encodedSerialGetServiceRspBO.getSerialNoList()) || StringUtils.isBlank((CharSequence)((CharSequence)encodedSerialGetServiceRspBO.getSerialNoList().get(0)))) {
            throw new FscBusinessException("191014", "\u83b7\u53d6\u914d\u7f6e\u6d41\u6c34\u53f7\u5f02\u5e38");
        }
        return encodedSerialGetServiceRspBO.getSerialNoList();
    }

    private void valid(FscMemInvoiceCreateAbilityReqBO reqBO, StringBuilder sb) {
        if (reqBO.getFscOrderId() == null) {
            throw new FscBusinessException("191000", sb + "\u5165\u53c2[fscOrderId]\u4e3a\u7a7a");
        }
        if (null == reqBO.getReceiveType()) {
            throw new FscBusinessException("191000", sb + "\u5165\u53c2[receiveType]\u4e3a\u7a7a");
        }
        if (null == reqBO.getSupplierId()) {
            throw new FscBusinessException("191000", sb + "\u5165\u53c2[supplierId]\u4e3a\u7a7a");
        }
        if (null == reqBO.getPurchaserId()) {
            throw new FscBusinessException("191000", sb + "\u5165\u53c2[purchaserId]\u4e3a\u7a7a");
        }
        if (null == reqBO.getTaxNo()) {
            throw new FscBusinessException("191000", sb + "\u5165\u53c2[taxNo]\u4e3a\u7a7a");
        }
        if (StringUtils.isEmpty((CharSequence)reqBO.getBuyName())) {
            throw new FscBusinessException("191000", sb + "\u5165\u53c2[buyName]\u4e3a\u7a7a");
        }
        if (null == reqBO.getInvoiceCategory()) {
            throw new FscBusinessException("191000", sb + "\u5165\u53c2[invoiceCategory]\u4e3a\u7a7a");
        }
        if (StringUtils.isEmpty((CharSequence)reqBO.getTaxNo())) {
            throw new FscBusinessException("191000", sb + "\u5165\u53c2[taxNo]\u4e3a\u7a7a");
        }
        if (StringUtils.isEmpty((CharSequence)reqBO.getAddress())) {
            throw new FscBusinessException("191000", sb + "\u5165\u53c2[address]\u4e3a\u7a7a");
        }
        if (StringUtils.isEmpty((CharSequence)reqBO.getPhone())) {
            throw new FscBusinessException("191000", sb + "\u5165\u53c2[phone]\u4e3a\u7a7a");
        }
        if (StringUtils.isEmpty((CharSequence)reqBO.getBank())) {
            throw new FscBusinessException("191000", sb + "\u5165\u53c2[bank]\u4e3a\u7a7a");
        }
        if (StringUtils.isEmpty((CharSequence)reqBO.getAccount())) {
            throw new FscBusinessException("191000", sb + "\u5165\u53c2[account]\u4e3a\u7a7a");
        }
        if (null == reqBO.getInvoiceType()) {
            throw new FscBusinessException("191000", sb + "\u5165\u53c2[invoiceType]\u4e3a\u7a7a");
        }
    }

    private void sendMq(Long orderId) {
        FscComOrderListSyncAbilityReqBO fscComOrderListSyncAbilityReqBO = new FscComOrderListSyncAbilityReqBO();
        fscComOrderListSyncAbilityReqBO.setFscOrderId(orderId);
        this.fscComOrderSyncAbilityService.dealComOrderSyncEs(fscComOrderListSyncAbilityReqBO);
    }
}

