/*
 * Decompiled with CFR 0.152.
 */
package com.tydic.fsc.bill.ability.impl;

import com.alibaba.fastjson.JSON;
import com.ohaotian.plugin.common.util.DateUtils;
import com.ohaotian.plugin.db.Page;
import com.tydic.fsc.bill.ability.api.FscPenaltyOrderQryService;
import com.tydic.fsc.bill.ability.bo.FscQryPenaltyOrderBO;
import com.tydic.fsc.bill.ability.bo.FscQryPenaltyOrderListAbilityReqBO;
import com.tydic.fsc.bill.ability.bo.FscQryPenaltyOrderListAbilityRspBO;
import com.tydic.fsc.dao.FscPenaltyOrderMapper;
import com.tydic.fsc.enums.FscBusiTypeEnum;
import com.tydic.fsc.enums.FscOrderTypeEnum;
import com.tydic.fsc.enums.FscPayNodeEnum;
import com.tydic.fsc.enums.FscPayRuleEnum;
import com.tydic.fsc.enums.FscPenaltyOrderStatusEnum;
import com.tydic.fsc.exception.FscBusinessException;
import com.tydic.fsc.po.FscPenaltyOrderPO;
import java.util.ArrayList;
import java.util.Calendar;
import java.util.Collection;
import java.util.Date;
import java.util.List;
import java.util.Objects;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;
import org.springframework.beans.BeanUtils;
import org.springframework.beans.factory.annotation.Autowired;
import org.springframework.util.CollectionUtils;
import org.springframework.web.bind.annotation.PostMapping;
import org.springframework.web.bind.annotation.RequestBody;
import org.springframework.web.bind.annotation.RequestMapping;
import org.springframework.web.bind.annotation.RestController;

@RestController
@RequestMapping(value={"FSC_GROUP_DEV/1.0.0/com.tydic.fsc.bill.ability.api.FscPenaltyOrderQryService"})
public class FscPenaltyOrderQryServiceImpl
implements FscPenaltyOrderQryService {
    private static final Logger log = LoggerFactory.getLogger(FscPenaltyOrderQryServiceImpl.class);
    @Autowired
    private FscPenaltyOrderMapper fscPenaltyOrderMapper;

    @PostMapping(value={"qryPenaltyOrderList"})
    public FscQryPenaltyOrderListAbilityRspBO qryPenaltyOrderList(@RequestBody FscQryPenaltyOrderListAbilityReqBO reqBO) {
        log.info("\u903e\u671f\u8fdd\u7ea6\u91d1\u5355\u636e\u5217\u8868\u67e5\u8be2\u5165\u53c2" + JSON.toJSONString((Object)reqBO));
        if (null == reqBO) {
            throw new FscBusinessException("191000", "\u5165\u53c2\u4e0d\u80fd\u4e3a\u7a7a");
        }
        if (null == reqBO.getAccountId()) {
            throw new FscBusinessException("191000", "\u8d26\u6237id\u4e0d\u80fd\u4e3a\u7a7a");
        }
        FscQryPenaltyOrderListAbilityRspBO rspBO = new FscQryPenaltyOrderListAbilityRspBO();
        Page page = new Page(reqBO.getPageNo().intValue(), reqBO.getPageSize().intValue());
        FscPenaltyOrderPO po = new FscPenaltyOrderPO();
        BeanUtils.copyProperties((Object)reqBO, (Object)po);
        po.setPayeeId(reqBO.getSupplierId());
        if (null != reqBO.getBusiType() && 4 == reqBO.getBusiType()) {
            po.setOrderType(FscOrderTypeEnum.INDIVIDUAL_SUPERMARKET.getCode());
        }
        List fscPenaltyOrderPOS = this.fscPenaltyOrderMapper.getPageList(po, page);
        ArrayList rows = new ArrayList();
        if (!CollectionUtils.isEmpty((Collection)fscPenaltyOrderPOS)) {
            fscPenaltyOrderPOS.forEach(fscPenaltyOrderPO -> {
                FscQryPenaltyOrderBO bo = new FscQryPenaltyOrderBO();
                BeanUtils.copyProperties((Object)fscPenaltyOrderPO, (Object)bo);
                bo.setPayNodeDesc(Objects.requireNonNull(FscPayNodeEnum.getInstance((Integer)bo.getPayNode())).getCodeDesc());
                bo.setPayRuleDesc(Objects.requireNonNull(FscPayRuleEnum.getInstance((Integer)bo.getPayRule())).getCodeDesc());
                bo.setStatusDesc(Objects.requireNonNull(FscPenaltyOrderStatusEnum.getInstance((String)bo.getStatus())).getCodeDesc());
                bo.setBusiTypeDesc(Objects.requireNonNull(FscBusiTypeEnum.getInstance((String)bo.getBusiType())).getCodeDesc());
                Integer penaltyDays = FscPenaltyOrderQryServiceImpl.daysBetween(bo.getShouldPayDate(), new Date());
                bo.setPenaltyDays(penaltyDays);
                rows.add(bo);
            });
        }
        rspBO.setRespCode("0000");
        rspBO.setRespDesc("\u6210\u529f");
        rspBO.setRows(rows);
        rspBO.setRecordsTotal(Integer.valueOf(page.getTotalCount()));
        rspBO.setTotal(Integer.valueOf(page.getTotalPages()));
        return rspBO;
    }

    public static Integer daysBetween(Date smdate, Date bdate) {
        smdate = DateUtils.strToDate((String)DateUtils.dateToStr((Date)smdate));
        System.out.println(smdate);
        bdate = DateUtils.strToDate((String)DateUtils.dateToStr((Date)bdate));
        System.out.println(bdate);
        Calendar cal = Calendar.getInstance();
        cal.setTime(smdate);
        long time1 = cal.getTimeInMillis();
        cal.setTime(bdate);
        long time2 = cal.getTimeInMillis();
        long between_days = (time2 - time1) / 86400000L;
        return Integer.parseInt(String.valueOf(between_days));
    }
}

