/*
 * Decompiled with CFR 0.152.
 */
package com.tydic.fsc.bill.ability.impl;

import com.alibaba.fastjson.JSONArray;
import com.alibaba.fastjson.JSONObject;
import com.tydic.fsc.bill.ability.api.FscPushNewYcPurSettleChargeAgainstAbilityService;
import com.tydic.fsc.bill.ability.bo.FscPushNewYcPurSettleChargeAgainstAbilityReqBO;
import com.tydic.fsc.bill.ability.bo.FscPushNewYcPurSettleChargeAgainstAbilityRspBO;
import com.tydic.fsc.bill.ability.bo.FscPushNewYcPurSettleChargeBO;
import com.tydic.fsc.bill.ability.bo.FscPushNewYcPurSettleChargeInvoiceBO;
import com.tydic.fsc.bill.ability.bo.FscPushNewYcPurSettleChargeItemBO;
import com.tydic.fsc.bill.busi.api.FscPushNewYcPurSettleChargeAgainstBusiService;
import com.tydic.fsc.bill.busi.bo.FscPushNewYcPurSettleChargeAgainstBusiReqBO;
import com.tydic.fsc.bill.busi.bo.FscPushNewYcPurSettleChargeAgainstBusiRspBO;
import com.tydic.fsc.busibase.external.api.esb.FscUnifySettleRelatedInterfacesAtomService;
import com.tydic.fsc.common.ability.api.FscComRefundSyncAbilityService;
import com.tydic.fsc.common.ability.api.FscDealPushPayRefundStatusAbilityService;
import com.tydic.fsc.common.ability.api.FscPushNewYcPayRefundQueryAbilityService;
import com.tydic.fsc.common.ability.api.FscSyncPushYcAttachmentAbilityService;
import com.tydic.fsc.common.ability.bo.FscComRefundSyncAbilityReqBO;
import com.tydic.fsc.common.ability.bo.FscDealPushPayRefundStatusAbilityReqBO;
import com.tydic.fsc.common.ability.bo.FscDealPushPayRefundStatusAbilityRspBO;
import com.tydic.fsc.common.ability.bo.FscPushNewYcPayRefundQueryAbilityReqBO;
import com.tydic.fsc.common.ability.bo.FscPushNewYcPayRefundQueryAbilityRspBO;
import com.tydic.fsc.common.ability.bo.FscPushYcAttachmentAbilityReqBO;
import com.tydic.fsc.constants.FscConstants;
import com.tydic.fsc.dao.FscDicDictionaryExernalMapper;
import com.tydic.fsc.dao.FscInvoiceMapper;
import com.tydic.fsc.dao.FscInvoicePoolMapper;
import com.tydic.fsc.dao.FscOrderItemMapper;
import com.tydic.fsc.dao.FscOrderMapper;
import com.tydic.fsc.dao.FscOrderRefundMapper;
import com.tydic.fsc.dao.FscOrderRelationMapper;
import com.tydic.fsc.dao.FscRefundShouldAmountMapper;
import com.tydic.fsc.dao.FscShouldPayMapper;
import com.tydic.fsc.exception.FscBusinessException;
import com.tydic.fsc.po.FscDicDictionaryExernalPO;
import com.tydic.fsc.po.FscInvoicePO;
import com.tydic.fsc.po.FscInvoicePoolPO;
import com.tydic.fsc.po.FscOrderItemPO;
import com.tydic.fsc.po.FscOrderPO;
import com.tydic.fsc.po.FscOrderRefundPO;
import com.tydic.fsc.po.FscOrderRelationPO;
import com.tydic.fsc.po.FscShouldPayPO;
import com.tydic.fsc.util.DateUtil;
import com.tydic.fsc.util.FscDuplicateCommitLimit;
import java.math.BigDecimal;
import java.math.RoundingMode;
import java.util.ArrayList;
import java.util.Collection;
import java.util.Collections;
import java.util.Date;
import java.util.HashMap;
import java.util.List;
import java.util.Map;
import java.util.stream.Collectors;
import org.apache.commons.lang3.StringUtils;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;
import org.springframework.beans.factory.annotation.Autowired;
import org.springframework.beans.factory.annotation.Value;
import org.springframework.util.CollectionUtils;
import org.springframework.web.bind.annotation.PostMapping;
import org.springframework.web.bind.annotation.RequestBody;
import org.springframework.web.bind.annotation.RequestMapping;
import org.springframework.web.bind.annotation.RestController;

@RestController
@RequestMapping(value={"FSC_GROUP_DEV/1.0.0/com.tydic.fsc.bill.ability.api.FscPushNewYcPurSettleChargeAgainstAbilityService"})
public class FscPushNewYcPurSettleChargeAgainstAbilityServiceImpl
implements FscPushNewYcPurSettleChargeAgainstAbilityService {
    private static final Logger log = LoggerFactory.getLogger(FscPushNewYcPurSettleChargeAgainstAbilityServiceImpl.class);
    @Autowired
    private FscPushNewYcPayRefundQueryAbilityService fscPushNewYcPayRefundQueryAbilityService;
    @Autowired
    private FscDealPushPayRefundStatusAbilityService fscDealPushPayRefundStatusAbilityService;
    @Autowired
    private FscComRefundSyncAbilityService fscComRefundSyncAbilityService;
    @Autowired
    private FscUnifySettleRelatedInterfacesAtomService fscUnifySettleRelatedInterfacesAtomService;
    @Autowired
    private FscPushNewYcPurSettleChargeAgainstBusiService fscPushNewYcPurSettleChargeAgainstBusiService;
    @Autowired
    private FscSyncPushYcAttachmentAbilityService fscSyncPushYcAttachmentAbilityService;
    @Autowired
    private FscDicDictionaryExernalMapper fscDicDictionaryExernalMapper;
    @Autowired
    private FscOrderRefundMapper fscOrderRefundMapper;
    @Autowired
    private FscOrderRelationMapper fscOrderRelationMapper;
    @Autowired
    private FscInvoiceMapper fscInvoiceMapper;
    @Autowired
    private FscOrderItemMapper fscOrderItemMapper;
    @Autowired
    private FscInvoicePoolMapper fscInvoicePoolMapper;
    @Autowired
    private FscOrderMapper fscOrderMapper;
    @Autowired
    private FscShouldPayMapper fscShouldPayMapper;
    @Autowired
    private FscRefundShouldAmountMapper fscRefundShouldAmountMapper;
    @Value(value="${OPER_ORG_ID}")
    private String operOrgId;
    @Value(value="${OPER_ORG_NAME}")
    private String operOrgName;
    @Value(value="${refund.settle.stage:FIRST}")
    private String settleStage;

    @FscDuplicateCommitLimit
    @PostMapping(value={"dealPushPurSettleCharge"})
    public FscPushNewYcPurSettleChargeAgainstAbilityRspBO dealPushPurSettleCharge(@RequestBody FscPushNewYcPurSettleChargeAgainstAbilityReqBO reqBO) {
        FscPushNewYcPurSettleChargeAgainstBusiRspBO busiRspBO;
        if (reqBO.getRefundId() == null) {
            throw new FscBusinessException("198888", "\u5165\u53c2[refundId]\u4e0d\u80fd\u4e3a\u7a7a\uff01");
        }
        FscOrderRefundPO refundPO = new FscOrderRefundPO();
        refundPO.setRefundId(reqBO.getRefundId());
        refundPO = this.fscOrderRefundMapper.getModelBy(refundPO);
        if (refundPO == null) {
            throw new FscBusinessException("198888", "\u672a\u67e5\u8be2\u5230\u9000\u7968\u5355\u76f8\u5173\u4fe1\u606f\uff01");
        }
        if (refundPO.getPushStatus() != null && refundPO.getPushStatus().equals(FscConstants.FscPushStatus.SUCCESS)) {
            throw new FscBusinessException("198888", "\u5f53\u524d\u5355\u636e\u5df2\u63a8\u9001\u6210\u529f\uff0c\u8bf7\u52ff\u91cd\u590d\u64cd\u4f5c\u3002");
        }
        try {
            int count;
            if (!refundPO.getAuditStatus().equals(FscConstants.AuditStatus.AUDIT_PASS)) {
                throw new FscBusinessException("198888", "\u5f53\u524d\u5355\u636e\u672a\u901a\u8fc7\u5ba1\u6279\uff01");
            }
            if (!FscConstants.RefundReasonType.ORDER_REFUND.equals(refundPO.getRefundReasonType()) && (count = this.fscOrderMapper.checkReopenSettle(refundPO.getRefundId())) == 0) {
                throw new FscBusinessException("198888", "\u8bf7\u5148\u5b8c\u6210\u91cd\u5f00\u7ed3\u7b97\u5355\u6d41\u7a0b\uff01");
            }
            FscPushNewYcPurSettleChargeBO settleInfo = this.buildSettleInfo(refundPO);
            List<FscPushNewYcPurSettleChargeItemBO> settleItemList = this.buildSettleItemInfo(refundPO, settleInfo);
            BigDecimal taxAmt = BigDecimal.ZERO;
            BigDecimal amt = BigDecimal.ZERO;
            BigDecimal untaxAmt = BigDecimal.ZERO;
            for (FscPushNewYcPurSettleChargeItemBO settleChargeItemBO : settleItemList) {
                taxAmt = taxAmt.add(settleChargeItemBO.getTAX_AMOUNT());
                amt = amt.add(settleChargeItemBO.getAMOUNT_INTAX());
                untaxAmt = untaxAmt.add(settleChargeItemBO.getAMOUNT_NOTAX());
            }
            settleInfo.setTAX_AMOUNT(taxAmt);
            settleInfo.setAMOUNT(amt);
            settleInfo.setAMOUNT_NOTAX(untaxAmt);
            settleInfo.setWRITE_TYPE("KF_BALANCE_REDRUSH");
            settleInfo.setWRITE_TYPE_DIS("\u9000\u6b3e\u9000\u7968");
            List<FscPushNewYcPurSettleChargeInvoiceBO> invoiceBOList = this.buildInvoiceInfo(refundPO, settleInfo);
            List payList = new ArrayList();
            JSONArray jsonArray = new JSONArray();
            JSONObject jsonObject = new JSONObject();
            jsonObject.put("BALANCE", (Object)settleInfo);
            jsonObject.put("BALANCE_LINE", settleItemList);
            jsonObject.put("BALANCE_INV", invoiceBOList);
            if (FscConstants.RefundReasonType.ORDER_REFUND.equals(refundPO.getRefundReasonType())) {
                FscPushNewYcPayRefundQueryAbilityReqBO refundQueryAbilityReqBO = new FscPushNewYcPayRefundQueryAbilityReqBO();
                refundQueryAbilityReqBO.setRefundId(refundPO.getRefundId());
                FscPushNewYcPayRefundQueryAbilityRspBO refundQueryAbilityRspBO = this.fscPushNewYcPayRefundQueryAbilityService.dealPushNewYcPayRefundQuery(refundQueryAbilityReqBO);
                if (!"0000".equals(refundQueryAbilityRspBO.getRespCode())) {
                    throw new FscBusinessException(refundQueryAbilityRspBO.getRespCode(), refundQueryAbilityRspBO.getRespDesc());
                }
                payList = refundQueryAbilityRspBO.getPAY_LIST();
                jsonObject.put("PAY_LIST", (Object)refundQueryAbilityRspBO.getPAY_LIST());
            }
            jsonArray.add((Object)jsonObject);
            FscPushNewYcPurSettleChargeAgainstBusiReqBO busiReqBO = new FscPushNewYcPurSettleChargeAgainstBusiReqBO();
            busiReqBO.setRefundId(refundPO.getRefundId());
            busiReqBO.setRefundNo(refundPO.getRefundNo());
            busiReqBO.setReqData(jsonArray.toJSONString());
            busiRspBO = this.fscPushNewYcPurSettleChargeAgainstBusiService.dealPushYcPurSettleCharge(busiReqBO);
            if (busiRspBO.getRespCode().equals("0000")) {
                FscPushYcAttachmentAbilityReqBO attachmentAbilityReqBO = new FscPushYcAttachmentAbilityReqBO();
                attachmentAbilityReqBO.setObjNo(refundPO.getRefundNo());
                attachmentAbilityReqBO.setObjId(refundPO.getRefundId());
                attachmentAbilityReqBO.setAgentAccount(refundPO.getExt1());
                attachmentAbilityReqBO.setAgentName(refundPO.getOperatorName());
                attachmentAbilityReqBO.setObjType(FscConstants.FSC_YC_FILE_TYPE.PUR_SETTLE_CHARGE_AGAINST);
                this.fscSyncPushYcAttachmentAbilityService.syncPushYcAttachment(attachmentAbilityReqBO);
            }
            if (!CollectionUtils.isEmpty(payList)) {
                this.syncRefundPayStatus(refundPO.getRefundId(), busiRspBO);
            }
        }
        catch (Exception e) {
            FscPushNewYcPurSettleChargeAgainstBusiReqBO busiReqBO = new FscPushNewYcPurSettleChargeAgainstBusiReqBO();
            busiReqBO.setRefundId(reqBO.getRefundId());
            busiReqBO.setRefundNo(refundPO.getRefundNo());
            busiReqBO.setReqData(e.getMessage());
            this.fscPushNewYcPurSettleChargeAgainstBusiService.dealPushFail(busiReqBO);
            log.error("\u63a8\u9001\u4e1a\u8d22\u91c7\u8d2d\u7ed3\u7b97\u51b2\u9500\u5355\u7ec4\u88c5\u53c2\u6570\u5931\u8d25\uff1a{}", (Throwable)e);
            this.syncEs(reqBO.getRefundId());
            throw new FscBusinessException("198888", "\u5904\u7406\u63a8\u9001\u5931\u8d25\uff1a" + e.getMessage());
        }
        this.syncEs(reqBO.getRefundId());
        return (FscPushNewYcPurSettleChargeAgainstAbilityRspBO)JSONObject.parseObject((String)JSONObject.toJSONString((Object)((Object)busiRspBO)), FscPushNewYcPurSettleChargeAgainstAbilityRspBO.class);
    }

    private List<FscPushNewYcPurSettleChargeItemBO> buildSettleItemInfo(FscOrderRefundPO refundPO, FscPushNewYcPurSettleChargeBO settleInfo) {
        FscOrderItemPO fscOrderItemPO = new FscOrderItemPO();
        fscOrderItemPO.setRefundId(refundPO.getRefundId());
        List itemPOList = this.fscOrderItemMapper.getListNoPage(fscOrderItemPO);
        ArrayList<FscPushNewYcPurSettleChargeItemBO> chargeItemBOList = new ArrayList<FscPushNewYcPurSettleChargeItemBO>();
        for (FscOrderItemPO orderItemPO : itemPOList) {
            FscPushNewYcPurSettleChargeItemBO settleChargeItemBO = new FscPushNewYcPurSettleChargeItemBO();
            settleChargeItemBO.setORG_ID(settleInfo.getORG_ID());
            settleChargeItemBO.setORG_NAME(settleInfo.getORG_NAME());
            settleChargeItemBO.setEXP_TYPE(settleInfo.getBUZ_PROPERTY_DIS());
            settleChargeItemBO.setEXP_TYPE_ID(null);
            settleChargeItemBO.setTAX_AMOUNT(orderItemPO.getTaxAmt().negate());
            settleChargeItemBO.setAMOUNT_INTAX(orderItemPO.getAmt().negate());
            settleChargeItemBO.setAMOUNT_NOTAX(orderItemPO.getUntaxAmt().negate());
            settleChargeItemBO.setTAX_RATE(orderItemPO.getTaxRate().multiply(new BigDecimal(100)).stripTrailingZeros().toString());
            settleChargeItemBO.setTAX_RATE_ID(null);
            settleChargeItemBO.setUSER_ID(settleInfo.getUSER_ID());
            settleChargeItemBO.setCONTRACT_NUM(settleInfo.getCONTRACT_NUM());
            settleChargeItemBO.setCONTRACT_NAME(settleInfo.getCONTRACT_NAME());
            settleChargeItemBO.setEG_TESCO_ID(orderItemPO.getId() + "");
            chargeItemBOList.add(settleChargeItemBO);
        }
        return chargeItemBOList;
    }

    private List<FscPushNewYcPurSettleChargeInvoiceBO> buildInvoiceInfo(FscOrderRefundPO refundPO, FscPushNewYcPurSettleChargeBO settleInfo) {
        FscInvoicePO fscInvoicePO = new FscInvoicePO();
        fscInvoicePO.setRefundId(refundPO.getRefundId());
        List invoiceList = this.fscInvoiceMapper.getListNoStatus(fscInvoicePO);
        if (CollectionUtils.isEmpty((Collection)invoiceList)) {
            return this.buildCancellationInvoiceInfo(refundPO, settleInfo);
        }
        ArrayList<FscPushNewYcPurSettleChargeInvoiceBO> invoiceBOList = new ArrayList<FscPushNewYcPurSettleChargeInvoiceBO>(invoiceList.size());
        List<String> invoiceNos = invoiceList.stream().map(FscInvoicePO::getInvoiceNo).collect(Collectors.toList());
        List preInvoiceIds = invoiceList.stream().map(FscInvoicePO::getPreInvoiceId).collect(Collectors.toList());
        HashMap<Long, FscInvoicePO> preInvoiceMap = new HashMap<Long, FscInvoicePO>(8);
        if (!CollectionUtils.isEmpty(preInvoiceIds)) {
            fscInvoicePO = new FscInvoicePO();
            fscInvoicePO.setInvoiceIds(preInvoiceIds);
            List preInvoiceList = this.fscInvoiceMapper.getListNoStatus(fscInvoicePO);
            for (FscInvoicePO invoicePO : preInvoiceList) {
                invoiceNos.add(invoicePO.getInvoiceNo());
                preInvoiceMap.put(invoicePO.getInvoiceId(), invoicePO);
            }
        }
        Map<String, String> invoiceMap = this.qryInvoicePool(invoiceNos);
        for (FscInvoicePO invoicePO : invoiceList) {
            FscPushNewYcPurSettleChargeInvoiceBO invoiceBO = new FscPushNewYcPurSettleChargeInvoiceBO();
            invoiceBO.setEG_TESCO_ID(invoicePO.getInvoiceId() + "");
            invoiceBO.setUSER_ID(settleInfo.getUSER_ID());
            invoiceBO.setORG_ID(settleInfo.getORG_ID());
            invoiceBO.setORG_NAME(settleInfo.getORG_NAME());
            invoiceBO.setEG_HCBALANCE_ID(settleInfo.getEG_HCBALANCE_ID());
            invoiceBO.setEG_HCBALANCE_NUM(settleInfo.getEG_HCBALANCE_NUM());
            invoiceBO.setINVOICE_NUM(invoicePO.getInvoiceNo());
            invoiceBO.setINVOICE_DATE(invoicePO.getBillDate());
            invoiceBO.setAMOUNT_INTAX(invoicePO.getAmt().negate());
            invoiceBO.setAMOUNT_NOTAX(invoicePO.getUntaxAmt().negate());
            invoiceBO.setTAX_RATE(this.calTaxRate(invoicePO.getAmt(), invoicePO.getUntaxAmt()));
            invoiceBO.setTAX_AMOUNT(invoicePO.getTaxAmt().negate());
            invoiceBO.setINVOICE_CODE(invoicePO.getInvoiceCode());
            if (StringUtils.isEmpty((CharSequence)invoiceBO.getINVOICE_CODE())) {
                invoiceBO.setINVOICE_CODE("");
            }
            if (invoiceMap.get(invoiceBO.getINVOICE_NUM() + "-" + invoiceBO.getINVOICE_CODE()) == null) {
                throw new FscBusinessException("198888", invoiceBO.getINVOICE_NUM() + "-" + invoiceBO.getINVOICE_CODE() + "\u67e5\u8be2\u8fdb\u9879\u7968\u6c60\u53d1\u7968\u4fe1\u606f\u4e3a\u7a7a\uff01");
            }
            invoiceBO.setINVOICE_ID(invoiceMap.get(invoiceBO.getINVOICE_NUM() + "-" + invoiceBO.getINVOICE_CODE()));
            FscInvoicePO preInvoicePO = (FscInvoicePO)preInvoiceMap.get(invoicePO.getPreInvoiceId());
            if (preInvoicePO != null) {
                invoiceBO.setINVOICE_NUM_F(preInvoicePO.getInvoiceNo());
                invoiceBO.setINVOICE_DATE_F(preInvoicePO.getBillDate());
                invoiceBO.setAMOUNT_INTAX_F(preInvoicePO.getAmt());
                invoiceBO.setTAX_RATE_F(this.calTaxRate(preInvoicePO.getAmt(), preInvoicePO.getUntaxAmt()));
                invoiceBO.setTAX_AMOUNT_F(preInvoicePO.getTaxAmt());
                invoiceBO.setAMOUNT_NOTAX_F(preInvoicePO.getUntaxAmt());
                if (invoiceMap.get(preInvoicePO.getInvoiceNo() + "-" + preInvoicePO.getInvoiceCode()) == null) {
                    throw new FscBusinessException("198888", preInvoicePO.getInvoiceNo() + "-" + preInvoicePO.getInvoiceCode() + "\u67e5\u8be2\u8fdb\u9879\u7968\u6c60\u53d1\u7968\u4fe1\u606f\u4e3a\u7a7a\uff01");
                }
                invoiceBO.setINVOICE_ID_F(invoiceMap.get(preInvoicePO.getInvoiceNo() + "-" + preInvoicePO.getInvoiceCode()));
            }
            invoiceBOList.add(invoiceBO);
        }
        return invoiceBOList;
    }

    private List<FscPushNewYcPurSettleChargeInvoiceBO> buildCancellationInvoiceInfo(FscOrderRefundPO refundPO, FscPushNewYcPurSettleChargeBO settleInfo) {
        List invoiceList = this.fscInvoiceMapper.getInvoiceByRefundId(refundPO.getRefundId());
        ArrayList<FscPushNewYcPurSettleChargeInvoiceBO> invoiceBOList = new ArrayList<FscPushNewYcPurSettleChargeInvoiceBO>(invoiceList.size());
        List<String> invoiceNos = invoiceList.stream().map(FscInvoicePO::getInvoiceNo).collect(Collectors.toList());
        Map<String, String> invoiceMap = this.qryInvoicePool(invoiceNos);
        for (FscInvoicePO invoicePO : invoiceList) {
            FscPushNewYcPurSettleChargeInvoiceBO invoiceBO = new FscPushNewYcPurSettleChargeInvoiceBO();
            invoiceBO.setEG_TESCO_ID(invoicePO.getInvoiceId() + "");
            invoiceBO.setUSER_ID(settleInfo.getUSER_ID());
            invoiceBO.setORG_ID(settleInfo.getORG_ID());
            invoiceBO.setORG_NAME(settleInfo.getORG_NAME());
            invoiceBO.setEG_HCBALANCE_ID(settleInfo.getEG_HCBALANCE_ID());
            invoiceBO.setEG_HCBALANCE_NUM(settleInfo.getEG_BALANCE_NUM());
            invoiceBO.setINVOICE_DATE_F(invoicePO.getBillDate());
            invoiceBO.setINVOICE_NUM_F(invoicePO.getInvoiceNo());
            invoiceBO.setTAX_RATE_F(this.calTaxRate(invoicePO.getAmt(), invoicePO.getUntaxAmt()));
            invoiceBO.setAMOUNT_INTAX_F(invoicePO.getAmt());
            invoiceBO.setAMOUNT_NOTAX_F(invoicePO.getUntaxAmt());
            invoiceBO.setTAX_AMOUNT_F(invoicePO.getTaxAmt());
            if (invoiceMap.get(invoicePO.getInvoiceNo() + "-" + invoicePO.getInvoiceCode()) == null) {
                throw new FscBusinessException("198888", invoicePO.getInvoiceNo() + "-" + invoicePO.getInvoiceCode() + "\u67e5\u8be2\u8fdb\u9879\u7968\u6c60\u53d1\u7968\u4fe1\u606f\u4e3a\u7a7a\uff01");
            }
            invoiceBO.setINVOICE_ID_F(invoiceMap.get(invoicePO.getInvoiceNo() + "-" + invoicePO.getInvoiceCode()));
            invoiceBOList.add(invoiceBO);
        }
        return invoiceBOList;
    }

    private Map<String, String> qryInvoicePool(List<String> invoiceNos) {
        HashMap<String, String> invoiceMap = new HashMap<String, String>();
        FscInvoicePoolPO invoicePoolPO = new FscInvoicePoolPO();
        invoicePoolPO.setInvoiceNos(invoiceNos);
        List poolPOList = this.fscInvoicePoolMapper.getList(invoicePoolPO);
        for (FscInvoicePoolPO poolPO : poolPOList) {
            if (StringUtils.isEmpty((CharSequence)poolPO.getInvoiceCode())) {
                poolPO.setInvoiceCode("");
            }
            invoiceMap.put(poolPO.getInvoiceNo() + "-" + poolPO.getInvoiceCode(), poolPO.getId() + "");
        }
        return invoiceMap;
    }

    private FscPushNewYcPurSettleChargeBO buildSettleInfo(FscOrderRefundPO refundPO) {
        BigDecimal balAmt;
        BigDecimal totalRefundAmt;
        FscOrderRelationPO relationPO = new FscOrderRelationPO();
        relationPO.setFscOrderId(refundPO.getFscOrderId());
        List relationPOList = this.fscOrderRelationMapper.getList(relationPO);
        FscDicDictionaryExernalPO externalPO = new FscDicDictionaryExernalPO();
        externalPO.setPCode("FSC_ORDER_SOURCE");
        externalPO.setCode(refundPO.getOrderType() + "");
        externalPO = this.fscDicDictionaryExernalMapper.getModelByCondition(externalPO);
        FscPushNewYcPurSettleChargeBO settleInfo = new FscPushNewYcPurSettleChargeBO();
        settleInfo.setORG_ID(this.operOrgId);
        settleInfo.setORG_NAME(this.operOrgName);
        settleInfo.setEG_HCBALANCE_ID(refundPO.getRefundId() + "");
        settleInfo.setEG_HCBALANCE_NUM(refundPO.getRefundNo());
        settleInfo.setCONTRACT_NUM(((FscOrderRelationPO)relationPOList.get(0)).getProContractNo());
        settleInfo.setCONTRACT_NAME(((FscOrderRelationPO)relationPOList.get(0)).getProContractName());
        settleInfo.setEG_BALANCE_ID(refundPO.getFscOrderId() + "");
        settleInfo.setEG_BALANCE_NUM(refundPO.getFscOrderNo());
        settleInfo.setSTATUS("Y");
        settleInfo.setSTATUS_DIS("\u5ba1\u6279\u901a\u8fc7");
        settleInfo.setBILL_DATE(DateUtil.dateToStr((Date)refundPO.getCreateTime()));
        settleInfo.setDESCRIPTIONS(refundPO.getRefundNote());
        settleInfo.setUSER_ID(refundPO.getYcUserId() + "");
        settleInfo.setPERSON_ID(refundPO.getYcPersonId() + "");
        settleInfo.setPERSON_NAME(refundPO.getYcPersonName() + "");
        settleInfo.setDEPT_ID(refundPO.getYcDeptId() + "");
        settleInfo.setDEPT_NAME(refundPO.getYcDeptName());
        settleInfo.setCOM_CODE(null);
        settleInfo.setBUZ_PROPERTY(externalPO.getExernalCode());
        settleInfo.setBUZ_PROPERTY_DIS(externalPO.getExernalTitle());
        settleInfo.setSTAGE(this.settleStage);
        FscOrderPO orderPO = new FscOrderPO();
        orderPO.setRefundId(refundPO.getRefundId());
        List reopenOrderList = this.fscOrderMapper.getOrderReopenOrderNo(orderPO);
        if (reopenOrderList.size() > 1) {
            throw new FscBusinessException("198888", "\u9000\u7968\u5355" + refundPO.getRefundNo() + "\u91cd\u5f00\u7ed3\u7b97\u5355\u6570\u91cf\u5927\u4e8e1\uff01");
        }
        if (!CollectionUtils.isEmpty((Collection)reopenOrderList)) {
            settleInfo.setNWRITE_AMOUNT(BigDecimal.ZERO);
            settleInfo.setBAL_BILL_ID2(((FscOrderPO)reopenOrderList.get(0)).getFscOrderId() + "");
            settleInfo.setBAL_BILL_NUM2(((FscOrderPO)reopenOrderList.get(0)).getOrderNo());
        }
        if ((totalRefundAmt = this.fscOrderRefundMapper.sumRefundAmtByFscOrderId(refundPO.getFscOrderId(), refundPO.getRefundId())) == null) {
            totalRefundAmt = BigDecimal.ZERO;
        }
        orderPO = new FscOrderPO();
        orderPO.setFscOrderId(refundPO.getFscOrderId());
        orderPO = this.fscOrderMapper.getModelBy(orderPO);
        FscShouldPayPO shouldPayPO = new FscShouldPayPO();
        shouldPayPO.setObjectId(refundPO.getFscOrderId());
        BigDecimal payPaidAmt = orderPO.getSettleType().equals(FscConstants.SettleType.ORDER) ? this.fscShouldPayMapper.sumOrderPayPaidAmt(shouldPayPO) : this.fscShouldPayMapper.sumPayPaidAmt(shouldPayPO);
        if (payPaidAmt == null) {
            payPaidAmt = BigDecimal.ZERO;
        }
        if ((balAmt = orderPO.getTotalCharge().subtract(orderPO.getWriteOffAmount()).subtract(totalRefundAmt).subtract(payPaidAmt)).compareTo(BigDecimal.ZERO) < 0) {
            balAmt = BigDecimal.ZERO;
        }
        settleInfo.setBAL_RE_AMOUNT(balAmt);
        if (!refundPO.getRefundReasonType().equals(FscConstants.RefundReasonType.ORDER_REFUND)) {
            if (balAmt.compareTo(BigDecimal.ZERO) == 0) {
                settleInfo.setOWRITE_AMOUNT(new BigDecimal("0.00"));
                settleInfo.setNWRITE_AMOUNT(refundPO.getRefundAmount());
                settleInfo.setREC_AMOUNT(new BigDecimal("0.00"));
            } else if (balAmt.compareTo(refundPO.getRefundAmount()) >= 0) {
                settleInfo.setOWRITE_AMOUNT(refundPO.getRefundAmount());
                settleInfo.setNWRITE_AMOUNT(new BigDecimal("0.00"));
                settleInfo.setREC_AMOUNT(new BigDecimal("0.00"));
            } else {
                settleInfo.setOWRITE_AMOUNT(balAmt);
                settleInfo.setREC_AMOUNT(new BigDecimal("0.00"));
                settleInfo.setNWRITE_AMOUNT(refundPO.getRefundAmount().subtract(balAmt));
            }
        } else if (balAmt.compareTo(BigDecimal.ZERO) == 0) {
            settleInfo.setOWRITE_AMOUNT(new BigDecimal("0.00"));
            settleInfo.setNWRITE_AMOUNT(new BigDecimal("0.00"));
            settleInfo.setREC_AMOUNT(orderPO.getWriteOffAmount().add(payPaidAmt));
        } else if (balAmt.compareTo(refundPO.getRefundAmount()) < 0) {
            BigDecimal writeOffAmt = this.fscRefundShouldAmountMapper.sumAmountByRefundId(refundPO.getRefundId());
            if (writeOffAmt == null) {
                writeOffAmt = BigDecimal.ZERO;
            }
            settleInfo.setREC_AMOUNT(refundPO.getShouldPayAmount().add(writeOffAmt).setScale(2, RoundingMode.HALF_UP));
            settleInfo.setOWRITE_AMOUNT(refundPO.getRefundAmount().subtract(settleInfo.getREC_AMOUNT()));
            settleInfo.setNWRITE_AMOUNT(new BigDecimal("0.00"));
        } else {
            BigDecimal writeOffAmt = this.fscRefundShouldAmountMapper.sumAmountByRefundId(refundPO.getRefundId());
            if (writeOffAmt == null) {
                writeOffAmt = BigDecimal.ZERO;
            }
            settleInfo.setOWRITE_AMOUNT(refundPO.getRefundAmount());
            settleInfo.setREC_AMOUNT(refundPO.getShouldPayAmount().add(writeOffAmt).setScale(2, RoundingMode.HALF_UP));
            settleInfo.setNWRITE_AMOUNT(new BigDecimal("0.00"));
        }
        return settleInfo;
    }

    private String calTaxRate(BigDecimal amt, BigDecimal untaxAmt) {
        return amt.divide(untaxAmt, 2, RoundingMode.HALF_UP).subtract(new BigDecimal(1)).multiply(new BigDecimal(100)).stripTrailingZeros().toString();
    }

    private void syncEs(Long refundId) {
        FscComRefundSyncAbilityReqBO refundSyncAbilityReqBO = new FscComRefundSyncAbilityReqBO();
        refundSyncAbilityReqBO.setRefundIds(Collections.singletonList(refundId));
        this.fscComRefundSyncAbilityService.syncRefund(refundSyncAbilityReqBO);
    }

    private void syncRefundPayStatus(Long refundId, FscPushNewYcPurSettleChargeAgainstBusiRspBO busiRspBO) {
        FscDealPushPayRefundStatusAbilityReqBO abilityReqBO = new FscDealPushPayRefundStatusAbilityReqBO();
        abilityReqBO.setRefundId(refundId);
        abilityReqBO.setPushResult("0000".equals(busiRspBO.getRespCode()) ? FscConstants.FscPushStatus.SUCCESS : FscConstants.FscPushStatus.FAIL);
        FscDealPushPayRefundStatusAbilityRspBO abilityRspBO = this.fscDealPushPayRefundStatusAbilityService.dealPushPayRefundStatus(abilityReqBO);
        if (!"0000".equals(abilityRspBO.getRespCode())) {
            log.error("{}\u540c\u6b65\u9000\u6b3e\u5355\u63a8\u9001\u4e1a\u8d22\u72b6\u6001\u5931\u8d25:{}", (Object)abilityReqBO.getRefundId(), (Object)abilityRspBO.getRespDesc());
        }
    }
}

