/*
 * Decompiled with CFR 0.152.
 */
package com.tydic.fsc.bill.ability.impl;

import com.alibaba.fastjson.JSON;
import com.alibaba.fastjson.JSONObject;
import com.ohaotian.plugin.mq.proxy.ProxyMessage;
import com.ohaotian.plugin.mq.proxy.ProxyMessageProducer;
import com.ohaotian.plugin.mq.proxy.ProxySendResult;
import com.tydic.fsc.bill.ability.api.FscSyncPushYcSpecialRefundAbilityService;
import com.tydic.fsc.bill.ability.bo.FscSyncPushYcSpecialRefundAbilityReqBO;
import com.tydic.fsc.bill.ability.bo.FscSyncPushYcSpecialRefundAbilityRspBO;
import com.tydic.fsc.busibase.busi.api.FscOrderFailLogUpdateBusiService;
import com.tydic.fsc.busibase.busi.bo.FscOrderFailLogUpdateBusiReqBO;
import com.tydic.fsc.constants.FscConstants;
import java.util.Date;
import javax.annotation.Resource;
import org.springframework.beans.factory.annotation.Autowired;
import org.springframework.beans.factory.annotation.Value;
import org.springframework.web.bind.annotation.PostMapping;
import org.springframework.web.bind.annotation.RequestBody;
import org.springframework.web.bind.annotation.RequestMapping;
import org.springframework.web.bind.annotation.RestController;

@RestController
@RequestMapping(value={"FSC_GROUP_DEV/1.0.0/com.tydic.fsc.bill.ability.api.FscSyncPushYcSpecialRefundAbilityService"})
public class FscSyncPushYcSpecialRefundAbilityServiceImpl
implements FscSyncPushYcSpecialRefundAbilityService {
    @Autowired
    private FscOrderFailLogUpdateBusiService fscOrderFailLogUpdateBusiService;
    @Resource(name="fscPushYcSpecialRefundMqServiceProvider")
    private ProxyMessageProducer fscPushYcSpecialRefundMqServiceProvider;
    @Value(value="${FSC_PUSH_YC_SPECIAL_REFUND_TOPIC:FSC_PUSH_YC_SPECIAL_REFUND_TOPIC}")
    private String fscPushYcSpecialRefundTopic;
    @Value(value="${FSC_PUSH_YC_SPECIAL_REFUND_TAG:FSC_PUSH_YC_SPECIAL_REFUND_TAG}")
    private String fscPushYcSpecialRefundTag;

    @PostMapping(value={"PushYcSpecialRefund"})
    public FscSyncPushYcSpecialRefundAbilityRspBO PushYcSpecialRefund(@RequestBody FscSyncPushYcSpecialRefundAbilityReqBO reqBO) {
        ProxySendResult proxySendResult = this.fscPushYcSpecialRefundMqServiceProvider.send(new ProxyMessage(this.fscPushYcSpecialRefundTopic, this.fscPushYcSpecialRefundTag, JSON.toJSONString((Object)reqBO)));
        if (!"SEND_OK".equals(proxySendResult.getStatus())) {
            this.writeFailLog(reqBO);
        }
        return new FscSyncPushYcSpecialRefundAbilityRspBO();
    }

    private void writeFailLog(FscSyncPushYcSpecialRefundAbilityReqBO reqBO) {
        FscOrderFailLogUpdateBusiReqBO fscOrderFailLogUpdateBusiReqBO = new FscOrderFailLogUpdateBusiReqBO();
        fscOrderFailLogUpdateBusiReqBO.setObjId(reqBO.getRefundId());
        fscOrderFailLogUpdateBusiReqBO.setBusiFailDesc(JSONObject.toJSONString((Object)reqBO));
        fscOrderFailLogUpdateBusiReqBO.setBusiFailTime(new Date());
        fscOrderFailLogUpdateBusiReqBO.setBusiType(FscConstants.FscOrderFailRetansBusiType.FSC_SYNC_YC_SPECIAL_REFUND_FAIL);
        this.fscOrderFailLogUpdateBusiService.dealInsert(fscOrderFailLogUpdateBusiReqBO);
    }
}

