/*
 * Decompiled with CFR 0.152.
 */
package com.tydic.fsc.bill.atom.impl.finance;

import com.tydic.fsc.bill.atom.api.finance.FscFinanceOrderReleaseWriteAtomService;
import com.tydic.fsc.bill.atom.bo.finance.FscFinanceOrderReleaseWriteAtomReqBO;
import com.tydic.fsc.bill.atom.bo.finance.FscFinanceOrderReleaseWriteAtomRspBO;
import com.tydic.fsc.dao.FscFinanceWriteOffMapper;
import com.tydic.fsc.dao.FscOrderMapper;
import com.tydic.fsc.dao.FscOrderPayItemMapper;
import com.tydic.fsc.exception.FscBusinessException;
import com.tydic.fsc.po.FscFinanceWriteOffPO;
import com.tydic.fsc.po.FscOrderPO;
import com.tydic.fsc.po.FscOrderPayItemPO;
import java.math.BigDecimal;
import java.util.Collection;
import java.util.HashMap;
import java.util.List;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;
import org.springframework.beans.factory.annotation.Autowired;
import org.springframework.stereotype.Service;
import org.springframework.util.CollectionUtils;

@Service
public class FscFinanceOrderReleaseWriteAtomServiceImpl
implements FscFinanceOrderReleaseWriteAtomService {
    private static final Logger log = LoggerFactory.getLogger(FscFinanceOrderReleaseWriteAtomServiceImpl.class);
    @Autowired
    private FscOrderMapper fscOrderMapper;
    @Autowired
    private FscFinanceWriteOffMapper fscFinanceWriteOffMapper;
    @Autowired
    private FscOrderPayItemMapper fscOrderPayItemMapper;

    @Override
    public FscFinanceOrderReleaseWriteAtomRspBO dealFinanceOrderReleaseWrite(FscFinanceOrderReleaseWriteAtomReqBO reqBO) {
        FscFinanceOrderReleaseWriteAtomRspBO rspBO = new FscFinanceOrderReleaseWriteAtomRspBO();
        FscFinanceWriteOffPO fscFinanceWriteOffPO = new FscFinanceWriteOffPO();
        fscFinanceWriteOffPO.setFscOrderId(reqBO.getFscOrderId());
        List writeOffList = this.fscFinanceWriteOffMapper.getList(fscFinanceWriteOffPO);
        if (CollectionUtils.isEmpty((Collection)writeOffList)) {
            return rspBO;
        }
        BigDecimal writeOffAmt = writeOffList.stream().map(FscFinanceWriteOffPO::getWriteOffAmt).reduce(BigDecimal.ZERO, BigDecimal::add);
        HashMap<Long, BigDecimal> updatePayWriteOffAmountMap = new HashMap<Long, BigDecimal>();
        HashMap<Long, BigDecimal> updatePayItemWriteOffAmountMap = new HashMap<Long, BigDecimal>();
        for (FscFinanceWriteOffPO po : writeOffList) {
            BigDecimal payWriteOffAmt = (BigDecimal)updatePayWriteOffAmountMap.get(po.getPayOrderId());
            if (payWriteOffAmt == null) {
                updatePayWriteOffAmountMap.put(po.getPayOrderId(), po.getWriteOffAmt());
            } else {
                payWriteOffAmt = payWriteOffAmt.add(po.getWriteOffAmt());
                updatePayWriteOffAmountMap.put(po.getPayOrderId(), payWriteOffAmt);
            }
            BigDecimal payItemWriteOffAmt = (BigDecimal)updatePayItemWriteOffAmountMap.get(po.getPayOrderId());
            if (payItemWriteOffAmt == null) {
                updatePayItemWriteOffAmountMap.put(po.getOrderPayItemId(), po.getWriteOffAmt());
                continue;
            }
            payItemWriteOffAmt = payItemWriteOffAmt.add(po.getWriteOffAmt());
            updatePayItemWriteOffAmountMap.put(po.getOrderPayItemId(), payItemWriteOffAmt);
        }
        FscOrderPO fscOrderPO = new FscOrderPO();
        fscOrderPO.setFscOrderId(reqBO.getFscOrderId());
        fscOrderPO.setPurWriteOffAmount(writeOffAmt.negate());
        int count = this.fscOrderMapper.updatePurWriteOffAmountAdd(fscOrderPO);
        if (count == 0) {
            throw new FscBusinessException("193011", "\u66f4\u65b0\u91c7\u8d2d\u7ed3\u7b97\u6838\u9500\u91d1\u989d\u5931\u8d25");
        }
        for (Long payOrderId : updatePayWriteOffAmountMap.keySet()) {
            FscOrderPO payOrderPO = new FscOrderPO();
            payOrderPO.setFscOrderId(payOrderId);
            payOrderPO.setPurWriteOffAmount(((BigDecimal)updatePayWriteOffAmountMap.get(payOrderId)).negate());
            count = this.fscOrderMapper.updatePurWriteOffAmountAdd(payOrderPO);
            if (count != 0) continue;
            throw new FscBusinessException("193011", "\u66f4\u65b0\u91c7\u8d2d\u7ed3\u7b97\u4ed8\u6b3e\u6838\u9500\u91d1\u989d\u5931\u8d25");
        }
        for (Long itemId : updatePayItemWriteOffAmountMap.keySet()) {
            FscOrderPayItemPO fscOrderPayItemPO = new FscOrderPayItemPO();
            fscOrderPayItemPO.setOrderPayItemId(itemId);
            fscOrderPayItemPO.setPurWriteOffAmount(((BigDecimal)updatePayItemWriteOffAmountMap.get(itemId)).negate());
            count = this.fscOrderPayItemMapper.updateWriteOffAmountAdd(fscOrderPayItemPO);
            if (count != 0) continue;
            throw new FscBusinessException("193011", "\u66f4\u65b0\u91c7\u8d2d\u7ed3\u7b97\u4ed8\u6b3e\u660e\u7ec6\u6838\u9500\u91d1\u989d\u5931\u8d25");
        }
        rspBO.setRespCode("0000");
        rspBO.setRespDesc("\u6210\u529f");
        return rspBO;
    }
}

