/*
 * Decompiled with CFR 0.152.
 */
package com.tydic.fsc.bill.busi.impl;

import com.alibaba.fastjson.JSON;
import com.ohaotian.plugin.db.Sequence;
import com.tydic.fsc.bill.busi.api.FscBillEcomCheckBusiService;
import com.tydic.fsc.bill.busi.bo.FscBillEcomCheckBusiReqBO;
import com.tydic.fsc.bill.busi.bo.FscBillEcomCheckBusiRspBO;
import com.tydic.fsc.bo.FscEcomJdOrderDetailBO;
import com.tydic.fsc.bo.FscOrderInfoBO;
import com.tydic.fsc.bo.FscOrderItemBO;
import com.tydic.fsc.bo.RelOrderBO;
import com.tydic.fsc.busibase.atom.api.FscAcceptOrderListQueryAtomService;
import com.tydic.fsc.busibase.atom.api.FscOrderFailLogUpdateAtomService;
import com.tydic.fsc.busibase.atom.bo.FscAcceptOrderListQueryAtomRspBO;
import com.tydic.fsc.busibase.atom.bo.FscOrderFailLogUpdateAtomReqBO;
import com.tydic.fsc.busibase.atom.bo.FscOrderFailLogUpdateAtomRspBO;
import com.tydic.fsc.busibase.external.api.bo.FscBillCheckOrderAccountRspBO;
import com.tydic.fsc.busibase.external.api.bo.FscCheckOrderEntity;
import com.tydic.fsc.busibase.external.api.bo.FscUocOrderSyncCheckStatusReqBO;
import com.tydic.fsc.busibase.external.api.bo.FscUocOrderSyncCheckStatusRspBO;
import com.tydic.fsc.busibase.external.api.esb.FscBillCheckOrderAccountService;
import com.tydic.fsc.busibase.external.api.uoc.FscUocOrderSyncCheckStatusAbilityService;
import com.tydic.fsc.constants.FscConstants;
import com.tydic.fsc.dao.FscCheckResultItemMapper;
import com.tydic.fsc.dao.FscCheckResultMapper;
import com.tydic.fsc.exception.FscBusinessException;
import com.tydic.fsc.po.FscCheckResultItemPO;
import com.tydic.fsc.po.FscCheckResultPO;
import java.math.BigDecimal;
import java.util.ArrayList;
import java.util.Collection;
import java.util.Date;
import java.util.HashMap;
import java.util.List;
import java.util.Map;
import java.util.stream.Collectors;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;
import org.springframework.beans.factory.annotation.Autowired;
import org.springframework.beans.factory.annotation.Value;
import org.springframework.stereotype.Service;
import org.springframework.util.CollectionUtils;

@Service
public class FscBillEcomCheckBusiServiceImpl
implements FscBillEcomCheckBusiService {
    private static final Logger log = LoggerFactory.getLogger(FscBillEcomCheckBusiServiceImpl.class);
    @Autowired
    private FscCheckResultMapper fscCheckResultMapper;
    @Autowired
    private FscCheckResultItemMapper fscCheckResultItemMapper;
    @Autowired
    private FscBillCheckOrderAccountService fscBillCheckOrderAccountService;
    @Autowired
    private FscAcceptOrderListQueryAtomService fscAcceptOrderListQueryAtomService;
    @Autowired
    private FscUocOrderSyncCheckStatusAbilityService fscUocOrderSyncCheckStatusAbilityService;
    @Autowired
    private FscOrderFailLogUpdateAtomService fscOrderFailLogUpdateAtomService;
    @Value(value="${JD_SUP_ID:100055}")
    private Long JD_SUP_ID;
    @Value(value="${SUPPLIER_JD_ID_FL:202200511}")
    private Long jdIdFl;
    @Value(value="${SUPPLIER_SUNING_FL:202200512}")
    private Long snIdFl;
    private static final String OPER_TYPE = "2";
    private static final Integer ERROR = 1;

    @Override
    public FscBillEcomCheckBusiRspBO dealEcomCheck(FscBillEcomCheckBusiReqBO reqBO) {
        List<String> otherNos = reqBO.getOtherNos();
        List<FscCheckResultPO> fscCheckResultPoList = reqBO.getFscCheckResultPoList();
        FscAcceptOrderListQueryAtomRspBO queryAtomRspBO = reqBO.getQueryAtomRspBO();
        Map fscOrderInfoBoMap = queryAtomRspBO.getFscOrderInfoBoMap();
        List<Long> acceptIds = reqBO.getAcceptIds();
        if ("OTHER_ECOM".equals(reqBO.getEcomType())) {
            if (ERROR.equals(reqBO.getErrorFlag())) {
                this.getEcomCheckDataFailUpdateCheckStateToNotEquals(acceptIds, fscOrderInfoBoMap, reqBO);
                return new FscBillEcomCheckBusiRspBO();
            }
            FscBillCheckOrderAccountRspBO checkOrderAccountRspBO = reqBO.getCheckOrderAccountRspBO();
            if (!CollectionUtils.isEmpty((Collection)checkOrderAccountRspBO.getResult().getOrders())) {
                if (checkOrderAccountRspBO.getResult().getOrders().size() != otherNos.size()) {
                    List backOrderNos = checkOrderAccountRspBO.getResult().getOrders().stream().map(FscCheckOrderEntity::getOrderId).collect(Collectors.toList());
                    List notBackOrderNos = otherNos.stream().filter(s -> !backOrderNos.contains(s)).collect(Collectors.toList());
                    List<Long> notBackAcceptIds = fscCheckResultPoList.stream().filter(fscCheckResultPO -> notBackOrderNos.contains(fscCheckResultPO.getOtherNo())).map(FscCheckResultPO::getAcceptOrderId).collect(Collectors.toList());
                    List<FscCheckResultPO> backFscCheckResultPOS = fscCheckResultPoList.stream().filter(fscCheckResultPO -> backOrderNos.contains(fscCheckResultPO.getOtherNo())).collect(Collectors.toList());
                    Map<Long, FscOrderInfoBO> backFscOrderInfoMap = queryAtomRspBO.getFscOrderInfoBoMap().values().stream().filter(fscOrderInfoBO -> backOrderNos.contains(fscOrderInfoBO.getExtOrderNo())).collect(Collectors.toMap(FscOrderInfoBO::getAcceptOrderId, o -> o));
                    this.check(backFscCheckResultPOS, null, checkOrderAccountRspBO.getResult().getOrders(), reqBO, backFscOrderInfoMap);
                    this.getEcomCheckDataFailUpdateCheckStateToNotEquals(notBackAcceptIds, fscOrderInfoBoMap, reqBO);
                    log.error("\u7535\u5546\u672a\u8fd4\u56de\u7684\u9a8c\u6536\u5355\uff1a{}", (Object)JSON.toJSONString(notBackAcceptIds));
                } else {
                    this.check(fscCheckResultPoList, null, checkOrderAccountRspBO.getResult().getOrders(), reqBO, queryAtomRspBO.getFscOrderInfoBoMap());
                }
            } else {
                this.getEcomCheckDataFailUpdateCheckStateToNotEquals(acceptIds, fscOrderInfoBoMap, reqBO);
                log.error("\u672a\u67e5\u8be2\u5230\u7535\u5546\u6570\u636e\uff0c\u9a8c\u6536\u5355\uff1a{}", (Object)JSON.toJSONString(acceptIds));
            }
        } else {
            List<FscEcomJdOrderDetailBO> jdOrderDetailBOS = reqBO.getJdOrderDetailBOS();
            if (!CollectionUtils.isEmpty(jdOrderDetailBOS)) {
                if (ERROR.equals(reqBO.getErrorFlag())) {
                    List backOrderNos = jdOrderDetailBOS.stream().map(FscEcomJdOrderDetailBO::getOrderNo).collect(Collectors.toList());
                    List notBackOrderNos = otherNos.stream().filter(s -> !backOrderNos.contains(s)).collect(Collectors.toList());
                    List<Long> notBackAcceptIds = fscCheckResultPoList.stream().filter(fscCheckResultPO -> notBackOrderNos.contains(fscCheckResultPO.getOtherNo())).map(FscCheckResultPO::getAcceptOrderId).collect(Collectors.toList());
                    List<FscCheckResultPO> backFscCheckResultPOS = fscCheckResultPoList.stream().filter(fscCheckResultPO -> backOrderNos.contains(fscCheckResultPO.getOtherNo())).collect(Collectors.toList());
                    Map<Long, FscOrderInfoBO> backFscOrderInfoMap = queryAtomRspBO.getFscOrderInfoBoMap().values().stream().filter(fscOrderInfoBO -> backOrderNos.contains(fscOrderInfoBO.getExtOrderNo())).collect(Collectors.toMap(FscOrderInfoBO::getAcceptOrderId, o -> o));
                    this.check(backFscCheckResultPOS, jdOrderDetailBOS, null, reqBO, backFscOrderInfoMap);
                    this.getEcomCheckDataFailUpdateCheckStateToNotEquals(notBackAcceptIds, fscOrderInfoBoMap, reqBO);
                    log.error("\u7535\u5546\u672a\u8fd4\u56de\u7684\u9a8c\u6536\u5355\uff1a{}", (Object)JSON.toJSONString(notBackAcceptIds));
                }
                this.check(fscCheckResultPoList, jdOrderDetailBOS, null, reqBO, queryAtomRspBO.getFscOrderInfoBoMap());
            } else {
                this.getEcomCheckDataFailUpdateCheckStateToNotEquals(acceptIds, fscOrderInfoBoMap, reqBO);
                log.error("\u672a\u67e5\u8be2\u5230\u4eac\u4e1c\u7535\u5546\u6570\u636e\uff0c\u9a8c\u6536\u5355\uff1a{}", (Object)JSON.toJSONString(acceptIds));
            }
        }
        return new FscBillEcomCheckBusiRspBO();
    }

    private void check(List<FscCheckResultPO> fscCheckResultPoList, List<FscEcomJdOrderDetailBO> jdOrders, List<FscCheckOrderEntity> extOrders, FscBillEcomCheckBusiReqBO reqBO, Map<Long, FscOrderInfoBO> fscOrderInfoMap) {
        Map<Object, Object> exts;
        Map<Long, RelOrderBO> relOrderBoMap = reqBO.getRelOrderList().stream().collect(Collectors.toMap(RelOrderBO::getAcceptOrderId, o -> o));
        Map<Long, String> orderMap = fscCheckResultPoList.stream().collect(Collectors.toMap(FscCheckResultPO::getAcceptOrderId, FscCheckResultPO::getOtherNo));
        HashMap ours = new HashMap(16);
        fscOrderInfoMap.forEach((acceptOrderId, fscOrderInfoBO) -> ours.put(acceptOrderId, fscOrderInfoBO.getInspTotalPurchaseMoney()));
        if (log.isDebugEnabled()) {
            log.debug("\u8ba2\u5355\uff1a{}", (Object)JSON.toJSONString(ours));
        }
        if ("OTHER_ECOM".equals(reqBO.getEcomType())) {
            exts = extOrders.stream().collect(Collectors.toMap(FscCheckOrderEntity::getOrderId, FscCheckOrderEntity::getOrderPrice));
        } else {
            exts = new HashMap(jdOrders.size());
            for (FscEcomJdOrderDetailBO jdOrder : jdOrders) {
                if (jdOrder.getSumRefundAmount() != null) {
                    exts.put(jdOrder.getOrderNo(), jdOrder.getOrderAmount().subtract(jdOrder.getSumRefundAmount()));
                    continue;
                }
                exts.put(jdOrder.getOrderNo(), jdOrder.getOrderAmount());
            }
        }
        if (log.isDebugEnabled()) {
            log.debug("\u5916\u90e8\u8ba2\u5355\uff1a{}", (Object)JSON.toJSONString(exts));
        }
        ArrayList uocOrderSyncCheckStatusReqBoList = new ArrayList();
        orderMap.forEach((k, v) -> {
            BigDecimal ourPrice = (BigDecimal)ours.get(k);
            BigDecimal extPrice = (BigDecimal)exts.get(v);
            FscCheckResultPO fscCheckResult = new FscCheckResultPO();
            FscUocOrderSyncCheckStatusReqBO uocOrderSyncCheckStatusReqBO = new FscUocOrderSyncCheckStatusReqBO();
            fscCheckResult.setAcceptOrderId(k);
            fscCheckResult.setCheckTime(new Date());
            fscCheckResult.setOperId(reqBO.getUserId());
            fscCheckResult.setOperName(reqBO.getName());
            fscCheckResult.setOtherAmount((BigDecimal)exts.get(v));
            fscCheckResult.setAmount(ourPrice);
            if (ourPrice.compareTo(extPrice) == 0) {
                fscCheckResult.setStatus(FscConstants.BillCheck.EQUALS);
                uocOrderSyncCheckStatusReqBO.setCheckState(FscConstants.BillCheck.EQUALS);
            } else {
                fscCheckResult.setStatus(FscConstants.BillCheck.NOT_EQUALS);
                uocOrderSyncCheckStatusReqBO.setCheckState(FscConstants.BillCheck.NOT_EQUALS);
            }
            this.fscCheckResultMapper.updateByOrderId(fscCheckResult);
            List skuList = ((FscOrderInfoBO)fscOrderInfoMap.get(k)).getFscOrderItemBOS();
            ArrayList<FscCheckResultItemPO> fscCheckResultItemPOS = new ArrayList<FscCheckResultItemPO>();
            for (FscOrderItemBO fscOrderItemBO : skuList) {
                FscCheckResultItemPO fscCheckResultItem = new FscCheckResultItemPO();
                fscCheckResultItem.setId(Long.valueOf(Sequence.getInstance().nextId()));
                fscCheckResultItem.setOrderId(fscOrderItemBO.getOrderId());
                fscCheckResultItem.setAcceptOrderId(fscOrderItemBO.getAcceptOrderId());
                fscCheckResultItem.setFscOrderId(fscOrderItemBO.getFscOrderId());
                fscCheckResultItem.setSkuId(fscOrderItemBO.getSkuId());
                fscCheckResultItem.setPrice(fscOrderItemBO.getPurchasePrice());
                fscCheckResultItem.setAmount(fscOrderItemBO.getInspPurchaseMoney());
                fscCheckResultItem.setNum(fscOrderItemBO.getNum());
                fscCheckResultItemPOS.add(fscCheckResultItem);
            }
            if (!CollectionUtils.isEmpty(fscCheckResultItemPOS)) {
                List acceptOrderIds = fscCheckResultItemPOS.stream().map(FscCheckResultItemPO::getAcceptOrderId).collect(Collectors.toList());
                if (!CollectionUtils.isEmpty(acceptOrderIds)) {
                    this.fscCheckResultItemMapper.deleteByAcceptOrderId(acceptOrderIds);
                }
                this.fscCheckResultItemMapper.insertBatch(fscCheckResultItemPOS);
            }
            uocOrderSyncCheckStatusReqBO.setInspectionVoucherId(k);
            uocOrderSyncCheckStatusReqBO.setOrderId(((FscOrderItemBO)skuList.get(0)).getOrderId());
            uocOrderSyncCheckStatusReqBoList.add(uocOrderSyncCheckStatusReqBO);
        });
        for (FscUocOrderSyncCheckStatusReqBO uocOrderSyncCheckStatusReqBO : uocOrderSyncCheckStatusReqBoList) {
            FscUocOrderSyncCheckStatusRspBO uocOrderSyncCheckStatusRspBO = this.fscUocOrderSyncCheckStatusAbilityService.dealSyncCheckStatus(uocOrderSyncCheckStatusReqBO);
            if ("0000".equals(uocOrderSyncCheckStatusRspBO.getRespCode())) continue;
            this.writeFailLog(uocOrderSyncCheckStatusRspBO, uocOrderSyncCheckStatusReqBO, relOrderBoMap);
        }
    }

    private void writeFailLog(FscUocOrderSyncCheckStatusRspBO uocOrderSyncCheckStatusRspBO, FscUocOrderSyncCheckStatusReqBO uocOrderSyncCheckStatusReqBO, Map<Long, RelOrderBO> relOrderBoMap) {
        FscOrderFailLogUpdateAtomReqBO fscOrderFailLogUpdateAtomReqBO = new FscOrderFailLogUpdateAtomReqBO();
        long id = Sequence.getInstance().nextId();
        fscOrderFailLogUpdateAtomReqBO.setId(Long.valueOf(id));
        fscOrderFailLogUpdateAtomReqBO.setObjId(uocOrderSyncCheckStatusReqBO.getOrderId());
        fscOrderFailLogUpdateAtomReqBO.setObjNo(relOrderBoMap.get(uocOrderSyncCheckStatusReqBO.getOrderId()).getOtherNo());
        fscOrderFailLogUpdateAtomReqBO.setBusiType(FscConstants.FscOrderFailRetansBusiType.ORDER_CHECK_STATUS_SYNC);
        fscOrderFailLogUpdateAtomReqBO.setBusiFailDesc(uocOrderSyncCheckStatusRspBO.getRespDesc());
        FscOrderFailLogUpdateAtomRspBO fscOrderFailLogUpdateAtomRspBO = this.fscOrderFailLogUpdateAtomService.dealInsert(fscOrderFailLogUpdateAtomReqBO);
        if (!"0000".equals(fscOrderFailLogUpdateAtomRspBO.getRespCode())) {
            throw new FscBusinessException("193002", fscOrderFailLogUpdateAtomRspBO.getRespDesc());
        }
    }

    private void getEcomCheckDataFailUpdateCheckStateToNotEquals(List<Long> acceptIds, Map<Long, FscOrderInfoBO> fscOrderInfoBoMap, FscBillEcomCheckBusiReqBO reqBO) {
        Map<Long, RelOrderBO> relOrderBoMap = reqBO.getRelOrderList().stream().collect(Collectors.toMap(RelOrderBO::getAcceptOrderId, o -> o));
        FscCheckResultPO fscCheckResult = new FscCheckResultPO();
        fscCheckResult.setAcceptOrderIds(acceptIds);
        this.fscCheckResultMapper.updateStatusByAcceptOrderIds(acceptIds, FscConstants.BillCheck.NOT_EQUALS);
        acceptIds.forEach(acceptId -> {
            FscUocOrderSyncCheckStatusReqBO uocOrderSyncCheckStatusReqBO = new FscUocOrderSyncCheckStatusReqBO();
            uocOrderSyncCheckStatusReqBO.setCheckState(FscConstants.BillCheck.NOT_EQUALS);
            uocOrderSyncCheckStatusReqBO.setInspectionVoucherId(acceptId);
            uocOrderSyncCheckStatusReqBO.setOrderId(((FscOrderInfoBO)fscOrderInfoBoMap.get(acceptId)).getOrderId());
            FscUocOrderSyncCheckStatusRspBO uocOrderSyncCheckStatusRspBO = this.fscUocOrderSyncCheckStatusAbilityService.dealSyncCheckStatus(uocOrderSyncCheckStatusReqBO);
            if (!"0000".equals(uocOrderSyncCheckStatusRspBO.getRespCode())) {
                this.writeFailLog(uocOrderSyncCheckStatusRspBO, uocOrderSyncCheckStatusReqBO, relOrderBoMap);
            }
        });
    }
}

