/*
 * Decompiled with CFR 0.152.
 */
package com.tydic.fsc.bill.busi.impl;

import com.tydic.fsc.bill.busi.api.FscBillOrderAdvanceWriteBusiService;
import com.tydic.fsc.bill.busi.bo.FscBillOrderAdvanceWriteBusiReqBO;
import com.tydic.fsc.bill.busi.bo.FscBillOrderAdvanceWriteBusiRspBO;
import com.tydic.fsc.bo.FscOrderItemBO;
import com.tydic.fsc.dao.FscAccountChargeMapper;
import com.tydic.fsc.dao.FscClaimDetailMapper;
import com.tydic.fsc.dao.FscOrderItemMapper;
import com.tydic.fsc.dao.FscOrderMapper;
import com.tydic.fsc.dao.FscOrderWriteRelationMapper;
import com.tydic.fsc.dao.FscWriteOffMapper;
import com.tydic.fsc.exception.FscBusinessException;
import com.tydic.fsc.po.FscAccountChargePO;
import com.tydic.fsc.po.FscClaimDetailPO;
import com.tydic.fsc.po.FscOrderItemPO;
import com.tydic.fsc.po.FscOrderPO;
import java.math.BigDecimal;
import java.util.List;
import org.springframework.beans.factory.annotation.Autowired;
import org.springframework.stereotype.Service;
import org.springframework.util.CollectionUtils;

@Service
public class FscBillOrderAdvanceWriteBusiServiceImpl
implements FscBillOrderAdvanceWriteBusiService {
    @Autowired
    private FscAccountChargeMapper fscAccountChargeMapper;
    @Autowired
    private FscOrderMapper fscOrderMapper;
    @Autowired
    private FscClaimDetailMapper fscClaimDetailMapper;
    @Autowired
    private FscWriteOffMapper fscWriteOffMapper;
    @Autowired
    private FscOrderWriteRelationMapper fscOrderWriteRelationMapper;
    @Autowired
    private FscOrderItemMapper fscOrderItemMapper;

    @Override
    public FscBillOrderAdvanceWriteBusiRspBO dealOrderAdvanceWrite(FscBillOrderAdvanceWriteBusiReqBO reqBO) {
        List<FscClaimDetailPO> fscClaimDetailList;
        int count;
        if (reqBO.getWriteOffAmount().compareTo(new BigDecimal(0)) > 0) {
            FscOrderPO fscOrderPO = new FscOrderPO();
            fscOrderPO.setWriteOffAmount(reqBO.getWriteOffAmountAdd());
            fscOrderPO.setFscOrderId(reqBO.getOrderId());
            count = this.fscOrderMapper.updateWriteOffAmountAdd(fscOrderPO);
            if (count != 1) {
                throw new FscBusinessException("198888", "\u7cfb\u7edf\u7e41\u5fd9,\u8bf7\u7a0d\u540e\u91cd\u65b0\u64cd\u4f5c\u3002");
            }
        }
        if (null != reqBO.getFscAccountChargePOS()) {
            for (FscAccountChargePO fscAccountChargePOFor : reqBO.getFscAccountChargePOS()) {
                FscAccountChargePO fscAccountChargePo = new FscAccountChargePO();
                fscAccountChargePo.setWriteOffAmount(fscAccountChargePOFor.getWriteOffAmount());
                fscAccountChargePo.setChargeId(fscAccountChargePOFor.getChargeId());
                this.fscAccountChargeMapper.updateWriteOffAmountById(fscAccountChargePo);
            }
        }
        if (!CollectionUtils.isEmpty(reqBO.getFscClaimDetailList()) && (count = this.fscClaimDetailMapper.updateWriteOffAmountByIdBatch(fscClaimDetailList = reqBO.getFscClaimDetailList())) != reqBO.getFscClaimDetailList().size()) {
            throw new FscBusinessException("198888", "\u7cfb\u7edf\u7e41\u5fd9,\u8bf7\u7a0d\u540e\u91cd\u65b0\u64cd\u4f5c\u3002");
        }
        if (!CollectionUtils.isEmpty(reqBO.getOrderItemList())) {
            for (FscOrderItemBO fscOrderItemBO : reqBO.getOrderItemList()) {
                FscOrderItemPO fscOrderItemPo = new FscOrderItemPO();
                fscOrderItemPo.setWriteOffAmount(fscOrderItemBO.getWriteOffAmount());
                fscOrderItemPo.setId(fscOrderItemBO.getId());
                fscOrderItemPo.setOrderId(fscOrderItemBO.getOrderId());
                fscOrderItemPo.setFscOrderId(fscOrderItemBO.getFscOrderId());
                this.fscOrderItemMapper.updateWriteOffAmountById(fscOrderItemPo);
            }
        }
        if (!CollectionUtils.isEmpty(reqBO.getFscWriteOffPOList())) {
            this.fscWriteOffMapper.insertBatch(reqBO.getFscWriteOffPOList());
        }
        if (!CollectionUtils.isEmpty(reqBO.getWriteRelationList())) {
            this.fscOrderWriteRelationMapper.insertBatch(reqBO.getWriteRelationList());
        }
        return new FscBillOrderAdvanceWriteBusiRspBO();
    }
}

