/*
 * Decompiled with CFR 0.152.
 */
package com.tydic.fsc.bill.busi.impl;

import com.alibaba.fastjson.JSONObject;
import com.ohaotian.plugin.db.Sequence;
import com.tydic.fsc.bill.ability.bo.FscBillOrderRefundCreateInvoiceBO;
import com.tydic.fsc.bill.atom.api.FscBillOrderRefundUpdateAtomService;
import com.tydic.fsc.bill.busi.api.FscBillOrderNewRefundUpdateBusiService;
import com.tydic.fsc.bill.busi.bo.FscBillOrderRefundUpdateBusiReqBO;
import com.tydic.fsc.bill.busi.bo.FscBillOrderRefundUpdateBusiRspBO;
import com.tydic.fsc.constants.FscConstants;
import com.tydic.fsc.constants.FscOrderSourceEnum;
import com.tydic.fsc.dao.FscAttachmentMapper;
import com.tydic.fsc.dao.FscInvoiceItemMapper;
import com.tydic.fsc.dao.FscInvoiceMapper;
import com.tydic.fsc.dao.FscInvoiceRefundRelationMapper;
import com.tydic.fsc.dao.FscOrderItemMapper;
import com.tydic.fsc.dao.FscOrderMapper;
import com.tydic.fsc.dao.FscOrderRefundMapper;
import com.tydic.fsc.dao.FscOrderRelationMapper;
import com.tydic.fsc.exception.FscBusinessException;
import com.tydic.fsc.po.FscInvoicePO;
import com.tydic.fsc.po.FscInvoiceRefundRelationPO;
import com.tydic.fsc.po.FscOrderItemPO;
import com.tydic.fsc.po.FscOrderPO;
import com.tydic.fsc.po.FscOrderRefundPO;
import com.tydic.uoc.common.ability.api.PebExtUpdateAbnormalRefundFlagAbilityService;
import com.tydic.uoc.common.ability.api.UocAbnormalSingleDetailsListQueryAbilityService;
import com.tydic.uoc.common.ability.bo.UocAbnormalSingleDetailsListQueryReqBO;
import com.tydic.uoc.common.ability.bo.UocAbnormalSingleDetailsListQueryRspBO;
import com.tydic.uoc.common.ability.bo.UocPebOrdShipAbnormalBO;
import java.math.BigDecimal;
import java.util.ArrayList;
import java.util.Collection;
import java.util.Date;
import java.util.HashMap;
import java.util.List;
import java.util.Map;
import java.util.Set;
import java.util.stream.Collectors;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;
import org.springframework.beans.factory.annotation.Autowired;
import org.springframework.stereotype.Service;
import org.springframework.util.CollectionUtils;

@Service
public class FscBillOrderNewRefundUpdateBusiServiceImpl
implements FscBillOrderNewRefundUpdateBusiService {
    private static final Logger log = LoggerFactory.getLogger(FscBillOrderNewRefundUpdateBusiServiceImpl.class);
    @Autowired
    private FscInvoiceRefundRelationMapper fscInvoiceRefundRelationMapper;
    @Autowired
    private FscOrderRefundMapper fscOrderRefundMapper;
    @Autowired
    private FscBillOrderRefundUpdateAtomService fscBillOrderRefundUpdateAtomService;
    @Autowired
    private FscInvoiceMapper fscInvoiceMapper;
    private static final Integer ABNORMAL_ALL_TAB_ID = 41001;
    private static final String ABNORMAL_STATE_TWO = "2";
    private static final String ABNORMAL_STATE_THREE = "3";
    private static final Integer ABNORMAL_PAGE_SIZE = 300;
    @Autowired
    private UocAbnormalSingleDetailsListQueryAbilityService uocAbnormalSingleDetailsListQueryAbilityService;
    @Autowired
    private FscOrderMapper fscOrderMapper;
    @Autowired
    private FscOrderItemMapper fscOrderItemMapper;
    @Autowired
    private FscInvoiceItemMapper fscInvoiceItemMapper;
    @Autowired
    private FscOrderRelationMapper fscOrderRelationMapper;
    @Autowired
    private FscAttachmentMapper fscAttachmentMapper;
    @Autowired
    private PebExtUpdateAbnormalRefundFlagAbilityService pebExtUpdateAbnormalRefundFlagAbilityService;

    @Override
    public FscBillOrderRefundUpdateBusiRspBO dealRefundUpdate(FscBillOrderRefundUpdateBusiReqBO reqBO) {
        return null;
    }

    private BigDecimal checkRefundAmt(FscBillOrderRefundUpdateBusiReqBO reqBO, List<FscBillOrderRefundCreateInvoiceBO> addInvoiceBOS, List<UocPebOrdShipAbnormalBO> abnormalOrderInfoList, List<FscOrderItemPO> rollBackAbnormalItemPOList) {
        List<Long> invoiceIds = addInvoiceBOS.stream().map(FscBillOrderRefundCreateInvoiceBO::getInvoiceId).collect(Collectors.toList());
        FscInvoicePO invoicePO = new FscInvoicePO();
        invoicePO.setFscOrderId(reqBO.getFscOrderId());
        invoicePO.setInvoiceIds(invoiceIds);
        List invoiceList = this.fscInvoiceMapper.getList(invoicePO);
        if (CollectionUtils.isEmpty((Collection)invoiceList)) {
            throw new FscBusinessException("198888", "\u672a\u67e5\u8be2\u5230\u53d1\u7968\u4fe1\u606f\uff01");
        }
        if (invoiceIds.size() != invoiceList.size()) {
            throw new FscBusinessException("198888", "\u6709\u53d1\u7968\u4fe1\u606f\u4e0d\u5b58\u5728\uff01");
        }
        BigDecimal refundAmt = BigDecimal.ZERO;
        BigDecimal abnormalOrderAmt = BigDecimal.ZERO;
        Map<Long, BigDecimal> invoiceIdRefundAmtMap = this.getAlreadyInvoiceIdRefundAmtMap(invoiceIds);
        Set<Long> alreadyRefundinvoiceIdSet = invoiceIdRefundAmtMap.keySet();
        Map<Long, BigDecimal> invoiceIdAmtMap = invoiceList.stream().collect(Collectors.toMap(FscInvoicePO::getInvoiceId, FscInvoicePO::getAmt));
        for (FscBillOrderRefundCreateInvoiceBO invoiceBO : addInvoiceBOS) {
            refundAmt = refundAmt.add(invoiceBO.getRefundAmt());
            BigDecimal amt = invoiceIdAmtMap.get(invoiceBO.getInvoiceId());
            if (alreadyRefundinvoiceIdSet.contains(invoiceBO.getInvoiceId())) {
                amt = amt.subtract(invoiceIdRefundAmtMap.get(invoiceBO.getInvoiceId()));
            }
            if (invoiceBO.getRefundAmt().compareTo(amt) <= 0) continue;
            throw new FscBusinessException("198888", "\u9000\u7968\u91d1\u989d\u4e0d\u80fd\u5927\u4e8e\u5f00\u7968\u91d1\u989d\uff01");
        }
        if (reqBO.getRefundReasonType().equals(FscConstants.RefundReasonType.ORDER_REFUND)) {
            Map<Object, Object> rollBackAbnormalIdMap = new HashMap();
            if (!CollectionUtils.isEmpty(rollBackAbnormalItemPOList)) {
                rollBackAbnormalIdMap = rollBackAbnormalItemPOList.stream().collect(Collectors.groupingBy(FscOrderItemPO::getAbnormalVoucherId));
            }
            for (UocPebOrdShipAbnormalBO uocPebOrdShipAbnormalBO : abnormalOrderInfoList) {
                BigDecimal changeFeeMoney = new BigDecimal(uocPebOrdShipAbnormalBO.getChangeFeeMoney()).abs();
                abnormalOrderAmt = abnormalOrderAmt.add(changeFeeMoney);
                Long abnormalVoucherId = Long.valueOf(uocPebOrdShipAbnormalBO.getAbnormalVoucherId());
                if (!rollBackAbnormalIdMap.containsKey(abnormalVoucherId)) continue;
                for (FscOrderItemPO fscOrderItemPO : (List)rollBackAbnormalIdMap.get(abnormalVoucherId)) {
                    abnormalOrderAmt = abnormalOrderAmt.add(fscOrderItemPO.getRefundAmt());
                }
            }
            if (refundAmt.compareTo(abnormalOrderAmt) > 0) {
                throw new FscBusinessException("198888", "\u9000\u7968\u91d1\u989d\u4e0d\u5141\u8bb8\u5927\u4e8e\u5f02\u5e38\u8ba2\u5355\u91d1\u989d\uff01");
            }
        }
        return refundAmt;
    }

    private void getInvoiceRelationInfo(FscBillOrderRefundUpdateBusiReqBO reqBO, List<FscInvoiceRefundRelationPO> insertInvoiceRelationList, Map<Long, Long> invoiceIdRelationMap, List<Long> delInvoiceRelationIdList, List<FscInvoiceRefundRelationPO> updateInvoiceRelationList) {
        Date nowDate = new Date();
        for (FscBillOrderRefundCreateInvoiceBO invoiceBO : reqBO.getInvoiceBOS()) {
            if (FscConstants.refundUpdateType.ADD.equals(invoiceBO.getType())) {
                FscInvoiceRefundRelationPO fscInvoiceRefundRelationPO = new FscInvoiceRefundRelationPO();
                fscInvoiceRefundRelationPO.setId(Long.valueOf(Sequence.getInstance().nextId()));
                fscInvoiceRefundRelationPO.setInvoiceId(invoiceBO.getInvoiceId());
                fscInvoiceRefundRelationPO.setFscOrderId(reqBO.getFscOrderId());
                fscInvoiceRefundRelationPO.setCreateTime(nowDate);
                fscInvoiceRefundRelationPO.setRefundAmt(invoiceBO.getRefundAmt());
                fscInvoiceRefundRelationPO.setRefundId(reqBO.getRefundId());
                insertInvoiceRelationList.add(fscInvoiceRefundRelationPO);
                continue;
            }
            Long id = invoiceIdRelationMap.get(invoiceBO.getInvoiceId());
            if (FscConstants.refundUpdateType.DELETE.equals(invoiceBO.getType())) {
                delInvoiceRelationIdList.add(id);
            }
            if (!FscConstants.refundUpdateType.UPDATE.equals(invoiceBO.getType()) || invoiceBO.getCompareRefundAmt() == null) continue;
            FscInvoiceRefundRelationPO fscInvoiceRefundRelationPO = new FscInvoiceRefundRelationPO();
            fscInvoiceRefundRelationPO.setId(id);
            fscInvoiceRefundRelationPO.setRefundAmt(invoiceBO.getCompareRefundAmt());
            updateInvoiceRelationList.add(fscInvoiceRefundRelationPO);
        }
    }

    private Map<Long, BigDecimal> getAlreadyInvoiceIdRefundAmtMap(List<Long> invoiceIds) {
        HashMap<Long, BigDecimal> invoiceIdRefundAmtMap = new HashMap<Long, BigDecimal>();
        FscInvoiceRefundRelationPO searchRefundRelationPO = new FscInvoiceRefundRelationPO();
        searchRefundRelationPO.setInvoiceIds(invoiceIds);
        List relationPOS = this.fscInvoiceRefundRelationMapper.getList(searchRefundRelationPO);
        if (!CollectionUtils.isEmpty((Collection)relationPOS)) {
            Set refundIdSet = relationPOS.stream().filter(e -> e.getRefundId() != null).map(FscInvoiceRefundRelationPO::getRefundId).collect(Collectors.toSet());
            if (!CollectionUtils.isEmpty(refundIdSet)) {
                FscOrderRefundPO fscOrderRefundPO = new FscOrderRefundPO();
                fscOrderRefundPO.setRefundIdList(new ArrayList(refundIdSet));
                List fscOrderRefundPOList = this.fscOrderRefundMapper.queryAll(fscOrderRefundPO);
                if (!CollectionUtils.isEmpty((Collection)fscOrderRefundPOList)) {
                    List delRefundIds = fscOrderRefundPOList.stream().filter(e -> FscConstants.RefundInvoiceStatus.DELETE.equals(e.getRefundStatus())).map(FscOrderRefundPO::getRefundId).collect(Collectors.toList());
                    relationPOS = relationPOS.stream().filter(e -> !delRefundIds.contains(e.getRefundId())).collect(Collectors.toList());
                }
            }
            if (!CollectionUtils.isEmpty((Collection)relationPOS)) {
                Map<Long, List<FscInvoiceRefundRelationPO>> invoiceIdMap = relationPOS.stream().collect(Collectors.groupingBy(FscInvoiceRefundRelationPO::getInvoiceId));
                for (Long invoiceId : invoiceIdMap.keySet()) {
                    List<FscInvoiceRefundRelationPO> refundRelationPOS = invoiceIdMap.get(invoiceId);
                    BigDecimal alreadyRefundAmt = BigDecimal.ZERO;
                    for (FscInvoiceRefundRelationPO refundRelationPO : refundRelationPOS) {
                        if (refundRelationPO.getRefundAmt() == null) continue;
                        alreadyRefundAmt = alreadyRefundAmt.add(refundRelationPO.getRefundAmt());
                    }
                    invoiceIdRefundAmtMap.put(invoiceId, alreadyRefundAmt);
                }
            }
        }
        return invoiceIdRefundAmtMap;
    }

    private List<UocPebOrdShipAbnormalBO> qryAbnormalOrderInfo(List<Long> abnormalIds, FscOrderPO orderPO) {
        UocAbnormalSingleDetailsListQueryReqBO abnormalReqBO = new UocAbnormalSingleDetailsListQueryReqBO();
        abnormalReqBO.setAbnormalVoucherIds(abnormalIds);
        abnormalReqBO.setPageSize(ABNORMAL_PAGE_SIZE.intValue());
        abnormalReqBO.setTabId(ABNORMAL_ALL_TAB_ID);
        if (FscOrderSourceEnum.ELECTRIC_MARKET.getCode().equals(orderPO.getOrderSource())) {
            abnormalReqBO.setAbnormalState(ABNORMAL_STATE_TWO);
        } else {
            abnormalReqBO.setAbnormalState(ABNORMAL_STATE_THREE);
        }
        if (orderPO.getReceiveType().equals(FscConstants.FscOrderReceiveType.PURCHASE)) {
            abnormalReqBO.setRefundDownFlag(FscConstants.FscRefundFlag.NO);
        } else {
            abnormalReqBO.setRefundUpFlag(FscConstants.FscRefundFlag.NO);
        }
        log.info("\u67e5\u8be2\u5f02\u5e38\u5355\u4fe1\u606f\u5165\u53c2" + JSONObject.toJSONString((Object)abnormalReqBO));
        UocAbnormalSingleDetailsListQueryRspBO abnormalRspBO = this.uocAbnormalSingleDetailsListQueryAbilityService.getAbnormalSingleDetailsListQuery(abnormalReqBO);
        if (!abnormalRspBO.getRespCode().equals("0000")) {
            throw new FscBusinessException(abnormalRspBO.getRespCode(), "\u8c03\u7528\u8ba2\u5355\u4e2d\u5fc3\u67e5\u8be2\u5f02\u5e38\u53d8\u66f4\u4fe1\u606f\u5f02\u5e38\uff1a" + abnormalRspBO.getRespDesc());
        }
        if (CollectionUtils.isEmpty((Collection)abnormalRspBO.getRows())) {
            throw new FscBusinessException("198888", "\u672a\u67e5\u8be2\u5230\u8ba2\u5355\u5f02\u5e38\u53d8\u66f4\u4fe1\u606f\uff01");
        }
        for (UocPebOrdShipAbnormalBO row : abnormalRspBO.getRows()) {
            BigDecimal changeFeeMoney = new BigDecimal(row.getChangeFeeMoney()).abs();
            if (orderPO.getReceiveType().equals(FscConstants.FscOrderReceiveType.PURCHASE)) {
                if (row.getRefundUpAmt() != null) {
                    changeFeeMoney = changeFeeMoney.subtract(row.getRefundUpAmt());
                }
            } else if (row.getRefundDownAmt() != null) {
                changeFeeMoney = changeFeeMoney.subtract(row.getRefundDownAmt());
            }
            row.setChangeFeeMoney(changeFeeMoney.toString());
        }
        return abnormalRspBO.getRows();
    }
}

