/*
 * Decompiled with CFR 0.152.
 */
package com.tydic.fsc.bill.busi.impl;

import com.alibaba.fastjson.JSON;
import com.ohaotian.plugin.db.Sequence;
import com.tydic.authority.busi.api.DycStationOrgSelectUserNameService;
import com.tydic.authority.busi.bo.DycStationOrgSelectUserNameReqBO;
import com.tydic.authority.busi.bo.DycStationOrgSelectUserNameRspBO;
import com.tydic.authority.busi.bo.UserBO;
import com.tydic.fsc.bill.ability.bo.FscBillOrderRefundCreateInvoiceBO;
import com.tydic.fsc.bill.busi.api.FscBillOrderSpecialRefundCreateBusiService;
import com.tydic.fsc.bill.busi.bo.FscBillOrderSpecialRefundCreateBusiReqBO;
import com.tydic.fsc.bill.busi.bo.FscBillOrderSpecialRefundCreateBusiRspBO;
import com.tydic.fsc.bo.AttachmentBO;
import com.tydic.fsc.bo.FscApprovalTaskQueryBO;
import com.tydic.fsc.busibase.atom.api.FscOrderStatusStartAtomService;
import com.tydic.fsc.busibase.atom.api.FscSendNotificationExtAtomService;
import com.tydic.fsc.busibase.atom.bo.FscOrderStatusStartAtomReqBO;
import com.tydic.fsc.busibase.atom.bo.FscOrderStatusStartAtomRspBO;
import com.tydic.fsc.busibase.atom.bo.FscSendNotificationExtAtomReqBO;
import com.tydic.fsc.constants.FscBillRefundInvoiceSerial;
import com.tydic.fsc.constants.FscConstants;
import com.tydic.fsc.constants.FscRefundFlowProcKeyEnum;
import com.tydic.fsc.dao.FscAttachmentMapper;
import com.tydic.fsc.dao.FscInvoiceItemMapper;
import com.tydic.fsc.dao.FscInvoiceMapper;
import com.tydic.fsc.dao.FscInvoiceRefundRelationMapper;
import com.tydic.fsc.dao.FscOrderItemMapper;
import com.tydic.fsc.dao.FscOrderMapper;
import com.tydic.fsc.dao.FscOrderRefundMapper;
import com.tydic.fsc.dao.FscOrderRelationMapper;
import com.tydic.fsc.dao.FscTaskCandidateMapper;
import com.tydic.fsc.exception.FscBusinessException;
import com.tydic.fsc.po.FscAttachmentPO;
import com.tydic.fsc.po.FscInvoiceItemPO;
import com.tydic.fsc.po.FscInvoiceRefundRelationPO;
import com.tydic.fsc.po.FscOrderItemPO;
import com.tydic.fsc.po.FscOrderPO;
import com.tydic.fsc.po.FscOrderRefundPO;
import com.tydic.fsc.po.FscOrderRelationPO;
import com.tydic.fsc.po.FscTaskCandidatePO;
import com.tydic.fsc.util.TaxUtils;
import com.tydic.plugin.encoded.service.CfcEncodedSerialGetService;
import com.tydic.plugin.encoded.service.bo.CfcEncodedSerialGetServiceReqBO;
import com.tydic.plugin.encoded.service.bo.CfcEncodedSerialGetServiceRspBO;
import com.tydic.uac.ability.UacNoTaskAuditCreateAbilityService;
import com.tydic.uac.ability.bo.UacNoTaskAuditCreateInfoReqBO;
import com.tydic.uac.ability.bo.UacNoTaskAuditCreateReqBO;
import com.tydic.uac.ability.bo.UacNoTaskAuditCreateRspBO;
import com.tydic.uac.bo.common.ApprovalObjBO;
import com.tydic.umc.general.ability.api.UmcEnterpriseOrgNameListQryAbilityService;
import com.tydic.umc.general.ability.bo.UmcDycEnterpriseOrgBO;
import com.tydic.umc.general.ability.bo.UmcEnterpriseOrgNameListQryAbilityReqBO;
import com.tydic.umc.general.ability.bo.UmcEnterpriseOrgNameListQryAbilityRspBO;
import java.math.BigDecimal;
import java.math.RoundingMode;
import java.util.ArrayList;
import java.util.Collection;
import java.util.Collections;
import java.util.Date;
import java.util.HashMap;
import java.util.List;
import java.util.Map;
import java.util.stream.Collectors;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;
import org.springframework.beans.BeanUtils;
import org.springframework.beans.factory.annotation.Autowired;
import org.springframework.beans.factory.annotation.Value;
import org.springframework.stereotype.Service;
import org.springframework.util.CollectionUtils;

@Service
public class FscBillOrderSpecialRefundCreateBusiServiceImpl
implements FscBillOrderSpecialRefundCreateBusiService {
    private static final Logger log = LoggerFactory.getLogger(FscBillOrderSpecialRefundCreateBusiServiceImpl.class);
    @Autowired
    private FscOrderMapper fscOrderMapper;
    @Autowired
    private FscAttachmentMapper fscAttachmentMapper;
    @Autowired
    private FscInvoiceMapper fscInvoiceMapper;
    @Autowired
    private FscOrderRefundMapper fscOrderRefundMapper;
    @Autowired
    private FscOrderRelationMapper fscOrderRelationMapper;
    @Autowired
    private FscOrderItemMapper fscOrderItemMapper;
    @Autowired
    private FscInvoiceRefundRelationMapper fscInvoiceRefundRelationMapper;
    @Autowired
    private FscInvoiceItemMapper fscInvoiceItemMapper;
    @Autowired
    private FscOrderStatusStartAtomService fscOrderStatusStartAtomService;
    @Autowired
    private FscTaskCandidateMapper fscTaskCandidateMapper;
    @Autowired
    private UmcEnterpriseOrgNameListQryAbilityService umcEnterpriseOrgNameListQryAbilityService;
    @Autowired
    private UacNoTaskAuditCreateAbilityService uacNoTaskAuditCreateAbilityService;
    @Autowired
    private DycStationOrgSelectUserNameService dycStationOrgSelectUserNameService;
    @Autowired
    private FscSendNotificationExtAtomService fscSendNotificationExtAtomService;
    @Autowired
    private CfcEncodedSerialGetService encodedSerialGetService;
    @Value(value="${fsc.main.pro.org:100096,100100}")
    private String proOrg;
    private static final String BUSI_NAME = "\u9000\u7968\u4e3b\u5355\u521b\u5efa";
    private static final String SEPARATOR = ",";

    @Override
    public FscBillOrderSpecialRefundCreateBusiRspBO dealSpecialRefundCreate(FscBillOrderSpecialRefundCreateBusiReqBO reqBO) {
        FscOrderPO orderPO = new FscOrderPO();
        orderPO.setFscOrderId(reqBO.getFscOrderId());
        orderPO = this.fscOrderMapper.getModelBy(orderPO);
        FscOrderItemPO orderItemPO = new FscOrderItemPO();
        orderItemPO.setFscOrderId(reqBO.getFscOrderId());
        List listNoPage = this.fscOrderItemMapper.getListNoPage(orderItemPO);
        FscOrderRefundPO refundPO = this.buildRefundInfo(reqBO, orderPO);
        List<FscInvoiceRefundRelationPO> invoiceList = this.buildRefundInvoiceInfo(reqBO, refundPO.getRefundId(), listNoPage);
        if (((FscOrderItemPO)listNoPage.get(0)).getCgPayAmount() != null) {
            refundPO.setActualPaidAmount(((FscOrderItemPO)listNoPage.get(0)).getCgPayAmount());
        } else {
            refundPO.setActualPaidAmount(orderPO.getTotalCharge());
        }
        ArrayList<Long> invoiceIds = new ArrayList<Long>();
        BigDecimal totalRefundAmt = BigDecimal.ZERO;
        for (FscBillOrderRefundCreateInvoiceBO invoiceBO : reqBO.getInvoiceBOS()) {
            invoiceIds.add(invoiceBO.getInvoiceId());
            totalRefundAmt = totalRefundAmt.add(invoiceBO.getRefundAmt());
        }
        refundPO.setRefundAmount(totalRefundAmt);
        List<FscOrderItemPO> orderItemList = this.buildRefundItemInfo(reqBO, invoiceIds, refundPO);
        HashMap<Long, FscOrderRelationPO> relationMap = new HashMap<Long, FscOrderRelationPO>();
        for (FscOrderItemPO fscOrderItemPO : orderItemList) {
            FscOrderRelationPO relationPO;
            fscOrderItemPO.setRefundId(refundPO.getRefundId());
            fscOrderItemPO.setFscOrderId(null);
            if (relationMap.get(fscOrderItemPO.getAcceptOrderId()) != null) {
                relationPO = (FscOrderRelationPO)relationMap.get(fscOrderItemPO.getAcceptOrderId());
                relationPO.setSettleAmt(relationPO.getSettleAmt().add(fscOrderItemPO.getAmt()));
            }
            relationPO = new FscOrderRelationPO();
            relationPO.setId(Long.valueOf(Sequence.getInstance().nextId()));
            relationPO.setAcceptOrderId(fscOrderItemPO.getAcceptOrderId());
            relationPO.setOrderId(fscOrderItemPO.getOrderId());
            relationPO.setRefundId(refundPO.getRefundId());
            relationPO.setSettleAmt(fscOrderItemPO.getAmt());
            relationMap.put(fscOrderItemPO.getAcceptOrderId(), relationPO);
        }
        ArrayList relationPOList = new ArrayList();
        for (Long key : relationMap.keySet()) {
            relationPOList.add(relationMap.get(key));
        }
        String string = this.qryRefundNo(refundPO);
        refundPO.setRefundNo(string);
        this.dealOperatorInfo(refundPO, reqBO);
        int count = this.fscInvoiceRefundRelationMapper.insertBatch(invoiceList);
        if (count != invoiceList.size()) {
            throw new FscBusinessException("198888", "\u63d2\u5165\u9000\u7968\u53d1\u7968\u4fe1\u606f\u5931\u8d25\uff01");
        }
        count = this.fscOrderRefundMapper.insert(refundPO);
        if (count != 1) {
            throw new FscBusinessException("198888", "\u63d2\u5165\u9000\u7968\u4e3b\u8868\u5931\u8d25\uff01");
        }
        count = this.fscOrderItemMapper.insertBatch(orderItemList);
        if (count != orderItemList.size()) {
            throw new FscBusinessException("198888", "\u63d2\u5165\u9000\u7968\u660e\u7ec6\u8868\u5931\u8d25\uff01");
        }
        count = this.fscOrderRelationMapper.insertBatch(relationPOList);
        if (count != relationPOList.size()) {
            throw new FscBusinessException("198888", "\u63d2\u5165\u9000\u5173\u8054\u7ec6\u8868\u5931\u8d25\uff01");
        }
        if (!CollectionUtils.isEmpty(reqBO.getFileList())) {
            ArrayList<FscAttachmentPO> attachmentList = new ArrayList<FscAttachmentPO>();
            for (AttachmentBO attachmentBO : reqBO.getFileList()) {
                FscAttachmentPO attachmentPO = new FscAttachmentPO();
                BeanUtils.copyProperties((Object)attachmentBO, (Object)attachmentPO);
                attachmentPO.setAttachmentId(Long.valueOf(Sequence.getInstance().nextId()));
                attachmentPO.setObjId(refundPO.getRefundId());
                attachmentPO.setObjType(FscConstants.AttachmentObjType.REFUND_INVOICE);
                attachmentPO.setAttachmentType(FscConstants.AttachmentType.REFUND_INVOICE);
                attachmentList.add(attachmentPO);
            }
            this.fscAttachmentMapper.insertBatch(attachmentList);
        }
        FscInvoiceItemPO invoiceItemPO = new FscInvoiceItemPO();
        invoiceItemPO.setInvoiceIds(invoiceIds);
        int invoiceItemCount = this.fscInvoiceItemMapper.getCheckBy(invoiceItemPO);
        count = this.fscInvoiceItemMapper.updateRefundAmtByIds(invoiceIds);
        if (count != invoiceItemCount) {
            throw new FscBusinessException("198888", "\u5360\u7528\u53d1\u7968\u660e\u7ec6\u9000\u7968\u91d1\u989d\u5931\u8d25\uff01");
        }
        if (reqBO.getOperationType().equals(FscConstants.RefundOperationType.SUBMIT)) {
            this.dealStartApproval(reqBO, refundPO);
            this.dealWorkFlow(refundPO);
        }
        FscBillOrderSpecialRefundCreateBusiRspBO rspBO = new FscBillOrderSpecialRefundCreateBusiRspBO();
        rspBO.setRefundId(refundPO.getRefundId());
        rspBO.setRespCode("0000");
        rspBO.setRespDesc("\u6210\u529f");
        return rspBO;
    }

    private void dealWorkFlow(FscOrderRefundPO refundPO) {
        FscOrderStatusStartAtomReqBO fscOrderStatusStartAtomReqBO = new FscOrderStatusStartAtomReqBO();
        fscOrderStatusStartAtomReqBO.setBusiName(BUSI_NAME);
        fscOrderStatusStartAtomReqBO.setOrderId(refundPO.getRefundId());
        fscOrderStatusStartAtomReqBO.setOrderFlowKey(refundPO.getOrderFlowKey());
        fscOrderStatusStartAtomReqBO.setOrderFlow(refundPO.getOrderFlow());
        HashMap<String, String> paramMap = new HashMap<String, String>();
        paramMap.put("startFlag", "1");
        fscOrderStatusStartAtomReqBO.setParamMap(paramMap);
        FscOrderStatusStartAtomRspBO fscOrderStatusStartAtomRspBO = this.fscOrderStatusStartAtomService.dealRefundStatusStart(fscOrderStatusStartAtomReqBO);
        if (!fscOrderStatusStartAtomRspBO.getRespCode().equals("0000")) {
            throw new FscBusinessException(fscOrderStatusStartAtomRspBO.getRespCode(), fscOrderStatusStartAtomRspBO.getRespDesc());
        }
    }

    private List<FscOrderItemPO> buildRefundItemInfo(FscBillOrderSpecialRefundCreateBusiReqBO reqBO, List<Long> invoiceIds, FscOrderRefundPO refundPO) {
        ArrayList<FscOrderItemPO> orderItemPOList = new ArrayList<FscOrderItemPO>();
        FscInvoiceItemPO invoiceItemPO = new FscInvoiceItemPO();
        invoiceItemPO.setInvoiceIds(invoiceIds);
        List invoiceList = this.fscInvoiceItemMapper.getList(invoiceItemPO);
        for (FscInvoiceItemPO itemPO : invoiceList) {
            FscOrderItemPO orderItemPO = new FscOrderItemPO();
            BeanUtils.copyProperties((Object)itemPO, (Object)orderItemPO);
            orderItemPO.setFscOrderId(null);
            orderItemPO.setId(Long.valueOf(Sequence.getInstance().nextId()));
            orderItemPO.setRefundId(refundPO.getRefundId());
            orderItemPO.setInvoiceItemId(itemPO.getId());
            orderItemPOList.add(orderItemPO);
        }
        return orderItemPOList;
    }

    private List<FscInvoiceRefundRelationPO> buildRefundInvoiceInfo(FscBillOrderSpecialRefundCreateBusiReqBO reqBO, Long refundId, List<FscOrderItemPO> listNoPage) {
        ArrayList<FscInvoiceRefundRelationPO> invoiceRefundRelationPOS = new ArrayList<FscInvoiceRefundRelationPO>();
        for (FscBillOrderRefundCreateInvoiceBO invoiceBO : reqBO.getInvoiceBOS()) {
            FscInvoiceRefundRelationPO refundRelationPO = new FscInvoiceRefundRelationPO();
            refundRelationPO.setRefundId(refundId);
            refundRelationPO.setInvoiceId(invoiceBO.getInvoiceId());
            refundRelationPO.setRefundAmt(invoiceBO.getRefundAmt());
            refundRelationPO.setId(Long.valueOf(Sequence.getInstance().nextId()));
            refundRelationPO.setFscOrderId(reqBO.getFscOrderId());
            refundRelationPO.setCreateTime(new Date());
            BigDecimal noTaxAmt = TaxUtils.calNoTaxAmt((BigDecimal)refundRelationPO.getRefundAmt(), (BigDecimal)listNoPage.get(0).getTaxRate().setScale(2, RoundingMode.HALF_UP));
            refundRelationPO.setTaxAmt(refundRelationPO.getRefundAmt().subtract(noTaxAmt));
            refundRelationPO.setUntaxAmt(noTaxAmt);
            if (reqBO.getOperationType().equals(FscConstants.RefundOperationType.SUBMIT)) {
                refundRelationPO.setInvoiceStatus(FscConstants.FscInvoiceStatus.TO_CONFIRM);
            } else {
                refundRelationPO.setInvoiceStatus(FscConstants.FscInvoiceStatus.VALID);
            }
            invoiceRefundRelationPOS.add(refundRelationPO);
        }
        return invoiceRefundRelationPOS;
    }

    private FscOrderRefundPO buildRefundInfo(FscBillOrderSpecialRefundCreateBusiReqBO reqBO, FscOrderPO orderPO) {
        FscOrderRefundPO refundPO = new FscOrderRefundPO();
        BeanUtils.copyProperties((Object)orderPO, (Object)refundPO);
        refundPO.setRefundId(Long.valueOf(Sequence.getInstance().nextId()));
        refundPO.setAgentDeptId(reqBO.getAgentDeptId());
        refundPO.setAgentDeptName(reqBO.getAgentDeptName());
        refundPO.setAgentUserId(reqBO.getAgentUserId());
        refundPO.setAgentUserName(reqBO.getAgentUserName());
        refundPO.setAuditStatus(FscConstants.AuditStatus.SAVE);
        refundPO.setRefundNote(reqBO.getRefundNote());
        refundPO.setRefundReason(reqBO.getRefundReason());
        refundPO.setRefundReasonType(reqBO.getRefundReasonType());
        refundPO.setTotalCharge(orderPO.getTotalCharge());
        refundPO.setCertification(reqBO.getCertification());
        refundPO.setCreateTime(new Date());
        refundPO.setCreateUserId(reqBO.getUserId());
        refundPO.setCreateUserName(reqBO.getName());
        refundPO.setRefundStatus(FscConstants.RefundInvoiceStatus.SAVE);
        refundPO.setPushStatus(FscConstants.RefundPushStatus.UN_PUSH);
        refundPO.setFscOrderNo(orderPO.getOrderNo());
        refundPO.setOrderFlow(FscConstants.OrderFlow.TRAFFIC_REFUND_INVOICE);
        refundPO.setIsPushUnify(orderPO.getSettlePlatform());
        if (refundPO.getIsPushUnify() == null) {
            refundPO.setIsPushUnify(Integer.valueOf(0));
        }
        refundPO.setPushUnifyStatus(FscConstants.FscPushStatus.NO_PUSH);
        refundPO.setOrderFlowKey(FscRefundFlowProcKeyEnum.TRAFFIC_REFUND_INVOICE.getDescr());
        refundPO.setYcUserId(reqBO.getYcUserId());
        refundPO.setYcPersonId(reqBO.getYcPersonId());
        refundPO.setYcPersonName(reqBO.getYcPersonName());
        refundPO.setYcDeptId(reqBO.getYcDeptId());
        refundPO.setYcDeptName(reqBO.getYcDeptName());
        refundPO.setExt1(reqBO.getAgentAccount());
        return refundPO;
    }

    private void dealOperatorInfo(FscOrderRefundPO refundPO, FscBillOrderSpecialRefundCreateBusiReqBO reqBO) {
        String[] split;
        refundPO.setOperatorId(reqBO.getUserId());
        refundPO.setOperatorName(reqBO.getName());
        for (String orgId : split = this.proOrg.split(SEPARATOR)) {
            if (!reqBO.getOrgPath().contains("-" + orgId + "-")) continue;
            refundPO.setOperationId(Long.valueOf(orgId));
            UmcEnterpriseOrgNameListQryAbilityReqBO abilityReqBO = new UmcEnterpriseOrgNameListQryAbilityReqBO();
            abilityReqBO.setOrgIdList(Collections.singletonList(Long.valueOf(orgId)));
            UmcEnterpriseOrgNameListQryAbilityRspBO rspBO = this.umcEnterpriseOrgNameListQryAbilityService.qryEnterpriseOrgNameList(abilityReqBO);
            if (rspBO.getRespCode().equals("0000") && !CollectionUtils.isEmpty((Map)rspBO.getOrgMap())) {
                Map orgMap = rspBO.getOrgMap();
                refundPO.setOperationName(((UmcDycEnterpriseOrgBO)orgMap.get(refundPO.getOperationId())).getOrgName());
                break;
            }
            throw new FscBusinessException("198888", "\u67e5\u8be2\u673a\u6784\u4fe1\u606f\u5f02\u5e38:" + rspBO.getRespDesc());
        }
    }

    private void dealStartApproval(FscBillOrderSpecialRefundCreateBusiReqBO reqBO, FscOrderRefundPO refundPO) {
        UacNoTaskAuditCreateReqBO auditCreateReqBO = new UacNoTaskAuditCreateReqBO();
        auditCreateReqBO.setCreateOperId(reqBO.getUserId().toString());
        auditCreateReqBO.setCreateOperName(reqBO.getName());
        auditCreateReqBO.setCreateOperDept(reqBO.getOrgName());
        auditCreateReqBO.setIsSaveCreateLog(Boolean.valueOf(true));
        auditCreateReqBO.setMenuId("M001040");
        auditCreateReqBO.setOrgId(reqBO.getOrgId().toString());
        ArrayList<UacNoTaskAuditCreateInfoReqBO> createBusiReqBO = new ArrayList<UacNoTaskAuditCreateInfoReqBO>();
        UacNoTaskAuditCreateInfoReqBO uacNoTaskAuditCreateInfoReqBO = new UacNoTaskAuditCreateInfoReqBO();
        uacNoTaskAuditCreateInfoReqBO.setObjType(FscConstants.AuditObjType.REFUND_INVOICE);
        uacNoTaskAuditCreateInfoReqBO.setObjNum("1");
        uacNoTaskAuditCreateInfoReqBO.setOrderId(refundPO.getRefundId());
        ArrayList<ApprovalObjBO> approvalObjBOList = new ArrayList<ApprovalObjBO>();
        ApprovalObjBO approvalObjBO = new ApprovalObjBO();
        approvalObjBO.setObjId(refundPO.getRefundId().toString());
        approvalObjBO.setObjName("\u5e73\u53f0\u6d41\u91cf\u8d39\u9000\u7968\u5355\u5ba1\u6279");
        approvalObjBO.setObjType(FscConstants.AuditObjType.REFUND_INVOICE);
        approvalObjBOList.add(approvalObjBO);
        uacNoTaskAuditCreateInfoReqBO.setApprovalObjInfo(approvalObjBOList);
        createBusiReqBO.add(uacNoTaskAuditCreateInfoReqBO);
        auditCreateReqBO.setCreateBusiReqBO(createBusiReqBO);
        log.info("\u5ba1\u6279\u5165\u53c2================" + JSON.toJSONString((Object)auditCreateReqBO));
        UacNoTaskAuditCreateRspBO uacNoTaskAuditCreateRspBO = this.uacNoTaskAuditCreateAbilityService.auditOrderCreate(auditCreateReqBO);
        log.info("\u5ba1\u6279\u51fa\u53c2================" + JSON.toJSONString((Object)uacNoTaskAuditCreateRspBO));
        if (!"0000".equals(uacNoTaskAuditCreateRspBO.getRespCode())) {
            throw new FscBusinessException("191019", uacNoTaskAuditCreateRspBO.getRespDesc());
        }
        if (uacNoTaskAuditCreateRspBO.getNotFindFlag().booleanValue()) {
            throw new FscBusinessException("190000", "\u8bf7\u8054\u7cfb\u7ba1\u7406\u5458\u914d\u7f6e\u7ed3\u7b97\u5355\u5ba1\u6279\u6d41\uff01");
        }
        FscTaskCandidatePO taskPo = new FscTaskCandidatePO();
        taskPo.setFscOrderId(refundPO.getRefundId());
        List pendAuditPostIdList = this.fscTaskCandidateMapper.getPendAuditPostIdList(taskPo);
        if (!CollectionUtils.isEmpty((Collection)pendAuditPostIdList)) {
            DycStationOrgSelectUserNameReqBO dycStationOrgSelectUserNameReqBO = new DycStationOrgSelectUserNameReqBO();
            dycStationOrgSelectUserNameReqBO.setStationId(Long.valueOf(((FscApprovalTaskQueryBO)pendAuditPostIdList.get(0)).getTaskOperId()));
            DycStationOrgSelectUserNameRspBO dycStationOrgSelectUserNameRspBO = this.dycStationOrgSelectUserNameService.selectUserName(dycStationOrgSelectUserNameReqBO);
            if (dycStationOrgSelectUserNameRspBO != null && !CollectionUtils.isEmpty((Collection)dycStationOrgSelectUserNameRspBO.getUserList())) {
                FscSendNotificationExtAtomReqBO fscSendNotificationExtAtomReqBO = new FscSendNotificationExtAtomReqBO();
                fscSendNotificationExtAtomReqBO.setTitel("\u9500\u552e\u9000\u7968\u7533\u8bf7\u5355");
                fscSendNotificationExtAtomReqBO.setText("\u3010\u4e2d\u56fd\u4e2d\u7164\u3011\u60a8\u6709\u5f85\u5ba1\u6279\u7684\u9000\u7968\u7533\u8bf7\u5355" + refundPO.getRefundNo() + "\u5df2\u63d0\u4ea4\u81f3\u60a8\u5904\u5ba1\u6279\uff0c\u8bf7\u53ca\u65f6\u5904\u7406\u3002");
                fscSendNotificationExtAtomReqBO.setUserId(reqBO.getUserId());
                fscSendNotificationExtAtomReqBO.setReceiveIds(dycStationOrgSelectUserNameRspBO.getUserList().stream().map(UserBO::getUserId).distinct().collect(Collectors.toList()));
                this.fscSendNotificationExtAtomService.sendNotification(fscSendNotificationExtAtomReqBO);
            }
        }
        FscOrderRefundPO updatePo = new FscOrderRefundPO();
        updatePo.setRefundId(refundPO.getRefundId());
        updatePo.setAuditStatus(FscConstants.AuditStatus.AUDITING);
        this.fscOrderRefundMapper.updateById(updatePo);
    }

    private String qryRefundNo(FscOrderRefundPO refundPO) {
        CfcEncodedSerialGetServiceReqBO encodedSerialGetServiceReqBO = new CfcEncodedSerialGetServiceReqBO();
        encodedSerialGetServiceReqBO.setCenter("FSC");
        encodedSerialGetServiceReqBO.setEncodedRuleCode(FscBillRefundInvoiceSerial.getInstance((String)(refundPO.getOrderType() + "")).getDesc());
        encodedSerialGetServiceReqBO.setNum(Integer.valueOf(1));
        CfcEncodedSerialGetServiceRspBO encodedSerialGetServiceRspBO = this.encodedSerialGetService.getEncodedSerial(encodedSerialGetServiceReqBO);
        if (!encodedSerialGetServiceRspBO.getRespCode().equals("0000") || CollectionUtils.isEmpty((Collection)encodedSerialGetServiceRspBO.getSerialNoList())) {
            throw new FscBusinessException("198888", "\u67e5\u8be2\u9000\u6b3e\u5355\u53f7\u7f16\u7801\u89c4\u5219\u5931\u8d25\uff01" + encodedSerialGetServiceRspBO.getRespDesc());
        }
        return (String)encodedSerialGetServiceRspBO.getSerialNoList().get(0);
    }
}

