/*
 * Decompiled with CFR 0.152.
 */
package com.tydic.fsc.bill.busi.impl;

import com.alibaba.fastjson.JSONObject;
import com.tydic.fsc.bill.busi.api.FscBillSendSaleFscOrderCancelBusiService;
import com.tydic.fsc.bill.busi.bo.FscBillSendSaleFscOrderCancelBusiReqBO;
import com.tydic.fsc.bill.busi.bo.FscBillSendSaleFscOrderCancelBusiRspBO;
import com.tydic.fsc.busibase.atom.api.FscOrderStatusFlowAtomService;
import com.tydic.fsc.busibase.atom.bo.FscOrderStatusFlowAtomReqBO;
import com.tydic.fsc.busibase.atom.bo.FscOrderStatusFlowAtomRspBO;
import com.tydic.fsc.constants.FscConstants;
import com.tydic.fsc.dao.FscAccountChargeMapper;
import com.tydic.fsc.dao.FscOrderItemMapper;
import com.tydic.fsc.dao.FscOrderMapper;
import com.tydic.fsc.dao.FscShouldPayMapper;
import com.tydic.fsc.enums.FscWriteOffAmountBusiTypeEnum;
import com.tydic.fsc.exception.FscBusinessException;
import com.tydic.fsc.po.FscAccountChargePO;
import com.tydic.fsc.po.FscOrderItemPO;
import com.tydic.fsc.po.FscOrderPO;
import com.tydic.fsc.po.FscShouldPayPO;
import java.util.Collection;
import java.util.HashMap;
import java.util.List;
import java.util.stream.Collectors;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;
import org.springframework.beans.factory.annotation.Autowired;
import org.springframework.stereotype.Service;
import org.springframework.util.CollectionUtils;

@Service
public class FscBillSendSaleFscOrderCancelBusiServiceImpl
implements FscBillSendSaleFscOrderCancelBusiService {
    private static final Logger log = LoggerFactory.getLogger(FscBillSendSaleFscOrderCancelBusiServiceImpl.class);
    @Autowired
    private FscOrderStatusFlowAtomService fscOrderStatusFlowAtomService;
    @Autowired
    private FscOrderItemMapper fscOrderItemMapper;
    private static final String BUSI_NAME = "\u53d6\u6d88\u5f00\u7968";
    @Autowired
    private FscShouldPayMapper fscShouldPayMapper;
    @Autowired
    private FscAccountChargeMapper fscAccountChargeMapper;
    @Autowired
    private FscOrderMapper fscOrderMapper;

    @Override
    public FscBillSendSaleFscOrderCancelBusiRspBO sendSaleFscOrderCancel(FscBillSendSaleFscOrderCancelBusiReqBO reqBO) {
        FscBillSendSaleFscOrderCancelBusiRspBO rspBO = new FscBillSendSaleFscOrderCancelBusiRspBO();
        rspBO.setRespCode("0000");
        rspBO.setRespDesc("\u6210\u529f");
        List tempList = this.fscOrderMapper.getListOrderWriteOffWriteTemp(reqBO.getOrderId());
        if (CollectionUtils.isEmpty((Collection)tempList)) {
            this.orderStateFlow(reqBO);
            return rspBO;
        }
        List orderList = tempList.stream().filter(temp -> FscWriteOffAmountBusiTypeEnum.ORDER.getCode().equals(temp.getBusiType())).collect(Collectors.toList());
        log.debug("\u7ed3\u7b97\u5355\u6838\u9500\u6570\u636e\uff1a" + JSONObject.toJSONString(orderList));
        if (!CollectionUtils.isEmpty(orderList)) {
            for (Object f : orderList) {
                f.setWriteOffAmount(f.getWriteOffAmount().subtract(f.getWriteOffAmountAdd()));
                this.fscOrderMapper.updateById((FscOrderPO)f);
            }
        }
        List shouldList = tempList.stream().filter(temp -> FscWriteOffAmountBusiTypeEnum.SHOULD.getCode().equals(temp.getBusiType())).collect(Collectors.toList());
        log.debug("\u5e94\u4ed8\u5355\u6838\u9500\u6570\u636e\uff1a" + JSONObject.toJSONString(shouldList));
        if (!CollectionUtils.isEmpty(shouldList)) {
            for (Object f : shouldList) {
                FscShouldPayPO fscShouldPayPO = new FscShouldPayPO();
                fscShouldPayPO.setShouldPayId(f.getBusiId());
                fscShouldPayPO.setWriteOffAmount(f.getWriteOffAmountAdd());
                this.fscShouldPayMapper.updateWriteOffAmountReturn(fscShouldPayPO);
            }
        }
        List itemList = tempList.stream().filter(temp -> FscWriteOffAmountBusiTypeEnum.ITEM.getCode().equals(temp.getBusiType())).collect(Collectors.toList());
        log.debug("\u9884\u4ed8\u6b3e\u6838\u9500\u6570\u636e\uff1a" + JSONObject.toJSONString(itemList));
        if (!CollectionUtils.isEmpty(itemList)) {
            for (FscOrderPO f : itemList) {
                FscOrderItemPO fscOrderItemPO = new FscOrderItemPO();
                fscOrderItemPO.setId(f.getBusiId());
                fscOrderItemPO.setWriteOffAmount(f.getWriteOffAmountAdd());
                this.fscOrderItemMapper.updateWriteOffAmountReturn(fscOrderItemPO);
            }
        }
        List chargeList = tempList.stream().filter(temp -> FscWriteOffAmountBusiTypeEnum.CHARGE.getCode().equals(temp.getBusiType())).collect(Collectors.toList());
        log.debug("\u5145\u503c\u6838\u9500\u6570\u636e\uff1a" + JSONObject.toJSONString(itemList));
        if (!CollectionUtils.isEmpty(chargeList)) {
            for (FscOrderPO f : chargeList) {
                FscAccountChargePO fscAccountChargePO = new FscAccountChargePO();
                fscAccountChargePO.setChargeId(f.getBusiId());
                fscAccountChargePO.setWriteOffAmount(f.getWriteOffAmountAdd());
                this.fscAccountChargeMapper.updateWriteOffAmountReturn(fscAccountChargePO);
            }
        }
        this.fscOrderMapper.deleteOrderWriteOffWriteTemp(reqBO.getOrderId());
        this.orderStateFlow(reqBO);
        return rspBO;
    }

    void orderStateFlow(FscBillSendSaleFscOrderCancelBusiReqBO reqBO) {
        FscOrderStatusFlowAtomReqBO fscOrderStatusFlowAtomReqBO = new FscOrderStatusFlowAtomReqBO();
        fscOrderStatusFlowAtomReqBO.setBusiName(BUSI_NAME);
        fscOrderStatusFlowAtomReqBO.setOrderId(reqBO.getOrderId());
        fscOrderStatusFlowAtomReqBO.setCurStatus(reqBO.getCurStatus());
        HashMap<String, Integer> paramMap = new HashMap<String, Integer>(4);
        paramMap.put("auditFlag", FscConstants.BilledParam.auditFlag3);
        fscOrderStatusFlowAtomReqBO.setParamMap(paramMap);
        FscOrderStatusFlowAtomRspBO fscOrderStatusFlowAtomRspBO = this.fscOrderStatusFlowAtomService.dealStatusFlow(fscOrderStatusFlowAtomReqBO);
        if (!"0000".equals(fscOrderStatusFlowAtomRspBO.getRespCode())) {
            throw new FscBusinessException("193011", fscOrderStatusFlowAtomRspBO.getRespDesc());
        }
    }
}

