/*
 * Decompiled with CFR 0.152.
 */
package com.tydic.fsc.bill.busi.impl;

import com.ohaotian.plugin.db.Sequence;
import com.tydic.fsc.bill.busi.api.FscBillValidOverdraftBusiService;
import com.tydic.fsc.bill.busi.bo.FscBillValidOverdraftBusiReqBO;
import com.tydic.fsc.bill.busi.bo.FscBillValidOverdraftBusiRspBO;
import com.tydic.fsc.constants.FscConstants;
import com.tydic.fsc.dao.FscAttachmentMapper;
import com.tydic.fsc.dao.FscDicDictionaryMapper;
import com.tydic.fsc.dao.FscPayLogMapper;
import com.tydic.fsc.po.FscAttachmentPO;
import com.tydic.fsc.po.FscDicDictionaryPO;
import java.util.Collection;
import java.util.Date;
import java.util.List;
import java.util.stream.Collectors;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;
import org.springframework.beans.factory.annotation.Autowired;
import org.springframework.stereotype.Service;
import org.springframework.util.CollectionUtils;

@Service
public class FscBillValidOverdraftBusiServiceImpl
implements FscBillValidOverdraftBusiService {
    private static final Logger log = LoggerFactory.getLogger(FscBillValidOverdraftBusiServiceImpl.class);
    @Autowired
    private FscPayLogMapper fscPayLogMapper;
    @Autowired
    private FscDicDictionaryMapper fscDicDictionaryMapper;
    @Autowired
    private FscAttachmentMapper fscAttachmentMapper;

    @Override
    public FscBillValidOverdraftBusiRspBO dealCreate(FscBillValidOverdraftBusiReqBO reqBO) {
        FscBillValidOverdraftBusiRspBO busiRspBO = new FscBillValidOverdraftBusiRspBO();
        busiRspBO.setRespCode("0000");
        busiRspBO.setRespDesc("\u6210\u529f");
        List fscPayLogPOList = this.fscPayLogMapper.validPayLog(reqBO.getOrderCodeList());
        FscDicDictionaryPO fscDicDictionaryPO = new FscDicDictionaryPO();
        fscDicDictionaryPO.setPCode("FSC_OVERDRAFT_VALID");
        List fscDicDictionaryPOList = this.fscDicDictionaryMapper.getListByCondition(fscDicDictionaryPO);
        if (CollectionUtils.isEmpty((Collection)fscDicDictionaryPOList)) {
            return busiRspBO;
        }
        return busiRspBO;
    }

    @Override
    public FscBillValidOverdraftBusiRspBO dealAttachment(FscBillValidOverdraftBusiReqBO reqBO) {
        FscBillValidOverdraftBusiRspBO busiRspBO = new FscBillValidOverdraftBusiRspBO();
        busiRspBO.setRespCode("0000");
        busiRspBO.setRespDesc("\u6210\u529f");
        FscAttachmentPO attpo = new FscAttachmentPO();
        attpo.setFscOrderId(reqBO.getBos().get(0).getFscOrderId());
        attpo.setAttachmentType(FscConstants.AttachmentType.DOWN_PDF_SNAPSHOT);
        this.fscAttachmentMapper.deleteBy(attpo);
        Date date = new Date();
        List pos = reqBO.getBos().stream().map(x -> {
            FscAttachmentPO po = new FscAttachmentPO();
            po.setFscOrderId(x.getFscOrderId());
            po.setObjId(x.getFscOrderId());
            po.setAttachmentId(Long.valueOf(Sequence.getInstance().nextId()));
            po.setObjType(FscConstants.AttachmentObjType.DOWN_PDF_SNAPSHOT);
            po.setAttachmentType(FscConstants.AttachmentType.DOWN_PDF_SNAPSHOT);
            po.setAttachmentUrl(x.getPrintUrl());
            po.setAttachmentName("\u8fc7\u8d26\u9644\u4ef6\u5feb\u7167-\u4e1a\u8d22\u6253\u5370\u4f7f\u7528");
            po.setCreateTime(date);
            return po;
        }).collect(Collectors.toList());
        this.fscAttachmentMapper.insertBatch(pos);
        return busiRspBO;
    }

    @Override
    public FscBillValidOverdraftBusiRspBO dealDownRefundAttachment(FscBillValidOverdraftBusiReqBO reqBO) {
        FscBillValidOverdraftBusiRspBO busiRspBO = new FscBillValidOverdraftBusiRspBO();
        busiRspBO.setRespCode("0000");
        busiRspBO.setRespDesc("\u6210\u529f");
        FscAttachmentPO attpo = new FscAttachmentPO();
        attpo.setFscOrderId(reqBO.getBos().get(0).getFscOrderId());
        attpo.setAttachmentType(FscConstants.AttachmentType.DOWN_REFUND_PDF_SNAPSHOT);
        this.fscAttachmentMapper.deleteBy(attpo);
        Date date = new Date();
        List pos = reqBO.getBos().stream().map(x -> {
            FscAttachmentPO po = new FscAttachmentPO();
            po.setFscOrderId(x.getFscOrderId());
            po.setObjId(x.getFscOrderId());
            po.setAttachmentId(Long.valueOf(Sequence.getInstance().nextId()));
            po.setObjType(FscConstants.AttachmentObjType.DOWN_REFUND_PDF_SNAPSHOT);
            po.setAttachmentType(FscConstants.AttachmentType.DOWN_REFUND_PDF_SNAPSHOT);
            po.setAttachmentUrl(x.getPrintUrl());
            po.setAttachmentName("\u4e0b\u6e38\u9000\u7968\u5355\u8fc7\u8d26\u9644\u4ef6\u5feb\u7167-\u4e1a\u8d22\u6253\u5370\u4f7f\u7528");
            po.setCreateTime(date);
            return po;
        }).collect(Collectors.toList());
        this.fscAttachmentMapper.insertBatch(pos);
        return busiRspBO;
    }
}

