/*
 * Decompiled with CFR 0.152.
 */
package com.tydic.fsc.bill.busi.impl;

import com.tydic.fsc.bill.busi.api.FscFinanceWriteOffApprovalBusiService;
import com.tydic.fsc.bill.busi.api.FscFinanceWriteOffCancelBusiService;
import com.tydic.fsc.busibase.busi.bo.FscFinanceWriteOffCancelServiceBusiReqBO;
import com.tydic.fsc.busibase.busi.bo.FscFinanceWriteOffCancelServiceBusiRspBO;
import com.tydic.fsc.constants.FscConstants;
import com.tydic.fsc.dao.FscFinanceWriteOffAdjustDetailMapper;
import com.tydic.fsc.dao.FscFinanceWriteOffAdjustMapper;
import com.tydic.fsc.dao.FscOrderMapper;
import com.tydic.fsc.dao.FscOrderPayItemMapper;
import com.tydic.fsc.exception.FscBusinessException;
import com.tydic.fsc.po.FscFinanceWriteOffAdjustDetailPO;
import com.tydic.fsc.po.FscFinanceWriteOffAdjustPO;
import com.tydic.fsc.po.FscOrderPO;
import com.tydic.fsc.po.FscOrderPayItemPO;
import java.math.BigDecimal;
import java.util.Date;
import java.util.List;
import org.springframework.beans.factory.annotation.Autowired;
import org.springframework.stereotype.Service;

@Service
public class FscFinanceWriteOffCancelBusiServiceImpl
implements FscFinanceWriteOffCancelBusiService {
    @Autowired
    private FscFinanceWriteOffApprovalBusiService fscFinanceWriteOffApprovalBusiService;
    @Autowired
    private FscFinanceWriteOffAdjustMapper fscFinanceWriteOffAdjustMapper;
    @Autowired
    private FscFinanceWriteOffAdjustDetailMapper fscFinanceWriteOffAdjustDetailMapper;
    @Autowired
    private FscOrderPayItemMapper fscOrderPayItemMapper;
    @Autowired
    private FscOrderMapper fscOrderMapper;

    @Override
    public FscFinanceWriteOffCancelServiceBusiRspBO cancelFinanceWriteOff(FscFinanceWriteOffCancelServiceBusiReqBO reqBO) {
        FscFinanceWriteOffCancelServiceBusiRspBO rspBO = new FscFinanceWriteOffCancelServiceBusiRspBO();
        for (FscFinanceWriteOffAdjustPO adjustPO : reqBO.getList()) {
            this.dealAmount(adjustPO);
            FscFinanceWriteOffAdjustPO adjustPo = new FscFinanceWriteOffAdjustPO();
            adjustPo.setUpdateTime(new Date());
            adjustPo.setUpdateUserId(reqBO.getUserId());
            adjustPo.setUpdateUserName(reqBO.getUserName());
            adjustPo.setBillStatus(FscConstants.WriteOffBillStatus.CANCELED);
            FscFinanceWriteOffAdjustPO where = new FscFinanceWriteOffAdjustPO();
            where.setAdjustId(adjustPO.getAdjustId());
            this.fscFinanceWriteOffAdjustMapper.updateBy(adjustPo, where);
        }
        rspBO.setRespCode("0000");
        rspBO.setRespDesc("\u6210\u529f");
        return rspBO;
    }

    public void dealAmount(FscFinanceWriteOffAdjustPO adjustPO) {
        FscFinanceWriteOffAdjustDetailPO adjustDetailPO = new FscFinanceWriteOffAdjustDetailPO();
        adjustDetailPO.setAdjustId(adjustPO.getAdjustId());
        List list = this.fscFinanceWriteOffAdjustDetailMapper.getList(adjustDetailPO);
        for (FscFinanceWriteOffAdjustDetailPO detailPO : list) {
            FscOrderPayItemPO fscOrderPayItemPO = new FscOrderPayItemPO();
            fscOrderPayItemPO.setOrderPayItemId(detailPO.getOrderPayDetailId());
            BigDecimal writeOffAmt = FscConstants.FinanceWriteOffType.ADD.equals(adjustPO.getBillType()) ? detailPO.getWriteOffAmt().negate() : detailPO.getWriteOffAmt();
            fscOrderPayItemPO.setPurWriteOffAmount(writeOffAmt);
            int num = this.fscOrderPayItemMapper.updatePurWriteOffAmountAdd(fscOrderPayItemPO);
            if (num >= 1) continue;
            throw new FscBusinessException("190000", "\u66f4\u65b0\u4ed8\u6b3e\u660e\u7ec6\u5355\u6838\u9500\u91d1\u989d\u5f02\u5e38,writeOffAmt:" + writeOffAmt);
        }
        BigDecimal writeOffAmt = FscConstants.FinanceWriteOffType.ADD.equals(adjustPO.getBillType()) ? adjustPO.getWriteOffAmt().negate() : adjustPO.getWriteOffAmt();
        FscOrderPO fscOrderPo = new FscOrderPO();
        fscOrderPo.setFscOrderId(adjustPO.getFscOrderId());
        fscOrderPo.setPurWriteOffAmount(writeOffAmt);
        int num = this.fscOrderMapper.updatePurWriteOffAmountAdd(fscOrderPo);
        if (num < 1) {
            throw new FscBusinessException("190000", "\u66f4\u65b0\u4e3b\u5355\u6838\u9500\u91d1\u989d\u5f02\u5e38,writeOffAmt:" + writeOffAmt);
        }
    }
}

