/*
 * Decompiled with CFR 0.152.
 */
package com.tydic.fsc.bill.busi.impl;

import com.ohaotian.plugin.base.exception.ZTBusinessException;
import com.tydic.fsc.bill.busi.api.FscMemPayBillDeleteBusiService;
import com.tydic.fsc.bill.busi.bo.FscMemPayBillDeleteBusiReqBo;
import com.tydic.fsc.bill.busi.bo.FscMemPayBillDeleteBusiRspBo;
import com.tydic.fsc.busibase.atom.api.FscOrderStatusFlowAtomService;
import com.tydic.fsc.busibase.atom.bo.FscOrderStatusFlowAtomReqBO;
import com.tydic.fsc.busibase.atom.bo.FscOrderStatusFlowAtomRspBO;
import com.tydic.fsc.constants.FscConstants;
import com.tydic.fsc.dao.FscOrderMapper;
import com.tydic.fsc.dao.FscOrderPayItemMapper;
import com.tydic.fsc.dao.FscShouldPayMapper;
import com.tydic.fsc.exception.FscBusinessException;
import com.tydic.fsc.po.FscOrderPO;
import com.tydic.fsc.po.FscOrderPayItemPO;
import com.tydic.fsc.po.FscShouldPayPO;
import java.util.HashMap;
import java.util.List;
import java.util.stream.Collectors;
import org.springframework.beans.factory.annotation.Autowired;
import org.springframework.stereotype.Service;
import org.springframework.util.CollectionUtils;

@Service
public class FscMemPayBillDeleteBusiServiceImpl
implements FscMemPayBillDeleteBusiService {
    @Autowired
    private FscOrderMapper fscOrderMapper;
    @Autowired
    private FscShouldPayMapper fscShouldPayMapper;
    @Autowired
    private FscOrderPayItemMapper fscOrderPayItemMapper;
    @Autowired
    private FscOrderStatusFlowAtomService fscOrderStatusFlowAtomService;
    public static final Integer ORDER_DELETE_STATE = 1000;
    public static final Integer SHOULD_DELETE_STATE = 8;
    public static final String BUSI_NAME = "\u5220\u9664";
    public static final String BUSI_CODE = "1000";

    @Override
    public FscMemPayBillDeleteBusiRspBo payBillDelete(FscMemPayBillDeleteBusiReqBo reqBo) {
        FscOrderPO wherePo = new FscOrderPO();
        wherePo.setFscOrderId(reqBo.getFscOrderId());
        FscOrderPO setPo = new FscOrderPO();
        setPo.setOrderState(ORDER_DELETE_STATE);
        FscOrderPO modelBy = this.fscOrderMapper.getModelBy(wherePo);
        if (!modelBy.getOrderState().equals(FscConstants.FscInvoiceOrderState.BILL_FAILURE)) {
            throw new ZTBusinessException(modelBy.getFscOrderId().toString() + "\u5220\u9664\u5931\u8d25\uff0c\u652f\u4ed8\u5355\u72b6\u6001\u4e0d\u4e3a\u5931\u6548");
        }
        if (null != reqBo.getFscOrderId()) {
            this.changeWorkFlow(reqBo, modelBy);
            this.deleteShouldPay(reqBo);
        }
        return new FscMemPayBillDeleteBusiRspBo();
    }

    private void changeWorkFlow(FscMemPayBillDeleteBusiReqBo reqBo, FscOrderPO po) {
        HashMap<String, Integer> paramMap = new HashMap<String, Integer>(4);
        paramMap.put("payFlag", FscConstants.MemPayOrderDeleteFlag.DELETE_FLAG);
        FscOrderStatusFlowAtomReqBO flowAtomReqBO = new FscOrderStatusFlowAtomReqBO();
        flowAtomReqBO.setOrderId(reqBo.getFscOrderId());
        flowAtomReqBO.setCurStatus(po.getOrderState());
        flowAtomReqBO.setBusiName(BUSI_NAME);
        flowAtomReqBO.setBusiCode(BUSI_CODE);
        flowAtomReqBO.setParamMap(paramMap);
        FscOrderStatusFlowAtomRspBO flowAtomRspBO = this.fscOrderStatusFlowAtomService.dealStatusFlow(flowAtomReqBO);
        if (!"0000".equals(flowAtomRspBO.getRespCode())) {
            throw new FscBusinessException("193108", flowAtomRspBO.getRespDesc());
        }
    }

    private void deleteShouldPay(FscMemPayBillDeleteBusiReqBo reqBo) {
        FscOrderPayItemPO fscOrderPayItemPo = new FscOrderPayItemPO();
        fscOrderPayItemPo.setFscOrderId(reqBo.getFscOrderId());
        List collect = null;
        if (null != fscOrderPayItemPo.getFscOrderId()) {
            List fscOrderPayItemPos = this.fscOrderPayItemMapper.getList(fscOrderPayItemPo);
            collect = fscOrderPayItemPos.stream().map(FscOrderPayItemPO::getShouldPayId).collect(Collectors.toList());
        }
        FscShouldPayPO whereFscShouldPayPO = new FscShouldPayPO();
        whereFscShouldPayPO.setShouldPayIds(collect);
        FscShouldPayPO setFscShouldPayPO = new FscShouldPayPO();
        setFscShouldPayPO.setShouldPayStatus(SHOULD_DELETE_STATE);
        if (!CollectionUtils.isEmpty(collect)) {
            this.fscShouldPayMapper.updateBy(setFscShouldPayPO, whereFscShouldPayPO);
        }
    }
}

