/*
 * Decompiled with CFR 0.152.
 */
package com.tydic.fsc.bill.ability.impl;

import com.alibaba.fastjson.JSONObject;
import com.tydic.fsc.bill.ability.api.FscBillOrderSpecialRefundCancelAbilityService;
import com.tydic.fsc.bill.ability.bo.FscBillOrderSpecialRefundCancelAbilityReqBO;
import com.tydic.fsc.bill.ability.bo.FscBillOrderSpecialRefundCancelAbilityRspBO;
import com.tydic.fsc.bill.busi.api.FscBillOrderSpecialRefundCancelBusiService;
import com.tydic.fsc.bill.busi.bo.FscBillOrderSpecialRefundCancelBusiReqBO;
import com.tydic.fsc.bill.busi.bo.FscBillOrderSpecialRefundCancelBusiRspBO;
import com.tydic.fsc.common.ability.api.FscComInvoiceSyncAbilityService;
import com.tydic.fsc.common.ability.api.FscComOrderSyncAbilityService;
import com.tydic.fsc.common.ability.api.FscComRefundSyncAbilityService;
import com.tydic.fsc.common.ability.bo.FscComInvoiceListSyncAbilityReqBO;
import com.tydic.fsc.common.ability.bo.FscComOrderListSyncAbilityReqBO;
import com.tydic.fsc.common.ability.bo.FscComRefundSyncAbilityReqBO;
import com.tydic.fsc.constants.FscConstants;
import com.tydic.fsc.dao.FscOrderRefundMapper;
import com.tydic.fsc.exception.FscBusinessException;
import com.tydic.fsc.po.FscOrderRefundPO;
import java.util.Collections;
import org.springframework.beans.factory.annotation.Autowired;
import org.springframework.web.bind.annotation.PostMapping;
import org.springframework.web.bind.annotation.RequestBody;
import org.springframework.web.bind.annotation.RequestMapping;
import org.springframework.web.bind.annotation.RestController;

@RestController
@RequestMapping(value={"FSC_GROUP_DEV/1.0.0/com.tydic.fsc.bill.ability.api.FscBillOrderSpecialRefundCancelAbilityService"})
public class FscBillOrderSpecialRefundCancelAbilityServiceImpl
implements FscBillOrderSpecialRefundCancelAbilityService {
    @Autowired
    private FscOrderRefundMapper fscOrderRefundMapper;
    @Autowired
    private FscComInvoiceSyncAbilityService fscComInvoiceSyncAbilityService;
    @Autowired
    private FscComRefundSyncAbilityService fscComRefundSyncAbilityService;
    @Autowired
    private FscComOrderSyncAbilityService fscComOrderSyncAbilityService;
    @Autowired
    private FscBillOrderSpecialRefundCancelBusiService fscBillOrderSpecialRefundCancelBusiService;

    @PostMapping(value={"dealSpecialRefundCancel"})
    public FscBillOrderSpecialRefundCancelAbilityRspBO dealSpecialRefundCancel(@RequestBody FscBillOrderSpecialRefundCancelAbilityReqBO reqBO) {
        this.valid(reqBO);
        FscOrderRefundPO refundPO = new FscOrderRefundPO();
        refundPO.setRefundId(reqBO.getRefundId());
        refundPO = this.fscOrderRefundMapper.getModelBy(refundPO);
        if (refundPO == null) {
            throw new FscBusinessException("198888", "\u672a\u67e5\u8be2\u5230\u9000\u7968\u5355\u4fe1\u606f\uff01");
        }
        if (reqBO.getDelType() == 2 ? !refundPO.getRefundStatus().equals(FscConstants.RefundInvoiceStatus.SAVE) && !refundPO.getRefundStatus().equals(FscConstants.RefundInvoiceStatus.CANCEL) : !refundPO.getRefundStatus().equals(FscConstants.RefundInvoiceStatus.SAVE) && !refundPO.getRefundStatus().equals(FscConstants.RefundInvoiceStatus.REFUND_BACK)) {
            throw new FscBusinessException("198888", "\u53ea\u6709\u5df2\u53d6\u6d88\u548c\u8349\u7a3f\u72b6\u6001\u7684\u9000\u7968\u5355\u53ef\u4ee5\u5220\u9664\uff01");
        }
        String reqString = JSONObject.toJSONString((Object)reqBO);
        FscBillOrderSpecialRefundCancelBusiReqBO busiReqBO = (FscBillOrderSpecialRefundCancelBusiReqBO)((Object)JSONObject.parseObject((String)reqString, FscBillOrderSpecialRefundCancelBusiReqBO.class));
        FscBillOrderSpecialRefundCancelBusiRspBO busiRspBO = this.fscBillOrderSpecialRefundCancelBusiService.dealSpecialRefundCancel(busiReqBO);
        if (!busiRspBO.getRespCode().equals("0000")) {
            throw new FscBusinessException(busiRspBO.getRespCode(), busiRspBO.getRespDesc());
        }
        this.syncEs(refundPO);
        FscBillOrderSpecialRefundCancelAbilityRspBO rspBO = new FscBillOrderSpecialRefundCancelAbilityRspBO();
        rspBO.setRespCode("0000");
        rspBO.setRespDesc("\u6210\u529f");
        return rspBO;
    }

    private void syncEs(FscOrderRefundPO refundPO) {
        FscComRefundSyncAbilityReqBO refundSyncAbilityReqBO = new FscComRefundSyncAbilityReqBO();
        refundSyncAbilityReqBO.setRefundIds(Collections.singletonList(refundPO.getRefundId()));
        this.fscComRefundSyncAbilityService.syncRefund(refundSyncAbilityReqBO);
        FscComInvoiceListSyncAbilityReqBO fscComInvoiceListSyncAbilityReqBO = new FscComInvoiceListSyncAbilityReqBO();
        fscComInvoiceListSyncAbilityReqBO.setFscOrderId(refundPO.getFscOrderId());
        this.fscComInvoiceSyncAbilityService.dealComOrderSyncEs(fscComInvoiceListSyncAbilityReqBO);
        FscComOrderListSyncAbilityReqBO fscComOrderListSyncAbilityReqBO = new FscComOrderListSyncAbilityReqBO();
        fscComOrderListSyncAbilityReqBO.setFscOrderId(refundPO.getFscOrderId());
        this.fscComOrderSyncAbilityService.dealComOrderSyncEs(fscComOrderListSyncAbilityReqBO);
    }

    private void valid(FscBillOrderSpecialRefundCancelAbilityReqBO reqBO) {
        if (reqBO.getRefundId() == null) {
            throw new FscBusinessException("198888", "\u5165\u53c2[refundId]\u4e0d\u80fd\u4e3a\u7a7a\uff01");
        }
        if (reqBO.getDelType() == null) {
            throw new FscBusinessException("198888", "\u5165\u53c2[delType]\u4e0d\u80fd\u4e3a\u7a7a\uff01");
        }
    }
}

