/*
 * Decompiled with CFR 0.152.
 */
package com.tydic.fsc.bill.ability.impl;

import com.alibaba.fastjson.JSON;
import com.alibaba.fastjson.JSONObject;
import com.tydic.fsc.bill.ability.api.FscBillPayRefundDetailAbilityService;
import com.tydic.fsc.bill.ability.bo.FscBillPayOrderBO;
import com.tydic.fsc.bill.ability.bo.FscBillPayRefundDetailAbilityReqBO;
import com.tydic.fsc.bill.ability.bo.FscBillPayRefundDetailAbilityRspBO;
import com.tydic.fsc.bill.ability.bo.FscOrderRefundBO;
import com.tydic.fsc.bo.AttachmentBO;
import com.tydic.fsc.bo.FscContractPlanItemBO;
import com.tydic.fsc.bo.FscPayClaimRefundBO;
import com.tydic.fsc.bo.FscPayRefundDetailBO;
import com.tydic.fsc.busibase.busi.api.FscDictionaryBusiService;
import com.tydic.fsc.common.ability.api.FscComRefundDetailAbilityService;
import com.tydic.fsc.common.ability.bo.FscComRefundDetailAbilityReqBO;
import com.tydic.fsc.common.ability.bo.FscComRefundDetailAbilityRspBO;
import com.tydic.fsc.constants.FscConstants;
import com.tydic.fsc.dao.FscAttachmentMapper;
import com.tydic.fsc.dao.FscFinancePayItemMapper;
import com.tydic.fsc.dao.FscOrderFinanceMapper;
import com.tydic.fsc.dao.FscOrderMapper;
import com.tydic.fsc.dao.FscOrderPayItemMapper;
import com.tydic.fsc.dao.FscOrderRefundMapper;
import com.tydic.fsc.dao.FscPayClaimRefundDetailMapper;
import com.tydic.fsc.dao.FscPayClaimRefundMapper;
import com.tydic.fsc.dao.FscPayRefundDetailMapper;
import com.tydic.fsc.dao.FscPayShouldRefundMapper;
import com.tydic.fsc.dao.FscPlanPayItemMapper;
import com.tydic.fsc.dao.FscRefundFinanceMapper;
import com.tydic.fsc.enums.FscClaimTypeEnum;
import com.tydic.fsc.enums.FscPayTypeEnum;
import com.tydic.fsc.enums.FscPostingStatusEnum;
import com.tydic.fsc.exception.FscBusinessException;
import com.tydic.fsc.po.FscAttachmentPO;
import com.tydic.fsc.po.FscOrderFinancePO;
import com.tydic.fsc.po.FscOrderPO;
import com.tydic.fsc.po.FscOrderPayItemPO;
import com.tydic.fsc.po.FscOrderRefundPO;
import com.tydic.fsc.po.FscPayClaimRefundDetailPO;
import com.tydic.fsc.po.FscPayClaimRefundPO;
import com.tydic.fsc.po.FscPayRefundDetailPO;
import com.tydic.fsc.po.FscPayShouldRefundPO;
import com.tydic.fsc.po.FscPlanPayItemPo;
import com.tydic.fsc.po.FscRefundFinancePO;
import java.util.ArrayList;
import java.util.Collection;
import java.util.Collections;
import java.util.List;
import java.util.Map;
import java.util.Objects;
import java.util.stream.Collectors;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;
import org.springframework.beans.BeanUtils;
import org.springframework.beans.factory.annotation.Autowired;
import org.springframework.util.CollectionUtils;
import org.springframework.util.StringUtils;
import org.springframework.web.bind.annotation.PostMapping;
import org.springframework.web.bind.annotation.RequestBody;
import org.springframework.web.bind.annotation.RequestMapping;
import org.springframework.web.bind.annotation.RestController;

@RestController
@RequestMapping(value={"FSC_GROUP_DEV/1.0.0/com.tydic.fsc.bill.ability.api.FscBillPayRefundDetailAbilityService"})
public class FscBillPayRefundDetailAbilityServiceImpl
implements FscBillPayRefundDetailAbilityService {
    private static final Logger log = LoggerFactory.getLogger(FscBillPayRefundDetailAbilityServiceImpl.class);
    @Autowired
    private FscOrderRefundMapper fscOrderRefundMapper;
    @Autowired
    private FscPayRefundDetailMapper fscPayRefundDetailMapper;
    @Autowired
    private FscPayClaimRefundMapper fscPayClaimRefundMapper;
    @Autowired
    private FscPayClaimRefundDetailMapper fscPayClaimRefundDetailMapper;
    @Autowired
    private FscPayShouldRefundMapper fscPayShouldRefundMapper;
    @Autowired
    private FscOrderMapper fscOrderMapper;
    @Autowired
    private FscOrderPayItemMapper fscOrderPayItemMapper;
    @Autowired
    private FscComRefundDetailAbilityService fscComRefundDetailAbilityService;
    @Autowired
    private FscAttachmentMapper fscAttachmentMapper;
    @Autowired
    private FscDictionaryBusiService fscDictionaryBusiService;
    @Autowired
    private FscPlanPayItemMapper fscPlanPayItemMapper;
    @Autowired
    private FscRefundFinanceMapper fscRefundFinanceMapper;
    @Autowired
    private FscOrderFinanceMapper fscOrderFinanceMapper;
    @Autowired
    private FscFinancePayItemMapper fscFinancePayItemMapper;

    @PostMapping(value={"dealPayRefundDetail"})
    public FscBillPayRefundDetailAbilityRspBO dealPayRefundDetail(@RequestBody FscBillPayRefundDetailAbilityReqBO reqBO) {
        FscBillPayRefundDetailAbilityRspBO rspBO = new FscBillPayRefundDetailAbilityRspBO();
        if (reqBO.getRefundId() == null) {
            throw new FscBusinessException("190000", "\u5165\u53c2[refundId]\u4e0d\u80fd\u4e3a\u7a7a");
        }
        FscOrderRefundPO fscOrderRefundPO = this.fscOrderRefundMapper.queryById(reqBO.getRefundId());
        if (fscOrderRefundPO == null) {
            throw new FscBusinessException("190000", "\u672a\u67e5\u8be2\u5230\u9000\u6b3e\u5355");
        }
        List fscPayRefundDetailList = this.fscPayRefundDetailMapper.queryByRefundId(reqBO.getRefundId());
        Long refundShouldPayId = ((FscPayRefundDetailPO)fscPayRefundDetailList.get(0)).getRefundShouldPayId();
        FscPayShouldRefundPO fscPayShouldRefundPO = this.fscPayShouldRefundMapper.queryById(refundShouldPayId);
        for (FscPayRefundDetailPO fscPayRefundDetailPO : fscPayRefundDetailList) {
            fscPayRefundDetailPO.setTotalRefundAmt(fscPayShouldRefundPO.getRefundAmount());
            if (fscPayRefundDetailPO.getClaimType() != null) {
                fscPayRefundDetailPO.setClaimTypeStr(FscClaimTypeEnum.getInstanceValue((String)fscPayRefundDetailPO.getClaimType()));
            }
            FscPlanPayItemPo fscPlanPayItemPo = new FscPlanPayItemPo();
            fscPlanPayItemPo.setShouldPayId(fscPayRefundDetailPO.getRefundShouldPayId());
            fscPlanPayItemPo.setFscOrderId(reqBO.getRefundId());
            List planPayItemList = new ArrayList();
            planPayItemList = this.fscPlanPayItemMapper.getOperatePlanPayList(fscPlanPayItemPo);
            if (CollectionUtils.isEmpty(planPayItemList)) continue;
            fscPayRefundDetailPO.setPlanItemBOs(JSON.parseArray((String)JSONObject.toJSONString(planPayItemList), FscContractPlanItemBO.class));
        }
        rspBO.setFscRefundShouldPayBOS(JSON.parseArray((String)JSONObject.toJSONString((Object)fscPayRefundDetailList), FscPayRefundDetailBO.class));
        fscOrderRefundPO.setClaimAmt(((FscPayRefundDetailPO)fscPayRefundDetailList.get(0)).getClaimAmt());
        if (fscPayShouldRefundPO.getPayOrderId() != null) {
            rspBO.setPayOrderInfo(this.queryPayOrderInfo(Collections.singletonList(fscPayShouldRefundPO.getPayOrderId())));
        }
        if (fscPayShouldRefundPO.getRefundId() != null) {
            FscComRefundDetailAbilityReqBO fscComRefundDetailAbilityReqBO = new FscComRefundDetailAbilityReqBO();
            fscComRefundDetailAbilityReqBO.setRefundId(fscPayShouldRefundPO.getRefundId());
            FscComRefundDetailAbilityRspBO fscComRefundDetailAbilityRspBO = this.fscComRefundDetailAbilityService.qryRefundDetail(fscComRefundDetailAbilityReqBO);
            if ("0000".equals(fscComRefundDetailAbilityRspBO.getRespCode())) {
                rspBO.setRefundOrderInfo(fscComRefundDetailAbilityRspBO);
            }
        }
        List fscPayClaimRefundList = this.fscPayClaimRefundMapper.queryByRefundId(reqBO.getRefundId());
        rspBO.setFscClaimDetailBOS(JSON.parseArray((String)JSONObject.toJSONString((Object)fscPayClaimRefundList), FscPayClaimRefundBO.class));
        if (!CollectionUtils.isEmpty((Collection)fscPayClaimRefundList) && fscOrderRefundPO.getUserType() == 1) {
            StringBuilder claimNo = new StringBuilder();
            for (FscPayClaimRefundPO fscPayClaimRefundPO : fscPayClaimRefundList) {
                String[] claimNos;
                if (StringUtils.isEmpty((Object)fscPayClaimRefundPO.getClaimNo())) continue;
                for (String s : claimNos = fscPayClaimRefundPO.getClaimNo().split(",")) {
                    if (claimNo.toString().contains(s)) continue;
                    claimNo.append(s).append(",");
                }
            }
            if (!StringUtils.isEmpty((Object)claimNo.toString()) && claimNo.toString().endsWith(",")) {
                fscOrderRefundPO.setClaimNo(claimNo.substring(0, claimNo.length() - 1));
            }
            FscPayClaimRefundDetailPO fscPayClaimRefundDetailPO = new FscPayClaimRefundDetailPO();
            fscPayClaimRefundDetailPO.setRefundId(reqBO.getRefundId());
            List claimRefundDetailPOList = this.fscPayClaimRefundDetailMapper.getClaimInfoByRefundId(fscPayClaimRefundDetailPO);
            List<Long> payOrderIdList = claimRefundDetailPOList.stream().filter(e -> e.getPayOrderId() != null).map(FscPayClaimRefundDetailPO::getPayOrderId).distinct().collect(Collectors.toList());
            if (!CollectionUtils.isEmpty(payOrderIdList)) {
                rspBO.setPayOrderInfo(this.queryPayOrderInfo(payOrderIdList));
            }
        }
        FscAttachmentPO attachmentPO = new FscAttachmentPO();
        attachmentPO.setObjId(fscOrderRefundPO.getRefundId());
        attachmentPO.setObjType(FscConstants.AttachmentObjType.REFUND_PAY);
        List list = this.fscAttachmentMapper.getList(attachmentPO);
        List fileList = new ArrayList(list.size());
        if (!CollectionUtils.isEmpty((Collection)list)) {
            fileList = JSON.parseArray((String)JSONObject.toJSONString((Object)list), AttachmentBO.class);
        }
        rspBO.setAttachmentList(fileList);
        fileList = new ArrayList();
        attachmentPO.setObjType(FscConstants.AttachmentObjType.REFUND_PAY_CREDENTIALS);
        list = this.fscAttachmentMapper.getList(attachmentPO);
        if (!CollectionUtils.isEmpty((Collection)list)) {
            fileList = JSON.parseArray((String)JSONObject.toJSONString((Object)list), AttachmentBO.class);
        }
        rspBO.setVoucherList(fileList);
        Map refundTypeMap = this.fscDictionaryBusiService.queryBypCodeBackMap("FSC_REFUND_TYPE");
        Map orderTypeMap = this.fscDictionaryBusiService.queryBypCodeBackMap("FSC_ORDER_TYPE");
        fscOrderRefundPO.setRefundReasonTypeStr((String)refundTypeMap.get(fscOrderRefundPO.getRefundReasonType() + ""));
        fscOrderRefundPO.setOrderTypeStr((String)orderTypeMap.get(fscOrderRefundPO.getOrderType() + ""));
        FscOrderRefundBO fscOrderRefundBO = (FscOrderRefundBO)JSON.parseObject((String)JSON.toJSONString((Object)fscOrderRefundPO), FscOrderRefundBO.class);
        if (!StringUtils.isEmpty((Object)fscPayShouldRefundPO.getContractType())) {
            Map engContractTypeMap = this.fscDictionaryBusiService.queryBypCodeBackMap("FINANCE_ENGINEERING_CONTRACT_TYPE");
            fscOrderRefundBO.setContractType(fscPayShouldRefundPO.getContractType());
            fscOrderRefundBO.setContractTypeStr((String)engContractTypeMap.get(fscPayShouldRefundPO.getContractType()));
        }
        if (!StringUtils.isEmpty((Object)fscPayShouldRefundPO.getBusinessType())) {
            Map businessTypeMap = this.fscDictionaryBusiService.queryBypCodeBackMap("FINANCE_ENGINEERING_BUSINESS_TYPE");
            fscOrderRefundBO.setBusinessType(fscPayShouldRefundPO.getBusinessType());
            fscOrderRefundBO.setBusinessTypeStr((String)businessTypeMap.get(fscPayShouldRefundPO.getBusinessType().toString()));
        }
        FscRefundFinancePO fscRefundFinanceReq = new FscRefundFinancePO();
        fscRefundFinanceReq.setRefundId(reqBO.getRefundId());
        FscRefundFinancePO fscRefundFinancePO = this.fscRefundFinanceMapper.getModelBy(fscRefundFinanceReq);
        if (fscRefundFinancePO != null) {
            BeanUtils.copyProperties((Object)fscRefundFinancePO, (Object)fscOrderRefundBO);
            Map isAgentMap = this.fscDictionaryBusiService.queryBypCodeBackMap("FSC_IS_AGENT");
            Map refundPayMethodMap = this.fscDictionaryBusiService.queryBypCodeBackMap("FSC_REFUND_PAY_METHOD");
            if (!StringUtils.isEmpty((Object)fscOrderRefundBO.getPostingStatus())) {
                fscOrderRefundBO.setPostingStatusStr(FscPostingStatusEnum.getCodeDesc((String)String.valueOf(fscOrderRefundBO.getPostingStatus())));
            }
            if (fscOrderRefundBO.getIsAgent() != null) {
                fscOrderRefundBO.setIsAgentStr((String)isAgentMap.get(fscOrderRefundBO.getIsAgent().toString()));
            }
            if (!StringUtils.isEmpty((Object)fscOrderRefundBO.getRefundPayMethod())) {
                fscOrderRefundBO.setRefundPayMethodStr((String)refundPayMethodMap.get(fscOrderRefundBO.getRefundPayMethod()));
            }
        }
        if (fscPayShouldRefundPO.getRefundId() != null && fscOrderRefundPO.getFscOrderId() != null) {
            FscOrderFinancePO fscOrderFinanceReq = new FscOrderFinancePO();
            fscOrderFinanceReq.setFscOrderId(fscOrderRefundPO.getFscOrderId());
            FscOrderFinancePO fscOrderFinance = this.fscOrderFinanceMapper.getModelBy(fscOrderFinanceReq);
            if (fscOrderFinance != null) {
                fscOrderRefundBO.setPayDate(fscOrderFinance.getPayDate());
                fscOrderRefundBO.setBusinessItemCode(fscOrderFinance.getBusinessItemCode());
                fscOrderRefundBO.setBusinessItemName(fscOrderFinance.getBusinessItemName());
            }
        }
        rspBO.setRefundInfo(fscOrderRefundBO);
        rspBO.setRespCode("0000");
        rspBO.setRespDesc("\u6210\u529f");
        return rspBO;
    }

    private List<FscBillPayOrderBO> queryPayOrderInfo(List<Long> payOrderIdList) {
        ArrayList<FscBillPayOrderBO> payOrderList = new ArrayList<FscBillPayOrderBO>();
        for (Long payOrderId : payOrderIdList) {
            FscOrderPO fscOrderPO = this.fscOrderMapper.qryByFscOrderId(payOrderId);
            FscBillPayOrderBO fscBillPayOrderBO = (FscBillPayOrderBO)JSON.parseObject((String)JSONObject.toJSONString((Object)fscOrderPO), FscBillPayOrderBO.class);
            fscBillPayOrderBO.setPayAmount(fscOrderPO.getPaidAmount());
            Map orderTypeMap = this.fscDictionaryBusiService.queryBypCodeBackMap("FSC_ORDER_TYPE");
            fscBillPayOrderBO.setOrderTypeStr((String)orderTypeMap.get(fscBillPayOrderBO.getOrderType().toString()));
            FscOrderPayItemPO fscOrderPayItemPO = new FscOrderPayItemPO();
            fscOrderPayItemPO.setFscOrderId(fscBillPayOrderBO.getFscOrderId());
            List payItems = this.fscOrderPayItemMapper.getList(fscOrderPayItemPO);
            if (!CollectionUtils.isEmpty((Collection)payItems)) {
                Integer shouldPayMethod = ((FscOrderPayItemPO)payItems.get(0)).getShouldPayMethod();
                fscBillPayOrderBO.setShouldPayMethodStr(Objects.nonNull(FscPayTypeEnum.getEnum((Integer)shouldPayMethod)) ? FscPayTypeEnum.getEnum((Integer)shouldPayMethod).getDesc() : null);
            }
            Map orderStateMap = this.fscDictionaryBusiService.queryBypCodeBackMap("FSC_ORDER_SERVICE_LIST_STATE");
            fscBillPayOrderBO.setOrderStateStr((String)orderStateMap.get(fscBillPayOrderBO.getOrderState() + ""));
            payOrderList.add(fscBillPayOrderBO);
        }
        return payOrderList;
    }
}

