/*
 * Decompiled with CFR 0.152.
 */
package com.tydic.fsc.bill.ability.impl;

import com.alibaba.fastjson.JSONObject;
import com.tydic.fsc.bill.ability.api.FscBillReopenInvoiceAbilityService;
import com.tydic.fsc.bill.ability.bo.FscBillReopenInvoiceAbilityReqBO;
import com.tydic.fsc.bill.ability.bo.FscBillReopenInvoiceAbilityRspBO;
import com.tydic.fsc.bill.busi.api.FscBillReopenInvoiceBusiService;
import com.tydic.fsc.bill.busi.bo.FscBillReopenInvoiceBusiReqBO;
import com.tydic.fsc.bill.busi.bo.FscBillReopenInvoiceBusiRspBO;
import com.tydic.fsc.busibase.atom.api.FscUocOrderRelUpdateAtomService;
import com.tydic.fsc.busibase.atom.bo.FscUocOrderRelUpdateAtomReqBO;
import com.tydic.fsc.common.ability.api.FscComOrderSyncAbilityService;
import com.tydic.fsc.common.ability.api.FscComRefundSyncAbilityService;
import com.tydic.fsc.common.ability.api.FscSyncPushYcSaleAbilityService;
import com.tydic.fsc.common.ability.bo.FscComOrderListSyncAbilityReqBO;
import com.tydic.fsc.common.ability.bo.FscComRefundSyncAbilityReqBO;
import com.tydic.fsc.common.ability.bo.FscSyncPushYcSaleAbilityReqBO;
import com.tydic.fsc.constants.FscBillInvoiceSerial;
import com.tydic.fsc.constants.FscConstants;
import com.tydic.fsc.dao.FscOrderRefundMapper;
import com.tydic.fsc.exception.FscBusinessException;
import com.tydic.fsc.po.FscOrderRefundPO;
import com.tydic.fsc.util.FscDuplicateCommitLimit;
import com.tydic.plugin.encoded.service.CfcEncodedSerialGetService;
import com.tydic.plugin.encoded.service.bo.CfcEncodedSerialGetServiceReqBO;
import com.tydic.plugin.encoded.service.bo.CfcEncodedSerialGetServiceRspBO;
import java.util.Collection;
import java.util.Collections;
import java.util.HashMap;
import java.util.Map;
import org.apache.commons.lang3.StringUtils;
import org.springframework.beans.factory.annotation.Autowired;
import org.springframework.beans.factory.annotation.Value;
import org.springframework.util.CollectionUtils;
import org.springframework.web.bind.annotation.PostMapping;
import org.springframework.web.bind.annotation.RequestBody;
import org.springframework.web.bind.annotation.RequestMapping;
import org.springframework.web.bind.annotation.RestController;

@RestController
@RequestMapping(value={"FSC_GROUP_DEV/1.0.0/com.tydic.fsc.bill.ability.api.FscBillReopenInvoiceAbilityService"})
public class FscBillReopenInvoiceAbilityServiceImpl
implements FscBillReopenInvoiceAbilityService {
    @Autowired
    private FscComRefundSyncAbilityService fscComRefundSyncAbilityService;
    @Autowired
    private FscUocOrderRelUpdateAtomService fscUocOrderRelUpdateAtomService;
    @Autowired
    private FscSyncPushYcSaleAbilityService fscSyncPushYcSaleAbilityService;
    @Autowired
    private FscBillReopenInvoiceBusiService fscBillReopenInvoiceBusiService;
    @Autowired
    private FscComOrderSyncAbilityService fscComOrderSyncAbilityService;
    @Autowired
    private CfcEncodedSerialGetService cfcEncodedSerialGetService;
    @Autowired
    private FscOrderRefundMapper fscOrderRefundMapper;
    @Value(value="${OPERATION_SUP_ID:1001693}")
    private Long operationSupId;

    @FscDuplicateCommitLimit
    @PostMapping(value={"dealInvoiceReopen"})
    public FscBillReopenInvoiceAbilityRspBO dealInvoiceReopen(@RequestBody FscBillReopenInvoiceAbilityReqBO reqBO) {
        this.valid(reqBO);
        FscOrderRefundPO refundPO = new FscOrderRefundPO();
        refundPO.setRefundId(reqBO.getRefundId());
        refundPO = this.fscOrderRefundMapper.getModelBy(refundPO);
        if (refundPO == null) {
            throw new FscBusinessException("198888", "\u67e5\u8be2\u9000\u7968\u4fe1\u606f\u4e3a\u7a7a\uff01");
        }
        String keySb = String.valueOf(reqBO.getReceiveType()) + refundPO.getTradeMode() + reqBO.getOrderSource();
        String orderNo = this.getSerial(keySb);
        HashMap<String, Object> paramMap = new HashMap<String, Object>(8);
        if (FscConstants.FscOrderMakeType.OPERTION.equals(refundPO.getMakeType())) {
            if (reqBO.getIsprofess().equals("0")) {
                paramMap.put("supplierFlag", FscConstants.BillOrderSupplieFlag.OPERATION_APPROVAL);
            } else {
                paramMap.put("supplierFlag", FscConstants.BillOrderSupplieFlag.PURCHASE_NOT_CHECK);
            }
        } else if (refundPO.getMakeType().equals(FscConstants.FscOrderMakeType.SUPPLIER)) {
            this.dealSupplierStart(reqBO, paramMap, refundPO);
        } else if (refundPO.getMakeType().equals(FscConstants.FscOrderMakeType.ELECTRONIC_COMMERCE)) {
            paramMap.put("supplierFlag", FscConstants.BillOrderSupplieFlag.ELECTRONIC);
        }
        this.checkReopen(reqBO.getRefundId(), refundPO.getMakeType(), refundPO.getReceiveType());
        FscBillReopenInvoiceBusiReqBO busiReqBO = (FscBillReopenInvoiceBusiReqBO)((Object)JSONObject.parseObject((String)JSONObject.toJSONString((Object)reqBO), FscBillReopenInvoiceBusiReqBO.class));
        busiReqBO.setParamMap(paramMap);
        busiReqBO.setFscOrderNo(orderNo);
        busiReqBO.setFscOrderId(refundPO.getFscOrderId());
        busiReqBO.setToPayAmount(refundPO.getToPayAmount());
        busiReqBO.setShouldPayAmount(refundPO.getShouldPayAmount());
        busiReqBO.setSettlePlatform(refundPO.getSettlePlatform());
        FscBillReopenInvoiceBusiRspBO busiRspBO = this.fscBillReopenInvoiceBusiService.dealInvoiceReopen(busiReqBO);
        if (!busiRspBO.getRespCode().equals("0000")) {
            throw new FscBusinessException(busiRspBO.getRespCode(), busiRspBO.getRespDesc());
        }
        if (busiRspBO.getApprovalFlag().booleanValue()) {
            FscSyncPushYcSaleAbilityReqBO saleAbilityReqBO = new FscSyncPushYcSaleAbilityReqBO();
            saleAbilityReqBO.setFscOrderId(busiReqBO.getFscOrderId());
            this.fscSyncPushYcSaleAbilityService.syncPushYcSale(saleAbilityReqBO);
        }
        this.sendMq((Long)busiRspBO.getFscOrderIds().get(0), reqBO.getRefundId());
        FscBillReopenInvoiceAbilityRspBO rspBO = new FscBillReopenInvoiceAbilityRspBO();
        rspBO.setRespCode("0000");
        rspBO.setRespDesc("\u6210\u529f");
        return rspBO;
    }

    private void checkReopen(Long refundId, Integer makeType, Integer receiveType) {
        int count = this.fscOrderRefundMapper.checkInvoiceReopen(refundId, makeType, receiveType);
        if (count != 0) {
            throw new FscBusinessException("198888", "\u5df2\u5b58\u5728\u91cd\u5f00\u7ed3\u7b97\u5355,\u8bf7\u52ff\u91cd\u590d\u53d1\u8d77\uff01");
        }
    }

    private void dealSupplierStart(FscBillReopenInvoiceAbilityReqBO reqBO, Map<String, Object> paramMap, FscOrderRefundPO refundPO) {
        if (FscConstants.FscOrderReceiveType.PURCHASE.equals(refundPO.getReceiveType()) && this.operationSupId.equals(reqBO.getSupplierId())) {
            if (reqBO.getWebSource() != null) {
                paramMap.put("supplierFlag", FscConstants.BillOrderSupplieFlag.OPERATION_APPROVAL);
            } else {
                paramMap.put("supplierFlag", FscConstants.BillOrderSupplieFlag.PURCHASE_NOT_CHECK);
            }
        } else {
            paramMap.put("supplierFlag", FscConstants.BillOrderSupplieFlag.OPERATION_NOT_CHECK);
        }
    }

    private void sendMq(Long fscOrderId, Long refundId) {
        FscComOrderListSyncAbilityReqBO fscComOrderListSyncAbilityReqBO = new FscComOrderListSyncAbilityReqBO();
        fscComOrderListSyncAbilityReqBO.setFscOrderId(fscOrderId);
        this.fscComOrderSyncAbilityService.dealComOrderSyncEs(fscComOrderListSyncAbilityReqBO);
        FscUocOrderRelUpdateAtomReqBO fscUocOrderRelUpdateAtomReqBO = new FscUocOrderRelUpdateAtomReqBO();
        fscUocOrderRelUpdateAtomReqBO.setFscOrderId(fscOrderId);
        fscUocOrderRelUpdateAtomReqBO.setOperType(FscConstants.FscRelUpdateAtomOperType.FSC_ORDER);
        this.fscUocOrderRelUpdateAtomService.dealRelUpdate(fscUocOrderRelUpdateAtomReqBO);
        FscComRefundSyncAbilityReqBO refundSyncAbilityReqBO = new FscComRefundSyncAbilityReqBO();
        refundSyncAbilityReqBO.setRefundIds(Collections.singletonList(refundId));
        this.fscComRefundSyncAbilityService.syncRefund(refundSyncAbilityReqBO);
    }

    private String getSerial(String key) {
        CfcEncodedSerialGetServiceReqBO encodedSerialGetServiceReqBO = new CfcEncodedSerialGetServiceReqBO();
        encodedSerialGetServiceReqBO.setCenter("FSC");
        encodedSerialGetServiceReqBO.setOrgType("-1");
        encodedSerialGetServiceReqBO.setEncodedRuleCode(FscBillInvoiceSerial.getInstance((String)key).getDesc());
        encodedSerialGetServiceReqBO.setNum(Integer.valueOf(1));
        CfcEncodedSerialGetServiceRspBO encodedSerialGetServiceRspBO = this.cfcEncodedSerialGetService.getEncodedSerial(encodedSerialGetServiceReqBO);
        if (null == encodedSerialGetServiceRspBO || CollectionUtils.isEmpty((Collection)encodedSerialGetServiceRspBO.getSerialNoList()) || StringUtils.isBlank((CharSequence)((CharSequence)encodedSerialGetServiceRspBO.getSerialNoList().get(0)))) {
            throw new FscBusinessException("191014", "\u83b7\u53d6\u914d\u7f6e\u6d41\u6c34\u53f7\u5f02\u5e38");
        }
        return (String)encodedSerialGetServiceRspBO.getSerialNoList().get(0);
    }

    private void valid(FscBillReopenInvoiceAbilityReqBO reqBO) {
        if (reqBO.getRefundId() == null) {
            throw new FscBusinessException("198888", "refundId\u4e0d\u80fd\u4e3a\u7a7a");
        }
        if (reqBO.getOpenInvoiceType() == null || !reqBO.getOpenInvoiceType().equals(FscConstants.OpenInvoiceType.INDIVIDUALLY_DOWN)) {
            if (StringUtils.isEmpty((CharSequence)reqBO.getTaxNo())) {
                throw new FscBusinessException("191000", "\u5165\u53c2[taxNo]\u4e3a\u7a7a");
            }
            if (StringUtils.isEmpty((CharSequence)reqBO.getAddress())) {
                throw new FscBusinessException("191000", "\u5165\u53c2[address]\u4e3a\u7a7a");
            }
            if (StringUtils.isEmpty((CharSequence)reqBO.getBank())) {
                throw new FscBusinessException("191000", "\u5165\u53c2[bank]\u4e3a\u7a7a");
            }
            if (StringUtils.isEmpty((CharSequence)reqBO.getAccount())) {
                throw new FscBusinessException("191000", "\u5165\u53c2[account]\u4e3a\u7a7a");
            }
        }
        if (StringUtils.isEmpty((CharSequence)reqBO.getPhone())) {
            throw new FscBusinessException("191000", "\u5165\u53c2[phone]\u4e3a\u7a7a");
        }
        if (!(FscConstants.InvoiceCategory.ELECTRON.equals(reqBO.getInvoiceCategory()) || FscConstants.InvoiceCategory.PAPER.equals(reqBO.getInvoiceCategory()) || FscConstants.InvoiceCategory.FULL_ELECTRON.equals(reqBO.getInvoiceCategory()))) {
            throw new FscBusinessException("191000", "\u5165\u53c2[invoiceCategory]\u53d1\u7968\u7c7b\u522b\u53ea\u80fd\u4e3a1\u62162\u62163");
        }
        if (FscConstants.InvoiceCategory.ELECTRON.equals(reqBO.getInvoiceCategory()) && StringUtils.isBlank((CharSequence)reqBO.getReceiveEmail()) && (reqBO.getOpenInvoiceType() == null || reqBO.getOpenInvoiceType() != 1)) {
            throw new FscBusinessException("191000", "\u63d0\u4ea4\u7535\u7968\u65f6\uff0c\u6536\u7968\u90ae\u7bb1\u4e0d\u80fd\u4e3a\u7a7a");
        }
        if (FscConstants.InvoiceCategory.PAPER.equals(reqBO.getInvoiceCategory())) {
            if (StringUtils.isBlank((CharSequence)reqBO.getProvince())) {
                throw new FscBusinessException("191000", "\u63d0\u4ea4\u7eb8\u7968\u65f6\uff0c\u5165\u53c2[province]\u4e0d\u80fd\u4e3a\u7a7a");
            }
            if (StringUtils.isBlank((CharSequence)reqBO.getProvinceCode())) {
                throw new FscBusinessException("191000", "\u63d0\u4ea4\u7eb8\u7968\u65f6\uff0c\u5165\u53c2[provinceCode]\u4e0d\u80fd\u4e3a\u7a7a");
            }
            if (StringUtils.isBlank((CharSequence)reqBO.getCity())) {
                throw new FscBusinessException("191000", "\u63d0\u4ea4\u7eb8\u7968\u65f6\uff0c\u5165\u53c2[city]\u4e0d\u80fd\u4e3a\u7a7a");
            }
            if (StringUtils.isBlank((CharSequence)reqBO.getCityCode())) {
                throw new FscBusinessException("191000", "\u63d0\u4ea4\u7eb8\u7968\u65f6\uff0c\u5165\u53c2[cityCode]\u4e0d\u80fd\u4e3a\u7a7a");
            }
            if (StringUtils.isBlank((CharSequence)reqBO.getArea())) {
                throw new FscBusinessException("191000", "\u63d0\u4ea4\u7eb8\u7968\u65f6\uff0c\u5165\u53c2[area]\u4e0d\u80fd\u4e3a\u7a7a");
            }
            if (StringUtils.isBlank((CharSequence)reqBO.getAreaCode())) {
                throw new FscBusinessException("191000", "\u63d0\u4ea4\u7eb8\u7968\u65f6\uff0c\u5165\u53c2[areaCode]\u4e0d\u80fd\u4e3a\u7a7a");
            }
            if (StringUtils.isBlank((CharSequence)reqBO.getReceiveAddr())) {
                throw new FscBusinessException("191000", "\u63d0\u4ea4\u7eb8\u7968\u65f6\uff0c\u5165\u53c2[receiveAddr]\u4e0d\u80fd\u4e3a\u7a7a");
            }
            if (StringUtils.isBlank((CharSequence)reqBO.getReceiveName())) {
                throw new FscBusinessException("191000", "\u63d0\u4ea4\u7eb8\u7968\u65f6\uff0c\u5165\u53c2[receiveName]\u4e0d\u80fd\u4e3a\u7a7a");
            }
            if (StringUtils.isBlank((CharSequence)reqBO.getReceivePhone())) {
                throw new FscBusinessException("191000", "\u63d0\u4ea4\u7eb8\u7968\u65f6\uff0c\u5165\u53c2[receivePhone]\u4e0d\u80fd\u4e3a\u7a7a");
            }
        }
        if (null == reqBO.getInvoiceType()) {
            throw new FscBusinessException("191000", "\u5165\u53c2[invoiceType]\u4e3a\u7a7a");
        }
        if (reqBO.getWebSource() != null && FscConstants.FscWebSource.AGR_DOWN.equals(reqBO.getWebSource())) {
            if (StringUtils.isEmpty((CharSequence)reqBO.getDeptName())) {
                throw new FscBusinessException("191000", "\u5165\u53c2[deptName]\u4e3a\u7a7a");
            }
            if (reqBO.getDeptId() == null) {
                throw new FscBusinessException("191000", "\u5165\u53c2[deptId]\u4e3a\u7a7a");
            }
            if (reqBO.getPersonId() == null) {
                throw new FscBusinessException("191000", "\u5165\u53c2[personId]\u4e3a\u7a7a");
            }
            if (StringUtils.isEmpty((CharSequence)reqBO.getPersonName())) {
                throw new FscBusinessException("191000", "\u5165\u53c2[personName]\u4e3a\u7a7a");
            }
            if (reqBO.getYcUserId() == null) {
                throw new FscBusinessException("191000", "\u5165\u53c2[ycUserId]\u4e3a\u7a7a");
            }
        }
    }
}

