/*
 * Decompiled with CFR 0.152.
 */
package com.tydic.fsc.bill.ability.impl.finance;

import com.alibaba.fastjson.JSON;
import com.tydic.fsc.bill.ability.api.finance.FscEngineeringInvoiceAuditAbilityService;
import com.tydic.fsc.bill.ability.api.finance.FscFinancePushEngineeringSettleAbilityService;
import com.tydic.fsc.bill.ability.bo.finance.FscEngineeringInvoiceAuditAbilityReqBO;
import com.tydic.fsc.bill.ability.bo.finance.FscEngineeringInvoiceAuditAbilityRspBO;
import com.tydic.fsc.bill.ability.bo.finance.FscFinancePushSettleAbilityReqBO;
import com.tydic.fsc.bill.busi.api.finance.FscEngineeringInvoiceAuditBusiService;
import com.tydic.fsc.bill.busi.bo.finance.FscEngineeringInvoiceAuditBusiReqBO;
import com.tydic.fsc.bill.busi.bo.finance.FscEngineeringInvoiceAuditBusiRspBO;
import com.tydic.fsc.common.ability.api.FscComInvoiceSyncAbilityService;
import com.tydic.fsc.common.ability.api.FscEsSyncComOrderListAbilityService;
import com.tydic.fsc.common.ability.bo.FscComInvoiceListSyncAbilityReqBO;
import com.tydic.fsc.common.ability.bo.FscEsSyncComOrderListReqBO;
import com.tydic.fsc.constants.FscConstants;
import com.tydic.fsc.dao.FscInvoiceMapper;
import com.tydic.fsc.dao.FscOrderItemMapper;
import com.tydic.fsc.dao.FscOrderMapper;
import com.tydic.fsc.dao.FscOrderPayItemMapper;
import com.tydic.fsc.exception.FscBusinessException;
import com.tydic.fsc.po.FscInvoicePO;
import com.tydic.fsc.po.FscOrderItemPO;
import com.tydic.fsc.po.FscOrderPO;
import com.tydic.fsc.po.FscOrderPayItemPO;
import java.math.BigDecimal;
import java.util.Collection;
import java.util.List;
import java.util.Objects;
import java.util.concurrent.CompletableFuture;
import java.util.stream.Collectors;
import javax.annotation.Resource;
import org.apache.commons.lang3.StringUtils;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;
import org.springframework.beans.factory.annotation.Autowired;
import org.springframework.beans.factory.annotation.Value;
import org.springframework.util.CollectionUtils;
import org.springframework.web.bind.annotation.PostMapping;
import org.springframework.web.bind.annotation.RequestBody;
import org.springframework.web.bind.annotation.RequestMapping;
import org.springframework.web.bind.annotation.RestController;

@RestController
@RequestMapping(value={"FSC_GROUP_DEV/1.0.0/com.tydic.fsc.bill.ability.api.finance.FscEngineeringInvoiceAuditAbilityService"})
public class FscEngineeringInvoiceAuditAbilityServiceImpl
implements FscEngineeringInvoiceAuditAbilityService {
    private static final Logger log = LoggerFactory.getLogger(FscEngineeringInvoiceAuditAbilityServiceImpl.class);
    @Value(value="${FINANCE_STATION_ID:1060246138443051008}")
    private String financeStationId;
    @Autowired
    private FscEngineeringInvoiceAuditBusiService fscEngineeringInvoiceAuditBusiService;
    @Resource
    private FscOrderMapper fscOrderMapper;
    @Resource
    private FscOrderPayItemMapper fscOrderPayItemMapper;
    @Resource
    private FscOrderItemMapper fscOrderItemMapper;
    @Resource
    private FscInvoiceMapper fscInvoiceMapper;
    @Autowired
    private FscEsSyncComOrderListAbilityService fscEsSyncComOrderListAbilityService;
    @Autowired
    private FscComInvoiceSyncAbilityService fscComInvoiceSyncAbilityService;
    @Autowired
    private FscFinancePushEngineeringSettleAbilityService fscFinancePushEngineeringSettleAbilityService;

    @PostMapping(value={"dealEngineeringInvoiceAudit"})
    public FscEngineeringInvoiceAuditAbilityRspBO dealEngineeringInvoiceAudit(@RequestBody FscEngineeringInvoiceAuditAbilityReqBO reqBO) {
        FscEngineeringInvoiceAuditAbilityRspBO abilityRspBO = new FscEngineeringInvoiceAuditAbilityRspBO();
        this.val(reqBO);
        if (CollectionUtils.isEmpty((Collection)reqBO.getStationsList())) {
            throw new FscBusinessException("191019", "\u5f53\u524d\u8d26\u53f7\u65e0\u4e0b\u4e00\u6b65\u5ba1\u6279\u6743\u9650");
        }
        if (reqBO.getStationsList().contains(Long.valueOf(this.financeStationId)) && reqBO.getAuditResult() == 0) {
            this.checkInput(reqBO);
        }
        StringBuffer errorInfo = new StringBuffer();
        if (!CollectionUtils.isEmpty((Collection)reqBO.getOrderIds())) {
            for (Long orderId : reqBO.getOrderIds()) {
                reqBO.setOrderId(orderId);
                FscEngineeringInvoiceAuditBusiRspBO rspBO = this.signBusi(reqBO);
                errorInfo.append(rspBO.getResult());
                this.sendMq(orderId);
            }
        } else if (reqBO.getOrderId() != null) {
            FscEngineeringInvoiceAuditBusiRspBO rspBO = this.signBusi(reqBO);
            errorInfo.append(rspBO.getResult());
            this.sendMq(reqBO.getOrderId());
        }
        if (StringUtils.isNotEmpty((CharSequence)errorInfo)) {
            abilityRspBO.setRespCode("190000");
            abilityRspBO.setRespDesc(errorInfo.toString());
        } else {
            abilityRspBO.setRespCode("0000");
            abilityRspBO.setRespDesc("\u6210\u529f");
        }
        return abilityRspBO;
    }

    private FscEngineeringInvoiceAuditBusiRspBO signBusi(FscEngineeringInvoiceAuditAbilityReqBO reqBO) {
        String result = "";
        FscOrderPO fscOrderPO = new FscOrderPO();
        fscOrderPO.setFscOrderId(reqBO.getOrderId());
        fscOrderPO = this.fscOrderMapper.getModelBy(fscOrderPO);
        if (null == fscOrderPO) {
            throw new FscBusinessException("191019", "\u7ed3\u7b97\u4e3b\u5355\u4e0d\u5b58\u5728");
        }
        if (fscOrderPO.getSignStation() == null) {
            throw new FscBusinessException("191019", "\u7ed3\u7b97\u4e3b\u5355\u5ba1\u6279\u6743\u9650\u5f02\u5e38");
        }
        Integer count = this.fscOrderMapper.getOrderAuditCount(reqBO.getOrderId(), reqBO.getStationsList());
        if (count == 0 || CollectionUtils.isEmpty((Collection)reqBO.getStationsList())) {
            throw new FscBusinessException("191124", "\u60a8\u6ca1\u6709\u8be5\u7533\u8bf7\u5355\u7684\u5ba1\u6279\u6743\u9650,\u8bf7\u5237\u65b0\u4e0b\u9875\u9762\uff01");
        }
        if (!FscConstants.FscInvoiceOrderState.BILL_APPLY.equals(fscOrderPO.getOrderState())) {
            throw new FscBusinessException("191019", "\u5f53\u524d\u72b6\u6001[" + fscOrderPO.getOrderState() + "]\u4e0d\u5141\u8bb8\u5ba1\u6279");
        }
        FscEngineeringInvoiceAuditBusiReqBO fscEngineeringInvoiceAuditBusiReqBO = (FscEngineeringInvoiceAuditBusiReqBO)((Object)JSON.parseObject((String)JSON.toJSONString((Object)reqBO), FscEngineeringInvoiceAuditBusiReqBO.class));
        fscEngineeringInvoiceAuditBusiReqBO.setCurStatus(fscOrderPO.getOrderState());
        BigDecimal payAmount = BigDecimal.ZERO;
        FscOrderPayItemPO fscOrderPayItemPO = new FscOrderPayItemPO();
        fscOrderPayItemPO.setSettleId(reqBO.getOrderId());
        List list = this.fscOrderPayItemMapper.getList(fscOrderPayItemPO);
        if (!CollectionUtils.isEmpty((Collection)list)) {
            FscOrderPO settltFscOrderPO = new FscOrderPO();
            settltFscOrderPO.setFscOrderId(((FscOrderPayItemPO)list.get(0)).getFscOrderId());
            settltFscOrderPO = this.fscOrderMapper.getModelBy(settltFscOrderPO);
            payAmount = settltFscOrderPO.getTotalCharge();
        }
        fscEngineeringInvoiceAuditBusiReqBO.setPayAmount(payAmount);
        FscEngineeringInvoiceAuditBusiRspBO fscEngineeringInvoiceAuditBusiRspBO = this.fscEngineeringInvoiceAuditBusiService.dealEngineeringInvoiceAudit(fscEngineeringInvoiceAuditBusiReqBO);
        if (!"0000".equals(fscEngineeringInvoiceAuditBusiRspBO.getRespCode())) {
            result = result + "\u7ed3\u7b97\u5355" + fscOrderPO.getOrderNo() + "\u5ba1\u6279\u5931\u8d25\uff0c" + fscEngineeringInvoiceAuditBusiRspBO.getRespDesc() + ";";
        }
        if ("0000".equals(fscEngineeringInvoiceAuditBusiRspBO.getRespCode()) && fscEngineeringInvoiceAuditBusiRspBO.getFinish().booleanValue() && reqBO.getAuditResult() == 0) {
            CompletableFuture.runAsync(() -> {
                log.info("\u7ed3\u7b97\u5355\uff1a{}\u5ba1\u6279\u5b8c\u6210\u63a8\u9001\u8d22\u52a1\u5171\u4eab", (Object)reqBO.getOrderId());
                FscFinancePushSettleAbilityReqBO pushReqBPO = new FscFinancePushSettleAbilityReqBO();
                pushReqBPO.setFscOrderId(reqBO.getOrderId());
                this.fscFinancePushEngineeringSettleAbilityService.pushEngineeringSettle(pushReqBPO);
            });
        }
        fscEngineeringInvoiceAuditBusiRspBO.setResult(result);
        fscEngineeringInvoiceAuditBusiRspBO.setTradeMode(fscOrderPO.getTradeMode());
        return fscEngineeringInvoiceAuditBusiRspBO;
    }

    private void val(FscEngineeringInvoiceAuditAbilityReqBO reqBO) {
        if (null == reqBO) {
            throw new FscBusinessException("191000", "\u5165\u53c2\u5bf9\u8c61\u4e3a\u7a7a");
        }
        if (null == reqBO.getOrderId() && CollectionUtils.isEmpty((Collection)reqBO.getOrderIds())) {
            throw new FscBusinessException("191000", "\u5165\u53c2orderId\u4e3a\u7a7a");
        }
        if (Objects.isNull(reqBO.getAuditResult())) {
            throw new FscBusinessException("191000", "\u5165\u53c2\u5ba1\u6279\u7ed3\u679c\u4e0d\u80fd\u4e3a\u7a7a");
        }
    }

    private void checkInput(FscEngineeringInvoiceAuditAbilityReqBO reqBO) {
        log.info("\u4e1a\u8d22\u5ba1\u6279\u5c97\u4f4d");
        if (StringUtils.isBlank((CharSequence)reqBO.getCashItemCode()) || StringUtils.isBlank((CharSequence)reqBO.getCashItemName())) {
            throw new FscBusinessException("191000", "\u5165\u53c2\u73b0\u91d1\u6d41\u91cf\u8868\u9879\u4e0d\u80fd\u4e3a\u7a7a");
        }
        FscOrderItemPO fscOrderItemPO = new FscOrderItemPO();
        fscOrderItemPO.setFscOrderId(reqBO.getOrderId());
        List itemPOList = this.fscOrderItemMapper.getFinanceList(fscOrderItemPO);
        FscInvoicePO fscInvoicePO = new FscInvoicePO();
        fscInvoicePO.setFscOrderId(reqBO.getOrderId());
        List invoicePOList = this.fscInvoiceMapper.getList(fscInvoicePO);
        if (CollectionUtils.isEmpty((Collection)itemPOList) || CollectionUtils.isEmpty((Collection)invoicePOList)) {
            throw new FscBusinessException("191019", "\u672a\u67e5\u8be2\u5230\u7ed3\u7b97\u4fe1\u606f\uff0c\u8bf7\u6838\u5bf9\u5165\u53c2\uff01");
        }
        List checkItemList = itemPOList.stream().filter(e -> Objects.isNull(e.getIsSimpleTax()) || Objects.isNull(e.getIsInputOut()) || e.getIsInputOut() == 1 && e.getIsInputOutAmt().compareTo(BigDecimal.ZERO) == 0 || StringUtils.isBlank((CharSequence)e.getSettleItemCode())).collect(Collectors.toList());
        if (!CollectionUtils.isEmpty(checkItemList)) {
            throw new FscBusinessException("191019", "\u7ed3\u7b97\u660e\u7ec6\u4e2d\u662f\u5426\u7b80\u6613\u8ba1\u7a0e/\u5dee\u989d\u5f81\u7a0e\u3001\u662f\u5426\u6d89\u53ca\u8fdb\u9879\u7a0e\u8f6c\u51fa\u3001\u7ed3\u7b97\u4e8b\u9879\u5fc5\u586b\uff0c\u6d89\u53ca\u8fdb\u9879\u7a0e\u8f6c\u51fa\u65f6\u8fdb\u9879\u8f6c\u51fa\u7a0e\u91d1\u989d\u4e0d\u80fd\u4e3a\u7a7a\uff01");
        }
        List checkInvoiceList = invoicePOList.stream().filter(e -> Objects.isNull(e.getIsSimpleTax()) || Objects.isNull(e.getIsInputOut()) || e.getIsInputOut() == 1 && (e.getIsInputOutAmt().compareTo(BigDecimal.ZERO) == 0 || Objects.isNull(e.getInputOutTypeCode()))).collect(Collectors.toList());
        if (!CollectionUtils.isEmpty(checkInvoiceList)) {
            throw new FscBusinessException("191019", "\u53d1\u7968\u660e\u7ec6\u4e2d\u662f\u5426\u7b80\u6613\u8ba1\u7a0e/\u5dee\u989d\u5f81\u7a0e\u3001\u662f\u5426\u6d89\u53ca\u8fdb\u9879\u7a0e\u8f6c\u51fa\u5fc5\u586b\uff0c\u6d89\u53ca\u8fdb\u9879\u7a0e\u8f6c\u51fa\u65f6\u8fdb\u9879\u8f6c\u51fa\u7a0e\u91d1\u989d\u3001\u8fdb\u9879\u7a0e\u8f6c\u51fa\u7c7b\u578b\u4e0d\u80fd\u4e3a\u7a7a\uff01");
        }
        List checkInvoiceTaxList = invoicePOList.stream().filter(e -> Objects.nonNull(e.getTaxAmt()) && e.getTaxAmt().compareTo(e.getIsInputOutAmt()) < 0).collect(Collectors.toList());
        if (!CollectionUtils.isEmpty(checkInvoiceTaxList)) {
            throw new FscBusinessException("191019", "\u53d1\u7968\u660e\u7ec6\u4e2d\u8fdb\u9879\u7a0e\u8f6c\u51fa\u91d1\u989d\u4e0d\u80fd\u5927\u4e8e\u7a0e\u989d\uff01");
        }
        BigDecimal itemAmount = itemPOList.stream().map(FscOrderItemPO::getIsInputOutAmt).reduce(BigDecimal.ZERO, BigDecimal::add);
        BigDecimal invoiceAmount = invoicePOList.stream().map(FscInvoicePO::getIsInputOutAmt).reduce(BigDecimal.ZERO, BigDecimal::add);
        if (Objects.nonNull(itemAmount) && Objects.nonNull(invoiceAmount) && itemAmount.compareTo(invoiceAmount) != 0) {
            throw new FscBusinessException("191019", "\u7ed3\u7b97\u660e\u7ec6\u4e2d\u7684\u8f6c\u51fa\u8fdb\u9879\u7a0e\u91d1\u989d\u4e0e\u53d1\u7968\u660e\u7ec6\u7684\u8fdb\u9879\u7a0e\u8f6c\u51fa\u91d1\u989d\u5fc5\u987b\u76f8\u7b49\uff01");
        }
        if (Integer.valueOf(1).equals(reqBO.getPaySource())) {
            reqBO.getFscOrderPayItemBOS().forEach(o -> {
                List financePayItemBOS = o.getFinanceItemList().stream().filter(e -> "FKFS0001".equals(e.getFinancePayMethod()) && (Objects.isNull(e.getPayerAccountName()) || Objects.isNull(e.getPayerBankName()) || Objects.isNull(e.getPayerLinkBankCode()) || Objects.isNull(e.getPayerBankAccountNum()))).collect(Collectors.toList());
                if (!CollectionUtils.isEmpty(financePayItemBOS)) {
                    throw new FscBusinessException("191019", "\u5373\u6302\u5373\u4ed8\u4ed8\u6b3e\u660e\u7ec6\u4e2d\u7684\u4ed8\u6b3e\u65b9\u94f6\u884c\u4e0d\u80fd\u4e3a\u7a7a\uff01");
                }
            });
        }
    }

    private void sendMq(Long orderId) {
        FscEsSyncComOrderListReqBO syncReqBO = new FscEsSyncComOrderListReqBO();
        syncReqBO.setFscOrderId(orderId);
        this.fscEsSyncComOrderListAbilityService.dealOrderToEs(syncReqBO);
        FscComInvoiceListSyncAbilityReqBO fscComInvoiceListSyncAbilityReqBO = new FscComInvoiceListSyncAbilityReqBO();
        fscComInvoiceListSyncAbilityReqBO.setFscOrderId(orderId);
        this.fscComInvoiceSyncAbilityService.dealComOrderSyncEs(fscComInvoiceListSyncAbilityReqBO);
    }
}

