/*
 * Decompiled with CFR 0.152.
 */
package com.tydic.fsc.bill.ability.impl.finance;

import com.alibaba.fastjson.JSONObject;
import com.tydic.contract.ability.FscFinanceSelectContractAmountAbilityService;
import com.tydic.contract.ability.bo.FscFinanceSelectContractAmountReqBO;
import com.tydic.contract.ability.bo.FscFinanceSelectContractAmountRspBo;
import com.tydic.contract.ability.bo.FscFinanceSelectContractAmountRspBoList;
import com.tydic.fsc.bill.ability.api.finance.FscFinancePushEngineeringSettleAbilityService;
import com.tydic.fsc.bill.ability.bo.finance.FscFinancePushSettleAbilityReqBO;
import com.tydic.fsc.bill.ability.bo.finance.FscFinancePushSettleAbilityRspBO;
import com.tydic.fsc.bill.busi.api.finance.FscFinancePushSettleBusiService;
import com.tydic.fsc.bill.busi.bo.finance.FscFinancePushSettleBusiReqBO;
import com.tydic.fsc.bill.busi.bo.finance.FscFinancePushSettleBusiRspBO;
import com.tydic.fsc.bo.AttachmentBO;
import com.tydic.fsc.bo.FscFinanceAttachmentBO;
import com.tydic.fsc.busibase.busi.api.FscDictionaryBusiService;
import com.tydic.fsc.busibase.external.api.bo.finance.FscFinanceShareTokenRspBO;
import com.tydic.fsc.busibase.external.api.esb.finance.FscFinanceShareRelatedInterfacesAtomService;
import com.tydic.fsc.common.ability.api.FscComOrderSyncAbilityService;
import com.tydic.fsc.common.ability.api.finance.FscFinanceFileUploadAbilityService;
import com.tydic.fsc.common.ability.bo.FscComOrderListSyncAbilityReqBO;
import com.tydic.fsc.common.ability.bo.finance.FscFinanceFileUploadAbilityReqBO;
import com.tydic.fsc.common.ability.bo.finance.FscFinanceFileUploadAbilityRspBO;
import com.tydic.fsc.common.ability.bo.finance.FscFinancePushSettleAttachmentListBO;
import com.tydic.fsc.common.ability.bo.finance.FscFinancePushSettleBaseBO;
import com.tydic.fsc.common.ability.bo.finance.FscFinancePushSettleContractBO;
import com.tydic.fsc.common.ability.bo.finance.FscFinancePushSettleDetailBO;
import com.tydic.fsc.common.ability.bo.finance.FscFinancePushSettleInvoiceBO;
import com.tydic.fsc.common.ability.bo.finance.FscFinancePushSettleItemBO;
import com.tydic.fsc.common.ability.bo.finance.FscFinancePushSettleQualityItemBO;
import com.tydic.fsc.common.ability.bo.finance.FscFinancePushSettleWriteItemBO;
import com.tydic.fsc.constants.FscConstants;
import com.tydic.fsc.dao.FscAttachmentMapper;
import com.tydic.fsc.dao.FscFinanceWriteOffMapper;
import com.tydic.fsc.dao.FscInvoiceMapper;
import com.tydic.fsc.dao.FscOrderFinanceMapper;
import com.tydic.fsc.dao.FscOrderItemMapper;
import com.tydic.fsc.dao.FscOrderMapper;
import com.tydic.fsc.dao.FscOrderRefundMapper;
import com.tydic.fsc.dao.FscOrderRelationMapper;
import com.tydic.fsc.enums.FscFundsclaimBillTypeEnum;
import com.tydic.fsc.exception.FscBusinessException;
import com.tydic.fsc.pay.ability.bo.finance.FscFinancePushPayBillAbilityRspBO;
import com.tydic.fsc.po.FscAttachmentPO;
import com.tydic.fsc.po.FscFinanceWriteOffPO;
import com.tydic.fsc.po.FscInvoicePO;
import com.tydic.fsc.po.FscOrderFinancePO;
import com.tydic.fsc.po.FscOrderItemPO;
import com.tydic.fsc.po.FscOrderPO;
import com.tydic.fsc.po.FscOrderRefundPO;
import com.tydic.fsc.po.FscOrderRelationPO;
import com.tydic.fsc.util.DateUtil;
import java.math.BigDecimal;
import java.math.RoundingMode;
import java.util.ArrayList;
import java.util.Calendar;
import java.util.Collection;
import java.util.Comparator;
import java.util.Date;
import java.util.HashMap;
import java.util.List;
import java.util.Map;
import java.util.Objects;
import java.util.function.Function;
import java.util.stream.Collectors;
import javax.annotation.Resource;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;
import org.springframework.beans.factory.annotation.Autowired;
import org.springframework.util.CollectionUtils;
import org.springframework.util.StringUtils;
import org.springframework.web.bind.annotation.PostMapping;
import org.springframework.web.bind.annotation.RequestBody;
import org.springframework.web.bind.annotation.RequestMapping;
import org.springframework.web.bind.annotation.RestController;

@RestController
@RequestMapping(value={"FSC_GROUP_DEV/1.0.0/com.tydic.fsc.bill.ability.api.finance.FscFinancePushEngineeringSettleAbilityService"})
public class FscFinancePushEngineeringSettleAbilityServiceImpl
implements FscFinancePushEngineeringSettleAbilityService {
    private static final Logger log = LoggerFactory.getLogger(FscFinancePushEngineeringSettleAbilityServiceImpl.class);
    @Resource
    private FscOrderMapper fscOrderMapper;
    @Resource
    private FscOrderFinanceMapper fscOrderFinanceMapper;
    @Resource
    private FscOrderRelationMapper fscOrderRelationMapper;
    @Resource
    private FscOrderItemMapper fscOrderItemMapper;
    @Resource
    private FscFinanceWriteOffMapper fscFinanceWriteOffMapper;
    @Resource
    private FscInvoiceMapper fscInvoiceMapper;
    @Resource
    private FscAttachmentMapper fscAttachmentMapper;
    @Resource
    private FscOrderRefundMapper fscOrderRefundMapper;
    @Autowired
    private FscComOrderSyncAbilityService fscComOrderSyncAbilityService;
    @Autowired
    private FscFinanceShareRelatedInterfacesAtomService fscFinanceShareRelatedInterfacesAtomService;
    @Autowired
    private FscFinancePushSettleBusiService fscFinancePushSettleBusiService;
    @Autowired
    private FscDictionaryBusiService fscDictionaryBusiService;
    @Autowired
    private FscFinanceSelectContractAmountAbilityService fscFinanceSelectContractAmountAbilityService;
    @Autowired
    private FscFinanceFileUploadAbilityService fscFinanceFileUploadAbilityService;

    @PostMapping(value={"pushEngineeringSettle"})
    public FscFinancePushSettleAbilityRspBO pushEngineeringSettle(@RequestBody FscFinancePushSettleAbilityReqBO reqBO) {
        if (reqBO.getFscOrderId() == null) {
            throw new FscBusinessException("198888", "\u5165\u53c2[fscOrderId]\u4e0d\u80fd\u4e3a\u7a7a\uff01");
        }
        FscOrderPO orderPO = new FscOrderPO();
        orderPO.setFscOrderId(reqBO.getFscOrderId());
        orderPO = this.fscOrderMapper.getModelBy(orderPO);
        if (orderPO == null) {
            throw new FscBusinessException("198888", reqBO.getFscOrderId() + "\u672a\u67e5\u8be2\u5230\u7ed3\u7b97\u5355\u4fe1\u606f!");
        }
        FscOrderFinancePO financePO = new FscOrderFinancePO();
        financePO.setFscOrderId(reqBO.getFscOrderId());
        financePO = this.fscOrderFinanceMapper.getModelBy(financePO);
        if (financePO == null) {
            throw new FscBusinessException("198888", "\u67e5\u8be2\u7ed3\u7b97\u5171\u4eab\u4fe1\u606f\u5931\u8d25\uff01");
        }
        if (FscConstants.FscPushStatus.SUCCESS.equals(financePO.getPushFinanceStatus())) {
            throw new FscBusinessException("198888", "\u5f53\u524d\u5355\u636e\u5df2\u63a8\u9001\u6210\u529f\uff0c\u8bf7\u52ff\u91cd\u590d\u63a8\u9001\uff01");
        }
        this.handleSettleInfo(reqBO, orderPO, financePO);
        FscFinancePushSettleAbilityRspBO rspBO = new FscFinancePushSettleAbilityRspBO();
        rspBO.setRespCode("0000");
        rspBO.setRespDesc("\u6210\u529f");
        return rspBO;
    }

    @PostMapping(value={"dealPushEngineeringSettleBatch"})
    public FscFinancePushSettleAbilityRspBO dealPushEngineeringSettleBatch(@RequestBody FscFinancePushSettleAbilityReqBO reqBO) {
        if (CollectionUtils.isEmpty((Collection)reqBO.getFscOrderIds())) {
            throw new FscBusinessException("198888", "\u5165\u53c2[fscOrderIds]\u4e0d\u80fd\u4e3a\u7a7a\uff01");
        }
        StringBuilder sb = new StringBuilder();
        for (Long fscOrderId : reqBO.getFscOrderIds()) {
            FscFinancePushSettleAbilityReqBO abilityReqBO = new FscFinancePushSettleAbilityReqBO();
            abilityReqBO.setFscOrderId(fscOrderId);
            FscFinancePushSettleAbilityRspBO abilityRspBO = this.pushEngineeringSettle(abilityReqBO);
            if ("0000".equals(abilityRspBO.getRespCode())) continue;
            sb.append("\u5355\u636e[").append(fscOrderId).append("]\u63a8\u9001\u5931\u8d25\uff1a").append(abilityRspBO.getRespDesc());
        }
        FscFinancePushSettleAbilityRspBO rspBO = new FscFinancePushSettleAbilityRspBO();
        rspBO.setRespCode("0000");
        rspBO.setRespDesc("\u6210\u529f");
        if (!StringUtils.isEmpty((Object)sb.toString())) {
            rspBO.setRespCode("190000");
            rspBO.setRespDesc(sb.toString());
        }
        return rspBO;
    }

    private void handleSettleInfo(FscFinancePushSettleAbilityReqBO reqBO, FscOrderPO orderPO, FscOrderFinancePO financePO) {
        try {
            FscOrderRelationPO fscOrderRelationPO = new FscOrderRelationPO();
            fscOrderRelationPO.setFscOrderId(reqBO.getFscOrderId());
            List fscOrderRelationPOList = this.fscOrderRelationMapper.getListByContractId(fscOrderRelationPO);
            if (CollectionUtils.isEmpty((Collection)fscOrderRelationPOList)) {
                throw new FscBusinessException("198888", "\u67e5\u8be2\u7ed3\u7b97\u5173\u8054\u4fe1\u606f\u5931\u8d25\uff01");
            }
            FscAttachmentPO fscAttachmentPO = new FscAttachmentPO();
            fscAttachmentPO.setFscOrderId(reqBO.getFscOrderId());
            fscAttachmentPO.setObjType(FscConstants.AttachmentType.FSC_ORDER);
            List fscAttachmentPOList = this.fscAttachmentMapper.getList(fscAttachmentPO);
            Map<Long, List<FscAttachmentPO>> attachmentMap = fscAttachmentPOList.stream().collect(Collectors.groupingBy(FscAttachmentPO::getObjId));
            FscFinancePushSettleBaseBO fscFinancePushSettleBaseBO = this.buildSettleInfo(orderPO, financePO, fscAttachmentPOList);
            List<FscFinancePushSettleContractBO> purSettleContractList = this.buildContractInfo(fscOrderRelationPOList, orderPO, attachmentMap, financePO);
            FscFinancePushSettleDetailBO fscFinancePushSettleDetailBO = new FscFinancePushSettleDetailBO();
            fscFinancePushSettleDetailBO.setBaseInfoData(fscFinancePushSettleBaseBO);
            fscFinancePushSettleDetailBO.setPurSettleContractList(purSettleContractList);
            this.dealPush(orderPO, fscFinancePushSettleDetailBO);
        }
        catch (Exception ex) {
            log.error("\u7ed3\u7b97\u5355\u63a8\u9001\u8d22\u52a1\u5171\u4eab\u5f02\u5e38" + ex);
            this.dealBuildFail(orderPO, ex);
        }
        FscComOrderListSyncAbilityReqBO fscComOrderListSyncAbilityReqBO = new FscComOrderListSyncAbilityReqBO();
        fscComOrderListSyncAbilityReqBO.setFscOrderId(orderPO.getFscOrderId());
        this.fscComOrderSyncAbilityService.dealComOrderSyncEs(fscComOrderListSyncAbilityReqBO);
    }

    private FscFinancePushSettleBaseBO buildSettleInfo(FscOrderPO orderPO, FscOrderFinancePO financePO, List<FscAttachmentPO> fscAttachmentPOList) {
        FscInvoicePO fscInvoicePO = new FscInvoicePO();
        fscInvoicePO.setFscOrderId(orderPO.getFscOrderId());
        int invoiceNum = this.fscInvoiceMapper.getCount(fscInvoicePO);
        FscFinancePushSettleBaseBO fscFinancePushSettleBaseBO = new FscFinancePushSettleBaseBO();
        fscFinancePushSettleBaseBO.setSrcSys("EB");
        fscFinancePushSettleBaseBO.setSrcBillId(orderPO.getFscOrderId() + "");
        fscFinancePushSettleBaseBO.setSrcBillCode(orderPO.getOrderNo());
        fscFinancePushSettleBaseBO.setCreateUser(financePO.getCreateUserId());
        fscFinancePushSettleBaseBO.setCreateUserName(financePO.getFinanceUserName());
        fscFinancePushSettleBaseBO.setCreateDate(DateUtil.dateToStrLong((Date)orderPO.getCreateTime()));
        fscFinancePushSettleBaseBO.setDeptCode(financePO.getFinanceDeptId());
        fscFinancePushSettleBaseBO.setDeptName(financePO.getFinanceDeptName());
        fscFinancePushSettleBaseBO.setOrgId(financePO.getFinanceOrgId());
        fscFinancePushSettleBaseBO.setOrgName(financePO.getFinanceOrgName());
        fscFinancePushSettleBaseBO.setAccountEntityCode(financePO.getAccountEntityCode());
        fscFinancePushSettleBaseBO.setAccountEntityName(financePO.getAccountEntityName());
        fscFinancePushSettleBaseBO.setBillDate(DateUtil.dateToStrYYYYMMdd((Date)orderPO.getCreateTime()));
        fscFinancePushSettleBaseBO.setBizDeptCode(financePO.getBizDeptCode());
        fscFinancePushSettleBaseBO.setBizDeptName(financePO.getBizDeptName());
        fscFinancePushSettleBaseBO.setBizTypeCode(financePO.getBizTypeCode());
        fscFinancePushSettleBaseBO.setBizTypeName(financePO.getBizTypeName());
        fscFinancePushSettleBaseBO.setBizItemCode(financePO.getBusinessItemCode());
        fscFinancePushSettleBaseBO.setBizItemName(financePO.getBusinessItemName());
        fscFinancePushSettleBaseBO.setNote(financePO.getNote());
        fscFinancePushSettleBaseBO.setAttachmentNum(Integer.valueOf(CollectionUtils.isEmpty(fscAttachmentPOList) ? invoiceNum : fscAttachmentPOList.size() + invoiceNum));
        fscFinancePushSettleBaseBO.setSegmentCode(financePO.getSegmentCode());
        fscFinancePushSettleBaseBO.setSegmentName(financePO.getSegmentName());
        Calendar calendar = Calendar.getInstance();
        calendar.setTime(orderPO.getCreateTime());
        fscFinancePushSettleBaseBO.setBillYear(calendar.get(1) + "");
        fscFinancePushSettleBaseBO.setBillTypeCode(FscFundsclaimBillTypeEnum.SETTLE_TYPE_USED_CONTRACT.getName());
        fscFinancePushSettleBaseBO.setBillTypeName(FscFundsclaimBillTypeEnum.SETTLE_TYPE_USED_CONTRACT.getDescription());
        fscFinancePushSettleBaseBO.setSegCompanyCode(financePO.getCompanySegmentCode());
        fscFinancePushSettleBaseBO.setSegCompanyName(financePO.getCompanySegmentName());
        fscFinancePushSettleBaseBO.setSegProjectCode(financePO.getProjectSegmentCode());
        fscFinancePushSettleBaseBO.setSegProjectName(financePO.getProjectSegmentName());
        fscFinancePushSettleBaseBO.setSegContractCode(financePO.getContractSegmentCode());
        fscFinancePushSettleBaseBO.setSegContractName(financePO.getContractSegmentName());
        fscFinancePushSettleBaseBO.setSegProductCode(null);
        fscFinancePushSettleBaseBO.setSegProductName(null);
        fscFinancePushSettleBaseBO.setSegMainSubjectName(null);
        fscFinancePushSettleBaseBO.setSegMainSubjectCode(null);
        fscFinancePushSettleBaseBO.setSegSubSubjectCode(null);
        fscFinancePushSettleBaseBO.setSegSubSubjectName(null);
        fscFinancePushSettleBaseBO.setSegCorrespondentCode(null);
        fscFinancePushSettleBaseBO.setSegCorrespondentName(null);
        fscFinancePushSettleBaseBO.setSegCalcCostCode(null);
        fscFinancePushSettleBaseBO.setSegCalcCostName(null);
        fscFinancePushSettleBaseBO.setSegProduceStageCode(null);
        fscFinancePushSettleBaseBO.setSegProduceStageName(null);
        fscFinancePushSettleBaseBO.setSegBakCode(null);
        fscFinancePushSettleBaseBO.setSegBakName(null);
        fscFinancePushSettleBaseBO.setSettleAmt(orderPO.getTotalCharge());
        fscFinancePushSettleBaseBO.setSettleLocalAmt(orderPO.getTotalCharge().multiply(financePO.getExchangeRate()));
        fscFinancePushSettleBaseBO.setCheckAdvPayAmt(orderPO.getPurWriteOffAmount());
        fscFinancePushSettleBaseBO.setCheckAdvPayLocalAmt(orderPO.getPurWriteOffAmount().multiply(financePO.getExchangeRate()));
        if (StringUtils.isEmpty((Object)financePO.getCashItemCode()) || StringUtils.isEmpty((Object)financePO.getCashItemName())) {
            throw new FscBusinessException("198888", "\u73b0\u91d1\u6d41\u91cf\u8868\u9879\u4e0d\u80fd\u4e3a\u7a7a\uff0c\u8bf7\u7ef4\u62a4\u540e\u91cd\u65b0\u63a8\u9001\uff01\u7ed3\u7b97\u5355\u7f16\u53f7\uff1a" + orderPO.getOrderNo());
        }
        fscFinancePushSettleBaseBO.setCashItemCode(financePO.getCashItemCode());
        fscFinancePushSettleBaseBO.setCashItemName(financePO.getCashItemName());
        fscFinancePushSettleBaseBO.setCashItemDetailCode(financePO.getCashDetailCode());
        fscFinancePushSettleBaseBO.setCashItemDetailName(financePO.getCashDetailName());
        fscFinancePushSettleBaseBO.setSupplierCode(financePO.getExt1());
        fscFinancePushSettleBaseBO.setSupplierName(orderPO.getPayeeName());
        fscFinancePushSettleBaseBO.setSupplierAreaCode(financePO.getVendorSiteId() + "");
        fscFinancePushSettleBaseBO.setSupplierAreaName(financePO.getVendorSiteName());
        Map currencTypeMap = this.fscDictionaryBusiService.queryBypCodeBackMap("FSC_MONEY_UNIT");
        fscFinancePushSettleBaseBO.setCurrencyCode(financePO.getCurrency());
        fscFinancePushSettleBaseBO.setCurrencyName((String)currencTypeMap.get(financePO.getCurrency()));
        fscFinancePushSettleBaseBO.setRate(financePO.getExchangeRate());
        fscFinancePushSettleBaseBO.setBizDate(DateUtil.dateToStrYYYYMMdd((Date)orderPO.getCreateTime()));
        FscOrderItemPO itemPO = new FscOrderItemPO();
        itemPO.setFscOrderId(orderPO.getFscOrderId());
        itemPO = this.fscOrderItemMapper.getTaxAmtByFscOrder(itemPO);
        fscFinancePushSettleBaseBO.setTaxAmt(itemPO.getTaxAmtSum());
        fscFinancePushSettleBaseBO.setTaxLocalAmt(fscFinancePushSettleBaseBO.getTaxAmt().multiply(financePO.getExchangeRate()));
        fscFinancePushSettleBaseBO.setEstimateBillGuid(null);
        fscFinancePushSettleBaseBO.setEstimateBillCode(null);
        fscFinancePushSettleBaseBO.setEstimateBizTypeCode(null);
        fscFinancePushSettleBaseBO.setBizAccountant(financePO.getFinanceAuditAccount());
        fscFinancePushSettleBaseBO.setBizAccountantName(financePO.getFinanceAuditName());
        if (orderPO.getRefundId() != null) {
            FscOrderRefundPO refundPO = new FscOrderRefundPO();
            refundPO.setRefundId(orderPO.getRefundId());
            refundPO = this.fscOrderRefundMapper.getModelBy(refundPO);
            fscFinancePushSettleBaseBO.setOffsetBillGuid(refundPO.getRefundId() + "");
            fscFinancePushSettleBaseBO.setOffsetBillCode(refundPO.getRefundNo());
            fscFinancePushSettleBaseBO.setOffsetType("0");
            fscFinancePushSettleBaseBO.setSettleBillGuid(refundPO.getFscOrderId() + "");
            fscFinancePushSettleBaseBO.setSettleBillCode(refundPO.getFscOrderNo());
            fscFinancePushSettleBaseBO.setOffsetBizTypeCode(null);
            fscFinancePushSettleBaseBO.setOffsetBizTypeName(null);
        }
        return fscFinancePushSettleBaseBO;
    }

    private List<FscFinancePushSettleContractBO> buildContractInfo(List<FscOrderRelationPO> fscOrderRelationPOList, FscOrderPO orderPO, Map<Long, List<FscAttachmentPO>> attachmentMap, FscOrderFinancePO financePO) {
        ArrayList<FscFinancePushSettleContractBO> purSettleContractList = new ArrayList<FscFinancePushSettleContractBO>();
        List<Long> contractIds = fscOrderRelationPOList.stream().map(FscOrderRelationPO::getContractId).distinct().collect(Collectors.toList());
        if (CollectionUtils.isEmpty(contractIds)) {
            throw new FscBusinessException("198888", "\u5f53\u524d\u7ed3\u7b97\u5355\u65e0\u5408\u540c\u4fe1\u606f\uff0c\u65e0\u9700\u63a8\u9001");
        }
        Map relationPOMap = fscOrderRelationPOList.stream().sorted(Comparator.comparingLong(FscOrderRelationPO::getId)).collect(Collectors.toMap(FscOrderRelationPO::getContractId, Function.identity(), (k1, k2) -> k1));
        List orderIds = fscOrderRelationPOList.stream().map(FscOrderRelationPO::getOrderId).collect(Collectors.toList());
        FscFinanceSelectContractAmountReqBO fscFinanceSelectContractAmountReqBO = new FscFinanceSelectContractAmountReqBO();
        fscFinanceSelectContractAmountReqBO.setContractIds(contractIds);
        FscFinanceSelectContractAmountRspBo fscFinanceSelectContractAmountRspBo = this.fscFinanceSelectContractAmountAbilityService.selectContractAmount(fscFinanceSelectContractAmountReqBO);
        if (Objects.nonNull(fscFinanceSelectContractAmountRspBo) && !"0000".equals(fscFinanceSelectContractAmountRspBo.getRespCode())) {
            throw new FscBusinessException("198888", "\u67e5\u8be2\u5408\u540c\u670d\u52a1\u5f02\u5e38\uff01");
        }
        Map<Object, Object> contractMap = CollectionUtils.isEmpty((Collection)fscFinanceSelectContractAmountRspBo.getRows()) ? new HashMap() : fscFinanceSelectContractAmountRspBo.getRows().stream().collect(Collectors.toMap(FscFinanceSelectContractAmountRspBoList::getContractId, Function.identity(), (k1, k2) -> k1));
        contractIds.forEach(contractId -> {
            if (!relationPOMap.containsKey(contractId)) {
                throw new FscBusinessException("198888", "\u7cfb\u7edf\u5f02\u5e38\uff01");
            }
            FscOrderItemPO fscOrderItemPO = new FscOrderItemPO();
            fscOrderItemPO.setFscOrderId(orderPO.getFscOrderId());
            fscOrderItemPO.setContractId(contractId);
            List fscOrderItemPOList = this.fscOrderItemMapper.getFinanceList(fscOrderItemPO);
            if (CollectionUtils.isEmpty((Collection)fscOrderItemPOList)) {
                throw new FscBusinessException("198888", "\u5f53\u524d\u7ed3\u7b97\u5355\u672a\u67e5\u8be2\u5230\u7ed3\u7b97\u660e\u7ec6\uff0c\u8bf7\u6838\u5bf9\u540e\u91cd\u8bd5\uff01");
            }
            BigDecimal settleAmt = fscOrderItemPOList.stream().map(FscOrderItemPO::getAmt).reduce(BigDecimal.ZERO, BigDecimal::add);
            BigDecimal taxAmt = fscOrderItemPOList.stream().map(FscOrderItemPO::getTaxAmt).reduce(BigDecimal.ZERO, BigDecimal::add);
            FscInvoicePO fscInvoicePO = new FscInvoicePO();
            fscInvoicePO.setFscOrderId(orderPO.getFscOrderId());
            fscInvoicePO.setContractId(contractId);
            List fscInvoicePOList = this.fscInvoiceMapper.getList(fscInvoicePO);
            if (CollectionUtils.isEmpty((Collection)fscInvoicePOList)) {
                throw new FscBusinessException("198888", "\u5f53\u524d\u7ed3\u7b97\u5355\u672a\u67e5\u8be2\u5230\u53d1\u7968\u5217\u8868\uff0c\u8bf7\u6838\u5bf9\u540e\u91cd\u8bd5\uff01\u5408\u540c\u7f16\u7801\uff1a" + ((FscOrderRelationPO)relationPOMap.get(contractId)).getContractNo());
            }
            FscFinanceWriteOffPO fscFinanceWriteOffPO = new FscFinanceWriteOffPO();
            fscFinanceWriteOffPO.setFscOrderId(orderPO.getFscOrderId());
            fscFinanceWriteOffPO.setContractId(contractId);
            List fscFinanceWriteOffPOList = this.fscFinanceWriteOffMapper.getList(fscFinanceWriteOffPO);
            List<FscFinancePushSettleInvoiceBO> invoiceList = this.buildInvoiceInfo(fscInvoicePOList);
            ArrayList<FscFinancePushSettleItemBO> settleNodetailList = new ArrayList<FscFinancePushSettleItemBO>();
            this.buildSettleItem(fscOrderItemPOList, financePO, settleNodetailList);
            List<Object> advCheckList = new ArrayList();
            BigDecimal writeOffAmt = BigDecimal.ZERO;
            if (!CollectionUtils.isEmpty((Collection)fscFinanceWriteOffPOList)) {
                writeOffAmt = fscFinanceWriteOffPOList.stream().map(FscFinanceWriteOffPO::getWriteOffAmt).reduce(BigDecimal.ZERO, BigDecimal::add);
                advCheckList = this.buildWriteOff(fscFinanceWriteOffPOList);
            }
            List<FscFinancePushSettleQualityItemBO> qualityDepositList = this.buildQualityInfo(orderPO, financePO, (Long)contractId);
            List<Object> cmAttachmentList = new ArrayList();
            if (!CollectionUtils.isEmpty((Map)attachmentMap) && attachmentMap.containsKey(contractId)) {
                cmAttachmentList = this.buildAttachmentInfo((List)attachmentMap.get(contractId), financePO);
            }
            FscFinancePushSettleContractBO contractBO = new FscFinancePushSettleContractBO();
            contractBO.setGuid(String.valueOf(((FscOrderRelationPO)relationPOMap.get(contractId)).getId()));
            contractBO.setContractCode(((FscOrderRelationPO)relationPOMap.get(contractId)).getContractNo());
            if (contractMap.containsKey(contractId)) {
                contractBO.setContractAmt(((FscFinanceSelectContractAmountRspBoList)contractMap.get(contractId)).getContractAmount());
            }
            contractBO.setContractName(((FscOrderRelationPO)relationPOMap.get(contractId)).getContractName());
            contractBO.setSettleAmt(settleAmt);
            contractBO.setSettleLocalAmt(settleAmt.multiply(financePO.getExchangeRate()));
            contractBO.setCheckAdvPayAmt(writeOffAmt);
            contractBO.setCheckAdvPayLocalAmt(writeOffAmt.multiply(financePO.getExchangeRate()));
            contractBO.setSegContractCode(((FscOrderRelationPO)relationPOMap.get(contractId)).getContractSegmentCode());
            contractBO.setSegContractName(((FscOrderRelationPO)relationPOMap.get(contractId)).getContractSegmentName());
            contractBO.setTaxRateCode(null);
            contractBO.setTaxRateName(null);
            contractBO.setTaxAmt(taxAmt);
            contractBO.setTaxLocalAmt(taxAmt.multiply(financePO.getExchangeRate()));
            contractBO.setEstimateBillCode(((FscOrderRelationPO)relationPOMap.get(contractId)).getEstimateBillCode());
            contractBO.setEstimateBillGuid(((FscOrderRelationPO)relationPOMap.get(contractId)).getEstimateBillGuid());
            contractBO.setEstimateBizTypeCode(((FscOrderRelationPO)relationPOMap.get(contractId)).getEstimateBizTypeCode());
            contractBO.setContractId(String.valueOf(contractId));
            Date qualityDate = ((FscOrderRelationPO)relationPOMap.get(contractId)).getQualityDate();
            Date shouldPayDate = ((FscOrderRelationPO)relationPOMap.get(contractId)).getShouldPayDate();
            if (Objects.nonNull(qualityDate) && Objects.nonNull(shouldPayDate)) {
                contractBO.setPanDueDate(shouldPayDate.compareTo(qualityDate) > 0 ? DateUtil.dateToStr((Date)shouldPayDate) : DateUtil.dateToStr((Date)qualityDate));
            } else if (Objects.nonNull(qualityDate)) {
                contractBO.setPanDueDate(DateUtil.dateToStr((Date)qualityDate));
            } else if (Objects.nonNull(shouldPayDate)) {
                contractBO.setPanDueDate(DateUtil.dateToStr((Date)shouldPayDate));
            } else if (Objects.nonNull(((FscOrderRelationPO)relationPOMap.get(contractId)).getPanDueDate())) {
                contractBO.setPanDueDate(DateUtil.dateToStr((Date)((FscOrderRelationPO)relationPOMap.get(contractId)).getPanDueDate()));
            }
            contractBO.setInvoiceList(invoiceList);
            contractBO.setSettleNodetailList(settleNodetailList);
            contractBO.setAdvCheckList(advCheckList);
            contractBO.setCmAttachmentList(cmAttachmentList);
            contractBO.setQualityDepositList(qualityDepositList);
            purSettleContractList.add(contractBO);
        });
        return purSettleContractList;
    }

    private List<FscFinancePushSettleAttachmentListBO> buildAttachmentInfo(List<FscAttachmentPO> attachmentPOList, FscOrderFinancePO financePO) {
        if (CollectionUtils.isEmpty(attachmentPOList)) {
            return new ArrayList<FscFinancePushSettleAttachmentListBO>();
        }
        List boList = JSONObject.parseArray((String)JSONObject.toJSONString(attachmentPOList), AttachmentBO.class);
        FscFinanceFileUploadAbilityReqBO abilityReqBO = new FscFinanceFileUploadAbilityReqBO();
        abilityReqBO.setFileList(boList);
        FscFinanceFileUploadAbilityRspBO abilityRspBO = this.fscFinanceFileUploadAbilityService.dealFinanceUpload(abilityReqBO);
        if (!"0000".equals(abilityRspBO.getRespCode())) {
            throw new FscBusinessException("198888", "\u8c03\u7528\u8d22\u52a1\u5171\u4eab\u9644\u4ef6\u4e0a\u4f20\u5931\u8d25\uff1a" + abilityRspBO.getRespDesc());
        }
        ArrayList<FscFinancePushSettleAttachmentListBO> fileList = new ArrayList<FscFinancePushSettleAttachmentListBO>(abilityRspBO.getFileList().size());
        for (FscFinanceAttachmentBO bo : abilityRspBO.getFileList()) {
            FscFinancePushSettleAttachmentListBO pushBo = new FscFinancePushSettleAttachmentListBO();
            pushBo.setFileId(bo.getFileId());
            pushBo.setFileName(bo.getFileName());
            pushBo.setFileSize(bo.getFileSize());
            pushBo.setCreateUserName(financePO.getFinanceUserName());
            pushBo.setCreateUser(financePO.getFinanceUserId());
            pushBo.setCreateDate(DateUtil.dateToStrLong((Date)financePO.getCreateTime()));
            fileList.add(pushBo);
        }
        return fileList;
    }

    private FscFinancePushPayBillAbilityRspBO dealPush(FscOrderPO orderPO, FscFinancePushSettleDetailBO fscFinancePushSettleDetailBO) {
        String token = this.getToken();
        FscFinancePushSettleBusiReqBO busiReqBO = new FscFinancePushSettleBusiReqBO();
        busiReqBO.setFscOrderId(orderPO.getFscOrderId());
        busiReqBO.setFscFinancePushSettleDetailBO(fscFinancePushSettleDetailBO);
        busiReqBO.setToken(token);
        busiReqBO.setOrderNo(orderPO.getOrderNo());
        if (orderPO.getRefundId() != null) {
            busiReqBO.setIsReopen(true);
        }
        FscFinancePushSettleBusiRspBO busiRspBO = this.fscFinancePushSettleBusiService.dealPushSettle(busiReqBO);
        FscFinancePushPayBillAbilityRspBO rspBO = new FscFinancePushPayBillAbilityRspBO();
        rspBO.setRespCode(busiRspBO.getRespCode());
        rspBO.setRespDesc(busiRspBO.getRespDesc());
        return rspBO;
    }

    private FscFinancePushPayBillAbilityRspBO dealBuildFail(FscOrderPO orderPO, Exception e) {
        FscFinancePushSettleBusiReqBO busiReqBO = new FscFinancePushSettleBusiReqBO();
        busiReqBO.setFscOrderId(orderPO.getFscOrderId());
        busiReqBO.setOrderNo(orderPO.getOrderNo());
        busiReqBO.setFailRemark(e.getMessage());
        this.fscFinancePushSettleBusiService.updateFailLog(busiReqBO);
        FscFinancePushPayBillAbilityRspBO rspBO = new FscFinancePushPayBillAbilityRspBO();
        rspBO.setRespCode("198888");
        rspBO.setRespDesc("\u6784\u5efa\u63a8\u9001\u5171\u4eab\u7ed3\u7b97\u5355\u53c2\u6570\u5f02\u5e38\uff1a" + e.getMessage());
        return rspBO;
    }

    private List<FscFinancePushSettleInvoiceBO> buildInvoiceInfo(List<FscInvoicePO> fscInvoicePOList) {
        ArrayList<FscFinancePushSettleInvoiceBO> invoiceList = new ArrayList<FscFinancePushSettleInvoiceBO>();
        fscInvoicePOList.forEach(invoice -> {
            if (Objects.isNull(invoice.getFinanceGuid())) {
                throw new FscBusinessException("198888", "\u5b58\u5728\u53d1\u7968\u672a\u4e0a\u4f20\u5171\u4eab\u7968\u5939\uff0c\u53d1\u7968ID\uff1a" + invoice.getInvoiceId());
            }
            FscFinancePushSettleInvoiceBO fscFinancePushSettleInvoiceBO = new FscFinancePushSettleInvoiceBO();
            fscFinancePushSettleInvoiceBO.setOriginGuid(invoice.getFinanceGuid());
            fscFinancePushSettleInvoiceBO.setGuid(String.valueOf(invoice.getInvoiceId()));
            if ("01".equals(invoice.getInvoiceType()) && FscConstants.InvoiceCategory.PAPER.equals(invoice.getInvoiceCategory())) {
                fscFinancePushSettleInvoiceBO.setInvoiceType("1010100");
            } else if ("00".equals(invoice.getInvoiceType()) && FscConstants.InvoiceCategory.PAPER.equals(invoice.getInvoiceCategory())) {
                fscFinancePushSettleInvoiceBO.setInvoiceType("1010101");
            } else if ("01".equals(invoice.getInvoiceType()) && FscConstants.InvoiceCategory.ELECTRON.equals(invoice.getInvoiceCategory())) {
                fscFinancePushSettleInvoiceBO.setInvoiceType("1010102");
            } else if ("00".equals(invoice.getInvoiceType()) && FscConstants.InvoiceCategory.FULL_ELECTRON.equals(invoice.getInvoiceCategory())) {
                fscFinancePushSettleInvoiceBO.setInvoiceType("1010107");
            } else if ("03".equals(invoice.getInvoiceType()) && FscConstants.InvoiceCategory.FULL_ELECTRON.equals(invoice.getInvoiceCategory())) {
                fscFinancePushSettleInvoiceBO.setInvoiceType("1010108");
            }
            if (Objects.nonNull(invoice.getFullElecNo()) && FscConstants.FscInvoiceCategory.FULL.equals(invoice.getInvoiceCategory())) {
                fscFinancePushSettleInvoiceBO.setInvoiceNo(invoice.getFullElecNo());
            } else {
                fscFinancePushSettleInvoiceBO.setInvoiceNo(invoice.getInvoiceNo());
            }
            fscFinancePushSettleInvoiceBO.setInvoiceCode(invoice.getInvoiceCode());
            if (!StringUtils.isEmpty((Object)invoice.getBillDate()) && invoice.getBillDate().length() > 10) {
                fscFinancePushSettleInvoiceBO.setInvoiceDate(invoice.getBillDate().substring(0, 10));
            } else {
                fscFinancePushSettleInvoiceBO.setInvoiceDate(invoice.getBillDate());
            }
            fscFinancePushSettleInvoiceBO.setInvoiceHeader(invoice.getBuyName());
            fscFinancePushSettleInvoiceBO.setRmbAmount(invoice.getUntaxAmt());
            fscFinancePushSettleInvoiceBO.setRmbTax(invoice.getTaxAmt());
            fscFinancePushSettleInvoiceBO.setRmbAmountTax(invoice.getAmt());
            fscFinancePushSettleInvoiceBO.setCurrOccAmountTax(invoice.getAmt());
            fscFinancePushSettleInvoiceBO.setCurrOccAmount(invoice.getUntaxAmt());
            fscFinancePushSettleInvoiceBO.setCurrOccTax(invoice.getTaxAmt());
            fscFinancePushSettleInvoiceBO.setIsSimpleTax(invoice.getIsSimpleTax());
            fscFinancePushSettleInvoiceBO.setIsInputOut(invoice.getIsInputOut());
            fscFinancePushSettleInvoiceBO.setInputOutAmt(invoice.getIsInputOutAmt());
            fscFinancePushSettleInvoiceBO.setInputOutTypeCode(invoice.getInputOutTypeCode());
            fscFinancePushSettleInvoiceBO.setInputOutTypeName(invoice.getInputOutTypeName());
            invoiceList.add(fscFinancePushSettleInvoiceBO);
        });
        return invoiceList;
    }

    private void buildSettleItem(List<FscOrderItemPO> fscOrderItemPOList, FscOrderFinancePO financePO, List<FscFinancePushSettleItemBO> settleNodetailList) {
        fscOrderItemPOList.forEach(item -> {
            FscFinancePushSettleItemBO notErpBO = new FscFinancePushSettleItemBO();
            notErpBO.setGuid(String.valueOf(item.getId()));
            notErpBO.setSegCompanyCode(null);
            notErpBO.setSegCompanyName(null);
            notErpBO.setSegProductCode(item.getProductSegmentCode());
            notErpBO.setSegProductName(item.getProductSegmentName());
            notErpBO.setSegProjectCode(item.getProjectCode());
            notErpBO.setSegProjectName(item.getProjectName());
            notErpBO.setSegContractCode(financePO.getContractSegmentCode());
            notErpBO.setSegContractName(financePO.getContractSegmentName());
            notErpBO.setSegMainSubjectCode(null);
            notErpBO.setSegMainSubjectName(null);
            notErpBO.setSegSubSubjectCode(null);
            notErpBO.setSegSubSubjectName(null);
            notErpBO.setSegCorrespondentCode(null);
            notErpBO.setSegCorrespondentName(null);
            notErpBO.setSegCalcCostCode(item.getCostCenterCode());
            notErpBO.setSegCalcCostName(item.getCostCenterName());
            notErpBO.setSegProduceStageCode(item.getProductionLinkCode());
            notErpBO.setSegProduceStageName(item.getProductionLinkName());
            notErpBO.setSegBakCode(null);
            notErpBO.setSegBakName(null);
            notErpBO.setSettleItemCode(item.getSettleItemCode());
            notErpBO.setSettleItemName(item.getSettleItemName());
            notErpBO.setNum(item.getNum());
            notErpBO.setPrice(item.getPrice());
            notErpBO.setUnitPrice(item.getPrice().divide(BigDecimal.ONE.add(item.getTaxRate()), 8, RoundingMode.HALF_UP));
            notErpBO.setUnitTaxPrice(item.getPrice());
            notErpBO.setUnitLocalPrice(notErpBO.getUnitPrice().multiply(financePO.getExchangeRate()));
            notErpBO.setUnitLocalTaxPrice(item.getPrice().multiply(financePO.getExchangeRate()));
            notErpBO.setAllAmt(item.getUntaxAmt());
            notErpBO.setAllTaxAmt(item.getAmt());
            notErpBO.setAllLocalAmt(item.getUntaxAmt().multiply(financePO.getExchangeRate()));
            notErpBO.setAllLocalTaxAmt(item.getAmt().multiply(financePO.getExchangeRate()));
            notErpBO.setTaxRateCode(Objects.nonNull(item.getTaxRate()) ? String.valueOf(item.getTaxRate().setScale(2, RoundingMode.HALF_UP)) : null);
            notErpBO.setTaxRateName(item.getTaxRate().multiply(new BigDecimal(100)).setScale(0, RoundingMode.HALF_UP) + "%");
            notErpBO.setTaxRateVal(null);
            notErpBO.setTaxAmt(item.getTaxAmt());
            notErpBO.setTaxLocalAmt(item.getTaxAmt().multiply(financePO.getExchangeRate()));
            notErpBO.setIsSimpleTax(Objects.isNull(item.getIsSimpleTax()) ? "" : String.valueOf(item.getIsSimpleTax()));
            notErpBO.setIsInputOut(Objects.isNull(item.getIsInputOut()) ? "" : String.valueOf(item.getIsInputOut()));
            notErpBO.setInputOutAmt(item.getIsInputOutAmt());
            notErpBO.setInputOutTypeCode(null);
            notErpBO.setInputOutTypeName(null);
            notErpBO.setProjectCode(null);
            notErpBO.setProjectName(null);
            notErpBO.setTaskCode(null);
            notErpBO.setTaskName(null);
            notErpBO.setUnitCode(null);
            notErpBO.setUnitName(item.getSettleUnit());
            settleNodetailList.add(notErpBO);
        });
    }

    private List<FscFinancePushSettleWriteItemBO> buildWriteOff(List<FscFinanceWriteOffPO> fscFinanceWriteOffPOList) {
        ArrayList<FscFinancePushSettleWriteItemBO> advCheckList = new ArrayList<FscFinancePushSettleWriteItemBO>();
        List payOrderIdList = fscFinanceWriteOffPOList.stream().map(FscFinanceWriteOffPO::getPayOrderId).collect(Collectors.toList());
        FscOrderPO fscOrderPO = new FscOrderPO();
        fscOrderPO.setFscOrderIds(payOrderIdList);
        fscFinanceWriteOffPOList.forEach(e -> {
            FscFinancePushSettleWriteItemBO writeItemBO = new FscFinancePushSettleWriteItemBO();
            writeItemBO.setGuid(String.valueOf(e.getWriteOffId()));
            writeItemBO.setApplyBillGuid(Objects.isNull(e.getPayOrderId()) ? "" : String.valueOf(e.getPayOrderId()));
            writeItemBO.setApplyBillCode(e.getPayOrderNo());
            writeItemBO.setAdvPayAmt(e.getPayAmt());
            writeItemBO.setAdvUncheckAmt(e.getLeaveWriteOffAmount());
            writeItemBO.setAdvUncheckLocalAmt(e.getLeaveWriteOffAmountLocal());
            writeItemBO.setCheckAmt(e.getWriteOffAmt());
            writeItemBO.setAdvPayLocalAmt(e.getPayAmtLocal());
            writeItemBO.setCheckLocalAmt(e.getWriteOffAmtLocal());
            writeItemBO.setWriteOffId(String.valueOf(e.getWriteOffId()));
            advCheckList.add(writeItemBO);
        });
        return advCheckList;
    }

    private List<FscFinancePushSettleQualityItemBO> buildQualityInfo(FscOrderPO orderPO, FscOrderFinancePO financePO, Long contractId) {
        ArrayList<FscFinancePushSettleQualityItemBO> qualityDepositList = new ArrayList<FscFinancePushSettleQualityItemBO>();
        FscOrderRelationPO fscOrderRelationPO = new FscOrderRelationPO();
        fscOrderRelationPO.setFscOrderId(orderPO.getFscOrderId());
        fscOrderRelationPO.setContractId(contractId);
        List qualityList = this.fscOrderRelationMapper.getQualityListByDate(fscOrderRelationPO);
        if (CollectionUtils.isEmpty((Collection)qualityList)) {
            return qualityDepositList;
        }
        qualityList.forEach(e -> {
            FscFinancePushSettleQualityItemBO qualityItemBO = new FscFinancePushSettleQualityItemBO();
            qualityItemBO.setGuid(String.valueOf(e.getId()));
            qualityItemBO.setHeadGuid(String.valueOf(orderPO.getFscOrderId()));
            qualityItemBO.setCreateUser(orderPO.getCreateOperNo());
            qualityItemBO.setCreateUserName(orderPO.getCreateOperName());
            qualityItemBO.setUpdateUser(financePO.getUpdateUserId());
            qualityItemBO.setUpdateUserName(financePO.getUpdateUserName());
            qualityItemBO.setCreateDate(DateUtil.dateToStrLong((Date)orderPO.getCreateTime()));
            qualityItemBO.setUpdateDate(DateUtil.dateToStrLong((Date)financePO.getUpdateTime()));
            qualityItemBO.setDepositAmt(e.getQualityAmt());
            qualityItemBO.setDepositLocalAmt(e.getQualityAmt().multiply(financePO.getExchangeRate()));
            if (!StringUtils.isEmpty((Object)e.getQualityDate())) {
                qualityItemBO.setPanDueDate(DateUtil.dateToStr((Date)e.getQualityDate()));
            }
            qualityDepositList.add(qualityItemBO);
        });
        return qualityDepositList;
    }

    private String getToken() {
        FscFinanceShareTokenRspBO shareToken = this.fscFinanceShareRelatedInterfacesAtomService.getFinanceShareToken();
        if (StringUtils.isEmpty((Object)shareToken.getToken())) {
            throw new FscBusinessException("198888", "\u83b7\u53d6\u8d22\u52a1\u5171\u4eabtoken\u4fe1\u606f\u5931\u8d25\uff1a" + shareToken.getRespDesc());
        }
        return shareToken.getToken();
    }
}

