/*
 * Decompiled with CFR 0.152.
 */
package com.tydic.fsc.bill.atom.impl.finance;

import com.alibaba.fastjson.JSON;
import com.tydic.fsc.bill.ability.api.FscBillAddPushLogAbilityService;
import com.tydic.fsc.bill.ability.bo.FscBillDealPushLogAbilityReqBO;
import com.tydic.fsc.bill.atom.api.finance.FscFinanceBudgetAtomService;
import com.tydic.fsc.bill.atom.bo.finance.FscFinanceBudgetReleaseAtomReqBO;
import com.tydic.fsc.bill.atom.bo.finance.FscFinanceBudgetReleaseAtomRspBO;
import com.tydic.fsc.bill.atom.bo.finance.FscFinanceBudgetUseAtomReqBO;
import com.tydic.fsc.bill.atom.bo.finance.FscFinanceBudgetUseAtomRspBO;
import com.tydic.fsc.common.ability.api.finance.FscFinanceBackBudgetLedgerSaveAbilityService;
import com.tydic.fsc.common.ability.api.finance.FscFinanceSubmitLedgerSaveAbilityService;
import com.tydic.fsc.common.ability.bo.finance.FscFinanceBackBudgetLedgerSaveListReqBO;
import com.tydic.fsc.common.ability.bo.finance.FscFinanceBackBudgetLedgerSaveReqBO;
import com.tydic.fsc.common.ability.bo.finance.FscFinanceBackBudgetLedgerSaveRspBO;
import com.tydic.fsc.common.ability.bo.finance.FscFinanceSubmitLedgerSaveListReqBO;
import com.tydic.fsc.common.ability.bo.finance.FscFinanceSubmitLedgerSaveReqBO;
import com.tydic.fsc.common.ability.bo.finance.FscFinanceSubmitLedgerSaveRspBO;
import com.tydic.fsc.constants.FscConstants;
import com.tydic.fsc.dao.FscOrderFinanceMapper;
import com.tydic.fsc.dao.FscOrderItemMapper;
import com.tydic.fsc.dao.FscOrderMapper;
import com.tydic.fsc.exception.FscBusinessException;
import com.tydic.fsc.po.FscOrderFinancePO;
import com.tydic.fsc.po.FscOrderItemPO;
import com.tydic.fsc.po.FscOrderPO;
import com.tydic.fsc.util.DateUtil;
import java.math.BigDecimal;
import java.util.ArrayList;
import java.util.Collection;
import java.util.Date;
import java.util.List;
import java.util.Map;
import java.util.Objects;
import java.util.function.Function;
import java.util.stream.Collectors;
import javax.annotation.Resource;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;
import org.springframework.beans.factory.annotation.Autowired;
import org.springframework.stereotype.Service;
import org.springframework.util.CollectionUtils;
import org.springframework.util.StringUtils;

@Service
public class FscFinanceBudgetAtomServiceImpl
implements FscFinanceBudgetAtomService {
    private static final Logger log = LoggerFactory.getLogger(FscFinanceBudgetAtomServiceImpl.class);
    private static final String BUSI_BUDGET = "0";
    @Resource
    private FscOrderMapper fscOrderMapper;
    @Resource
    private FscOrderItemMapper fscOrderItemMapper;
    @Resource
    private FscOrderFinanceMapper fscOrderFinanceMapper;
    @Resource
    private FscBillAddPushLogAbilityService fscBillAddPushLogAbilityService;
    @Autowired
    private FscFinanceSubmitLedgerSaveAbilityService fscFinanceSubmitLedgerSaveAbilityService;
    @Autowired
    private FscFinanceBackBudgetLedgerSaveAbilityService fscFinanceBackBudgetLedgerSaveAbilityService;

    @Override
    public FscFinanceBudgetUseAtomRspBO useFinanceBudget(FscFinanceBudgetUseAtomReqBO reqBO) {
        FscFinanceBudgetUseAtomRspBO rspBO = new FscFinanceBudgetUseAtomRspBO();
        rspBO.setRespCode("0000");
        rspBO.setRespDesc("\u6210\u529f");
        FscOrderItemPO fscOrderItemPO = new FscOrderItemPO();
        fscOrderItemPO.setFscOrderId(reqBO.getFscOrderId());
        List budgetList = this.fscOrderItemMapper.getBudgetItemList(fscOrderItemPO);
        List<FscOrderItemPO> changeBudgetList = budgetList.stream().filter(e -> !e.getBudgetItemCode().equals(e.getBudgetItemCodeLast())).collect(Collectors.toList());
        if (CollectionUtils.isEmpty(changeBudgetList)) {
            return rspBO;
        }
        Map budgetLeaveMap = changeBudgetList.stream().collect(Collectors.toMap(FscOrderItemPO::getBudgetItemCode, Function.identity(), (k1, k2) -> k1));
        Map<String, BigDecimal> budgetMap = changeBudgetList.stream().collect(Collectors.groupingBy(FscOrderItemPO::getBudgetItemCode, Collectors.reducing(BigDecimal.ZERO, FscOrderItemPO::getAmt, BigDecimal::add)));
        FscOrderPO fscOrderPOReq = new FscOrderPO();
        fscOrderPOReq.setFscOrderId(reqBO.getFscOrderId());
        FscOrderPO fscOrderPO = this.fscOrderMapper.getModelBy(fscOrderPOReq);
        FscOrderFinancePO financePO = new FscOrderFinancePO();
        financePO.setFscOrderId(reqBO.getFscOrderId());
        FscOrderFinancePO fscOrderFinancePO = this.fscOrderFinanceMapper.getModelBy(financePO);
        if (Objects.isNull(fscOrderPO) || Objects.isNull(fscOrderFinancePO)) {
            throw new FscBusinessException("193011", "\u672a\u67e5\u8be2\u5230\u7ed3\u7b97\u5355\u4fe1\u606f\uff01");
        }
        ArrayList fscFinanceBackBudgetLedgerSaveListReqBOList = new ArrayList();
        changeBudgetList.forEach(item -> {
            if (StringUtils.isEmpty((Object)item.getBudgetItemCodeLast())) {
                return;
            }
            FscFinanceBackBudgetLedgerSaveListReqBO submitLedgerSaveListReqBO = new FscFinanceBackBudgetLedgerSaveListReqBO();
            submitLedgerSaveListReqBO.setBillGuid(String.valueOf(reqBO.getFscOrderId()));
            submitLedgerSaveListReqBO.setBillCode(fscOrderPO.getOrderNo());
            submitLedgerSaveListReqBO.setBudgetType(BUSI_BUDGET);
            submitLedgerSaveListReqBO.setOrgId(fscOrderFinancePO.getFinanceOrgId());
            submitLedgerSaveListReqBO.setSubTypeCode(item.getSettleItemCode());
            submitLedgerSaveListReqBO.setSubTypeName(item.getSettleItemName());
            submitLedgerSaveListReqBO.setBizSmallTypeCode(financePO.getBizTypeCode());
            submitLedgerSaveListReqBO.setBizSmallTypeName(financePO.getBizTypeName());
            submitLedgerSaveListReqBO.setCostCenterCode(item.getCostCenterCode());
            submitLedgerSaveListReqBO.setCostCenterName(item.getCostCenterName());
            submitLedgerSaveListReqBO.setBudgetItemCode(item.getBudgetItemCode());
            submitLedgerSaveListReqBO.setBudgetItemName(item.getBudgetItemName());
            submitLedgerSaveListReqBO.setLocalHoldAmt(item.getBudgetItemAmt());
            submitLedgerSaveListReqBO.setBizDate(DateUtil.dateToStr((Date)fscOrderPO.getCreateTime()));
            submitLedgerSaveListReqBO.setAccountDate(DateUtil.dateToStr((Date)new Date()));
            fscFinanceBackBudgetLedgerSaveListReqBOList.add(submitLedgerSaveListReqBO);
            if (budgetLeaveMap.containsKey(item.getBudgetItemCodeLast())) {
                ((FscOrderItemPO)budgetLeaveMap.get(item.getBudgetItemCodeLast())).setBudgetLeaveAmt(((FscOrderItemPO)budgetLeaveMap.get(item.getBudgetItemCodeLast())).getBudgetLeaveAmt().add(item.getBudgetItemAmt()));
            }
        });
        budgetMap.forEach((key, val) -> {
            if (!budgetLeaveMap.containsKey(key)) {
                throw new FscBusinessException("193011", "\u5360\u7528\u9884\u7b97\u5931\u8d25\uff0c\u8bf7\u8054\u7cfb\u8fd0\u7ef4\u4eba\u5458\uff01");
            }
            if (((FscOrderItemPO)budgetLeaveMap.get(key)).getBudgetLeaveAmt().compareTo((BigDecimal)val) < 0) {
                throw new FscBusinessException("193011", "\u5b58\u5728\u9884\u7b97\u989d\u5ea6\u4e0d\u8db3\uff0c\u8bf7\u6838\u5bf9\u540e\u91cd\u65b0\u63d0\u4ea4\uff0c\u9884\u7b97\u9879\u76ee\u540d\u79f0\uff1a" + ((FscOrderItemPO)budgetLeaveMap.get(key)).getBudgetItemName());
            }
        });
        Integer pushStatus = FscConstants.FscPushStatus.SUCCESS;
        if (!CollectionUtils.isEmpty(fscFinanceBackBudgetLedgerSaveListReqBOList)) {
            FscFinanceBackBudgetLedgerSaveReqBO fscFinanceBackBudgetLedgerSaveReqBO = new FscFinanceBackBudgetLedgerSaveReqBO();
            fscFinanceBackBudgetLedgerSaveReqBO.setBackBudgetLedgerSaveList(fscFinanceBackBudgetLedgerSaveListReqBOList);
            FscFinanceBackBudgetLedgerSaveRspBO fscFinanceBackBudgetLedgerSaveRspBO = this.fscFinanceBackBudgetLedgerSaveAbilityService.saveBackBudgetLedger(fscFinanceBackBudgetLedgerSaveReqBO);
            if (Objects.nonNull(fscFinanceBackBudgetLedgerSaveRspBO) && !"0000".equals(fscFinanceBackBudgetLedgerSaveRspBO.getRespCode())) {
                rspBO.setRespCode("190000");
                rspBO.setRespDesc("\u8d39\u7528\u9884\u7b97\u91ca\u653e\u5f02\u5e38\uff1a" + fscFinanceBackBudgetLedgerSaveRspBO.getRespDesc());
                pushStatus = FscConstants.FscPushStatus.FAIL;
                this.savePushLog(reqBO.getFscOrderId(), FscConstants.FscPurchasePushType.FINANCE_BUDGET_RELEASE, JSON.toJSONString((Object)fscFinanceBackBudgetLedgerSaveReqBO), JSON.toJSONString((Object)fscFinanceBackBudgetLedgerSaveRspBO), pushStatus);
                return rspBO;
            }
            this.savePushLog(reqBO.getFscOrderId(), FscConstants.FscPurchasePushType.FINANCE_BUDGET_RELEASE, JSON.toJSONString((Object)fscFinanceBackBudgetLedgerSaveReqBO), JSON.toJSONString((Object)fscFinanceBackBudgetLedgerSaveRspBO), pushStatus);
        }
        ArrayList submitLedgerSaveListReqBOList = new ArrayList();
        budgetList.forEach(item -> {
            item.setBudgetItemAmt(item.getAmt());
            item.setBudgetItemCodeLast(item.getBudgetItemCode());
            FscFinanceSubmitLedgerSaveListReqBO submitLedgerSaveListReqBO = new FscFinanceSubmitLedgerSaveListReqBO();
            submitLedgerSaveListReqBO.setBillGuid(String.valueOf(reqBO.getFscOrderId()));
            submitLedgerSaveListReqBO.setBillCode(fscOrderPO.getOrderNo());
            submitLedgerSaveListReqBO.setBudgetType(BUSI_BUDGET);
            submitLedgerSaveListReqBO.setOrgId(fscOrderFinancePO.getFinanceOrgId());
            submitLedgerSaveListReqBO.setSubTypeCode(item.getSettleItemCode());
            submitLedgerSaveListReqBO.setSubTypeName(item.getSettleItemName());
            submitLedgerSaveListReqBO.setBizSmallTypeCode(financePO.getBizTypeCode());
            submitLedgerSaveListReqBO.setBizSmallTypeName(financePO.getBizTypeName());
            submitLedgerSaveListReqBO.setCostCenterCode(item.getCostCenterCode());
            submitLedgerSaveListReqBO.setCostCenterName(item.getCostCenterName());
            submitLedgerSaveListReqBO.setBudgetItemCode(item.getBudgetItemCode());
            submitLedgerSaveListReqBO.setBudgetItemName(item.getBudgetItemName());
            submitLedgerSaveListReqBO.setLocalHoldAmt(item.getBudgetItemAmt());
            submitLedgerSaveListReqBO.setBizDate(DateUtil.dateToStr((Date)fscOrderPO.getCreateTime()));
            submitLedgerSaveListReqBO.setAccountDate(DateUtil.dateToStr((Date)new Date()));
            submitLedgerSaveListReqBOList.add(submitLedgerSaveListReqBO);
        });
        this.fscOrderItemMapper.updateBatchByList(budgetList);
        FscFinanceSubmitLedgerSaveReqBO fscFinanceSubmitLedgerSaveReqBO = new FscFinanceSubmitLedgerSaveReqBO();
        fscFinanceSubmitLedgerSaveReqBO.setSubmitLedgerSaveList(submitLedgerSaveListReqBOList);
        FscFinanceSubmitLedgerSaveRspBO fscFinanceSubmitLedgerSaveRspBO = this.fscFinanceSubmitLedgerSaveAbilityService.saveSubmitLedger(fscFinanceSubmitLedgerSaveReqBO);
        if (Objects.nonNull(fscFinanceSubmitLedgerSaveRspBO) && !"0000".equals(fscFinanceSubmitLedgerSaveRspBO.getRespCode())) {
            rspBO.setRespCode("190000");
            rspBO.setRespDesc("\u8d39\u7528\u9884\u7b97\u91ca\u653e\u5f02\u5e38\uff1a" + fscFinanceSubmitLedgerSaveRspBO.getRespDesc());
            pushStatus = FscConstants.FscPushStatus.FAIL;
        }
        this.savePushLog(reqBO.getFscOrderId(), FscConstants.FscPurchasePushType.FINANCE_BUDGET_USE, JSON.toJSONString((Object)fscFinanceSubmitLedgerSaveReqBO), JSON.toJSONString((Object)fscFinanceSubmitLedgerSaveRspBO), pushStatus);
        return rspBO;
    }

    @Override
    public FscFinanceBudgetReleaseAtomRspBO releaseFinanceBudget(FscFinanceBudgetReleaseAtomReqBO reqBO) {
        FscFinanceBudgetReleaseAtomRspBO rspBO = new FscFinanceBudgetReleaseAtomRspBO();
        rspBO.setRespCode("0000");
        rspBO.setRespDesc("\u6210\u529f");
        FscOrderItemPO fscOrderItemPO = new FscOrderItemPO();
        fscOrderItemPO.setFscOrderId(reqBO.getFscOrderId());
        List budgetList = this.fscOrderItemMapper.getBudgetItemList(fscOrderItemPO);
        if (CollectionUtils.isEmpty((Collection)budgetList)) {
            return rspBO;
        }
        FscOrderPO fscOrderPO = new FscOrderPO();
        fscOrderPO.setFscOrderId(reqBO.getFscOrderId());
        fscOrderPO = this.fscOrderMapper.getModelBy(fscOrderPO);
        FscOrderFinancePO financePO = new FscOrderFinancePO();
        financePO.setFscOrderId(reqBO.getFscOrderId());
        FscOrderFinancePO fscOrderFinancePO = this.fscOrderFinanceMapper.getModelBy(financePO);
        if (Objects.isNull(fscOrderPO) || Objects.isNull(fscOrderFinancePO)) {
            throw new FscBusinessException("193011", "\u672a\u67e5\u8be2\u5230\u7ed3\u7b97\u5355\u4fe1\u606f\uff01");
        }
        ArrayList<FscFinanceBackBudgetLedgerSaveListReqBO> fscFinanceBackBudgetLedgerSaveListReqBOList = new ArrayList<FscFinanceBackBudgetLedgerSaveListReqBO>();
        for (FscOrderItemPO item : budgetList) {
            FscFinanceBackBudgetLedgerSaveListReqBO submitLedgerSaveListReqBO = new FscFinanceBackBudgetLedgerSaveListReqBO();
            submitLedgerSaveListReqBO.setBillGuid(String.valueOf(reqBO.getFscOrderId()));
            submitLedgerSaveListReqBO.setBillCode(fscOrderPO.getOrderNo());
            submitLedgerSaveListReqBO.setBudgetType(BUSI_BUDGET);
            submitLedgerSaveListReqBO.setOrgId(fscOrderFinancePO.getFinanceOrgId());
            submitLedgerSaveListReqBO.setSubTypeCode(item.getSettleItemCode());
            submitLedgerSaveListReqBO.setSubTypeName(item.getSettleItemName());
            submitLedgerSaveListReqBO.setBizSmallTypeCode(financePO.getBizTypeCode());
            submitLedgerSaveListReqBO.setBizSmallTypeName(financePO.getBizTypeName());
            submitLedgerSaveListReqBO.setCostCenterCode(item.getCostCenterCode());
            submitLedgerSaveListReqBO.setCostCenterName(item.getCostCenterName());
            submitLedgerSaveListReqBO.setBudgetItemCode(item.getBudgetItemCode());
            submitLedgerSaveListReqBO.setBudgetItemName(item.getBudgetItemName());
            submitLedgerSaveListReqBO.setLocalHoldAmt(item.getBudgetItemAmt());
            submitLedgerSaveListReqBO.setBizDate(DateUtil.dateToStr((Date)fscOrderPO.getCreateTime()));
            submitLedgerSaveListReqBO.setAccountDate(DateUtil.dateToStr((Date)new Date()));
            fscFinanceBackBudgetLedgerSaveListReqBOList.add(submitLedgerSaveListReqBO);
        }
        Integer pushStatus = FscConstants.FscPushStatus.SUCCESS;
        FscFinanceBackBudgetLedgerSaveReqBO fscFinanceBackBudgetLedgerSaveReqBO = new FscFinanceBackBudgetLedgerSaveReqBO();
        fscFinanceBackBudgetLedgerSaveReqBO.setBackBudgetLedgerSaveList(fscFinanceBackBudgetLedgerSaveListReqBOList);
        FscFinanceBackBudgetLedgerSaveRspBO fscFinanceBackBudgetLedgerSaveRspBO = this.fscFinanceBackBudgetLedgerSaveAbilityService.saveBackBudgetLedger(fscFinanceBackBudgetLedgerSaveReqBO);
        if (Objects.nonNull(fscFinanceBackBudgetLedgerSaveRspBO) && !"0000".equals(fscFinanceBackBudgetLedgerSaveRspBO.getRespCode())) {
            rspBO.setRespCode("190000");
            rspBO.setRespDesc("\u8d39\u7528\u9884\u7b97\u91ca\u653e\u5f02\u5e38\uff1a" + fscFinanceBackBudgetLedgerSaveRspBO.getRespDesc());
            pushStatus = FscConstants.FscPushStatus.FAIL;
        }
        this.savePushLog(reqBO.getFscOrderId(), FscConstants.FscPurchasePushType.FINANCE_BUDGET_RELEASE, JSON.toJSONString((Object)fscFinanceBackBudgetLedgerSaveReqBO), JSON.toJSONString((Object)fscFinanceBackBudgetLedgerSaveRspBO), pushStatus);
        return rspBO;
    }

    private void savePushLog(Long fscOrderId, Integer pushType, String pushData, String respData, Integer pushStatus) {
        FscBillDealPushLogAbilityReqBO abilityReqBO = new FscBillDealPushLogAbilityReqBO();
        abilityReqBO.setCreateTime(new Date());
        abilityReqBO.setType(pushType);
        abilityReqBO.setObjectId(fscOrderId);
        abilityReqBO.setPushData(pushData);
        abilityReqBO.setPushStatus(pushStatus);
        abilityReqBO.setRespData(respData);
        this.fscBillAddPushLogAbilityService.savePurchasePushLog(abilityReqBO);
    }
}

