/*
 * Decompiled with CFR 0.152.
 */
package com.tydic.fsc.bill.busi.impl;

import cn.hutool.core.bean.BeanUtil;
import com.alibaba.fastjson.JSON;
import com.ohaotian.plugin.db.Sequence;
import com.tydic.dyc.base.utils.JUtil;
import com.tydic.fsc.bill.ability.bo.FscAddFinanceWriteOffReqBoDetails;
import com.tydic.fsc.bill.busi.api.FscAddFinanceWriteOffBusiService;
import com.tydic.fsc.bill.busi.bo.FscAddFinanceWriteOffBusiReqBo;
import com.tydic.fsc.bill.busi.bo.finance.FscAddFinanceWriteOffBusiRspBo;
import com.tydic.fsc.constants.FscConstants;
import com.tydic.fsc.dao.FscFinanceWriteOffAdjustDetailMapper;
import com.tydic.fsc.dao.FscFinanceWriteOffAdjustMapper;
import com.tydic.fsc.dao.FscOrderMapper;
import com.tydic.fsc.dao.FscOrderPayItemMapper;
import com.tydic.fsc.exception.FscBusinessException;
import com.tydic.fsc.po.FscFinanceWriteOffAdjustDetailPO;
import com.tydic.fsc.po.FscFinanceWriteOffAdjustPO;
import com.tydic.fsc.po.FscOrderPO;
import com.tydic.fsc.po.FscOrderPayItemPO;
import com.tydic.uac.ability.UacNoTaskAuditCreateAbilityService;
import com.tydic.uac.ability.bo.UacNoTaskAuditCreateInfoReqBO;
import com.tydic.uac.ability.bo.UacNoTaskAuditCreateReqBO;
import com.tydic.uac.ability.bo.UacNoTaskAuditCreateRspBO;
import com.tydic.uac.bo.common.ApprovalObjBO;
import java.math.BigDecimal;
import java.util.ArrayList;
import java.util.Date;
import java.util.List;
import org.apache.commons.lang3.StringUtils;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;
import org.springframework.beans.factory.annotation.Autowired;
import org.springframework.stereotype.Service;

@Service
public class FscAddFinanceWriteOffBusiServiceImpl
implements FscAddFinanceWriteOffBusiService {
    private static final Logger log = LoggerFactory.getLogger(FscAddFinanceWriteOffBusiServiceImpl.class);
    @Autowired
    private FscFinanceWriteOffAdjustMapper fscFinanceWriteOffAdjustMapper;
    @Autowired
    private FscFinanceWriteOffAdjustDetailMapper fscFinanceWriteOffAdjustDetailMapper;
    @Autowired
    private FscOrderPayItemMapper fscOrderPayItemMapper;
    @Autowired
    private FscOrderMapper fscOrderMapper;
    @Autowired
    private UacNoTaskAuditCreateAbilityService uacNoTaskAuditCreateAbilityService;

    @Override
    public FscAddFinanceWriteOffBusiRspBo dealFinanceWriteOff(FscAddFinanceWriteOffBusiReqBo reqBo) {
        FscFinanceWriteOffAdjustPO newAdjustPO;
        Long adjustId;
        List orderIds = this.fscOrderMapper.selectOrderIds(reqBo.getFscOrderId(), null);
        FscOrderPO orderPO = new FscOrderPO();
        orderPO.setOrderIds(orderIds);
        FscOrderPO fscOrderPO = this.fscOrderMapper.qryPurPrePay(orderPO);
        if (null == fscOrderPO) {
            throw new FscBusinessException("190000", "\u67e5\u8be2\u7ed3\u7b97\u5355\u9884\u4ed8\u6838\u9500\u4fe1\u606f\u5f02\u5e38");
        }
        reqBo.setPaidAmount(fscOrderPO.getPaidAmount());
        reqBo.setPaidWriteOffAmount(fscOrderPO.getPurWriteOffAmount());
        reqBo.setRemainWriteOffAmount(fscOrderPO.getPaidAmount().subtract(fscOrderPO.getPurWriteOffAmount()));
        if (null != reqBo.getAdjustId()) {
            FscFinanceWriteOffAdjustPO adjustPo = new FscFinanceWriteOffAdjustPO();
            adjustPo.setAdjustId(reqBo.getAdjustId());
            FscFinanceWriteOffAdjustPO oldAdjustPO = this.fscFinanceWriteOffAdjustMapper.getModelBy(adjustPo);
            if (oldAdjustPO == null) {
                throw new FscBusinessException("190000", "\u672a\u627e\u5230\u5bf9\u5e94\u6838\u9500\u5355,adjustId:" + reqBo.getAdjustId());
            }
            if (!FscConstants.WriteOffBillStatus.AUDIT_FAIL.equals(oldAdjustPO.getBillStatus())) {
                throw new FscBusinessException("190000", "\u5f53\u524d\u6838\u9500\u5355\u72b6\u6001\u4e0d\u5141\u8bb8\u4fee\u6539,billStatus:" + oldAdjustPO.getBillStatus());
            }
            adjustId = reqBo.getAdjustId();
            this.dealAmount(oldAdjustPO);
            this.valCancel(reqBo);
            BeanUtil.copyProperties((Object)((Object)reqBo), (Object)oldAdjustPO, (String[])new String[]{"note"});
            oldAdjustPO.setUpdateTime(new Date());
            if (StringUtils.isNotEmpty((CharSequence)reqBo.getNote())) {
                oldAdjustPO.setNote(reqBo.getNote());
            }
            oldAdjustPO.setUpdateUserId(reqBo.getUserId());
            oldAdjustPO.setUpdateUserAccount(reqBo.getUserName());
            oldAdjustPO.setUpdateUserName(reqBo.getName());
            oldAdjustPO.setBillStatus(FscConstants.WriteOffBillStatus.TO_AUDIT);
            FscFinanceWriteOffAdjustPO where = new FscFinanceWriteOffAdjustPO();
            where.setAdjustId(oldAdjustPO.getAdjustId());
            this.fscFinanceWriteOffAdjustMapper.updateBy(oldAdjustPO, where);
            newAdjustPO = oldAdjustPO;
            FscFinanceWriteOffAdjustDetailPO detailPO = new FscFinanceWriteOffAdjustDetailPO();
            detailPO.setAdjustId(adjustId);
            this.fscFinanceWriteOffAdjustDetailMapper.deleteBy(detailPO);
        } else {
            this.valCancel(reqBo);
            adjustId = Sequence.getInstance().nextId();
            FscFinanceWriteOffAdjustPO fscFinanceWriteOffAdjustPo = new FscFinanceWriteOffAdjustPO();
            BeanUtil.copyProperties((Object)((Object)reqBo), (Object)fscFinanceWriteOffAdjustPo);
            fscFinanceWriteOffAdjustPo.setAdjustId(adjustId);
            fscFinanceWriteOffAdjustPo.setCreateTime(new Date());
            fscFinanceWriteOffAdjustPo.setCreateUserId(reqBo.getUserId());
            fscFinanceWriteOffAdjustPo.setCreateUserAccount(reqBo.getUserName());
            fscFinanceWriteOffAdjustPo.setCreateUserName(reqBo.getName());
            fscFinanceWriteOffAdjustPo.setBillStatus(FscConstants.WriteOffBillStatus.TO_AUDIT);
            int num = this.fscFinanceWriteOffAdjustMapper.insert(fscFinanceWriteOffAdjustPo);
            newAdjustPO = fscFinanceWriteOffAdjustPo;
            if (num <= 0) {
                throw new FscBusinessException("190000", "\u7ed3\u7b97\u6838\u9500\u8865\u5f55\u6570\u636e\u5165\u5e93\u5f02\u5e38");
            }
        }
        this.invokeUacTask(reqBo, adjustId);
        ArrayList<FscFinanceWriteOffAdjustDetailPO> list = new ArrayList<FscFinanceWriteOffAdjustDetailPO>();
        for (FscAddFinanceWriteOffReqBoDetails detail : reqBo.getDetails()) {
            if (FscConstants.FinanceWriteOffType.CANCELED.equals(reqBo.getBillType()) && detail.getWriteOffAmt().multiply(detail.getExchangeRate()).compareTo(detail.getPaidWriteOffAmount()) > 0) {
                throw new FscBusinessException("190000", "\u64a4\u9500\u6838\u9500\u91d1\u989d\u4e0d\u80fd\u5927\u4e8e\u5df2\u6838\u9500\u91d1\u989d,paidWriteOffAmount:" + detail.getPaidWriteOffAmount());
            }
            FscFinanceWriteOffAdjustDetailPO adjustDetailPO = (FscFinanceWriteOffAdjustDetailPO)JUtil.js((Object)detail, FscFinanceWriteOffAdjustDetailPO.class);
            adjustDetailPO.setAdjustId(adjustId);
            adjustDetailPO.setAdjustDetailId(Long.valueOf(Sequence.getInstance().nextId()));
            adjustDetailPO.setFscOrderId(reqBo.getFscOrderId());
            adjustDetailPO.setCreateTime(new Date());
            list.add(adjustDetailPO);
        }
        this.fscFinanceWriteOffAdjustDetailMapper.insertBatch(list);
        newAdjustPO.setBillType(FscConstants.FinanceWriteOffType.ADD.equals(newAdjustPO.getBillType()) ? FscConstants.FinanceWriteOffType.CANCELED : FscConstants.FinanceWriteOffType.ADD);
        this.dealAmount(newAdjustPO);
        FscAddFinanceWriteOffBusiRspBo rspBo = new FscAddFinanceWriteOffBusiRspBo();
        rspBo.setRespCode("0000");
        rspBo.setRespDesc("\u6210\u529f");
        return rspBo;
    }

    private void valCancel(FscAddFinanceWriteOffBusiReqBo reqBo) {
        Integer num1;
        if (FscConstants.FinanceWriteOffType.CANCELED.equals(reqBo.getBillType()) && null != reqBo.getCancelAdjustId() && (num1 = this.fscFinanceWriteOffAdjustMapper.sumCancelAmountByAdjustId(reqBo.getCancelAdjustId(), reqBo.getWriteOffAmt())) > 0) {
            throw new FscBusinessException("190000", "\u8be5\u6838\u9500\u5355\u4e0d\u652f\u6301\u64a4\u9500\u6838\u9500\u64cd\u4f5c,adjustId:" + reqBo.getCancelAdjustId());
        }
    }

    private void invokeUacTask(FscAddFinanceWriteOffBusiReqBo reqBO, Long adjustId) {
        UacNoTaskAuditCreateReqBO auditCreateReqBO = new UacNoTaskAuditCreateReqBO();
        auditCreateReqBO.setCreateOperId(reqBO.getUserId().toString());
        auditCreateReqBO.setCreateOperName(reqBO.getName());
        auditCreateReqBO.setCreateOperDept(reqBO.getOrgName());
        auditCreateReqBO.setIsSaveCreateLog(Boolean.valueOf(true));
        ArrayList<UacNoTaskAuditCreateInfoReqBO> createBusiReqBO = new ArrayList<UacNoTaskAuditCreateInfoReqBO>();
        UacNoTaskAuditCreateInfoReqBO uacNoTaskAuditCreateInfoReqBO = new UacNoTaskAuditCreateInfoReqBO();
        ApprovalObjBO approvalObjBO = new ApprovalObjBO();
        if (FscConstants.FinanceWriteOffType.CANCELED.equals(reqBO.getBillType())) {
            auditCreateReqBO.setMenuId("M001042");
            uacNoTaskAuditCreateInfoReqBO.setObjType(FscConstants.AuditObjType.FINANCE_WRITEOFF_CANCEL);
            approvalObjBO.setObjType(FscConstants.AuditObjType.FINANCE_WRITEOFF_CANCEL);
            approvalObjBO.setObjName("\u7ed3\u7b97\u64a4\u9500\u6838\u9500\u5ba1\u6279");
        } else if (FscConstants.FinanceWriteOffType.ADD.equals(reqBO.getBillType())) {
            auditCreateReqBO.setMenuId("M001041");
            uacNoTaskAuditCreateInfoReqBO.setObjType(FscConstants.AuditObjType.FINANCE_WRITEOFF);
            approvalObjBO.setObjType(FscConstants.AuditObjType.FINANCE_WRITEOFF);
            approvalObjBO.setObjName("\u7ed3\u7b97\u8865\u6838\u9500\u5ba1\u6279");
        }
        auditCreateReqBO.setOrgId(String.valueOf(reqBO.getOrgId()));
        uacNoTaskAuditCreateInfoReqBO.setObjNum("1");
        uacNoTaskAuditCreateInfoReqBO.setOrderId(adjustId);
        ArrayList<ApprovalObjBO> approvalObjBOList = new ArrayList<ApprovalObjBO>();
        approvalObjBO.setObjId(adjustId.toString());
        approvalObjBOList.add(approvalObjBO);
        uacNoTaskAuditCreateInfoReqBO.setApprovalObjInfo(approvalObjBOList);
        createBusiReqBO.add(uacNoTaskAuditCreateInfoReqBO);
        auditCreateReqBO.setCreateBusiReqBO(createBusiReqBO);
        this.checkExistProcess(adjustId, approvalObjBO.getObjType());
        log.info("\u5ba1\u6279\u5165\u53c2================" + JSON.toJSONString((Object)auditCreateReqBO));
        UacNoTaskAuditCreateRspBO uacNoTaskAuditCreateRspBO = this.uacNoTaskAuditCreateAbilityService.auditOrderCreate(auditCreateReqBO);
        log.info("\u5ba1\u6279\u51fa\u53c2================" + JSON.toJSONString((Object)uacNoTaskAuditCreateRspBO));
        if (!"0000".equals(uacNoTaskAuditCreateRspBO.getRespCode())) {
            throw new FscBusinessException("190000", uacNoTaskAuditCreateRspBO.getRespDesc());
        }
        if (uacNoTaskAuditCreateRspBO.getNotFindFlag().booleanValue()) {
            throw new FscBusinessException("190000", "\u8bf7\u8054\u7cfb\u7ba1\u7406\u5458\u914d\u7f6e\u7ed3\u7b97\u6838\u9500\u5ba1\u6279\u6d41\uff01");
        }
    }

    private void checkExistProcess(Long adjustId, Integer objType) {
        int count = this.fscOrderMapper.selectStepIdCount(adjustId, objType);
        if (count > 0) {
            throw new FscBusinessException("190000", "\u8be5\u5355\u636e\u5df2\u63d0\u4ea4\u5ba1\u6279");
        }
    }

    public void dealAmount(FscFinanceWriteOffAdjustPO adjustPO) {
        FscFinanceWriteOffAdjustDetailPO adjustDetailPO = new FscFinanceWriteOffAdjustDetailPO();
        adjustDetailPO.setAdjustId(adjustPO.getAdjustId());
        List list = this.fscFinanceWriteOffAdjustDetailMapper.getList(adjustDetailPO);
        for (FscFinanceWriteOffAdjustDetailPO detailPO : list) {
            FscOrderPayItemPO fscOrderPayItemPO = new FscOrderPayItemPO();
            fscOrderPayItemPO.setOrderPayItemId(detailPO.getOrderPayDetailId());
            BigDecimal writeOffAmt = FscConstants.FinanceWriteOffType.ADD.equals(adjustPO.getBillType()) ? detailPO.getWriteOffAmt().negate() : detailPO.getWriteOffAmt();
            fscOrderPayItemPO.setPurWriteOffAmount(writeOffAmt);
            int num = this.fscOrderPayItemMapper.updatePurWriteOffAmountAdd(fscOrderPayItemPO);
            if (num >= 1) continue;
            throw new FscBusinessException("190000", "\u66f4\u65b0\u4ed8\u6b3e\u660e\u7ec6\u5355\u6838\u9500\u91d1\u989d\u5f02\u5e38,writeOffAmt:" + writeOffAmt);
        }
        BigDecimal writeOffAmt = FscConstants.FinanceWriteOffType.ADD.equals(adjustPO.getBillType()) ? adjustPO.getWriteOffAmt().negate() : adjustPO.getWriteOffAmt();
        FscOrderPO fscOrderPo = new FscOrderPO();
        fscOrderPo.setFscOrderId(adjustPO.getFscOrderId());
        fscOrderPo.setPurWriteOffAmount(writeOffAmt);
        int num = this.fscOrderMapper.updatePurWriteOffAmountAdd(fscOrderPo);
        if (num < 1) {
            throw new FscBusinessException("190000", "\u66f4\u65b0\u4e3b\u5355\u6838\u9500\u91d1\u989d\u5f02\u5e38,writeOffAmt:" + writeOffAmt);
        }
    }
}

