/*
 * Decompiled with CFR 0.152.
 */
package com.tydic.fsc.bill.busi.impl;

import com.ohaotian.plugin.db.Sequence;
import com.tydic.fsc.bill.busi.api.FscBillPayRefundRegisterBusiService;
import com.tydic.fsc.bill.busi.bo.FscBillPayRefundRegisterBusiReqBO;
import com.tydic.fsc.bill.busi.bo.FscBillPayRefundRegisterBusiRspBO;
import com.tydic.fsc.bo.AttachmentBO;
import com.tydic.fsc.bo.FscPayRefundDetailBO;
import com.tydic.fsc.busibase.atom.api.FscOrderStatusFlowAtomService;
import com.tydic.fsc.busibase.atom.bo.FscOrderStatusFlowAtomReqBO;
import com.tydic.fsc.busibase.atom.bo.FscOrderStatusFlowAtomRspBO;
import com.tydic.fsc.constants.FscConstants;
import com.tydic.fsc.dao.FscAttachmentMapper;
import com.tydic.fsc.dao.FscOrderRefundMapper;
import com.tydic.fsc.dao.FscPayRefundDetailMapper;
import com.tydic.fsc.exception.FscBusinessException;
import com.tydic.fsc.po.FscAttachmentPO;
import com.tydic.fsc.po.FscOrderRefundPO;
import com.tydic.fsc.po.FscPayRefundDetailPO;
import java.util.ArrayList;
import java.util.HashMap;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;
import org.springframework.beans.BeanUtils;
import org.springframework.beans.factory.annotation.Autowired;
import org.springframework.stereotype.Service;
import org.springframework.util.CollectionUtils;

@Service
public class FscBillPayRefundRegisterBusiServiceImpl
implements FscBillPayRefundRegisterBusiService {
    private static final Logger log = LoggerFactory.getLogger(FscBillPayRefundRegisterBusiServiceImpl.class);
    @Autowired
    private FscOrderRefundMapper fscOrderRefundMapper;
    @Autowired
    private FscPayRefundDetailMapper fscPayRefundDetailMapper;
    @Autowired
    private FscOrderStatusFlowAtomService fscOrderStatusFlowAtomService;
    private static final String BUSI_NAME = "\u9000\u6b3e\u767b\u8bb0";
    @Autowired
    private FscAttachmentMapper fscAttachmentMapper;

    @Override
    public FscBillPayRefundRegisterBusiRspBO dealPayRefundRegister(FscBillPayRefundRegisterBusiReqBO reqBO) {
        FscBillPayRefundRegisterBusiRspBO rspBO = new FscBillPayRefundRegisterBusiRspBO();
        ArrayList<FscPayRefundDetailPO> refundDetailPOList = new ArrayList<FscPayRefundDetailPO>();
        boolean isFinish = false;
        for (FscPayRefundDetailBO bo : reqBO.getFscRefundShouldPayBOS()) {
            FscPayRefundDetailPO fscPayRefundDetailPO = new FscPayRefundDetailPO();
            fscPayRefundDetailPO.setRefundDetailId(bo.getRefundDetailId());
            fscPayRefundDetailPO.setRegisterAmt(bo.getRegisterAmt());
            if (bo.getRegisterAmt().compareTo(bo.getRefundAmt()) == 0) {
                isFinish = true;
            }
            refundDetailPOList.add(fscPayRefundDetailPO);
        }
        int count = this.fscPayRefundDetailMapper.updateRegisterAmtBatch(refundDetailPOList);
        if (count != refundDetailPOList.size()) {
            throw new FscBusinessException("190000", "\u66f4\u65b0\u9000\u6b3e\u8be6\u60c5\u767b\u8bb0\u91d1\u989d\u5931\u8d25");
        }
        FscOrderRefundPO refundPO = this.fscOrderRefundMapper.queryById(reqBO.getRefundId());
        FscAttachmentPO fscAttachmentPO = new FscAttachmentPO();
        fscAttachmentPO.setObjId(reqBO.getRefundId());
        fscAttachmentPO.setObjType(FscConstants.AttachmentObjType.REFUND_PAY_CREDENTIALS);
        fscAttachmentPO.setAttachmentType(FscConstants.AttachmentType.REFUND_PAY);
        this.fscAttachmentMapper.deleteBy(fscAttachmentPO);
        if (!CollectionUtils.isEmpty(reqBO.getFileList())) {
            ArrayList<FscAttachmentPO> attachmentList = new ArrayList<FscAttachmentPO>();
            for (AttachmentBO attachmentBO : reqBO.getFileList()) {
                FscAttachmentPO attachmentPO = new FscAttachmentPO();
                BeanUtils.copyProperties((Object)attachmentBO, (Object)attachmentPO);
                attachmentPO.setFscOrderId(refundPO.getRefundId());
                attachmentPO.setAttachmentId(Long.valueOf(Sequence.getInstance().nextId()));
                attachmentPO.setObjId(refundPO.getRefundId());
                attachmentPO.setObjType(FscConstants.AttachmentObjType.REFUND_PAY_CREDENTIALS);
                attachmentPO.setAttachmentType(FscConstants.AttachmentType.REFUND_PAY_CREDENTIALS);
                attachmentPO.setFormatType(attachmentBO.getFormatType());
                attachmentPO.setFileSize(attachmentBO.getFileSize());
                attachmentList.add(attachmentPO);
            }
            this.fscAttachmentMapper.insertBatch(attachmentList);
        }
        FscPayRefundDetailPO fscPayRefundDetailPO = (FscPayRefundDetailPO)this.fscPayRefundDetailMapper.queryByRefundId(reqBO.getRefundId()).get(0);
        if (isFinish) {
            refundPO.setBillStatus(FscConstants.RefundBillStatus.PAIED);
            refundPO.setRefundReasonType(reqBO.getRefundReasonType());
            this.fscOrderRefundMapper.updateById(refundPO);
            FscOrderStatusFlowAtomReqBO fscOrderStatusFlowAtomReqBO = new FscOrderStatusFlowAtomReqBO();
            fscOrderStatusFlowAtomReqBO.setBusiName(BUSI_NAME);
            fscOrderStatusFlowAtomReqBO.setOrderId(refundPO.getRefundId());
            fscOrderStatusFlowAtomReqBO.setCurStatus(refundPO.getRefundStatus());
            HashMap<String, Integer> paramMap = new HashMap<String, Integer>();
            paramMap.put("registerFlag", FscConstants.BillRegisterFlag.REGISTER);
            fscOrderStatusFlowAtomReqBO.setParamMap(paramMap);
            FscOrderStatusFlowAtomRspBO fscOrderStatusFlowAtomRspBO = this.fscOrderStatusFlowAtomService.dealRefundStatusFlow(fscOrderStatusFlowAtomReqBO);
            if (!fscOrderStatusFlowAtomRspBO.getRespCode().equals("0000")) {
                throw new FscBusinessException(fscOrderStatusFlowAtomRspBO.getRespCode(), fscOrderStatusFlowAtomRspBO.getRespDesc());
            }
        }
        rspBO.setRespCode("0000");
        rspBO.setRespDesc("\u6210\u529f");
        return rspBO;
    }
}

